/* Process model C form file: wlan_txrx_channel.pr.c */
/* Portions of this file copyright 1992-2003 by OPNET Technologies, Inc. */



/* This variable carries the header into the object file */
const char wlan_txrx_channel_pr_c [] = "MIL_3_Tfile_Hdr_ 100A 30A modeler 7 437F7CC6 437F7CC6 1 P614876 nchevrol 0 0 none none 0 0 none 0 0 0 0 0 0 0 0 8f3 1                                                                                                                                                                                                                                                                                                                                                                                                          ";
#include <string.h>



/* OPNET system definitions */
#include <opnet.h>



/* Header Block */

/* include support */
#include "lr_wpan_support.h"
#include "wlan_support.h"
#include "lr_wpan_stat_write.h"
#include <math.h>

/* define some codes */
typedef enum {
	WlanT_Next_State,
	WlanT_Ready_To_Send,
	WlanT_Idle_Power
} WlanT_Intrpt_Code;

/* condition definitions */
#define PKT_ARRIVAL (intrpt_type == OPC_INTRPT_STRM)
#define UPDATE_FLAG (intrpt_type == OPC_INTRPT_REMOTE)
#define IDLE_POWER (intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanT_Idle_Power)
#define READY_TO_SEND (intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanT_Ready_To_Send)

/* debug */
#define POWER_DEBUG (op_prg_odb_ltrace_active("power") == OPC_TRUE)
#define		INTRPT_STATUS_DEBUG	(op_prg_odb_ltrace_active("intrpt_status") == OPC_TRUE)
/*********/

/* default power */
#define WLAN_DEFAULT_POWER	0.001

/* Create a structure for the statistics to collect */
typedef struct {
	int Pkt_Recv;
	int Pkt_Sent;
	int Pkt_Lost;
	double Delay;
} Wlan_Stat_Vector;

/* function prototype */
static void wlan_txrx_chan_error (const char * fcnt, const char * msg, const char * opt);
static void wlan_txrx_channel_register_packet (void);
static void wlan_txrx_channel_send_packet (void);
static void wlan_txrx_channel_rcv_packet (void);
static void wlan_rcv_wpan_packet (void);
static void wlan_txrx_channel_register (void);
static void wlan_txrx_flags (void);
static void wlan_collect_stat (void);
static void wlan_send_fake_packet(double packet_size);

/* End of Header Block */


#if !defined (VOSD_NO_FIN)
#undef	BIN
#undef	BOUT
#define	BIN		FIN_LOCAL_FIELD(_op_last_line_passed) = __LINE__ - _op_block_origin;
#define	BOUT	BIN
#define	BINIT	FIN_LOCAL_FIELD(_op_last_line_passed) = 0; _op_block_origin = __LINE__;
#else
#define	BINIT
#endif /* #if !defined (VOSD_NO_FIN) */



/* State variable definitions */
typedef struct
	{
	/* Internal state tracking for FSM */
	FSM_SYS_STATE
	/* State Variables */
	Objid	                  		my_objid;
	Boolean	                		rx_enable;
	int	                    		intrpt_type;
	int	                    		intrpt_stream;
	int	                    		intrpt_code;
	Objid	                  		parent_objid;
	char *	                 		node_name;
	double	                 		x_position;
	double	                 		y_position;
	Stathandle	             		busy_stat_handle;
	Stathandle	             		power_stat_handle;
	double	                 		wlan_frequency_center;
	Wlan_Stat_Vector	       		statistic;
	double	                 		tx_time_to_send;
	List *	                 		tx_pkt_subqueue;
	int	                    		own_mac_address;
	double	                 		tx_power;
	double	                 		delta_x;
	double	                 		delta_y;
	} wlan_txrx_channel_state;

#define pr_state_ptr            		((wlan_txrx_channel_state*) (OP_SIM_CONTEXT_PTR->mod_state_ptr))
#define my_objid                		pr_state_ptr->my_objid
#define rx_enable               		pr_state_ptr->rx_enable
#define intrpt_type             		pr_state_ptr->intrpt_type
#define intrpt_stream           		pr_state_ptr->intrpt_stream
#define intrpt_code             		pr_state_ptr->intrpt_code
#define parent_objid            		pr_state_ptr->parent_objid
#define node_name               		pr_state_ptr->node_name
#define x_position              		pr_state_ptr->x_position
#define y_position              		pr_state_ptr->y_position
#define busy_stat_handle        		pr_state_ptr->busy_stat_handle
#define power_stat_handle       		pr_state_ptr->power_stat_handle
#define wlan_frequency_center   		pr_state_ptr->wlan_frequency_center
#define statistic               		pr_state_ptr->statistic
#define tx_time_to_send         		pr_state_ptr->tx_time_to_send
#define tx_pkt_subqueue         		pr_state_ptr->tx_pkt_subqueue
#define own_mac_address         		pr_state_ptr->own_mac_address
#define tx_power                		pr_state_ptr->tx_power
#define delta_x                 		pr_state_ptr->delta_x
#define delta_y                 		pr_state_ptr->delta_y

/* These macro definitions will define a local variable called	*/
/* "op_sv_ptr" in each function containing a FIN statement.	*/
/* This variable points to the state variable data structure,	*/
/* and can be used from a C debugger to display their values.	*/
#undef FIN_PREAMBLE_DEC
#undef FIN_PREAMBLE_CODE
#if defined (OPD_PARALLEL)
#  define FIN_PREAMBLE_DEC	wlan_txrx_channel_state *op_sv_ptr; OpT_Sim_Context * tcontext_ptr;
#  define FIN_PREAMBLE_CODE	\
		if (VosS_Mt_Perform_Lock) \
			VOS_THREAD_SPECIFIC_DATA_GET (VosI_Globals.simi_mt_context_data_key, tcontext_ptr, SimT_Context *); \
		else \
			tcontext_ptr = VosI_Globals.simi_sequential_context_ptr; \
		op_sv_ptr = ((wlan_txrx_channel_state *)(tcontext_ptr->mod_state_ptr));
#else
#  define FIN_PREAMBLE_DEC	wlan_txrx_channel_state *op_sv_ptr;
#  define FIN_PREAMBLE_CODE	op_sv_ptr = pr_state_ptr;
#endif


/* Function Block */


#if !defined (VOSD_NO_FIN)
enum { _op_block_origin = __LINE__ };
#endif
/*
 * Function:	wlan_txrx_chan_error
 *
 * Descritpion: print error message and end the simulation
 *
 * ParamIn:		const char * fcnt
 *				name of the function
 *
 *				const char * msg
 *				error message to print
 *
 *				const char * opt
 *				optional error message to print
 *
 */

static void 
wlan_txrx_chan_error (const char * fcnt, const char * msg, const char * opt)
{
	FIN (wlan_txrx_chan_error (fcnt, msg, opt));
	
	/* print error message and end the simulation */
	op_sim_end ("WLAN txrx interface:", fcnt, msg, opt);
	
	FOUT;
}


/*
 * Function:	wlan_txrx_channel_register_packet
 *
 * Description:	register a higher layer packet to a queue
 *				before being sent by the physical layer.
 *				A queue is made to be consistent in a case of
 *				problem in the MAC layer transmission. This 
 *				prevent to send 2 packet without enough time
 *				between them.
 *
 * No Parameters
 */

static void
wlan_txrx_channel_register_packet (void)
{
	Packet *	pkptr;
	char format[32];
	WlanT_Data_Header_Fields * header_data;
	WlanT_Control_Header_Fields * header_ctrl;
	int dest_address, pos_index;
	Wpan_Node_Param * element;
	double txrx_distance;
	Ici * iciptr;
	double bit_rate;
	double time_to_send = op_sim_time ();
		
	
	FIN (wlan_txrx_channel_register_packet ());
	
	/* get the packet */
	pkptr = op_pk_get (intrpt_stream);
	
	/* get the format of the packet */
	op_pk_format (pkptr, format);
			
	/* get the destination address */
	if (strcmp (format, "wlan_mac"))
		{
		/* access the header of the packet */
		op_pk_nfd_access (pkptr, "Wlan Header", &header_data);
		
		/* get the destination address from the packet's header */
		dest_address = header_data->address1;
		}
	else if (strcmp (format, "wlan_control"))
		{
		/* access the header of the packet */
		op_pk_nfd_access (pkptr, "Wlan Header", &header_ctrl);
		
		/* get the destination address from the packet's header */
		dest_address = header_ctrl->rx_addr;
		}
	
	/* get the bit rate of the packet */
	op_pk_nfd_access (pkptr, "Tx Data Rate", &bit_rate);
	
	/* search the information about the destination node */
	pos_index = wpan_search_mac_address (dest_address);
	
	/* get the informations */
	element = op_prg_list_access (wpan_node_param_list, pos_index);
	
	/* compute the distance between the RX and TX */
	txrx_distance = sqrt ((x_position - element->x)*(x_position - element->x) + (y_position - element->y)*(y_position - element->y));
	
	/* create an ICI pointer */
	iciptr = op_ici_create ("ici_channel");
	
	/* complete the ICI */
	if (op_ici_attr_set_dbl (iciptr, "txrx distance", txrx_distance) == OPC_COMPCODE_FAILURE ||
		op_ici_attr_set_dbl (iciptr, "Tx x", x_position) == OPC_COMPCODE_FAILURE ||
		op_ici_attr_set_dbl (iciptr, "Tx y", y_position) == OPC_COMPCODE_FAILURE ||
		op_ici_attr_set_dbl (iciptr, "Rx x", element->x) == OPC_COMPCODE_FAILURE ||
		op_ici_attr_set_dbl (iciptr, "Rx y", element->y) == OPC_COMPCODE_FAILURE ||
		op_ici_attr_set_dbl (iciptr, "bit rate", bit_rate) == OPC_COMPCODE_FAILURE ||
		op_ici_attr_set_dbl (iciptr, "channel", wlan_frequency_center) == OPC_COMPCODE_FAILURE ||
		op_ici_attr_set_dbl (iciptr, "power", tx_power) == OPC_COMPCODE_FAILURE ||
		op_ici_attr_set_int32 (iciptr, "packet type", WLAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||
		op_ici_attr_set_int32 (iciptr, "dest address", dest_address) == OPC_COMPCODE_FAILURE)
		wlan_txrx_chan_error ("wlan_txrx_channel_send_packet:", "Unable to set the ICI pointer.", OPC_NIL);
		
	/* associate the ici with the packet */
	op_pk_ici_set (pkptr, iciptr);

	/* put the packet in the queue */
	op_prg_list_insert (tx_pkt_subqueue, pkptr, OPC_LISTPOS_TAIL);
	
	/* schedule the packet send */
	if (time_to_send < tx_time_to_send)	time_to_send = tx_time_to_send;
	op_intrpt_schedule_self (time_to_send, WlanT_Ready_To_Send);
	
	
	FOUT;
}


/*
 * Function:	wlan_txrx_channel_send_packet
 */

static void
wlan_txrx_channel_send_packet (void)
{
	Packet * pkptr;
	double bit_rate, tx_delay;
	
	FIN (wlan_txrx_channel_send_packet ());
	
	/* get the packet from the queue */
	pkptr = op_prg_list_remove (tx_pkt_subqueue, OPC_LISTPOS_HEAD);
	
	if (pkptr == NULL || pkptr == OPC_NIL)
		op_sim_end ("ERROR !!!", OPC_NIL, OPC_NIL, OPC_NIL);
	
	/* get the bit rate of the packet */
	op_pk_nfd_access (pkptr, "Tx Data Rate", &bit_rate);
	
	/* compute the transmission delay */
	tx_delay = (double) op_pk_total_size_get (pkptr) / bit_rate;
	
	/* update the time to send */
	tx_time_to_send = op_sim_time () + tx_delay;
	//last_sending_time = op_sim_time ();
	
	if (INTRPT_STATUS_DEBUG)
		{
		printf ("%s TX layer: %.15f s: send the packet %d to receiver\n", node_name, op_sim_time (), (int) op_pk_id (pkptr));
		}
	/* deliver the packet to the channel */
	op_pk_deliver (pkptr, wpan_channel_objid, 0);
	
	/* when we send a packet, the node should stay busy till the end of the transmission */
	op_stat_write (busy_stat_handle, 1.0);
	
	/* update the statistic */
	statistic.Pkt_Sent ++;
	
	if (ODB_WLAN_TRANSMISSION)
		{
		printf("\n");
		printf ("%s: send a packet to the channel at %f s.\n", node_name, op_sim_time ());
		printf ("%s TX layer: %.15f s: send packet %d with size %d\n", node_name, op_sim_time (), (int) op_pk_id (pkptr), op_pk_total_size_get (pkptr));
		}
	FOUT;
}


/*
 *
 */

static void
wlan_txrx_channel_rcv_packet (void)
{
	Packet * pkptr;
	int accept;

	
	FIN (wlan_txrx_channel_rcv_packet ());
	
	/* get the packet */
	pkptr = op_pk_get (intrpt_stream);
	
	/* get the accept flag of the packet for the statistic */
	op_pk_nfd_get_int32 (pkptr, "Accept", &accept);
	
	/* update the statistics */
	if (accept)
		statistic.Pkt_Recv ++;
	else
		statistic.Pkt_Lost ++;
	
	/* 
	 * This is the end of the transmission, the packet
	 * is entirely received.
	 * so, we reset the power transmission to 0
	 */
	op_stat_write (power_stat_handle, 0.0);
	/* we forward the packet to the wlan MAC layer*/
	op_pk_send (pkptr, 0);
	if (ODB_WLAN_TRANSMISSION)
		{
		printf("\n");
		printf ("%s: receive a packet from lower layer at %f s.\n", node_name, op_sim_time ());
		printf ("%s TX layer: %.15f s: received the packet %d\n", node_name, op_sim_time (), (int) op_pk_id (pkptr));
		}
	FOUT;
}


/*
 * Function:
 */

static void
wlan_rcv_wpan_packet (void)
{
	WlanT_Data_Header_Fields * header_data;
	Packet * fake_pkptr;
	
	FIN (wlan_rcv_wpan_packet ());
	
	/* create some fake packet to send to the WLAN */
	fake_pkptr = op_pk_create_fmt ("wlan_mac");
	
	/* compute a fake header */
	header_data = (WlanT_Data_Header_Fields *) op_prg_mem_alloc (sizeof (WlanT_Data_Header_Fields));
	
	/* complete the header */
	header_data->address1 = own_mac_address + 1;
	header_data->address2 = own_mac_address + 1;
	
	/* assign the header structure to a field in the packet */
	op_pk_nfd_set_ptr (fake_pkptr, "Wlan Header", header_data, op_prg_mem_copy_create, op_prg_mem_free, sizeof (header_data));
	
	/* Assigned a size of 304 bits to the packet (same as a control packet) */
	op_pk_total_size_set (fake_pkptr, 304);
	
	/* set the noise flag */
	op_pk_nfd_set (fake_pkptr, "Noise", 1);	
	
	/* forward the packet to the MAC layer */
	op_pk_send (fake_pkptr, 0);

	/* reset the power */
	op_stat_write (power_stat_handle, 0.0);
	
	if (ODB_WLAN_TRANSMISSION)
		printf ("%s: send a fake packet (CCA) at %f s.\n", node_name, op_sim_time ());
	
	FOUT;
}


/*
 */

static void
wlan_txrx_channel_register (void)
{
	int nb_element = op_prg_list_size (wpan_node_param_list);
	Wpan_Node_Param * element;
	int i;

	
	FIN (wlan_txrx_channel_register ());

	/* 
	 * search the cell pre-registered according
	 * to the parent objid
	 */

	if (!nb_element)
		op_sim_end ("wlan_txrx_channel_register:", "No device registered.", OPC_NIL, OPC_NIL);

	/* search the element in the list of nodes */
	for (i = 0; i < nb_element; i++)
		{
		/* access the element */
		element = op_prg_list_access (wpan_node_param_list, i);
		
		/* check the MAC address*/
		if (element->objid == parent_objid)
			{
		    element->objid = my_objid;
			element->frequency = wlan_frequency_center;
			own_mac_address = element->mac_address;
			}
		}
		
	FOUT;
}


/*
 * Function:	wlan_txrx_idle_channel
 *
 * Description:	this function will update the statistics (power and busy)
 *				to generate an interuption to the MAC layer through the
 *				statistic wire.
 *
 * No Parameter
 */

static void
wlan_txrx_flags (void)
{
	WlanT_Rx_State_Info * wlan_info_ptr; // wlan state variable
	double pk_reception_end;
	int packet_type;
	double packet_size;
	Ici * wlan_rx;
	
	
	FIN (wlan_txrx_idle_channel);

	/* debug informations */
	if (ODB_WLAN_TRANSMISSION)
		printf ("%s: receive a remote interuption\n", node_name);
	
	if (rx_enable)
		{
		if( intrpt_code == 1)
			{
			wlan_rx = op_intrpt_ici ();
		
			/* get the information from the ICI */
			if (op_ici_attr_get_dbl (wlan_rx, "Packet Size", &packet_size) == OPC_COMPCODE_FAILURE )
				op_sim_end ("wlan_txrx_flags:", "Unable to read the ICI.", OPC_NIL, OPC_NIL);
				
			/* destroy the Ici */
			op_ici_destroy (wlan_rx);
			
			wlan_send_fake_packet(packet_size);
			}
		else
			{
			if (ODB_WLAN_TRANSMISSION)
				printf ("received\n");
			/* if the module is in RX mode, we need to upadte the power statistic */
			/* get the ICI associate with the event */
			wlan_rx = op_intrpt_ici ();
		
			/* get the information from the ICI */
			if (op_ici_attr_get_dbl (wlan_rx, "End of Transmission", &pk_reception_end) == OPC_COMPCODE_FAILURE ||
				op_ici_attr_get_int32 (wlan_rx, "Packet Type", &packet_type) == OPC_COMPCODE_FAILURE)
				op_sim_end ("wlan_txrx_flags:", "Unable to read the ICI.", OPC_NIL, OPC_NIL);
				
			/* destroy the Ici */
			op_ici_destroy (wlan_rx);
		
			/*
			* if the module is in RX mode, the remote interuption is for a power update:
			* we are receiving a packet so the power is not null
			*/
			op_stat_write (power_stat_handle, WLAN_DEFAULT_POWER);
		
			/* update the end of transmission for the WLAN MAC */
			if ((wlan_info_ptr = (WlanT_Rx_State_Info *) wlan_state_variable_get (my_objid)) == NULL)
				op_sim_end ("wlan_txrx_flags:", "Null pointer to the WLAN state variable.", OPC_NIL, OPC_NIL);
		
			wlan_info_ptr->rx_end_time = pk_reception_end;
		
			/*
			* if the packet type is a WPAN, we need to schedule an interuption
			* to create a fake packet to forward at the MAC layer and reset the
			* power when the transmission is over
			*/
			if (packet_type == WPAN_PKT_TYPE)
				{
				op_intrpt_schedule_self (pk_reception_end, WlanT_Idle_Power);
				}
			}
		}
	else
		{
		/*
		 * if the module is in TX mode, the remote interuption is to set the channel idle:
		 * the transmission is done and the channel is idle again
		 * We will idle the channel only if no packet is sent in the same time
		 */
		if (ODB_WLAN_TRANSMISSION)
			printf ("transmission done\n");
		op_stat_write (busy_stat_handle, 0.0);
		}
		
	
	FOUT;
}

/*
 * Function:
 */

static void
wlan_send_fake_packet (double packet_size)
{
	WlanT_Data_Header_Fields * header_data;
	Packet * fake_pkptr;
	
	FIN (wlan_send_fake_packet ());
	
	/* create some fake packet to send to the WLAN */
	fake_pkptr = op_pk_create_fmt ("wlan_mac");
	
	/* compute a fake header */
	header_data = (WlanT_Data_Header_Fields *) op_prg_mem_alloc (sizeof (WlanT_Data_Header_Fields));
	
	/* complete the header */
	header_data->address1 = own_mac_address + 1;
	header_data->address2 = own_mac_address + 1;
	
	/* assign the header structure to a field in the packet */
	op_pk_nfd_set_ptr (fake_pkptr, "Wlan Header", header_data, op_prg_mem_copy_create, op_prg_mem_free, sizeof (header_data));
	
	/* Assigned a size to the packet */
	op_pk_total_size_set (fake_pkptr, packet_size);
	
	/* set the accept flag */
	op_pk_nfd_set (fake_pkptr, "Accept", 1);
	
	/* set the accept flag */
	op_pk_nfd_set (fake_pkptr, "Noise", 1);
	
	/* set the frame type */
	if (packet_size == 304.0)
		op_pk_nfd_set (fake_pkptr, "Type", WlanC_Ack);
	else
		op_pk_nfd_set (fake_pkptr, "Type", WlanC_Data);
	/* forward the packet to the MAC layer */
	op_pk_send (fake_pkptr, 0);

	/* reset the power */
	op_stat_write (power_stat_handle, 0.0);
		
	FOUT;
}
/*
 * Function:	
 */

static void
wlan_collect_stat (void)
{
	FILE * fp;
	char report_name[64], date_str[32];
	char rx_file_name[] = "pkt_recv.txt";
	char tx_file_name[] = "pkt_sent.txt";
	time_t date;
	Boolean exist;
	double packet_loss = -1.0;
	
	
	FIN (wlan_collect_stat ());
	
	/* get the date of the day */
	time (&date);
	sprintf (date_str, "%s", ctime (&date));
	
	
	/* start printing report */
	/* get the report name according to the RX/TX status */
	if (rx_enable)
		sprintf (report_name, "%s_%s", node_name, rx_file_name);
	else
		sprintf (report_name, "%s_%s", node_name, tx_file_name);
	
	/* open the file */
	fp = lr_wpan_open_report_file (report_name, &exist);
	
	if (!exist)
		{
		/* write a header in the file */
		if (rx_enable)
			{
			fprintf (fp, "\t*** Packet received at the node %s ***\n", node_name);
			fprintf (fp, "\tCreation date: %s\n", date_str);
			fprintf (fp, "\tPackets lost:\t\tnumber of packet lost by collisions\n");
			fprintf (fp, "\tPackets received:\t\tnumber of MAC data packets received\n");
			fprintf (fp, "\tSimulation time:\t\ttotal simulation time in seconds\n\n");
			fprintf (fp, "Packets lost\t Packets Received\t Packet loss\t Simulation time\t Last modified date\n");
			}
		else
			{
			fprintf (fp, "\t*** Packet sent at the node %s ***\n", node_name);
			fprintf (fp, "\tCreation date: %s\n", date_str);
			fprintf (fp, "\tPackets sent:\t\tnumber of MAC data packets sent\n");
			fprintf (fp, "\tPacket loss:\t\tratio between the number of data packet received and the total number of packet sent (except the Ack)\n");
			fprintf (fp, "\tSimulation time:\t\ttotal simulation time in seconds\n\n");
			fprintf (fp, "Packets Sent\t Simulation time\t Last modified date\n");
			}
		}
	
	/* compute the packet loss */
	if (rx_enable && (statistic.Pkt_Recv + statistic.Pkt_Lost) != 0)
		packet_loss = (double) statistic.Pkt_Lost / ((double) statistic.Pkt_Recv + (double) statistic.Pkt_Lost);
	
	if (rx_enable)
		fprintf (fp, "%s\t %s\t %s\t %s\t %s", integer_to_string (statistic.Pkt_Lost, strlen ("Packets lost")),
			integer_to_string (statistic.Pkt_Recv, strlen ("Packets Received")),
			double_to_string (packet_loss, strlen ("Packet loss")),
			double_to_string (op_sim_time (), strlen ("Simulation time")),
			date_str);
	else
		fprintf (fp, "%s\t %s\t %s", integer_to_string (statistic.Pkt_Sent, strlen ("Packet Sent")),
			double_to_string (op_sim_time (), strlen ("Simulation time")),
			date_str);
	
	fclose (fp);
	
	FOUT;
}

/* End of Function Block */

/* Undefine optional tracing in FIN/FOUT/FRET */
/* The FSM has its own tracing code and the other */
/* functions should not have any tracing.		  */
#undef FIN_TRACING
#define FIN_TRACING

#undef FOUTRET_TRACING
#define FOUTRET_TRACING

#if defined (__cplusplus)
extern "C" {
#endif
	void wlan_txrx_channel (OP_SIM_CONTEXT_ARG_OPT);
	VosT_Obtype wlan_txrx_channel_init (int * init_block_ptr);
	VosT_Address wlan_txrx_channel_alloc (VOS_THREAD_INDEX_ARG_COMMA VosT_Obtype, int);
	void wlan_txrx_channel_diag (OP_SIM_CONTEXT_ARG_OPT);
	void wlan_txrx_channel_terminate (OP_SIM_CONTEXT_ARG_OPT);
	void wlan_txrx_channel_svar (void *, const char *, void **);


	VosT_Fun_Status Vos_Define_Object (VosT_Obtype * obst_ptr, const char * name, unsigned int size, unsigned int init_obs, unsigned int inc_obs);
	VosT_Address Vos_Alloc_Object_MT (VOS_THREAD_INDEX_ARG_COMMA VosT_Obtype ob_hndl);
	VosT_Fun_Status Vos_Poolmem_Dealloc_MT (VOS_THREAD_INDEX_ARG_COMMA VosT_Address ob_ptr);
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif




/* Process model interrupt handling procedure */


void
wlan_txrx_channel (OP_SIM_CONTEXT_ARG_OPT)
	{

#if !defined (VOSD_NO_FIN)
	int _op_block_origin = 0;
#endif
	FIN_MT (wlan_txrx_channel ());
	if (1)
		{
		char buffer[128];
		Objid wlan_params_comp_attr_objid, wlan_params_attr_objid;
		Objid channel_params_comp_attr_objid, channel_params_attr_objid;
		
		/* channel parameters */
		double channel_bandwidth;
		double channel_min_frequency;


		FSM_ENTER ("wlan_txrx_channel")

		FSM_BLOCK_SWITCH
			{
			/*---------------------------------------------------------*/
			/** state (Init) enter executives **/
			FSM_STATE_ENTER_UNFORCED_NOLABEL (0, "Init", "wlan_txrx_channel [Init enter execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [Init enter execs], state0_enter_exec)
				{
				/* get the ID of the module */
				my_objid = op_id_self ();
				
				/* get the id of the node */
				parent_objid = op_topo_parent (my_objid);
				
				/* get the name of the node */
				op_ima_obj_attr_get_str (parent_objid, "name", 128, buffer);
				
				
				/* register the node name */
				node_name = (char *) op_prg_mem_alloc ((strlen(buffer) + 1)*sizeof(char));
				strcpy (node_name, buffer);
				
				/* get the position of the node */
				op_ima_obj_attr_get (parent_objid, "x position", &x_position);
				op_ima_obj_attr_get (parent_objid, "y position", &y_position);
				
				/* addition Milcom 05 */
				op_ima_obj_attr_get (parent_objid, "delta x", &delta_x);
				op_ima_obj_attr_get (parent_objid, "delta y", &delta_y);
				
				x_position = x_position + delta_x;
				y_position = y_position + delta_y;
				
				/* end addition milcom 05 */
				
				/* Obtain the values assigned to the various attributes.*/
				op_ima_obj_attr_get (parent_objid, "Wireless LAN Parameters", &wlan_params_comp_attr_objid);
				wlan_params_attr_objid = op_topo_child (wlan_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);
				op_ima_obj_attr_get (wlan_params_attr_objid, "Channel Settings", &channel_params_comp_attr_objid);
				channel_params_attr_objid = op_topo_child (channel_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);
				
				/*get the transmission power*/
				op_ima_obj_attr_get (wlan_params_attr_objid, "Transmit Power", &tx_power);
				
				/* Get the frequency */
				op_ima_obj_attr_get (channel_params_attr_objid, "Bandwidth", &channel_bandwidth);
				op_ima_obj_attr_get (channel_params_attr_objid, "Min Frequency", &channel_min_frequency);
				
				/* compute the frequency center */
				if (channel_min_frequency != -1.0)
					wlan_frequency_center = channel_min_frequency + (channel_bandwidth / 2.0);
				else
					wlan_txrx_chan_error ("Wireless LAN init:", "The WLAN is in BSS Based for the Frequency.", "Please set a channel directly in the \"WLAN Parameters\"");
				
				
				
				
				/* get the operation mode */
				op_ima_obj_attr_get (my_objid, "operation mode", &rx_enable);
				printf(" objid %d, parent %d, name %s, rxtx %d \n", my_objid, parent_objid, buffer, rx_enable);
				/* print some information */
				if (rx_enable)
					printf ("**  Node %s, frequency Center: %f MHz  **\n", node_name, wlan_frequency_center);
				
				/* statistic handle */
				busy_stat_handle = op_stat_reg ("TxRx.busy", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				power_stat_handle = op_stat_reg ("TxRx.power", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				
				/* initialize the statistic vector */
				statistic.Pkt_Recv 	= 0;
				statistic.Pkt_Sent 	= 0;
				statistic.Pkt_Lost 	= 0;
				statistic.Delay		= 0.0;
				
				/* initialize the queue */
				tx_pkt_subqueue = op_prg_list_create ();
				
				/* initialize the time to send delay */
				tx_time_to_send = 0.0;
				
				/* define highest priority for the packet sending */
				op_intrpt_priority_set (OPC_INTRPT_SELF, WlanT_Ready_To_Send, 5);
				op_intrpt_priority_set (OPC_INTRPT_STRM, 0, 5);
				
				/* interruption to go to the next state */
				op_intrpt_schedule_self (op_sim_time (), WlanT_Next_State);
				}

				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [Init enter execs], state0_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (1,"wlan_txrx_channel")


			/** state (Init) exit executives **/
			FSM_STATE_EXIT_UNFORCED (0, "Init", "wlan_txrx_channel [Init exit execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [Init exit execs], state0_exit_exec)
				{
				}
				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [Init exit execs], state0_exit_exec)


			/** state (Init) transition processing **/
			FSM_TRANSIT_FORCE (3, state3_enter_exec, ;, "default", "", "Init", "register")
				/*---------------------------------------------------------*/



			/** state (Idle) enter executives **/
			FSM_STATE_ENTER_UNFORCED (1, "Idle", state1_enter_exec, "wlan_txrx_channel [Idle enter execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [Idle enter execs], state1_enter_exec)
				{
				}

				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [Idle enter execs], state1_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (3,"wlan_txrx_channel")


			/** state (Idle) exit executives **/
			FSM_STATE_EXIT_UNFORCED (1, "Idle", "wlan_txrx_channel [Idle exit execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [Idle exit execs], state1_exit_exec)
				{
				/* get the type of the interruption */
				intrpt_type = op_intrpt_type ();
				
				/*
				 * get the stream or the code 
				 * of the interruption according
				 * to its type
				 */
				if (intrpt_type == OPC_INTRPT_STRM)
					intrpt_stream = op_intrpt_strm ();
				else
					intrpt_code = op_intrpt_code ();
				
				/* If the end of simulation occurs, we print the statistic report */
				if (END_SIM)
					wlan_collect_stat ();
				}
				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [Idle exit execs], state1_exit_exec)


			/** state (Idle) transition processing **/
			FSM_PROFILE_SECTION_IN (wlan_txrx_channel [Idle trans conditions], state1_trans_conds)
			FSM_INIT_COND (PKT_ARRIVAL)
			FSM_TEST_COND (READY_TO_SEND)
			FSM_TEST_COND (UPDATE_FLAG)
			FSM_TEST_COND (IDLE_POWER)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("Idle")
			FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [Idle trans conditions], state1_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 2, state2_enter_exec, ;, "PKT_ARRIVAL", "", "Idle", "TX_RX")
				FSM_CASE_TRANSIT (1, 4, state4_enter_exec, ;, "READY_TO_SEND", "", "Idle", "SEND")
				FSM_CASE_TRANSIT (2, 5, state5_enter_exec, ;, "UPDATE_FLAG", "", "Idle", "IDLE CHANNEL")
				FSM_CASE_TRANSIT (3, 1, state1_enter_exec, wlan_rcv_wpan_packet ();, "IDLE_POWER", "wlan_rcv_wpan_packet ()", "Idle", "Idle")
				FSM_CASE_TRANSIT (4, 1, state1_enter_exec, ;, "default", "", "Idle", "Idle")
				}
				/*---------------------------------------------------------*/



			/** state (TX_RX) enter executives **/
			FSM_STATE_ENTER_FORCED (2, "TX_RX", state2_enter_exec, "wlan_txrx_channel [TX_RX enter execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [TX_RX enter execs], state2_enter_exec)
				{
				if (rx_enable)
					{
					/* received the packet */
					wlan_txrx_channel_rcv_packet ();
					}
				else
					{
					/* call the TX send packet */
					wlan_txrx_channel_register_packet ();
					}
				}

				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [TX_RX enter execs], state2_enter_exec)

			/** state (TX_RX) exit executives **/
			FSM_STATE_EXIT_FORCED (2, "TX_RX", "wlan_txrx_channel [TX_RX exit execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [TX_RX exit execs], state2_exit_exec)
				{
				}
				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [TX_RX exit execs], state2_exit_exec)


			/** state (TX_RX) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "TX_RX", "Idle")
				/*---------------------------------------------------------*/



			/** state (register) enter executives **/
			FSM_STATE_ENTER_UNFORCED (3, "register", state3_enter_exec, "wlan_txrx_channel [register enter execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [register enter execs], state3_enter_exec)
				{
				/* interruption to go to the next state */
				op_intrpt_schedule_self (op_sim_time (), WlanT_Next_State);
				}

				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [register enter execs], state3_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (7,"wlan_txrx_channel")


			/** state (register) exit executives **/
			FSM_STATE_EXIT_UNFORCED (3, "register", "wlan_txrx_channel [register exit execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [register exit execs], state3_exit_exec)
				{
				/* 
				 * register this module for the channel
				 * we assume that the WLAN mac layer pre-register
				 * this node via the function "wpan_store_stranger_node".
				 */
				
				if (rx_enable)
					wlan_txrx_channel_register ();
				}
				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [register exit execs], state3_exit_exec)


			/** state (register) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "register", "Idle")
				/*---------------------------------------------------------*/



			/** state (SEND) enter executives **/
			FSM_STATE_ENTER_FORCED (4, "SEND", state4_enter_exec, "wlan_txrx_channel [SEND enter execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [SEND enter execs], state4_enter_exec)
				{
				/*
				 * We are ready to send the packet to the channel
				 * Also, we update the busy flag of the WLAN
				 */
				wlan_txrx_channel_send_packet ();
				}

				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [SEND enter execs], state4_enter_exec)

			/** state (SEND) exit executives **/
			FSM_STATE_EXIT_FORCED (4, "SEND", "wlan_txrx_channel [SEND exit execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [SEND exit execs], state4_exit_exec)
				{
				}
				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [SEND exit execs], state4_exit_exec)


			/** state (SEND) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "SEND", "Idle")
				/*---------------------------------------------------------*/



			/** state (IDLE CHANNEL) enter executives **/
			FSM_STATE_ENTER_FORCED (5, "IDLE CHANNEL", state5_enter_exec, "wlan_txrx_channel [IDLE CHANNEL enter execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [IDLE CHANNEL enter execs], state5_enter_exec)
				{
				/*
				 * Update the TX/RX flags of the WLAN by generating
				 * statistic interuptions, according to the RX/TX
				 * attribute of this module
				 */
				
				wlan_txrx_flags ();
				}

				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [IDLE CHANNEL enter execs], state5_enter_exec)

			/** state (IDLE CHANNEL) exit executives **/
			FSM_STATE_EXIT_FORCED (5, "IDLE CHANNEL", "wlan_txrx_channel [IDLE CHANNEL exit execs]")
				FSM_PROFILE_SECTION_IN (wlan_txrx_channel [IDLE CHANNEL exit execs], state5_exit_exec)
				{
				}
				FSM_PROFILE_SECTION_OUT (wlan_txrx_channel [IDLE CHANNEL exit execs], state5_exit_exec)


			/** state (IDLE CHANNEL) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "IDLE CHANNEL", "Idle")
				/*---------------------------------------------------------*/



			}


		FSM_EXIT (0,"wlan_txrx_channel")
		}
	}




void
wlan_txrx_channel_diag (OP_SIM_CONTEXT_ARG_OPT)
	{
	/* No Diagnostic Block */
	}




void
wlan_txrx_channel_terminate (OP_SIM_CONTEXT_ARG_OPT)
	{

#if !defined (VOSD_NO_FIN)
	int _op_block_origin = __LINE__;
#endif

	FIN_MT (wlan_txrx_channel_terminate ())

	Vos_Poolmem_Dealloc_MT (OP_SIM_CONTEXT_THREAD_INDEX_COMMA pr_state_ptr);

	FOUT
	}


/* Undefine shortcuts to state variables to avoid */
/* syntax error in direct access to fields of */
/* local variable prs_ptr in wlan_txrx_channel_svar function. */
#undef my_objid
#undef rx_enable
#undef intrpt_type
#undef intrpt_stream
#undef intrpt_code
#undef parent_objid
#undef node_name
#undef x_position
#undef y_position
#undef busy_stat_handle
#undef power_stat_handle
#undef wlan_frequency_center
#undef statistic
#undef tx_time_to_send
#undef tx_pkt_subqueue
#undef own_mac_address
#undef tx_power
#undef delta_x
#undef delta_y

#undef FIN_PREAMBLE_DEC
#undef FIN_PREAMBLE_CODE

#define FIN_PREAMBLE_DEC
#define FIN_PREAMBLE_CODE

VosT_Obtype
wlan_txrx_channel_init (int * init_block_ptr)
	{

#if !defined (VOSD_NO_FIN)
	int _op_block_origin = 0;
#endif
	VosT_Obtype obtype = OPC_NIL;
	FIN_MT (wlan_txrx_channel_init (init_block_ptr))

	Vos_Define_Object (&obtype, "proc state vars (wlan_txrx_channel)",
		sizeof (wlan_txrx_channel_state), 0, 20);
	*init_block_ptr = 0;

	FRET (obtype)
	}

VosT_Address
wlan_txrx_channel_alloc (VOS_THREAD_INDEX_ARG_COMMA VosT_Obtype obtype, int init_block)
	{

#if !defined (VOSD_NO_FIN)
	int _op_block_origin = 0;
#endif
	wlan_txrx_channel_state * ptr;
	FIN_MT (wlan_txrx_channel_alloc (obtype))

	ptr = (wlan_txrx_channel_state *)Vos_Alloc_Object_MT (VOS_THREAD_INDEX_COMMA obtype);
	if (ptr != OPC_NIL)
		ptr->_op_current_block = init_block;
	FRET ((VosT_Address)ptr)
	}



void
wlan_txrx_channel_svar (void * gen_ptr, const char * var_name, void ** var_p_ptr)
	{
	wlan_txrx_channel_state		*prs_ptr;

	FIN_MT (wlan_txrx_channel_svar (gen_ptr, var_name, var_p_ptr))

	if (var_name == OPC_NIL)
		{
		*var_p_ptr = (void *)OPC_NIL;
		FOUT
		}
	prs_ptr = (wlan_txrx_channel_state *)gen_ptr;

	if (strcmp ("my_objid" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->my_objid);
		FOUT
		}
	if (strcmp ("rx_enable" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->rx_enable);
		FOUT
		}
	if (strcmp ("intrpt_type" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->intrpt_type);
		FOUT
		}
	if (strcmp ("intrpt_stream" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->intrpt_stream);
		FOUT
		}
	if (strcmp ("intrpt_code" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->intrpt_code);
		FOUT
		}
	if (strcmp ("parent_objid" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->parent_objid);
		FOUT
		}
	if (strcmp ("node_name" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->node_name);
		FOUT
		}
	if (strcmp ("x_position" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->x_position);
		FOUT
		}
	if (strcmp ("y_position" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->y_position);
		FOUT
		}
	if (strcmp ("busy_stat_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->busy_stat_handle);
		FOUT
		}
	if (strcmp ("power_stat_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->power_stat_handle);
		FOUT
		}
	if (strcmp ("wlan_frequency_center" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->wlan_frequency_center);
		FOUT
		}
	if (strcmp ("statistic" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->statistic);
		FOUT
		}
	if (strcmp ("tx_time_to_send" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->tx_time_to_send);
		FOUT
		}
	if (strcmp ("tx_pkt_subqueue" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->tx_pkt_subqueue);
		FOUT
		}
	if (strcmp ("own_mac_address" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->own_mac_address);
		FOUT
		}
	if (strcmp ("tx_power" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->tx_power);
		FOUT
		}
	if (strcmp ("delta_x" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->delta_x);
		FOUT
		}
	if (strcmp ("delta_y" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->delta_y);
		FOUT
		}
	*var_p_ptr = (void *)OPC_NIL;

	FOUT
	}

