/* wlan_custom_txdel.ps.c */                                                       
/* Modified transmission delay model for IEEE 802.11.	*/
/* It retrieves the transmission data rate from the		*/
/* packet itself instead of the transmitter channel for	*/
/* the computation of the transmission delay. This is	*/
/* needed because the transmissions of all supported	*/
/* WLAN (802.11 and 802.11b) data rates use the same	*/
/* tranceiver channel. Hence, the data rate setting of	*/
/* the transmitter channel doesn't always indicate the	*/
/* actual transmission data rate.						*/

/****************************************/
/*		  Copyright (c) 1993-2003		*/
/*		by OPNET Technologies, Inc.		*/
/*		(A Delaware Corporation)		*/
/*	7255 Woodmont Av., Suite 250  		*/
/*     Bethesda, MD 20814, U.S.A.       */
/*			All Rights Reserved.		*/
/****************************************/

#include "opnet.h"
#include <oms_tan.h>
#include <oms_rr.h>

#if defined (__cplusplus)
extern "C"
#endif
void
wlan_custom_txdel_mt (OP_SIM_CONTEXT_ARG_OPT_COMMA Packet * pkptr)
	{
	OpT_Packet_Size	pklen;
	double			tx_drate, tx_delay;
	Objid			tx_objid;
	char			node_name [OMSC_HNAME_MAX_LEN];
	char			node_link_name_str [2 * OMSC_HNAME_MAX_LEN];

	/** Compute the transmission delay associated with the	**/
	/** transmission of a packet over a radio link.			**/
	FIN_MT (wlan_custom_txdel (pkptr));

	/* Obtain the transmission rate from the packet.		*/
	op_pk_nfd_get (pkptr, "Tx Data Rate", &tx_drate);

	/* Obtain length of packet. 							*/
	pklen = op_pk_total_size_get (pkptr);

	/* Compute time required to complete transmission of	*/
	/* packet. 												*/
	tx_delay = pklen / tx_drate;

	/* Place transmission delay result in packet's 			*/
	/* reserved transmission data attribute. 				*/
	op_td_set_dbl (pkptr, OPC_TDA_RA_TX_DELAY, tx_delay);
	
	/* Modif. Oliv */
	if (op_prg_odb_ltrace_active("intrpt_status") == OPC_TRUE)
		printf ("%.15f, node wlan (send), send packet %d to the receiver\n", op_sim_time (), (int) op_pk_id (pkptr));
	/***************/
	
	/* Dump routes for only packets	that have requested for	*/
	/* route information by setting the correct flag.		*/
	if (op_pk_encap_flag_is_set (pkptr, OMSC_RR_ENCAP_FLAG_INDEX))
		{	
		/* Determine the name of the sending node and store	*/
		/* it for future use. 								*/
		tx_objid = op_td_get_int (pkptr, OPC_TDA_RA_TX_OBJID);
		oms_tan_hname_get (op_topo_parent (tx_objid), node_name);
	
		/* Construct a <node,link> pair string				*/
		sprintf (node_link_name_str, "%s,%s", node_name, "None");
	
		/* Update information about traversed node/links if	*/
		/* this is a bgutil tracer packet.					*/
		oms_rr_info_update (pkptr, node_link_name_str);
		}

	FOUT
	}
