/* wlan_custom_ecc.ps.c */
/* Modified for IEEE802.11										*/		 
/* Error correction model for radio link Transceiver Pipeline 	*/

/****************************************/
/*		Copyright (c) 1993 - 2002		*/
/*		by OPNET Technologies, Inc.		*/
/*		(A Delaware Corporation)		*/
/*	7255 Woodmont Av., Suite 250  		*/
/*     Bethesda, MD 20814, U.S.A.       */
/*			All Rights Reserved.		*/
/****************************************/

#include <opnet.h>
#include <wlan_support.h>	

#if defined (__cplusplus)
extern "C"
#endif
void
wlan_custom_ecc_mt (OP_SIM_CONTEXT_ARG_OPT_COMMA Packet* pkptr)
    {
	OpT_Packet_Size	pklen;
	int				num_errs, accept;
	double			ecc_thresh;

	/** Determine acceptability of given packet at receiver. 		**/
	FIN_MT (wlan_custom_ecc (pkptr));

	/* Check the value of Accept field in the packet. If it is an	*/
	/* interfering packet from a neighbor BSS with high power, then	*/
	/* the Accept field will be set to a special value.				*/
	op_pk_nfd_get (pkptr, "Accept", &accept);

	/* Do not accept packets that were received when the node was	*/
	/* disabled or coming from an interferer node.					*/		
	if (accept == WLANC_NEIGHBOR_BSS_PKT_REJECT || op_td_is_set (pkptr, OPC_TDA_RA_ND_FAIL))
		accept = OPC_FALSE;
	else
		{
		/* Obtain the error correction threshold of the receiver. 	*/
		ecc_thresh = op_td_get_dbl (pkptr, OPC_TDA_RA_ECC_THRESH);

		/* Obtain length of packet. 								*/
		pklen = op_pk_total_size_get (pkptr);

		/* Obtain number of errors in packet.						*/
		num_errs = op_td_get_int (pkptr, OPC_TDA_RA_NUM_ERRORS);
	
		/* Test if bit errors exceed threshold. 					*/
		if (pklen == 0)
			accept = OPC_TRUE;
		else
			accept = ((((double) num_errs) / pklen) <= ecc_thresh) ? OPC_TRUE : OPC_FALSE;
		}

	/* Place flag indicating accept/reject in the data packet		*/
	/* control field. 												*/
	op_pk_nfd_set (pkptr, "Accept", accept);
	
	/* Modif. Oliv */
	if (op_prg_odb_ltrace_active("intrpt_status") == OPC_TRUE)
		printf ("%.15f, node wlan (rcv), received packet %d in the receiver\n", op_sim_time (), (int) op_pk_id (pkptr));
	/***************/
	    
	/* Force the simulation kernel to always accpet the packet. The	*/
	/* actual discarding of the packet will take place at the MAC	*/
	/* layer of the receiving node receiving this packet.      		*/
	op_td_set_int (pkptr, OPC_TDA_RA_PK_ACCEPT, OPC_TRUE);

	FOUT
	}
