/* wlan_propdel.ps.c */                                                       
/* Modified for IEEE802.11										*/
/* Propagation delay model for radio link Transceiver Pipeline 	*/

/****************************************/
/*	   Copyright (c) 1993 - 2002		*/
/*		by OPNET Technologies, Inc.		*/
/*		(A Delaware Corporation)		*/
/*	7255 Woodmont Av., Suite 250  		*/
/*     Bethesda, MD 20814, U.S.A.       */
/*			All Rights Reserved.		*/
/****************************************/

#include <opnet.h>
#include <oms_tan.h>

/***** constants *****/

/* propagation velocity of radio signal (m/s) 				*/
#define	PROP_VELOCITY	3.0E+08

/* Maximum allowed distance by the WLAN standard in meters,	*/
/* i.e. PROP_VELOCITY * 1 usec = 300 m						*/
#define	MAX_DISTANCE	300  

/* The variable defining a maximum range across which the station can communicate (meters)	*/ 
static double wlan_max_distance = OPC_DBL_INFINITY;

/***** pipeline procedure *****/
#if defined (__cplusplus)
extern "C"
#endif
void
op_wlan_propdel (Packet * pkptr)
	{
	double				start_prop_delay, end_prop_delay;
	double				start_prop_distance, end_prop_distance;
	static Boolean		log_message_written = OPC_FALSE;
	static Log_Handle	tx_range_lhdl;
	char*				node1_name_str;
	char*				node2_name_str;
	
	/** Compute the propagation delay separating the radio transmitter from	**/
	/** the radio receiver.													**/
	FIN (wlan_propdel (pkptr));

	/* Modif. Olivier */
	printf ("\n|**************************************|\n");
	printf ("|** Simulation time : %f seconds\n", op_sim_time());
		
	printf ("|** \"Pass through the op_wlan_propdel\"\n");
		
	printf ("|**************************************|\n");
	op_sim_message ("Pass through the op_wlan_propdel", OPC_NIL, OPC_NIL);
	Sleep (1000);
	/******************/
	
	/* Get the start distance between transmitter and receiver. 			*/
	start_prop_distance = op_td_get_dbl (pkptr, OPC_TDA_RA_START_DIST);

	/* Get the end distance between transmitter and receiver. 				*/
	end_prop_distance = op_td_get_dbl (pkptr, OPC_TDA_RA_END_DIST);

	/* Compute propagation delay to start of reception. 					*/
	start_prop_delay = start_prop_distance / PROP_VELOCITY;

	/* Compute propagation delay to end of reception. 						*/
	end_prop_delay = end_prop_distance / PROP_VELOCITY;

    /* Check whether the propagation distance is higher than the maximum	*/
	/* value allowed by IEEE 802.11 standard. If this is the case, write	*/
	/* a simulation notification log for warning.							*/
	if ((end_prop_distance > MAX_DISTANCE || start_prop_distance > MAX_DISTANCE) && log_message_written == OPC_FALSE)
		{
			/* Register the log handle.										*/
			tx_range_lhdl = op_prg_log_handle_create (OpC_Log_Category_Configuration, "Wireless Lan", "Distance Limit Exceeded", 1);

			/* Allocate memory for the name strings.						*/
			node1_name_str = (char *) op_prg_mem_alloc (256 * sizeof (char));
			node2_name_str = (char *) op_prg_mem_alloc (256 * sizeof (char));
			
			/* Obtain the hierarchical names of the nodes.					*/
			oms_tan_hname_get (op_topo_parent (op_td_get_int (pkptr, OPC_TDA_RA_TX_OBJID)), node1_name_str);
			oms_tan_hname_get (op_topo_parent (op_td_get_int (pkptr, OPC_TDA_RA_RX_OBJID)), node2_name_str);
			
			/* Write the warning message.									*/
			op_prg_log_entry_write(tx_range_lhdl,
				"WARNING:\n"
				" The propagation delay between the two WLAN nodes of same BSS\n"
				" \n"	
				" %s and\n"
				" %s\n"
				" \n"	
				" is greater than the maximum propagation delay allowed by \n"
				" IEEE 802.11 WLAN standard, which is 1 microsecond. Due \n"
				" to violation of this rule, a degradation of WLAN\n"
				" performance is possible within the BSS of these nodes.\n"
				" \n"
				" This message will not be repeated even the same condition\n"
				" is detected between two other WLAN nodes in the network.\n"
				" \n"	
				"SUGGESTION:\n"
				" Bring these nodes closer to each so that the distance\n"
				" between them is less than 300 meters if you want the\n"
				" configuration of these nodes to comply with the rules of the\n"
				" 802.11 standard fully.\n",
				node1_name_str, node2_name_str);
		
		/* Prevent multiple entries of the same message.					*/
		log_message_written = OPC_TRUE;
		}

    /* Place both propagation delays in packet transmission data attributes.*/
	op_td_set_dbl (pkptr, OPC_TDA_RA_START_PROPDEL, start_prop_delay);
	op_td_set_dbl (pkptr, OPC_TDA_RA_END_PROPDEL, end_prop_delay);
	FOUT;
	}                
