MIL_3_Tfile_Hdr_ 120A 107A modeler 9 3F79EB73 45217C93 421 P614876 nchevrol 0 0 none none 0 0 none E891EAB8 18445 0 0 0 0 0 0 fec 0                                                                                                                                                                                                                                                                                                                                                                                             g      @  
  
     Q     9 = A P   
   CSMA-CA Parameters                         count       
      
      list   	   
          
                                 $Parameters for the CSMA-CA algorithm   count                                                 list   	   	                                               Maximum backoff number                    4                             1            2            3            4               Maximum number of backoff   Minimum backoff exponent                    3                             0             1            2            3                Maximum backoff exponent                    5                             1            2            3            4            5                Address                  
Auto assigned                             
Auto assigned            MAC address of the node   Channel           %         
channel 11                             
channel 11            
channel 12            
channel 13      
      
channel 14            
channel 15            
channel 16            
channel 17            
channel 18            
channel 19            
channel 20            
channel 21            
channel 22            
channel 23            
channel 24            
channel 25            
channel 26               Uchannel numbers in the 2.4 GHz band. The number must be beetween 11 and 26 inclusive.   Group number                                               0             1            2            3               rThis number  differs the transmissions. Each device  will send packets to the devices belonging in the same group.   Source Type                   	Bulk Data                             	Bulk Data            TCP/IP                -Type of packet source used with the MAC layer   Nb of transmission retries                    3                             1            2            3               PNumber maximum of transmission retries when we don't receive an acknowledgement.   Acknowledgement                   Enabled                             Enabled            Disabled                1Enable or disable the acknowledgement of the WPAN   Channel Access                    	Unslotted                             Slotted            	Unslotted                GSwitch between a channel divided in slot or an unslotted communication.   Mode                   Master                             Master            Slave                vUsed for the slotted channel access. If the mode is set to "Master", the node will send the first beacon to the other.       3Attention: it must be one master in the same group.   	---------   Power             ?                                                    	   
begsim intrpt         
      
   doc file            	nd_module      
endsim intrpt         
      
   failure intrpts            disabled      intrpt interval         ԲI%}      priority                    recovery intrpts            disabled      subqueue         
            count       
      
      list   	   
          
   
   super priority                       c   "/* type of current interruption */   int	\intrpt_type;       $/* stream of current interruption */   int	\intrpt_stream;       "/* code of current interruption */   int	\intrpt_code;       /* CSMA CA parameters */    Mac_CSMA_Param	\csma_parameters;       /* flag to perform the CCA */   Boolean	\channel_is_idle;       /* Parameters of the node */   !Wpan_Node_Param *	\my_parameters;       "/* Frequency used by the device */   double	\wpan_frequency_center;       /* Name of the WPAN node */   char *	\lr_wpan_node_name;       9/* MAC queue to store the packet from the higher layer */   Wpan_Queue *	\wpan_queue;       &/* Number of packet in the subqueue */   Stathandle	\nb_pkt_subq;       /* Number of packet received */   Stathandle	\nb_pkt_recv;       /* Number of packet send */   Stathandle	\nb_pkt_send;       ?/* Copy of the current packet to transmit for retransmission */   Packet *	\retransmission_ptr;       =/* Data sequence number (DSN) defined in the IEEE 802.15.4 */   List *	\Mac_Data_Rx_Seqn;       ?/* flag to know whether we are waiting for an acknowledgment */   Boolean	\Rx_Ack_Expected;       </* flag to know whether we have to send an acknowledgment */   Boolean	\Tx_Ack_Require;       @/* Handle for the interruption of the acknowledgment time out */   Evhandle	\Ack_TimeOut_Evhandle;       =/* Data sequence number (DSN) defined in the IEEE 802.15.4 */   int	\Mac_Data_Tx_Seqn;       //* Destination address of the acknowledgment */   int	\Ack_Dest_Addr;        /* Flag for the TX/RX channel */   Wpan_Chan_Flag	\channel_flag;       ,/* Vector of all the collected statistics */   Wpan_Stat_Vector	\statistic;       I/* Flag to know whether the source of packet is a simple source or not */   Boolean	\bulk_data_source;       C/* Handle for the interruption of the turn around time of the TX */   Evhandle	\TAT_TX_Evhandle;       C/* Handle for the interruption of the turn around time of the RX */   Evhandle	\TAT_RX_Evhandle;       7/* Indicate that some packets need to be transmitted */   $Boolean	\wpan_transmission_required;       ./* mark the queue using to send the packets */   Wpan_Queue *	\current_queue;       ,/* Number of maximum transmission retries */   int	\max_frame_retries;       ,/* Number of current transmission retries */   int	\nb_transmission_retries;       ?/* Used to record the MAC process in the model wide registry */   *OmsT_Pr_Handle	\own_process_record_handle;       %/* Used to resolve the MAC address */   &OmsT_Aa_Address_Handle	\oms_aa_handle;       A/* Used to make the acknowledgement or not in the transmission */    Boolean	\Acknowledgement_Enable;       /* Beacon Parameters */   (Wpan_Beacon_Param	\lr_wpan_beacon_param;       ?/* Beacon sequence number (BSN) defined in the IEEE 802.15.4 */   int	\Mac_Beacon_Tx_Seqn;              /*   #** $File : LR-WPAN Mac layer header   **   ** EPON model in Opnet   1** National Institute of Standards and Technology   **   B** This model was developed at the National Institute of Standards   F** and Technology by employees of the Federal Government in the course   D** of their official duties. Pursuant to title 17 Section 105 of the   ?** United States Code this software is not subject to copyright   B** protection and is in the public domain. This is an experimental   D** system.  NIST assumes no responsibility whatsoever for its use by   @** other parties, and makes no guarantees, expressed or implied,   ?** about its quality, reliability, or any other characteristic.   **   <** We would appreciate acknowledgement if the model is used.   **   A** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION   D** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER   +** RESULTING FROM THE USE OF THIS SOFTWARE.   **   !** Primary Author:      O. Rebala   #** Secondary Author:	N. Chevrollier   ;** Module description:  header file for Low Rate WPAN model   )** Last Modification:   October, 1st 2003   **   */       /* header include */   #include "lr_wpan_support.h"   #include "channel_buffer.h"   #include "lr_wpan_stat_write.h"   #include <math.h>   "/* include for the TCP/IP stack */   #include "oms_pr.h"   "#include "oms_auto_addr_support.h"       /* Constant definitions */    #define HIGHER_LAYER_DOWN_STRM 0   #define HIGHER_LAYER_UP_STRM 0   #define LOWER_LAYER_UP_STRM 1   #define MAC_SUBQ	0   #define POWER_TRANS 0.001       /* macro definition */   #ifndef min   #define min(a,b)	(a < b)?a:b   #endif       /* debugging Macro */   <#define ENTER_STATE_ODB_PRINTING(a) if (STATE_PRINT_STATUS)\   ,	printf ("%s MAC layer (%d): %.9f s: %s\n",\   B	lr_wpan_node_name, my_parameters->mac_address, op_sim_time (), a)       2#define FLAG_ODB_PRINTING		if (FLAG_PRINT_STATUS)\   F	printf ("%s MAC layer (%d): flag status:\n\t%s\n\t%s\n\t%s\n\t%s\n",\   0	lr_wpan_node_name, my_parameters->mac_address,\   3	(channel_flag.tx_idle)?"TX is idle":"TX is busy",\   3	(channel_flag.rx_idle)?"RX is idle":"RX is busy",\   =	(Rx_Ack_Expected)?"Acknowledge expected":"No expected Ack",\   8	(Tx_Ack_Require)?"Ack has to be sent":"No Ack pending")       /* structure definition */       2/* structure to create the MAC subqueues system */   typedef struct t_Wpan_Queue {   	List * subqueue;   	int mac_address;   
	int size;   	int nb_element;   	struct t_Wpan_Queue * next;   
} Wpan_Queue;       ,/* define the codes for the interruptions */   typedef enum {   	Backoff_Time_Out,   	Data_Pkt_To_Send,   	Ack_Time_Out,   	Ack_Received,   	Wpan_Ack_Tx_Required,   	End_Of_Transmission,   	CCA_Pkt_Detect,   	Wpan_CCA_Time_Out,   	Wpan_Rcv_Pkt,   
	Wpan_Rx_TAT,   
	Wpan_Tx_TAT,   	Wpan_LIFS_Over,   	Wpan_Beacon_To_Send,   	Wpan_Data_Req_To_Send   } Wpan_Intrpt_Code;       $/* define some code for TX and RX */   typedef enum {   		RX_CODE,   		TX_CODE,   
	TXRX_CODE   } TxRx_Management;       /* define a statistic vector */   typedef struct {   	int Data_Pkt_Rcv;   	int Segment_generated;   	int Data_Pkt_Sent;   	int Data_Req_Send;   	int Ack_Pkt_Rcv;   	int Ack_Pkt_Sent;   	int Pkt_Lost;   	int Pkt_Collided;   	int Pkt_Noise;   	int Pkt_Dropped;   	int Segment_Dropped;   	int Retransmission;   	int Nb_Time_Out;   	double total_backoff_time;   	int	total_backoff;   	double Total_MAC_Delay;   	int tcp_HL_pkt_sent;   	int tcp_HL_bit_sent;   	int tcp_HL_pkt_rcvd;   	int tcp_HL_bit_rcvd;   } Wpan_Stat_Vector;       /* define the channel flag */   typedef struct {   	Boolean tx_idle;   	Boolean rx_idle;   	Boolean LIFS_on;   	Boolean data_is_sending;   } Wpan_Chan_Flag;       /* define the Data Rx Seqn */   typedef struct {   	int mac_address;   
	int seqn;   } Mac_Data_Seqn;       #/* define the backoff parameters */   typedef struct {   .	int max_backoff; // maximum number of Backoff   -	int nb_backoff; // current number of backoff   (	int min_BE; // minimum backoff exponent   (	int max_BE; // maximum backoff exponent   	int Be; // Backoff exponent   } Mac_CSMA_Param;           /* state machine conditions */   c#define		SLOTTED_CONDITION		((my_parameters->master_enable && lr_wpan_beacon_param.beacon_rcvd) ||\   Q									 (!my_parameters->master_enable && lr_wpan_beacon_param.data_requested))   J#define		UNSLOTTED_CONDITION		(my_parameters->slotted_enable == OPC_FALSE)   N#define		READY_TO_SEND			(!channel_flag.LIFS_on && wpan_transmission_required)   b#define		PACKET_TO_SEND			(INTRPT_SELF && (READY_TO_SEND || intrpt_code == Wpan_Data_Req_To_Send))   K#define 	BACKOFF_EXPIRED			(INTRPT_SELF && intrpt_code == Backoff_Time_Out)   I#define		CCA_EXPIRED				(INTRPT_SELF && intrpt_code == Wpan_CCA_Time_Out)   ?#define		TRANSMISSION_OK			(channel_is_idle && !SECOND_CCA_REQ)   y#define		BACK_TO_BACKOFF			(CCA_EXPIRED && !channel_is_idle && csma_parameters.nb_backoff <= csma_parameters.max_backoff)   u#define		END_OF_CCA				(CCA_EXPIRED && (channel_is_idle || csma_parameters.nb_backoff > csma_parameters.max_backoff))   `#define		SECOND_CCA_REQ			(my_parameters->slotted_enable && lr_wpan_beacon_param.second_cca_req)   ;#define		BACK_TO_CCA				(channel_is_idle && SECOND_CCA_REQ)   e#define		BACK_TO_IDLE			(INTRPT_SELF && (intrpt_code == Ack_Time_Out || intrpt_code == Ack_Received))   q#define		END_OF_TRANSMISSION		(channel_flag.data_is_sending && INTRPT_SELF && intrpt_code == End_Of_Transmission)   C#define		ACKNOWLEDGEMENT			(END_OF_TRANSMISSION && Rx_Ack_Expected)   =#define		NO_ACK					(END_OF_TRANSMISSION && !Rx_Ack_Expected)   p#define		TIME_TO_TRANSMIT		(!Tx_Ack_Require && !Rx_Ack_Expected && channel_flag.tx_idle && !END_OF_TRANSMISSION)   F#define		BOUNDARY_REACHED		(INTRPT_SELF && intrpt_code == Wpan_Tx_TAT)           /* function prototypes */   &static void 		lr_wpan_mac_init (void);   1static void			lr_wpan_model_wide_register (void);   1static void 		lr_wpan_mac_address_resolve (void);   :static void			lr_wpan_schedule_TAT (TxRx_Management code);   8static void			lr_wpan_cancel_TAT (TxRx_Management code);   &static void			lr_wpan_cca_init (void);   )static void 		lr_wpan_mac_backoff (void);   =static void 		lr_wpan_intrpt_check (const char * state_name);   -static void			lr_wpan_generate_beacon (void);   3static void			lr_wpan_generate_data_request (void);   +static void 		higher_layer_pkt_recv (void);   )static void 		lower_layer_pkt_rcv (void);   -static void			unacknowledgement_reset (void);   0static void 		lr_wpan_packet_to_transmit (void);   -static void			lr_wpan_ack_to_transmit (void);   Nstatic void 		lr_wpan_debug_state_msg (const char * state_name, Boolean exit);   3static void			lr_wpan_drop_higher_layer_pkt (void);   3static int			lr_wpan_destroy_retransmission (void);   )static void 		lr_wpan_print_queue (void);   Bstatic int			lr_wpan_get_beacon_size (Addressing_Field * address);   Gstatic void 		lr_wpan_enqueue_packet (int mac_address, Packet * pkptr);   Pstatic Wpan_Queue * lr_wpan_allocate_subqueue (int mac_address, Packet * pkptr);   .//static void		lr_wpan_subq_allocation (void);   +static void			lr_wpan_subq_checking (void);   4static int 			lr_wpan_get_rx_seqn (int mac_address);   >static void 		lr_wpan_set_rx_seqn (int mac_address, int seqn);   *static void 		lr_wpan_collect_stat (void);  q   /*    * Function:	lr_wpan_init    *   & * Description:	initialize the process   6 *				read the attributes and set the global variables    *    * No parameters    */       static void lr_wpan_mac_init ()   {   	Objid csma_parameters_comp_id;   	Objid csma_parameters_id;   	int mac_address, index_wpan;   	int channel_number;   	char buffer[64];   	char proc_model_name[64];   	   	char error_message[256];   	Wpan_Node_Param * element;   	   	   	FIN (lr_wpan_mac_init ());       	/* memory allocation */   Q	my_parameters	= (Wpan_Node_Param *) op_prg_mem_alloc (sizeof (Wpan_Node_Param));   	   (	/* initialize the wpan queue to NULL */   	wpan_queue = NULL;   	current_queue = NULL;   	   	/* set the type of the node */   &	strcpy (my_parameters->type, "wpan");   	    	/* get the ID of this module */   &	my_parameters->objid = op_id_self ();       	/* get the ID of the node */   B	my_parameters->parent_id = op_topo_parent (my_parameters->objid);       2	/* get the channel number for the 2.4 GHz band */   H	op_ima_obj_attr_get (my_parameters->objid, "Channel", &channel_number);   	   (	/* get the power of the transmission */   L	op_ima_obj_attr_get (my_parameters->objid, "Power", &my_parameters->power);   	   <	/* compute the center frequency for the channel selected */   @	wpan_frequency_center = WPAN_FREQUENCY_CENTER (channel_number);   7	my_parameters->frequency_wpan = wpan_frequency_center;   	   	/* get the type of source */   N	op_ima_obj_attr_get (my_parameters->objid, "Source Type", &bulk_data_source);   	   )	/* get the Acknowledgemnent attribute */   X	op_ima_obj_attr_get (my_parameters->objid, "Acknowledgement", &Acknowledgement_Enable);   	   '	/* get the Channel Access attribute */   ^	op_ima_obj_attr_get (my_parameters->objid, "Channel Access", &my_parameters->slotted_enable);   S	op_ima_obj_attr_get (my_parameters->objid, "Mode", &my_parameters->master_enable);   	   	/* get the CSMA-CA settings */   W	op_ima_obj_attr_get (my_parameters->objid, "CSMA-CA Parameters", &csma_parameters_id);   V	csma_parameters_comp_id = op_topo_child (csma_parameters_id, OPC_OBJTYPE_GENERIC, 0);   	   g	op_ima_obj_attr_get (csma_parameters_comp_id, "Maximum backoff number", &csma_parameters.max_backoff);   d	op_ima_obj_attr_get (csma_parameters_comp_id, "Minimum backoff exponent", &csma_parameters.min_BE);   e	op_ima_obj_attr_get (csma_parameters_comp_id, "Maximum backoff exponent", &csma_parameters.max_BE);	   	   +	/* get the maximum transmission retries */   ^	op_ima_obj_attr_get (my_parameters->objid, "Nb of transmission retries", &max_frame_retries);   	   2	/* get the channel number for the 2.4 GHz band */   S	op_ima_obj_attr_get (my_parameters->objid, "Group number", &my_parameters->group);   	   #	/* get the position of the node */   Q	op_ima_obj_attr_get (my_parameters->parent_id, "x position", &my_parameters->x);   Q	op_ima_obj_attr_get (my_parameters->parent_id, "y position", &my_parameters->y);       	/* get the name of the node */   H	op_ima_obj_attr_get_str (my_parameters->parent_id, "name", 64, buffer);   	   W	lr_wpan_node_name = (char *) op_prg_mem_alloc ((strlen (buffer) + 1) * sizeof (char));   $	strcpy (lr_wpan_node_name, buffer);   		   (	/* get the name of the process model */   N	op_ima_obj_attr_get (my_parameters->objid, "process model", proc_model_name);   	   &	/* get the MAC address of the node */   E	op_ima_obj_attr_get (my_parameters->objid, "Address", &mac_address);   	   	if (bulk_data_source)   		{   		/* check the MAC address */   		if (mac_address == -2)   			{   .			/* if the mac address is "auto assigned" */   ,			mac_address = (int) my_parameters->objid;   			}   +		else if (wpan_node_param_list != OPC_NIL)   			{   			/*    7			* if the MAC address was set by the user, we have to   -			* check whether this address doesn't exist   			*/   			   B			if ((index_wpan = wpan_search_mac_address (mac_address)) != -1)   				{   3				/* get the element with the same MAC address */   D				element = op_prg_list_access (wpan_node_param_list, index_wpan);   				   #				/* get the name of this node */   R				op_ima_obj_attr_get_str (op_topo_parent (element->objid), "name", 64, buffer);   				    				/* edit the error message */   i				sprintf (error_message, "Check the MAC addresses of the nodes %s and %s", lr_wpan_node_name, buffer);   Y				lr_wpan_mac_error ("lr_wpan_init:", "The MAC address already exist.", error_message);   				}   			}   		}   	   	/* set the MAC address */   *	my_parameters->mac_address = mac_address;   	   %	/* initialize the CCA requirement */   ,	my_parameters->cca_requirement = OPC_FALSE;   	   !	/* Set the WLAN field to NULL */   !	my_parameters->wlan_info = NULL;   		   1	/* initialize the node list if it is not done */   %	if (wpan_node_param_list == OPC_NIL)   /		wpan_node_param_list = op_prg_list_create ();   	   &	/* register the node into the list */   L	op_prg_list_insert (wpan_node_param_list, my_parameters, OPC_LISTPOS_TAIL);   	   !	/* set the backoff parameters */   -	csma_parameters.Be = csma_parameters.min_BE;    	csma_parameters.nb_backoff = 0;   	   	    	/* statistic initializations */   `	nb_pkt_subq = op_stat_reg ("subqueues.Number of packets", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);   T	nb_pkt_send = op_stat_reg ("mac.Packet sent", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);   X	nb_pkt_recv = op_stat_reg ("mac.Packet received", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);   	   	/* initialize variables */   "	retransmission_ptr 				= OPC_NIL;   !	Rx_Ack_Expected 				= OPC_FALSE;   !	Tx_Ack_Require 					= OPC_FALSE;   /	Mac_Data_Tx_Seqn 				= rand () % MAX_MAC_SEQN;   	Mac_Beacon_Tx_Seqn				= 0;   .	Mac_Data_Rx_Seqn 				= op_prg_list_create ();   $	channel_flag.tx_idle 			= OPC_TRUE;   $	channel_flag.rx_idle 			= OPC_TRUE;   %	channel_flag.LIFS_on 			= OPC_FALSE;   *	channel_flag.data_is_sending	= OPC_FALSE;   *	wpan_transmission_required 		= OPC_FALSE;   	nb_transmission_retries 		= 0;   	   	/* beacon variables */   '	lr_wpan_beacon_param.stop_time		= 0.0;   (	lr_wpan_beacon_param.nb_addresses 	= 0;   )	lr_wpan_beacon_param.addr_table 	= NULL;   .	lr_wpan_beacon_param.beacon_rcvd	= OPC_FALSE;   0	lr_wpan_beacon_param.data_req_rcvd	= OPC_FALSE;   1	lr_wpan_beacon_param.second_cca_req = OPC_FALSE;   (	lr_wpan_beacon_param.master_addr 	= -1;   .	lr_wpan_beacon_param.data_request 	= OPC_NIL;   	    	/* initialize the statistics */   	statistic.Data_Pkt_Rcv 		= 0;   !	statistic.Segment_generated = 0;   	statistic.Data_Pkt_Sent 	= 0;   	statistic.Ack_Pkt_Rcv 		= 0;   	statistic.Ack_Pkt_Sent 		= 0;   	statistic.Pkt_Lost 			= 0;   	statistic.Pkt_Collided		= 0;   	statistic.Pkt_Noise			= 0;   	statistic.Pkt_Dropped		= 0;   	statistic.Segment_Dropped	= 0;   	statistic.Retransmission 	= 0;   	statistic.Nb_Time_Out 		= 0;   "	statistic.Total_MAC_Delay 	= 0.0;   	statistic.tcp_HL_pkt_sent	= 0;   	statistic.tcp_HL_bit_sent	= 0;   	statistic.tcp_HL_pkt_rcvd	= 0;   	statistic.tcp_HL_bit_rcvd	= 0;   	statistic.Data_Req_Send 	= 0;   	statistic.total_backoff		= 0;   #	statistic.total_backoff_time= 0.0;   	   '	/* print information about the node */   ?	printf ("+-----------------------------------------------\n");   =	printf ("| MAC layer of the node %s:\n", lr_wpan_node_name);   M	printf ("| \tposition: (%.1f, %.1f)\n", my_parameters->x, my_parameters->y);   	printf ("| \tGroup: %d; MAC address: %s%d\n", my_parameters->group, (my_parameters->mac_address == -2)?"Auto Assigned, ":"", my_parameters->mac_address);   	printf ("| \tChannel Access: %s (%s)\n", (my_parameters->slotted_enable) ? "Slotted" : "Unslotted", (my_parameters->master_enable) ? "Master" : "Slave");   6	printf ("| \tFirst TX Seqn: %d\n", Mac_Data_Tx_Seqn);   M	printf ("| \tAcknowledgement: %s\n", Acknowledgement_Enable ? "On" : "Off");   	printf ("| Status:\n");   N	printf ("| \tMaximum number of backoff:\t%d\n", csma_parameters.max_backoff);   H	printf ("| \tMinimum backoff exponent:\t%d\n", csma_parameters.min_BE);   H	printf ("| \tMaximum backoff exponent:\t%d\n", csma_parameters.max_BE);   ?	printf ("+-----------------------------------------------\n");       	   	FOUT;   }           /*   ( * Function:	lr_wpan_model_wide_register    *   8 * Description:	initialize the MAC layer with the TCP/IP    *				stack if any    */       .static void	lr_wpan_model_wide_register (void)   {   	Prohandle own_prohandle;   	char proc_model_name[64];   	   	FIN (lr_wpan_tcp_ip_init ());   	   #	/* Obtain the process prohandle */    	own_prohandle = op_pro_self ();   	   %	/* Obatin the name of the process */   N	op_ima_obj_attr_get (my_parameters->objid, "process model", proc_model_name);   	   ;	/* Register this MAC process in the model wide registry */   -	own_process_record_handle = (OmsT_Pr_Handle)   k		oms_pr_process_register (my_parameters->parent_id, my_parameters->objid, own_prohandle, proc_model_name);   	   	/*   @	 * obtain  the address handle assigned to this node. The string   <	 * "MAC addresses" rendez-vous with other MACs to guarantee   =	 * unique addresses across all MAC types. The OMS_AA package   	 * handles this feature.   	 */   H	oms_aa_handle = oms_aa_address_handle_get ("MAC Addresses", "Address");   	   	   	FOUT;   }           /*    * Function:    */       .static void lr_wpan_mac_address_resolve (void)   {   	Objid subnet_objid;   	int mac_address;   	   &	FIN (lr_wpan_mac_address_resolve ());   	   *	mac_address = my_parameters->mac_address;   	   #	/* Obtain the subnet identifier */   :	subnet_objid = op_topo_parent (my_parameters->parent_id);   	   	/*   7	 * Perform auto-addressing for the MAC address. Appart   5	 * from dynamically addresses, if atau-assigned, the   6	 * address resolution function also detects duplicate   3	 * static assignments. By default, each address is   8	 * considered as being a valid destination unless it is   	 * explicitly set.   	 */   L	oms_aa_address_resolve (oms_aa_handle, my_parameters->objid, &mac_address);   	   ,	/* update the parameter of the MAC layer */   *	my_parameters->mac_address = mac_address;   	   	/*   2	 * Register station's MAC address into model-wide   9	 * registery, since the address assignment is final now.   	 */   ,	oms_pr_attr_set (own_process_record_handle,   )		"protocol",				OMSC_PR_STRING,			"mac",   2		"mac_type",				OMSC_PR_STRING,			"wireless_pan",   *		"subprotocol", 			OMSC_PR_NUMBER,			0.0,   /		"subnetid",				OMSC_PR_OBJID,			subnet_objid,   8		"address", 				OMSC_PR_NUMBER, 		(double) mac_address,   9		"auto address handle",	OMSC_PR_ADDRESS,		oms_aa_handle,   		OPC_NIL);   	   	FOUT;   }       /*   ! * Function:	lr_wpan_schedule_TAT    *   2 * Description:	schedule the next turn around time    *   
 * ParamIn:		    */       7static void lr_wpan_schedule_TAT (TxRx_Management code)   {   #	FIN (lr_wpan_schedule_TAT (code));   	   7	/* check if a Turn Around time was already schedule */   	lr_wpan_cancel_TAT (code);   	   	if (code == TX_CODE)   b		TAT_TX_Evhandle = op_intrpt_schedule_self (op_sim_time () + WPAN_TURN_AROUND_TIME, Wpan_Tx_TAT);   	   	if (code == RX_CODE)   b		TAT_RX_Evhandle = op_intrpt_schedule_self (op_sim_time () + WPAN_TURN_AROUND_TIME, Wpan_Rx_TAT);   	   	FOUT;   }       /*    */   5static void lr_wpan_cancel_TAT (TxRx_Management code)   {   !	FIN (lr_wpan_cancel_TAT (code));   	   ?	/* check the channel according to the Tx RX management code */   [	if ((code == RX_CODE || code == TXRX_CODE) && op_ev_valid (TAT_RX_Evhandle) == OPC_TRUE &&   <		op_ev_id (TAT_RX_Evhandle) != op_ev_id (op_ev_current ()))   !		op_ev_cancel (TAT_RX_Evhandle);   	   [	if ((code == TX_CODE || code == TXRX_CODE) && op_ev_valid (TAT_TX_Evhandle) == OPC_TRUE &&   <		op_ev_id (TAT_TX_Evhandle) != op_ev_id (op_ev_current ()))   !		op_ev_cancel (TAT_TX_Evhandle);   	   	FOUT;   }           /*    * Function:	lr_wpan_cca_init    */       #static void lr_wpan_cca_init (void)   {    	Buff_Info_Packet * info_packet;   	Boolean 			temp;   	   	FIN (lr_wpan_cca_init ());   	   #	/* Update the number of backoff */   	csma_parameters.nb_backoff ++;       "	/* update the backoff exponent */   K	csma_parameters.Be = min (csma_parameters.Be + 1, csma_parameters.max_BE);   	   	/* perform the CCA */   +	my_parameters->cca_requirement = OPC_TRUE;   	   #	/* set the time out for the CCA */   O	op_intrpt_schedule_self (op_sim_time () + WPAN_CCA_PERIOD, Wpan_CCA_Time_Out);   	   	/* set TX to busy */   "	channel_flag.tx_idle = OPC_FALSE;   	   7	/* cancel any Turn Around time scheduled for the TX */   	lr_wpan_cancel_TAT (TX_CODE);   	   #	/* check if the channel is idle */   	if (wpan_cca_all_pkt_types)   1		channel_is_idle = (channel_buffer_ptr == NULL);   	else   		{   		/*   L		 * in the case we only check the WPAN packets, we search for a WPAN packet   B		 * in the channel buffer and if we find one, the channel is busy   		 */   		temp = OPC_TRUE;   		   #		info_packet = channel_buffer_ptr;   				   		while (info_packet != NULL)   			{   m			if (info_packet->packet_type == WPAN_PKT_TYPE && info_packet->frequency == my_parameters->frequency_wpan )   				{   				temp = OPC_FALSE;   				info_packet = NULL;		   				}   			else   				{   +				info_packet = info_packet->next_packet;   				}   			}   W		/* check the channel: if the info_packet pointer is null, the channel will be idle */   		channel_is_idle = temp;	   		}   		   	FOUT;   }           /*     * Function:	lr_wpan_mac_backoff    *    * description:	    *    * No parameters    */       "static void lr_wpan_mac_backoff ()   {   		int		cw;   	int		backoff_unit;   	double 	backoff_time;   	   	   	FIN (lr_wpan_mac_backoff ());   		   &	/* compute the backoff time period */   =	cw = (int) (01<<csma_parameters.Be) - 1; // compute 2^be - 1   -	backoff_unit = floor (op_dist_uniform (cw));   	   j	backoff_time = (double) backoff_unit * LR_WPAN_BACKOFF_UNIT; // multiply by the unit time for the backoff   &	// compute average backoff per packet   %	if (csma_parameters.nb_backoff == 0)   		{   		statistic.total_backoff ++;   		}   	   .	statistic.total_backoff_time += backoff_time;       	/* set the backoff timer */   #	if (my_parameters->slotted_enable)   		{   I		/* if we are in a slotted mode, we start the backoff at the boundary */   ^		op_intrpt_schedule_self (lr_wpan_slotted_boundary_time () + backoff_time, Backoff_Time_Out);   		}   	else   		{   L		/* if we are in unslotted mode, we start the backoff at the curent time */   L		op_intrpt_schedule_self (op_sim_time () + backoff_time, Backoff_Time_Out);   		}   	    	   	FOUT;   }           :static void lr_wpan_intrpt_check (const char * state_name)   {   (	char odb_msg[128]; // debugging message   	   	   	FIN (lr_wpan_intrpt_check ());   		   $	/* compute the debugging message */   :	sprintf (odb_msg, "exit the \"%s\" state: ", state_name);   	FLAG_ODB_PRINTING;   	   &	/* get the type of the interuption */   )	switch (intrpt_type = op_intrpt_type ())   		{   		case OPC_INTRPT_SELF:   		case OPC_INTRPT_REMOTE:   *		switch (intrpt_code = op_intrpt_code ())   			{   			case Backoff_Time_Out:   '			strcat (odb_msg, "backoff expired");   				break;   				   			case Data_Pkt_To_Send:   -			strcat (odb_msg, "transmission required");   			   			/* set the flag */   )			wpan_transmission_required = OPC_TRUE;   				break;   			   			case Ack_Time_Out:   *			strcat (odb_msg, "Ack period expired");   			   =			/* if the time is out, we reset the acknowledgment flag */   			Rx_Ack_Expected = OPC_FALSE;   			   			/* update the statistic */   			(statistic.Nb_Time_Out)++;   				break;   			   			case Ack_Received:   '			strcat (odb_msg, "Received an Ack");   			    			/* turn on the LIFS period */   #			channel_flag.LIFS_on = OPC_TRUE;   	   ,			/* schedule when the LIFS will be over */   Q			op_intrpt_schedule_self (op_sim_time () + WPAN_LIFS_DURATION, Wpan_LIFS_Over);   			   :			/* canceled the Ack Time out if it is still schedule */   8			if (op_ev_valid (Ack_TimeOut_Evhandle) == OPC_TRUE &&   B				op_ev_id (Ack_TimeOut_Evhandle) != op_ev_id (op_ev_current()))   (				op_ev_cancel (Ack_TimeOut_Evhandle);   				break;   			   			case Wpan_Ack_Tx_Required:   '			strcat (odb_msg, "Transmit an Ack");   			   			   				break;   			   			case End_Of_Transmission:   /			strcat (odb_msg, "End of the transmission");   			   			/* set the TX to idle */   #			channel_flag.tx_idle = OPC_TRUE;   						   6			/* schedule the release of RX (Turn Around Time) */   "			lr_wpan_schedule_TAT (RX_CODE);   				break;   			   			case CCA_Pkt_Detect:   7			strcat (odb_msg, "Packet detecting during the CCA");   			    			/* set the channel to busy */   			channel_is_idle = OPC_FALSE;   				break;   			   			case Wpan_CCA_Time_Out:   #			strcat (odb_msg, "CCA is over");   			   6			/* schedule the release of TX (Turn Around Time) */   "			lr_wpan_schedule_TAT (TX_CODE);   			   			/* end the CCA */   .			my_parameters->cca_requirement = OPC_FALSE;   			   			/*   >			 * if we are in a slotted mode, we need to switch the flag    			 * for the second cca   			 */   %			if (my_parameters->slotted_enable)   g				lr_wpan_beacon_param.second_cca_req = (lr_wpan_beacon_param.second_cca_req) ? OPC_FALSE : OPC_TRUE;   				break;   			   			case Wpan_Rcv_Pkt:   0			strcat (odb_msg, "We're receiving a packet");   			   			/* turn off the TX */   $			channel_flag.tx_idle = OPC_FALSE;   			   8			/* if a turn around time is schedule, we cancel it */    			lr_wpan_cancel_TAT (TX_CODE);   				break;   			   			case Wpan_Rx_TAT:   ?			strcat (odb_msg, "End of the Turn Around Time, Rx is idle");   			   			/* set the RX to idle */   &			channel_flag.rx_idle    = OPC_TRUE;   				break;   			   			case Wpan_Tx_TAT:   ?			strcat (odb_msg, "End of the Turn Around Time, Tx is idle");   			   			/* set the TX to idle */   #			channel_flag.tx_idle = OPC_TRUE;   			   0			/* we check whether we need to send an Ack */   			if (Tx_Ack_Require)   				{   $				/* transmit an acknowledgment */   				lr_wpan_ack_to_transmit ();   				   "				/* complete the ODB message */   -				strcat (odb_msg, "; send an acknoledge");   				   				/* turn off the flag */   				Tx_Ack_Require = OPC_FALSE;   				}   				break;   			   			case Wpan_LIFS_Over:   :			strcat (odb_msg, "End of the LIFS period, Tx is idle");   			   !			/* turn off the LIFS Period */   $			channel_flag.LIFS_on = OPC_FALSE;   				break;   			   			case Wpan_Beacon_To_Send:   4			/* we generate and send a beacon on broadcast */\   			lr_wpan_generate_beacon ();   				break;   			   			case Wpan_Data_Req_To_Send:   #			/* we generate a data request */   %			lr_wpan_generate_data_request ();	   				break;   			   			default:   $			strcat (odb_msg, "unknown code");   				break;   			}   		break;   			   		case OPC_INTRPT_STRM:   ,		switch (intrpt_stream = op_intrpt_strm ())   			{   			case HIGHER_LAYER_DOWN_STRM:   3			/* we received a packet from the higher layer */   			higher_layer_pkt_recv ();   				   4			strcat (odb_msg, "packet from the higher layer");   				break;   				   			case LOWER_LAYER_UP_STRM:   K			strcat (odb_msg, "packet from the physical layer: reception completed");   			   .			/* we received a packet from the channel */   			lower_layer_pkt_rcv ();   			   6			/* schedule the release of TX (Turn Around Time) */   "			lr_wpan_schedule_TAT (TX_CODE);   				break;   				   			default:   &			strcat (odb_msg, "unknown stream");   				break;   			}   		break;   		   			   		case OPC_INTRPT_ENDSIM:   		lr_wpan_collect_stat ();   		break;   		   
		default:   %		strcat (odb_msg, "unknown intrpt");   		break;   		}   	   "	/* print the debugging message */   $	ENTER_STATE_ODB_PRINTING (odb_msg);   	FLAG_ODB_PRINTING;   	   	/* define a break point */    	op_prg_odb_bkpt ("wpan_state");   	FOUT;   }           /*   $ * Function:	lr_wpan_generate_beacon    *   5 * Description:	create a Beacon packet and send it in   * *				Broadcast to the devices in the same    *				group    *    * No parameters    */       static void    lr_wpan_generate_beacon (void)   {   	Packet * beacon_ptr;   	Addressing_Field * address;   	int i; // loop variables   	int beacon_size, rx_index;   	double txrx_distance;   	Wpan_Node_Param * rxptr;   	Ici * ici_ptr;   	   	   "	FIN (lr_wpan_generate_beacon ());   	   	   	/* debugging */   :	ENTER_STATE_ODB_PRINTING ("Generate the beacon packet.");   	   6	/* Check if the MAC address table has been created */   ,	if (lr_wpan_beacon_param.nb_addresses == 0)   Q		lr_wpan_mac_error ("lr_wpan_generate_beacon:", "No connexion found.", OPC_NIL);   	   >	/* for each device in the group, we create a beacon packet */   4	for (i=0; i<lr_wpan_beacon_param.nb_addresses; i++)   		{   		/* init the pointer */   		address = NULL;   		beacon_ptr = OPC_NIL;   		   		/* create a Beacon packet */   3		beacon_ptr = op_pk_create_fmt ("lr_wpan_beacon");   	   3		/* create the address field and the frame Ctrl */   N		address = (Addressing_Field *) op_prg_mem_alloc (sizeof (Addressing_Field));   		   "		/* complete the address field */   1		address->src_addr = my_parameters->mac_address;   :		address->dest_addr = lr_wpan_beacon_param.addr_table[i];   		   &		/* compute the beacon packet size */   2		beacon_size = lr_wpan_get_beacon_size (address);       +		/* set the fields of the Beacon packet */   		if (op_pk_nfd_set (beacon_ptr, "Addressing field", address, op_prg_mem_copy_create, op_prg_mem_free, sizeof (Addressing_Field)) == OPC_COMPCODE_FAILURE ||   a			op_pk_nfd_set_dbl (beacon_ptr, "Sequence number", Mac_Beacon_Tx_Seqn) == OPC_COMPCODE_FAILURE)   _			lr_wpan_mac_error ("lr_wpan_generate_beacon:", "Unable to set the Beacon packet.", OPC_NIL);   	   "		/* set the size of the packet */   1		op_pk_total_size_set (beacon_ptr, beacon_size);   		   `		/* search the mac address in the list of node to get the parameters of the destination node */   F		if ((rx_index = wpan_search_mac_address (address->dest_addr)) == -1)   i			lr_wpan_mac_error ("lr_wpan_generate_beacon:", "The MAC destination address doesn't exist.", OPC_NIL);   	   3		/* get the parameter of the destination device */   R		rxptr = (Wpan_Node_Param *) op_prg_list_access (wpan_node_param_list, rx_index);       2		/* compute the distance between the RX and TX */   		txrx_distance = sqrt ((rxptr->x - my_parameters->x)*(rxptr->x - my_parameters->x) + (rxptr->y - my_parameters->y)*(rxptr->y - my_parameters->y));   		   $		/* initialize the ICI structure */   		ici_ptr = OPC_NIL;   		   		/* create ICI pointer */   *		ici_ptr = op_ici_create ("ici_channel");   			   		/* set the ICI pointer */   ^		if (op_ici_attr_set_dbl (ici_ptr, "txrx distance", txrx_distance) == OPC_COMPCODE_FAILURE ||   Y			op_ici_attr_set_dbl (ici_ptr, "bit rate", LR_WPAN_BIT_RATE) == OPC_COMPCODE_FAILURE ||   ]			op_ici_attr_set_dbl (ici_ptr, "channel", wpan_frequency_center) == OPC_COMPCODE_FAILURE ||   Z			op_ici_attr_set_dbl (ici_ptr, "power", my_parameters->power) == OPC_COMPCODE_FAILURE ||   [			op_ici_attr_set_int32 (ici_ptr, "packet type", WPAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||   a			op_ici_attr_set_int32 (ici_ptr, "dest address", address->dest_addr) == OPC_COMPCODE_FAILURE ||   U			op_ici_attr_set_dbl (ici_ptr, "Tx x", my_parameters->x) == OPC_COMPCODE_FAILURE ||   U			op_ici_attr_set_dbl (ici_ptr, "Tx y", my_parameters->y) == OPC_COMPCODE_FAILURE ||   M			op_ici_attr_set_dbl (ici_ptr, "Rx x", rxptr->x) == OPC_COMPCODE_FAILURE ||   K			op_ici_attr_set_dbl (ici_ptr, "Rx y", rxptr->y) == OPC_COMPCODE_FAILURE)   ]			lr_wpan_mac_error ("lr_wpan_generate_beacon:", "Unable to set the ICI pointer.", OPC_NIL);   		   8		/* Associate the ICI pointer with the beacon packet */   &		op_pk_ici_set (beacon_ptr, ici_ptr);   		   &		/* send the packet to the channel */   D		op_pk_deliver (beacon_ptr, wpan_channel_objid, CHANNEL_UP_STREAM);   		}   	   !	/* update the sequence number */   	Mac_Beacon_Tx_Seqn++;   $	Mac_Beacon_Tx_Seqn %= MAX_MAC_SEQN;   	   &	/* schedule the next Beacon packet */   `	//op_intrpt_schedule_self (op_sim_time () + LR_WPAN_BEACON_INTERVAL_TIME, Wpan_Beacon_To_Send);   	   	FOUT;   }   	       /*   * * Function:	lr_wpan_generate_data_request    *   8 * Description:	create a data request packet and send it   , *				to the master device in the same group    *    * ParamIn:		int dest_address   + *				MAC destination address of the master    */       static void   $lr_wpan_generate_data_request (void)   {   	Addressing_Field * address;   #	Frame_Ctrl_Field * ctrl_field_ptr;   	int rx_index;   	double txrx_distance;   	Wpan_Node_Param * rxptr;   	Ici * ici_ptr;   	   	   "	FIN (lr_wpan_generate_beacon ());   		   	/* debugging */   <	ENTER_STATE_ODB_PRINTING ("Create a data request packet.");   	   	/* init the pointer */   	address = NULL;   	ctrl_field_ptr = NULL;   		   #	/* create a data request packet */   F	lr_wpan_beacon_param.data_request = op_pk_create_fmt ("lr_wpan_mac");   	   2	/* create the address field and the frame Ctrl */   M	address = (Addressing_Field *) op_prg_mem_alloc (sizeof (Addressing_Field));   T	ctrl_field_ptr = (Frame_Ctrl_Field *) op_prg_mem_alloc (sizeof (Frame_Ctrl_Field));   		   !	/* complete the address field */   0	address->src_addr = my_parameters->mac_address;   7	address->dest_addr = lr_wpan_beacon_param.master_addr;   	   '	/* complete the frame control field */   2	ctrl_field_ptr->ack_req = Acknowledgement_Enable;   	   *	/* set the fields of the Beacon packet */   	if (op_pk_nfd_set (lr_wpan_beacon_param.data_request, "Addressing field", address, op_prg_mem_copy_create, op_prg_mem_free, sizeof (Addressing_Field)) == OPC_COMPCODE_FAILURE ||   		op_pk_nfd_set (lr_wpan_beacon_param.data_request, "Frame Ctrl", ctrl_field_ptr, op_prg_mem_copy_create, op_prg_mem_free, sizeof (Frame_Ctrl_Field)) == OPC_COMPCODE_FAILURE ||   `		op_pk_nfd_set_int32 (lr_wpan_beacon_param.data_request, "Request", 1) == OPC_COMPCODE_FAILURE)   j		lr_wpan_mac_error ("lr_wpan_generate_data_request:", "Unable to set the data request packet.", OPC_NIL);   		   !	/* set the size of the packet */   N	op_pk_total_size_set (lr_wpan_beacon_param.data_request, WPAN_DATA_REQ_SIZE);   	   _	/* search the mac address in the list of node to get the parameters of the destination node */   E	if ((rx_index = wpan_search_mac_address (address->dest_addr)) == -1)   n		lr_wpan_mac_error ("lr_wpan_generate_data_request:", "The MAC destination address doesn't exist.", OPC_NIL);   	   2	/* get the parameter of the destination device */   Q	rxptr = (Wpan_Node_Param *) op_prg_list_access (wpan_node_param_list, rx_index);   	   1	/* compute the distance between the RX and TX */   	txrx_distance = sqrt ((rxptr->x - my_parameters->x)*(rxptr->x - my_parameters->x) + (rxptr->y - my_parameters->y)*(rxptr->y - my_parameters->y));   	   #	/* initialize the ICI structure */   	ici_ptr = OPC_NIL;   	   	/* create ICI pointer */   )	ici_ptr = op_ici_create ("ici_channel");   			   	/* set the ICI pointer */   ]	if (op_ici_attr_set_dbl (ici_ptr, "txrx distance", txrx_distance) == OPC_COMPCODE_FAILURE ||   X		op_ici_attr_set_dbl (ici_ptr, "bit rate", LR_WPAN_BIT_RATE) == OPC_COMPCODE_FAILURE ||   \		op_ici_attr_set_dbl (ici_ptr, "channel", wpan_frequency_center) == OPC_COMPCODE_FAILURE ||   Y		op_ici_attr_set_dbl (ici_ptr, "power", my_parameters->power) == OPC_COMPCODE_FAILURE ||   Z		op_ici_attr_set_int32 (ici_ptr, "packet type", WPAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||   `		op_ici_attr_set_int32 (ici_ptr, "dest address", address->dest_addr) == OPC_COMPCODE_FAILURE ||   T		op_ici_attr_set_dbl (ici_ptr, "Tx x", my_parameters->x) == OPC_COMPCODE_FAILURE ||   T		op_ici_attr_set_dbl (ici_ptr, "Tx y", my_parameters->y) == OPC_COMPCODE_FAILURE ||   L		op_ici_attr_set_dbl (ici_ptr, "Rx x", rxptr->x) == OPC_COMPCODE_FAILURE ||   J		op_ici_attr_set_dbl (ici_ptr, "Rx y", rxptr->y) == OPC_COMPCODE_FAILURE)   \		lr_wpan_mac_error ("lr_wpan_generate_beacon:", "Unable to set the ICI pointer.", OPC_NIL);   		   7	/* Associate the ICI pointer with the beacon packet */   <	op_pk_ici_set (lr_wpan_beacon_param.data_request, ici_ptr);   		   	   	FOUT;   }           /*   " * Function:	higher_layer_pkt_recv    *   2 * Description:	receive the packet from the higher   ' *				layer and encapsulated the packet    *				into a MAC packet    *    * No parameter    */       static void    higher_layer_pkt_recv (void)   {   	Packet * pkptr;   	Packet * higher_layer_pkptr;   	int higher_layer_pksize;   	int last_pksize, pk_number;   ,	Addressing_Field * address, * address_copy;   6	Frame_Ctrl_Field * ctrl_field_ptr, * ctrl_field_copy;   	Wpan_Node_Param * rxptr;   	Ici * ici_ptr;   	int rx_index;   	double txrx_distance;   	int dest_mac_address;   	int i; // loop variable   	   	    	FIN (higher_layer_pkt_recv ());   	   %	/* get the packet from the stream */   0	higher_layer_pkptr = op_pk_get (intrpt_stream);   	   $	/* get the address of the packet */   	if (bulk_data_source)   		{   d		/* if the packet source is a simple source, we just get the destination address from the packet */   e		if (op_pk_nfd_get_int32 (higher_layer_pkptr, "Address", &dest_mac_address) == OPC_COMPCODE_FAILURE)   _			lr_wpan_mac_error ("higher_layer_pkt_recv:", "Unable to read the packet address.", OPC_NIL);   		}   	else   		{   [		/* if we have the TCP/IP stack, we get the address in the ICI attached with the packet */   8		/* Read ICI parameters at the stream interrupt.					*/   		ici_ptr = op_intrpt_ici ();       M		/* Retrieve destination address from the ici set by the interface layer.	*/   n		if (ici_ptr == OPC_NIL || op_ici_attr_get (ici_ptr, "dest_addr", &dest_mac_address) == OPC_COMPCODE_FAILURE)   			{    			/* Generate error message.	*/   ^			lr_wpan_mac_error ("higher_layer_pkt_recv:", "Destination address in not valid.", OPC_NIL);   			}   		   		/* update the statistics */   		statistic.tcp_HL_pkt_sent ++;   I		statistic.tcp_HL_bit_sent += op_pk_total_size_get (higher_layer_pkptr);   		}   	   	/* create address field */   M	address = (Addressing_Field *) op_prg_mem_alloc (sizeof (Addressing_Field));   	   !	/* complete the address field */   0	address->src_addr = my_parameters->mac_address;   '	address->dest_addr = dest_mac_address;   	   #	/* Create a frame control field */   T	ctrl_field_ptr = (Frame_Ctrl_Field *) op_prg_mem_alloc (sizeof (Frame_Ctrl_Field));   	   '	/* complete the frame control field */   2	ctrl_field_ptr->ack_req = Acknowledgement_Enable;   	   C	if ((rx_index = wpan_search_mac_address (dest_mac_address)) == -1)   f		lr_wpan_mac_error ("higher_layer_pkt_recv:", "The MAC destination address doesn't exist.", OPC_NIL);   	   2	/* get the parameter of the destination device */   Q	rxptr = (Wpan_Node_Param *) op_prg_list_access (wpan_node_param_list, rx_index);       1	/* compute the distance between the RX and TX */   	txrx_distance = sqrt ((rxptr->x - my_parameters->x)*(rxptr->x - my_parameters->x) + (rxptr->y - my_parameters->y)*(rxptr->y - my_parameters->y));       2	/* compute the size of the higher layer packet */   G	higher_layer_pksize = (int) op_pk_total_size_get (higher_layer_pkptr);   	/* start the segmentation */   1	if (higher_layer_pksize > WPAN_PAYLOAD_MAX_SIZE)   		{   $		/* dimension of the last packet */   :		last_pksize = higher_layer_pksize%WPAN_PAYLOAD_MAX_SIZE;   		   $		/* compute the number of packet */   H		pk_number = (higher_layer_pksize - last_pksize)/WPAN_PAYLOAD_MAX_SIZE;   		}   	else   		{   		pk_number = 0;   $		last_pksize = higher_layer_pksize;   		}   	   	/*    M	 * if the last packet size is null, we decrease the number of packets by one   L	 * to be able to create the last packet with the address of the real packet   	 */   	if (last_pksize == 0)   		{    		/* decrease the loop number */   		pk_number--;   		   C		/* the last packet size will be equal to WPAN_PAYLOAD_MAX_SIZE */   &		last_pksize = WPAN_PAYLOAD_MAX_SIZE;   		}   	   	for (i=0; i<pk_number; i++)   		{   $		/* initialize the ICI structure */   		ici_ptr = OPC_NIL;   		   		/* create ICI pointer */   *		ici_ptr = op_ici_create ("ici_channel");   			   		/* set the ICI pointer */   ^		if (op_ici_attr_set_dbl (ici_ptr, "txrx distance", txrx_distance) == OPC_COMPCODE_FAILURE ||   Y			op_ici_attr_set_dbl (ici_ptr, "bit rate", LR_WPAN_BIT_RATE) == OPC_COMPCODE_FAILURE ||   ]			op_ici_attr_set_dbl (ici_ptr, "channel", wpan_frequency_center) == OPC_COMPCODE_FAILURE ||   Z			op_ici_attr_set_dbl (ici_ptr, "power", my_parameters->power) == OPC_COMPCODE_FAILURE ||   [			op_ici_attr_set_int32 (ici_ptr, "packet type", WPAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||   _			op_ici_attr_set_int32 (ici_ptr, "dest address", dest_mac_address) == OPC_COMPCODE_FAILURE ||   U			op_ici_attr_set_dbl (ici_ptr, "Tx x", my_parameters->x) == OPC_COMPCODE_FAILURE ||   U			op_ici_attr_set_dbl (ici_ptr, "Tx y", my_parameters->y) == OPC_COMPCODE_FAILURE ||   M			op_ici_attr_set_dbl (ici_ptr, "Rx x", rxptr->x) == OPC_COMPCODE_FAILURE ||   K			op_ici_attr_set_dbl (ici_ptr, "Rx y", rxptr->y) == OPC_COMPCODE_FAILURE)   [			lr_wpan_mac_error ("higher_layer_pkt_recv:", "Unable to set the ICI pointer.", OPC_NIL);   		   		/* create a MAC packet */   +		pkptr = op_pk_create_fmt ("lr_wpan_mac");   		   1		/* copy the address field and the frame Ctrl */   b		address_copy = (Addressing_Field *) op_prg_mem_copy_create (address, sizeof (Addressing_Field));   l		ctrl_field_copy = (Frame_Ctrl_Field *) op_prg_mem_copy_create (ctrl_field_ptr, sizeof (Frame_Ctrl_Field));   		   (		/* set the fields of the MAC packet */   		if (op_pk_nfd_set (pkptr, "Frame Ctrl", ctrl_field_copy, op_prg_mem_copy_create, op_prg_mem_free, sizeof (Frame_Ctrl_Field)) == OPC_COMPCODE_FAILURE ||   			op_pk_nfd_set (pkptr, "Addressing field", address_copy, op_prg_mem_copy_create, op_prg_mem_free, sizeof (Addressing_Field)) == OPC_COMPCODE_FAILURE)   Z			lr_wpan_mac_error ("higher_layer_pkt_recv:", "Unable to set the MAC packet.", OPC_NIL);   		   "		/* set the size of the packet */   2		op_pk_total_size_set (pkptr, WPAN_MAC_MAX_SIZE);   		   2		/* Associate the ICI pointer with this packet */   !		op_pk_ici_set (pkptr, ici_ptr);   				   		/* enqueue the packet */   3		lr_wpan_enqueue_packet (dest_mac_address, pkptr);   		}   	   O	/* we create the last packet with a pointer to the real higher layer packet */   #	/* initialize the ICI structure */   	ici_ptr = OPC_NIL;   		   	/* create ICI pointer */   )	ici_ptr = op_ici_create ("ici_channel");   	   	/* set the ICI pointer */   ]	if (op_ici_attr_set_dbl (ici_ptr, "txrx distance", txrx_distance) == OPC_COMPCODE_FAILURE ||   X		op_ici_attr_set_dbl (ici_ptr, "bit rate", LR_WPAN_BIT_RATE) == OPC_COMPCODE_FAILURE ||   \		op_ici_attr_set_dbl (ici_ptr, "channel", wpan_frequency_center) == OPC_COMPCODE_FAILURE ||   Y		op_ici_attr_set_dbl (ici_ptr, "power", my_parameters->power) == OPC_COMPCODE_FAILURE ||   Z		op_ici_attr_set_int32 (ici_ptr, "packet type", WPAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||   `		op_ici_attr_set_int32 (ici_ptr, "dest address", address->dest_addr) == OPC_COMPCODE_FAILURE ||   T		op_ici_attr_set_dbl (ici_ptr, "Tx x", my_parameters->x) == OPC_COMPCODE_FAILURE ||   T		op_ici_attr_set_dbl (ici_ptr, "Tx y", my_parameters->y) == OPC_COMPCODE_FAILURE ||   L		op_ici_attr_set_dbl (ici_ptr, "Rx x", rxptr->x) == OPC_COMPCODE_FAILURE ||   J		op_ici_attr_set_dbl (ici_ptr, "Rx y", rxptr->y) == OPC_COMPCODE_FAILURE)   Z		lr_wpan_mac_error ("higher_layer_pkt_recv:", "Unable to set the ICI pointer.", OPC_NIL);   		   	/* create a MAC packet */   *	pkptr = op_pk_create_fmt ("lr_wpan_mac");   	   '	/* set the fields of the MAC packet */   N	if (op_pk_nfd_set_int32 (pkptr, "Segmentation", 1) == OPC_COMPCODE_FAILURE ||   ^		op_pk_nfd_set_pkt (pkptr, "Higher Layer Pkt", higher_layer_pkptr) == OPC_COMPCODE_FAILURE ||   		op_pk_nfd_set (pkptr, "Frame Ctrl", ctrl_field_ptr, op_prg_mem_copy_create, op_prg_mem_free, sizeof (Frame_Ctrl_Field)) == OPC_COMPCODE_FAILURE ||   		op_pk_nfd_set (pkptr, "Addressing field", address, op_prg_mem_copy_create, op_prg_mem_free, sizeof (Addressing_Field)) == OPC_COMPCODE_FAILURE)   Y		lr_wpan_mac_error ("higher_layer_pkt_recv:", "Unable to set the MAC packet.", OPC_NIL);   	   !	/* set the size of the packet */   >	op_pk_total_size_set (pkptr, last_pksize + WPAN_HEADER_SIZE);   	   1	/* Associate the ICI pointer with this packet */    	op_pk_ici_set (pkptr, ici_ptr);   		   	/* enqueue the packet */   2	lr_wpan_enqueue_packet (dest_mac_address, pkptr);   	   	   	FOUT;   }               /*     * Function:	lower_layer_pkt_rcv    *   0 * description:	Received all the packet from the    *				lower layer    *    * No Parameter    */       static void   lower_layer_pkt_rcv (void)   {   ,	Packet * pkptr, *higher_layer_pkptr = NULL;   	char format[32];   	Addressing_Field * addr_field;   #	Frame_Ctrl_Field * frame_ctrl_ptr;   	int last_packet;   
	int seqn;   	int accept;   	int noise;   	Ici * ici_ptr;   	//int wpan_bulk_data_id;   	   	   	FIN (lower_layer_pkt_rcv ());   	   %	/* get the packet from the stream */   #	pkptr = op_pk_get (intrpt_stream);   		   	/* get the accept flag */   0	op_pk_nfd_get_int32 (pkptr, "Accept", &accept);   	   	/* get the noise flag */   .	op_pk_nfd_get_int32 (pkptr, "Noise", &noise);   '	//printf("noise flag is %d\n", noise);   	   #	/* get the format of the packet */   	op_pk_format (pkptr, format);   	   	/*    =	* if this is a WPAN MAC data packet, check if a higher layer   	* is in there   	*/   %	if (!strcmp (format, "lr_wpan_mac"))   		{   D		/* get the higher layer packet if the segmentation flag is true */   <		op_pk_nfd_get_int32 (pkptr, "Segmentation", &last_packet);   		   		if (last_packet)   			{   			/*   *			* if this is the last segment received,   #			* we get the higher layer packet   			*/   F			op_pk_nfd_get_pkt (pkptr, "Higher Layer Pkt", &higher_layer_pkptr);   			}   		}   	   V	/* if the RX flag is not idle or the packet is not accepted, we discard the packet */   /	if (!channel_flag.rx_idle || !accept || noise)   		{   		/* debugging */   		if (!channel_flag.rx_idle)   			{   ;			ENTER_STATE_ODB_PRINTING ("packet is  collided or bad");   			(statistic.Pkt_Collided)++;   			}   		else if (noise)   			{   >			ENTER_STATE_ODB_PRINTING ("packet is considered as noise");   			(statistic.Pkt_Noise)++;   			}   		else if (!accept)   			{   C			ENTER_STATE_ODB_PRINTING ("packet is lost due to interference");   			(statistic.Pkt_Lost)++;	   			}   		    		op_prg_odb_bkpt ("collision");   0   		/* check if a higher layer packet is set */   !		if (higher_layer_pkptr != NULL)   			{   (			/* destroy the higher layer packet */   &			op_pk_destroy (higher_layer_pkptr);   			}   		   		/* destroy the packet */   		op_pk_destroy (pkptr);   		FOUT;   		}   	   	/*   *	 * Check the type of the received packet:   ,	 *		* if it's a beacon packet, we schedule    	 */   (	if (!strcmp (format, "lr_wpan_beacon"))   		{   		/* debugging */   6		ENTER_STATE_ODB_PRINTING ("Beacon Frame received.");   			   		/* update the flag */   .		lr_wpan_beacon_param.beacon_rcvd = OPC_TRUE;   		   		/* get the address field */   Y		if (op_pk_nfd_get_ptr (pkptr, "Addressing field", &addr_field) == OPC_COMPCODE_FAILURE)   o			lr_wpan_mac_error ("lower_layer_pkt_rcv:", "Unable to get the address field of the Beacon frame.", OPC_NIL);   		   )		/* get the MAC address of the master */   -		if (lr_wpan_beacon_param.master_addr == -1)   ;			lr_wpan_beacon_param.master_addr = addr_field->src_addr;   		   &		if (addr_field->packet_pending != 0)   			{   D			/* schedule a data request to send if some packets are pending */   U			op_intrpt_schedule_self (lr_wpan_slotted_boundary_time (), Wpan_Data_Req_To_Send);   			}   &		else if (wpan_transmission_required)   			{   			/*   I			 * otherwise, if no packets are pending and if we need to send a data,   "			 * we schedule the transmission   			 */   P			op_intrpt_schedule_self (lr_wpan_slotted_boundary_time (), Data_Pkt_To_Send);   			}   		   		/* destroy the packet */   		op_pk_destroy (pkptr);			   		}   >	else if (!Rx_Ack_Expected && !strcmp (format, "lr_wpan_mac"))   		{   2		/* get the sequence number of the Data packet */   -		op_pk_nfd_get_int32 (pkptr, "Seqn", &seqn);   		   ,		/* look if the packet is a data request */   N		op_pk_nfd_get_int32 (pkptr, "Request", &lr_wpan_beacon_param.data_req_rcvd);   		   +		/* get the address field of the packet */   =		op_pk_nfd_get_ptr (pkptr, "Addressing field", &addr_field);   		   #		/* get the frame control field */   ;		op_pk_nfd_get_ptr (pkptr, "Frame Ctrl", &frame_ctrl_ptr);   		   G		/* get the source MAC address of the packet for the acknowledgment */   '		Ack_Dest_Addr = addr_field->src_addr;   		   0		/* schedule the acknowledgment transmission */   +		Tx_Ack_Require = frame_ctrl_ptr->ack_req;   		   0		/* if the packet sequence number is correct */   9		if (seqn != lr_wpan_get_rx_seqn (addr_field->src_addr))   			{   #			/* update the sequence number */   4			lr_wpan_set_rx_seqn (addr_field->src_addr, seqn);   			   			/* update the statistic */   			statistic.Data_Pkt_Rcv ++;   N			statistic.Total_MAC_Delay += op_sim_time () - op_pk_stamp_time_get (pkptr);   			   			/*   /			* if we have a higher layer packet in there,   &			* we forward it to the higher layer   			*/   "			if (higher_layer_pkptr != NULL)   				{   *				/* check if we have a simple source */   				if (bulk_data_source)   					{   1					/* forward the packet to the higher layer */   ;					op_pk_send (higher_layer_pkptr, HIGHER_LAYER_UP_STRM);   					}   				else   					{   *					/* create an ICI for the LLC layer */   .					ici_ptr = op_ici_create ("wlan_mac_ind");   					   					/* set the ICI */   l					if (op_ici_attr_set_int32 (ici_ptr, "dest_addr", my_parameters->mac_address) == OPC_COMPCODE_FAILURE ||   `						op_ici_attr_set_int32 (ici_ptr, "src_addr", addr_field->src_addr) == OPC_COMPCODE_FAILURE)   `						lr_wpan_mac_error ("lower_layer_pkt_rcv:", "Unable to set the LLC ICI pointer.", OPC_NIL);   					    					/* update the statistics */   "					statistic.tcp_HL_pkt_rcvd ++;   L					statistic.tcp_HL_bit_rcvd += op_pk_total_size_get (higher_layer_pkptr);   					   					/* install the ici */   					op_ici_install (ici_ptr);   					   1					/* forward the packet to the higher layer */   ;					op_pk_send (higher_layer_pkptr, HIGHER_LAYER_UP_STRM);   					   					/* de-install the ici */   					op_ici_install (OPC_NIL);   					}   				}   			}   		else   			{   			/* debugging */   5			ENTER_STATE_ODB_PRINTING ("Bad Sequence number.");   		   "			if (higher_layer_pkptr != NULL)   				{   )				/* discard the higher layer packet */   '				op_pk_destroy (higher_layer_pkptr);   				}   			}   		   		/* free the memory */   		op_prg_mem_free (addr_field);   #		op_prg_mem_free (frame_ctrl_ptr);   		   		/* destroy the packet */   		op_pk_destroy (pkptr);   		}   =	else if (Rx_Ack_Expected && !strcmp (format, "lr_wpan_ack"))   		{   		/* destroy the packet */   		op_pk_destroy (pkptr);   		   		/* update the flag */   		Rx_Ack_Expected = OPC_FALSE;   		   )		/* destroy the retransmission packet */   $		lr_wpan_destroy_retransmission ();   		   "		/* update the sequence number */   		Mac_Data_Tx_Seqn++;   #		Mac_Data_Tx_Seqn %= MAX_MAC_SEQN;   		   &		/* schedule the exit of the state */   9		op_intrpt_schedule_self (op_sim_time (), Ack_Received);   		   		/* update the statistic */   		statistic.Ack_Pkt_Rcv ++;   		}   	else   		{   		/* debugging */   J		ENTER_STATE_ODB_PRINTING ("WPAN Packet not accepted by the MAC layer.");   		   -		/* check if a higher layer packet is set */   !		if (higher_layer_pkptr != NULL)   			{   (			/* discard the higher layer packet */   &			op_pk_destroy (higher_layer_pkptr);   			}   		   		/* discard the packet */   		op_pk_destroy (pkptr);   		}   	   	FOUT;   }       /*   # * Function:	unacknowlegement_reset    */       static void   unacknowlegement_reset (void)   {   /*    < * if we are in unacknowledgement mode, we turn the LIFS on    , * and we destroy the retransmission packet     */   !	FIN (unacknowlegement_reset ());   	   /	/* The transmission of the data is finished */   *	channel_flag.data_is_sending = OPC_FALSE;   	   	/* turn on the LIFS period */   !	channel_flag.LIFS_on = OPC_TRUE;   	   *	/* schedule when the LIFS will be over */   O	op_intrpt_schedule_self (op_sim_time () + WPAN_LIFS_DURATION, Wpan_LIFS_Over);   	   (	/* destroy the retransmission packet */   #	lr_wpan_destroy_retransmission ();   	   !	/* update the sequence number */   	Mac_Data_Tx_Seqn++;   "	Mac_Data_Tx_Seqn %= MAX_MAC_SEQN;   		   	FOUT;   }       	   /*   ' * Function:	lr_wpan_packet_to_transmit    *   > * Description:	set and transmit the MAC packet to the channel    *    * No parameter    */       -static void lr_wpan_packet_to_transmit (void)   {   	Packet * pkptr;   	   	   %	FIN (lr_wpan_packet_to_transmit ());   	       2	if (lr_wpan_beacon_param.data_request != OPC_NIL)   		{   		/* set the packet to send  */   ,		pkptr = lr_wpan_beacon_param.data_request;   		   ?		/* reset the pointer without destroying the packet to send */   .		lr_wpan_beacon_param.data_request = OPC_NIL;   		}   (	else if (retransmission_ptr == OPC_NIL)   		{   		/* debugging */   1		ENTER_STATE_ODB_PRINTING ("transmit a packet");   		   *		/* check if the subqueue is not empty */   		if (!current_queue->size)   e			lr_wpan_mac_error ("lr_wpan_packet_to_transmit:", "The higher layer subqueue is empty.", OPC_NIL);   		   3		/* dequeue the higher layer packet to transmit */   Z		if ((pkptr = op_prg_list_remove (current_queue->subqueue, OPC_LISTPOS_HEAD)) == OPC_NIL)   m			lr_wpan_mac_error ("lr_wpan_packet_to_transmit:", "Unable to get the packet from the subqueue.", OPC_NIL);   		   #		/* update the size of the list */   C		current_queue->size = op_prg_list_size (current_queue->subqueue);   		   -		/* Set the sequence number of the packet */   8		op_pk_nfd_set_int32 (pkptr, "Seqn", Mac_Data_Tx_Seqn);   		   :		/* get a copy of the packet in case of retransmission */   *		retransmission_ptr = op_pk_copy (pkptr);   		}   	else   		{   		/* debugging */   3		ENTER_STATE_ODB_PRINTING ("retransmit a packet");       )		/* compute the retransmission packet */   		(statistic.Retransmission)++;   		   0		/* set a break point for the retransmission */   %		op_prg_odb_bkpt ("retransmission");   		   $		/* get the packet to retransmit */   *		pkptr = op_pk_copy (retransmission_ptr);   		}   	   	   %	/* send the packet to the channel */   >	op_pk_deliver (pkptr, wpan_channel_objid, CHANNEL_UP_STREAM);   	   	/* update the statistics */   	statistic.Data_Pkt_Sent ++;   	   +	/* schedule the end of the transmission */   	op_intrpt_schedule_self (op_sim_time () + (op_pk_total_size_get (pkptr) + (double) LR_WPAN_PHY_OVERHEAD)/LR_WPAN_BIT_RATE, End_Of_Transmission);   	    	/* set the TX and RX to busy */   "	channel_flag.tx_idle = OPC_FALSE;   "	channel_flag.rx_idle = OPC_FALSE;   	   6	/* if a turn around time is schedule, we cancel it */    	lr_wpan_cancel_TAT (TXRX_CODE);   	   0	/* we expected to received an acknowledgment */   *	Rx_Ack_Expected = Acknowledgement_Enable;   	   #	/* We are sending a data packet */   )	channel_flag.data_is_sending = OPC_TRUE;   	   	FOUT;   }           /*   $ * Function:	lr_wpan_ack_to_transmit    *   & * Description:	Transmit an Ack packet    *    * No Parameters    */       &static void lr_wpan_ack_to_transmit ()   {   	Packet * Ack_Pkptr;   	Ici * ici_ptr;   	double txrx_distance;   	int rx_index, rx_seqn;   	Wpan_Node_Param * rxptr;   	   	   "	FIN (lr_wpan_ack_to_transmit ());   	   	/* create an Ack packet */   .	Ack_Pkptr = op_pk_create_fmt ("lr_wpan_ack");   	   	/* get the sequence number */   ;	if ((rx_seqn = lr_wpan_get_rx_seqn (Ack_Dest_Addr)) == -1)   `		lr_wpan_mac_error ("lr_wpan_ack_to_transmit:", "Unable to get the sequence number.", OPC_NIL);   	   '	/* fill out the field of the packet */   N	if (op_pk_nfd_set_int32 (Ack_Pkptr, "Seqn", rx_seqn) == OPC_COMPCODE_FAILURE)   e		lr_wpan_mac_error ("lr_wpan_ack_to_transmit:", "Unable to fill out the packet's fields.", OPC_NIL);   		   @	if ((rx_index = wpan_search_mac_address (Ack_Dest_Addr)) == -1)   h		lr_wpan_mac_error ("lr_wpan_ack_to_transmit:", "The MAC destination address doesn't exist.", OPC_NIL);   	   2	/* get the parameter of the destination device */   =	rxptr = op_prg_list_access (wpan_node_param_list, rx_index);       1	/* compute the distance between the RX and TX */   	txrx_distance = sqrt ((rxptr->x - my_parameters->x)*(rxptr->x - my_parameters->x) + (rxptr->y - my_parameters->y)*(rxptr->y - my_parameters->y));       	/* create a new ICI */   )	ici_ptr = op_ici_create ("ici_channel");   	   	/* set the ICI pointer */   ]	if (op_ici_attr_set_dbl (ici_ptr, "txrx distance", txrx_distance) == OPC_COMPCODE_FAILURE ||   X		op_ici_attr_set_dbl (ici_ptr, "bit rate", LR_WPAN_BIT_RATE) == OPC_COMPCODE_FAILURE ||   \		op_ici_attr_set_dbl (ici_ptr, "channel", wpan_frequency_center) == OPC_COMPCODE_FAILURE ||   Y		op_ici_attr_set_dbl (ici_ptr, "power", my_parameters->power) == OPC_COMPCODE_FAILURE ||   Z		op_ici_attr_set_int32 (ici_ptr, "packet type", WPAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||   [		op_ici_attr_set_int32 (ici_ptr, "dest address", Ack_Dest_Addr) == OPC_COMPCODE_FAILURE ||   T		op_ici_attr_set_dbl (ici_ptr, "Tx x", my_parameters->x) == OPC_COMPCODE_FAILURE ||   T		op_ici_attr_set_dbl (ici_ptr, "Tx y", my_parameters->y) == OPC_COMPCODE_FAILURE ||   L		op_ici_attr_set_dbl (ici_ptr, "Rx x", rxptr->x) == OPC_COMPCODE_FAILURE ||   J		op_ici_attr_set_dbl (ici_ptr, "Rx y", rxptr->y) == OPC_COMPCODE_FAILURE)   Z		lr_wpan_mac_error ("higher_layer_pkt_recv:", "Unable to set the ICI pointer.", OPC_NIL);   	   1	/* Associate the ICI pointer with this packet */   $	op_pk_ici_set (Ack_Pkptr, ici_ptr);   	   	   %	/* send the packet to the channel */   B	op_pk_deliver (Ack_Pkptr, wpan_channel_objid, CHANNEL_UP_STREAM);   	   	/* update the statistics */   	statistic.Ack_Pkt_Sent ++;   		   +	/* schedule the end of the transmission */   s	op_intrpt_schedule_self (op_sim_time () + op_pk_total_size_get (Ack_Pkptr)/LR_WPAN_BIT_RATE, End_Of_Transmission);   	   	/* set the transmitter busy */   "	channel_flag.tx_idle = OPC_FALSE;   "	channel_flag.rx_idle = OPC_FALSE;       6	/* if a turn around time is schedule, we cancel it */    	lr_wpan_cancel_TAT (TXRX_CODE);   	   	FOUT;   }           /*   * * Function:	lr_wpan_drop_higher_layer_pkt    *    * Description:     *    * No parameters    */       0static void	lr_wpan_drop_higher_layer_pkt (void)   {   	Packet * pkptr;   	Packet * higher_layer_pkptr;   	int last_packet = 0;   	Ici * ici_ptr;   	char error_msg[256];   	   	   (	FIN (lr_wpan_drop_higher_layer_pkt ());   	   	while (!last_packet)   		{   2		/* dequeue the packets from the current queue */   Z		if ((pkptr = op_prg_list_remove (current_queue->subqueue, OPC_LISTPOS_HEAD)) == OPC_NIL)   			{   {			sprintf (error_msg, "Queue size: %d; list size: %d\n", current_queue->size, op_prg_list_size (current_queue->subqueue));   r			lr_wpan_mac_error ("lr_wpan_drop_higher_layer_pkt:", "Unable to get the packet from the subqueue.", error_msg);   			}   	   -		/* get the ICI associate with the packet */   3		if ((ici_ptr = op_pk_ici_get (pkptr)) == OPC_NIL)   m			lr_wpan_mac_error ("lr_wpan_drop_higher_layer_pkt", "No ICI associates with the current packet", OPC_NIL);   		   		/* destroy the ICI */   		op_ici_destroy (ici_ptr);   				   D		/* get the higher layer packet if the segmentation flag is true */   <		op_pk_nfd_get_int32 (pkptr, "Segmentation", &last_packet);   		   		if (last_packet)   			{   			/*   .			* if this is the last segment of the higher   +			* layer packet, we get it and destroy it   			*/   F			op_pk_nfd_get_pkt (pkptr, "Higher Layer Pkt", &higher_layer_pkptr);   			   (			/* destroy the higher layer packet */   &			op_pk_destroy (higher_layer_pkptr);   			}   		   		/* destroy the packet */   		op_pk_destroy (pkptr);   		   		/* update the statistic */   		statistic.Segment_Dropped ++;   		}   	   #	/* update the size of the queue */   B	current_queue->size = op_prg_list_size (current_queue->subqueue);   		   	FOUT;   }           /*   + * Function:	lr_wpan_destroy_retransmission    *    * Description:	    *    * ParamOut:	int last_packet   5 *				return the value 1 if the retransmission packet   6 *				was the last segment of the higher layer packet,    *				otherwise, we return 0    */       0static int	lr_wpan_destroy_retransmission (void)   {   	Packet * higher_layer_pkptr;	   	Ici * ici_ptr;   	int last_packet;   	   )	FIN (lr_wpan_destroy_retransmission ());   	   <	/* get the ICI associates with the retransmission packet */   ?	if ((ici_ptr = op_pk_ici_get (retransmission_ptr)) == OPC_NIL)   c		lr_wpan_mac_error ("lr_wpan_destroy_retransmission:", "Unable to get the ICI pointer.", OPC_NIL);   		    	/* destroy the ICI structure */   	op_ici_destroy (ici_ptr);   	    	/* get the segmentation flag */   H	op_pk_nfd_get_int32 (retransmission_ptr, "Segmentation", &last_packet);   	   	if (last_packet)   		{   		/*   -		* if this is the last segment of the higher   *		* layer packet, we get it and destroy it   		*/   R		op_pk_nfd_get_pkt (retransmission_ptr, "Higher Layer Pkt", &higher_layer_pkptr);   		   '		/* destroy the higher layer packet */   %		op_pk_destroy (higher_layer_pkptr);   		}   	   (	/* destroy the retransmission packet */   #	op_pk_destroy(retransmission_ptr);   	retransmission_ptr = OPC_NIL;   	   -	/* reset the transmission retries counter */   	nb_transmission_retries = 0;   	   	FRET (last_packet);   }           /*   # * Function:	lr_wpan_enqueue_packet    *   # * Description:	subqueue mechanism:   9 *				each packet is enqueue according to its destination   6 *				MAC address. A structure has been made to record   % *				these information: "Wpan_queue"   5 *				this function enqueue a packet according to its   8 *				destination MAC address. If no subqueue exists for   3 *				the current MAC address, we create a new one.    *    * ParamIn:		int mac_address   + *				Destination MAC address of the packet    *    *				Packet * pkptr   & *				pointer to the packet to enqueue    *				    */       Dstatic void lr_wpan_enqueue_packet (int mac_address, Packet * pkptr)   {   	Wpan_Queue * queue;   	   3	FIN (lr_wpan_enqueue_packet (mac_address, pkptr));   	   	queue = wpan_queue;   	   	/* update the statistic */    	statistic.Segment_generated ++;   	   %	/* consider all the possibilities */   	if (wpan_queue == NULL)   		{   +		/* if the structure is not yet created */   >		wpan_queue = lr_wpan_allocate_subqueue (mac_address, pkptr);   		   		/* we make a loop */    		wpan_queue->next = wpan_queue;   		   		   )		/* initialize the round robin if any */   		current_queue = wpan_queue;       		FOUT;   		}   	   	while (queue != NULL)   		{   		/* */   (		if (queue->mac_address == mac_address)   			{   A			op_prg_list_insert (queue->subqueue, pkptr, OPC_LISTPOS_TAIL);   4			queue->size = op_prg_list_size (queue->subqueue);   			FOUT;   			}   		    		if (queue->next == wpan_queue)   			{   '			/* we are at the end of the chain */   @			queue->next = lr_wpan_allocate_subqueue (mac_address, pkptr);   			   (			/* increase the number of elements */   			wpan_queue->nb_element ++;   			FOUT;   			}   		   		queue = queue->next;   		}   	   =	/* we shouldn't be here, so we print out an error message */   X	lr_wpan_mac_error ("lr_wpan_enqueue_packet:", "Unable to enqueue the packet", OPC_NIL);   }           /*   & * Function:	lr_wpan_allocate_subqueue    *   = * Description:	allocate a new subqueue for a new destination    *				MAC address    *    * ParamIn:		int mac_address   < *				Destination MAC address of the packets in the subqueue    *    *				Packet * pkptr   & *				pointer to the packet to enqueue    *    * ParamOut:	Wpan_queue * queue   8 *				New queue structure with the first pascket enqueue    */       Ostatic Wpan_Queue * lr_wpan_allocate_subqueue (int mac_address, Packet * pkptr)   {   	Wpan_Queue * queue;   	   $	FIN (lr_wpan_allocate_subqueue ());   	   '	/* allocate the memory for the cell */   ?	queue = (Wpan_Queue *) op_prg_mem_alloc (sizeof (Wpan_Queue));   	   "	/* create a the list attribute */   )	queue->subqueue = op_prg_list_create ();   	   	/* enqueue the packet */   ?	op_prg_list_insert (queue->subqueue, pkptr, OPC_LISTPOS_TAIL);   	   "	/* initialize the other fields */   "	queue->mac_address = mac_address;   	queue->size = 1;   	queue->nb_element = 1;   	queue->next = wpan_queue;   	   	FRET (queue);   }           /*     * Function:	lr_wpan_print_queue    *   1 * Description:	print the whole queue of the node    *    * No parameter    */       static void   lr_wpan_print_queue (void)   {   	Wpan_Queue * queue;   	int i;   	   	FIN (lr_wpan_print_queue ());   	   	queue = wpan_queue;   	   	/* */   G	printf ("\n|-----------------------------------------------------\n");   ,	printf ("| Node %s:\n", lr_wpan_node_name);   	if (queue != NULL)   		{   *		for (i=0; i<wpan_queue->nb_element; i++)   			{   7			printf ("|\tMac address: %d\n", queue->mac_address);   ,			printf ("|\tsize: %d\n|\n", queue->size);   			queue = queue->next;   			}   		}   	else   		printf ("|\tNo subqueues\n");       E	printf ("|-----------------------------------------------------\n");       	FOUT;   }           /*   $ * Function:	lr_wpan_get_beacon_size    *   3 * Description:	compute the size of a Beacon packet    *    * ParamOut:	int beacon_size    *				size of the beacon packet    */       
static int   4lr_wpan_get_beacon_size (Addressing_Field * address)   {   	Wpan_Queue * queue;   	int i;   	int beacon_size, nbPacket = 0;   	   B	const int address_size = 16; // size of the address field in bits   <	const int maximum_nbpacket = 7; // maximum number of packet   	   "	FIN (lr_wpan_get_beacon_size ());   	   	queue = wpan_queue;   	   "	/* count the number of packets */   	if (queue != NULL)   		{   *		for (i=0; i<wpan_queue->nb_element; i++)   			{   ,			/* increase the number of total packet */   			nbPacket += queue->size;   			   >			/* if we have a packet for the particular source address */   /			if (address->src_addr == queue->mac_address)   *				address->packet_pending = queue->size;   			   			/* get the next queue */   			queue = queue->next;   			}   		}   	   %	/* compute the Beacon packet size */   !	if (nbPacket < maximum_nbpacket)   .		beacon_size = 104 + nbPacket * address_size;   	else   6		beacon_size = 104 + maximum_nbpacket * address_size;       	   	FRET (beacon_size);   }           /*   " * Function:	lr_wpan_subq_checking    */       $static void lr_wpan_subq_checking ()   {   	int i = 0;   	Wpan_Queue * queue;   	Boolean subq_empty;   	    	FIN (lr_wpan_subq_checking ());   	   	queue = current_queue;   	   	/*   6 	 * if no transmission is already scheduled, we check   +	 * the subqueues for the next transmission   	 */   )	/* initialize the flag subqueue empty */   	if (queue != NULL)   		{   		queue = queue->next;   "		subq_empty = (queue->size == 0);   		}   	else   		{   		FOUT;   		}   	   	/* check the subqueues */   3	while (subq_empty && queue->next != current_queue)   		{   #		/* get the next subqueue index */   		queue = queue->next;   		   &		/* check if the subqueue is empty */   "		subq_empty = (queue->size == 0);   		}   	   	if (!subq_empty)   		{   9		/* schedule an interuption for the next transmission */   =		op_intrpt_schedule_self (op_sim_time (), Data_Pkt_To_Send);   		   		/* get the subqueue */   		current_queue = queue;   		}   	   	FOUT;   }           /*     * Function:	lr_wpan_get_rx_seqn    */       0static int lr_wpan_get_rx_seqn (int mac_address)   {   	Mac_Data_Seqn * element;   	int list_size;   	int i; // loop variable   	   	   )	FIN (lr_wpan_get_rx_seqn (mac_address));   	   1	list_size = op_prg_list_size (Mac_Data_Rx_Seqn);   	   	for (i=0; i<list_size; i++)   		{   		/* get the ith element */   5		element = op_prg_list_access (Mac_Data_Rx_Seqn, i);   		   *		if (element->mac_address == mac_address)   			FRET (element->seqn);   		}   	   :	/* if the MAC address is not present, we initialize it */   '	lr_wpan_set_rx_seqn (mac_address, -1);   	   	FRET (-1);   }           /*     * Function:	lr_wpan_set_rx_seqn    */       ;static void lr_wpan_set_rx_seqn (int mac_address, int seqn)   {   	Mac_Data_Seqn * element;   	int list_size;   	int i; // loop variable   	   /	FIN (lr_wpan_set_rx_seqn (mac_address, seqn));   	   2	 list_size = op_prg_list_size (Mac_Data_Rx_Seqn);   	   %	/* search for an existing element */   	for (i=0; i<list_size; i++)   		{   		/* get the ith element */   5		element = op_prg_list_access (Mac_Data_Rx_Seqn, i);   		   *		if (element->mac_address == mac_address)   			{   			element->seqn = seqn;   			FOUT;   			}   		}   	   3	/* if we are here, no sequence number exist yet */   	/* we create a new one */   G	element = (Mac_Data_Seqn *) op_prg_mem_alloc (sizeof (Mac_Data_Seqn));   	   $	element->mac_address = mac_address;   	element->seqn = seqn;   	   (	/* insert this element into the list */   B	op_prg_list_insert (Mac_Data_Rx_Seqn, element, OPC_LISTPOS_TAIL);   	   	FOUT;   }       /*   ! * Function:	lr_wpan_collect_stat    *   9 * Description:	collect data at the end of the simulation   / *				4 files are created during this function:    *	   1 *				* {basename}_pkt_rcv.txt: record the number   , *				  of packets received and packets loss    *   2 *				* {basename}_pkt_sent.txt: record the number   - *				  of packets sent during the simulation    *   5 *				* {basename}_node_status.txt: record the number   + *				  of packets present in the subqueues    *   6 *				* {basename}_pkt_delay.txt: record the MAC delay    *    * No parameter    */       #static void lr_wpan_collect_stat ()   {   	FILE * fp;   	char report_name[128];   	Boolean exist;   	double packet_loss, mac_delay;   	   *	const char * packet_rcv = "_pkt_rcv.txt";   ,	const char * packet_sent = "_pkt_sent.txt";   /	const char * node_status = "_node_status.txt";   .	const char * packet_delay = "_pkt_delay.txt";   	   	Wpan_Queue * queue;   	int i; // loop variable   
	time_t date;   	char date_str[32];   	   	   	FIN (lr_wpan_collect_stat ());   	   	/* get the date of the day */   	time (&date);   )	sprintf (date_str, "%s", ctime (&date));   	   B	printf(" total backoff time %f\n", statistic.total_backoff_time);   8	printf(" total backoff %d\n", statistic.total_backoff);   	   	/* start printing report */   	/* get the report name */   >	sprintf (report_name, "%s%s", lr_wpan_node_name, packet_rcv);   	   5	fp = lr_wpan_open_report_file (report_name, &exist);   	   	if (!exist)   		{   "		/* write a header in the file */   P		fprintf (fp, "\t*** Packet received at the node %s ***\n", lr_wpan_node_name);   2		fprintf (fp, "\tCreation date: %s\n", date_str);   W		fprintf (fp, "\tNb packet collided:\t\tnumber of packet collided, protocol issue\n");   M		fprintf (fp, "\tNb packet lost:\t\tnumber of packet lost by collisions\n");   I		fprintf (fp, "\tNb packet noise:\t\tnumber of packet lost by noise\n");   N		fprintf (fp, "\tData packet rcv:\t\tnumber of MAC data packets received\n");   S		fprintf (fp, "\tAck packet rcv:\t\tnumber of acknowledgment packets received\n");   		fprintf (fp, "\tPacket loss:\t\tratio between the number of data packet received and the total number of packet sent (except the Ack)\n");   O		fprintf (fp, "\tRetransmit packet:\tnumber of retransmission packet sent\n");   ^		fprintf (fp, "\tNb Time Out:\t\tnumber of time out reached in the Acknowledgement state\n");   M		fprintf (fp, "\tSimulation time:\t\ttotal simulation time in seconds\n\n");   		fprintf (fp, "Nb packet collided\t Nb packet lost\t Nb packet Noise\t Data packet rcv\t Ack packet rcv\t Packet loss\t Nb Time Out\t simulation time\t last modified date\n");   		}   	   	/* compute the packet loss */   f	if (statistic.Data_Pkt_Rcv + statistic.Pkt_Lost + statistic.Pkt_Collided + statistic.Pkt_Noise  == 0)   		packet_loss = -1.0;   	else   		packet_loss = (double)( statistic.Pkt_Lost + statistic.Pkt_Collided + statistic.Pkt_Noise) / ((double) statistic.Data_Pkt_Rcv + (double) statistic.Pkt_Lost + (double) statistic.Pkt_Collided + (double)statistic.Pkt_Noise);   	   k	fprintf (fp, "%s\t %s\t %s\t %s\t %s\t %s\t %s\t %s\t %s", integer_to_string (statistic.Pkt_Collided, 15),   -		integer_to_string (statistic.Pkt_Lost, 14),   .		integer_to_string (statistic.Pkt_Noise, 14),   1		integer_to_string (statistic.Data_Pkt_Rcv, 15),   0		integer_to_string (statistic.Ack_Pkt_Rcv, 14),   %		double_to_string (packet_loss, 11),   0		integer_to_string (statistic.Nb_Time_Out, 11),   @		double_to_string (op_sim_time (), strlen ("simulation time")),   		date_str);   	   
	fclose (fp);   	   	/* get the report name */   ?	sprintf (report_name, "%s%s", lr_wpan_node_name, packet_sent);   	   5	fp = lr_wpan_open_report_file (report_name, &exist);   	   	if (!exist)   		{   "		/* write a header in the file */   N		fprintf (fp, "\t*** Packet sent from the node %s ***\n", lr_wpan_node_name);   2		fprintf (fp, "\tCreation date: %s\n", date_str);   R		fprintf (fp, "\tSegment generated:\tdata segment generated in the MAC layer\n");   M		fprintf (fp, "\tData packet sent:\t\ttotal number of data packets sent\n");   W		fprintf (fp, "\tAck packet sent:\t\ttotal number of acknowledgement packets sent\n");   [		fprintf (fp, "\tPacket dropped:\t\tnumber of higher layer packets dropped by the CCA\n");   P		fprintf (fp, "\tSegment dropped:\t\tnumber of segments dropped by the CCA\n");   M		fprintf (fp, "\tSimulation time:\t\ttotal simulation time in seconds\n\n");   		fprintf (fp, "Segment generated\t Data packet sent\t Ack packet sent\t Packet dropped\t Segment dropped\t Retransmit packet\t Simulation time\t last modified date\n");   		}   	   	fprintf (fp, "%s\t %s\t %s\t %s\t %s\t %s\t %s\t %s", integer_to_string (statistic.Segment_generated, strlen ("Segment generated")),   K		integer_to_string (statistic.Data_Pkt_Sent, strlen ("Data packet sent")),   I		integer_to_string (statistic.Ack_Pkt_Sent, strlen ("Ack packet sent")),   G		integer_to_string (statistic.Pkt_Dropped, strlen ("Packet dropped")),   L		integer_to_string (statistic.Segment_Dropped, strlen ("Segment dropped")),   M		integer_to_string (statistic.Retransmission, strlen ("Retransmit packet")),   @		double_to_string (op_sim_time (), strlen ("simulation time")),   		date_str);   	   
	fclose (fp);        	/* get the total report name */   	if (wpan_queue != NULL)   		{   		/* get the report name */   @		sprintf (report_name, "%s%s", lr_wpan_node_name, node_status);   		   6		fp = lr_wpan_open_report_file (report_name, &exist);   		   $		/* Print the header of the file */   
		if (!exist)   			{   #			/* write a header in the file */   S			fprintf (fp, "\t*** Status of the node queues for %s ***\n", lr_wpan_node_name);   3			fprintf (fp, "\tCreation date: %s\n", date_str);   >			fprintf (fp, "\tSubq n length:\tsize of the subqueue n\n");   L			fprintf (fp, "\tSimulation time:\ttotal simulation time in seconds\n\n");   			   -			for (i=0; i < wpan_queue->nb_element; i++)   (				fprintf (fp, "Subq %d length, ", i);   			   			/* print the return char */   9			fprintf (fp, "simulation time, last modified date\n");   			}   		   		/* print the results */   @		for (i=0, queue = wpan_queue; i < wpan_queue->nb_element; i++)   			{   =			fprintf (fp, "%s, ", integer_to_string (queue->size, 13));   			queue = queue->next;   			}   		   		/* print the return char */   b		fprintf (fp, "%s, %s", double_to_string (op_sim_time (), strlen ("simulation time")), date_str);   		   		fclose (fp);   		}   	   	   	/* get the report name */   @	sprintf (report_name, "%s%s", lr_wpan_node_name, packet_delay);   	   5	fp = lr_wpan_open_report_file (report_name, &exist);   	   #	/* Print the header of the file */   	if (!exist)   		{   "		/* write a header in the file */   M		fprintf (fp, "\t*** Packet delay at the node %s ***\n", lr_wpan_node_name);   2		fprintf (fp, "\tCreation date: %s\n", date_str);   Z		fprintf (fp, "\tTotal MAC delay:\t\tsum of all the delay collected at the MAC level\n");   P		fprintf (fp, "\tnb data packets:\t\ttotal number of data packets received\n");   T		fprintf (fp, "\tMAC delay (everage):\teverage of the MAC delay for one packet\n");   M		fprintf (fp, "\tSimulation time:\t\ttotal simulation time in seconds\n\n");   r		fprintf (fp, "Total MAC dela\t nb data packets\t MAC delay (everage)\t simulation time\t last modified date\n");   		}   	   $	/* compute the MAC everage delay */   k	mac_delay = (statistic.Data_Pkt_Rcv) ? statistic.Total_MAC_Delay / (double) statistic.Data_Pkt_Rcv : -1.0;   	   	/* print the results */   Z	fprintf (fp, "%s\t %s\t %s\t %s\t %s", double_to_string (statistic.Total_MAC_Delay, 15),    1		integer_to_string (statistic.Data_Pkt_Rcv, 15),   #		double_to_string (mac_delay, 19),   @		double_to_string (op_sim_time (), strlen ("simulation time")),   		date_str);   	   
	fclose (fp);   	   	if (!bulk_data_source)   		{   		/*    E		 * we don't have the simple source but the TCP/IP stack, so we must   *		 * generate a report for the upper layer   		 */   		/* get the report name */   B		sprintf (report_name, "%s_higher_layer.txt", lr_wpan_node_name);   	   6		fp = lr_wpan_open_report_file (report_name, &exist);   	   $		/* Print the header of the file */   
		if (!exist)   			{   #			/* write a header in the file */   N			fprintf (fp, "\t*** Packet delay at the node %s ***\n", lr_wpan_node_name);   3			fprintf (fp, "\tCreation date: %s\n", date_str);   Y			fprintf (fp, "\tnb packets rcvd:\t\ttotal number of higher layer packets received\n");   S			fprintf (fp, "\tnb bits rcvd:\t\ttotal number of higher layer bits received\n");   U			fprintf (fp, "\tnb packets sent:\t\ttotal number of higher layer packets sent\n");   R			fprintf (fp, "\tnb bits sent:\t\ttotal number of higher layer bits sent\n");			   N			fprintf (fp, "\tSimulation time:\t\ttotal simulation time in seconds\n\n");   |			fprintf (fp, "nb packets rcvd\t nb bits rcvd\t nb packets sent\t nb bits sent\t simulation time\t last modified date\n");   			}   				   		/* print the results */   x		fprintf (fp, "%s\t %s\t %s\t %s\t %s\t %s", integer_to_string (statistic.tcp_HL_pkt_rcvd, strlen ("nb packets rcvd")),   J			integer_to_string (statistic.tcp_HL_bit_rcvd, strlen ("nb bits rcvd")),   M			integer_to_string (statistic.tcp_HL_pkt_sent, strlen ("nb packets sent")),   J			integer_to_string (statistic.tcp_HL_bit_sent, strlen ("nb bits sent")),   A			double_to_string (op_sim_time (), strlen ("simulation time")),   
			date_str);   		   		fclose (fp);   		}   	   	FOUT;   }                        
wpan_state   	generator   	wpan_flag      #Print informations about the states   4Print informations about the source packet generator   'Print informations about the WPAN flags       	       Z            
   Init   
       
      /* initialize the process */   lr_wpan_mac_init ();           if (!bulk_data_source)   	{   	/*   -	 * If the packet source is the tcp/ip stack,   -	 * we need to register the MAC layer in the    	 * model wide registry    	 */    	lr_wpan_model_wide_register ();   	}   /* create a self interupt */   ,op_intrpt_schedule_self (op_sim_time (), 0);   
       
      if (!bulk_data_source)   	{   	/*   +	 * if the TCP/IP stack is present, we need   *	 * to resolve the MAC address of the node   	 */    	lr_wpan_mac_address_resolve ();   	}       /*   B * If we are in a Slotted mode and the current node is the master,   3 * we schedule the first Beacon packet transmission    */   Bif (my_parameters->slotted_enable && my_parameters->master_enable)   	{   ;	/* check the consistency of the slotted mode parameters */   -	lr_wpan_slotted_consistency (my_parameters);       D	/* create the MAC address table to send the Beacons on broadcast */   L	lr_wpan_slotted_generate_addr_table (my_parameters, &lr_wpan_beacon_param);       '	/* schedule the first Beacon packet */   Q	op_intrpt_schedule_self (lr_wpan_slotted_boundary_time (), Wpan_Beacon_To_Send);   	}   
       
       
          pr_state                     
   Idle   
       
   /   /* print a debugging message */   6ENTER_STATE_ODB_PRINTING ("enter the \"Idle\" state");            if (!wpan_transmission_required)   	{   #	if (retransmission_ptr == OPC_NIL)   		{   E		/* check the queues to know whether we have some packets to send */   		lr_wpan_subq_checking ();   		}   	else   		{   1		/* update the number of transmission retries */   		nb_transmission_retries++;   	   		/* check the number */   3		if (nb_transmission_retries <= max_frame_retries)   			{   $			/* schedule the retransmission */   >			op_intrpt_schedule_self (op_sim_time (), Data_Pkt_To_Send);   			}   		else   			{   			/*    <			 * the maximum number of retransmission is reach, we have   			 * to drop the packet   			 */   *			if (!lr_wpan_destroy_retransmission ())   				{   				/*   A				 * if this packet is not the last segment of the higher layer   +				 * we have to destroy the left segments   				 */   %				lr_wpan_drop_higher_layer_pkt ();   				}   			   			/* update the statistic */   			statistic.Pkt_Dropped ++;   			/*   *			 * we have to count the segment dropped   6			 * in the function "lr_wpan_destroy_retransmission"   			 */    			statistic.Segment_Dropped ++;   			}   		}   	}   
       
      %/* check if we receive some packet */   lr_wpan_intrpt_check ("Idle");   
                        pr_state                      
   BackOff   
       
      /*   2 * We have a packet arriving from the higher layer   4 * We need to send it. To do so, we have to wait for   6 * a backoff period and listen the channel (CCA state)    */       /* print a debugging message */   9ENTER_STATE_ODB_PRINTING ("enter the \"Backoff\" state");   
       
      %/* check if we receive some packet */   !lr_wpan_intrpt_check ("Backoff");   
                        pr_state                     
   CCA   
       
      /* debugging */   5ENTER_STATE_ODB_PRINTING ("Enter the \"CCA\" state");   
       
      /* check the interruption */   lr_wpan_intrpt_check ("CCA");   
       
       
          pr_state                    
   Wait for Ack   
       
      /* print a debugging message */   >ENTER_STATE_ODB_PRINTING ("enter the \"Wait for Ack\" state");   
       
   #   %/* check if we receive some packet */   &lr_wpan_intrpt_check ("Wait for Ack");       /*   @ * if the transmission is finished, we schedule Ack the time out   B * Warning: This step should apply only after a Data transmission.    */   Lif (channel_flag.tx_idle && op_ev_valid (Ack_TimeOut_Evhandle) == OPC_FALSE)   	{   (	/* The data transmission is finished */   *	channel_flag.data_is_sending = OPC_FALSE;   	   3	/* schedule the time out for the acknowledgment */   #	if (my_parameters->slotted_enable)   		{   I		/* if we are in the slotted mode, we start the timer at the boundary */   z		Ack_TimeOut_Evhandle = op_intrpt_schedule_self (lr_wpan_slotted_boundary_time () + MAC_ACK_WAIT_DURATION, Ack_Time_Out);   		}   	else   h		Ack_TimeOut_Evhandle = op_intrpt_schedule_self (op_sim_time () + MAC_ACK_WAIT_DURATION, Ack_Time_Out);   	}		       1//if (INTRPT_SELF && intrpt_code == Ack_Received)   //	{   	/* turn on the LIFS period */   #//	channel_flag.LIFS_on = OPC_TRUE;   	   *	/* schedule when the LIFS will be over */   Q//	op_intrpt_schedule_self (op_sim_time () + WPAN_LIFS_DURATION, Wpan_LIFS_Over);   	   8	/* canceled the Ack Time out if it is still schedule */   8//	if (op_ev_valid (Ack_TimeOut_Evhandle) == OPC_TRUE &&   B//		op_ev_id (Ack_TimeOut_Evhandle) != op_ev_id (op_ev_current()))   (//		op_ev_cancel (Ack_TimeOut_Evhandle);   //	}   
                        pr_state      
  :             
   
Reset Backoff   
       
   D   /* debugging */   ?ENTER_STATE_ODB_PRINTING ("Enter the \"Reset Backoff\" state");       B/* set off the backoff parameters if we don't need a second CCA */   5if (lr_wpan_beacon_param.second_cca_req == OPC_FALSE)   	{   -	csma_parameters.Be = csma_parameters.min_BE;    	csma_parameters.nb_backoff = 0;   	}       if (channel_is_idle)   	{   	/*    K	 * after the CCA is completed, if the channel is idle, we need to turn off   '	 * the RX flag before the transmission   	 */   "	channel_flag.rx_idle = OPC_FALSE;   	}   else   	{   	/*    K	 * Here, all the CCA attempts have failed, we must drop the current packet   =	 * and all the segments associates with it if it is the case   	 */   2	if (lr_wpan_beacon_param.data_request != OPC_NIL)   		{   ;		/* we attempt to send a data request, so we destroy it */   4		op_pk_destroy (lr_wpan_beacon_param.data_request);   		   $		/* we reset the pointer to NULL */   .		lr_wpan_beacon_param.data_request = OPC_NIL;   		}   (	else if (retransmission_ptr == OPC_NIL)   		{   		/*    .		 * The transmission is not a retransmission:   2		 * the packet to transmit is still in the queue,   7		 * we have to remove it and all the segment associate   		 * with it from the subqueue   		 */   #		lr_wpan_drop_higher_layer_pkt ();   		}   -	else if (!lr_wpan_destroy_retransmission ())   		{   		/*   4		 * The packet to transmit is a retransmission and    8		 * is not the last segment of the higher layer packet,   9		 * we have to destroy the left segments in the subqueue   		 */   #		lr_wpan_drop_higher_layer_pkt ();   		   		/*   7		 * update the statistic: we have to count the segment   =		 * dropped in the function "lr_wpan_destroy_retransmission"   		 */   		statistic.Segment_Dropped ++;   		}   	else   		{   		/*    2		 * if it was a retransmission and the packet was   <		 * the last one, just update the number of segment dropped   		 */   		statistic.Segment_Dropped ++;   		}   	/* update the statistic */   	statistic.Pkt_Dropped ++;   	}   
                     
      
          pr_state                     
   Init Backoff   
       
   	   /* debugging */   >ENTER_STATE_ODB_PRINTING ("Enter the \"init backoff\" state");       /* init the CCA */   lr_wpan_mac_backoff ();       =/* reset the transmission flag if we are in unslotted mode */   /if (my_parameters->slotted_enable == OPC_FALSE)   (	wpan_transmission_required = OPC_FALSE;   
                     
      
          pr_state        :            
   TX   
       
      /* debugging */   4ENTER_STATE_ODB_PRINTING ("Enter the \"TX\" state");       
       
      /* check the interuption */   lr_wpan_intrpt_check ("TX");   
                        pr_state        :   Z          
   
Wait boundary   
       
      /*   2 * This state is needed to wait the next boundary    . * before performing the second CCA in case of    * slotted mode    */       /* debugging */   ?ENTER_STATE_ODB_PRINTING ("Enter the \"Wait boundary\" state");   
       
      /* check the interruption */   lr_wpan_intrpt_check ("CCA");   
                        pr_state                                k                 
   tr_0   
                           
@    
                                 
pr_transition                                                  
   tr_29   
       
   default   
                 
       
                                 
pr_transition      H           B        q               
   tr_1   
       
   PACKET_TO_SEND   
       
   
       
@    
       
       
                    
pr_transition      I                                     
   tr_73   
                           
@    
                                 
pr_transition      L        /        s        
          
   tr_14   
       
   BACK_TO_BACKOFF   
       
   
       
@    
       
       
                    
pr_transition      M   
     w  '     :     :  p          
   tr_18   
       
   TRANSMISSION_OK   
       
   
       
@    
       
       
                    
pr_transition      N   
       ;     *        r          
   tr_34   
       
   !TRANSMISSION_OK   
       
   
       
@    
       
       
                    
pr_transition      O      
               7             
   tr_79   
       
   
END_OF_CCA   
                 
@    
       
       
                    
pr_transition      R         t                  v                      
   tr_33   
       
   default   
                 
       
                                 
pr_transition      V        d              ~             
   tr_13   
       
   BACKOFF_EXPIRED   
       
   lr_wpan_cca_init ()   
       
@    
       
       
                    
pr_transition      W               x     l                       
   tr_47   
       
   default   
                 
       
                                 
pr_transition      Y        L       H    z    /    4            
   tr_84   
       
   TIME_TO_TRANSMIT   
       
   lr_wpan_packet_to_transmit ()   
       
@    
       
      
                    
pr_transition      Z          q     L  w    _      R            
   tr_81   
       
   default   
                 
       
                                 
pr_transition      [          s     $                 
   tr_88   
       
   NO_ACK   
       
   unacknowlegement_reset ()   
       
       
       
       
                    
pr_transition      _        ;       r                     
   tr_42   
       
   BACK_TO_IDLE   
                 
@    
       
       
                    
pr_transition      `               )                    
   tr_83   
       
   ACKNOWLEDGEMENT   
                 
@    
       
       
                    
pr_transition      b               w    i                    
   tr_45   
       
   default   
                 
@      
                                 
pr_transition      d   
     m        9     9   n          
   tr_99   
       
   BACK_TO_CCA   
       
   
       
@    
                                 
pr_transition      e           j     1   [               
   tr_101   
       
   BOUNDARY_REACHED   
       
   lr_wpan_cca_init ()   
       
       
                                 
pr_transition         f          Number of packets          !Number of packet in the subqueues   	subqueues   normal   linear        ԲI%}   Packet received          Number of packet received   mac   normal   linear        ԲI%}   Packet sent          Number of packets sent   mac   normal   linear        ԲI%}          lr_wpan_stat_write   oms_auto_addr_support   oms_pr          lr_wpan_mac            