/* Process model C form file: lr_wpan_source.pr.c */
/* Portions of this file copyright 1992-2006 by OPNET Technologies, Inc. */



/* This variable carries the header into the object file */
const char lr_wpan_source_pr_c [] = "MIL_3_Tfile_Hdr_ 120A 30A op_runsim 7 45228AD9 45228AD9 1 P614876 nchevrol 0 0 none none 0 0 none 0 0 0 0 0 0 0 0 fec 0                                                                                                                                                                                                                                                                                                                                                                                                        ";
#include <string.h>



/* OPNET system definitions */
#include <opnet.h>



/* Header Block */

/* Include files.					*/
#include	<oms_dist_support.h>
#include	"lr_wpan_support.h"
#include	"lr_wpan_stat_write.h"

/* Special attribute values.		*/
#define		SSC_INFINITE_TIME		-1.0

/* Interrupt code values.			*/
#define		SSC_START				0
#define		SSC_GENERATE			1
#define		SSC_STOP				2

/* Node configuration constants.	*/
#define		SSC_STRM_TO_LOW			0

/* Macro definitions for state		*/
/* transitions.						*/
#define		START				(INTRPT_SELF && intrpt_code == SSC_START)
#define		DISABLED			(INTRPT_SELF && intrpt_code == SSC_STOP)
#define		STOP				(INTRPT_SELF && intrpt_code == SSC_STOP)
#define		PACKET_GENERATE		(INTRPT_SELF && intrpt_code == SSC_GENERATE)

#define		ODB_GEN_PRINT_MESSAGE(a)	if (ODB_GENERATOR_ENABLED)\
	printf ("%s Generator (%d): %.9f s: %s\n",\
	lr_wpan_node_name, own_id, op_sim_time (), a)

/* structure for the round-robin mechanism */
typedef struct {
	int index;		// current subqueue index to store the packet
	int nb_element;	// total number of subqueues
} Wpan_RR_Param;

/* strucure for the statistics collection */
typedef struct {
	int Pkt_Rcvd;
	int Bits_Rcvd;
	int Pkt_Sent;
	int Bits_Sent;
	double Delay;
} Wpan_Ss_Stat;

int lr_wpan_bulk_data_id;
double lr_wpan_start_time_shift = 0.0;

/* Function prototypes.				*/
static void		lr_wpan_ss_pkt_generate (void);
static void		lr_wpan_rr_init (void);
static void		lr_wpan_ss_pkt_recv (void);
static void		lr_wpan_ss_collect_stat (void);

/* End of Header Block */

#if !defined (VOSD_NO_FIN)
#undef	BIN
#undef	BOUT
#define	BIN		FIN_LOCAL_FIELD(_op_last_line_passed) = __LINE__ - _op_block_origin;
#define	BOUT	BIN
#define	BINIT	FIN_LOCAL_FIELD(_op_last_line_passed) = 0; _op_block_origin = __LINE__;
#else
#define	BINIT
#endif /* #if !defined (VOSD_NO_FIN) */



/* State variable definitions */
typedef struct
	{
	/* Internal state tracking for FSM */
	FSM_SYS_STATE
	/* State Variables */
	Objid	                  		own_id                                          ;	/* Object ID of the surrounding module.						 */
	double	                 		start_time                                      ;	/* Time when this source will start its packet generation	 */
	                        		                                                	/* activities.												                                 */
	double	                 		stop_time                                       ;	/* Time when this source will stop its packet generation 	 */
	                        		                                                	/* activities.												                                 */
	OmsT_Dist_Handle	       		interarrival_dist_ptr                           ;	/* PDF used to determine the interarrival times of			 */
	                        		                                                	/* generated packets.										                       */
	OmsT_Dist_Handle	       		pksize_dist_ptr                                 ;	/* PDF used to determine the sizes of generated packets.	 */
	Evhandle	               		next_pk_evh                                     ;	/* Event handle for the arrival of next packet.				 */
	double	                 		next_intarr_time                                ;	/* Time between the generation of the last packet and the	 */
	                        		                                                	/* next packet.												                                */
	Stathandle	             		bits_sent_hndl                                  ;	/* Statistic handle for "Traffic Sent (bits/sec)" statistic.	 */
	Stathandle	             		packets_sent_hndl                               ;	/* Statistic handle for "Traffic Sent (packets/sec)" statistic.	 */
	Stathandle	             		packet_size_hndl                                ;	/* Statistic handle for "Packet Size (bits)" statistic.		 */
	Stathandle	             		interarrivals_hndl                              ;	/* Statistic handle for "Packet Interaarival Time (secs)"		 */
	                        		                                                	/* statistic.													                                  */
	Wpan_RR_Param	          		round_robin                                     ;	/* round robin parameters */
	int	                    		lr_wpan_group                                   ;	/* Group number of the wpan */
	Stathandle	             		nb_packet_sent_hndl                             ;	/* Statistic handle for "Traffic Sent (Packets)" statistic. */
	Stathandle	             		nb_packet_rcv_hndl                              ;	/* Statistic handle for "Traffic Received (Packets)" statistic. */
	Stathandle	             		bits_rcvd_hndl                                  ;	/* Statistic handle for "Traffic Received (bits/sec)" statistic. */
	char	                   		lr_wpan_node_name[64]                           ;	/* Name of the name */
	Wpan_Ss_Stat	           		statistic                                       ;	/* Statistic vector */
	int	                    		mac_destination_preference                      ;	/* Option: destination MAC address of the packets */
	int *	                  		mac_address_table                               ;	/* Table of the destination MAC address in the case of a Round Robin */
	int	                    		last_wpan_packet_id                             ;	/* Remind the last packet ID (customized ID) */
	double	                 		start_time_shift                                ;	/* value to shift the start time of each devices */
	int	                    		own_mac_address                                 ;	/* Mac address of the current device */
	} lr_wpan_source_state;

#define own_id                  		op_sv_ptr->own_id
#define start_time              		op_sv_ptr->start_time
#define stop_time               		op_sv_ptr->stop_time
#define interarrival_dist_ptr   		op_sv_ptr->interarrival_dist_ptr
#define pksize_dist_ptr         		op_sv_ptr->pksize_dist_ptr
#define next_pk_evh             		op_sv_ptr->next_pk_evh
#define next_intarr_time        		op_sv_ptr->next_intarr_time
#define bits_sent_hndl          		op_sv_ptr->bits_sent_hndl
#define packets_sent_hndl       		op_sv_ptr->packets_sent_hndl
#define packet_size_hndl        		op_sv_ptr->packet_size_hndl
#define interarrivals_hndl      		op_sv_ptr->interarrivals_hndl
#define round_robin             		op_sv_ptr->round_robin
#define lr_wpan_group           		op_sv_ptr->lr_wpan_group
#define nb_packet_sent_hndl     		op_sv_ptr->nb_packet_sent_hndl
#define nb_packet_rcv_hndl      		op_sv_ptr->nb_packet_rcv_hndl
#define bits_rcvd_hndl          		op_sv_ptr->bits_rcvd_hndl
#define lr_wpan_node_name       		op_sv_ptr->lr_wpan_node_name
#define statistic               		op_sv_ptr->statistic
#define mac_destination_preference		op_sv_ptr->mac_destination_preference
#define mac_address_table       		op_sv_ptr->mac_address_table
#define last_wpan_packet_id     		op_sv_ptr->last_wpan_packet_id
#define start_time_shift        		op_sv_ptr->start_time_shift
#define own_mac_address         		op_sv_ptr->own_mac_address

/* These macro definitions will define a local variable called	*/
/* "op_sv_ptr" in each function containing a FIN statement.	*/
/* This variable points to the state variable data structure,	*/
/* and can be used from a C debugger to display their values.	*/
#undef FIN_PREAMBLE_DEC
#undef FIN_PREAMBLE_CODE
#define FIN_PREAMBLE_DEC	lr_wpan_source_state *op_sv_ptr;
#define FIN_PREAMBLE_CODE	\
		op_sv_ptr = ((lr_wpan_source_state *)(OP_SIM_CONTEXT_PTR->_op_mod_state_ptr));


/* Function Block */

#if !defined (VOSD_NO_FIN)
enum { _op_block_origin = __LINE__ + 2};
#endif

static void
lr_wpan_ss_pkt_generate (void)
{
	Packet*				pkptr;
	double				pksize;
	int					address;

	/** This function creates a packet based on the packet generation		**/
	/** specifications of the source model and sends it to the lower layer.	**/
	FIN (ss_packet_generate ());

	address = mac_destination_preference;
	
	/* debugging */
	ODB_GEN_PRINT_MESSAGE ("Sent a packet to the lower layer");
	
	/* Generate a packet size outcome.					*/
	pksize = (double) ceil (oms_dist_outcome (pksize_dist_ptr));
	
	/* Create a packet with the specified format.	*/
	pkptr = op_pk_create_fmt ("lr_wpan_bulk_data");
	op_pk_total_size_set (pkptr, pksize);
	
	/* complete the address */
	if (address == -1)
		{
		/* in this case, we must apply a round robin */
		address = mac_address_table[round_robin.index ++];
		round_robin.index %= round_robin.nb_element;
		}
	
	if (op_pk_nfd_set_int32 (pkptr, "Address", address) == OPC_COMPCODE_FAILURE ||
		op_pk_nfd_set_int32 (pkptr, "Src address", own_mac_address) == OPC_COMPCODE_FAILURE ||
		op_pk_nfd_set_int32 (pkptr, "ID", lr_wpan_bulk_data_id++) == OPC_COMPCODE_FAILURE)
		lr_wpan_mac_error ("ss_packet_generate:", "Unable to set the packet address.", OPC_NIL);
	
	/* Update the packet generation statistics.			*/
	op_stat_write (packets_sent_hndl, 1.0);
	op_stat_write (packets_sent_hndl, 0.0);
	op_stat_write (bits_sent_hndl, (double) pksize);
	op_stat_write (bits_sent_hndl, 0.0);
	op_stat_write (packet_size_hndl, (double) pksize);
	op_stat_write (interarrivals_hndl, next_intarr_time);
	
	/* More statistics */
	op_stat_write (nb_packet_sent_hndl, 1.0);
	
	statistic.Pkt_Sent++;
	statistic.Bits_Sent += (int) pksize;


	/* Send the packet via the stream to the lower layer.	*/
	op_pk_send (pkptr, SSC_STRM_TO_LOW);

	FOUT;
}	


/*
 * Function:	lr_wpan_rr_init
 */

static void
lr_wpan_rr_init (void)
{
	Wpan_Node_Param * element;
	int list_size;
	int nb_element = 0;
	int i; // loop variable
	Objid node_objid;
	
	
	FIN (lr_wpan_subq_allocation ());
	
	node_objid = op_topo_parent (own_id);
	
			
	/* read the MAC address fields */
	op_ima_obj_attr_get (own_id, "Mac Address Destination", &mac_destination_preference);
			
	/* counting the number of device in the same group */
	if (wpan_node_param_list == NULL)
		lr_wpan_mac_error ("lr_wpan_rr_init:", "No device register.", OPC_NIL);
	else
		list_size = op_prg_list_size (wpan_node_param_list);
	
	/* allocate some space memory for the mac address table */
	mac_address_table = (int *) op_prg_mem_alloc (list_size * sizeof (int));
	
	for (i = 0; i<list_size; i++)
		{
		/* access the element in the ith position */
		if ((element = op_prg_list_access (wpan_node_param_list, i)) == NULL)
			lr_wpan_mac_error ("lr_wpan_rr_init:", "Cannot access the topology parameters.", OPC_NIL);
		
		/* counting the element in the same group */
		if (!strcmp(element->type, "wpan") && element->group == lr_wpan_group && element->parent_id != node_objid)
			{
			/* complete the table and increase the number of element */
			mac_address_table[nb_element++] = element->mac_address;
			}
		}
	
	/* control the number of wpan */
	if (nb_element <= 0)
		lr_wpan_mac_error ("lr_wpan_rr_init:", "No association is made.", OPC_NIL);
	
	round_robin.nb_element = nb_element;
	round_robin.index = 0;
	
	/* get our own MAC address */
	own_mac_address = wpan_get_mac_address (node_objid);
	
	FOUT;
}


/*
 * Function:	lr_wpan_ss_pkt_recv
 */

static void
lr_wpan_ss_pkt_recv (void)
{
	Packet * pkptr;
	double pksize;
	int id_wpan_packet;
	char name[64];
	int src_mac_address;
	int pos_index;
	Wpan_Node_Param * element;
	
	FIN (lr_wpan_ss_pkt_recv ());
	
	/* debugging */
	ODB_GEN_PRINT_MESSAGE ("Received a packet from the lower layer");
	
	/* get the packet */
	pkptr = op_pk_get (op_intrpt_strm ());
	
	/* get the size of the packet */
	pksize = op_pk_total_size_get (pkptr);
	
	/* write some statistics */
	op_stat_write (nb_packet_rcv_hndl, 1.0);
	op_stat_write (bits_rcvd_hndl, (double) pksize);
	op_stat_write (bits_rcvd_hndl, 0.0);
	
	statistic.Pkt_Rcvd ++;
	statistic.Bits_Rcvd += (int) pksize;
	statistic.Delay += op_sim_time () - op_pk_stamp_time_get (pkptr);
	
	/* get the packet ID */
	op_pk_nfd_get (pkptr, "ID", &id_wpan_packet);
	
	/* get the source MAC address */
	op_pk_nfd_get (pkptr, "Src address", &src_mac_address);
	
	/* search the information about the source module in the list of nodes */
	if ((pos_index = wpan_search_mac_address (src_mac_address)) == -1)
		lr_wpan_mac_error ("lr_wpan_ss_pkt_recv:", "Cannot access the source node parameters.", OPC_NIL);
		
	/* get the information */
	element = op_prg_list_access (wpan_node_param_list, pos_index);
	
	/* update the share statistic */
	element->share_statistic ++;
	
	if (last_wpan_packet_id && id_wpan_packet == last_wpan_packet_id)
		{
		/* get the name of the source node of the packet */
		op_ima_obj_attr_get_str (op_topo_parent (op_pk_stamp_mod_get(pkptr)), "name", 64, name);
		
		printf ("|------------------------------------------------\n");
		printf ("| The packet %d was already received by %s\n", id_wpan_packet, lr_wpan_node_name);
		printf ("| Creation time of the packet: %.12f s\n", op_pk_stamp_time_get (pkptr));
		printf ("| Current time: %.12f\n", op_sim_time ());
		printf ("| Source node: %s\n", name);
		printf ("|------------------------------------------------\n");
		
		/* set a breakpoint */
		op_prg_odb_bkpt ("wpan_id");
		}

	/* update the last packet */
	last_wpan_packet_id = id_wpan_packet;
	
	/* destroy the packet */
	op_pk_destroy (pkptr);
	
	FOUT;
}


/*
 * Function:	lr_wpan_ss_collect_stat
 *
 * Description:	collect data at the end of the simulation
 *
 * No parameter
 */

static void
lr_wpan_ss_collect_stat (void)
{
	FILE * fp;
	char report_name[64], date_str[32];
	Boolean exist;
	double delay = -1.0;
	time_t date;
	int pos_index;
	Wpan_Node_Param * element;
	
	
	FIN (lr_wpan_collect_stat ());
	
	/* get the date of the day */
	time (&date);
	sprintf (date_str, "%s", ctime (&date));
		
	/* search the information about this module in the list of nodes */
	if ((pos_index = wpan_search_mac_address (own_mac_address)) == -1)
		lr_wpan_mac_error ("lr_wpan_ss_pkt_recv:", "Cannot access the curent node parameters.", OPC_NIL);
		
	/* get the information */
	element = op_prg_list_access (wpan_node_param_list, pos_index);
	
	/* start printing report */
	/* get the report name */
	sprintf (report_name, "%s_generator.txt", lr_wpan_node_name);
	
	fp = lr_wpan_open_report_file (report_name, &exist);
	
	if (!exist)
		{
		fprintf (fp, "\t*** Simple source of the node %s ***\n", lr_wpan_node_name);
		fprintf (fp, "\tCreation date: %s\n", date_str);
		fprintf (fp, "Total packets sent, Packets well done, Total bits sent, Total packet rcvd, Total bits rcvd, Higher layer delay, Simulation time, last update\n");
		}
	
	/* compute the delay for the packet received */
	if (statistic.Pkt_Rcvd)
		delay = statistic.Delay / (double) statistic.Pkt_Rcvd;
	
	fprintf (fp, "%s, %s, %s, %s, %s, %s, %s, %s", integer_to_string(statistic.Pkt_Sent, strlen ("Total packets sent")),
		integer_to_string(element->share_statistic, strlen ("Packets well done")),
		integer_to_string(statistic.Bits_Sent, strlen ("Total bits sent")),
		integer_to_string(statistic.Pkt_Rcvd, strlen ("Total packet rcvd")),
		integer_to_string(statistic.Bits_Rcvd, strlen ("Total bits rcvd")),
		double_to_string (delay, strlen ("Higher layer delay")),
		double_to_string (op_sim_time (), strlen ("Simulation time")),
		date_str);
	
	fclose (fp);
	
	
	FOUT;
}

/* End of Function Block */

/* Undefine optional tracing in FIN/FOUT/FRET */
/* The FSM has its own tracing code and the other */
/* functions should not have any tracing.		  */
#undef FIN_TRACING
#define FIN_TRACING

#undef FOUTRET_TRACING
#define FOUTRET_TRACING

#if defined (__cplusplus)
extern "C" {
#endif
	void lr_wpan_source (OP_SIM_CONTEXT_ARG_OPT);
	VosT_Obtype _op_lr_wpan_source_init (int * init_block_ptr);
	void _op_lr_wpan_source_diag (OP_SIM_CONTEXT_ARG_OPT);
	void _op_lr_wpan_source_terminate (OP_SIM_CONTEXT_ARG_OPT);
	VosT_Address _op_lr_wpan_source_alloc (VosT_Obtype, int);
	void _op_lr_wpan_source_svar (void *, const char *, void **);


	VosT_Obtype Vos_Define_Object_Prstate (const char * _op_name, size_t _op_size);
	VosT_Address Vos_Alloc_Object (VosT_Obtype _op_ob_hndl);
	VosT_Fun_Status Vos_Poolmem_Dealloc (VosT_Address _op_ob_ptr);
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif




/* Process model interrupt handling procedure */


void
lr_wpan_source (OP_SIM_CONTEXT_ARG_OPT)
	{
#if !defined (VOSD_NO_FIN)
	int _op_block_origin = 0;
#endif
	FIN_MT (lr_wpan_source ());

		{
		/* Temporary Variables */
		/* Variables used in the "init" state.		*/
		char		interarrival_str [128];
		char		size_str [128];
		int			lr_wpan_profile;
		
		/* Variables used in state transitions.		*/
		int			intrpt_code;
		/* End of Temporary Variables */


		FSM_ENTER ("lr_wpan_source")

		FSM_BLOCK_SWITCH
			{
			/*---------------------------------------------------------*/
			/** state (Init) enter executives **/
			FSM_STATE_ENTER_UNFORCED (0, "Init", state0_enter_exec, "lr_wpan_source [Init enter execs]")
				FSM_PROFILE_SECTION_IN ("lr_wpan_source [Init enter execs]", state0_enter_exec)
				{
				/* Debugging */
				ODB_GEN_PRINT_MESSAGE ("Enter the Init state");
				
				/* At this initial state, we read the values of source attributes	*/
				/* and schedule a selt interrupt that will indicate our start time	*/
				/* for packet generation.											*/
				
				/* Obtain the object id of the surrounding module.					*/
				own_id = op_id_self ();
				
				/* Read the values of the packet generation parameters, i.e. the	*/
				/* attribute values of the surrounding module.						*/
				op_ima_obj_attr_get (own_id,				 "Predefined Profiles", &lr_wpan_profile);
				
				switch (lr_wpan_profile)
					{
					case 0:
						/* Set the profile for ECG */
						sprintf (interarrival_str,	"constant (0.25)");
						sprintf (size_str, 			"constant (3984)");
					break;
					
					case 1:
						/* Set the profile for Blood Analysis */
						sprintf (interarrival_str,	"constant (1.0)");
						sprintf (size_str, 			"constant (1456)");
					break;
					
					case 2:
						/* Set the profile for System & Control */
						sprintf (interarrival_str,	"constant (1.0)");
						sprintf (size_str, 			"constant (760)");
					break;
					
					case 3:
						/* Set the profile for Status & Alarm */
						sprintf (interarrival_str,	"constant (60)");
						sprintf (size_str, 			"constant (632)");
					break;
					
					case -1:
						/* if the no predefined profile is selected, read the manual settings */
						op_ima_obj_attr_get (own_id, "Packet Interarrival Time", interarrival_str);
						op_ima_obj_attr_get (own_id, "Packet Size",              size_str);
					break;
					}
				
				op_ima_obj_attr_get (own_id,				 "Start Time",               &start_time);
				op_ima_obj_attr_get (own_id,				 "Stop Time",                &stop_time);
				op_ima_obj_attr_get (own_id, 				 "Group number",			 &lr_wpan_group);
				op_ima_obj_attr_get_str (op_topo_parent(own_id), "name", 64, lr_wpan_node_name);
				
				if (start_time != SSC_INFINITE_TIME)
					{
					/* get the start time shift */
					op_ima_obj_attr_get_dbl (own_id, "Start time shift", &start_time_shift);
					
					/* compute the new start time */
					start_time += lr_wpan_start_time_shift;
					lr_wpan_start_time_shift += start_time_shift;
					}
				
				
				/* initialize the statistic vector */
				statistic.Pkt_Rcvd 	= 0;
				statistic.Bits_Rcvd	= 0;
				statistic.Pkt_Sent	= 0;
				statistic.Bits_Sent	= 0;
				statistic.Delay		= 0.0;
				
				/* Load the PDFs that will be used in computing the packet			*/
				/* interarrival times and packet sizes.								*/
				interarrival_dist_ptr = oms_dist_load_from_string (interarrival_str);
				pksize_dist_ptr       = oms_dist_load_from_string (size_str);
				
				/* set a priority to interupt self event */
				op_intrpt_priority_set (OPC_INTRPT_SELF, SSC_START, 1);
				
				
				/* Make sure we have valid start and stop times, i.e. stop time is	*/
				/* not earlier than start time.										*/
				if ((stop_time <= start_time) && (stop_time != SSC_INFINITE_TIME))
					{
					/* Stop time is earlier than start time. Disable the source.	*/
					start_time = SSC_INFINITE_TIME;
				
					/* Display an appropriate warning.								*/
					op_prg_odb_print_major ("Warning from simple packet generator model (simple_source):", 
											"Although the generator is not disabled (start time is set to a finite value),",
											"a stop time that is not later than the start time is specified.",
											"Disabling the generator.", OPC_NIL);
					}
				
				/* Schedule a self interrupt that will indicate our start time for	*/
				/* packet generation activities. If the source is disabled,			*/
				/* schedule it at current time with the appropriate code value.		*/
				if (start_time == SSC_INFINITE_TIME)
					{
					op_intrpt_schedule_self (op_sim_time (), SSC_STOP);
					}
				else
					{
					/* Schedule the first packet to be sent */
					op_intrpt_schedule_self (start_time, SSC_GENERATE);
					
					/* event to go to the idle state */
					op_intrpt_schedule_self (op_sim_time (), SSC_START);
				
					/* In this case, also schedule the interrupt when we will stop	*/
					/* generating packets, unless we are configured to run until	*/
					/* the end of the simulation.									*/
					if (stop_time != SSC_INFINITE_TIME)
						{
						op_intrpt_schedule_self (stop_time, SSC_STOP);
						}
					}
				
				/* initialize the ID of the WPAN bulk data */
				lr_wpan_bulk_data_id = 0;
				last_wpan_packet_id = 0;
				
				/* Register the statistics that will be maintained by this model.	*/
				bits_sent_hndl     	= op_stat_reg ("Generator.Traffic Sent (bits/sec)",			OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				packets_sent_hndl   = op_stat_reg ("Generator.Traffic Sent (packets/sec)",		OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				packet_size_hndl    = op_stat_reg ("Generator.Packet Size (bits)",              OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				interarrivals_hndl  = op_stat_reg ("Generator.Packet Interarrival Time (secs)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				
				/* More statistics */
				nb_packet_sent_hndl	= op_stat_reg ("Generator.Traffic Sent (packets)",			OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				nb_packet_rcv_hndl	= op_stat_reg ("Generator.Traffic Received (packets)",		OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				bits_rcvd_hndl		= op_stat_reg ("Generator.Traffic Received (bits/sec)",		OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				}
				FSM_PROFILE_SECTION_OUT (state0_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (1,"lr_wpan_source")


			/** state (Init) exit executives **/
			FSM_STATE_EXIT_UNFORCED (0, "Init", "lr_wpan_source [Init exit execs]")
				FSM_PROFILE_SECTION_IN ("lr_wpan_source [Init exit execs]", state0_exit_exec)
				{
				/* Debugging */
				ODB_GEN_PRINT_MESSAGE ("Start the RR Init");
				
				/* initialize the WPAN round robin */
				lr_wpan_rr_init ();
				
				/* Determine the code of the interrupt, which is used in evaluating	*/
				/* state transition conditions.										*/
				intrpt_code = op_intrpt_code ();
				}
				FSM_PROFILE_SECTION_OUT (state0_exit_exec)


			/** state (Init) transition processing **/
			FSM_PROFILE_SECTION_IN ("lr_wpan_source [Init trans conditions]", state0_trans_conds)
			FSM_INIT_COND (START)
			FSM_TEST_COND (DISABLED)
			FSM_TEST_COND (END_SIM)
			FSM_TEST_LOGIC ("Init")
			FSM_PROFILE_SECTION_OUT (state0_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 1, state1_enter_exec, ;, "START", "", "Init", "Idle", "lr_wpan_source [Init -> Idle : START / ]")
				FSM_CASE_TRANSIT (1, 2, state2_enter_exec, ;, "DISABLED", "", "Init", "stop", "lr_wpan_source [Init -> stop : DISABLED / ]")
				FSM_CASE_TRANSIT (2, 0, state0_enter_exec, ;, "END_SIM", "", "Init", "Init", "lr_wpan_source [Init -> Init : END_SIM / ]")
				}
				/*---------------------------------------------------------*/



			/** state (Idle) enter executives **/
			FSM_STATE_ENTER_UNFORCED (1, "Idle", state1_enter_exec, "lr_wpan_source [Idle enter execs]")

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (3,"lr_wpan_source")


			/** state (Idle) exit executives **/
			FSM_STATE_EXIT_UNFORCED (1, "Idle", "lr_wpan_source [Idle exit execs]")
				FSM_PROFILE_SECTION_IN ("lr_wpan_source [Idle exit execs]", state1_exit_exec)
				{
				/* Determine the code of the interrupt, which is used in evaluating	*/
				/* state transition conditions.										*/
				if (INTRPT_SELF)
					intrpt_code = op_intrpt_code ();
				}
				FSM_PROFILE_SECTION_OUT (state1_exit_exec)


			/** state (Idle) transition processing **/
			FSM_PROFILE_SECTION_IN ("lr_wpan_source [Idle trans conditions]", state1_trans_conds)
			FSM_INIT_COND (STOP)
			FSM_TEST_COND (PACKET_GENERATE)
			FSM_TEST_COND (INTRPT_STRM)
			FSM_TEST_COND (END_SIM)
			FSM_TEST_LOGIC ("Idle")
			FSM_PROFILE_SECTION_OUT (state1_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 2, state2_enter_exec, ;, "STOP", "", "Idle", "stop", "lr_wpan_source [Idle -> stop : STOP / ]")
				FSM_CASE_TRANSIT (1, 3, state3_enter_exec, ;, "PACKET_GENERATE", "", "Idle", "Generate", "lr_wpan_source [Idle -> Generate : PACKET_GENERATE / ]")
				FSM_CASE_TRANSIT (2, 1, state1_enter_exec, lr_wpan_ss_pkt_recv ();, "INTRPT_STRM", "lr_wpan_ss_pkt_recv ()", "Idle", "Idle", "lr_wpan_source [Idle -> Idle : INTRPT_STRM / lr_wpan_ss_pkt_recv ()]")
				FSM_CASE_TRANSIT (3, 1, state1_enter_exec, lr_wpan_ss_collect_stat ();, "END_SIM", "lr_wpan_ss_collect_stat ()", "Idle", "Idle", "lr_wpan_source [Idle -> Idle : END_SIM / lr_wpan_ss_collect_stat ()]")
				}
				/*---------------------------------------------------------*/



			/** state (stop) enter executives **/
			FSM_STATE_ENTER_FORCED (2, "stop", state2_enter_exec, "lr_wpan_source [stop enter execs]")
				FSM_PROFILE_SECTION_IN ("lr_wpan_source [stop enter execs]", state2_enter_exec)
				{
				/* Debugging */
				ODB_GEN_PRINT_MESSAGE ("Enter the \"Stop\" state");
				
				/* When we enter into the "stop" state, it is the time for us to	*/
				/* stop generating traffic. We simply cancel the generation of the	*/
				/* next packet and go into a silent mode by not scheduling anything	*/
				/* else.															*/
				if (op_ev_valid (next_pk_evh) == OPC_TRUE)
					{
					op_ev_cancel (next_pk_evh);
					}
				
				}
				FSM_PROFILE_SECTION_OUT (state2_enter_exec)

			/** state (stop) exit executives **/
			FSM_STATE_EXIT_FORCED (2, "stop", "lr_wpan_source [stop exit execs]")


			/** state (stop) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "stop", "Idle", "lr_wpan_source [stop -> Idle : default / ]")
				/*---------------------------------------------------------*/



			/** state (Generate) enter executives **/
			FSM_STATE_ENTER_FORCED (3, "Generate", state3_enter_exec, "lr_wpan_source [Generate enter execs]")
				FSM_PROFILE_SECTION_IN ("lr_wpan_source [Generate enter execs]", state3_enter_exec)
				{
				/* Debugging */
				ODB_GEN_PRINT_MESSAGE ("Enter the \"Generate\" state");
				
				/* generate and send a packet */
				lr_wpan_ss_pkt_generate ();
				}
				FSM_PROFILE_SECTION_OUT (state3_enter_exec)

			/** state (Generate) exit executives **/
			FSM_STATE_EXIT_FORCED (3, "Generate", "lr_wpan_source [Generate exit execs]")
				FSM_PROFILE_SECTION_IN ("lr_wpan_source [Generate exit execs]", state3_exit_exec)
				{
				/* At the enter execs of the "generate" state we schedule the		*/
				/* arrival of the next packet.										*/
				next_intarr_time = oms_dist_outcome (interarrival_dist_ptr);
				
				/* Make sure that interarrival time is not negative. In that case it */
				/* will be set to 0.												 */
				if (next_intarr_time <0)
					{
					next_intarr_time = 0;
					}
				
				next_pk_evh      = op_intrpt_schedule_self (op_sim_time () + next_intarr_time, SSC_GENERATE);
				
				}
				FSM_PROFILE_SECTION_OUT (state3_exit_exec)


			/** state (Generate) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "Generate", "Idle", "lr_wpan_source [Generate -> Idle : default / ]")
				/*---------------------------------------------------------*/



			}


		FSM_EXIT (0,"lr_wpan_source")
		}
	}




void
_op_lr_wpan_source_diag (OP_SIM_CONTEXT_ARG_OPT)
	{
	/* No Diagnostic Block */
	}




void
_op_lr_wpan_source_terminate (OP_SIM_CONTEXT_ARG_OPT)
	{

	FIN_MT (_op_lr_wpan_source_terminate ())


	/* No Termination Block */

	Vos_Poolmem_Dealloc (op_sv_ptr);

	FOUT
	}


/* Undefine shortcuts to state variables to avoid */
/* syntax error in direct access to fields of */
/* local variable prs_ptr in _op_lr_wpan_source_svar function. */
#undef own_id
#undef start_time
#undef stop_time
#undef interarrival_dist_ptr
#undef pksize_dist_ptr
#undef next_pk_evh
#undef next_intarr_time
#undef bits_sent_hndl
#undef packets_sent_hndl
#undef packet_size_hndl
#undef interarrivals_hndl
#undef round_robin
#undef lr_wpan_group
#undef nb_packet_sent_hndl
#undef nb_packet_rcv_hndl
#undef bits_rcvd_hndl
#undef lr_wpan_node_name
#undef statistic
#undef mac_destination_preference
#undef mac_address_table
#undef last_wpan_packet_id
#undef start_time_shift
#undef own_mac_address

#undef FIN_PREAMBLE_DEC
#undef FIN_PREAMBLE_CODE

#define FIN_PREAMBLE_DEC
#define FIN_PREAMBLE_CODE

VosT_Obtype
_op_lr_wpan_source_init (int * init_block_ptr)
	{
	VosT_Obtype obtype = OPC_NIL;
	FIN_MT (_op_lr_wpan_source_init (init_block_ptr))

	obtype = Vos_Define_Object_Prstate ("proc state vars (lr_wpan_source)",
		sizeof (lr_wpan_source_state));
	*init_block_ptr = 0;

	FRET (obtype)
	}

VosT_Address
_op_lr_wpan_source_alloc (VosT_Obtype obtype, int init_block)
	{
#if !defined (VOSD_NO_FIN)
	int _op_block_origin = 0;
#endif
	lr_wpan_source_state * ptr;
	FIN_MT (_op_lr_wpan_source_alloc (obtype))

	ptr = (lr_wpan_source_state *)Vos_Alloc_Object (obtype);
	if (ptr != OPC_NIL)
		{
		ptr->_op_current_block = init_block;
#if defined (OPD_ALLOW_ODB)
		ptr->_op_current_state = "lr_wpan_source [Init enter execs]";
#endif
		}
	FRET ((VosT_Address)ptr)
	}



void
_op_lr_wpan_source_svar (void * gen_ptr, const char * var_name, void ** var_p_ptr)
	{
	lr_wpan_source_state		*prs_ptr;

	FIN_MT (_op_lr_wpan_source_svar (gen_ptr, var_name, var_p_ptr))

	if (var_name == OPC_NIL)
		{
		*var_p_ptr = (void *)OPC_NIL;
		FOUT
		}
	prs_ptr = (lr_wpan_source_state *)gen_ptr;

	if (strcmp ("own_id" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->own_id);
		FOUT
		}
	if (strcmp ("start_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->start_time);
		FOUT
		}
	if (strcmp ("stop_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->stop_time);
		FOUT
		}
	if (strcmp ("interarrival_dist_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->interarrival_dist_ptr);
		FOUT
		}
	if (strcmp ("pksize_dist_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pksize_dist_ptr);
		FOUT
		}
	if (strcmp ("next_pk_evh" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->next_pk_evh);
		FOUT
		}
	if (strcmp ("next_intarr_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->next_intarr_time);
		FOUT
		}
	if (strcmp ("bits_sent_hndl" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->bits_sent_hndl);
		FOUT
		}
	if (strcmp ("packets_sent_hndl" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->packets_sent_hndl);
		FOUT
		}
	if (strcmp ("packet_size_hndl" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->packet_size_hndl);
		FOUT
		}
	if (strcmp ("interarrivals_hndl" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->interarrivals_hndl);
		FOUT
		}
	if (strcmp ("round_robin" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->round_robin);
		FOUT
		}
	if (strcmp ("lr_wpan_group" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->lr_wpan_group);
		FOUT
		}
	if (strcmp ("nb_packet_sent_hndl" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->nb_packet_sent_hndl);
		FOUT
		}
	if (strcmp ("nb_packet_rcv_hndl" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->nb_packet_rcv_hndl);
		FOUT
		}
	if (strcmp ("bits_rcvd_hndl" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->bits_rcvd_hndl);
		FOUT
		}
	if (strcmp ("lr_wpan_node_name" , var_name) == 0)
		{
		*var_p_ptr = (void *) (prs_ptr->lr_wpan_node_name);
		FOUT
		}
	if (strcmp ("statistic" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->statistic);
		FOUT
		}
	if (strcmp ("mac_destination_preference" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->mac_destination_preference);
		FOUT
		}
	if (strcmp ("mac_address_table" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->mac_address_table);
		FOUT
		}
	if (strcmp ("last_wpan_packet_id" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->last_wpan_packet_id);
		FOUT
		}
	if (strcmp ("start_time_shift" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->start_time_shift);
		FOUT
		}
	if (strcmp ("own_mac_address" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->own_mac_address);
		FOUT
		}
	*var_p_ptr = (void *)OPC_NIL;

	FOUT
	}

