MIL_3_Tfile_Hdr_ 120A 107A modeler 9 3F7B2946 45228515 224 P614876 nchevrol 0 0 none none 0 0 none DF842AD6 76D6 0 0 0 0 0 0 fec 0                                                                                                                                                                                                                                                                                                                                                                                              g      @  e  i  1  5  j~  t+  t/  t3  t7  t  t  t  j4      CCA Parameters                         count       
      
      list   	   
          
                                  count                                                 list   	   	                                               	WLAN node                   Only WLAN packets                             All packet types            Only WLAN packets                uSet the type of CCA to apply in the WLAN nodes. The CCA can detect all kind of packets or just the WLAN packet types.   	WPAN node                   Only WPAN packets                             All packet types            Only WPAN packets                ~Set the type of CCA to apply in the Low Rate WPAN nodes. The CCA can detect all kind of packets or just the WPAN packet types.   Report Path                C:\                     C:\      C:\              	   
begsim intrpt         
      
   doc file            	nd_module      
endsim intrpt         
      
   failure intrpts            disabled      intrpt interval         ԲI%}      priority                    recovery intrpts            disabled      subqueue         
            count       
      
      list   	   
          
   
   super priority                          /* ID of the current module */   Objid	\my_objid;       /* ID of the current node */   Objid	\my_node_objid;       &/* type of the current interruption */   int	\intrpt_type;       (/* stream of the current interruption */   int	\intrpt_stream;       &/* code of the current interruption */   int	\intrpt_code;       #/* queue for the received packet */   List *	\channel_pkt_queue;           >   /*   ** $File : WPAN channel header   **   ** EPON model in Opnet   1** National Institute of Standards and Technology   **   B** This model was developed at the National Institute of Standards   F** and Technology by employees of the Federal Government in the course   D** of their official duties. Pursuant to title 17 Section 105 of the   ?** United States Code this software is not subject to copyright   B** protection and is in the public domain. This is an experimental   D** system.  NIST assumes no responsibility whatsoever for its use by   @** other parties, and makes no guarantees, expressed or implied,   ?** about its quality, reliability, or any other characteristic.   **   <** We would appreciate acknowledgement if the model is used.   **   A** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION   D** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER   +** RESULTING FROM THE USE OF THIS SOFTWARE.   **   !** Primary Author:      O. Rebala   #** Secondary Author:	N. Chevrollier   7** Module description:  channel for Low Rate WPAN model   )** Last Modification:   October, 1st 2005   **   */       /* include header */   #include "lr_wpan_support.h"   #include "channel_buffer.h"   #include "Physical_Layer.h"   #include <math.h>   #include "wlan_support.h"               /* define some constants */   #define PKT_DELIVERY_CODE	0   #define	WPAN_CCA_CODE 		6   #define WPAN_RX_START		8       /* State machine conditions */   %#define PACKET_RECEIVED	(INTRPT_STRM)   I#define PACKET_TO_SEND 	(INTRPT_SELF && intrpt_code == PKT_DELIVERY_CODE)       R#define     MAX_ERROR_TO_CORRECT   35  /* Maximum of errors that we can correct */       1double *bt_report_table[2][MAX_ERROR_TO_CORRECT];       /* function prototypes */   'static void 		wpan_channel_init (void);   Ystatic void 		lr_wpan_chan_error (const char * fcnt, const char * msg, const char * opt);   0static void 		lr_wpan_chan_buffer_insert (void);   =static int			channel_queue_search_pkt (OpT_Packet_Id pkt_id);   -static void 		lr_wpan_channel_pk_send (void);   Bstatic int			compute_accept_flag (Buff_Info_Packet * info_packet);   Lstatic void 		wlan_flag_transmission (const Buff_Info_Packet * info_packet);   Qstatic void 		wlan_flag_transmission_nico (const Buff_Info_Packet * info_packet);       Kstatic void			wpan_update_wlan_flag (const Buff_Info_Packet * info_packet);   Cstatic void			wpan_flag_cca (const Buff_Info_Packet * info_packet);     /*    * Function:	lr_wpan_chan_error    *   : * Descritpion: print error message and end the simulation    *    * ParamIn:		const char * fcnt    *				name of the function    *    *				const char * msg    *				error message to print    *    *				const char * opt   % *				optional error message to print    *    */       static void    Jlr_wpan_chan_error (const char * fcnt, const char * msg, const char * opt)   {   6	FIN (static void lr_wpan_mac_error (fcnt, msg, opt));   	   1	/* print error message and end the simulation */   1	op_sim_end ("LR WPAN Channel:", fcnt, msg, opt);   	   	FOUT;   }           /*    * Function:	wpan_channel_init    *   / * Description:	initialization the channel node    *    * No parameter    */       static void    wpan_channel_init (void)   {   	Objid cca_param_comp_objid;   	Objid cca_param_objid;   	   	FIN (wpan_channel_init ());   	   3	/* initialize the pointer to the channel buffer */   	channel_buffer_ptr = NULL;   	   !	/* record the channel node id */   	wpan_channel_objid = my_objid;   	   	/* init the channel queue */   +	channel_pkt_queue = op_prg_list_create ();   	   (	/* get the WPAN Parameters Object ID */   I	op_ima_obj_attr_get (my_objid, "CCA Parameters", &cca_param_comp_objid);   P	cca_param_objid = op_topo_child (cca_param_comp_objid, OPC_OBJTYPE_GENERIC, 0);   	   	/* get the WPAN CCA mode */   M	op_ima_obj_attr_get (cca_param_objid, "WPAN node", &wpan_cca_all_pkt_types);   M	op_ima_obj_attr_get (cca_param_objid, "WLAN node", &wlan_cca_all_pkt_types);   	   	   	/* print informations */   P	printf ("\n+--------------------------------------------------------------\n");   %	printf ("| Channel Information:\n");   w	printf ("| \tWPAN CCA mode: %s\n", wpan_cca_all_pkt_types ? "All packet types checked" : "Only WPAN packets checked");   N	printf ("+--------------------------------------------------------------\n");   	   	FOUT;   }           /*   ' * Function:	lr_wpan_chan_buffer_insert    *   C * Description:	insert the received packet into the channel buffer.   @ *				All the packet we receive are linked with an ICI structure   < *				which contain the infoamtion about the packet type and     *				the position of the nodes.   7 *				The computation of the transmission delay and the   : *				propagation delay are made here with the information   > *				collected. We record all this information in a structure    *				Buff_Info_Packet.   C *				Finally, we schedules remote interuptions for the destination   > *				and source nodes to keep track of the different delays.     *    * No parameter    */       static void    !lr_wpan_chan_buffer_insert (void)   {   	Packet * rcv_pkptr;   	Ici *	ici_ptr;    	Buff_Info_Packet * info_packet;   	double bit_rate;   	int dest_address, pos_index;   	Wpan_Node_Param * element;   	char format[64];         	   %	FIN (lr_wpan_chan_buffer_insert ());   	   	   	/* get the received packet */   8	if ((rcv_pkptr = op_pk_get (intrpt_stream)) == OPC_NIL)   S		lr_wpan_chan_error ("lr_wpan_chan_buffer_insert", "No received packet", OPC_NIL);   		   	/* get the received ICI */   6	if ((ici_ptr = op_pk_ici_get (rcv_pkptr)) == OPC_NIL)   j		lr_wpan_chan_error ("lr_wpan_chan_buffer_insert", "No ICI associates with the current packet", OPC_NIL);   	   +	if (ici_ptr == NULL || ici_ptr == OPC_NIL)   7		printf ("lr_wpan_chan_buffer_insert: Invalid ICI\n");   	   "	/* create the info packet cell */   *	info_packet = create_info_packet_cell ();   	   #	/* get information from the ici */   g	if (op_ici_attr_get (ici_ptr, "txrx distance", &info_packet->txrx_distance) == OPC_COMPCODE_FAILURE ||   M		op_ici_attr_get (ici_ptr, "bit rate", &bit_rate) == OPC_COMPCODE_FAILURE ||   Z		op_ici_attr_get (ici_ptr, "channel", &info_packet->frequency) == OPC_COMPCODE_FAILURE ||   T		op_ici_attr_get (ici_ptr, "power", &info_packet->power) == OPC_COMPCODE_FAILURE ||   `		op_ici_attr_get (ici_ptr, "packet type", &info_packet->packet_type) == OPC_COMPCODE_FAILURE ||   U		op_ici_attr_get (ici_ptr, "dest address", &dest_address) == OPC_COMPCODE_FAILURE ||   R		op_ici_attr_get (ici_ptr, "Tx x", &info_packet->tx_x) == OPC_COMPCODE_FAILURE ||   R		op_ici_attr_get (ici_ptr, "Tx y", &info_packet->tx_y) == OPC_COMPCODE_FAILURE ||   R		op_ici_attr_get (ici_ptr, "Rx x", &info_packet->rx_x) == OPC_COMPCODE_FAILURE ||   P		op_ici_attr_get (ici_ptr, "Rx y", &info_packet->rx_y) == OPC_COMPCODE_FAILURE)   _		lr_wpan_chan_error ("lr_wpan_chan_buffer_insert", "cannot read the ICI attributes", OPC_NIL);   	   Y		//op_ici_attr_get (ici_ptr, "piconet number", &piconet_number) == OPC_COMPCODE_FAILURE)   a		//lr_wpan_chan_error ("lr_wpan_chan_buffer_insert", "cannot read the ICI attributes", OPC_NIL);   	   	/* get the packet format */   "	op_pk_format (rcv_pkptr, format);   	   	/*    ;	 * destroy the ICI pointer if the packet comes from a WLAN   	 * or is a WPAN acknolegement.   ;	 * If the packet is a WPAN data, the ICI will be destroyed   ;	 * with the copy of the packet used for the retransmission   	 */   $	if (strcmp (format, "lr_wpan_mac"))   		op_ici_destroy (ici_ptr);   	   H	/* a priori, the packet is valid until the opposite statment is made */   /	if (info_packet->packet_type == WPAN_PKT_TYPE)   		{   !		info_packet->noise = OPC_FALSE;   		}   !	/* get the size of the packet */   =	info_packet->packet_size = op_pk_total_size_get (rcv_pkptr);   	   $	/* compute the propagation delay */   E	info_packet->prop_delay =  info_packet->txrx_distance / LIGHT_SPEED;   	   %	/* compute the transmission delay */   /	if (info_packet->packet_type == WLAN_PKT_TYPE)   >		info_packet->tx_delay = info_packet->packet_size / bit_rate;   4	else if (info_packet->packet_type == WPAN_PKT_TYPE)   `		info_packet->tx_delay = (info_packet->packet_size + (double) LR_WPAN_PHY_OVERHEAD) / bit_rate;   		   N	/*search the information about the destination module in the list of nodes */       4	pos_index = wpan_search_mac_address (dest_address);   	/* get the information */   T	element = (Wpan_Node_Param *) op_prg_list_access (wpan_node_param_list, pos_index);   	   		   '	/* complete the info packet pointer */   0	info_packet->packet_id		= op_pk_id (rcv_pkptr);   (	info_packet->tx_time		= op_sim_time ();   `	info_packet->delivery_time	= op_sim_time () + info_packet->prop_delay + info_packet->tx_delay;    	   +	info_packet->dest_objid		= element->objid;   /	info_packet->src_objid		= op_intrpt_source ();   	   ?	/* if the packet is a wlan packet, we update the WLAN flags */   I	if (wlan_cca_all_pkt_types || info_packet->packet_type == WLAN_PKT_TYPE)   		{   $		/* update the transmission flag */   '		wlan_flag_transmission (info_packet);   		}   	   I	if (wpan_cca_all_pkt_types || info_packet->packet_type == WPAN_PKT_TYPE)   		{   8		/* update the transmission flag of the WPAN devices */   		wpan_flag_cca (info_packet);   		}   	    A	/* Send some remote interruption according to the packet type */   /	if (info_packet->packet_type == WPAN_PKT_TYPE)   		{   c		/* if the packet is a WPAN, send an interuption to the destination node to start the reception */   o		op_intrpt_schedule_remote (op_sim_time () + info_packet->prop_delay, WPAN_RX_START, info_packet->dest_objid);   		}   4	else if (info_packet->packet_type == WLAN_PKT_TYPE)   		{   b		/* if the packet is a WLAN, send an interuption to the source module to idle the transmission */   `		op_intrpt_schedule_remote (op_sim_time () + info_packet->tx_delay, 0, info_packet->src_objid);   		}   	   E	/* schedule the interuption to send the packet to its destination */   I	op_intrpt_schedule_self (info_packet->delivery_time, PKT_DELIVERY_CODE);       (	/* insert the packet into the buffer */   .	channel_buffer_register_packet (info_packet);   	   '	/* insert the packet into the queue */   E	op_prg_list_insert (channel_pkt_queue, rcv_pkptr, OPC_LISTPOS_TAIL);   	   	/* debug informations */   	if (ODB_CHANNEL_BUFFER)   		{   @		printf ("\n+---------------------------------------------\n");   q		printf ("| Channel buffer: %.12f s\n|\tpropagation delay: %.12f s\n", op_sim_time (), info_packet->prop_delay);   {		printf ("|\ttransmission delay: %.9f s\n|\tdelivery time: %.12f s\n", info_packet->tx_delay, info_packet->delivery_time);   >		printf ("+---------------------------------------------\n");   		}   	   	   	FOUT;   }           /*   % * Function:	channel_queue_search_pkt    *   ? * Description:	search a packet in the channel queue, according   2 *				to the packet ID in parameter and return the   4 *				index of this packet in the list if it exists,    *				otherwise return -1    *   ! * ParamIn:		OpT_Packet_Id pkt_id     *				ID of the packet to search    *    * ParamOut:	int pos_index   # *				position index of the element    */       static int    /channel_queue_search_pkt (OpT_Packet_Id pkt_id)   {   	int i, pos_index = -1;   	Packet * element;   	int nbElement;   	   	   )	FIN (channel_queue_search_pkt (pkt_id));   	   2	nbElement = op_prg_list_size (channel_pkt_queue);   	   $	/* chack if the list is not null */   	if (!nbElement)   U		lr_wpan_chan_error ("channel_queue_search_pkt:", "No packet registered.", OPC_NIL);       .	/* search the element in the list of nodes */    	for (i = 0; i < nbElement; i++)   		{   		/* access the element */   6		element = op_prg_list_access (channel_pkt_queue, i);   		   		/* check the MAC address*/   "		if (op_pk_id(element) == pkt_id)   			pos_index = i;   		}   		   	FRET (pos_index);   }           /*   $ * Function:	lr_wpan_channel_pk_send    */       static void    lr_wpan_channel_pk_send (void)   {    	Buff_Info_Packet * info_packet;   	Packet * pkptr;   	int pos_index;   	int accept;   "	FIN (lr_wpan_channel_pk_send ());   	   0	/* get the information of the packet to send */   /	info_packet = search_pkt_info_for_delivery ();   	   7	/* get the packet according to the information cell */   K	if ((pos_index = channel_queue_search_pkt (info_packet->packet_id)) == -1)   \		lr_wpan_chan_error ("lr_wpan_channel_pk_send:", "No packet found in the queue.", OPC_NIL);   	   /	/* remove the packet from the channel queue */   L	if ((pkptr = op_prg_list_remove (channel_pkt_queue, pos_index)) == OPC_NIL)   c		lr_wpan_chan_error ("lr_wpan_channel_pk_send:", "Cannot remove packet from the queue.", OPC_NIL);   		   	/* compute the accept flag */   ,	accept = compute_accept_flag (info_packet);   	   	/* set the accept flag */   )	op_pk_nfd_set (pkptr, "Accept", accept);   	   	/* Set the noise flag */   /	if (info_packet->packet_type == WPAN_PKT_TYPE)   		{   5		op_pk_nfd_set (pkptr, "Noise", info_packet->noise);   		}   	   /	if (info_packet->packet_type == WPAN_PKT_TYPE)   		{	   *		/* send the packet to its destination */   4		op_pk_deliver (pkptr, info_packet->dest_objid, 1);   		}   	else   		{   6		 op_pk_deliver (pkptr, info_packet->dest_objid, 0);	   		 }   		   '	/* remove the packet from the queue */   ,	channel_buffer_remove_packet (info_packet);         	FOUT;   }               /*     * Function:	compute_accept_flag    *    * Description	    */       
static int   4compute_accept_flag (Buff_Info_Packet * info_packet)   {   	int i; // loop variable   =	double ber = 0.0, distance_interferer, distance_transmitter;   T	double delta_x, delta_y; // difference beetween Receiver and Interferer coordinates   I	Buff_Info_Packet * info_packet_interferer = info_packet->next_collision;   2	int packet_size = (int) info_packet->packet_size;   2	double power_packet_w, power_packet_interferer_w;   	   )	FIN (compute_accept_flag (info_packet));   	       5	/* check the number of collisions with the packet */   %	if (info_packet->nb_collisions == 1)   		{   6		/* the packet has no collision, so it is accepted */   		FRET (1);   		}   	   	   D	/* We are in the case that that packet has at least 1 collisions */   '	while (info_packet_interferer != NULL)   	   {   -		//chan_buffer_print_info_pkt (info_packet);   		   9	 // chan_buffer_print_info_pkt (info_packet_interferer);   		   F		/* compute the distance beetween the transmitter and the receiver */   2		delta_x = info_packet->rx_x - info_packet->tx_x;   2		delta_y = info_packet->rx_y - info_packet->tx_y;   F		distance_transmitter = sqrt (delta_x * delta_x + delta_y * delta_y);   		   		   E		/* compute the distance beetween the interferer and the receiver */   =		delta_x = info_packet->rx_x - info_packet_interferer->tx_x;   =		delta_y = info_packet->rx_y - info_packet_interferer->tx_y;   E		distance_interferer = sqrt (delta_x * delta_x + delta_y * delta_y);   		   3		power_packet_w = power_packet_interferer_w = 0.0;   2		/* if BT an WPAN conversion of the power in W */   0		if (info_packet->packet_type == WLAN_PKT_TYPE)   '			power_packet_w = info_packet->power;   		else   .			power_packet_w = info_packet->power / 1000;   		   ;		if (info_packet_interferer->packet_type == WLAN_PKT_TYPE)   =			power_packet_interferer_w = info_packet_interferer->power;   		else   D			power_packet_interferer_w = info_packet_interferer->power / 1000;   		   		/* compute the BER */   o		ber = coexistence_ri (info_packet->packet_type, info_packet->frequency, power_packet_w, distance_transmitter,   {			info_packet_interferer->packet_type, info_packet_interferer->frequency, power_packet_interferer_w, distance_interferer);   		   		   '		/* compute the error in the packet */   		for (i=0; i<packet_size; i++)   			{   #			if (op_dist_uniform (1.0) < ber)   				{   C				/* there is no error correction in the WLAN and WPAN devices */   >				/* if one error occur in the packet, it is not accepted */   "				op_prg_odb_bkpt ("collision");   
				FRET (0);   				}   			}   		   		/* Get the next collision */   B		info_packet_interferer = info_packet_interferer->next_collision;   		}	   	   0	/* in all other case, the packet is accepted */   
	FRET (1);   }           /*   # * Function:	wlan_flag_transmission    *    * Description:	    */       static void    =wlan_flag_transmission (const Buff_Info_Packet * info_packet)   {	   1	Ici * wlan_rx, *wlan_rx_beginning, *wlan_rx_end;   	int nb_wlan,i;   	Wpan_Node_Param * element;   	double prop_delay;   	double delivery_time;   	   ,	FIN (wlan_idle_transmission (info_packet));       	   !	/* check the information cell */   )	if (info_packet->delivery_time	== 0.0 ||   $		info_packet->prop_delay		== 0.0 ||   "		info_packet->tx_delay		== 0.0 ||   "		info_packet->dest_objid		== 0 ||   		info_packet->src_objid		== 0)   		op_sim_message ("FUNCTION WARNING: \"wlan_flag_transmission\" of the LR WPAN Channel", "Some informations of the cell are set to the default value.");         	   /	if (info_packet->packet_type == WLAN_PKT_TYPE)   		{   "		/* check the information cell */   		if (info_packet == NULL)   Z			lr_wpan_chan_error ("wpan_update_wlan_flag:", "No packet information found.", OPC_NIL);   	   .		/* get the number of WLAN in the topology */   ,		nb_wlan = wpan_list_size_get_wlan_node ();   		   5		/* For each WLAN, we need to send an interuption */   		for (i = 0; i < nb_wlan; i++)   			{   			/* get the WLAN device */   '			element = wpan_search_wlan_node (i);   R			//printf(" device %d, packet %d,\n", element->objid, info_packet->dest_objid );   			   1			if( element->objid == info_packet->dest_objid)   				{   				/*    L				* We create an ICI to send the packet delivery time to the wlan receiver   B				* in order to update the "rx_end_time" field of the MAC layer    				*/   8				wlan_rx = (Ici *) op_ici_create ("ici_wlan_rx_end");   		   `				if (op_ici_attr_set_int32 (wlan_rx, "Packet Type", WLAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||   n					op_ici_attr_set_dbl (wlan_rx, "End of Transmission", info_packet->delivery_time) == OPC_COMPCODE_FAILURE)   W					lr_wpan_chan_error ("wlan_flag_transmission:", "Unable to set the ICI.", OPC_NIL);   		   5				/* install the ici with the first interruption */   				op_ici_install (wlan_rx);   		   X				/* send an interuption to the destination module to update the power transmission */   e				op_intrpt_schedule_remote (op_sim_time () + info_packet->prop_delay, 0, info_packet->dest_objid);   	   %				/* Deinstall the ici mechanism */   				op_ici_install (OPC_NIL);   				}   			else   				{   w				if ((element->parent_id != op_topo_parent(info_packet->src_objid))&&(element->frequency == info_packet->frequency))   					{   (					/* compute the propagation delay */   [					prop_delay = sqrt((info_packet->tx_x - element->x)*(info_packet->tx_x - element->x) +    W						(info_packet->tx_y - element->y)*(info_packet->tx_y - element->y)) / LIGHT_SPEED;   		   $					/* compute the delivery time */   W					delivery_time = info_packet->delivery_time - info_packet->prop_delay + prop_delay;   					   					/*    M					* We create an ICI to send the packet delivery time to the wlan receiver   C					* in order to update the "rx_end_time" field of the MAC layer    					*/   C					wlan_rx_beginning = (Ici *) op_ici_create ("ici_wlan_rx_end");   					   k					if (op_ici_attr_set_int32 (wlan_rx_beginning, "Packet Type", WLAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||   l						op_ici_attr_set_dbl (wlan_rx_beginning, "End of Transmission", delivery_time) == OPC_COMPCODE_FAILURE)   W						lr_wpan_chan_error ("wpan_update_wlan_flag:", "Unable to set the ICI.", OPC_NIL);   		   7					/* install the ici with the first interruption */    (					op_ici_install (wlan_rx_beginning);   		   Y					/* send an interuption to the destination module to update the power transmission */   P					op_intrpt_schedule_remote (op_sim_time () + prop_delay, 0, element->objid);   					   &					/* Deinstall the ici mechanism */   					op_ici_install (OPC_NIL);   					   =					wlan_rx_end = (Ici *) op_ici_create ("ici_wlan_rx_end");   					   e					if (op_ici_attr_set_int32 (wlan_rx_end, "Packet Type", WLAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||   h						op_ici_attr_set_dbl (wlan_rx_end, "End of Transmission", delivery_time) == OPC_COMPCODE_FAILURE ||   j						op_ici_attr_set_dbl (wlan_rx_end, "Packet Size", info_packet->packet_size) == OPC_COMPCODE_FAILURE )   W						lr_wpan_chan_error ("wpan_update_wlan_flag:", "Unable to set the ICI.", OPC_NIL);   		   7					/* install the ici with the first interruption */    "					op_ici_install (wlan_rx_end);   					   B					op_intrpt_schedule_remote (delivery_time, 1, element->objid);   					   					op_ici_install (OPC_NIL);   					   					}   				}   			}	   		   		}   	else   		{   ^		/* if the packet is from a WPAN, we have to send a power transmission in each WLAN device */   &		wpan_update_wlan_flag (info_packet);   		}   	   	FOUT;   }               /*   " * Function:	wpan_update_wlan_flag    *   = * Description:	send a power transmission to all WLAN devices   5 *				if a WPAN send a packet and the CCA of the WLAN    *				detects all packet type    */       static void   <wpan_update_wlan_flag (const Buff_Info_Packet * info_packet)   {   	Ici * wlan_rx;   
	int nb_wlan;   	int i; // loop variable   	Wpan_Node_Param * element;   	double prop_delay;   	double delivery_time;   	   +	FIN (wpan_update_wlan_flag (info_packet));   	   !	/* check the information cell */   	if (info_packet == NULL)   Y		lr_wpan_chan_error ("wpan_update_wlan_flag:", "No packet information found.", OPC_NIL);   	   -	/* get the number of WLAN in the topology */   +	nb_wlan = wpan_list_size_get_wlan_node ();   		   4	/* For each WLAN, we need to send an interuption */   	for (i = 0; i < nb_wlan; i++)   		{   		/* get the WLAN device */   &		element = wpan_search_wlan_node (i);   		   %		/* compute the propagation delay */   X		prop_delay = sqrt((info_packet->tx_x - element->x)*(info_packet->tx_x - element->x) +    T			(info_packet->tx_y - element->y)*(info_packet->tx_y - element->y)) / LIGHT_SPEED;   		   !		/* compute the delivery time */   T		delivery_time = info_packet->delivery_time - info_packet->prop_delay + prop_delay;   		   		/*    J		* We create an ICI to send the packet delivery time to the wlan receiver   @		* in order to update the "rx_end_time" field of the MAC layer    		*/   6		wlan_rx = (Ici *) op_ici_create ("ici_wlan_rx_end");   		   ^		if (op_ici_attr_set_int32 (wlan_rx, "Packet Type", WPAN_PKT_TYPE) == OPC_COMPCODE_FAILURE ||   _			op_ici_attr_set_dbl (wlan_rx, "End of Transmission", delivery_time) == OPC_COMPCODE_FAILURE)   T			lr_wpan_chan_error ("wpan_update_wlan_flag:", "Unable to set the ICI.", OPC_NIL);   		   3		/* install the ici with the first interruption */   		op_ici_install (wlan_rx);   		   V		/* send an interuption to the destination module to update the power transmission */   M		op_intrpt_schedule_remote (op_sim_time () + prop_delay, 0, element->objid);   			   #		/* Deinstall the ici mechanism */   		op_ici_install (OPC_NIL);   		}   		   	FOUT;   }           /*   # * Function:	wpan_flag_transmission    *    * Description:	    */       static void   4wpan_flag_cca (const Buff_Info_Packet * info_packet)   {   	Wpan_Node_Param * element;   9	int list_size = op_prg_list_size (wpan_node_param_list);   	int i; // loop variable   	double distance;   	double prop_delay;   	   #	FIN (wpan_flag_cca (info_packet));   	   !	/* check the information cell */    	if (info_packet->tx_x == 0.0 ||   		info_packet->tx_y == 0.0)   		op_sim_message ("FUNCTION WARNING: \"wpan_flag_cca\" of the LR WPAN Channel", "Some informations of the cell are set to the default value.");   	   	/*   6	 * We check all the node list to know whether we need   &	 * to send an interuption for the CCA   	 */   	for (i=0; i<list_size; i++)   		{   (		/* get the element in the node list */   9		element = op_prg_list_access (wpan_node_param_list, i);   "		/* if the node asks for a CCA */   ;		// equality of frequencies depends on detection mechanism   Z		//if ((element->cca_requirement) && (element->frequency_wpan == info_packet->frequency))   "		if ((element->cca_requirement))	   			{   			//printf("CCA updat\n");   3			/* compute the distance between the two nodes */   			distance = sqrt((info_packet->tx_x - element->x)*(info_packet->tx_x - element->x) + (info_packet->tx_y - element->y)*(info_packet->tx_y - element->y));   			   &			/* compute the propagation delay */   %			prop_delay = distance/LIGHT_SPEED;   						   -			/* schedule an event for the CCA period */   Z			op_intrpt_schedule_remote (op_sim_time () + prop_delay, WPAN_CCA_CODE, element->objid);   			}   		}   		   	   	FOUT   }                        chan_buffer      +Print informations about the channel buffer                          
   Init   
       
      &/* get the ID of the current module */   my_objid = op_id_self ();       $/* get the ID of the current node */   *my_node_objid = op_topo_parent (my_objid);       /* init the process */   wpan_channel_init ();       </* create a self interuption to exit the initialize state */   ,op_intrpt_schedule_self (op_sim_time (), 0);   
       
       
       
       
          pr_state                     
   Idle   
       
          
       
      &/* get the type of the interruption */    intrpt_type = op_intrpt_type ();       switch (intrpt_type)   	{   	case OPC_INTRPT_STRM:   #	intrpt_stream = op_intrpt_strm ();   	break;   	   	case OPC_INTRPT_SELF:   !	intrpt_code = op_intrpt_code ();   	break;   	   		default:   I	lr_wpan_chan_error ("Idle state:", "Unexpected interruption.", OPC_NIL);   	break;   	}   
                        pr_state           Z          
   Pkt Rcv   
       
      3/* put the packet received in the channel buffer */   lr_wpan_chan_buffer_insert ();   
                     
      
          pr_state          J          
   Send   
       
      4/* forward the packet and call the physical layer */   lr_wpan_channel_pk_send ();   
                     
      
          pr_state                        y             X          
   tr_1   
       
   PACKET_RECEIVED   
                 
@    
                                 
pr_transition                         e               
   tr_2   
                           
@     
                                 
pr_transition                             8          
   tr_3   
       
   PACKET_TO_SEND   
                 
@    
                                 
pr_transition                       :               
   tr_4   
                           
@     
                                 
pr_transition                          B     r                 
   tr_5   
       
   default   
                 
       
                                 
pr_transition      
         j        (                  
   tr_10   
                           
       
                                 
pr_transition                        
   BER   Binomial   channel_buffer   Coexistence   lr_wpan_support   oms_rr   oms_tan   Qerf   Spectrum   Util          lr_wpan_mac            