/* Process model C form file: custom_wlan_mac.pr.c */
/* Portions of this file copyright 1992-2003 by OPNET Technologies, Inc. */



/* This variable carries the header into the object file */
const char custom_wlan_mac_pr_c [] = "MIL_3_Tfile_Hdr_ 100A 30A op_runsim 7 437F6874 437F6874 1 P614876 nchevrol 0 0 none none 0 0 none 0 0 0 0 0 0 0 0 8f3 1                                                                                                                                                                                                                                                                                                                                                                                                        ";
#include <string.h>



/* OPNET system definitions */
#include <opnet.h>



/* Header Block */

/** Include files **/

#include <math.h>
#include <string.h>
#include "oms_pr.h"
#include "oms_tan.h"
#include "oms_bgutil.h"
#include "wlan_support.h"
#include "oms_auto_addr_support.h"
#include "oms_dist_support.h"
#include "bridge_header.h"	
#include "prg_mapping.h"
#include <prg_geo.h>

/* Modifications for LR WPAN model, by Olivier	*/
#include "lr_wpan_support.h"
#include "lr_wpan_stat_write.h"
/************  end of modifications  ************/


/** Constants **/

/* Modifications for LR WPAN model, by Olivier	*/
#define		INTRPT_STATUS_DEBUG	(op_prg_odb_ltrace_active("intrpt_status") == OPC_TRUE)
#define		ENTER_STATE_PRINT	printf ("%s MAC layer: %.15f s: Enter the \"%s\" state\n", wlan_name, op_sim_time (), current_state_name)
/************  end of modifications  ************/

/* Incoming statistics and stream wires.							*/
#define 	TRANSMITTER_BUSY_INSTAT		1
#define		LOW_LAYER_INPUT_STREAM		0
#define		LOW_LAYER_OUTPUT_STREAM		0

/* Flags to load different variables based on attribute settings.	*/
#define		WLAN_AP						1
#define		WLAN_STA					0

/* Flags to indicate the medium access mode (PCF/DCF).				*/
#define		PCF_ACTIVE					1
#define		PCF_INACTIVE				0

/* Special value indicating BSS identification is not used.			*/
#define		WLAN_BSSID_NOT_USED			-1

/* Special value indicating radio transceiver frequencies are set	*/
/* based on the BSS identification.									*/
#define 	WLAN_BSS_BASED_FREQ_USED	-1

/* Special value indicating that the number of back-off slots are	*/
/* not determined yet.												*/
#define		BACKOFF_SLOTS_UNSET			-1.0

/* Define a small value (= 1 psec), which will be used to recover	*/
/* from double arithmetic precision losts while doing time related	*/
/* precision sensitive computations.								*/
#define		PRECISION_RECOVERY			0.000000000001

/* Special value indicating BSS identification is currently unset.	*/
#define 	WLANC_BSS_ID_UNKNOWN		-2

/* Define the lowest data transmission rate supported by WLAN MAC.	*/
#define		LOWEST_TX_RATE				1000000.0 /* bits/sec */

/* Speed of light (m/s). 											*/
#define 	C							3.0E+08		

/* 16 times pi-squared. 											*/
#define 	SIXTEEN_PI_SQ				157.91367	

/* In the idle state, number of beacon intervals after which the STA will wake	*/
/* up to check if it is still connected, if scanning is based on beacon			*/
/* reliability. There are no interrupts pending in the idle state, therefore,	*/
/* it is possible that the STA's state may be set to "scan" from a pipeline		*/
/* state without the MAC becoming aware of the state change till a packet		*/
/* arrives from the higher layer. Hence, there is a need to schedule periodic	*/
/* interrupts when in IDLE.    													*/
#define WLANC_CONN_CHK_BEACON_MULT		5.0  

/* Period after which the STA will check for connectivity if scanning is		*/
/* distance based. 																*/
#define WLANC_CONN_CHK_DIST_INTERVAL	10.0

/* When in the SCAN state, the period that an STA will wait before trying a new	*/
/* channel. 																	*/
#define WLANC_NEW_SCAN_BEACON_MULT		2.5

/* Physical layer parameters used during roaming/channel scanning.				*/
#define	WLANC_CHANNEL_COUNT				11
#define	WLANC_FIRST_CHAN_MIN_FREQ		2401.0	/* MHz */
#define	WLANC_CHANNEL_BANDWIDTH			22.0	/* MHz */
#define	WLANC_CHANNEL_SPACING			5.0		/* MHz */
#define	WLANC_LAST_CHAN_MIN_FREQ		((WLANC_CHANNEL_COUNT - 1) * WLANC_CHANNEL_SPACING + WLANC_FIRST_CHAN_MIN_FREQ)
#define WLANC_CH_STEP_FOR_NO_OVERLAP	((int) ceil (WLANC_CHANNEL_BANDWIDTH / WLANC_CHANNEL_SPACING))	

/* When virtual scanning is used, two different thresholds are used to decide	*/
/* when the STA must start looking for a new AP, and when a new AP is			*/
/* considered acceptable. This brings in a "hysteresis" which ensures that the	*/
/* STA does not flip-flop rapidly between APs.                          		*/
#define WLANC_ROAM_SCAN_START_VIRTUAL_THRESH	rx_power_threshold
#define WLANC_ROAM_NEW_CONN_VIRTUAL_THRESH		(rx_power_threshold * 1.1)


/** Enumarated Types **/

/* Define the three possible values that a global variable takes				*/
/* to check and ensure that all the MAC modules are either BSS ID				*/
/* based or purely subnet based. The variable is initialized to					*/
/* Not_Set and the first wireless MAC process sets it to either					*/
/* Entire_Subnet (if BSS_Identifier is Not Used) or Bssid_Subnet				*/
/* (if the BSS_Identifier is set to some value other than Not					*/
/* Used).																		*/						  
typedef enum WlanT_Bssid_Approach
	{
	WlanC_Not_Set,						/* Type of network not set				*/
	WlanC_Entire_Subnet,				/* The network is a pure subnet			*/
	WlanC_Bss_Divided_Subnet			/* The network is a BSS based subnet	*/
	} WlanT_Bss_Identification_Approach;
 
/* Define interrupt codes for generating handling interrupts					*/
/* indicating changes in deference, frame timeout which infers         			*/
/* that the collision has occurred, random backoff and transmission 			*/
/* completion by the physical layer (self interrupts).							*/
typedef enum WlanT_Mac_Intrpt_Code
	{	
	WlanC_Deference_Off,  	/* Deference before frame transmission 				*/
	WlanC_Frame_Timeout,	/* No frame rcvd in set duration (infer collision)	*/
	WlanC_Backoff_Elapsed,  /* Backoff done before frame transmission			*/
	WlanC_CW_Elapsed,		/* Backoff done after successful frame transmission	*/	
	WlanC_Beacon_Tx_Time,	/* Time to transmit beacon frame                    */
	WlanC_Cfp_End,			/* End of the Contention free period 				*/
	WlanC_Scan_Timeout,		/* End of scan duration for given channel 			*/
	WlanC_AP_Check_Timeout	/* Time to check the connectivity status with the	*/
							/* current AP.										*/
	} WlanT_Mac_Intrpt_Code;

/* Defining codes for the physical layer characteristics type.					*/
typedef enum WlanT_Phy_Char_Code
	{
	WlanC_Frequency_Hopping,			
	WlanC_Direct_Sequence,				
	WlanC_Infra_Red					
	} WlanT_Phy_Char_Code;


/** Data Structures **/

/* Define a structure to maintain data fragments received by each 	  */
/* station for the purpose of reassembly (or defragmentation)		  */
typedef struct WlanT_Mac_Defragmentation_Buffer_Entry
	{		
	int			tx_station_address    ;/* Store the station address of transmitting station  		*/	 
	double		time_rcvd		      ;/* Store time the last fragment for this frame was received	*/ 
	Sbhandle	reassembly_buffer_ptr ;/* Store data fragments for a particular packet       		*/  		 
	} WlanT_Mac_Defragmentation_Buffer_Entry;

/* Define a structure to maintain a copy of each unique data frame      */
/* received by the station. This is done so that the station can    	*/
/* discard any additional copies of the frame received by it. 	   		*/
typedef struct WlanT_Mac_Duplicate_Buffer_Entry
	{	
	int         tx_station_address;  /* store the station address of transmitting station	*/
	int 		sequence_id		  ;  /* rcvd packet sequence id 						 	*/	
	int		    fragment_number	  ;  /* rcvd packet fragment number                      	*/	 
	} WlanT_Mac_Duplicate_Buffer_Entry;

/* This structure contains all the flags used in this process model to determine	*/
/* various conditions as mentioned in the comments for each flag					*/
typedef struct WlanT_Mac_Flags
	{
	Boolean 	data_frame_to_send; /* Flag to check when station needs to transmit.		*/ 
	Boolean     backoff_flag;  	    /* Backoff flag is set when either the collision is		*/
	                                /* inferred or the channel switched from busy to idle	*/
	Boolean		rts_sent;   		/* Flag to indicate that whether the Rts for this		*/
								    /* particular data frame is sent						*/
	Boolean		rcvd_bad_packet;	/* Flag to indicate that the received packet is bad		*/
    Boolean	    receiver_busy;		/* Set this flag if receiver busy stat is enabled		*/	
    Boolean	    transmitter_busy;	/* Set this flag if we are transmitting something.		*/	
	Boolean		wait_eifs_dur;		/* Set this flag if the station needs to wait for eifs	*/
									/* duration.											*/	
	Boolean		gateway_flag;		/* Set this flag if the station is a gateway.			*/
	Boolean		bridge_flag;		/* Set this flag if the station is a bridge				*/
	Boolean		immediate_xmt;		/* Set this flag if the new frame can be transmitted	*/
									/* without deferring.									*/
	Boolean		forced_bk_end;		/* Special case: resume with completion of back-off (or	*/
									/* CW) period regardless of receiver's status.			*/
	Boolean		cw_required;		/* Indicates that the MAC is in contention window		*/
									/* period following a successful transmission.			*/
	Boolean		perform_cw;			/* Flag that triggers backoff process for CW period.	*/
	Boolean		nav_updated;		/* Indicates a new NAV value since the last time when	*/
									/* self interrupt is scheduled for the end of deference.*/
	Boolean		collision;			/* Set this flag if a channel became busy while another	*/
									/* one busy.											*/
	Boolean		collided_packet;	/* Set this flag to drop the next received packet		*/
									/* because of collision.								*/
	Boolean		duration_zero;		/* Set this flag if duration should be zero in next ack	*/
	Boolean		ignore_busy;		/* Set this flag if the STA should ignore receiver busy	*/
	Boolean		tx_beacon;          /* Set this flag if time to send a beacon               */
	Boolean		tx_cf_end;          /* Set this flag if time to send a CF End frame         */
	Boolean		pcf_active;         /* Set this flag for AP if PCF is currently in effect	*/
	Boolean		polled;		        /* Set this flag if the station has received a poll     */
	Boolean		more_data;			/* Set this flag if must poll for more data (MSDU)		*/
	Boolean		more_frag;			/* Set this flag if must poll for more fragments		*/
	Boolean		pcf_side_traf;		/* Set this flag if the AP detects STA to STA traffic   */
	Boolean		active_poll;		/* Set this flag if an active poll is outstanding		*/
	} WlanT_Mac_Flags;

/* This structure contains the destination address to which the received */
/* data packet needs to be sent and the contents of the received packet  */
/* from the higher layer.												 */
typedef struct WlanT_Hld_List_Elem
	{
	double		time_rcvd;  			/* Time packet is received by the higher layer	*/
	int			destination_address; 	/* Station to which this packet needs to be sent*/
	Packet*     pkptr;				 	/* store packet contents  					  	*/
	} WlanT_Hld_List_Elem;

/* Information record for each BSS */
typedef struct bss_mapping_info
	{
	int 				bss_idx;
	int					ap_sta_addr;
	PrgT_Mapping_Handle sta_mapping_hndl;
	}WlanT_Bss_Mapping_Info;

/* Information record for each STA */
typedef struct sta_mapping_info
	{
	int 				sta_addr;
	PrgT_Mapping_Handle dup_mapping_hndl;
	}WlanT_Sta_Mapping_Info;

/* Information record for each STA */
typedef struct dup_mapping_info
	{
	int 								rem_sta_addr;
	WlanT_Mac_Duplicate_Buffer_Entry*	duplicate_ptr;
	}WlanT_Duplicate_Mapping_Info;

/* Information regarding the location of each APs */
typedef struct
	{
	int		ap_bss_id;
	int		ap_channel_num;
	double  tx_power;
	double	lat;
	double  lon;
	double  alt;
	}
WlanT_AP_Position_Info;


/** Global Variables **/

/* Global list of AP position info.											*/
List*	global_ap_pos_info_lptr = OPC_NIL;

/* Global variable to keep note of the nature of the subnet.				*/
/* This variable is initialized to not set.									*/
WlanT_Bss_Identification_Approach bss_id_type = WlanC_Not_Set;


/**	Macro Definitions **/

/** The data frame send flag is set whenever there is a data to be send by	**/
/** the higher layer or the response frame needs to be sent. However, in 	**/
/** either case the flag will not be set if the receiver is busy			**/
/** Frames cannot be transmitted until medium is idle. Once, the medium 	**/
/** is available then the station is eligible to transmit provided there	**/
/** is a need for backoff. Once the transmission is complete then the		**/
/** station will wait for the response provided the frame transmitted  		**/
/** requires a response (such as RTS and Data frames). If response			**/
/** is not needed then the station will defer to transmit next packet		**/

/* After receiving a stream interrupt, we need to switch states from	*/
/* idle to defer or transmit if there is a frame to transmit and the	*/
/* receiver is not busy													*/ 
/* If a frame is received indicating that the STA should scan, all bets */
/* are off, and the STA moves into the scan state to look for other APs */
#define READY_TO_TRANSMIT		(((intrpt_type == OPC_INTRPT_STRM && wlan_flags->data_frame_to_send == OPC_TRUE && \
								   (pcf_flag == OPC_BOOLINT_DISABLED || (wlan_flags->pcf_active == OPC_FALSE && \
								    (ap_flag == OPC_BOOLINT_ENABLED || cfp_ap_medium_control == OPC_FALSE)))) || \
								  fresp_to_send != WlanC_None || \
								  wlan_flags->polled == OPC_TRUE || \
								  wlan_flags->tx_beacon == OPC_TRUE || \
								  (wlan_flags->pcf_active == OPC_TRUE && ap_flag == OPC_BOOLINT_ENABLED)) && \
								 !roam_state_ptr->scan_mode)

/* When we have a frame to transmit, we move to transmit state if the	*/
/* medium was idle for at least a DIFS time, otherwise we go to defer	*/
/* state.																*/
#define MEDIUM_IS_IDLE			(((current_time - nav_duration + PRECISION_RECOVERY >= difs_time) && \
	             				  wlan_flags->receiver_busy == OPC_FALSE && \
								  (current_time - rcv_idle_time + PRECISION_RECOVERY >= difs_time) && \
								  wlan_flags->pcf_active == OPC_FALSE) || \
								 wlan_flags->forced_bk_end == OPC_TRUE)

/* Change state to Defer from Frm_End, if the input buffers are not empty or a frame needs	*/
/* to be retransmitted or the station has to respond to some frame.							*/		
#define FRAME_TO_TRANSMIT		(wlan_flags->data_frame_to_send == OPC_TRUE || fresp_to_send != WlanC_None || \
								 retry_count != 0 || wlan_flags->tx_beacon == OPC_TRUE || \
								 wlan_flags->cw_required == OPC_TRUE)
	
/* After deferring for either collision avoidance or interframe gap		*/
/* the channel will be available for transmission. 						*/
#define DEFERENCE_OFF			(intrpt_type == OPC_INTRPT_SELF && \
								 intrpt_code == WlanC_Deference_Off && \
								 wlan_flags->receiver_busy == OPC_FALSE)

/* Issue a transmission complete stat once the packet has successfully 	*/
/* been transmitted from the source station								*/						 
#define TRANSMISSION_COMPLETE	(intrpt_type == OPC_INTRPT_STAT && \
								 op_intrpt_stat () == TRANSMITTER_BUSY_INSTAT)

/* Backoff is performed based on the value of the backoff flag.			*/
#define PERFORM_BACKOFF			(wlan_flags->backoff_flag == OPC_TRUE || wlan_flags->perform_cw == OPC_TRUE)

/* Need to start transmitting frame once the backoff (self intrpt) 		*/
/* completed															*/
#define BACKOFF_COMPLETED		(intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanC_Backoff_Elapsed && \
								 (wlan_flags->receiver_busy == OPC_FALSE || wlan_flags->forced_bk_end == OPC_TRUE))

/* Contention Window period, which follows a successful packet			*/
/* transmission, is completed.											*/
#define CW_COMPLETED			(intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanC_CW_Elapsed && \
								 (wlan_flags->receiver_busy == OPC_FALSE || wlan_flags->forced_bk_end == OPC_TRUE))

/* After transmission the station will wait for a frame response for    */
/* Data and Rts frames.												    */
#define WAIT_FOR_FRAME          (expected_frame_type != WlanC_None)

/* Need to retransmit frame if there is a frame timeout and the         */
/* required frame is not received									    */
#define FRAME_TIMEOUT           (intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanC_Frame_Timeout)

/* If the frame is received appropriate response will be transmitted    */
/* provided the medium is considered to be idle						    */
#define FRAME_RCVD			    (intrpt_type == OPC_INTRPT_STRM && bad_packet_rcvd == OPC_FALSE && \
		 						 i_strm == LOW_LAYER_INPUT_STREAM)

/* Skip backoff if no backoff is needed								    */
#define TRANSMIT_FRAME			(!PERFORM_BACKOFF)

/* Expecting frame response	after data or Rts transmission			    */
#define EXPECTING_FRAME			(expected_frame_type != WlanC_None)

/* When the contention window period is over then we go to IDLE state	*/
/* if we don't have another frame to send at that moment. If we have	*/
/* one then we go to TRANSMIT state if we did not sense any activity	*/
/* on our receiver for a period that is greater than or equal to DIFS	*/
/* period; otherwise we go to DEFER state to defer and back-off before	*/
/* transmitting the new frame.											*/
#define	BACK_TO_IDLE			(CW_COMPLETED && wlan_flags->data_frame_to_send == OPC_FALSE && !roam_state_ptr->scan_mode)
	
#define SEND_NEW_FRAME_AFTER_CW	(CW_COMPLETED && wlan_flags->data_frame_to_send == OPC_TRUE && MEDIUM_IS_IDLE && !roam_state_ptr->scan_mode)

#define DEFER_AFTER_CW			(CW_COMPLETED && wlan_flags->data_frame_to_send == OPC_TRUE && !MEDIUM_IS_IDLE && !roam_state_ptr->scan_mode)

/* Macros that check the change in the busy status of the receiver.	   	*/
#define	RECEIVER_BUSY_HIGH		(intrpt_type == OPC_INTRPT_STAT && intrpt_code < TRANSMITTER_BUSY_INSTAT && \
								 op_stat_local_read (intrpt_code) > rx_power_threshold && !wlan_flags->collision)

#define	RECEIVER_BUSY_LOW		(intrpt_type == OPC_INTRPT_STAT && intrpt_code < TRANSMITTER_BUSY_INSTAT && !wlan_flags->receiver_busy)

#define	PERFORM_TRANSMIT		((BACKOFF_COMPLETED || SEND_NEW_FRAME_AFTER_CW))

#define	BACK_TO_DEFER			((FRAME_RCVD || DEFER_AFTER_CW || \
								 (wlan_flags->tx_beacon == OPC_TRUE && !wlan_flags->receiver_busy))) 							

/* Macro to evaluate whether the MAC is in a contention free period.	*/
#define	IN_CFP					(pcf_flag == OPC_BOOLINT_ENABLED && \
								 (cfp_ap_medium_control == OPC_TRUE || wlan_flags->pcf_active == OPC_TRUE))

/* After receiving a packet that indicates the end of the current CFP	*/
/* go to back to IDLE state if there is no packet to transmit in the CP.*/
#define	IDLE_AFTER_CFP			(intrpt_type == OPC_INTRPT_STRM && !FRAME_TO_TRANSMIT && !IN_CFP)

/* Macro to cancel the self interrupt for end of deference. It is		*/
/* called at the state transition from DEFER to IDLE.					*/
#define	CANCEL_DEF_EVENT		(op_ev_cancel (deference_evh))

#define FRM_END_TO_IDLE			(!FRAME_TO_TRANSMIT && !EXPECTING_FRAME && !IN_CFP)
	
#define	FRM_END_TO_DEFER		(!EXPECTING_FRAME && (FRAME_TO_TRANSMIT || IN_CFP))

/* Macros associated with the "SCAN" state. If the scan mode flag is	*/
/* set, the STA considers itself disconnected from its AP and starts	*/
/* scanning for a new AP-- only in DCF STAs.							*/
#define AP_DISCONNECTED 		(roam_state_ptr->scan_mode == OPC_TRUE)

#define AP_CONNECTED 			(roam_state_ptr->scan_mode == OPC_FALSE)

#define DATA_FRAME_TO_TX 		(wlan_flags->data_frame_to_send == OPC_TRUE)

#define SCAN_TIMEOUT			(intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanC_Scan_Timeout)	

#define SCAN_AFTER_CW			(CW_COMPLETED && AP_DISCONNECTED)


/** Function Prototypes **/
static void			wlan_mac_sv_init ();
static void			wlan_higher_layer_data_arrival ();
static void			wlan_physical_layer_data_arrival ();
static void			wlan_hlpk_enqueue (Packet* hld_pkptr, int dest_addr, Boolean polling);
static Boolean		wlan_tuple_find (int sta_addr, int seq_id, int frag_num, int dest_addr);
static void			wlan_data_process (Packet* seg_pkptr,int dest_addr, int sta_addr, int final_dest_addr, int frag_num, int more_frag, double pkt_id);
static void			wlan_accepted_frame_stats_update (Packet* seg_pkptr);
static void			wlan_interrupts_process ();
static void 		wlan_prepare_frame_to_send (int frame_type);
static void			wlan_frame_transmit ();
static void			wlan_schedule_deference ();
static void			wlan_frame_discard ();
static void			wlan_mac_rcv_channel_status_update (int channel_id);
static void			wlan_mac_error (const char* msg1, const char* msg2, const char* msg3);
static void			wlan_pcf_frame_discard ();
static int	   		wlan_hld_list_elem_add_comp (const void* list_elem_ptr1, const void* list_elem_ptr2);
static Boolean		wlan_poll_list_member_find (int dest_addr); 

static void						wlan_frame_type_conv (int frame_type, char* frame_type_name); 
static int						wlan_bss_id_list_manage (int bssid, const char* operation);
static PrgT_Mapping_Handle		wlan_bss_mapping_get (void);
static int 						wlan_get_ap_sta_addr (int bss_idx);
static WlanT_Sta_Mapping_Info*	wlan_sta_addr_register (int bss_idx, int sta_addr, int sta_is_ap);
static WlanT_Bss_Mapping_Info*	wlan_bss_info_get (int bssid);
static WlanT_Sta_Mapping_Info*	wlan_sta_info_get (int sta_addr, Boolean serialize);
static double 					wlan_min_freq_for_chan (int chan_num);
static void 					wlan_begin_new_scan (void);
static void 					wlan_set_transceiver_channel (int chan_num);
static void						wlan_ap_switch (void);
static void 					wlan_sta_addr_deregister (int bss_idx, int sta_addr);
static void						wlan_reset_sv (void);
static void 					wlan_ap_position_publish (void);
static void 					wlan_ap_eval_virtual (void);
static double 					wlan_ap_signal_strength_calc (double prop_distance, WlanT_AP_Position_Info *ap_info_ptr);
static void 					wlan_find_new_ap_virtual (void);

/* Modifications for LR WPAN model, by Olivier	*/
static void 					wlan_print_state_debug (void);
/************  end of modifications  ************/

/* Callback functions		*/
#if defined (__cplusplus)
extern "C" {
#endif

static void*					wlan_bss_info_get_key (void *value_ptr);
static int 						wlan_mapping_int_key_compare (void *key_a_ptr, void *key_b_ptr);
static void 					wlan_bss_info_free (void *value_ptr);
static void*					wlan_sta_info_get_key (void *value_ptr);
static void 					wlan_sta_info_free (void *value_ptr);
static void*					wlan_dup_info_get_key (void *value_ptr);
static void 					wlan_dup_info_free (void *value_ptr);

#if defined (__cplusplus)
} /* end of 'extern "C" {' */
#endif

/* End of Header Block */


#if !defined (VOSD_NO_FIN)
#undef	BIN
#undef	BOUT
#define	BIN		FIN_LOCAL_FIELD(_op_last_line_passed) = __LINE__ - _op_block_origin;
#define	BOUT	BIN
#define	BINIT	FIN_LOCAL_FIELD(_op_last_line_passed) = 0; _op_block_origin = __LINE__;
#else
#define	BINIT
#endif /* #if !defined (VOSD_NO_FIN) */



/* State variable definitions */
typedef struct
	{
	/* Internal state tracking for FSM */
	FSM_SYS_STATE
	/* State Variables */
	int	                    		retry_count;
	int	                    		intrpt_type;
	int	                    		my_address;
	Objid	                  		my_objid;
	Objid	                  		my_node_objid;
	Objid	                  		my_subnet_objid;
	Objid	                  		tx_objid;
	Objid	                  		txch_objid;
	Objid	                  		rx_objid;
	Objid	                  		rxch_objid;
	OmsT_Pr_Handle	         		own_process_record_handle;
	List*	                  		hld_list_ptr;
	double	                 		operational_speed;
	int	                    		frag_threshold;
	int	                    		packet_seq_number;
	int	                    		packet_frag_number;
	int	                    		destination_addr;
	Sbhandle	               		fragmentation_buffer_ptr;
	Sbhandle	               		common_rsmbuf_ptr;
	WlanT_Mac_Frame_Type	   		fresp_to_send;
	double	                 		nav_duration;
	int	                    		rts_threshold;
	int	                    		duplicate_entry;
	WlanT_Mac_Frame_Type	   		expected_frame_type;
	int	                    		remote_sta_addr;
	double	                 		backoff_slots;
	Stathandle	             		packet_load_handle;
	double	                 		intrpt_time;
	Packet *	               		wlan_transmit_frame_copy_ptr;
	Stathandle	             		backoff_slots_handle;
	int	                    		instrm_from_mac_if;
	int	                    		outstrm_to_mac_if;
	int	                    		num_fragments;
	OpT_Packet_Size	        		remainder_size;
	List*	                  		defragmentation_list_ptr;
	WlanT_Mac_Flags*	       		wlan_flags;
	OmsT_Aa_Address_Handle	 		oms_aa_handle;
	double	                 		current_time;
	double	                 		rcv_idle_time;
	Pmohandle	              		hld_pmh;
	int	                    		max_backoff;
	char	                   		current_state_name [32];
	Stathandle	             		hl_packets_rcvd;
	Stathandle	             		media_access_delay;
	Stathandle	             		ete_delay_handle;
	Stathandle	             		global_ete_delay_handle;
	Stathandle	             		global_throughput_handle;
	Stathandle	             		global_load_handle;
	Stathandle	             		global_dropped_data_handle;
	Stathandle	             		global_mac_delay_handle;
	Stathandle	             		ctrl_traffic_rcvd_handle_inbits;
	Stathandle	             		ctrl_traffic_sent_handle_inbits;
	Stathandle	             		ctrl_traffic_rcvd_handle;
	Stathandle	             		ctrl_traffic_sent_handle;
	Stathandle	             		data_traffic_rcvd_handle_inbits;
	Stathandle	             		data_traffic_sent_handle_inbits;
	Stathandle	             		data_traffic_rcvd_handle;
	Stathandle	             		data_traffic_sent_handle;
	double	                 		sifs_time;
	double	                 		slot_time;
	int	                    		cw_min;
	int	                    		cw_max;
	double	                 		difs_time;
	double	                 		plcp_overhead_control;
	double	                 		plcp_overhead_data;
	Stathandle	             		channel_reserv_handle;
	Stathandle	             		retrans_handle;
	Stathandle	             		throughput_handle;
	int	                    		long_retry_limit;
	int	                    		short_retry_limit;
	int	                    		retry_limit;
	WlanT_Mac_Frame_Type	   		last_frametx_type;
	Evhandle	               		deference_evh;
	Evhandle	               		backoff_elapsed_evh;
	Evhandle	               		frame_timeout_evh;
	double	                 		eifs_time;
	int	                    		i_strm;
	Boolean	                		wlan_trace_active;
	SimT_Pk_Id	             		pkt_in_service;
	Stathandle	             		bits_load_handle;
	int	                    		ap_flag;
	Boolean	                		bss_flag;
	int	                    		ap_mac_address;
	int	                    		hld_max_size;
	double	                 		max_receive_lifetime;
	int	                    		accept_large_packets;
	WlanT_Phy_Char_Code	    		phy_char_flag;
	OpT_Packet_Size	        		total_hlpk_size;
	Stathandle	             		drop_packet_handle;
	Stathandle	             		drop_packet_handle_inbits;
	Log_Handle	             		drop_pkt_log_handle;
	Log_Handle	             		config_log_handle;
	int	                    		drop_pkt_entry_log_flag;
	int	                    		packet_size;
	double	                 		receive_time;
	Ici*	                   		llc_iciptr;
	double	                 		rx_power_threshold;
	int	                    		bss_id;
	int	                    		pcf_retry_count;
	int	                    		poll_fail_count;
	int	                    		max_poll_fails;
	List*	                  		cfpd_list_ptr;
	int	                    		pcf_queue_offset;
	double	                 		beacon_int;
	Sbhandle	               		pcf_frag_buffer_ptr;
	Packet *	               		wlan_pcf_transmit_frame_copy_ptr;
	int	                    		pcf_num_fragments;
	OpT_Packet_Size	        		pcf_remainder_size;
	int*	                   		polling_list;
	int	                    		poll_list_size;
	int	                    		poll_index;
	double	                 		pifs_time;
	Evhandle	               		beacon_evh;
	Evhandle	               		cfp_end_evh;
	SimT_Pk_Id	             		pcf_pkt_in_service;
	int	                    		pcf_flag;
	Boolean	                		active_pc;
	int	                    		cfp_prd;
	int	                    		cfp_offset;
	double	                 		cfp_length;
	Boolean	                		ap_relay;
	OpT_Packet_Size	        		total_cfpd_size;
	OpT_Packet_Size	        		packet_size_dcf;
	OpT_Packet_Size	        		packet_size_pcf;
	double	                 		receive_time_dcf;
	double	                 		receive_time_pcf;
	Boolean	                		cfp_ap_medium_control;
	int	                    		pcf_network;
	int	                    		beacon_eff_mode;
	int	                    		channel_num;
	int	                    		eval_bss_id;
	WlanT_Roam_State_Info*	 		roam_state_ptr;
	WlanT_Rx_State_Info*	   		rx_state_info_ptr;
	double	                 		ap_connectivity_check_interval;
	double	                 		ap_connectivity_check_time;
	Evhandle	               		ap_connectivity_check_evhndl;
	WlanT_AP_Position_Info*			conn_ap_pos_info_ptr;
	WlanT_Sta_Mapping_Info*			my_sta_info_ptr;
	WlanT_Bss_Mapping_Info*			my_bss_info_ptr;
	PrgT_Mutex*	            		mapping_info_mutex;
	int	                    		wlan_name;
	WlanT_Mac_Stat	         		wlan_stat_custom;
	Boolean	                		wlan_state_debug;
	int	                    		error;
	WlanT_Mac_Intrpt_Code	  		intrpt_code;
	} custom_wlan_mac_state;

#define pr_state_ptr            		((custom_wlan_mac_state*) (OP_SIM_CONTEXT_PTR->mod_state_ptr))
#define retry_count             		pr_state_ptr->retry_count
#define intrpt_type             		pr_state_ptr->intrpt_type
#define my_address              		pr_state_ptr->my_address
#define my_objid                		pr_state_ptr->my_objid
#define my_node_objid           		pr_state_ptr->my_node_objid
#define my_subnet_objid         		pr_state_ptr->my_subnet_objid
#define tx_objid                		pr_state_ptr->tx_objid
#define txch_objid              		pr_state_ptr->txch_objid
#define rx_objid                		pr_state_ptr->rx_objid
#define rxch_objid              		pr_state_ptr->rxch_objid
#define own_process_record_handle		pr_state_ptr->own_process_record_handle
#define hld_list_ptr            		pr_state_ptr->hld_list_ptr
#define operational_speed       		pr_state_ptr->operational_speed
#define frag_threshold          		pr_state_ptr->frag_threshold
#define packet_seq_number       		pr_state_ptr->packet_seq_number
#define packet_frag_number      		pr_state_ptr->packet_frag_number
#define destination_addr        		pr_state_ptr->destination_addr
#define fragmentation_buffer_ptr		pr_state_ptr->fragmentation_buffer_ptr
#define common_rsmbuf_ptr       		pr_state_ptr->common_rsmbuf_ptr
#define fresp_to_send           		pr_state_ptr->fresp_to_send
#define nav_duration            		pr_state_ptr->nav_duration
#define rts_threshold           		pr_state_ptr->rts_threshold
#define duplicate_entry         		pr_state_ptr->duplicate_entry
#define expected_frame_type     		pr_state_ptr->expected_frame_type
#define remote_sta_addr         		pr_state_ptr->remote_sta_addr
#define backoff_slots           		pr_state_ptr->backoff_slots
#define packet_load_handle      		pr_state_ptr->packet_load_handle
#define intrpt_time             		pr_state_ptr->intrpt_time
#define wlan_transmit_frame_copy_ptr		pr_state_ptr->wlan_transmit_frame_copy_ptr
#define backoff_slots_handle    		pr_state_ptr->backoff_slots_handle
#define instrm_from_mac_if      		pr_state_ptr->instrm_from_mac_if
#define outstrm_to_mac_if       		pr_state_ptr->outstrm_to_mac_if
#define num_fragments           		pr_state_ptr->num_fragments
#define remainder_size          		pr_state_ptr->remainder_size
#define defragmentation_list_ptr		pr_state_ptr->defragmentation_list_ptr
#define wlan_flags              		pr_state_ptr->wlan_flags
#define oms_aa_handle           		pr_state_ptr->oms_aa_handle
#define current_time            		pr_state_ptr->current_time
#define rcv_idle_time           		pr_state_ptr->rcv_idle_time
#define hld_pmh                 		pr_state_ptr->hld_pmh
#define max_backoff             		pr_state_ptr->max_backoff
#define current_state_name      		pr_state_ptr->current_state_name
#define hl_packets_rcvd         		pr_state_ptr->hl_packets_rcvd
#define media_access_delay      		pr_state_ptr->media_access_delay
#define ete_delay_handle        		pr_state_ptr->ete_delay_handle
#define global_ete_delay_handle 		pr_state_ptr->global_ete_delay_handle
#define global_throughput_handle		pr_state_ptr->global_throughput_handle
#define global_load_handle      		pr_state_ptr->global_load_handle
#define global_dropped_data_handle		pr_state_ptr->global_dropped_data_handle
#define global_mac_delay_handle 		pr_state_ptr->global_mac_delay_handle
#define ctrl_traffic_rcvd_handle_inbits		pr_state_ptr->ctrl_traffic_rcvd_handle_inbits
#define ctrl_traffic_sent_handle_inbits		pr_state_ptr->ctrl_traffic_sent_handle_inbits
#define ctrl_traffic_rcvd_handle		pr_state_ptr->ctrl_traffic_rcvd_handle
#define ctrl_traffic_sent_handle		pr_state_ptr->ctrl_traffic_sent_handle
#define data_traffic_rcvd_handle_inbits		pr_state_ptr->data_traffic_rcvd_handle_inbits
#define data_traffic_sent_handle_inbits		pr_state_ptr->data_traffic_sent_handle_inbits
#define data_traffic_rcvd_handle		pr_state_ptr->data_traffic_rcvd_handle
#define data_traffic_sent_handle		pr_state_ptr->data_traffic_sent_handle
#define sifs_time               		pr_state_ptr->sifs_time
#define slot_time               		pr_state_ptr->slot_time
#define cw_min                  		pr_state_ptr->cw_min
#define cw_max                  		pr_state_ptr->cw_max
#define difs_time               		pr_state_ptr->difs_time
#define plcp_overhead_control   		pr_state_ptr->plcp_overhead_control
#define plcp_overhead_data      		pr_state_ptr->plcp_overhead_data
#define channel_reserv_handle   		pr_state_ptr->channel_reserv_handle
#define retrans_handle          		pr_state_ptr->retrans_handle
#define throughput_handle       		pr_state_ptr->throughput_handle
#define long_retry_limit        		pr_state_ptr->long_retry_limit
#define short_retry_limit       		pr_state_ptr->short_retry_limit
#define retry_limit             		pr_state_ptr->retry_limit
#define last_frametx_type       		pr_state_ptr->last_frametx_type
#define deference_evh           		pr_state_ptr->deference_evh
#define backoff_elapsed_evh     		pr_state_ptr->backoff_elapsed_evh
#define frame_timeout_evh       		pr_state_ptr->frame_timeout_evh
#define eifs_time               		pr_state_ptr->eifs_time
#define i_strm                  		pr_state_ptr->i_strm
#define wlan_trace_active       		pr_state_ptr->wlan_trace_active
#define pkt_in_service          		pr_state_ptr->pkt_in_service
#define bits_load_handle        		pr_state_ptr->bits_load_handle
#define ap_flag                 		pr_state_ptr->ap_flag
#define bss_flag                		pr_state_ptr->bss_flag
#define ap_mac_address          		pr_state_ptr->ap_mac_address
#define hld_max_size            		pr_state_ptr->hld_max_size
#define max_receive_lifetime    		pr_state_ptr->max_receive_lifetime
#define accept_large_packets    		pr_state_ptr->accept_large_packets
#define phy_char_flag           		pr_state_ptr->phy_char_flag
#define total_hlpk_size         		pr_state_ptr->total_hlpk_size
#define drop_packet_handle      		pr_state_ptr->drop_packet_handle
#define drop_packet_handle_inbits		pr_state_ptr->drop_packet_handle_inbits
#define drop_pkt_log_handle     		pr_state_ptr->drop_pkt_log_handle
#define config_log_handle       		pr_state_ptr->config_log_handle
#define drop_pkt_entry_log_flag 		pr_state_ptr->drop_pkt_entry_log_flag
#define packet_size             		pr_state_ptr->packet_size
#define receive_time            		pr_state_ptr->receive_time
#define llc_iciptr              		pr_state_ptr->llc_iciptr
#define rx_power_threshold      		pr_state_ptr->rx_power_threshold
#define bss_id                  		pr_state_ptr->bss_id
#define pcf_retry_count         		pr_state_ptr->pcf_retry_count
#define poll_fail_count         		pr_state_ptr->poll_fail_count
#define max_poll_fails          		pr_state_ptr->max_poll_fails
#define cfpd_list_ptr           		pr_state_ptr->cfpd_list_ptr
#define pcf_queue_offset        		pr_state_ptr->pcf_queue_offset
#define beacon_int              		pr_state_ptr->beacon_int
#define pcf_frag_buffer_ptr     		pr_state_ptr->pcf_frag_buffer_ptr
#define wlan_pcf_transmit_frame_copy_ptr		pr_state_ptr->wlan_pcf_transmit_frame_copy_ptr
#define pcf_num_fragments       		pr_state_ptr->pcf_num_fragments
#define pcf_remainder_size      		pr_state_ptr->pcf_remainder_size
#define polling_list            		pr_state_ptr->polling_list
#define poll_list_size          		pr_state_ptr->poll_list_size
#define poll_index              		pr_state_ptr->poll_index
#define pifs_time               		pr_state_ptr->pifs_time
#define beacon_evh              		pr_state_ptr->beacon_evh
#define cfp_end_evh             		pr_state_ptr->cfp_end_evh
#define pcf_pkt_in_service      		pr_state_ptr->pcf_pkt_in_service
#define pcf_flag                		pr_state_ptr->pcf_flag
#define active_pc               		pr_state_ptr->active_pc
#define cfp_prd                 		pr_state_ptr->cfp_prd
#define cfp_offset              		pr_state_ptr->cfp_offset
#define cfp_length              		pr_state_ptr->cfp_length
#define ap_relay                		pr_state_ptr->ap_relay
#define total_cfpd_size         		pr_state_ptr->total_cfpd_size
#define packet_size_dcf         		pr_state_ptr->packet_size_dcf
#define packet_size_pcf         		pr_state_ptr->packet_size_pcf
#define receive_time_dcf        		pr_state_ptr->receive_time_dcf
#define receive_time_pcf        		pr_state_ptr->receive_time_pcf
#define cfp_ap_medium_control   		pr_state_ptr->cfp_ap_medium_control
#define pcf_network             		pr_state_ptr->pcf_network
#define beacon_eff_mode         		pr_state_ptr->beacon_eff_mode
#define channel_num             		pr_state_ptr->channel_num
#define eval_bss_id             		pr_state_ptr->eval_bss_id
#define roam_state_ptr          		pr_state_ptr->roam_state_ptr
#define rx_state_info_ptr       		pr_state_ptr->rx_state_info_ptr
#define ap_connectivity_check_interval		pr_state_ptr->ap_connectivity_check_interval
#define ap_connectivity_check_time		pr_state_ptr->ap_connectivity_check_time
#define ap_connectivity_check_evhndl		pr_state_ptr->ap_connectivity_check_evhndl
#define conn_ap_pos_info_ptr    		pr_state_ptr->conn_ap_pos_info_ptr
#define my_sta_info_ptr         		pr_state_ptr->my_sta_info_ptr
#define my_bss_info_ptr         		pr_state_ptr->my_bss_info_ptr
#define mapping_info_mutex      		pr_state_ptr->mapping_info_mutex
#define wlan_name               		pr_state_ptr->wlan_name
#define wlan_stat_custom        		pr_state_ptr->wlan_stat_custom
#define wlan_state_debug        		pr_state_ptr->wlan_state_debug
#define error                   		pr_state_ptr->error
#define intrpt_code             		pr_state_ptr->intrpt_code

/* These macro definitions will define a local variable called	*/
/* "op_sv_ptr" in each function containing a FIN statement.	*/
/* This variable points to the state variable data structure,	*/
/* and can be used from a C debugger to display their values.	*/
#undef FIN_PREAMBLE_DEC
#undef FIN_PREAMBLE_CODE
#if defined (OPD_PARALLEL)
#  define FIN_PREAMBLE_DEC	custom_wlan_mac_state *op_sv_ptr; OpT_Sim_Context * tcontext_ptr;
#  define FIN_PREAMBLE_CODE	\
		if (VosS_Mt_Perform_Lock) \
			VOS_THREAD_SPECIFIC_DATA_GET (VosI_Globals.simi_mt_context_data_key, tcontext_ptr, SimT_Context *); \
		else \
			tcontext_ptr = VosI_Globals.simi_sequential_context_ptr; \
		op_sv_ptr = ((custom_wlan_mac_state *)(tcontext_ptr->mod_state_ptr));
#else
#  define FIN_PREAMBLE_DEC	custom_wlan_mac_state *op_sv_ptr;
#  define FIN_PREAMBLE_CODE	op_sv_ptr = pr_state_ptr;
#endif


/* Function Block */


#if !defined (VOSD_NO_FIN)
enum { _op_block_origin = __LINE__ };
#endif
static void
wlan_mac_sv_init ()
	{
	Objid					mac_params_comp_attr_objid;
	Objid					params_attr_objid;
	Objid					pcf_params_comp_attr_objid;
	Objid					subpcf_params_attr_objid;	
	Objid					chann_objid;
	int						num_chann;
	double					tx_power;
	int						i;
	Objid					statwire_objid;
	int						num_statwires;
	double					threshold;
	void*	   				temp_ptr;
	char					mutex_name_str [64];
	int						roaming_cap_flag;
	
	/**	1. Initialize state variables.						**/
	/** 2. Read model attribute values in variables.	    **/
	/** 3. Create global lists								**/
	/** 4. Register statistics handlers						**/
	FIN (wlan_mac_sv_init ());

	/* Modifications for LR WPAN model, by Olivier	*/
	wlan_stat_custom.packet_rcvd 		= 0;
	wlan_stat_custom.bad_packet 		= 0;
	wlan_stat_custom.lost_packet 		= 0;
	wlan_stat_custom.collided_packet 	= 0;
	/************  end of modifications  ************/
	
	/* object id of the surrounding processor.				*/
	my_objid = op_id_self ();

	/* Obtain the node's object identifier					*/
	my_node_objid = op_topo_parent (my_objid);

	/* Obtain subnet objid.									*/
	my_subnet_objid = op_topo_parent (my_node_objid);

	/* Obtain the values assigned to the various attributes	*/
	op_ima_obj_attr_get (my_objid, "Wireless LAN Parameters", &mac_params_comp_attr_objid);
    params_attr_objid = op_topo_child (mac_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);

	/* Determine the assigned MAC address.					*/
	op_ima_obj_attr_get (my_objid, "Address", &my_address);
	
	/* Obtain an address handle for resolving WLAN MAC addresses.				*/
	oms_aa_handle = oms_aa_address_handle_get ("MAC Addresses", "Address");

 	/* Obtain the BSS_Id attribute to determine if BSS based network is used	*/ 
	op_ima_obj_attr_get (params_attr_objid, "BSS Identifier", &bss_id);
	
	/* Register the log handles and related flags.								*/
	config_log_handle	= op_prg_log_handle_create (OpC_Log_Category_Configuration, "Wireless Lan", "MAC Configuration", 128);
	drop_pkt_log_handle	= op_prg_log_handle_create (OpC_Log_Category_Protocol,      "Wireless Lan", "Data packet Drop",  128);
    drop_pkt_entry_log_flag = 0;

	/* Update the global variable if this is the first node to come up. If not the	*/ 
	/* first node, then check for mismatches. A subnet can be a traditional subnet	*/
	/* (i.e. a subnet with one BSS, this is the existing model) or a  BSS based		*/
	/* subnet where for every node the attribute BSS_Id is set to indicate to which */
	/* BSS a node belongs. If the global is set to traditional subnet and the this	*/
	/* node has its BSS_Id attribute set then log a warning message and recover		*/
	/* by considering the BSS_Id attribute setting as not used. If the global is	*/
	/* set to BSS based subnet and this node is not using its BSS_Id attribute 		*/
	/* then log an error message and stop the simulation.					 		*/
	if (bss_id_type == WlanC_Not_Set)
		{
		if (bss_id ==  WLAN_BSSID_NOT_USED)
			{
			bss_id_type = WlanC_Entire_Subnet ;
			}
		else
			{
			bss_id_type = WlanC_Bss_Divided_Subnet ;
			}
		}

	/* Configuration error checking */
	if (bss_id_type == WlanC_Entire_Subnet && bss_id != WLAN_BSSID_NOT_USED)
		{
		/* Recoverable mismatch, log warning and continue by enforcing			*/
		/* traditional subnet, i.e. force the bss_id variable to not used.		*/

		/* Write the warning message.											*/
		op_prg_log_entry_write (config_log_handle,
			"WARNING:\n"
			" A node with an explicit BSS \n"
			" assignment was found in a pure \n"
			" subnet.\n"
			"ACTION:\n"
			" The BSS identifier is set to\n"
			" the default value.\n"
			"CAUSE:\n"
			" There are some nodes in the\n"
			" network which have their BSS\n"
			" identifiers set to the default\n"
			" while the others have the\n"
			" default setting.\n"
			"SUGGESTION:\n"
			" Ensure that all nodes have the\n"
			" BSS identifier set to the default\n"
			" value or all of them are explicitly\n"
			" assigned.\n"
							  );
		}
	else if (bss_id_type == WlanC_Bss_Divided_Subnet && bss_id == WLAN_BSSID_NOT_USED)
		{
		/* Unrecoverable error-- not all BSS IDs have been configured. Cannot 	*/
		/* what the BSS ID should be, hence terminate.							*/

		wlan_mac_error ("BSS ID not set in a node which belongs to a network in which some BSS IDs are set", 
			"Please set a non-default BSS ID on all nodes in the network", OPC_NIL);
		}

	/* Use the subnet ID as the BSS ID if it is set to "NOT USED".				*/
	if (bss_id_type == WlanC_Entire_Subnet)
		{
		bss_id = my_subnet_objid;
		
		/* Add the BSS ID into the BSS ID list, which is later going to be used	*/
		/* while selecting channels for BSSs.									*/
		wlan_bss_id_list_manage (bss_id, "add");
		}

   	/* Get model attributes.	*/
	op_ima_obj_attr_get (params_attr_objid, "Data Rate", &operational_speed);
	op_ima_obj_attr_get (params_attr_objid, "Fragmentation Threshold", &frag_threshold);
	op_ima_obj_attr_get (params_attr_objid, "Rts Threshold", &rts_threshold);
	op_ima_obj_attr_get (params_attr_objid, "Short Retry Limit", &short_retry_limit);
	op_ima_obj_attr_get (params_attr_objid, "Long Retry Limit", &long_retry_limit);
	op_ima_obj_attr_get (params_attr_objid, "Access Point Functionality", &ap_flag);	
	op_ima_obj_attr_get (params_attr_objid, "Buffer Size", &hld_max_size);
	op_ima_obj_attr_get (params_attr_objid, "Max Receive Lifetime", &max_receive_lifetime);
	op_ima_obj_attr_get (params_attr_objid, "Large Packet Processing", &accept_large_packets);

	/* Get simulation attributes. */
	op_ima_sim_attr_get (OPC_IMA_TOGGLE, "WLAN Beacon Efficiency Mode", &beacon_eff_mode);

	/* Initialize the retry limit for the current frame to long retry limit.	*/
	retry_limit = long_retry_limit;
	
	/* Extract beacon and PCF parameters.										*/
	op_ima_obj_attr_get (params_attr_objid, "PCF Parameters", &pcf_params_comp_attr_objid);
	subpcf_params_attr_objid = op_topo_child (pcf_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);
	op_ima_obj_attr_get (subpcf_params_attr_objid, "PCF Functionality", &pcf_flag);	
	op_ima_obj_attr_get (subpcf_params_attr_objid, "CFP Beacon Multiple", &cfp_prd);	
	op_ima_obj_attr_get (subpcf_params_attr_objid, "CFP Offset", &cfp_offset);	
	op_ima_obj_attr_get (subpcf_params_attr_objid, "CFP Interval", &cfp_length);	
	op_ima_obj_attr_get (subpcf_params_attr_objid, "Max Failed Polls", &max_poll_fails);	
	op_ima_obj_attr_get (subpcf_params_attr_objid, "Beacon Interval", &beacon_int);	

	ap_relay = OPC_TRUE;
		
	/* Check if there is an active AP controlling the medium during the CFP.*/
	if ((ap_flag == OPC_BOOLINT_ENABLED) && (pcf_flag == OPC_BOOLINT_ENABLED))
		active_pc= OPC_TRUE;
	else
		active_pc= OPC_FALSE;

	/* Load the appropriate physical layer characteristics.					*/	
	op_ima_obj_attr_get (params_attr_objid, "Physical Characteristics", &phy_char_flag);

	/* Obtain the receiver valid packet power threshold value used by the	*/
	/* statwires from the receiver into the MAC module.						*/
	op_ima_obj_attr_get (params_attr_objid, "Packet Reception-Power Threshold", &rx_power_threshold);
	op_ima_obj_attr_get (params_attr_objid, "Transmit Power", &tx_power);
	
	/* Based on physical characteristics settings set appropriate values to	*/
	/* the variables.														*/
	switch (phy_char_flag)
		{
		case WlanC_Frequency_Hopping:
			{
			/* Slot duration in terms of seconds.							*/
			slot_time = 50E-06;

			/* Short interframe gap in terms of seconds.					*/
			sifs_time = 28E-06;
			
			/* PLCP overheads, which include the preamble and header, in	*/
			/* terms of seconds.											*/
			plcp_overhead_control = 128E-06;
			plcp_overhead_data    = 128E-06;
			
			/* Minimum contention window size for selecting backoff slots.	*/
			cw_min = 15;

			/* Maximum contention window size for selecting backoff slots.	*/
			cw_max = 1023;
			break;
			}

		case WlanC_Direct_Sequence:
			{
			/* Slot duration in terms of seconds.							*/
			slot_time = 20E-06;

			/* Short interframe gap in terms of seconds.					*/
			sifs_time = 10E-06;

			/* PLCP overheads, which include the preamble and header, in	*/
			/* terms of seconds.											*/
			plcp_overhead_control = 192E-06;
			plcp_overhead_data    = 192E-06;
			
			/* Minimum contention window size for selecting backoff slots.	*/
			cw_min = 31;

			/* Maximum contention window size for selecting backoff slots.	*/
			cw_max = 1023;
			break;
			}

		case WlanC_Infra_Red:
			{
			/* Slot duration in terms of seconds.							*/
			slot_time = 8E-06;

			/* Short interframe gap in terms of seconds.					*/
			sifs_time = 7E-06;

			/* PLCP overheads, which include the preamble and header, in	*/
			/* terms of seconds. Infra-red supports transmission of parts	*/
			/* of the PLCP header at the regular data transmission rate,	*/
			/* which can be higher than mandatory lowest data rate.			*/
			plcp_overhead_control = 57E-06;
			plcp_overhead_data    = 25E-06 + (ceil (32000000.0 / operational_speed) / 1E6);
	  
			/* Minimum contention window size for selecting backoff slots.	*/
			cw_min = 63;

			/* Maximum contention window size for selecting backoff slots.	*/
			cw_max = 1023;
			break;
			}

		default:
			{
			wlan_mac_error ("Unexpected Physical Layer Characteristic encountered.", OPC_NIL, OPC_NIL);
			break;
			}
		}

	/** By default stations are configured for IBSS unless an Access Point is found,**/
	/** then the network will have an infrastructure BSS configuration.				**/
	bss_flag = OPC_FALSE;

	/* Computing DIFS interval which is interframe gap between successive	*/
	/* frame transmissions.													*/
	/* Modifications for LR WPAN model, by Olivier	*/
	difs_time = sifs_time + 2 * slot_time;
	//difs_time = 320E-06;
	//op_sim_message ("Warning: modification in the WLAN MAC", "DIFS = 320 micro-seconds");
	/************  end of modifications  ************/
	
	/* If the receiver detects that the received frame is erroneous then it	*/
	/* will set the network allocation vector to EIFS duration. 			*/
	eifs_time = difs_time + sifs_time + WLAN_ACK_DURATION + plcp_overhead_control;
	
	/** PIFS duration is used by the AP operating under PCF to gain		**/
	/** priority to access the medium **/
	pifs_time = sifs_time + slot_time;
	
	/* Creating list to store data arrived from higher layer.	*/	
	hld_list_ptr = op_prg_list_create ();

	/* If the station is an AP, and PCF supported, create separate PCF queue list for higher layer. */
	if ((ap_flag == OPC_BOOLINT_ENABLED) && (pcf_flag == OPC_BOOLINT_ENABLED))
		cfpd_list_ptr = op_prg_list_create ();
	else
		cfpd_list_ptr = OPC_NIL;
	
	/* Initialize segmentation and reassembly buffers.	*/
	defragmentation_list_ptr = op_prg_list_create ();
	fragmentation_buffer_ptr = op_sar_buf_create (OPC_SAR_BUF_TYPE_SEGMENT,    OPC_SAR_BUF_OPT_PK_BNDRY);
	common_rsmbuf_ptr        = op_sar_buf_create (OPC_SAR_BUF_TYPE_REASSEMBLY, OPC_SAR_BUF_OPT_DEFAULT);

	/* Initialize PCF segmentation and reassembly buffer. (only used by AP)	*/
	pcf_frag_buffer_ptr = op_sar_buf_create (OPC_SAR_BUF_TYPE_SEGMENT, OPC_SAR_BUF_OPT_PK_BNDRY);

	/* Registering local statistics.	*/
	packet_load_handle				= op_stat_reg ("Wireless Lan.Load (packets)", 					  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	bits_load_handle				= op_stat_reg ("Wireless Lan.Load (bits/sec)", 					  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	hl_packets_rcvd					= op_stat_reg ("Wireless Lan.Hld Queue Size (packets)", 		  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	backoff_slots_handle			= op_stat_reg ("Wireless Lan.Backoff Slots (slots)", 			  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	data_traffic_sent_handle 		= op_stat_reg ("Wireless Lan.Data Traffic Sent (packets/sec)", 	  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);	
	data_traffic_rcvd_handle		= op_stat_reg ("Wireless Lan.Data Traffic Rcvd (packets/sec)", 	  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL); 
	data_traffic_sent_handle_inbits	= op_stat_reg ("Wireless Lan.Data Traffic Sent (bits/sec)", 	  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	data_traffic_rcvd_handle_inbits	= op_stat_reg ("Wireless Lan.Data Traffic Rcvd (bits/sec)", 	  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	ctrl_traffic_sent_handle	 	= op_stat_reg ("Wireless Lan.Control Traffic Sent (packets/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	ctrl_traffic_rcvd_handle		= op_stat_reg ("Wireless Lan.Control Traffic Rcvd (packets/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL); 
	ctrl_traffic_sent_handle_inbits	= op_stat_reg ("Wireless Lan.Control Traffic Sent (bits/sec)",    OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	ctrl_traffic_rcvd_handle_inbits	= op_stat_reg ("Wireless Lan.Control Traffic Rcvd (bits/sec)", 	  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL); 
	drop_packet_handle       		= op_stat_reg ("Wireless Lan.Dropped Data Packets (packets/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL); 
	drop_packet_handle_inbits		= op_stat_reg ("Wireless Lan.Dropped Data Packets (bits/sec)", 	  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL); 
	retrans_handle					= op_stat_reg ("Wireless Lan.Retransmission Attempts (packets)",  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL); 
	media_access_delay				= op_stat_reg ("Wireless Lan.Media Access Delay (sec)", 		  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	ete_delay_handle				= op_stat_reg ("Wireless Lan.Delay (sec)", 					 	  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	channel_reserv_handle			= op_stat_reg ("Wireless Lan.Channel Reservation (sec)", 		  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	throughput_handle				= op_stat_reg ("Wireless Lan.Throughput (bits/sec)", 			  OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);

	/* Registering global statistics.		*/
	global_ete_delay_handle 		= op_stat_reg ("Wireless LAN.Delay (sec)", 	  		    OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
	global_load_handle 				= op_stat_reg ("Wireless LAN.Load (bits/sec)", 		    OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
	global_throughput_handle 		= op_stat_reg ("Wireless LAN.Throughput (bits/sec)",    OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
	global_dropped_data_handle		= op_stat_reg ("Wireless LAN.Data Dropped (bits/sec)",  OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
	global_mac_delay_handle			= op_stat_reg ("Wireless LAN.Media Access Delay (sec)", OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);

	/* Allocating memory for the flags used in this process model. */
	wlan_flags = (WlanT_Mac_Flags *) op_prg_mem_alloc (sizeof (WlanT_Mac_Flags));

	/* Disabling all flags as a default.	*/
	wlan_flags->data_frame_to_send 	= OPC_FALSE;
	wlan_flags->backoff_flag       	= OPC_FALSE;
	wlan_flags->rts_sent		   	= OPC_FALSE;
	wlan_flags->rcvd_bad_packet		= OPC_FALSE;
	wlan_flags->receiver_busy		= OPC_FALSE;
	wlan_flags->transmitter_busy	= OPC_FALSE;
	wlan_flags->gateway_flag		= OPC_FALSE;
	wlan_flags->bridge_flag			= OPC_FALSE;
	wlan_flags->wait_eifs_dur		= OPC_FALSE;
	wlan_flags->immediate_xmt		= OPC_FALSE;
	wlan_flags->forced_bk_end  	    = OPC_FALSE;
	wlan_flags->cw_required			= OPC_FALSE;
	wlan_flags->perform_cw			= OPC_FALSE;
	wlan_flags->nav_updated			= OPC_FALSE;
	wlan_flags->collision			= OPC_FALSE;
	wlan_flags->collided_packet		= OPC_FALSE;

	wlan_flags->duration_zero		= OPC_FALSE;
	wlan_flags->ignore_busy			= OPC_FALSE;
	wlan_flags->tx_beacon			= OPC_FALSE;
	wlan_flags->tx_cf_end			= OPC_FALSE;
	wlan_flags->pcf_active			= OPC_FALSE;
	wlan_flags->polled				= OPC_FALSE;
	wlan_flags->more_data			= OPC_FALSE;
	wlan_flags->more_frag			= OPC_FALSE;
	wlan_flags->pcf_side_traf		= OPC_FALSE;
	wlan_flags->active_poll			= OPC_FALSE;

	/* Initialize polling index. 								*/
	poll_index = -1;

	/* Initialize pcf retry count. 								*/
	pcf_retry_count = 0;

	/* Initialize pcf retry count. 								*/
	poll_fail_count = 0;

	/* Initialize pcf queue offset. 							*/
	pcf_queue_offset = 0;

	/* Initialize retry and back-off slot counts.				*/
	retry_count   = 0;
	backoff_slots = BACKOFF_SLOTS_UNSET;

	/* Initialize the packet pointers that holds the last		*/
	/* transmitted packets to be used for retransmissions when	*/
	/* necessary.												*/
	wlan_transmit_frame_copy_ptr     = OPC_NIL;
    wlan_pcf_transmit_frame_copy_ptr = OPC_NIL;
	
	/* Initialize NAV duration.									*/
	nav_duration = 0;
	
	/* Initialize receiver idle timer. 							*/
	rcv_idle_time = -2.0 * difs_time;

	/* Initializing the sum of sizes of the packets in the higher layer queue.	*/
	total_hlpk_size = 0;

	/* Initializing the sum of sizes of the packets in the Contention Free Period queue.	*/
	total_cfpd_size = 0;
	
	/* Initialize the state variables related with the current frame that is being handled.	*/
	packet_size_dcf  = 0;
	packet_size_pcf  = 0;
	receive_time_dcf = 0.0;
	receive_time_pcf = 0.0;
	
	/* Initializing frame response to send to none.				*/
	fresp_to_send = WlanC_None;

	/* Determines if the ap is controlling the medium. This		*/
	/* variable is used to determine when the NAV's can be		*/
	/* updates.													*/
	cfp_ap_medium_control = OPC_FALSE;

	/* Initializing expected frame type to none.				*/
	expected_frame_type = WlanC_None;
		
	/* Data arrived from higher layer is queued in the buffer. Pool memory is used for		*/
	/* allocating data structure for the higher layer packet and the random destination		*/
	/* for the packet. This structure is then inserted in the higher layer arrival queue.	*/
	hld_pmh = op_prg_pmo_define ("WLAN hld list elements", sizeof (WlanT_Hld_List_Elem), 32);

	/* Obtaining transmitter objid for accessing channel data rate attribute.	*/
	tx_objid = op_topo_assoc (my_objid, OPC_TOPO_ASSOC_OUT, OPC_OBJTYPE_RATX, 0);

	/* If no receiver is attach then generate error message and abort the simulation.	*/
	if (tx_objid == OPC_OBJID_INVALID)
		{
		wlan_mac_error ("No transmitter attached to this MAC process", OPC_NIL, OPC_NIL);	
		}

	/* Obtaining number of channels available.									*/
	op_ima_obj_attr_get (tx_objid, "channel", &chann_objid);
	num_chann = op_topo_child_count (chann_objid, OPC_OBJTYPE_RATXCH);
	
	/* Check for error conditions. The transmitter is expected to have a single	*/
	/* channel.																	*/
	if (num_chann > 1)
		wlan_mac_error ("The transmitter of the surrounding node has too many channels. This MAC",
						"is implemented to use a single channel for all supported data rates.",
						"Possibly, the new MAC process model is deployed in an old node model.");
	else if (num_chann == 0)
		wlan_mac_error ("No channel is available for transmission.", OPC_NIL, OPC_NIL);
		
	/* Set the transmitter's transmission power.								*/	
	txch_objid = op_topo_child (chann_objid, OPC_OBJTYPE_RATXCH, 0);
	op_ima_obj_attr_set (txch_objid, "power", tx_power);

	/* Free the transmitter channel state information set at the rxgroup		*/
	/* pipeline stage.															*/
	temp_ptr = (void *) op_ima_obj_state_get (txch_objid);
	op_prg_mem_free (temp_ptr);		

	/* Obtaining receiver's objid for accessing channel data rate attribute.	*/
	rx_objid = op_topo_assoc (my_objid, OPC_TOPO_ASSOC_IN, OPC_OBJTYPE_RARX, 0);

	/* If no receiver is attach then generate error message and abort the		*/
	/* simulation.																*/
	if (rx_objid == OPC_OBJID_INVALID)
		{
		wlan_mac_error ("No receiver attached to this MAC process", OPC_NIL, OPC_NIL);	
		}

	/* Obtaining number of channels available.									*/
	op_ima_obj_attr_get (rx_objid, "channel", &chann_objid);
	num_chann = op_topo_child_count (chann_objid, OPC_OBJTYPE_RARXCH);
	
	/* Check for error conditions. The receiver is expected to have a single	*/
	/* channel.																	*/
	if (num_chann > 1)
		wlan_mac_error ("The receiver of the surrounding node has too many channels. This MAC",
						"is implemented to use a single channel for all supported data rates.",
						"Possibly, the new MAC process model is deployed in an old node model.");
	else if (num_chann == 0)
		wlan_mac_error (" No channel is available for reception", OPC_NIL, OPC_NIL);

	/* Free the receiver channel state information set at the rxgroup stage.	*/
	rxch_objid = op_topo_child (chann_objid, OPC_OBJTYPE_RARXCH, 0);
	temp_ptr = (void *) op_ima_obj_state_get (rxch_objid);
	op_prg_mem_free (temp_ptr);
		
	/* Initialize the roaming related information.								*/
	roam_state_ptr = (WlanT_Roam_State_Info *) op_prg_mem_alloc (sizeof (WlanT_Roam_State_Info));
	roam_state_ptr->ap_reliability = 1.0;
	roam_state_ptr->scan_mode      = OPC_FALSE;
	roam_state_ptr->current_bss_id = bss_id;

	/* Initially, set roaming based on the attribute. In the next state, if it	*/
	/* is determined that this is an ad-hoc network or if PCF is active in the	*/
	/* BSS then roaming will be disabled.										*/
	op_ima_obj_attr_get (params_attr_objid, "Roaming Capability", &roaming_cap_flag);
	roam_state_ptr->enable_roaming = (roaming_cap_flag == OPC_BOOLINT_ENABLED) ? OPC_TRUE : OPC_FALSE;

	/* Initialize the receiver channel state information.						*/
	rx_state_info_ptr = (WlanT_Rx_State_Info *) op_prg_mem_alloc (sizeof (WlanT_Roam_State_Info));
	rx_state_info_ptr->state_info_id	= WLANC_RXCH_STATE_ID;
	rx_state_info_ptr->rx_power_thresh  = rx_power_threshold;
	rx_state_info_ptr->rx_end_time      = 0.0;
	rx_state_info_ptr->roaming_info_ptr = roam_state_ptr;

	/* Set the new "state" information of the receiver channel.					*/
	op_ima_obj_state_set (rxch_objid, rx_state_info_ptr);
		
	/* Also overwrite the high threshold trigger attribute values of the		*/
	/* statwires that come into the MAC from the radio receiver by using the	*/
	/* reception power threshold. First determine the total count of incoming	*/
	/* statwires.																*/
	num_statwires = op_topo_assoc_count (my_objid, OPC_TOPO_ASSOC_IN, OPC_OBJTYPE_STATWIRE);
	for (i = 0; i < num_statwires; i++)
		{
		/* Access the next statwire. Skip it if it is coming from the			*/
		/* transmitter.															*/
		statwire_objid = op_topo_assoc (my_objid, OPC_TOPO_ASSOC_IN, OPC_OBJTYPE_STATWIRE, i);
		op_ima_obj_attr_get (statwire_objid, "high threshold trigger", &threshold);
		
		/* If the trigger is not disabled then the statwire is from the			*/
		/* receiver. Overwrite the attribute value unless they are already same.*/
		if (threshold != OPC_BOOLDBL_DISABLED && threshold != rx_power_threshold)
			op_ima_obj_attr_set (statwire_objid, "high threshold trigger", rx_power_threshold);			
		}
			
	/* Create an ICI to be used during the communication with LLC.				*/
	llc_iciptr = op_ici_create ("wlan_mac_ind");
	if (llc_iciptr == OPC_NIL)
		{
		wlan_mac_error ("Unable to create ICI for communication with LLC.", OPC_NIL, OPC_NIL);
		}

	/* Initialize the variable which keeps track of number of PCF enabled nodes	*/
	/* in the network 															*/	
	pcf_network = 0;
	
	/* Create the mutex that will be used to serialize calling of prg_mapping	*/
	/* functions, which read/write global model related mapping information,	*/
	/* under multi-threaded execution with multiple CPUs.						*/
	mapping_info_mutex = op_prg_mt_mutex_create (OPC_MT_MUTEX_READER_WRITER, 0, "WLAN Mapping Info Mutex");

	FOUT;
	}

static void
wlan_transceiver_channel_init (void)
	{
	Objid		mac_params_comp_attr_objid;
	Objid		params_attr_objid;
	Objid		chann_params_comp_attr_objid;
	Objid		subchann_params_attr_objid;	
	int			bss_index;
	double		bandwidth_mhz;
	double		frequency;
	char		err_msg1 [256];
	char		err_msg2 [256];

	/** This function determines the 802.11b channel that the			**/
	/** surrounding node will use and configures the transceiver		**/
	/** with the corresponding minimum frequency and bandwidth values.	**/
	FIN (wlan_transceiver_channel_init (void));
	
	/* Get a handle to node's WLAN parameters.							*/
	op_ima_obj_attr_get (my_objid, "Wireless LAN Parameters", &mac_params_comp_attr_objid);
    params_attr_objid = op_topo_child (mac_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);

	/* Get the provided channel configuration.							*/
	op_ima_obj_attr_get (params_attr_objid, "Channel Settings", &chann_params_comp_attr_objid);
	subchann_params_attr_objid = op_topo_child (chann_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);
	op_ima_obj_attr_get (subchann_params_attr_objid, "Bandwidth", &bandwidth_mhz);	
	op_ima_obj_attr_get (subchann_params_attr_objid, "Min Frequency", &frequency);	

	/* Determine the 802.11b channel number we are going to use.		*/ 
	if (frequency == WLAN_BSS_BASED_FREQ_USED)
		{
		/* The channel will be selected based on node's BSS ID. Check	*/
		/* whether the BSS IDs are auto-assigned or not.				*/
		if (bss_id_type == WlanC_Entire_Subnet)
			{
			/* BSS IDs are auto assigned and their are set to node's	*/
			/* subnet ID. Use BSS index for channel selection.			*/
			bss_index = wlan_bss_id_list_manage (bss_id, "get_index");
			}
		else
			{
			/* BSS IDs are explicitly assigned. Use the BSS ID as the	*/
			/* BSS index.												*/
			bss_index = bss_id;
			}
		
		/* Assign channels from 1 through 11 (North America) with a gap */
		/* of 5 channels in between. The sequence will look like 1, 6,  */
		/* 11, 5, 10, 4, 9,... The channel will be picked as a function */
		/* BSS ID, that is mapped to a BSS index. Note that only		*/
		/* channels that are 5 channels apart are non-overlapping.		*/
		/* Assume that BSS indices run serially: 0, 1, 2, ... 			*/
		/* WLANC_CHANNEL_COUNT = 11, and								*/
		/* WLANC_CH_STEP_FOR_NO_OVERLAP = ceil (22.0/5.0) = 5			*/			
		channel_num = (WLANC_CH_STEP_FOR_NO_OVERLAP * bss_index) % WLANC_CHANNEL_COUNT + 1;

		/* Get the minimum frequency that corresponds to the selected	*/
		/* channel.														*/
		frequency = wlan_min_freq_for_chan (channel_num);
		}
	else
		{
		/* The frequency band that will be used by this node is			*/
		/* explicitly specified. Validate it and determine its channel	*/
		/* number if roaming is enabled.								*/
		if (roam_state_ptr->enable_roaming)
			{
			/* For a standard, acceptable channel, the bandwidth has to	*/
			/* be 22 MHz, and the minimum frequency has to be between	*/
			/* 2401 and 2451 MHz, inclusive, with intervals of 5 MHz	*/
			/* (i.e. the roaming feature is currently supported only	*/
			/* within first 11 channels. These numbers refer to the		*/
			/* values of the constants used below as specified in the	*/
			/* standard.)												*/
			if (bandwidth_mhz == WLANC_CHANNEL_BANDWIDTH && frequency >= WLANC_FIRST_CHAN_MIN_FREQ && frequency == ceil (frequency) &&
				(frequency - WLANC_FIRST_CHAN_MIN_FREQ) / WLANC_CHANNEL_SPACING < WLANC_CHANNEL_COUNT && 
				(int) (frequency - WLANC_FIRST_CHAN_MIN_FREQ) % (int) WLANC_CHANNEL_SPACING == 0)
				{
				/* The radio band has a valid configuration. Compute	*/
				/* its channel number.									*/
				channel_num = (frequency - WLANC_FIRST_CHAN_MIN_FREQ) / WLANC_CHANNEL_SPACING + 1;
				}
			else
				{
				/* Terminate the simulation with an error message.		*/
				sprintf (err_msg1, "only for the first %d channels of 802.11b specifications. Channel bandwidth must be %d MHz,",
						 WLANC_CHANNEL_COUNT, (int) WLANC_CHANNEL_BANDWIDTH);
				sprintf (err_msg2, "and minimum frequency must be between %d and %d MHz, inclusive, with intervals of %d MHz.",
						 (int) WLANC_FIRST_CHAN_MIN_FREQ, (int) WLANC_LAST_CHAN_MIN_FREQ, (int) WLANC_CHANNEL_SPACING);
				wlan_mac_error ("Cannot support WLAN roaming with configured radio channel settings. Roaming is supported", err_msg1, err_msg2);
				}
			}
		else
			/* When the roaming is disabled, the value of the state		*/
			/* variable channel_num is not used.						*/
			channel_num = 0;
		}
	
	/* Configure the transmitter channel based on selected/assigned		*/
	/* frequency band.													*/
	op_ima_obj_attr_set (txch_objid, "bandwidth", bandwidth_mhz * 1000.0);
	op_ima_obj_attr_set (txch_objid, "min frequency", frequency);
	
	/* Similarly configure the receiver channel.						*/
	op_ima_obj_attr_set (rxch_objid, "bandwidth", bandwidth_mhz * 1000.0);
	op_ima_obj_attr_set (rxch_objid, "min frequency", frequency);
			
	FOUT;
	}

static void
wlan_rxgroup_reduce (void)
	{
	unsigned int			old_rxch_count, new_rxch_count = 0;
	int						rxch_index, i;
	Objid*					old_rxch_objid_arr;
	Objid*					temp_rxch_objid_arr;
	Objid*					new_rxch_objid_arr = OPC_NIL;
	double					tx_bandwidth, rx_bandwidth, tx_min_freq, rx_min_freq;	
	WlanT_Rx_State_Info*	rxch_state_ptr;
	List*					proc_record_lptr;
	static int				rxgroup_config_count = -1;
	
	/** This function is called after the channel/frequency			**/
	/** assignments are finalized in order to reduce the receiver	**/
	/** group of our transmitter channel by excluding the receiver	**/
	/** channels with non-overlapping frequency bands, which we can	**/
	/** neither interfere nor communicate with, for simulation		**/
    /** efficiency purposes. Receiver channels whose WLAN nodes		**/
	/** have roaming functionality enabled are not excluded in any	**/
	/** case since they can change their channels during the		**/
	/** simulation.													**/
	FIN (wlan_rxgroup_reduce (void));
	
	/* First check whether a dynamic receiver group configuration	*/
	/* utility object exists in the network. If it does, we will	*/
	/* not perform any changes in our transmitter's receiver group	*/
	/* and rely on user's configuration using that utility object.	*/
	/* Search the network-wide process registery to find out. There	*/
	/* is no need to do the search again, if it is already one by	*/
	/* another WLAN MAC process.									*/
	if (rxgroup_config_count < 0)
		{
		proc_record_lptr = op_prg_list_create ();
		oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_lptr, 
								 "protocol", OMSC_PR_STRING, "rx_group_config", OPC_NIL);
	
		/* The size of the list is equal to the number of objects	*/
		/* in the network that we are looking for.					*/
		rxgroup_config_count = op_prg_list_size (proc_record_lptr);
		
		/* Destroy the list and its elements.						*/
		for (i = rxgroup_config_count; i > 0; i--)
			op_prg_list_remove (proc_record_lptr, OPC_LISTPOS_HEAD);
		op_prg_mem_free (proc_record_lptr);
		}

	/* Quit if receiver group configuration utility object count is	*/
	/* more than 0.													*/
	if (rxgroup_config_count > 0)
		{
		FOUT;
		}
	
	/* Get the current rxgroup set of our transmitter channel.		*/
	op_radio_txch_rxgroup_get (txch_objid, &old_rxch_count, &old_rxch_objid_arr);
	
	/* Quit if the initial receiver group is already empty.			*/
	if (old_rxch_count == 0)
		{
		FOUT;
		}
		
	/* Retrieve the channel settings of our transmitter channel.	*/
	op_ima_obj_attr_get (txch_objid, "min frequency", &tx_min_freq);
	op_ima_obj_attr_get (txch_objid, "bandwidth",     &tx_bandwidth);
	
	/* Convert the bandwidth from KHz to MHz.						*/
	tx_bandwidth /= 1000.0;
	
	/* Create a temporary array to store the receiver channel IDs	*/
	/* that are kept in the receiver group. Set the size of the		*/
	/* array considering the extreme case where none of the current	*/
	/* receiver channels are eliminated.							*/
	temp_rxch_objid_arr = (Objid *) op_prg_mem_alloc (old_rxch_count * sizeof (Objid));
	
	/* For every receiver channel in the group, check whether it	*/
	/* needs to be kept or removed from the group.					*/
	for (rxch_index = 0; rxch_index < old_rxch_count; rxch_index++)
		{
		/* Obtain the channel settings of the receiver channel.		*/
		op_ima_obj_attr_get (old_rxch_objid_arr [rxch_index], "min frequency", &rx_min_freq);
		op_ima_obj_attr_get (old_rxch_objid_arr [rxch_index], "bandwidth",     &rx_bandwidth);

		/* Convert the bandwidth from KHz to MHz.					*/
		rx_bandwidth /= 1000.0;
		
		/* Check for an overlap between the frequency bands.		*/
		if (tx_min_freq + tx_bandwidth > rx_min_freq && rx_min_freq + rx_bandwidth > tx_min_freq)
			{
			/* Because of overlap, we will keep the current 		*/
			/* receiver channel in the group.						*/
			temp_rxch_objid_arr [new_rxch_count++] = old_rxch_objid_arr [rxch_index];
			}
		else
			{
			/* Even though there is no overlap, don't exclude the	*/
			/* receiver if its node has the roaming functionality	*/
			/* enabled.	Check this by accessing the receiver		*/
			/* channel's state information. Identify the channel as	*/
			/* a WLAN receiver channel by checking its first 4		*/
			/* bytes (state_info_id) of its state information.		*/
			rxch_state_ptr = (WlanT_Rx_State_Info *) op_ima_obj_state_get (old_rxch_objid_arr [rxch_index]);
			if (rxch_state_ptr != OPC_NIL && rxch_state_ptr->state_info_id == WLANC_RXCH_STATE_ID && 
				rxch_state_ptr->roaming_info_ptr->enable_roaming)
				{
				temp_rxch_objid_arr [new_rxch_count++] = old_rxch_objid_arr [rxch_index];
				}
			}
		}
	
	/* Create an array that will hold the list of object IDs of the	*/
	/* receiver channels that are kept in the receiver group.		*/
	if (new_rxch_count != 0)
		{
		new_rxch_objid_arr = (Objid *) op_prg_mem_alloc (new_rxch_count * sizeof (Objid));
		
		/* Copy the object IDs from temporary list to the final		*/
		/* list.													*/
		op_prg_mem_copy (temp_rxch_objid_arr, new_rxch_objid_arr, new_rxch_count * sizeof (Objid));
		}
	
	/* Set the new list as the receiver group of our transmitter	*/
	/* channel.														*/
	op_radio_txch_rxgroup_set (txch_objid, new_rxch_count, new_rxch_objid_arr);
	
	/* Destroy the old list and temporary list.						*/
	op_prg_mem_free (old_rxch_objid_arr);
	op_prg_mem_free (temp_rxch_objid_arr);
		
	FOUT;
	}

static void
wlan_higher_layer_data_arrival (void)
	{
	Packet*					hld_pkptr;
	OpT_Packet_Size			data_size, frag_size;
	int						dest_addr;
	int						large_packet_bit = 0x1;
	int						full_buffer_bit  = 0x2;
	Ici*					ici_ptr;
	Boolean					polling;

	/** Queue the packet as it arrives from higher layer.	**/
	/** Also, store the destination address of the packet	**/
	/** in the queue and the arrival time.					**/
	FIN (wlan_higher_layer_data_arrival (void));

	/* Get packet from the incoming stream from higher layer and	*/
	/* obtain the packet size 										*/
	hld_pkptr = op_pk_get (op_intrpt_strm ());	
	
	/* If we are in a bridge/switch node, then we don't accept any	*/
	/* higher layer packet unless we are AP enabled.				*/
	if ((wlan_flags->bridge_flag == OPC_TRUE) && (ap_flag == OPC_BOOLINT_DISABLED))
		{
		op_pk_destroy (hld_pkptr);
		FOUT;
		}

	/* Get the size of the packet arrived from higher layer.		*/
	data_size = op_pk_total_size_get (hld_pkptr);		
	
	/* Read ICI parameters at the stream interrupt.					*/
	ici_ptr = op_intrpt_ici ();

	/* Retrieve destination address from the ici set by the interface layer.	*/
	if (ici_ptr == OPC_NIL || op_ici_attr_get (ici_ptr, "dest_addr", &dest_addr) == OPC_COMPCODE_FAILURE)
		{
		/* Generate error message.	*/
		wlan_mac_error ("Destination address in not valid.", OPC_NIL, OPC_NIL);
		}

	/* The queueing of the packets in the AP is based on the node type	*/
	/* (DCF/PCF) of the destination. If the destination node is a PCF	*/
	/* node, then the packets are queued into the cfpd_list_ptr and		*/
	/* transmitted only during the PCF period. Likewise packets for a	*/
	/* DCF destination node will be inserted into the hld_list_ptr and	*/
	/* transmitted only during DCF. Packets with broadcast address are	*/
	/* transmitted during DCF.											*/
	polling = wlan_poll_list_member_find (dest_addr);
	
	/* Maintaining total packet size of the packets in the higher layer queue.	*/
	/* The total size is calculated from the respective list based on whether	*/
	/* the station has been polled by the AP during the start of the simulation */
	if (polling)
		total_hlpk_size = total_cfpd_size + data_size;
	else
		total_hlpk_size = total_hlpk_size + data_size;

	/* If fragmentation is enabled and packet size is greater than the threshold		*/
	/* then MSDU length will not be more than fragmentation threshold, hence			*/
	/* the packet will be fragmented into the size less than or equal to fragmentation	*/
	/* threshold.																		*/
	if ((data_size > frag_threshold * 8) && (frag_threshold != -1))
		frag_size = frag_threshold * 8;
	else
		frag_size = data_size;
	
	/* Destroy packet if it is more than max msdu length or its		*/
	/* size zero. Also, if the size of the higher layer queue  		*/
	/* will exceed its maximum after the insertion of this packet, 	*/
	/* then discard the arrived packet. 							*/
	/* The higher layer is responsible for the retransmission of 	*/
	/* this packet.													*/ 
	if ((data_size > WLAN_MAXMSDU_LENGTH && accept_large_packets == OPC_BOOLINT_DISABLED) ||
		frag_size > WLAN_MAXMSDU_LENGTH || 
		data_size == 0 ||
        total_hlpk_size > hld_max_size)
		{
  		/* Write an appropriate simulation log message unless the	*/
		/* same message is written before.							*/
		if (drop_pkt_entry_log_flag < full_buffer_bit + large_packet_bit)
			{
			if (total_hlpk_size > hld_max_size && !(drop_pkt_entry_log_flag & full_buffer_bit))
				{
				/* Writing log message for dropped packets.			*/
				op_prg_log_entry_write (drop_pkt_log_handle, 
				"SYMPTOM(S):\n"
			    " Wireless LAN MAC layer discarded some packets due to\n "
			    " insufficient buffer capacity. \n"
				"\n"
			    " This may lead to: \n"
  			    " - application data loss.\n"
			    " - higher layer packet retransmission.\n"
			    "\n"
			    " REMEDIAL ACTION(S): \n"
			    " 1. Reduce Network load. \n"
			    " 2. User higher speed wireless lan. \n"
			    " 3. Increase buffer capacity\n");
				drop_pkt_entry_log_flag += full_buffer_bit;
				}
			
			else if (total_hlpk_size <= hld_max_size && frag_size > 0 && !(drop_pkt_entry_log_flag & large_packet_bit))
				{
				/* Writing log message for dropped packets due to	*/
				/* packet size.										*/
				op_prg_log_entry_write (drop_pkt_log_handle, 
				"SYMPTOM(S):\n"
			    " Wireless LAN MAC layer discarded some packets due to \n"
			    " their large sizes. This is an expected protocol \n"
				" behavior. \n"	
				"\n"
			    " This may lead to: \n"
  			    " - application data loss.\n"
			    " - higher layer packet retransmission.\n"
			    "\n"
			    " REMEDIAL ACTION(S): \n"
			    " 1. Set the higher layer packet size to \n"
				"    be smaller than max MSDU size (2304 bytes). \n"
			    " 2. Enable fragmentation threshold and large packet \n"
				"    processing. \n");
				drop_pkt_entry_log_flag += large_packet_bit;
				}
			}

		/* Change the total hld queue size to original value	*/
		/* as this packet will not be added to the queue.		*/
		total_hlpk_size = total_hlpk_size - data_size;

		/* Destroy the dropped packet.							*/
		op_pk_destroy (hld_pkptr);
		
		/* Report stat when data packet is dropped due to overflow buffer.	*/
		op_stat_write (drop_packet_handle, 1.0);
	    op_stat_write (drop_packet_handle, 0.0);

		/* Report stat when data packet is dropped due to overflow buffer.	*/
		op_stat_write (drop_packet_handle_inbits, (double) (data_size));
	    op_stat_write (drop_packet_handle_inbits, 0.0);
		op_stat_write (global_dropped_data_handle, (double) (data_size));
		op_stat_write (global_dropped_data_handle, 0.0);
		
		FOUT; 
		}
		
	/* Check for an AP bridge that whether the destined stations exist in the BSS or not	*/
	/* if not then no need to broadcast the packet.											*/
	if (wlan_flags->bridge_flag == OPC_TRUE && ap_flag == OPC_BOOLINT_ENABLED)
		{
		/* If the destination station doesn't exist in the BSS then */
		/* no need to broadcast the packet. Use dynamic station		*/
		/* mapping to determine if this station is currently part	*/
		/* of this BSS.												*/
		if (!wlan_sta_info_get (dest_addr, OPC_TRUE) && (dest_addr >= 0))
			{
			/* change the total hld queue size to original value	*/
			/* as this packet will not be added to the queue.		*/
			total_hlpk_size = total_hlpk_size - data_size;
		
			op_pk_destroy (hld_pkptr);
		
			FOUT;	
			}
		}

	/* Stamp the packet with the current time. This information will remain		*/
	/* unchanged even if the packet is copied for retransmissions, and			*/
	/* eventually it will be used by the destination MAC to compute the end-to-	*/
	/* end delay.																*/
	op_pk_stamp (hld_pkptr);
	
	/* Insert the arrived packet in higher layer queue.				*/	
	wlan_hlpk_enqueue (hld_pkptr, dest_addr, polling);

	FOUT;
	}

static void
wlan_hlpk_enqueue (Packet* hld_pkptr, int dest_addr, Boolean polling)
	{
	char					msg_string [120];
	char					msg_string1 [120];
	WlanT_Hld_List_Elem*	hld_ptr;
	double					data_size;
   	int						list_size;
	
	/* Enqueuing data packet for transmission.	*/
	FIN (wlan_hlpk_enqueue (Packet* hld_pkptr, int dest_addr, polling));

	/* Allocating pool memory to the higher layer data structure type. */	
	hld_ptr = (WlanT_Hld_List_Elem *) op_prg_pmo_alloc (hld_pmh);

	/* Generate error message and abort simulation if no memory left for data received from higher layer.	*/
	if (hld_ptr == OPC_NIL)
		{
		wlan_mac_error ("No more memory left to assign for data received from higher layer", OPC_NIL, OPC_NIL);
		}

	/* Updating higher layer data structure fields.	*/
	hld_ptr->time_rcvd           = current_time;
	hld_ptr->destination_address = dest_addr;
	hld_ptr->pkptr               = hld_pkptr;

	/* Check for PCF terminal and also if this station has been polled.	*/
	if (polling == OPC_TRUE)
		{
		/* Insert the packet sorted in the order of the MAC addresses.	*/
		op_prg_list_insert_sorted (cfpd_list_ptr, hld_ptr, wlan_hld_list_elem_add_comp);	
		
		list_size = op_prg_list_size (cfpd_list_ptr);
		}
	else
		{
		/* Insert a packet to the list.*/
		op_prg_list_insert (hld_list_ptr, hld_ptr, OPC_LISTPOS_TAIL);	
		
		list_size = op_prg_list_size (hld_list_ptr);
		
		/* Enable the flag indicating that there is a data frame to transmit.	*/
		wlan_flags->data_frame_to_send = OPC_TRUE;
		}

	/* Printing out information to ODB.	*/
	if (wlan_trace_active == OPC_TRUE)
		{
		sprintf (msg_string, "Just arrived outbound Data packet id " SIMC_PK_ID_FMT, op_pk_id (hld_ptr->pkptr));
		sprintf	(msg_string1, "The outbound Data queue size is %d", list_size); 	
		op_prg_odb_print_major (msg_string, msg_string1, OPC_NIL);
		}

	/* Report stat when outbound data packet is received.	*/
	op_stat_write (packet_load_handle, 1.0);

	/* Report stat in bits when outbound data packet is received.	*/
	data_size = (double) op_pk_total_size_get (hld_pkptr);
	op_stat_write (bits_load_handle, data_size);
    op_stat_write (bits_load_handle, 0.0);
	
	/* Update the global statistics as well.						*/
	op_stat_write (global_load_handle, data_size);
    op_stat_write (global_load_handle, 0.0);

	op_stat_write (hl_packets_rcvd, (double) list_size);
	
	FOUT;
	}

static void 
wlan_frame_transmit ()
	{
	char						msg_string  [120];
	char						msg_string1 [120];
	WlanT_Hld_List_Elem*		hld_ptr;
	double						pkt_tx_time;
	int 						list_high_index;
	int							list_low_index;
	int							type;
	Boolean						pcf_frag_buf_empty;
	
	/** Main procedure to invoke function for preparing and  **/
	/** transmitting the appropriate frames.			     **/
	FIN (wlan_frame_transmit());

	/* Check if PCF is currently active and if time to transmit */
	/* the CFP end frame. If so check if more fragments have 	*/
	/* to be transmitted. If none then, prepare to send the 	*/
	/* cfp_end frame to indicate the end of the CFP period		*/
	if ((wlan_flags->pcf_active == OPC_TRUE) && 
		(ap_flag == OPC_BOOLINT_ENABLED) &&
		((wlan_flags->tx_beacon == OPC_FALSE) || 
		 (wlan_flags->tx_cf_end == OPC_TRUE)  ||
		 (op_sar_buf_size (pcf_frag_buffer_ptr) != 0)))
		{
		/* Store the size of the PCF fragmentation buffer in a	*/
		/* local variable for quick access.						*/
		pcf_frag_buf_empty = (op_sar_buf_size (pcf_frag_buffer_ptr) == 0) ? OPC_TRUE : OPC_FALSE;
		
		/* Check if the transmission of the cf end frame has been */
		/* enabled. If so, make sure there are no more fragments  */
		/* pending and the PCF fragmentation buffer is empty      */
		if ((wlan_flags->tx_cf_end == OPC_TRUE) && (wlan_flags->more_frag == OPC_FALSE) && pcf_frag_buf_empty)
			{
			/* If the AP needs to ACK to a previously received       */
			/* frame send a CF_end_Ack frame, if not transmit CF end */
			if (fresp_to_send == WlanC_Ack) 
				wlan_prepare_frame_to_send (WlanC_Cf_End_A);
			else  
				wlan_prepare_frame_to_send (WlanC_Cf_End);
						
			FOUT;
			}

		/* Allocating pool memory to the higher layer data structure type. */	
		hld_ptr = (WlanT_Hld_List_Elem *) op_prg_pmo_alloc (hld_pmh);
	
		/* Generate error message and abort simulation if no memory left for data received from higher layer.	*/
		if (hld_ptr == OPC_NIL)
			{
			wlan_mac_error ("No more memory left to assign for data received from higher layer", OPC_NIL, OPC_NIL);
			}
		
		/* Set up dummy element to see if any more data for station currently being polled */
		if (poll_index > -1)
			hld_ptr->destination_address = polling_list [poll_index];
		else 
			hld_ptr->destination_address = -1;
		
		/* Set search bound for pcf higher layer data queue */
		list_high_index = op_prg_list_size (cfpd_list_ptr);
		list_low_index = 0;

		/* If a poll fail count reached the max poll fail count or		 */
		/* the previous poll was successful and no more data from this   */
		/* station and last data tx was successful and no more           */
		/* fragments exist and no more data exist in the hlk queue       */
		/* for this station then next station will start transmission	 */
		if ((poll_fail_count > max_poll_fails) ||
			(((poll_fail_count == 0) && 
			 (wlan_flags->more_data == OPC_FALSE) &&
			 (wlan_flags->more_frag == OPC_FALSE)) &&
			((pcf_retry_count == 0) && pcf_frag_buf_empty &&
			(op_prg_list_elem_find (cfpd_list_ptr, wlan_hld_list_elem_add_comp, hld_ptr, 
			&list_low_index, &list_high_index) == OPC_NIL))))
			{
			/* Increment polling index to next user.		*/
			poll_index++;
			
			/* Check whether the poll reached the specified	*/
			/* limit.										*/
			if (poll_fail_count > max_poll_fails)
				{
				/* Reset the relevant flags.				*/
				wlan_flags->pcf_side_traf = OPC_FALSE;
				wlan_flags->active_poll   = OPC_FALSE;
				wlan_flags->more_data	  = OPC_FALSE;
			
				/* Reset the retry count and drop the		*/
				/* packet.								   	*/
				pcf_retry_count = retry_limit;
				wlan_pcf_frame_discard ();
				
				/* Initialize the poll fail count.			*/
				poll_fail_count = 0;
				}
			}
		
		/* If we finished polling all the pollable STAs in	*/
		/* the list but still have some contention free		*/
		/* frames to send, then restart polling the			*/
		/* pollable STAs since we still have some CFP time	*/
		/* to go.											*/
		if (poll_index == poll_list_size)
			{
			if (op_prg_list_size (cfpd_list_ptr) > 0)
				{
				/* Restart the polling.						*/
				poll_index       = 0;
				pcf_queue_offset = 0;
				}
			else
				{
				/* End the CFP prematurely since we have no	*/
				/* stations to poll and no CF frames to		*/
				/* send. Also send an ACK if necessary.		*/
				if (fresp_to_send == WlanC_Ack) 
					wlan_prepare_frame_to_send (WlanC_Cf_End_A);
				else 
					wlan_prepare_frame_to_send (WlanC_Cf_End);
				
				/* Destroy the dummy higher layer data		*/
				/* entry used for searching.				*/
				op_prg_mem_free (hld_ptr);
			
				FOUT;			
				}
			}

		/* Re init dummy element for new poll index.		*/
		hld_ptr->destination_address = polling_list [poll_index];

		/* Set the destination address.						*/				
		destination_addr = hld_ptr->destination_address;
		
		/* First check if this is a retry.					*/
		if (pcf_retry_count != 0)
			{
			/* Destroy the dummy higher layer data entry	*/
			/* used for searching.							*/
			op_prg_mem_free (hld_ptr);
			
			/* Set type to last frame type.					*/
			op_pk_nfd_access (wlan_pcf_transmit_frame_copy_ptr, "Type", &type);
			
			/* Check the ACK status for retransmission.		*/
			if (fresp_to_send != WlanC_Ack && (type == WlanC_Data_A_P || type == WlanC_Cf_A_P))
				{
				/* The previous message was sent with an	*/
				/* ACK, which needs to be removed from this	*/
				/* retransmission.							*/
				type = (type == WlanC_Data_A_P) ? WlanC_Data_Poll : WlanC_Cf_Poll;
				}
			
			/* Perform the retransmission.					*/
			wlan_prepare_frame_to_send (type);
			
			FOUT;
			}
		
		/* Check if fragmentation buffer is empty and if there is any data to send 	*/
	   	/* to this station.  If no data,  send  ack / poll as needed.		 		*/ 
		else if (pcf_frag_buf_empty && 
				(op_prg_list_elem_find (cfpd_list_ptr, wlan_hld_list_elem_add_comp, hld_ptr, &list_low_index, &list_high_index) == OPC_NIL))
			{
			/* Set active poll flag since poll will be transmitted*/
			wlan_flags->active_poll = OPC_TRUE;

			/* If the AP has a pending ACK to transmit, send Ack-CF poll frame. */
			/* If no pending ACK for this station transmit the poll frame		*/
			if (fresp_to_send == WlanC_Ack) 
				{
				wlan_prepare_frame_to_send (WlanC_Cf_A_P);
				}
			else
				{
				wlan_prepare_frame_to_send (WlanC_Cf_Poll);
				}
		
			/* Destroy the dummy higher layer data entry	*/
			/* used for searching.							*/
			op_prg_mem_free (hld_ptr);
			
			FOUT;
			}

		/* If we've come this far, there must be data for this user.		*/
		/* If the fragmentation buffer is empty, get a new packet and 	 	*/
		/* setup fragmentation buffer. Tx of frame is queued outside		*/
		/* this else if.													*/
		else if (pcf_frag_buf_empty) 
			{
			/* First destroy the dummy higher layer data entry used for		*/
			/* searching.													*/
			op_prg_mem_free (hld_ptr);
			
			do
				{
				/* Get next packet for transmission from the higher layer queue.*/
				hld_ptr = (WlanT_Hld_List_Elem*) op_prg_list_access (cfpd_list_ptr, pcf_queue_offset);

				/* Make sure destination address matches polling address.		*/
				if (hld_ptr->destination_address != polling_list 	[poll_index])
					{
					/* A packet must have been inserted into the queue by the 	*/
					/* upper layers after I started polling for a lower 		*/
					/* address.  Increment an offset to track packets at the 	*/
					/* head of the queue that have missed their opportunity 	*/
					/* to transmit this CFP.  Restore the packet to the 		*/
					/* point where it was stored, and get the next packet for 	*/
					/* transmission.											*/
					pcf_queue_offset++;
				
					if (pcf_queue_offset > list_high_index)
						wlan_mac_error ("Polling routine error. \n Destination not on list.", OPC_NIL, OPC_NIL);
					}
				} 
			while (hld_ptr->destination_address != polling_list [poll_index] );
			
			/* Remove packet from higher layer queue. */	
			hld_ptr = (WlanT_Hld_List_Elem *) op_prg_list_remove (cfpd_list_ptr, pcf_queue_offset);

			/* Setting destination address state variable	*/				
			destination_addr = hld_ptr->destination_address;

			/* Determine packet size - required to determine fragmentation	*/
			packet_size_pcf = op_pk_total_size_get (hld_ptr->pkptr);
	
			/* Updating the total packet size of the higher layer buffer.	*/
			total_cfpd_size = total_cfpd_size - packet_size_pcf;

			/* Packet seq number modulo 4096 counter.	*/
			packet_seq_number = (packet_seq_number + 1) % 4096;  

			/* Packet fragment number is initialized.	*/	
			packet_frag_number = 0;				
						
			/* Packet needs to be fragmented if it is more than			*/
			/* fragmentation threshold, provided fragmentation is		*/
			/* enabled. Broadcast packets are not fragmented regardless	*/
			/* of their sizes.											*/
			if (frag_threshold != -1 && destination_addr >= 0 && packet_size_pcf > (frag_threshold * 8))
				{
				/* Determine number of fragments for the packet	*/
				/* and the size of the last fragment			*/							
				pcf_num_fragments =  (int) (packet_size_pcf / (frag_threshold * 8));
				pcf_remainder_size = packet_size_pcf - (pcf_num_fragments * frag_threshold * 8);

				/* If the remainder size is non zero it means that the	*/
				/* last fragment is fractional but since the number 	*/
				/* of fragments is a whole number we need to transmit	*/	
				/* one additional fragment to ensure that all of the	*/
				/* data bits will be transmitted						*/
				if (pcf_remainder_size != 0)
					{
					pcf_num_fragments = pcf_num_fragments + 1;									 
					}
				}
			else
				{			
				/* If no fragments needed then number of	*/
				/* packets to be transmitted is set to 1	*/								
				pcf_num_fragments = 1;
				pcf_remainder_size = packet_size_pcf;
				}

			/* Storing Data packet id for debugging purposes.	*/			
			pcf_pkt_in_service = op_pk_id (hld_ptr->pkptr);		

			/* Insert packet to fragmentation buffer	*/					
			op_sar_segbuf_pk_insert (pcf_frag_buffer_ptr, hld_ptr->pkptr, 0);

			/* Computing packet duration in the queue in seconds	*/
			/* and reporting it to the statistics					*/
			pkt_tx_time = (current_time - hld_ptr->time_rcvd);
			
			/* Printing out information to ODB.				*/
			if (wlan_trace_active == OPC_TRUE)
				{
				sprintf (msg_string, "Data packet " SIMC_PK_ID_FMT " is removed from pcf queue", pcf_pkt_in_service);
				sprintf	(msg_string1, "The queueing delay for data packet " SIMC_PK_ID_FMT " is %fs", 	
							pcf_pkt_in_service, pkt_tx_time);	
				op_prg_odb_print_major (msg_string, msg_string1, OPC_NIL);
				}

			/* Store the arrival time of the pcf packet.	*/
			receive_time_pcf = hld_ptr->time_rcvd;
			
			/* Freeing up allocated memory for the data		*/
			/* packet removed from the higher layer queue.	*/
			op_prg_mem_free (hld_ptr);
	
			/* Set up retry limit - no RTS so always short.	*/
			retry_limit = short_retry_limit;
			}
		else
			{
			/* Destroy the dummy higher layer data entry	*/
			/* used earlier for searching.					*/
			op_prg_mem_free (hld_ptr);
			}

		/* Set active poll flag since poll will be			*/
		/* transmitted.										*/
		wlan_flags->active_poll = OPC_TRUE;

		/* Time to transmit fragment - Retrys happen		*/
		/* automatically.									*/
		if (fresp_to_send == WlanC_Ack) 
			wlan_prepare_frame_to_send (WlanC_Data_A_P);
		else  
			wlan_prepare_frame_to_send (WlanC_Data_Poll);
		}
	else
		{
		/* The order of else if statements here is very important, as		*/
		/* the code uses it to enforce the proper preemption of various		*/
		/* valid frame sequences while preventing the preemption of others	*/

		/* If not PCF, an Ack needs to be sent for the data */
		/* prepare Ack for transmission	                    */
		if ((wlan_flags->polled == OPC_FALSE) && 
			(fresp_to_send == WlanC_Ack))
			{
			wlan_prepare_frame_to_send (fresp_to_send);
			
			/* Break the routine once Ack is prepared to transmit */
			FOUT;
			}

		/* If Time to send beacon, takes priority over other sequences	*/
		else if ((wlan_flags->tx_beacon == OPC_TRUE) && 
			(op_sar_buf_size (fragmentation_buffer_ptr) == 0))
			{
			/* Reset any pending responses since beacon will terminate sequence anyway */
			fresp_to_send = WlanC_None;

			/* Prepare beacon frame to be transmitted */
			wlan_prepare_frame_to_send (WlanC_Beac);
		
			/* Break the routine once beacon prepared to transmit */
			FOUT;
			}

		/* DCF Transmission processing */
		
		/* Send a CTS frame if it is the type of frame we need to send a		*/
		/* response of.															*/
		else if (fresp_to_send == WlanC_Cts)
			{
			wlan_prepare_frame_to_send (fresp_to_send);
			
			/* Break the routine if Cts or Ack is already prepared to transmit.	*/
			FOUT;
			}
	
		/* If it is a retransmission then check which type of frame needs to be	*/
		/* retransmitted and then prepare and transmit that frame.				*/
		else if (retry_count != 0)
			{
			/* If the last frame unsuccessfully transmitted was Rts then transmit it again.	*/
			if (last_frametx_type == WlanC_Rts && wlan_flags->rts_sent == OPC_FALSE && 
				wlan_flags->polled == OPC_FALSE)
				{
				/* Retransmit the Rts frame.	*/
				wlan_prepare_frame_to_send (WlanC_Rts);
				}

			/* For the retransmission of data frame first check whether RTS needs to be sent or not.	*/
			/* If it RTS needs to be sent and it is not already sent then first transmit RTS and then	*/
			/* transmit data frame.																		*/
			else if (last_frametx_type == WlanC_Data && wlan_flags->polled == OPC_FALSE)
				{
				if ((rts_threshold != -1) && (wlan_flags->rts_sent == OPC_FALSE) && 
					(op_pk_total_size_get (wlan_transmit_frame_copy_ptr) - 
					 plcp_overhead_data * operational_speed > 8 * rts_threshold))
					{
					/* Retransmit the RTS frame to again contend for the data .	*/
					wlan_prepare_frame_to_send (WlanC_Rts);		
					}
				else
					{
					wlan_prepare_frame_to_send (WlanC_Data);
					}
				}
			else
				{
				/* We continue with the retransmission process. Either we have	*/
				/* received the expected CTS for our last RTS before and now we	*/
				/* can retransmit our data frame, or we moved from DCF period	*/
				/* into PCF period and have been polled by the AP for			*/
				/* transmission. In case of PCF, also check whether we have an	*/
				/* ACK to append to our data packet.							*/
				if (fresp_to_send == WlanC_Ack && wlan_flags->polled == OPC_TRUE)
					wlan_prepare_frame_to_send (WlanC_Data_Ack);
				else 
					wlan_prepare_frame_to_send (WlanC_Data);
				}
			
			FOUT;
			}

		/* If higher layer queue is not empty then dequeue a packet	*/
		/* from the higher layer and insert it into fragmentation 	*/
		/* buffer check whether fragmentation and Rts-Cts exchange 	*/
		/* is needed  based on thresholds							*/
		/* Check if fragmentation buffer is empty. If it is empty   */
		/* then dequeue a packet from the higher layer queue.		*/ 
		else if ((op_prg_list_size (hld_list_ptr) != 0) && (op_sar_buf_size (fragmentation_buffer_ptr) == 0))
			{	
			/* If rts is already sent then transmit data otherwise	*/
			/* check if rts needs to be sent or not.				*/
			if (wlan_flags->rts_sent == OPC_FALSE)
				{
				/* Remove packet from higher layer queue. */
				hld_ptr = (WlanT_Hld_List_Elem *) op_prg_list_remove (hld_list_ptr, 0);
			
				/* Update the higher layer queue size statistic.				*/
				op_stat_write (hl_packets_rcvd, (double) (op_prg_list_size (hld_list_ptr)));
			
				/* Determine packet size to determine later whether fragmentation	*/
				/* and/or rts-cts exchange is needed.								*/
				packet_size_dcf = op_pk_total_size_get (hld_ptr->pkptr);

				/* Updating the total packet size of the higher layer buffer.	*/
				total_hlpk_size = total_hlpk_size - packet_size_dcf;

				/* Setting destination address state variable	*/				
				destination_addr = hld_ptr->destination_address;
						
				/* Packet seq number modulo 4096 counter.	*/
				packet_seq_number = (packet_seq_number + 1) % 4096;  
				
				/* Packet fragment number is initialized.	*/
				packet_frag_number = 0;				
						
				/* Packet needs to be fragmented if it is more than			*/
				/* fragmentation threshold, provided fragmentation is		*/
				/* enabled. Broadcast packets are not fragmented regardless	*/
				/* of their sizes.											*/
				if (frag_threshold != -1 && destination_addr >= 0 && packet_size_dcf > (frag_threshold * 8))
					{
					/* Determine number of fragments for the packet	*/
					/* and the size of the last fragment			*/							
					num_fragments =  (int) (packet_size_dcf / (frag_threshold * 8));
					remainder_size = packet_size_dcf - (num_fragments * frag_threshold * 8);

					/* If the remainder size is non zero it means that the	*/
					/* last fragment is fractional but since the number 	*/
					/* of fragments is a whole number we need to transmit	*/
					/* one additional fragment to ensure that all of the	*/
					/* data bits will be transmitted						*/
					if (remainder_size != 0)
						{
						num_fragments = num_fragments + 1;									 
						}
					}
				else
					{			
					/* If no fragments needed then number of	*/
					/* packets to be transmitted is set to 1	*/								
					num_fragments = 1;
					remainder_size = packet_size_dcf;
					}

				/* Storing Data packet id for debugging purposes.	*/			
				pkt_in_service = op_pk_id (hld_ptr->pkptr);		
				
				/* Insert packet to fragmentation buffer	*/					
				op_sar_segbuf_pk_insert (fragmentation_buffer_ptr, hld_ptr->pkptr, 0);

				/* Computing packet duration in the queue in seconds	*/
				/* and reporting it to the statistics					*/
				pkt_tx_time = (current_time - hld_ptr->time_rcvd);

				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					sprintf (msg_string, "Data packet " SIMC_PK_ID_FMT " is removed from higher layer buffer", pkt_in_service);
					sprintf	(msg_string1, "The queueing delay for data packet " SIMC_PK_ID_FMT " is %fs", 	
						pkt_in_service, pkt_tx_time);	
					op_prg_odb_print_major (msg_string, msg_string1, OPC_NIL);
					}

				/* Store the arrival time of the packet.	*/
				receive_time_dcf = hld_ptr->time_rcvd;
			
				/* Freeing up allocated memory for the data packet removed from the higher layer queue.	*/
				op_prg_mem_free (hld_ptr);

				/* Send rts if RTS is enabled and packet size is more than RTS threshold.	*/
				/* No RTS message is sent for broadcast packets regradless of their sizes.	*/
				if (rts_threshold != -1 && destination_addr >= 0 && 
					(packet_size_dcf + WLANC_MSDU_HEADER_SIZE) > (rts_threshold * 8) &&
					wlan_flags->polled == OPC_FALSE)			
					{						 		
					retry_limit = long_retry_limit;
				
					/* Prepare Rts frame for transmission	*/
					wlan_prepare_frame_to_send (WlanC_Rts);
					
					/* Break the routine as Rts is already prepared	*/
					FOUT;
					}
				else
					{
					retry_limit = short_retry_limit;
					}
				}
			}
		
		/* Prepare data frame to transmit. First check whether the station	*/
		/* has been polled (if it is in CFP).								*/
		if (wlan_flags->polled == OPC_TRUE)
			{
			/* If there is no data to send select frame response			*/
			/* accordingly if we need to send an ACK back.					*/
			if (op_sar_buf_size (fragmentation_buffer_ptr) == 0)
				{
				if (fresp_to_send == WlanC_Ack) 
					wlan_prepare_frame_to_send (WlanC_Cf_Ack);
				else 
					wlan_prepare_frame_to_send (WlanC_Data_Null);
				}
			else  
				{
				/* We have data to respond to the poll. Also append the ACK	*/
				/* if we have an ACK to respond.							*/
				if (fresp_to_send == WlanC_Ack)
					wlan_prepare_frame_to_send (WlanC_Data_Ack);
				else 
					wlan_prepare_frame_to_send (WlanC_Data);
				}
			}		
		else
			{
			/* This is a normal DCF transmission. Prepare the frame for		*/
			/* for transmission.											*/
			wlan_prepare_frame_to_send (WlanC_Data);
			}
		}
	
	FOUT;
	}
		
static void 
wlan_prepare_frame_to_send (int frame_type)
	{
	Packet*							seg_pkptr;
	OpT_Packet_Size					tx_datapacket_size;
	int								type;
	double							tx_data_rate;
	double							duration, mac_delay;
	double							total_pk_size;
	double							tx_end_time;
	WlanT_Data_Header_Fields*		pk_dhstruct_ptr;
	WlanT_Control_Header_Fields*	pk_chstruct_ptr;
	WlanT_Beacon_Body_Fields*		pk_bbstruct_ptr;
	Packet*							wlan_transmit_frame_ptr;
	char							msg_string [120];
	char							frame_type_str [32];
	
	/** Prepare frames to transmit by setting appropriate fields in the 	**/
    /** packet format for Data,Cts,Rts or Ack.  If data or Rts packet needs **/
    /** to be retransmitted then the copy of the packet is resent.          **/
	FIN (wlan_prepare_frame_to_send (int frame_type));

	/* First initialize the transmission data rate to the lowest supported	*/
	/* data rate.															*/
	tx_data_rate = LOWEST_TX_RATE;

	/* It this is a CP period and the frame to be transmitted is a data/ACK.*/
	if ((wlan_flags->pcf_active == OPC_FALSE) && 
	   ((frame_type == WlanC_Data) || (frame_type == WlanC_Data_Ack)))
		{
		/* Adjust the transmission data rate based on the operational speed.*/
		tx_data_rate = operational_speed;

		/* Set the variable which keeps track of the last transmitted frame.	*/
		last_frametx_type = (WlanT_Mac_Frame_Type) frame_type;
					
		/* If it is a retransmission of a packet. Obtain the frame from the 	*/
		/* the copy pointer which was stored during the previous transmission	*/
		if ((retry_count > 0) && (wlan_transmit_frame_copy_ptr != OPC_NIL))
			{
			/* If it is a retransmission then just transmit the previous frame	*/			
			wlan_transmit_frame_ptr = op_pk_copy (wlan_transmit_frame_copy_ptr);
			
			/* Modifications for LR WPAN model, by Olivier	*/
			if (INTRPT_STATUS_DEBUG)
				printf ("%s MAC layer: %.15f s: retransmission.\n", wlan_name, op_sim_time ());
			/************  end of modifications  ************/

			/* Reset header type in case Ack status has changed for frame */
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", frame_type);

			/* If retry count is non-zero means that the frame is a */
			/* retransmission of the last transmitted frame			*/
			op_pk_nfd_access (wlan_transmit_frame_ptr, "Wlan Header", &pk_dhstruct_ptr);
			pk_dhstruct_ptr->retry = 1;
			
			/* Reset more_data bit in case queue status has changed since last transmission			*/
			/* If this STA has been polled, and there are additional packets remaining				*/
			if ((wlan_flags->polled == OPC_TRUE) && (op_prg_list_size (hld_list_ptr) != 0))
				{
				/* Set more data bit to tell AP that STA has more packets */
				pk_dhstruct_ptr->more_data = 1;
				}

			/* Printing out information to ODB.	*/
			if (wlan_trace_active == OPC_TRUE)
				{
				sprintf (msg_string, "Data fragment %d for packet " SIMC_PK_ID_FMT " is retransmitted",
					     pk_dhstruct_ptr->fragment_number, pkt_in_service);							
				op_prg_odb_print_major (msg_string, OPC_NIL);
				}					

			/* Calculate nav duration till the channel will be occupied by 	*/
			/* station. The duration is SIFS time plus the ack frame time  	*/
			/* which the station needs in response to the data frame.		*/		
			duration = sifs_time + plcp_overhead_control + WLAN_ACK_DURATION;		

			/* Since the number of fragments for the last transmitted frame is	*/
			/* already decremented, there will be more fragments to transmit  	*/
			/* if number of fragments is more than zero.					  	*/
			if (num_fragments != 1)	
				{
				/* If more fragments need to be transmitted then the station 	*/
				/* need to broadcast the time until the receipt of the       	*/
				/* the acknowledgement for the next fragment. 224 bits (header	*/
				/* size) is the length of the control fields in the data  		*/
				/* frame and needs to be accounted in the duration calculation	*/
				duration = 2 * duration + sifs_time + plcp_overhead_data + 
						   ((frag_threshold * 8) + WLANC_MSDU_HEADER_SIZE) / operational_speed;
				}

			/* Set the type of the expected response to "ACK".	*/			
			expected_frame_type = WlanC_Ack;
			
			/* Station update its own nav_duration during CP   	*/
			/* NAV should be updated only during the CP period 	*/
			/* During CFP NAV duration is updated only during	*/
			/* the transmission of the beacon frames			*/
			if (cfp_ap_medium_control == OPC_FALSE)
				nav_duration = current_time + duration + (double) (op_pk_total_size_get (wlan_transmit_frame_ptr)) / operational_speed ;
			}
		else
			{
			/* Creating transmit data packet type.							*/
			wlan_transmit_frame_ptr = op_pk_create_fmt ("wlan_mac");
				
			/* Add some bulk to the packet to model the transmission delay	*/
			/* of PLCP fields accurately which are always transmitted at	*/
			/* 1 Mbps regardless of the actual data rate used for data		*/
			/* frames.														*/
			op_pk_bulk_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (plcp_overhead_data * operational_speed - WLAN_DEFAULT_PLCP_OVERHEAD));
		
			/* Prepare data frame fields for transmission.					*/		
			pk_dhstruct_ptr = wlan_mac_pk_dhstruct_create ();

			type = (WlanT_Mac_Frame_Type) frame_type;
			
			pk_dhstruct_ptr->retry = 0;				
			pk_dhstruct_ptr->order = 1;
			pk_dhstruct_ptr->sequence_number = packet_seq_number;

			/* Calculate nav duration till the channel will be occupied by  */
			/* station. The duration is SIFS time plus the ack frame time   */
			/* which the station needs in response to the data frame.		*/		
			duration = sifs_time + plcp_overhead_control + WLAN_ACK_DURATION;

			/* If there is more than one fragment to transmit and there are  	*/
			/* equal sized fragments then remove fragmentation threshold size	*/
			/* length of data from the buffer for transmission.					*/
			if  ((num_fragments > 1) || (remainder_size == 0))
				{
				/* Remove next fragment from the fragmentation buffer for 	*/
				/* transmission and set the appropriate fragment number.  	*/
				seg_pkptr = op_sar_srcbuf_seg_remove (fragmentation_buffer_ptr, frag_threshold * 8);
			
				/* Indicate in transmission frame that more fragments need to be sent	*/
				/* if more than one fragments are left								 	*/
				if (num_fragments != 1)	
					{
					pk_dhstruct_ptr->more_frag = 1;
				
					/* If more fragments need to be transmitted then the station	*/
					/* need to broadcast the time until the receipt of the       	*/
					/* the acknowledgement for the next fragment. 224 bits (header	*/
					/* size) is the length of control fields in the data frame  	*/
					/* and need to be accounted for in the duration calculation		*/
					duration = 2 * duration + sifs_time + plcp_overhead_data + 
					           ((frag_threshold * 8) + WLANC_MSDU_HEADER_SIZE) / operational_speed;
					}
				else
					{
					/* If no more fragments to transmit then set more fragment field to be 0 */
					pk_dhstruct_ptr->more_frag = 0;
					}
						
				/* Set fragment number in packet field	 */
				pk_dhstruct_ptr->fragment_number = packet_frag_number ;

				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					sprintf (msg_string, "Data fragment %d for packet " SIMC_PK_ID_FMT " is transmitted",packet_frag_number, pkt_in_service);							
					op_prg_odb_print_major (msg_string, OPC_NIL);
					}

				/* Setting packet fragment number for next fragment to be transmitted */
				packet_frag_number = packet_frag_number + 1;    	
				}
			else
				{
				/* Remove last fragments (if any left) from the fragmentation buffer for */
				/* transmission and disable more fragmentation bit.				         */
												
				seg_pkptr = op_sar_srcbuf_seg_remove (fragmentation_buffer_ptr, remainder_size);					
			
				pk_dhstruct_ptr->more_frag = 0;
				
				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					sprintf (msg_string, "Data fragment %d for packet " SIMC_PK_ID_FMT " is transmitted",packet_frag_number, pkt_in_service);								
					op_prg_odb_print_major (msg_string, OPC_NIL);
					}

				pk_dhstruct_ptr->fragment_number = packet_frag_number;
				}	

			/* Setting the Header field structure.	*/

			/** if this is the CF period and the STA has been polled	**/
			/** then set the duration to the standard value.			**/
			if (wlan_flags->polled == OPC_TRUE)
				{
				/* Duration should be set to 32768 during CFP.										*/
				duration = 32768.0;
				pk_dhstruct_ptr->duration  = duration;
				}
			else
				{
				/* This is the CP, so set duration field.											*/
				pk_dhstruct_ptr->duration  = duration;
				}
			
			pk_dhstruct_ptr->address1  = destination_addr;
			pk_dhstruct_ptr->address2  = my_address;

			/* In the BSS network the Data frame is going from AP to sta then fromds bit is set.	*/
    		if (ap_flag == OPC_BOOLINT_ENABLED)
				pk_dhstruct_ptr->fromds	 = 1;
			else
				pk_dhstruct_ptr->fromds	 = 0;

			/* if in the BSS network the Data frame is going from sta to AP then tods bit is set.	*/					
    		if ((bss_flag == OPC_TRUE) && 
				(ap_flag == OPC_BOOLINT_DISABLED) &&
				(ap_relay == OPC_TRUE))
				{
				pk_dhstruct_ptr->tods = 1;
				
				/* If Infrastructure BSS then the immediate destination will be Access point, which 	*/
				/* then forward the frame to the appropriate destination.								*/
				pk_dhstruct_ptr->address1 = ap_mac_address ;
				pk_dhstruct_ptr->address3 = destination_addr;
				}
			else
				{
				pk_dhstruct_ptr->tods = 0;
				}

			/* If this STA has been polled, and there are additional packets remaining				*/
			if ((wlan_flags->polled == OPC_TRUE) && (op_prg_list_size (hld_list_ptr) != 0))
				{
				/* Set more data bit to tell AP that STA has more packets */
				pk_dhstruct_ptr->more_data = 1;
				}
			
			/* If we are sending the first fragment of the data fragment for the first	*/
			/* time, then this is the end of media access duration, hence we must		*/
			/* update the media access delay statistics.								*/
			if (packet_size_dcf == op_pk_total_size_get (seg_pkptr) + op_sar_buf_size (fragmentation_buffer_ptr))
				{
				mac_delay = current_time - receive_time_dcf;
				op_stat_write (media_access_delay, mac_delay);
				op_stat_write (global_mac_delay_handle, mac_delay);
				}
			
			/* Populate the packet fields.								*/
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", type);
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Accept", OPC_TRUE);
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Data Packet ID", (double) (OpT_Int64) pkt_in_service);
				
			/* Set the frame control field and nav duration.		   	*/
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Wlan Header", pk_dhstruct_ptr,	
			wlan_mac_pk_dhstruct_copy, wlan_mac_pk_dhstruct_destroy, sizeof (WlanT_Data_Header_Fields));

			/* The actual data is placed in the Frame Body field.		*/
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Frame Body", seg_pkptr);

			/* Only expect Acknowledgement for directed frames.			*/
			if (destination_addr < 0)
				{
				expected_frame_type = WlanC_None;
				}
			else
				{
				/* Ack frame is expected in response to data frame.		*/
				expected_frame_type = WlanC_Ack;
				}

			/* Make copy of the frame before transmission -- make sure	*/
			/* that a packet destined for broadcast addresses is not	*/
			/* copied as that would never to destroyed (due to unACKing	*/
			/* nature of broadcast traffic).							*/
			if (destination_addr >= 0)
				wlan_transmit_frame_copy_ptr = op_pk_copy (wlan_transmit_frame_ptr);
			else
				wlan_transmit_frame_copy_ptr = (Packet *) OPC_NIL;

		    /* Station update of its own nav_duration.					*/
			if (cfp_ap_medium_control == OPC_FALSE)
				nav_duration = current_time + duration + (double) (op_pk_total_size_get (wlan_transmit_frame_ptr)) / operational_speed ;
			}
		
		/* Update the data traffic sent statistics.						*/
		total_pk_size = (double) op_pk_total_size_get (wlan_transmit_frame_ptr);
		op_stat_write (data_traffic_sent_handle_inbits, total_pk_size);
		op_stat_write (data_traffic_sent_handle, 1.0);

		/* Write a value of 0 for the end of transmission.				*/
		tx_end_time = current_time + total_pk_size / operational_speed;
		op_stat_write_t (data_traffic_sent_handle_inbits, 0.0, tx_end_time);
		op_stat_write_t (data_traffic_sent_handle, 0.0, tx_end_time);
		
		/* We can be sending this data message as a response to a CTS message	*/
		/* we received. Therefore reset the "frame respond to send" variable.	*/
		fresp_to_send = WlanC_None;
		
		/* If there is nothing in the higher layer data queue and fragmentation buffer	*/
		/* then disable the data frame flag which will indicate to the station to wait	*/
		/* for the higher layer packet.													*/
		if (op_prg_list_size (hld_list_ptr) == 0 && op_sar_buf_size (fragmentation_buffer_ptr) == 0)
			wlan_flags->data_frame_to_send = OPC_FALSE;			
		}

	/* If this is a contention free period and need to send a data/ack/poll.	*/
	else if ((wlan_flags->pcf_active == OPC_TRUE) &&
			((frame_type == WlanC_Data)	|| (frame_type == WlanC_Data_Ack) || 
			(frame_type == WlanC_Data_Poll)	|| (frame_type == WlanC_Data_A_P))) 
		{
		/* Preserve the frame type being transmitted */
		last_frametx_type = (WlanT_Mac_Frame_Type) frame_type;
		
		/* Adjust the transmission data rate based on the operational speed.*/
		tx_data_rate = operational_speed;

		/* Set active poll flag if this is a poll frame */
		if ((frame_type == WlanC_Data_Poll)	|| (frame_type == WlanC_Data_A_P))
			{
			wlan_flags->active_poll = OPC_TRUE;
			}
		
		/* If it is a retransmission of a packet then no need 	*/
        /* to prepare data frame.							    */
		if (pcf_retry_count == 0)
			{
			/* Creating transmit data packet type.							*/
			wlan_transmit_frame_ptr = op_pk_create_fmt ("wlan_mac");
				
			/* Add some bulk to the packet to model the transmission delay	*/
			/* of PLCP fields accurately which are always transmitted at	*/
			/* 1 Mbps regardless of the actual data rate used for data		*/
			/* frames.														*/
			op_pk_bulk_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (plcp_overhead_data * operational_speed - WLAN_DEFAULT_PLCP_OVERHEAD));
		
			/* Prepare data frame fields for transmission.					*/		
			pk_dhstruct_ptr = wlan_mac_pk_dhstruct_create ();

			pk_dhstruct_ptr->retry = 0;				
			pk_dhstruct_ptr->order = 1;
			pk_dhstruct_ptr->sequence_number = packet_seq_number;

			/* If there is more than one fragment to transmit and there are  	*/
			/* equal sized fragments then remove fragmentation threshold size	*/
			/* length of data from the buffer for transmission.					*/
			if  ((pcf_num_fragments > 1) || (pcf_remainder_size == 0))
				{
				/* Remove next fragment from the fragmentation buffer for 	*/
				/* transmission and set the appropriate fragment number.  	*/
				seg_pkptr = op_sar_srcbuf_seg_remove (pcf_frag_buffer_ptr, frag_threshold * 8);
		
				/* Indicate in transmission frame that more fragments need to be sent	*/
				/* if more than one fragments are left								 	*/
				if (pcf_num_fragments != 1)	
					{
					pk_dhstruct_ptr->more_frag = 1;
					}
				else
					{
					/* If no more fragments to transmit then set more fragment field to be 0 */
					pk_dhstruct_ptr->more_frag = 0;
					}
						
				/* Set fragment number in packet field	 */
				pk_dhstruct_ptr->fragment_number = packet_frag_number;

				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					sprintf (msg_string, "Data fragment %d for packet " SIMC_PK_ID_FMT " is transmitted",
						packet_frag_number, pcf_pkt_in_service);							
					op_prg_odb_print_major (msg_string, OPC_NIL);
					}

				/* Setting packet fragment number for next fragment to be transmitted */
				packet_frag_number = packet_frag_number + 1;    	
				}
			else
				{
				/* Remove last fragments (if any left) from the fragmentation buffer for */
				/* transmission and disable more fragmentation bit.				         */
				seg_pkptr = op_sar_srcbuf_seg_remove (pcf_frag_buffer_ptr, pcf_remainder_size);					

				pk_dhstruct_ptr->more_frag = 0;

				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					sprintf (msg_string, "Data fragment %d for packet " SIMC_PK_ID_FMT " is transmitted",
							 packet_frag_number, pcf_pkt_in_service);								
					op_prg_odb_print_major (msg_string, OPC_NIL);
					}

				pk_dhstruct_ptr->fragment_number = packet_frag_number;
				}	

			/* Set duration field */
			/* During CFP the duration field should read 32768. (Section 7.1.3.2 of spec) */
			duration = 32768.0;

			/* Setting the Header field structure.	*/
			pk_dhstruct_ptr->duration  = duration;
			pk_dhstruct_ptr->address1  = destination_addr;
			pk_dhstruct_ptr->address2  = my_address;

			/* In the BSS network the Data frame is going from AP to sta then fromds bit is set.	*/
    		if (ap_flag == OPC_BOOLINT_ENABLED)
				{
				pk_dhstruct_ptr->fromds	 = 1;
				}
			else
				{
				pk_dhstruct_ptr->fromds	 = 0;
				}

			/* if in the BSS network the Data frame is going from sta to AP then tods bit is set.	*/					
    		if ((bss_flag == OPC_TRUE) && (ap_flag == OPC_BOOLINT_DISABLED) &&
				(ap_relay == OPC_TRUE))
				{
				pk_dhstruct_ptr->tods = 1;

				/* If Infrastructure BSS then the immediate destination will be Access point, which 	*/
				/* then forward the frame to the appropriate destination.								*/
				pk_dhstruct_ptr->address1 = ap_mac_address;
				pk_dhstruct_ptr->address3 = destination_addr;
				}
			else
				{
				pk_dhstruct_ptr->tods = 0;
				}
	
			/* If we are sending the first fragment of the data fragment for the first	*/
			/* time, then this is the end of media access duration, hence we must		*/
			/* update the media access delay statistics.								*/
			if (packet_size_pcf == op_pk_total_size_get (seg_pkptr) + op_sar_buf_size (pcf_frag_buffer_ptr))
				{
				mac_delay = current_time - receive_time_pcf;
			
				op_stat_write (media_access_delay, mac_delay);
				op_stat_write (global_mac_delay_handle, mac_delay);
				}
			
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", frame_type);
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Accept", OPC_TRUE);
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Data Packet ID", (double) (OpT_Int64) pcf_pkt_in_service);
				
			/* Set the frame control field.				*/
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Wlan Header", pk_dhstruct_ptr,	
			wlan_mac_pk_dhstruct_copy, wlan_mac_pk_dhstruct_destroy, sizeof (WlanT_Data_Header_Fields));

			/* The actual data is placed in the Frame Body field	*/
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Frame Body", seg_pkptr);

			/* Make copy of the frame before transmission	*/
			wlan_pcf_transmit_frame_copy_ptr = op_pk_copy (wlan_transmit_frame_ptr);
			}
		else
			{
			/* If it is a retransmission then just transmit the previous frame	*/			
			wlan_transmit_frame_ptr = op_pk_copy (wlan_pcf_transmit_frame_copy_ptr);
			
			/* Modifications for LR WPAN model, by Olivier	*/
			if (INTRPT_STATUS_DEBUG)
				printf ("%s MAC layer: %.15f s: retransmission.\n", wlan_name, op_sim_time ());
			/************  end of modifications  ************/

			/* If retry count is non-zero means that the frame is a */
			/* retransmission of the last transmitted frame			*/
			op_pk_nfd_access (wlan_transmit_frame_ptr, "Wlan Header", &pk_dhstruct_ptr);
			pk_dhstruct_ptr->retry = 1;

			/* Reset header type in case Ack status has changed for frame */
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", frame_type);
			
			/* read back duration field for debug stuff */
			duration =	pk_dhstruct_ptr->duration;

			/* Printing out information to ODB.	*/
			if (wlan_trace_active == OPC_TRUE)
				{
				sprintf (msg_string, "Data fragment %d for packet " SIMC_PK_ID_FMT " is retransmitted", 
						pk_dhstruct_ptr->fragment_number, pcf_pkt_in_service);							
				op_prg_odb_print_major (msg_string, OPC_NIL);
				}					
			}
			
		/* Update the data traffic sent statistics.						*/
		total_pk_size = (double) op_pk_total_size_get (wlan_transmit_frame_ptr);
		op_stat_write (data_traffic_sent_handle_inbits, total_pk_size);
		op_stat_write (data_traffic_sent_handle, 1.0);

		/* Write a value of 0 for the end of transmission.				*/
		tx_end_time = current_time + total_pk_size / operational_speed;
		op_stat_write_t (data_traffic_sent_handle_inbits, 0.0, tx_end_time);
		op_stat_write_t (data_traffic_sent_handle, 0.0, tx_end_time);

		/* Only expect Acknowledgement for directed frames.				*/
		if (destination_addr < 0)
			expected_frame_type = WlanC_None;
		else
			/* ACK frame is expected in response to data frame.			*/
			expected_frame_type = WlanC_Ack;
		
		/* Reset the "frame to respond" variable since we have piggy-	*/
		/* backed an ACK to our message if we had to send one.			*/
		fresp_to_send = WlanC_None;
		}
	
	else if	(frame_type == WlanC_Ack)			
		{	
		if ((pcf_flag == OPC_BOOLINT_ENABLED) || (wlan_flags->pcf_active == OPC_TRUE))
			last_frametx_type = (WlanT_Mac_Frame_Type) frame_type;
				
		/* Preparing acknowledgement frame in response to the data frame	*/
		/* received from the remote stations.								*/
			
		/* Creating ACK packet format type.									*/
		wlan_transmit_frame_ptr = op_pk_create_fmt ("wlan_control");

		/* Adjust the packet size if necessary to model the PLCP overhead	*/
		/* accurately, which is physical layer technology dependent. The	*/
		/* default value is set for infra-red technology.					*/
		if (phy_char_flag != WlanC_Infra_Red)
			op_pk_bulk_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (plcp_overhead_control * WLAN_MAN_DATA_RATE - WLAN_DEFAULT_PLCP_OVERHEAD));

		/* Setting ack frame fields.										*/
		pk_chstruct_ptr = wlan_mac_pk_chstruct_create ();
   		
		type = WlanC_Ack;   		
		pk_chstruct_ptr->retry = duplicate_entry;

		/* If there are more fragments to transmit then broadcast the remaining duration for which	*/
		/* the station will be using the channel.													*/
		if ((wlan_flags->duration_zero == OPC_FALSE) || (pcf_flag == OPC_BOOLINT_DISABLED))
			duration = nav_duration - (current_time + plcp_overhead_control + WLAN_ACK_DURATION);
		else 
			duration = 0;
		
		pk_chstruct_ptr->duration = duration;

		/* Destination station address.	*/
		pk_chstruct_ptr->rx_addr = remote_sta_addr;

		/* Setting Ack type.	*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", type);
			
		/* Setting the accept field to true, meaning the frame is a good frame.	*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Accept", OPC_TRUE);

		op_pk_nfd_set (wlan_transmit_frame_ptr, "Wlan Header", pk_chstruct_ptr, wlan_mac_pk_chstruct_copy, 
					   wlan_mac_pk_chstruct_destroy, sizeof (WlanT_Control_Header_Fields));

		/* since no frame is expected, the expected frame type field */
		/* to nil.                                                   */
		expected_frame_type = WlanC_None;	
	
		/* Once Ack is transmitted in response to Data frame then set the frame		*/
		/* response indicator to none frame as the response is already generated	*/
		fresp_to_send = WlanC_None;			

		/* Printing out information to ODB.	*/
		if (wlan_trace_active == OPC_TRUE)
			{
			op_prg_odb_print_major ("Ack is being transmitted for data packet received", OPC_NIL);
			}

		/* Update the control traffic sent statistics.					*/
		total_pk_size = (double) op_pk_total_size_get (wlan_transmit_frame_ptr);
		op_stat_write (ctrl_traffic_sent_handle_inbits, total_pk_size);
		op_stat_write (ctrl_traffic_sent_handle, 		1.0);

		/* Write a value of 0 for the end of transmission.				*/
		tx_end_time = current_time + total_pk_size / WLAN_MAN_DATA_RATE;
		op_stat_write_t (ctrl_traffic_sent_handle_inbits, 0.0, tx_end_time);
		op_stat_write_t (ctrl_traffic_sent_handle, 		  0.0, tx_end_time);
		}
	
	else if (frame_type == WlanC_Rts)
		{		
		last_frametx_type = (WlanT_Mac_Frame_Type) frame_type;
		
		/* Creating Rts packet format type.									*/
		wlan_transmit_frame_ptr = op_pk_create_fmt ("wlan_control");

		/* Initializing RTS frame fields.									*/
		pk_chstruct_ptr = wlan_mac_pk_chstruct_create ();
		
		/* Type of frame */
	   	type = WlanC_Rts;   						

		/* if in the infrastructure BSS network then the immediate recipient for the transmitting	*/
		/* station will always be an Access point. Otherwise the frame is directly sent to the 		*/
		/* final destination.																		*/
    	if ((bss_flag == OPC_TRUE) && (ap_flag == OPC_BOOLINT_DISABLED))
			{
			/* If Infrastructure BSS then the immediate destination will be Access point, which 	*/
			/* then forward the frame to the appropriate destination.								*/
			pk_chstruct_ptr->rx_addr = ap_mac_address;
			}
		else
			{
			/* Otherwise set the final destination address.	*/				   
			pk_chstruct_ptr->rx_addr = destination_addr;
			}

		/* Source station address.	*/
		pk_chstruct_ptr->tx_addr = my_address;

		/* Setting the Rts frame type.	*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", type);

		/* Setting the accept field to true, meaning the frame is a good frame.	*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Accept", OPC_TRUE);
				
		/* Setting the variable which keeps track of the last transmitted frame that needs response.	*/
		last_frametx_type = (WlanT_Mac_Frame_Type)type;
					
		/* Determining the size of the first data fragment or frame that need */
		/* to be transmitted following the Rts transmission.				  */				
		if (num_fragments > 1)
			{
			/* If there are more than one fragment to transmit then the */
			/* data segment of the first data frame will be the size of */
			/* fragmentation threshold. The total packet size will be   */
			/* data plus the overhead (which is 224 bits).				*/
			tx_datapacket_size = frag_threshold * 8 + WLANC_MSDU_HEADER_SIZE;
			}
		else
			/* If there is one data frame to transmit then the          */
			/* data segment of the first data frame will be the size of */
			/* the remainder computed earlier. The total packet size    */
			/* will be data plus the overhead (which is 224 bits).		*/
			{
			tx_datapacket_size = remainder_size + WLANC_MSDU_HEADER_SIZE;
			}

		/* Station is reserving channel bandwidth by using RTS frame, so    */
		/* in RTS the station will broadcast the duration it needs to send  */ 		 		
		/* one data frame and receive ACK for it. The total duration is the */
		/* the time required to transmit one data frame, plus one CTS frame */
		/* plus one ACK frame, and plus three SIFS intervals.				*/
		duration = WLAN_CTS_DURATION + WLAN_ACK_DURATION + ((double) tx_datapacket_size / operational_speed) + 
				   3 * sifs_time + 2 * plcp_overhead_control + plcp_overhead_data;            
		pk_chstruct_ptr->duration = duration;
				
		/* Setting RTS frame fields.										*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Wlan Header", pk_chstruct_ptr, wlan_mac_pk_chstruct_copy, wlan_mac_pk_chstruct_destroy, sizeof (WlanT_Control_Header_Fields));				
				
		/* Adjust the packet size to accurately model the RTS message and	*/
		/* the PLCP overhead, which is physical layer technology dependent.	*/
		/* The default value for PLCP overhead is set for infra-red			*/
		/* technology.														*/
		if (phy_char_flag != WlanC_Infra_Red)
			op_pk_total_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (plcp_overhead_control * WLAN_MAN_DATA_RATE + WLAN_RTS_LENGTH));
		else
			op_pk_total_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (WLAN_DEFAULT_PLCP_OVERHEAD + WLAN_RTS_LENGTH));
		
		/* Station update of its own nav_duration	*/
		if (cfp_ap_medium_control == OPC_FALSE)
			nav_duration = current_time + duration + (double) (op_pk_total_size_get (wlan_transmit_frame_ptr)) / WLAN_MAN_DATA_RATE; 								 						
			
		/* CTS is expected in response to RTS.	*/						
		expected_frame_type = WlanC_Cts;

		/* Printing out information to ODB.	*/
		if (wlan_trace_active == OPC_TRUE)
			{
			sprintf (msg_string, "Rts is being transmitted for data packet " SIMC_PK_ID_FMT, pkt_in_service);
			op_prg_odb_print_major (msg_string, OPC_NIL);
			}

		/* Update the control traffic sent statistics.					*/
		total_pk_size = (double) op_pk_total_size_get (wlan_transmit_frame_ptr);
		op_stat_write (ctrl_traffic_sent_handle_inbits, total_pk_size);
		op_stat_write (ctrl_traffic_sent_handle, 		1.0);

		/* Write a value of 0 for the end of transmission.				*/
		tx_end_time = current_time + total_pk_size / WLAN_MAN_DATA_RATE;
		op_stat_write_t (ctrl_traffic_sent_handle_inbits, 0.0, tx_end_time);
		op_stat_write_t (ctrl_traffic_sent_handle, 		  0.0, tx_end_time);
		}
	
	else if (frame_type == WlanC_Cts)
		{
		if ((pcf_flag == OPC_BOOLINT_ENABLED) || (wlan_flags->pcf_active == OPC_TRUE))
			last_frametx_type = (WlanT_Mac_Frame_Type) frame_type;
				
		/** Preparing CTS frame in response to the received Rts frame.		*/
			
		/* Creating Cts packet format type.									*/
		wlan_transmit_frame_ptr = op_pk_create_fmt ("wlan_control");

		/* Adjust the packet size if necessary to model the PLCP overhead	*/
		/* accurately, which is physical layer technology dependent. The	*/
		/* default value is set for infra-red technology.					*/
		if (phy_char_flag != WlanC_Infra_Red)
			op_pk_bulk_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (plcp_overhead_control * WLAN_MAN_DATA_RATE - WLAN_DEFAULT_PLCP_OVERHEAD));

		/* Initializing Rts frame fields.									*/
		pk_chstruct_ptr = wlan_mac_pk_chstruct_create ();
		
		/* Type of frame.													*/
   		type = WlanC_Cts;

		/* Destination station address.										*/
		pk_chstruct_ptr->rx_addr = remote_sta_addr;
			
		/* Station is reserving channel bandwidth by using RTS frame, so    */
		/* in RTS the station will broadcast the duration it needs to send  */ 		 		
		/* one data frame and receive ACK for it. Just subtract the			*/
		/* transmission of the CTS frame from updated NAV. Already waited	*/
		/* SIFS is subtracted within "current_time".						*/
		duration = nav_duration - (plcp_overhead_control + WLAN_CTS_DURATION + current_time);
		pk_chstruct_ptr->duration = duration;

		/* Setting Cts frame type.	*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", type);

		/* Setting the accept field to true, meaning the frame is a good frame.	*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Accept", OPC_TRUE);
				
		/* Setting Cts frame fields.	*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Wlan Header", pk_chstruct_ptr, wlan_mac_pk_chstruct_copy, 
					   wlan_mac_pk_chstruct_destroy, sizeof (WlanT_Control_Header_Fields));

		/* Once Cts is transmitted in response to Rts then set the frame    		*/
		/* response indicator to none frame as the response is already generated	*/
		fresp_to_send = WlanC_None;										
			
		/* No frame is expected once Cts is transmitted	*/
		expected_frame_type = WlanC_None;	

		/* Printing out information to ODB.	*/
		if (wlan_trace_active == OPC_TRUE)
			{
			op_prg_odb_print_major ("Cts is being transmitted in response to Rts", OPC_NIL);
			}

		/* Update the control traffic sent statistics.					*/
		total_pk_size = (double) op_pk_total_size_get (wlan_transmit_frame_ptr);
		op_stat_write (ctrl_traffic_sent_handle_inbits, total_pk_size);
		op_stat_write (ctrl_traffic_sent_handle, 		1.0);

		/* Write a value of 0 for the end of transmission.				*/
		tx_end_time = current_time + total_pk_size / WLAN_MAN_DATA_RATE;
		op_stat_write_t (ctrl_traffic_sent_handle_inbits, 0.0, tx_end_time);
		op_stat_write_t (ctrl_traffic_sent_handle, 		  0.0, tx_end_time);
		}
	
	else if (frame_type == WlanC_Beac)
		{			
		last_frametx_type = (WlanT_Mac_Frame_Type) frame_type;

		/* Create packet container for beacon body */
		seg_pkptr = op_pk_create_fmt ("wlan_beacon_body");

		/* Create beacon body */
		pk_bbstruct_ptr = wlan_mac_pk_bbstruct_create ();

		/* Timestamp should be set to reference 1st bit of timestamp in message at antenna (11.1.2.1) */
		/* To reduce processing, it is currently set for first bit of MAC frame at antenna  */
		/* (assuming no PHY delay) */
		pk_bbstruct_ptr->timestamp  = current_time;
		pk_bbstruct_ptr->beacon_intv = beacon_int;
		
		/* if no PCF, No beacon starts a CFP */ 
		if (pcf_flag == OPC_BOOLINT_DISABLED || poll_list_size == 0)           
			{
			pk_bbstruct_ptr->cf_par.cfp_count = 1;   

			pk_bbstruct_ptr->cf_par.cfp_period = 0;    

			pk_bbstruct_ptr->cf_par.cfp_maxduration	= 0.0; 
			
			pk_bbstruct_ptr->cf_par.cfp_durremaining = 0.0;
			}
		else											
			/* PCF implemented */
			{
			/* Set flag to indicate that this beacon transmission will initiate */
			/* a contention free period */
			wlan_flags->pcf_active = OPC_TRUE;

			pk_bbstruct_ptr->cf_par.cfp_count = 
				(((int) (current_time/beacon_int)+ cfp_offset) % cfp_prd);    	
			
			/* set CFP period */
			pk_bbstruct_ptr->cf_par.cfp_period 	= cfp_prd;   	
			
			/* Set CFP maximum duration*/
			pk_bbstruct_ptr->cf_par.cfp_maxduration	 = cfp_length;	

			/* if beginning a cfp */
			if (pk_bbstruct_ptr->cf_par.cfp_count == 0)           	
				{ 							
				/* Find time remaining in current cfp */
				pk_bbstruct_ptr->cf_par.cfp_durremaining = 
					cfp_length - (current_time -((int) (current_time/beacon_int))*beacon_int); 
				}
			else 
				pk_bbstruct_ptr->cf_par.cfp_durremaining = 0;    /* No CFP so no time remaining */
			}
		
		/* Use data frame format for beacon frame since need frame body.	*/

		/* Creating transmit data packet type.								*/
		wlan_transmit_frame_ptr = op_pk_create_fmt ("wlan_mac");
		
		/* Adjust the packet size if necessary to model the PLCP overhead	*/
		/* accurately, which is physical layer technology dependent. The	*/
		/* default value is set for infra-red technology.					*/
		if (phy_char_flag != WlanC_Infra_Red)
			op_pk_bulk_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (plcp_overhead_control * WLAN_MAN_DATA_RATE - WLAN_DEFAULT_PLCP_OVERHEAD));
		
		/* Set destination address to broadcast since unicast not supported.*/
		destination_addr = -1;

		/* Prepare data frame fields for transmission.	*/		
		pk_dhstruct_ptr = wlan_mac_pk_dhstruct_create ();

		pk_dhstruct_ptr->retry = 0;				
		pk_dhstruct_ptr->order = 1;
		pk_dhstruct_ptr->sequence_number = packet_seq_number;

		/* During CFP the duration field should read 32768. (Section 7.1.3.2 of spec) */
		/* During CP should read zero since broadcast (Section 7.2.3)  */
		if (pk_bbstruct_ptr->cf_par.cfp_count == 0)	
			duration = 32768.0;
		else 
			duration = 0.0;
				
		/* Setting the Header field structure.	*/
		pk_dhstruct_ptr->duration  = duration;
		pk_dhstruct_ptr->address1  = destination_addr; /* Always set for broadcast for now */
		pk_dhstruct_ptr->address2  = my_address;
		
		/* This value is checked at the receiving end to see if this frame was intended for this bss id */
		pk_dhstruct_ptr->address3  = bss_id;

		/* Management frames (Beacon) never involve DS.	*/
		pk_dhstruct_ptr->fromds	 = 0;
		pk_dhstruct_ptr->tods    = 0;
	
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", frame_type);
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Accept", OPC_TRUE);

		/* Data Packet in service not really meaningful for beacon so set to -1 */
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Data Packet ID", -1);
				
		/* Set the frame control field.				*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Wlan Header", pk_dhstruct_ptr,	
		wlan_mac_pk_dhstruct_copy, wlan_mac_pk_dhstruct_destroy, sizeof (WlanT_Data_Header_Fields));

		/* If this is the start of the CFP, reset the NAV 				*/
		/* Any frame sequences in progress will be interrupted anyway.	*/
		if(pk_bbstruct_ptr->cf_par.cfp_count == 0)
			nav_duration = current_time;
		
		/* The beacon body is placed in the Packet container	*/
		op_pk_nfd_set (seg_pkptr, "Beacon Body", pk_bbstruct_ptr,	
		wlan_mac_pk_bbstruct_copy, wlan_mac_pk_bbstruct_destroy, sizeof (WlanT_Beacon_Body_Fields));

		/* The beacon body "packet" is placed in the Frame Body field	*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Frame Body", seg_pkptr);
	
		/* Clear expected frame time since any existing valid frame sequences have been interrupted anyway.	*/
		expected_frame_type = WlanC_None;

		/* Printing out information to ODB.	*/
		if (wlan_trace_active == OPC_TRUE)
			{
			op_prg_odb_print_major ("Beacon is being transmitted by the Access Point.", OPC_NIL);
			}
		
		/* Update the control traffic sent statistics.					*/
		total_pk_size = (double) op_pk_total_size_get (wlan_transmit_frame_ptr);
		op_stat_write (ctrl_traffic_sent_handle_inbits, total_pk_size);
		op_stat_write (ctrl_traffic_sent_handle, 		1.0);

		/* Write a value of 0 for the end of transmission.				*/
		tx_end_time = current_time + total_pk_size / WLAN_MAN_DATA_RATE;
		op_stat_write_t (ctrl_traffic_sent_handle_inbits, 0.0, tx_end_time);
		op_stat_write_t (ctrl_traffic_sent_handle, 		  0.0, tx_end_time);

		/* This Beacon frame we are sending may have paused the transmission	*/
		/* process of a regular frame. As a further case, it may have blocked	*/
		/* the "re-transmission" of this regular frame. If this is the			*/
		/* situation, then adjust the upper bound of contention window, so that	*/
		/* we don't increase it even further as a result of this Beacon's		*/
		/* transmission for the re-transmission of the regular packet.			*/
		if (retry_count != 0)
			max_backoff = (cw_min) / 2;
		
		/* Clear tx beacon flag.												*/
		wlan_flags->tx_beacon = OPC_FALSE;
		}

	/* Check if the frame type to be transmitted is a data null/cf acf/cf poll */
	else if ((frame_type == WlanC_Data_Null)|| (frame_type == WlanC_Cf_Ack)	|| 
			(frame_type == WlanC_Cf_Poll)	|| (frame_type == WlanC_Cf_A_P))
		{			
		/* Preserve the frame being transmitted */
		last_frametx_type = (WlanT_Mac_Frame_Type) frame_type;
		
		/* Adjust the transmission data rate based on the operational speed.*/
		tx_data_rate = operational_speed;

		/* Set active poll flag if this is a poll frame */
		if ((frame_type == WlanC_Cf_Poll) || (frame_type == WlanC_Cf_A_P))
			{
			wlan_flags->active_poll = OPC_TRUE;
			}
		
		/* If it is a retransmission of a packet then no need 	*/
     	/* of preparing data frame.				*/
		if	(((frame_type == WlanC_Data_Null) || (frame_type == WlanC_Cf_Ack)) || 
			((pcf_retry_count == 0) && (poll_fail_count == 0)))
			{
			/* Creating transmit data packet type.							*/
			wlan_transmit_frame_ptr = op_pk_create_fmt ("wlan_mac");
				
			/* Add some bulk to the packet to model the transmission delay	*/
			/* of PLCP fields accurately which are always transmitted at	*/
			/* 1 Mbps regardless of the actual data rate used for data		*/
			/* frames.														*/
			op_pk_bulk_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (plcp_overhead_data * operational_speed - WLAN_DEFAULT_PLCP_OVERHEAD));
		
			/* Prepare data frame fields for transmission.					*/		
			pk_dhstruct_ptr = wlan_mac_pk_dhstruct_create ();

			pk_dhstruct_ptr->retry = 0;				
			pk_dhstruct_ptr->order = 1;
			pk_dhstruct_ptr->sequence_number = packet_seq_number;

			/* Set packet fragment fields  	*/
			pk_dhstruct_ptr->more_frag = 0;
			pk_dhstruct_ptr->fragment_number = 0;

			/* Set duration field */
			/* During PCF the duration field should read 32768. (Section 7.1.3.2 of spec) */
			duration = 32768.0;

			/* Setting the Header field structure.	*/
			pk_dhstruct_ptr->duration  = duration;
			pk_dhstruct_ptr->address1  = destination_addr;
			pk_dhstruct_ptr->address2  = my_address;

			/* In the BSS network the Data frame is going from AP to sta then fromds bit is set.	*/
    		if (ap_flag == OPC_BOOLINT_ENABLED)
				{
				pk_dhstruct_ptr->fromds	 = 1;
				}
			else
				{
				pk_dhstruct_ptr->fromds	 = 0;
				}

			/* if in the BSS network the Data frame is going from sta to AP then tods bit is set.	*/					
    		if ((bss_flag == OPC_TRUE) && (ap_flag == OPC_BOOLINT_DISABLED))
				{
				pk_dhstruct_ptr->tods = 1;

				/* If Infrastructure BSS then the immediate destination will be Access point, which 	*/
				/* then forward the frame to the appropriate destination.								*/
				pk_dhstruct_ptr->address1 = ap_mac_address;
				pk_dhstruct_ptr->address3 = destination_addr;
				}
			else
				{
				pk_dhstruct_ptr->tods = 0;
				}
	
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", frame_type);
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Accept", OPC_TRUE);
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Data Packet ID", (double) (OpT_Int64) pcf_pkt_in_service);
				
			/* Set the frame control field.				*/
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Wlan Header", pk_dhstruct_ptr,	
			wlan_mac_pk_dhstruct_copy, wlan_mac_pk_dhstruct_destroy, sizeof (WlanT_Data_Header_Fields));

			/* Need to create dummy "Frame Body" so use beacon frame and	*/
			/* set size to zero. Create packet container for beacon body.	*/
			seg_pkptr = op_pk_create_fmt ("wlan_beacon_body");
			op_pk_total_size_set (seg_pkptr, (OpT_Packet_Size) (0));

			/* The actual data is placed in the Frame Body field.			*/
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Frame Body", seg_pkptr);

			/* If enabled, print out an ODB trace message.					*/
			if (wlan_trace_active == OPC_TRUE)
				{
				if (frame_type == WlanC_Cf_Ack)
					op_prg_odb_print_major ("A CF-ACK message is being transmitted in reply to received poll+data message.", OPC_NIL);
				else if (frame_type == WlanC_Data_Null)
					op_prg_odb_print_major ("A Null (no data) message is being transmitted in reply to received poll message.", OPC_NIL);
				else
					{
					wlan_frame_type_conv (frame_type, frame_type_str);
					sprintf (msg_string, " A %s message is being transmitted by the Access Point.", frame_type_str);
					op_prg_odb_print_major (msg_string, OPC_NIL);
					}
				}
			
			/* Make copy of the frame before transmission	*/
			if ((frame_type != WlanC_Data_Null) && (frame_type != WlanC_Cf_Ack))
				{
				wlan_pcf_transmit_frame_copy_ptr = op_pk_copy (wlan_transmit_frame_ptr);
				}
			}
		else 
			{
			/* If it is a retransmission then just transmit the previous frame	*/			
			wlan_transmit_frame_ptr = op_pk_copy (wlan_pcf_transmit_frame_copy_ptr);
			
			/* Modifications for LR WPAN model, by Olivier	*/
			if (INTRPT_STATUS_DEBUG)
				printf ("%s MAC layer: %.15f s: retransmission.\n", wlan_name, op_sim_time ());
			/************  end of modifications  ************/

			/* If retry count is non-zero means that the frame is a 	*/
			/* retransmission of the last transmitted frame.			*/
			op_pk_nfd_access (wlan_transmit_frame_ptr, "Wlan Header", &pk_dhstruct_ptr);
			pk_dhstruct_ptr->retry = 1;

			/* Read back duration field for debug stuff.				*/
			duration =	pk_dhstruct_ptr->duration;
			
			/* Re-write the packet type since the poll message sent		*/
			/* earlier may have a piggy-backed ACK, which will not be	*/
			/* repeated in this retransmission.							*/
			op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", frame_type); 
			
			/* If enabled, print out an ODB trace message.				*/
			if (wlan_trace_active == OPC_TRUE)
				{
				wlan_frame_type_conv (frame_type, frame_type_str);
				sprintf (msg_string, "The Access Point is retransmitting a %s messsge.", frame_type_str);							
				op_prg_odb_print_major (msg_string, OPC_NIL);
				}
			}

		/* Update the control traffic sent statistics.					*/
		total_pk_size = (double) op_pk_total_size_get (wlan_transmit_frame_ptr);
		op_stat_write (ctrl_traffic_sent_handle_inbits, total_pk_size);
		op_stat_write (ctrl_traffic_sent_handle, 1.0);

		/* Write a value of 0 for the end of transmission.				*/
		tx_end_time = current_time + total_pk_size / operational_speed;
		op_stat_write_t (ctrl_traffic_sent_handle_inbits, 0.0, tx_end_time);
		op_stat_write_t (ctrl_traffic_sent_handle, 0.0, tx_end_time);

		/* No ACK expected for non-data poll frames but do expect some	*/
		/* type of Data frame in response.								*/
		if	((frame_type == WlanC_Cf_Poll)	|| (frame_type == WlanC_Cf_A_P))
			expected_frame_type = WlanC_Data;
		else
			expected_frame_type = WlanC_None;

		/* Once Ack is transmitted in response to Data frame then set	*/
		/* the frame response indicator to none frame as the response	*/
		/* is already generated.										*/
		fresp_to_send = WlanC_None;					
		}

	/* Preparing Contention Free end frame if no more stations */
	/* to poll or Cfp_End interrupt.						   */
	else if	((frame_type == WlanC_Cf_End) || (frame_type == WlanC_Cf_End_A))
		{
	   	if ((pcf_flag == OPC_BOOLINT_ENABLED) || (wlan_flags->pcf_active == OPC_TRUE))
			last_frametx_type = (WlanT_Mac_Frame_Type) frame_type;
			
		/* Creating Cf_End packet format type.								*/
		wlan_transmit_frame_ptr = op_pk_create_fmt ("wlan_control");

		/* Adjust the packet size to model the Cf_End message and the PLCP	*/
		/* overhead, which is physical layer technology dependent,			*/
		/* accurately. The default value for PLCP overhead is set for		*/
		/* infra-red technology. Also note that the size of CF End message	*/
		/* is equal to the size of the RTS message.							*/
		if (phy_char_flag != WlanC_Infra_Red)
			op_pk_total_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (plcp_overhead_control * WLAN_MAN_DATA_RATE + WLAN_RTS_LENGTH));
		else
			op_pk_total_size_set (wlan_transmit_frame_ptr, (OpT_Packet_Size) (WLAN_DEFAULT_PLCP_OVERHEAD + WLAN_RTS_LENGTH));

		/* Setting ack frame fields.										*/
		pk_chstruct_ptr = wlan_mac_pk_chstruct_create ();

		/* Set duration field */
		/* CF_End duration should always read zero.(Section 7.2.1.6 of spec)*/
		duration = 0;
		pk_chstruct_ptr->duration = duration;

		/* CF End is a broadcast, so set destination address to -1.			*/
		pk_chstruct_ptr->rx_addr = -1;

		/* The tx address conveys our own BSS ID in the CF-End messages.	*/
		pk_chstruct_ptr->tx_addr = bss_id;

		/* Setting frame type.												*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Type", frame_type);
			
		/* Setting the accept field to true, meaning the frame is a good frame.	*/
		op_pk_nfd_set (wlan_transmit_frame_ptr, "Accept", OPC_TRUE);

		op_pk_nfd_set (wlan_transmit_frame_ptr, "Wlan Header", pk_chstruct_ptr, wlan_mac_pk_chstruct_copy, 
					   wlan_mac_pk_chstruct_destroy, sizeof (WlanT_Control_Header_Fields));

		/* since no frame is expected, the expected frame type field */
		/* to nil.                                                   */
		expected_frame_type = WlanC_None;	
	
		/* No response is expected so set indicator accordingly		*/
		fresp_to_send = WlanC_None;			

		/* Printing out information to ODB.	*/
		if (wlan_trace_active == OPC_TRUE)
			{
			if (frame_type == WlanC_Cf_End_A)
				op_prg_odb_print_major ("A CF-End+ACK is being transmitted by the Access Point.", OPC_NIL);
			else
				op_prg_odb_print_major ("A CF-End is being transmitted by the Access Point.", OPC_NIL);
			}

		/* Since CFP over, clean up indicators */
		if ((op_ev_valid (cfp_end_evh) == OPC_TRUE) && (wlan_flags->tx_cf_end == OPC_FALSE))
			{op_ev_cancel (cfp_end_evh);}

		/* Check if a PCF beacon has been overrun before clearing pcf_active flag */
		if ((wlan_flags->tx_beacon == OPC_TRUE) && 
			((((int) (current_time/beacon_int) +cfp_offset) % cfp_prd) == 0))
			{
			/* PCF beacon has been overrun so don't clear flag */
			}
		else 
			{
			wlan_flags->pcf_active = OPC_FALSE;
			}

		wlan_flags->tx_cf_end			= OPC_FALSE;
		wlan_flags->pcf_side_traf		= OPC_FALSE;
		wlan_flags->active_poll			= OPC_FALSE;
		wlan_flags->more_data			= OPC_FALSE;
		poll_fail_count = 0;

		/* Update the control traffic sent statistics.					*/
		total_pk_size = (double) op_pk_total_size_get (wlan_transmit_frame_ptr);
		op_stat_write (ctrl_traffic_sent_handle_inbits, total_pk_size);
		op_stat_write (ctrl_traffic_sent_handle, 		1.0);

		/* Write a value of 0 for the end of transmission.				*/
		tx_end_time = current_time + total_pk_size / WLAN_MAN_DATA_RATE;
		op_stat_write_t (ctrl_traffic_sent_handle_inbits, 0.0, tx_end_time);
		op_stat_write_t (ctrl_traffic_sent_handle, 		  0.0, tx_end_time);
		}
	else
		{
		wlan_mac_error ("Transmission request for unexpected frame type.", OPC_NIL, OPC_NIL);
		}
			
	
	/* Place the transmission data rate information into the packet.		*/
	op_pk_nfd_set (wlan_transmit_frame_ptr, "Tx Data Rate", tx_data_rate);
	
	/* Modifications for LR WPAN model, by Olivier	*/
	if (INTRPT_STATUS_DEBUG)
		printf ("%s MAC layer: %.15f s: packet * id %d * %d bits * %.0f bits/s\n", wlan_name, op_sim_time (), (int) op_pk_id (wlan_transmit_frame_ptr),
			(int) op_pk_total_size_get (wlan_transmit_frame_ptr), tx_data_rate);
	/************  end of modifications  ************/
	
	/* Send packet to the transmitter.										*/
	op_pk_send (wlan_transmit_frame_ptr, LOW_LAYER_OUTPUT_STREAM);	
	wlan_flags->transmitter_busy = OPC_TRUE;
	
	/* Clear ignore busy flag in case it was set.							*/
	wlan_flags->ignore_busy = OPC_FALSE;
	
	/* Clear PCF side traffic flag in case it was set.						*/
	wlan_flags->pcf_side_traf = OPC_FALSE;
	
	/* Clear polled flag in case it was set.								*/
	wlan_flags->polled = OPC_FALSE;
	
	FOUT;
	}

static void 
wlan_interrupts_process (void)
	{
	/** This routine handles the appropriate processing need for each type 	**/
	/** of remote interrupt. The type of interrupts are: stream interrupts	**/
	/** (from lower and higher layers), stat interrupts (from receiver and 	**/
	/** transmitter).      													**/
	char my_name[256];
	
	FIN (wlan_interrupts_process (void));

	op_ima_obj_attr_get (my_node_objid, "name", &my_name);
	/* Modifications for LR WPAN model, by Olivier	*/
	if (op_intrpt_type () == OPC_INTRPT_ENDSIM)
		{
		/* print a message at the end */
		printf ("%s:\tNb of packet received: %d\n", wlan_name, wlan_stat_custom.packet_rcvd);
		printf ("\t\tNb of packet lost: %d\n", wlan_stat_custom.lost_packet);
		printf ("\t\tNb of packet collided: %d\n", wlan_stat_custom.collided_packet);
		printf ("\t\tNb of bad packets: %d\n", wlan_stat_custom.bad_packet);
		
		/* write the statistics in a file */
		wlan_mac_collect_stat (wlan_stat_custom, wlan_name);
		}
	
	/* print debug message */
	if (INTRPT_STATUS_DEBUG) wlan_print_state_debug ();
	if (wlan_state_debug) printf ("%s MAC layer: %.15f s: exit \"%s\" state\n", wlan_name, op_sim_time (), current_state_name);

	/* Check if debugging is enabled. */
	wlan_state_debug = op_prg_odb_ltrace_active ("state_wlan");
	/************  end of modifications  ************/
	
	/* Check if debugging is enabled.										*/
	wlan_trace_active = op_prg_odb_ltrace_active ("wlan");

	/* Determine the current simulation time.								*/	
	current_time = op_sim_time ();
	
	/* Determine interrupt type and code to divide treatment along the		*/
	/* lines of interrupt type.						  						*/
	intrpt_type = op_intrpt_type ();
	intrpt_code = (WlanT_Mac_Intrpt_Code) op_intrpt_code ();

	/* Stream interrupts are either arrivals from the higher layer, or		*/
	/* from the physical layer.												*/
	if (intrpt_type == OPC_INTRPT_STRM)
		{
		/* Determine the stream on which the arrival occurred.				*/
		i_strm = op_intrpt_strm ();

		/* If the event arrived from higher layer then queue the packet	and	*/
		/* the destination address.											*/
		if (i_strm == instrm_from_mac_if)
			{
			/* Process stream interrupt received from higher layer.	*/
			//printf ("%s MAC layer: %.15f s: exit \"%s\" state\n", wlan_name, op_sim_time (), current_state_name);
			wlan_higher_layer_data_arrival ();
			}

		/* If the event was an arrival from the physical layer,	*/
		/* accept the packet and decapsulate it			 		*/
		else 
			{
			/* Process stream interrupt received from physical layer	*/	
			wlan_physical_layer_data_arrival ();		
   			}
	 	}	

	/* Handle stat interrupt received from the receiver	*/
	else if (intrpt_type == OPC_INTRPT_STAT)
		{
		/* Make sure it is not a stat interrupt from the transmitter.	*/
		if (intrpt_code < TRANSMITTER_BUSY_INSTAT)
			{
			
			//printf("before stat intrpt MEDIUM IS IDLE %d\n", MEDIUM_IS_IDLE);
			//printf(" REAd to transmit %d\n", READY_TO_TRANSMIT);
			//printf("current_time %s %.15f\n", my_name, current_time);
			//printf(" first parameter %.15f compare to %f\n", current_time - nav_duration + PRECISION_RECOVERY, difs_time);
			//printf(" second parameter %d receiver busy\n", wlan_flags->receiver_busy);
			//printf(" third parameter %.15f compare to %f\n", current_time - rcv_idle_time + PRECISION_RECOVERY, difs_time);
			//printf(" fourth parameter %d\n", wlan_flags->pcf_active);
			//printf(" fith parameter %d\n",  wlan_flags->forced_bk_end);
			
			/* One of receiver channels is changing its status.		*/
			/* Update the channel status flag.	   					*/
			wlan_mac_rcv_channel_status_update (intrpt_code);
			/* If the channel is not busy anymore reset the receiver idle	*/
			/* timer to the current time.									*/
			if (!wlan_flags->receiver_busy)
				rcv_idle_time = current_time;
			
			//printf("after stat intrpt MEDIUM IS IDLE %d\n", MEDIUM_IS_IDLE);
			//printf(" first parameter %.15f compare to %f\n", current_time - nav_duration + PRECISION_RECOVERY, difs_time);
			//printf(" second parameter %d receiver busy\n", wlan_flags->receiver_busy);
			//printf(" third parameter %.15f compare to %f\n", current_time - rcv_idle_time + PRECISION_RECOVERY, difs_time);
			//printf(" fourth parameter %d\n", wlan_flags->pcf_active);
			//printf(" fith parameter %d\n",  wlan_flags->forced_bk_end);
			//printf(" REAd to transmit %d\n", READY_TO_TRANSMIT);
			
			}

		}

	/* Handle interrupt from Beacon timer */
	else if (intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanC_Beacon_Tx_Time)
		{
		/* If AP and time to transmit beacon then set the flag	  */
		if (ap_flag == OPC_BOOLINT_ENABLED) 
			{
			wlan_flags->tx_beacon = OPC_TRUE;

			/* Set timer for next beacon Tx.				*/
			beacon_evh = op_intrpt_schedule_self (current_time + beacon_int , WlanC_Beacon_Tx_Time);	
			}
		
		/* Make the initializations for CFP if the BSS has	*/
		/* at least one PCF enabled station and if we are	*/
		/* not already in CFP.								*/
		if (active_pc == OPC_TRUE && poll_list_size > 0 && wlan_flags->pcf_active == OPC_FALSE)
			{
			if ((((int) (current_time / beacon_int) + cfp_offset) % cfp_prd) == 0)
				{
				/* If this is an AP.						*/
				if (ap_flag == OPC_BOOLINT_ENABLED)
					{
					cfp_end_evh = op_intrpt_schedule_self (current_time + cfp_length , WlanC_Cfp_End);

					/* For current polling implementation, the fragmentation buffer is assumed	*/
					/* empty at the start of the CFP, and polling always starts with the first 	*/	
					/* station. This variable will be incremented for first station.  			*/
					poll_index = -1;

					/* Reset failed poll counter.			*/
					poll_fail_count = 0;

					/* Reset poll for more data flag.		*/
					wlan_flags->more_data = OPC_FALSE;
					
					/* Reset pcf queue offset.				*/
					pcf_queue_offset = 0;
					}
				else 
					{
					/* Update the NAV duration for a non-AP station */
					if (nav_duration < (cfp_length + current_time))
						{
						nav_duration = cfp_length + current_time;
						}
					}
				}
			} 
		}
	
	/* Handle interrupt from CFP end timer */
	else if (intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanC_Cfp_End)
		{
		/* Set Transmit Contention Free (CF) Period End flag */
		wlan_flags->tx_cf_end = OPC_TRUE;
		
		/* Don't clear CFP Flag till after transmitting CF End	  */
		/* Don't touch NAV - It should clear itself anyway */
		}

	if (roam_state_ptr->scan_type == WlanC_Scan_Type_Distance && current_time >= ap_connectivity_check_time)
		{
		/* In the "virtual" scanning mode, we check if the distance of this STA is greater   */
		/* than "start scanning" threshold. If so, we go to the scan mode, and look for a    */
		/* new AP. */
		ap_connectivity_check_time = current_time + ap_connectivity_check_interval;
		wlan_ap_eval_virtual ();
		}

	FOUT;
	}

static void 
wlan_physical_layer_data_arrival ()
	{
	char										msg_string [120];
	int											dest_addr;
	int											accept;
	int											final_dest_addr;
	double										data_pkt_id;
	WlanT_Data_Header_Fields*					pk_dhstruct_ptr;
	WlanT_Control_Header_Fields*				pk_chstruct_ptr;
	WlanT_Mac_Frame_Type						rcvd_frame_type;	
	Packet*										wlan_rcvd_frame_ptr;
	Packet*										seg_pkptr;
	WlanT_Beacon_Body_Fields*					pk_bbstruct_ptr;
	int											rcvd_sta_bssid;
	int											temp;
	int											temp2;
	Boolean										data_pkt_received = OPC_FALSE;
	double										tx_drate, rcvd_pk_size, rx_start_time;
	char										actual_frame_name [256];
	int											noise;
	
	/** Process the frame received from the lower layer.          **/
	/** This routine decapsulate the frame and set appropriate    **/
	/** flags if the station needs to generate a response to the  **/
	/** received frame.											  **/
	FIN (wlan_physical_layer_data_arrival ());

	/*  Access received packet from the physical layer stream.	*/
	wlan_rcvd_frame_ptr = op_pk_get (i_strm);	

	if (INTRPT_STATUS_DEBUG) 
		{
		printf (" packet id %d\n", (int) op_pk_id (wlan_rcvd_frame_ptr));
		op_pk_print (wlan_rcvd_frame_ptr);
		}
	/************  end of modifications  ************/
	
	op_pk_nfd_access (wlan_rcvd_frame_ptr, "Accept", &accept);
	op_pk_nfd_access (wlan_rcvd_frame_ptr, "Noise", &noise);	
	if(noise == 0)
		{
		/* Modifications for LR WPAN model, by Olivier	*/
		wlan_stat_custom.packet_rcvd ++;
		}
		
	/* Getting frame control field and duration information from	*/
    /* the received packet.											*/		
	op_pk_nfd_access (wlan_rcvd_frame_ptr, "Type", &rcvd_frame_type);
	
	/* If the packet is received while the station is in transmission,	*/
	/* or if the packet is collided with another packet received or if	*/
	/* the accept field is set to false, then the packet will not be	*/
	/* processed and if needed the station will retransmit the packet.	*/
	if ((wlan_flags->rcvd_bad_packet == OPC_TRUE) || (accept == OPC_FALSE) ||
		(wlan_flags->collided_packet == OPC_TRUE))
		{error ++;
		if(noise == 0)
			{
			/* Modifications for LR WPAN model, by Olivier	*/
			if (!accept) 
				{
				/* update the custom statistics */
				wlan_stat_custom.lost_packet ++;
				/* print a message */
				if (INTRPT_STATUS_DEBUG)
				printf (", the accept field is set to false\n");
				}
			else if (wlan_flags->rcvd_bad_packet) 
				{
				/* update the custom statistics */
				wlan_stat_custom.bad_packet ++;
				/* print a message */
				if (INTRPT_STATUS_DEBUG)
					printf (", packet is received while the station is in transmission\n");
				}
			else if (wlan_flags->collided_packet)
				{
				/* update the custom statistics */
				wlan_stat_custom.collided_packet ++;
				/* print a message */
				if (INTRPT_STATUS_DEBUG)
					printf (", packet is collided with another packet received\n");
				}
			
			}
		/* pause the simulation */
		//op_prg_odb_bkpt ("collision");
		/************  end of modifications  ************/
		
		/* If the pipeline stage set the accept flag to be false or if it is 		*/
		/* collided then it means that the packet is erroneous.  Enable the EIFS	*/
		/* duration flag and set nav duration to be EIFS duration.					*/ 	
		if (((accept == OPC_FALSE) || 
			(wlan_flags->collided_packet == OPC_TRUE)) && wlan_flags->pcf_active == OPC_FALSE)
			{
			wlan_flags->wait_eifs_dur = OPC_TRUE;
     
			/* Setting nav duration to EIFS.	*/
			if (cfp_ap_medium_control == OPC_FALSE)
				{
				nav_duration = current_time + eifs_time - difs_time; 
				}

			/* Reporting the amount of time the channel will be busy.	*/	   
			op_stat_write (channel_reserv_handle, (nav_duration - current_time));
			op_stat_write (channel_reserv_handle, 0.0);
			}
		
		/* Check if we were waiting for a poll response and increment poll fail accordingly */
		if	(((last_frametx_type == WlanC_Data_Poll)	||	(last_frametx_type == WlanC_Data_A_P)	||
			(last_frametx_type == WlanC_Cf_Poll)		||	(last_frametx_type == WlanC_Cf_A_P))	&&
			(wlan_flags->active_poll == OPC_TRUE))
			{
			/* Poll failed.  Increment Failed Poll counter */
			poll_fail_count++;
			wlan_flags->active_poll = OPC_FALSE;
			}
		
		/* We may have experienced a collision during transmission. We	*/
		/* could be transmitting a packet which requires a response (an	*/
		/* Rts or a data frame requiring an Ack). Even, this is the		*/
		/* case, we do not take any action right now and wait for the	*/
		/* related timers to expire; then we will retransmit the frame.	*/
		/* This is the approach described in the standard, and it is	*/
		/* necessary because of the slight possibility that our peer	*/
		/* may receive the frame without collision and send us the		*/
		/* response back, which we should be still expecting.			*/

		/* Check whether the timer for the expected response has		*/
		/* already expired. If yes, we must initiate the retransmission.*/
		if ((expected_frame_type != WlanC_None) && (wlan_flags->transmitter_busy == OPC_FALSE) &&
			(op_ev_valid (frame_timeout_evh) == OPC_FALSE))
			{		
			if ((last_frametx_type == WlanC_Data) || (last_frametx_type == WlanC_Data_Ack))
				{
				retry_count = retry_count + 1;

				/* Check if more retrys permitted, if not discard */
				wlan_frame_discard ();
				}
			else
				{
				/* If last frame a data frame, Increment retry counter */
				if ((last_frametx_type == WlanC_Data_Poll)	||	(last_frametx_type == WlanC_Data_A_P))
					{
					pcf_retry_count++;
					}

				/* Check if more retrys permitted, if not discard */
				wlan_pcf_frame_discard ();
				}

			/* If Rts sent flag was enable then disable it as the station will recontend for the channel.	*/
			if (wlan_flags->rts_sent == OPC_TRUE)
				{
				wlan_flags->rts_sent = OPC_FALSE;
				}

			/* Set expected frame type flag to none as the		*/
			/* station needs to retransmit the frame.			*/
			expected_frame_type = WlanC_None;
			
			/* Reset the NAV duration so that the				*/
			/* retransmission is not unnecessarily delayed.		*/
			if (cfp_ap_medium_control == OPC_FALSE)
				nav_duration = current_time;
			}

		/* Reset the bad packet receive flag for subsequent		*/
		/* receptions.											*/
		wlan_flags->rcvd_bad_packet = OPC_FALSE;		

		/* Similarly reset the collided packet flag.			*/
		wlan_flags->collided_packet = OPC_FALSE;
			
		/* If the corrupted frame is a Beacon, update the		*/
		/* reliability of the signal from AP indicating that	*/
		/* the packet was not successfully received.			*/
		if (rcvd_frame_type == WlanC_Beac && roam_state_ptr->enable_roaming)
			wlan_ap_reliability_eval (wlan_rcvd_frame_ptr, OPC_FALSE, roam_state_ptr);

		/* Printing out information to ODB.						*/
		if (wlan_trace_active == OPC_TRUE)
			{
			op_prg_odb_print_major ("Received bad packet. Discarding received packet", OPC_NIL);
			}
		
		/* Destroy the bad packet.								*/
		op_pk_destroy (wlan_rcvd_frame_ptr);

		/* Break the routine as no further processing is needed.*/
		FOUT;
		}

	/* If waiting for EIFS duration then set the nav duration such that	*/
	/* the normal operation is resumed.									*/
	if (wlan_flags->wait_eifs_dur == OPC_TRUE)
		{
		if (cfp_ap_medium_control == OPC_FALSE)
			nav_duration = current_time;
		
		wlan_flags->wait_eifs_dur = OPC_FALSE;	
		}
	
	/* Compute the values that will be used while updating the received	*/
	/* traffic statistics.												*/
	op_pk_nfd_access (wlan_rcvd_frame_ptr, "Tx Data Rate", &tx_drate);
	rcvd_pk_size  = (double) op_pk_total_size_get (wlan_rcvd_frame_ptr);
	rx_start_time = current_time - rcvd_pk_size / tx_drate;
	
	if	((rcvd_frame_type == WlanC_Data)		|| (rcvd_frame_type == WlanC_Data_Ack)	|| 
		(rcvd_frame_type == WlanC_Data_Poll)	|| (rcvd_frame_type == WlanC_Data_A_P)	|| 
		(rcvd_frame_type == WlanC_Data_Null)	|| (rcvd_frame_type == WlanC_Cf_Ack)	|| 
		(rcvd_frame_type == WlanC_Cf_Poll)		|| (rcvd_frame_type == WlanC_Cf_A_P))
		{
		/* First check that whether the station is expecting	*/
		/* any frame or not. If not then decapsulate relevant 	*/
		/* information from the packet fields and set the frame	*/
		/* response variable with appropriate frame type.		*/
		if	((rcvd_frame_type == WlanC_Data)		|| (rcvd_frame_type == WlanC_Data_Ack)	|| 
			(rcvd_frame_type == WlanC_Data_Poll)	|| (rcvd_frame_type == WlanC_Data_A_P))
			{
			/* Update received data traffic statistics. Write the		*/
			/* appropriate values for start and end of the reception.	*/
			op_stat_write_t (data_traffic_rcvd_handle_inbits, rcvd_pk_size, rx_start_time);
			op_stat_write (data_traffic_rcvd_handle_inbits, 0.0);
			op_stat_write_t (data_traffic_rcvd_handle, 1.0, rx_start_time);
			op_stat_write (data_traffic_rcvd_handle, 0.0);
			
			/* Set the "data packet received" flag to be used later on.	*/
			data_pkt_received = OPC_TRUE;
			}
		else
			{
			/* Received frame is a control frame using data format, update control		*/
			/* statistics. Write the appropriate values for start and end of the		*/
			/* reception.																*/
			op_stat_write_t (ctrl_traffic_rcvd_handle_inbits, rcvd_pk_size, rx_start_time);
			op_stat_write (ctrl_traffic_rcvd_handle_inbits, 0.0);
			op_stat_write_t (ctrl_traffic_rcvd_handle, 1.0, rx_start_time);
			op_stat_write (ctrl_traffic_rcvd_handle, 0.0);
			}
		
		/* In case of Beacon colliding with other packets being received, the stations	*/
		/* will not be indicated on the PCF period. If this happens, and we receive a	*/
		/* poll packet, then we need to initialize variables that indicate the start of	*/
		/* PCF duration.							 	  								*/
		if ((cfp_ap_medium_control == OPC_FALSE) && 
			(rcvd_frame_type == WlanC_Data_Poll) || (rcvd_frame_type == WlanC_Data_A_P) ||
			(rcvd_frame_type == WlanC_Cf_Poll) || (rcvd_frame_type == WlanC_Cf_A_P))
			{
			/* Indicate the medium controlled by the active AP.							*/
			cfp_ap_medium_control =  OPC_TRUE;
			}
		
		/* Address information, sequence control fields,	*/
		/* and the data is extracted from the rcvd packet.	*/
		op_pk_nfd_access (wlan_rcvd_frame_ptr, "Wlan Header",	&pk_dhstruct_ptr);

		/* Data packet id of the received data frame is extracted.	*/
		op_pk_nfd_access (wlan_rcvd_frame_ptr, "Data Packet ID", &data_pkt_id);

		/* Obtain the destination this packet id addressed to */
		dest_addr = pk_dhstruct_ptr->address1;	
		remote_sta_addr = pk_dhstruct_ptr->address2;
		
		
		/* Check if PCF active and this is an AP */
		if ((wlan_flags->pcf_active == OPC_TRUE) && 
			(ap_flag == OPC_BOOLINT_ENABLED))
			{
			/* Check if frame is from station polled and increment failed poll count if necessary	*/
			if (remote_sta_addr == polling_list [poll_index]) 
				{
				poll_fail_count = 0;
				}
			else if (wlan_flags->active_poll == OPC_TRUE) 
				{
				poll_fail_count++;
				}
			
	
			/* Disable active poll flag since it is now satisfied one way or another */
			wlan_flags->active_poll = OPC_FALSE;
			
			if ((dest_addr != ap_mac_address)  && (dest_addr > -1))
				{
				/* If data not addressed to AP and not broadcast then set side	*/
				/* traffic flag and set NAV to wait for expected ack 			*/
				wlan_flags->pcf_side_traf = OPC_TRUE;
				
				if (nav_duration < (current_time + sifs_time + plcp_overhead_control + WLAN_ACK_DURATION)) 
					nav_duration = current_time + sifs_time + plcp_overhead_control + WLAN_ACK_DURATION;

				/* Set poll more fragments flag if necessary */
				if (pk_dhstruct_ptr->more_frag == 1) 
					wlan_flags->more_frag = OPC_TRUE;
				else 
					wlan_flags->more_frag = OPC_FALSE;

				/* Set poll more data (MSDU's) flag if necessary */
				if ((pk_dhstruct_ptr->more_data == 0)  || (wlan_flags->tx_beacon == OPC_TRUE) ||
					(wlan_flags->tx_cf_end == OPC_TRUE))
					{
					/* No more polls for new MDSU will be sent to this STA so reset flag		*/
					wlan_flags->more_data = OPC_FALSE;
					}
				else 
					{
					/* need to poll this STA at least one more time, so set flag				*/
					wlan_flags->more_data = OPC_TRUE;
					}
				}
			}
		
		/* If the station is an AP then it will need to forward the receiving data	*/ 
		/* to this address. Otherwise this field will be zero and will be ignored.	*/
		final_dest_addr = pk_dhstruct_ptr->address3;

		/* Process frame only if it is destined for this station.	*/
		/* or it is a broadcast frame.								*/
		if	(((dest_addr == my_address) || (dest_addr < 0)) && data_pkt_received)
			{	
			/* Extracting the MSDU from the packet only if the packet	*/
			/* is destined for this station.							*/		
			op_pk_nfd_get (wlan_rcvd_frame_ptr, "Frame Body", &seg_pkptr);

			/* Only send acknowledgement if the data frame is destined for 	*/
			/* this station. No Acks for broadcast frame.					*/
			if (dest_addr == my_address)
				{
				/* Send the acknowledgement to any received data frame.	*/
				fresp_to_send = WlanC_Ack;
				
				/* If no more fragments, then duration value in ack must be zero */
				if (pk_dhstruct_ptr->more_frag == 0)
					wlan_flags->duration_zero = OPC_TRUE;
				else 
					wlan_flags->duration_zero = OPC_FALSE;							
				}
			             	
			/* If PCF is active and this is an AP */ 
			if ((wlan_flags->pcf_active == OPC_TRUE) && 
				(ap_flag == OPC_BOOLINT_ENABLED))
				{
				/* Set poll more fragments flag if necessary */
				if (pk_dhstruct_ptr->more_frag == 1)
					wlan_flags->more_frag = OPC_TRUE;
				else 
					wlan_flags->more_frag = OPC_FALSE;

				/* Set poll more data (MSDU's) flag if necessary */
				if ((pk_dhstruct_ptr->more_data == 0)  || (wlan_flags->tx_beacon == OPC_TRUE) ||
					(wlan_flags->tx_cf_end == OPC_TRUE))
					{
					/* no more polls for new MDSU will be sent to this STA so reset flag		*/
					wlan_flags->more_data = OPC_FALSE;
					}
				else 
					{
					/* need to poll this STA at least one more time, so set flag				*/
					wlan_flags->more_data = OPC_TRUE;
					}
				}
												
			/* If its a duplicate packet then destroy it and do nothing, otherwise 	*/
			/* insert it in the defragmentation list.								*/
			if (wlan_tuple_find (remote_sta_addr, pk_dhstruct_ptr->sequence_number, pk_dhstruct_ptr->fragment_number, dest_addr) == OPC_FALSE)
				{
				wlan_data_process (seg_pkptr, dest_addr, remote_sta_addr, final_dest_addr, pk_dhstruct_ptr->fragment_number, 
					pk_dhstruct_ptr->more_frag, data_pkt_id);
				}
			else
				{
				/* Destroy the duplicate packet without any processing.				*/
				op_pk_destroy (seg_pkptr);
				}
			}
			
		/* Check whether we are being polled.										*/
		if (((rcvd_frame_type == WlanC_Data_Poll) || (rcvd_frame_type == WlanC_Data_A_P) ||
			(rcvd_frame_type == WlanC_Cf_Poll)	  || (rcvd_frame_type == WlanC_Cf_A_P))	 &&
			(dest_addr == my_address))
			{
			/* Since frame contained a poll for my address, set polled flag.		*/
			wlan_flags->polled = OPC_TRUE;
			
			/* Printing out information to ODB.	*/
			if (wlan_trace_active == OPC_TRUE)
				{
				wlan_frame_type_conv(rcvd_frame_type, actual_frame_name);
				
				sprintf (msg_string, "%s is received from AP", actual_frame_name);
				op_prg_odb_print_major (msg_string, OPC_NIL);
			 	}
			}
		
		if (expected_frame_type == WlanC_Ack)
			{
			/* If an Ack is expected, and a PCF Ack is received, regardless of whom	*/  
			/* the frame is	addressed to, process the received ACK.					*/
			if ((rcvd_frame_type == WlanC_Data_Ack) || (rcvd_frame_type == WlanC_Data_A_P) ||
				(rcvd_frame_type == WlanC_Cf_Ack)   || (rcvd_frame_type == WlanC_Cf_A_P)) 
				{
				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					if ((last_frametx_type == WlanC_Data) || (last_frametx_type == WlanC_Data_Ack))
						{
						sprintf (msg_string, "Ack received for data packet " SIMC_PK_ID_FMT, pkt_in_service);
						op_prg_odb_print_major (msg_string, OPC_NIL);
						}
					else
						{
						sprintf (msg_string, "Ack received for data packet " SIMC_PK_ID_FMT, pcf_pkt_in_service);
						op_prg_odb_print_major (msg_string, OPC_NIL);
						}
					}			

				op_stat_write (retrans_handle, (double) (pcf_retry_count * 1.0));

				if ((last_frametx_type == WlanC_Data) || (last_frametx_type == WlanC_Data_Ack))
					{
					/* Reset the retry counter as the expected frame is received.		*/
					retry_count = 0;
					
					/* Similarly reset the variables that may have been set and used	*/
					/* for this transmission during the DCF period that proceeded the	*/
					/* current PCF period.												*/
					wlan_flags->rts_sent = OPC_FALSE;
					if (wlan_flags->cw_required != OPC_TRUE)
						backoff_slots = BACKOFF_SLOTS_UNSET;
					
					/* Decrement number of fragment count because one fragment is		*/
					/* successfully transmitted.										*/
					num_fragments = num_fragments - 1;				

					/* Data packet is successfully delivered to remote station,			*/
					/* since no further retransmission is needed the copy of the data	*/
					/* packet will be destroyed.										*/
					if (wlan_transmit_frame_copy_ptr != OPC_NIL) 
						{
						op_pk_destroy (wlan_transmit_frame_copy_ptr);
						wlan_transmit_frame_copy_ptr = OPC_NIL;
						}
					}
				else
					{
					/* Reset the retry counter as the expected frame is received  */
					pcf_retry_count = 0;

					/* Decrement number of fragment count because one fragment    */
					/* is successfully transmitted.							      */
					pcf_num_fragments = pcf_num_fragments - 1;				

					/* Data packet is successfully delivered to remote station,			*/
					/* since no further retransmission is needed the copy of the data	*/
					/* packet will be destroyed.										*/
					if (wlan_pcf_transmit_frame_copy_ptr != OPC_NIL)
						{
						op_pk_destroy (wlan_pcf_transmit_frame_copy_ptr);
						wlan_pcf_transmit_frame_copy_ptr = OPC_NIL;
						}
					}
				}
			else
				{
				/* A frame has not been properly acknowledged and requires retransmission    */
				/* If the last transmitted frame was a data frame must be a DCF transmission */
				/* Else must be a PCF transmission 											 */
				if ((last_frametx_type == WlanC_Data) || (last_frametx_type == WlanC_Data_Ack)) 
					{
				    retry_count++;
					}
				else 
					{
					pcf_retry_count++;
					}
				}
			}

		if 	((expected_frame_type == WlanC_Data) && 
			((rcvd_frame_type == WlanC_Data) ||	(rcvd_frame_type == WlanC_Data_Null)))
			{
			/* If PCF Data is expected, and some type of PCF Data is received regardless of who	*/  
			/* 	addressed to, poll is satisfied so destroy copy of tx packet                    */
			if (((last_frametx_type == WlanC_Data)  || 
				(last_frametx_type == WlanC_Data_Ack)) && 
				(wlan_transmit_frame_copy_ptr != OPC_NIL)) 
				{
				op_pk_destroy (wlan_transmit_frame_copy_ptr);
				wlan_transmit_frame_copy_ptr = OPC_NIL;
				}
			else if (wlan_pcf_transmit_frame_copy_ptr != OPC_NIL)
				{
				op_pk_destroy (wlan_pcf_transmit_frame_copy_ptr);
				wlan_pcf_transmit_frame_copy_ptr = OPC_NIL;
				}
			}
		
		if (expected_frame_type == WlanC_Cts) 
			{
			/* Since the station did not receive the expected frame	*/
			/* it has to retransmit the packet.						*/
			retry_count = retry_count + 1;
						
			/* If Rts sent flag was enable then disable it as the station will recontend for the channel.	*/
			if (wlan_flags->rts_sent == OPC_TRUE)
				{
				wlan_flags->rts_sent = OPC_FALSE;
				}
			
			if (cfp_ap_medium_control == OPC_FALSE)
				nav_duration = current_time;
			}
			
		/* Update NAV duration if the received NAV duration is greater	*/
		/* than the current NAV duration.							  	*/    	
		if ((pk_dhstruct_ptr->duration < 32768) && 
			(nav_duration < (pk_dhstruct_ptr->duration + current_time)))
			{
			nav_duration = pk_dhstruct_ptr->duration + current_time;

			/* Set the flag that indicates updated NAV value.			*/
			wlan_flags->nav_updated = OPC_TRUE;
			}
		else if (nav_duration < current_time)
			{
			/* Update NAV to current time in case ack is required (otherwise negative duration may be	*/
			/* be computed.  Should not effect deference processing, so don't set nav_updated flag.		*/
			nav_duration = current_time;
			}			
		}

	else if	(rcvd_frame_type == WlanC_Beac)
		{
		/* Update received control traffic statistics. Write the		*/
		/* appropriate values for start and end of the reception.		*/
		op_stat_write_t (ctrl_traffic_rcvd_handle_inbits, rcvd_pk_size, rx_start_time);
		op_stat_write (ctrl_traffic_rcvd_handle_inbits, 0.0);
		op_stat_write_t (ctrl_traffic_rcvd_handle, 1.0, rx_start_time);
		op_stat_write (ctrl_traffic_rcvd_handle, 0.0);

		/* Address information, sequence control fields,	*/
		/* and the data is extracted from the rcvd packet.	*/
		op_pk_nfd_access (wlan_rcvd_frame_ptr, "Wlan Header",	&pk_dhstruct_ptr);

		/* The destination address in this case will be -1 as the */
		/* beacon frame is a broadcast frame.				      */
		dest_addr = pk_dhstruct_ptr->address1;			
		
		/* Store the address of the AP transmitting the Beacon.		*/
		remote_sta_addr = pk_dhstruct_ptr->address2;	
		rcvd_sta_bssid = pk_dhstruct_ptr->address3;		

		/* If roaming enabled, update the reliability of the signal	*/
		/* from the AP that sent this Beacon, which we received		*/
		/* successfully.											*/
		if (roam_state_ptr->enable_roaming)
			wlan_ap_reliability_eval (wlan_rcvd_frame_ptr, OPC_TRUE, roam_state_ptr);
		
		/* If the STA is canning for a new BSS, then save the BSS ID of the beacon transmitter */
		if (roam_state_ptr->scan_mode)
			eval_bss_id = rcvd_sta_bssid;

		/* Init frame response to send 			*/
		fresp_to_send = WlanC_None; 
		
		/* Extracting the Beacon Body packet 	*/
		op_pk_nfd_get (wlan_rcvd_frame_ptr, "Frame Body", &seg_pkptr);

		/* Extracting the Beacon Body structure from packet	*/
		op_pk_nfd_access (seg_pkptr, "Beacon Body",	&pk_bbstruct_ptr);

		/* Only send acknowledgement if the beacon frame is addressed to this station.	*/
		/* No Acks for broadcast frame.													*/
		if (dest_addr == my_address)
			{
			/* Send the acknowledgement to any received data frame.	*/
			fresp_to_send = WlanC_Ack;
			}
		else
			{
			/* If the frame is not destined for this station	*/
			/* then do not respond with any frame.				*/
			fresp_to_send = WlanC_None;
			}						
			
		if (expected_frame_type != WlanC_None) 
			{
			/* Since the station did not receive the expected frame	*/
			/* it has to retransmit the packet.						*/
			if (wlan_flags->pcf_active == OPC_TRUE) 
				{
				pcf_retry_count = pcf_retry_count + 1;
				}
			else
				{
				retry_count = retry_count + 1;
				}
			
			/* If Rts sent flag was enable then disable it as the station will recontend for the channel.	*/
			if (wlan_flags->rts_sent == OPC_TRUE)
				{
				wlan_flags->rts_sent = OPC_FALSE;
				}
			}
			
		/* If beacon is intended for this BSS, update BSS related variables */
		if (rcvd_sta_bssid == bss_id) 
			{
			/* Set beacon interval */
			beacon_int = pk_bbstruct_ptr->beacon_intv;				
	
			/* Set CFP period */		
			cfp_prd = pk_bbstruct_ptr->cf_par.cfp_period;		
			
			/* Set CFP length*/
			cfp_length =pk_bbstruct_ptr->cf_par.cfp_maxduration;	

			/* Indicate the presence of an active AP  */
			if (cfp_prd != 0)
				{
				/* set active PC flag */	
				active_pc = OPC_TRUE;
				
				/* Set this flag only if the beacon indicates the start of a CFP */
				/* Will not be set if the beacon is sent from a non-PC AP.       */
				cfp_ap_medium_control = OPC_TRUE;

				temp = (((int) (pk_bbstruct_ptr->timestamp/beacon_int)) % cfp_prd);
				
				temp2 = (temp - pk_bbstruct_ptr->cf_par.cfp_count + cfp_prd);
				cfp_offset = temp2 % cfp_prd;
				}
			}

		if ((pk_bbstruct_ptr->cf_par.cfp_count == 0) && 
			((pk_bbstruct_ptr->timestamp + pk_bbstruct_ptr->cf_par.cfp_durremaining) > nav_duration))
			{
			nav_duration = pk_bbstruct_ptr->timestamp + pk_bbstruct_ptr->cf_par.cfp_durremaining;

			/* Set the flag that indicates updated NAV value.			*/
			wlan_flags->nav_updated = OPC_TRUE;
			
			}

		/* Update nav duration if the received nav duration is greater	*/
		/* than the current nav duration.							  	*/    	
		else if ((pk_dhstruct_ptr->duration < 32768) && 
			(nav_duration < (pk_dhstruct_ptr->duration + current_time)))
			{
			nav_duration = pk_dhstruct_ptr->duration + current_time;

			/* Set the flag that indicates updated NAV value.			*/
			wlan_flags->nav_updated = OPC_TRUE;
			
			}

		/* Destroy beacon body since no longer needed */
		op_pk_destroy (seg_pkptr);
		
		/* Printing out information to ODB.	*/
		if (wlan_trace_active == OPC_TRUE)
			{
			op_prg_odb_print_major ("Beacon frame is received", OPC_NIL);
		 	}
		}

	else if	(rcvd_frame_type == WlanC_Rts)
		{
		/* Update received control traffic statistics. Write the		*/
		/* appropriate values for start and end of the reception.		*/
		op_stat_write_t (ctrl_traffic_rcvd_handle_inbits, rcvd_pk_size, rx_start_time);
		op_stat_write (ctrl_traffic_rcvd_handle_inbits, 0.0);
		op_stat_write_t (ctrl_traffic_rcvd_handle, 1.0, rx_start_time);
		op_stat_write (ctrl_traffic_rcvd_handle, 0.0);

		/* First check that whether the station is expecting any frame or not	*/
		/* If not then decapsulate the Rts frame and set a Cts frame response	*/
		/* if frame is destined for this station. Otherwise, just update the	*/
		/* network allocation vector for this station.							*/
		op_pk_nfd_access (wlan_rcvd_frame_ptr, "Wlan Header", &pk_chstruct_ptr);			
		dest_addr = pk_chstruct_ptr->rx_addr;
		remote_sta_addr = pk_chstruct_ptr->tx_addr;
			
		if (expected_frame_type == WlanC_None)
			{
			/* We will respond to the Rts with a Cts only if a) the	*/
			/* Rts is destined for us, and b) our NAV duration is	*/
			/* not larger than current simulation time.				*/
			if ((my_address == dest_addr) && (current_time >= nav_duration))
				{
				/* Set the frame response field to Cts.				*/
				fresp_to_send = WlanC_Cts;

				/* Printing out information to ODB.					*/
				if (wlan_trace_active == OPC_TRUE)
					op_prg_odb_print_major ("Rts is received and Cts will be transmitted", OPC_NIL);
				}			
			else
				{
				/* Printing out information to ODB.					*/
				if (wlan_trace_active == OPC_TRUE)
					op_prg_odb_print_major ("Rts is received and discarded", OPC_NIL);
				}				
		 	}
		else
			{				
			/* Since the station did not receive the expected frame it has to retransmit the packet.	*/
			retry_count = retry_count + 1;				
			
			/* If Rts sent flag was enable then disable it as the station will recontend for the channel.	*/
			if (wlan_flags->rts_sent == OPC_TRUE)
				{
				wlan_flags->rts_sent = OPC_FALSE;
				}
				
			/* Reset the NAV duration so that the				*/
			/* retransmission is not unnecessarily delayed.		*/
			if (cfp_ap_medium_control == OPC_FALSE)
				nav_duration = current_time;
						
			/* Reset the expected frame type variable since we	*/
			/* will retransmit.									*/
			fresp_to_send = WlanC_None;
			}

		/* Update NAV duration if the received NAV duration is greater	*/
		/* than the current NAV duration.							  	*/    	
		if (nav_duration < (pk_chstruct_ptr->duration + current_time))
			{
			nav_duration = pk_chstruct_ptr->duration + current_time;

			/* Set the flag that indicates updated NAV value.			*/
			wlan_flags->nav_updated = OPC_TRUE;
			}			
		}		
	
	else if	(rcvd_frame_type == WlanC_Cts)
		{
		/* Update received control traffic statistics. Write the		*/
		/* appropriate values for start and end of the reception.		*/
		op_stat_write_t (ctrl_traffic_rcvd_handle_inbits, rcvd_pk_size, rx_start_time);
		op_stat_write (ctrl_traffic_rcvd_handle_inbits, 0.0);
		op_stat_write_t (ctrl_traffic_rcvd_handle, 1.0, rx_start_time);
		op_stat_write (ctrl_traffic_rcvd_handle, 0.0);

		/* First check that whether the station is expecting any frame or not	*/
		/* If not then decapsulate the Rts frame and set a Cts frame response	*/
		/* if frame is destined for this station. Otherwise, just update the	*/
		/* network allocation vector for this station.							*/
		op_pk_nfd_access (wlan_rcvd_frame_ptr, "Wlan Header",	&pk_chstruct_ptr);
		dest_addr = pk_chstruct_ptr->rx_addr;

		/* If the frame is destined for this station and the station is expecting	*/
		/* Cts frame then set appropriate indicators.								*/
		if ((dest_addr == my_address) && (expected_frame_type == rcvd_frame_type)) 				
			{
			/* The receipt of Cts frame indicates that Rts is successfully	*/
			/* transmitted and the station can now respond with Data frame	*/
			fresp_to_send = WlanC_Data;

			/* Set the flag indicating that Rts is successfully transmitted.*/
			wlan_flags->rts_sent = OPC_TRUE;

			op_stat_write (retrans_handle, (double) (retry_count * 1.0));

			/* Printing out information to ODB.	*/
			if (wlan_trace_active == OPC_TRUE)
				{	
				sprintf (msg_string, "Cts is received for Data packet " SIMC_PK_ID_FMT, pkt_in_service);
				op_prg_odb_print_major (msg_string, OPC_NIL);
				}
			}
		else
			{
			/* Printing out information to ODB.								*/
			if (wlan_trace_active == OPC_TRUE)
				op_prg_odb_print_major ("Cts is received and discarded.", OPC_NIL);

			/* Check whether we were expecting another frame. If yes then	*/
			/* we need to retransmit the frame for which we were expecting	*/
			/* a reply.														*/
			if (expected_frame_type != WlanC_None)
				{				
				/* Since the station did not receive the expected frame it	*/
				/* has to retransmit the packet.							*/
				retry_count = retry_count + 1;				

				/* If Rts sent flag was enable then disable it as the		*/
				/* station will recontend for the channel.					*/
				if (wlan_flags->rts_sent == OPC_TRUE)
					wlan_flags->rts_sent = OPC_FALSE;
				
				/* Reset the NAV duration so that the retransmission is not	*/
				/* unnecessarily delayed.									*/
				if (cfp_ap_medium_control == OPC_FALSE)
					nav_duration = current_time;
				}
			}
						
		/* If network allocation vector is less than the received duration	*/
		/* value then update its value.  									*/
		if (nav_duration < (pk_chstruct_ptr->duration + current_time))
			{
			nav_duration = pk_chstruct_ptr->duration + current_time;				
			
			/* Set the flag that indicates updated NAV value.				*/
			wlan_flags->nav_updated = OPC_TRUE;
			}			
		}
	
	else if	((rcvd_frame_type == WlanC_Ack)	|| (rcvd_frame_type == WlanC_Cf_End) ||
			(rcvd_frame_type == WlanC_Cf_End_A))
		{				
		op_pk_nfd_access (wlan_rcvd_frame_ptr,"Wlan Header", &pk_chstruct_ptr); 		
		dest_addr = pk_chstruct_ptr->rx_addr;
		
		/* If PCF active and this is an AP */
		if ((wlan_flags->pcf_active == OPC_TRUE) && (ap_flag == OPC_BOOLINT_ENABLED))
			{
			/* Check if frame is intended for this station and increment failed poll count if necessary */
			if (dest_addr == my_address) 
				poll_fail_count = 0;
			else if (wlan_flags->active_poll == OPC_TRUE) 
				{
				poll_fail_count++;
				}

			wlan_flags->active_poll = OPC_FALSE;
			
			/* Clear side traffic flag if set since Ack is now received.*/
			wlan_flags->pcf_side_traf = OPC_FALSE;
			}
			
		/* Update received control traffic statistics. Write the		*/
		/* appropriate values for start and end of the reception.		*/
		op_stat_write_t (ctrl_traffic_rcvd_handle_inbits, rcvd_pk_size, rx_start_time);
		op_stat_write (ctrl_traffic_rcvd_handle_inbits, 0.0);
		op_stat_write_t (ctrl_traffic_rcvd_handle, 1.0, rx_start_time);
		op_stat_write (ctrl_traffic_rcvd_handle, 0.0);

		if (expected_frame_type == WlanC_Ack)
			{
			/* If an Ack is expected, and a DCF Ack is received for this destination, or 	*/  
			/* CF_END+ACK is received, process the received ack.                            */
			if (((rcvd_frame_type == WlanC_Ack) && (dest_addr == my_address)) || 
				(rcvd_frame_type == WlanC_Cf_End_A))
				{
				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					if ((last_frametx_type == WlanC_Data) || (last_frametx_type == WlanC_Data_Ack))
						{
						sprintf (msg_string, "Ack received for data packet " SIMC_PK_ID_FMT, pkt_in_service);
						op_prg_odb_print_major (msg_string, OPC_NIL);
						}
					else
						{
						sprintf (msg_string, "Ack received for data packet " SIMC_PK_ID_FMT, pcf_pkt_in_service);
					  	op_prg_odb_print_major (msg_string, OPC_NIL);
						}
					}			

				if ((last_frametx_type == WlanC_Data) || (last_frametx_type == WlanC_Data_Ack))
					{
					op_stat_write (retrans_handle, (double) (retry_count * 1.0));

					/* Reset the retry counter as the expected frame is received	*/
					retry_count = 0;
				
					/* Decrement number of fragment count because one fragment is successfully transmitted.	*/
					num_fragments = num_fragments - 1;				
					}
				else
		        	{
					op_stat_write (retrans_handle, (double) (pcf_retry_count * 1.0));

					/* Reset the retry counter as the expected frame is received	*/
					pcf_retry_count = 0;

					/* Decrement number of fragment count because one fragment is successfully transmitted.	*/
					pcf_num_fragments = pcf_num_fragments - 1;				
                    }

				/* When there are no more fragments to transmit then disable the Rts sent flag	*/
				/* if it was enabled because the contention period due to Rts/Cts exchange is 	*/
				/* over and another Rts/Cts exchange is needed for next contention period.		*/
				if (num_fragments == 0)
					{
					wlan_flags->rts_sent = OPC_FALSE;
					
					/* Set the contention window flag. Since the ACK for the last 		*/
					/* fragment indicates a	successful transmission of the entire data,	*/
					/* we need to back-off for a contention window period.				*/
					if (rcvd_frame_type == WlanC_Ack)
						wlan_flags->cw_required = OPC_TRUE;
					
					}

				/* Data packet is successfully delivered to remote station,			*/
				/* since no further retransmission is needed the copy of the data	*/
				/* packet will be destroyed.										*/
				if (((last_frametx_type == WlanC_Data) || (last_frametx_type == WlanC_Data_Ack)) &&
					(wlan_transmit_frame_copy_ptr != OPC_NIL)) 
					{
					op_pk_destroy (wlan_transmit_frame_copy_ptr);
					wlan_transmit_frame_copy_ptr = OPC_NIL;
					}
				else if (wlan_pcf_transmit_frame_copy_ptr != OPC_NIL)
					{
					op_pk_destroy (wlan_pcf_transmit_frame_copy_ptr);
					wlan_pcf_transmit_frame_copy_ptr = OPC_NIL;
					}
				}
			else
				{
				/* A frame has not been properly acknowledged and requires retransmission */
				retry_count = retry_count + 1;
				
				if (expected_frame_type == WlanC_Ack)
					{
					/* Printing out information to ODB.	*/
					if (wlan_trace_active == OPC_TRUE)
						{
						op_prg_odb_print_major ("The expected ACK is not received.", OPC_NIL);
						}
					}
				}
			}

		if (expected_frame_type == WlanC_Cts) 
			{
			/* Since the station did not receive the expected frame	*/
			/* it has to retransmit the packet.						*/
			retry_count = retry_count + 1;
			
			/* If Rts sent flag was enable then disable it as the station will recontend for the channel.	*/
			if (wlan_flags->rts_sent == OPC_TRUE)
				{
				wlan_flags->rts_sent = OPC_FALSE;
				}
			
			/* Reset the NAV duration so that the				*/
			/* retransmission is not unnecessarily delayed.		*/
			if (cfp_ap_medium_control == OPC_FALSE)
				nav_duration = current_time;
			}
		
		if ((rcvd_frame_type == WlanC_Cf_End) || (rcvd_frame_type == WlanC_Cf_End_A))
			{
			/* If a CFP end frame was received, indicate that availability	*/
			/* of the medium to the stations to contend to transmit frames.	*/
			cfp_ap_medium_control = OPC_FALSE;
			
			/* Make sure that we have received the CF-End message from our	*/
			/* own AP. The tx_addr field of the frame's header conveys the	*/
			/* BSS ID of the sending AP in CF-End messages.					*/
			if (bss_id == pk_chstruct_ptr->tx_addr)
				{
				/* If end of cfp, reset NAV.								*/
				nav_duration = current_time;

				/* Set the flag that indicates updated NAV value.			*/
				wlan_flags->nav_updated = OPC_TRUE;
				
				/* Printing out information to ODB.							*/
				if (wlan_trace_active == OPC_TRUE)
					{
					if (rcvd_frame_type == WlanC_Cf_End)
						op_prg_odb_print_major ("CF-End frame is received.",     OPC_NIL);
					else
						op_prg_odb_print_major ("CF-End+Ack frame is received.", OPC_NIL);
					}				
				}
			}

		/* If network allocation vector is less than the received duration	*/
		/* value then update its value. 									*/
		if (nav_duration < (pk_chstruct_ptr->duration + current_time))
			{
			nav_duration = pk_chstruct_ptr->duration + current_time;

			/* Set the flag that indicates updated NAV value.				*/
			wlan_flags->nav_updated = OPC_TRUE;
			}
		
		}

	else 
		{
		/* Unknown frame type so declare error.								*/
		wlan_mac_error ("Unexpected frame type received.", OPC_NIL, OPC_NIL);
		}
   
	/* Report the amount of time the channel will be busy if the NAV is		*/
	/* updated with the received packet.									*/
	if (!(rcvd_frame_type == WlanC_Ack || rcvd_frame_type == WlanC_Cf_End || rcvd_frame_type == WlanC_Cf_End_A))
		{
		op_stat_write (channel_reserv_handle, (nav_duration - current_time));
		op_stat_write (channel_reserv_handle, 0.0);
		}
	
	/* Check whether further retries are possible or	*/
	/* the data frame needs to be discarded.			*/
	if ((wlan_flags->pcf_active == OPC_TRUE) && (ap_flag == OPC_BOOLINT_ENABLED))
		wlan_pcf_frame_discard ();
	else
		wlan_frame_discard ();

	/* Set the expected frame type to None because either the 	*/
	/* expected frame is received or the station will have to 	*/
	/* retransmit the frame										*/
	expected_frame_type = WlanC_None;
	
	/* Destroying the received frame once relevant information is taken out of it.	*/
	op_pk_destroy (wlan_rcvd_frame_ptr);														

	FOUT;
	}


static Boolean
wlan_tuple_find (int sta_addr, int seq_id, int frag_num, int dest_addr)
	{
	WlanT_Mac_Duplicate_Buffer_Entry*	tuple_ptr;
	WlanT_Duplicate_Mapping_Info *dup_info_ptr;
	WlanT_Sta_Mapping_Info *sta_info_ptr;

	/** This routine determines whether the received data frame already	**/
	/** exists in the duplicate buffer. If it is not then it will be	**/
	/** added to the list and the list is updated such that its size	**/
	/** will not be greater then the MAX TUPLE SIZE.					**/
	FIN (wlan_tuple_find (sta_addr, seq_id, frag_num, dest_addr));

	/* Before accessing, lock the mutex for global BSS-STA mapping		*/
	/* information as a "reader".										*/
	op_prg_mt_mutex_lock (mapping_info_mutex, OPC_MT_MUTEX_LOCK_READER);
	
	/* First check if this station belongs to this BSS.					*/
	sta_info_ptr =  wlan_sta_info_get (sta_addr, OPC_FALSE);
	if (sta_info_ptr != PRGC_NIL)
		{
		/* Access our duplicate information, if any, for the given		*/
		/* source address.												*/
		dup_info_ptr = (WlanT_Duplicate_Mapping_Info *) prg_mapping_value_get (my_sta_info_ptr->dup_mapping_hndl, &sta_addr);
		
		/* If remote station entry doesn't exist then create new node.	*/
		if (dup_info_ptr == OPC_NIL)
			{	
			/* Creating struct type for duplicate frame (or tuple)		*/
			/* structure. 												*/
			tuple_ptr = (WlanT_Mac_Duplicate_Buffer_Entry *) op_prg_mem_alloc (sizeof (WlanT_Mac_Duplicate_Buffer_Entry));

			/* Generate error and abort simulation if no more memory	*/
			/* left to allocate for duplicate buffer.					*/
			if (tuple_ptr == OPC_NIL)
				{
				wlan_mac_error ("Cannot allocate memory for duplicate buffer entry", OPC_NIL, OPC_NIL);
				}	

			/* Note remote_sta_addr is same as sta_addr.				*/
			tuple_ptr->tx_station_address 	= remote_sta_addr;						
			tuple_ptr->sequence_id 			= seq_id;
			tuple_ptr->fragment_number 		= frag_num;

			/* Create a duplicate information record for the given		*/
			/* remote station.											*/
			dup_info_ptr = (WlanT_Duplicate_Mapping_Info *) op_prg_mem_alloc (sizeof (WlanT_Duplicate_Mapping_Info));
			dup_info_ptr->rem_sta_addr = sta_addr;

			/* Add new tuple information to record.						*/					
			dup_info_ptr->duplicate_ptr = tuple_ptr;						

			/* Insert duplicate information record in the mapping.		*/
			prg_mapping_value_add (my_sta_info_ptr->dup_mapping_hndl, dup_info_ptr);
			}			
		else
			{
			if (dup_info_ptr->duplicate_ptr->sequence_id == seq_id &&
				dup_info_ptr->duplicate_ptr->fragment_number >= frag_num)
				{
				/* This will be set in the retry field of				*/
				/* Acknowledgement.										*/
				duplicate_entry = 1;

				/* Break the routine as the packet is already received	*/
				/* by the station. Unlock the mutex before exiting.		*/
				op_prg_mt_mutex_unlock (mapping_info_mutex);
				FRET (OPC_TRUE);
				}
			else
				{
				/* Update the sequence id and fragment number fields of	*/
				/* the remote station in the duplicate buffer list. The	*/
				/* list maintains the sequence id and fragment number	*/
				/* of the previously received frame from this remote	*/
				/* station. 											*/
				dup_info_ptr->duplicate_ptr->sequence_id = seq_id;
				dup_info_ptr->duplicate_ptr->fragment_number = frag_num;							
				}
			}
		
		/* Unlock the mapping information mutex.						*/
		op_prg_mt_mutex_unlock (mapping_info_mutex);
        }
	else
		{
		/* First unlock the mapping information mutex.					*/
		op_prg_mt_mutex_unlock (mapping_info_mutex);
		
		/* Its not possible for a station to directly receive packet	*/
		/* from a station that does not exist in its BSS unless it is a	*/
		/* broadcast packet.											*/
		if (dest_addr == my_address)
			{
			wlan_mac_error ("Receiving packet from a station that does not exist in this BSS",
							"Possibly wrong destination address", "Please check the configuration");
			}
		else
			{
			/* We may receive broadcast packets that are not originated	*/
			/* in our BSS, if there are other BSSes in the vicinity		*/
			/* that uses the exact same physical channel with our own	*/
			/* BSS. In such cases, return OPC_TRUE, like we received a	*/
			/* duplicate message, so that the caller function destroys	*/
			/* the packet without any processing.						*/
			FRET (OPC_TRUE);
			}
		}

	/* This will be set in the retry field of Acknowledgement.			*/
	duplicate_entry = 0;

	/* Packet is not already received by the station.					*/ 
	FRET (OPC_FALSE);				
	}
	
static void
wlan_data_process (Packet* seg_pkptr,int dest_addr, int sta_addr, int final_dest_addr,
				int frag_num, int more_frag, double pkt_id)
	{
	char										msg_string [120];
	int	 										current_index;
	int 										list_index;
	int 										list_size;
	int											protocol_type;
	Packet*										copy_pkptr;
	Boolean										send_to_higher;
	WlanT_Mac_Defragmentation_Buffer_Entry*     defrag_ptr = OPC_NIL;
	
	/** This routine handles defragmentation process and also sends		**/
	/** data to the higher layer if all the fragments have been			**/
	/** received by the station.										**/
	FIN (wlan_data_process (seg_pkptr, dest_addr, sta_addr, final_dest_addr, frag_num, more_frag, pkt_id));

	/* First check for the case where the received segment contains the	*/
	/* entire data packet, i.e. the data is transmitted as a single		*/
	/* fragment.														*/
	if (frag_num == 0 && more_frag == 0)
		{
		/* Insert the segment into our "common" reassembly buffer that	*/
		/* is used for such single-fragment transmission.				*/
		op_sar_rsmbuf_seg_insert (common_rsmbuf_ptr, seg_pkptr);
		}
	
	else
		{
		/* The original packet is being transmitted in multiple			*/
		/* fragments. Insert fragments into the reassembly buffer.		*/
		/* There are two possible cases:								*/
		/* 1. The remote station has just started sending the 			*/
		/* fragments and it doesn't exist in the list.					*/
		/* 2. The remote station does exist in the list and the 		*/
		/* and the new fragment is a series of fragments for the data 	*/
		/* packet.													  	*/

		/* Get the size of the defragmentation list.					*/
		list_size = op_prg_list_size (defragmentation_list_ptr);

		/* Initialize the current node index which will indicate		*/
		/* whether the entry for the station exists in the list.		*/
		current_index = -1;

		/* Searching through the list to find if the remote station		*/
		/* address exists i.e. the source station has received			*/
		/* fragments for this data packet before. Also, removing		*/
		/* entries from the defragmentation buffer which has reached	*/
		/* its maximum receive lifetime.								*/
		for (list_index = 0; list_index < list_size; )
			{
			/* Accessing node of the list for search purposes.			*/						
			defrag_ptr = (WlanT_Mac_Defragmentation_Buffer_Entry *) op_prg_list_access (defragmentation_list_ptr, list_index);

			/* Removing station entry if the receive lifetime has		*/
			/* expired.													*/
			if ((current_time - defrag_ptr->time_rcvd) >= max_receive_lifetime)
				{
				/* Removing the partially completed fragment once its	*/
				/* lifetime has reached.								*/
				defrag_ptr =(WlanT_Mac_Defragmentation_Buffer_Entry *) op_prg_list_remove (defragmentation_list_ptr, list_index);
				op_sar_buf_destroy (defrag_ptr->reassembly_buffer_ptr);					
				op_prg_mem_free (defrag_ptr);	

				/* Updating the total list size.						*/
				list_size = list_size - 1;
				}

			/* If the station entry already exists in the list then		*/
			/* store its index for future use.							*/
			else if (remote_sta_addr == defrag_ptr->tx_station_address)
				{
				current_index = list_index;
			
				/* Exit the loop since we have found the entry we were	*/
				/* looking for.											*/
				list_index = list_size;	
				}
		
			/* Otherwise move to the next element in the list.			*/
			else
				list_index++;
			}                             						

		/* If remote station entry doesn't exist then create new node.	*/
		if (current_index == -1)											
			{
			/* If the entry of the station does not exist in the defrag	*/
			/* list and the fragment received is not the first fragment	*/
			/* of the packet then it implies that the maximum receive	*/
			/* lifetime of the packet has expired. In this case the		*/
			/* received packet will be destroyed and the				*/
			/* acknowledgement is sent to the receiver as specified by	*/
			/* the protocol.											*/
			if (frag_num > 0)
				{
				op_pk_destroy (seg_pkptr);
				FOUT;
				}

			/* Creating struct type for defragmentation structure.		*/  						
			defrag_ptr = (WlanT_Mac_Defragmentation_Buffer_Entry *) op_prg_mem_alloc (sizeof (WlanT_Mac_Defragmentation_Buffer_Entry));

			/* Generate error and abort simulation if no more memory	*/
			/* left to allocate for duplicate buffer.					*/
			if (defrag_ptr == OPC_NIL)
				{
				wlan_mac_error ("Cannot allocate memory for defragmentation buffer entry", OPC_NIL, OPC_NIL);
				}	

			/* Source station address is store in the list for future	*/
			/* reference.												*/
			defrag_ptr->tx_station_address = sta_addr;

			/* For new node creating a reassembly buffer.				*/
			defrag_ptr->reassembly_buffer_ptr = op_sar_buf_create (OPC_SAR_BUF_TYPE_REASSEMBLY, OPC_SAR_BUF_OPT_DEFAULT);
			op_prg_list_insert (defragmentation_list_ptr, defrag_ptr, OPC_LISTPOS_TAIL);
			}

		/* Record the received time of this fragment.					*/
		defrag_ptr->time_rcvd = current_time;
					
		/* Insert fragment into the reassembly buffer.					*/
		op_sar_rsmbuf_seg_insert (defrag_ptr->reassembly_buffer_ptr, seg_pkptr);
		}

	/* If this is the last fragment then send the data to higher layer.	*/
	if (more_frag == 0)
		{
		/* Pick the correct reassembly buffer based on the fragment		*/
		/* type.														*/
		if (frag_num > 0)
			seg_pkptr = op_sar_rsmbuf_pk_remove (defrag_ptr->reassembly_buffer_ptr);
		else
			seg_pkptr = op_sar_rsmbuf_pk_remove (common_rsmbuf_ptr);
		
		if (ap_flag == OPC_BOOLINT_ENABLED) 
			{
			/* If the address is not found in the address list then access point will sent the data to higher	*/
			/* layer for address resolution. Note that if destination address is same as AP's address then		*/
			/* the packet is sent to higher layer for address resolution. If the destination address is			*/
			/* broadcast address then the packet is both transmitted within the BSS and also forwarded to the	*/
			/* higher layer.																					*/
	
			if ((final_dest_addr != my_address && wlan_sta_info_get (final_dest_addr, OPC_TRUE) != PRGC_NIL) ||
				final_dest_addr == MAC_BROADCAST_ADDR)
				{
				/* Printing out information to ODB.						*/
				if (wlan_trace_active == OPC_TRUE)
					{
					sprintf (msg_string, "All fragments of Data packet %.0f is received and enqueued for transmission within a subnet", pkt_id);
					op_prg_odb_print_major (msg_string, OPC_NIL);
					}

				/* If the destination address is broadcast address then	*/
				/* we need to send a copy also to the higher layer.		*/
				if (final_dest_addr == MAC_BROADCAST_ADDR)
					{
					copy_pkptr = op_pk_copy (seg_pkptr);
					send_to_higher = OPC_TRUE;
					}
				else
					{
					copy_pkptr = seg_pkptr;
					send_to_higher = OPC_FALSE;
					}
				  
				/* Make sure that we have all the fragments.			*/
				if (copy_pkptr == OPC_NIL)
					{
					if (wlan_trace_active == OPC_TRUE)
						{
						strcpy (msg_string, "The received frame was of 0 size and hence all received fragments are discarded.");
						op_prg_odb_print_major (msg_string, OPC_NIL);
						}
					}
				else
					{
					/* Enqueuing packet for transmission within a		*/
					/* subnet.											*/
					if (wlan_poll_list_member_find (final_dest_addr) == OPC_TRUE)
						{
						wlan_hlpk_enqueue (copy_pkptr, final_dest_addr, OPC_TRUE);
						}
					else
						{
						wlan_hlpk_enqueue (copy_pkptr, final_dest_addr, OPC_FALSE);
						wlan_flags->data_frame_to_send  = OPC_TRUE;
						}
					}
				}
			else
				send_to_higher = OPC_TRUE;
			
			/* Send the packet to the higher layer if not destined		*/
			/* within own BSS or if it has broadcast address as			*/
			/* destination address.										*/
			if (send_to_higher == OPC_TRUE)
				{				
				/* Update the local/global throughput and end-to-end	*/
				/* delay statistics based on the packet that will be	*/
				/* forwarded to the higher layer.						*/
				wlan_accepted_frame_stats_update (seg_pkptr);

				/* Set the contents of the LLC-destined ICI -- set the address	*/
				/* of the transmitting station.									*/
				if (op_ici_attr_set (llc_iciptr, "src_addr", remote_sta_addr) == OPC_COMPCODE_FAILURE)
					{
					wlan_mac_error ("Unable to set source address in LLC ICI.", OPC_NIL, OPC_NIL);
					}

				/* Set the destination address (this mainly serves to			*/
				/* distinguish packets received under broadcast conditions.)	*/
				if (op_ici_attr_set (llc_iciptr, "dest_addr", final_dest_addr) == OPC_COMPCODE_FAILURE)
					{
					wlan_mac_error("Unable to set destination address in LLC ICI.", OPC_NIL, OPC_NIL);
					}
		
				/* Set the protocol type field contained in the Wlan frame.	*/
				protocol_type = 0;
				if (op_ici_attr_set (llc_iciptr, "protocol_type", protocol_type) == OPC_COMPCODE_FAILURE)
					{
					wlan_mac_error("Unable to set protocol type in LLC ICI.", OPC_NIL, OPC_NIL);
					}				

				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					sprintf (msg_string, "All fragments of Data packet %.0f is received and sent to the higher layer", pkt_id);
					op_prg_odb_print_major (msg_string, OPC_NIL);
					}
				
				/* Setting an ici for the higher layer */
				op_ici_install (llc_iciptr);

				/* Sending data to higher layer through mac interface.	*/
				op_pk_send (seg_pkptr, outstrm_to_mac_if);
				}
			}
		else
			{
			/* If the station is a gateway and not an access point then do not send		*/
			/* data to higher layer for address resolution.  This is for not allowing   */
			/* data to go out of the ad-hoc BSS. Except, in the case of broadcast		*/
			/* packets and packets addressed to this station. On the other hand, if we	*/
			/* are in a bridge/switch node and not AP enabled, then drop the packet.	*/
			if ((wlan_flags->gateway_flag == OPC_TRUE  && 
				dest_addr != my_address && dest_addr >= 0) || 
				wlan_flags->bridge_flag == OPC_TRUE)
				{				
				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					strcpy (msg_string, "Gateway is not an access point so all received fragments are discarded.");
					op_prg_odb_print_major (msg_string, OPC_NIL);
					}
				op_pk_destroy (seg_pkptr);
				}
			else
				{
				/* Update the local/global throughput and end-to-end	*/
				/* delay statistics based on the packet that will be	*/
				/* forwarded to the higher layer.						*/
				wlan_accepted_frame_stats_update (seg_pkptr);
				
				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					sprintf (msg_string, "All fragments of Data packet %.0f is received and sent to the higher layer", pkt_id);
					op_prg_odb_print_major (msg_string, OPC_NIL);
					}

				/* Sending data to higher layer through mac interface	*/
				op_pk_send (seg_pkptr, outstrm_to_mac_if);
				}
			}
			
		/* If any used, destroyed any defragmentation entry and			*/
		/* reassembly buffer, since the fragments of frame were			*/
		/* completed and the data was sent to the higher layer.			*/
		if (defrag_ptr != OPC_NIL)
			{
			defrag_ptr = (WlanT_Mac_Defragmentation_Buffer_Entry *) op_prg_list_remove (defragmentation_list_ptr, current_index);
			op_sar_buf_destroy (defrag_ptr->reassembly_buffer_ptr);					
			op_prg_mem_free (defrag_ptr);
			}
		}
	else
		{
		/* Printing out information to ODB.	*/
		if (wlan_trace_active == OPC_TRUE)
			{			
			sprintf (msg_string, "Data packet %.0f is received and waiting for more fragments ", pkt_id);
			op_prg_odb_print_major (msg_string, OPC_NIL);
			}
		}

	FOUT;
	}

static void
wlan_accepted_frame_stats_update (Packet* seg_pkptr)
	{
	double	ete_delay, pk_size;
	
	/** This function is called just before a frame received from	**/
	/** physical layer being forwarded to the higher layer to		**/
	/** update end-to-end delay and throughput statistics.			**/
	FIN (wlan_accepted_frame_stats_update (seg_pkptr));
	
	/* Total number of bits sent to higher layer is equivalent to a	*/
	/* throughput.													*/
	pk_size = (double) op_pk_total_size_get (seg_pkptr);
	op_stat_write (throughput_handle, pk_size);
	op_stat_write (throughput_handle, 0.0);

	/* Also update the global WLAN throughput statistic.			*/
	op_stat_write (global_throughput_handle, pk_size);
	op_stat_write (global_throughput_handle, 0.0);
	
	/* Compute the end-to-end delay for the frame and record it.	*/
	ete_delay = current_time - op_pk_stamp_time_get (seg_pkptr);
	op_stat_write (ete_delay_handle, 		ete_delay);
	op_stat_write (global_ete_delay_handle, ete_delay);
	
	FOUT;
	}


static void 
wlan_schedule_deference ()
	{
	/** This routine schedules self interrupt for deference **/
	/** to avoid collision and also deference to observe	**/
	/** interframe gap between the frame transmission.	**/
	FIN (wlan_schedule_deference ());

	/* Check the status of the receiver. If it is busy, exit the	*/
	/* function, since we will schedule the end of the deference	*/
	/* when it becomes idle.										*/
	if (wlan_flags->receiver_busy == OPC_TRUE)
		{
		FOUT;
		} 

	/* Extracting current time at each interrupt.				*/
	current_time = op_sim_time ();
	
	/* Adjust the NAV if necessary.								*/
	if (nav_duration < rcv_idle_time)
		{
		nav_duration = rcv_idle_time;
		}
	
	if (fresp_to_send == WlanC_Ack && IN_CFP) 
		{
		/* ACK over rides receiver busy signal (see 9.2.8).		*/
	
		/* Set deference interrupt for SIFS time.				*/
		deference_evh = op_intrpt_schedule_self (current_time + sifs_time, WlanC_Deference_Off);
		
		/* Disable backoff since not used with SIFS.			*/
		wlan_flags->backoff_flag = OPC_FALSE;
		wlan_flags->perform_cw   = OPC_FALSE;
		
		/* Set ignore busy flag to prevent canceling of			*/
		/* deference by receiver busy.							*/
		wlan_flags->ignore_busy = OPC_TRUE;
		}
	
	else if	(fresp_to_send != WlanC_Ack && wlan_flags->tx_beacon == OPC_TRUE && 
		     wlan_flags->pcf_active == OPC_FALSE)
		{
		/* If it is time to send a Beacon frame and if this is going to	*/
		/* be the beginning of a new CFP, use a PIFS time for deference.*/
		/* Check if PIFS deference already satisfied. If satisfied		*/
		/* start the transmission immediately. Else schedule PIFS based	*/
		/* on last medium idle time. Note that Beacon currently does	*/
		/* not defer to NAV.											*/
		if	(current_time > (rcv_idle_time + pifs_time))
			deference_evh = op_intrpt_schedule_self (current_time, WlanC_Deference_Off);
		else
			deference_evh = op_intrpt_schedule_self (rcv_idle_time + pifs_time, WlanC_Deference_Off);
		
		/* Since we are going to transmit a Beacon frame disable the	*/
		/* backoff and contention window flags.							*/
		wlan_flags->backoff_flag = OPC_FALSE;
		wlan_flags->perform_cw   = OPC_FALSE;
		}

	else if (wlan_flags->pcf_active == OPC_TRUE)
		{
		/* PCF is active, so follow PCF deference and backoff rules. 	*/

		/* Disable backoff because this is the CFP (backoff is actually optional)	*/
		/* Note that a mandatory periodic DIFS + backoff during the CFP is not 		*/
		/* implemented.  (See 9.3.3.2)												*/
		wlan_flags->backoff_flag = OPC_FALSE;		
		wlan_flags->perform_cw   = OPC_FALSE;

		if (wlan_flags->pcf_side_traf == OPC_TRUE)
			{
			/* If last frame was side traffic must defer for ACK as well. Side traffic		*/
			/* requires an Ack from a station other than the AP and the AP may not be 		*/
			/* able to hear the Ack so AP should defer till the Ack would be completed.		*/
			/* Note that allowing side traffic in an infrastructure network was voted out	*/
			/* of the 802.11 standard and should not be permitted. However, the standard	*/
			/* was never fully updated and the wording is currently contradictory on this	*/
			/* point.  The side traffic capability can be shut off in the MAC model			*/
			/* attributes.	To account for side traffic poll response will set the duration	*/
			/* field to account for a WLAN_ACK duration and SIFS.  This is in violation of	*/
			/* the protocol since the duration field should be set to 32768 (0).  However,	*/
			/* since this whole thing is forbidden anyway, some liberties may be taken.		*/
			/* The AP will update it's NAV, and automatically defer the right amount of 	*/
			/* time.																		*/
			deference_evh = op_intrpt_schedule_self (nav_duration + sifs_time , WlanC_Deference_Off);
			wlan_flags->pcf_side_traf = OPC_FALSE;
			}

		else if (ap_flag == OPC_BOOLINT_ENABLED && (poll_fail_count != 0 || pcf_retry_count != 0))
			{
			/* If this is an AP, and a transmission has failed, already waited for 		*/
			/* pifs_time when waiting for response - don't need additional deference.	*/
			deference_evh = op_intrpt_schedule_self (current_time, WlanC_Deference_Off);
			}
	    else
			{
			/* Normal PCF transmission so use a sifs_time.								*/
			deference_evh = op_intrpt_schedule_self (current_time + sifs_time, WlanC_Deference_Off);
			}

		/* Set ignore busy flag to prevent canceling of deference by receiver busy.		*/
		wlan_flags->ignore_busy = OPC_TRUE;
		}
	
	else 
		{
		/* DCF is active, so follow DCF deference and backoff rules. 	*/
	
		/* Station needs to wait SIFS duration before responding to any */	
		/* frame. Also, if Rts/Cts is enabled then the station needs	*/
		/* to wait for SIFS duration after acquiring the channel using	*/
		/* Rts/Cts exchange.						*/
		if ((fresp_to_send != WlanC_None) || (wlan_flags->rts_sent == OPC_TRUE))
			{ 
			deference_evh = op_intrpt_schedule_self (current_time + sifs_time, WlanC_Deference_Off);

			/* Disable backoff and CW flags because this frame is a response frame	*/
			/* to the previously received frame (this could be Ack or Cts).			*/
			wlan_flags->backoff_flag = OPC_FALSE;
			wlan_flags->perform_cw   = OPC_FALSE;
			}

		/* If more fragments to send then wait for SIFS duration and transmit. 		*/
		/* Station need to contend for the channel if one of the fragments is not	*/
		/* successfully transmitted.												*/
		else if ((retry_count == 0) && (op_sar_buf_size (fragmentation_buffer_ptr) > 0))
			{
			/* Scheduling a self interrupt after SIFS duration.						*/
			deference_evh = op_intrpt_schedule_self (current_time + sifs_time, WlanC_Deference_Off);
		
			/* Disable backoff because the frame need to be transmitted after SIFS	*/
			/* duration. This frame is part of the fragment burst.					*/
			wlan_flags->backoff_flag = OPC_FALSE;
			
			}
	
		/* If the last frame we received was corrupted, which indicates a			*/
		/* collision, then we need to defer for a longer period, i.e. for EIFS		*/
		/* period, which starts when the medium becomes idle.						*/
		else if (wlan_flags->wait_eifs_dur == OPC_TRUE)
			{
			/* EIFS is required. We need to use the larger of rcv_idle_time + EIFS	*/
			/* and NAV + DIFS since EIFS period starts when the receiver becomes	*/
			/* idle regardless of the status of virtual carrier sensing (section	*/
			/* 9.2.3.4).															*/
			if (rcv_idle_time + eifs_time >= nav_duration + difs_time)
				deference_evh = op_intrpt_schedule_self ((rcv_idle_time + eifs_time), WlanC_Deference_Off);
			else
				deference_evh = op_intrpt_schedule_self ((nav_duration + difs_time), WlanC_Deference_Off);

			/* After an EIFS period, a backoff is needed.							*/
			if (wlan_flags->cw_required == OPC_TRUE)
				wlan_flags->perform_cw = OPC_TRUE;
			else
				wlan_flags->backoff_flag = OPC_TRUE;
		
			/* Reset the EIFS flag.													*/
			wlan_flags->wait_eifs_dur = OPC_FALSE;
			}
	
		/* If we are in contention window period, which follows a successful		*/
		/* packet transmission, set the flag to trigger the backoff period.			*/
		else if ((wlan_flags->cw_required == OPC_TRUE) && 
			(wlan_flags->polled == OPC_FALSE))
			{
			wlan_flags->perform_cw = OPC_TRUE;
			
			/* We defer for NAV duration plus DIFS duration before resuming for CW	*/
			/* backoff period.														*/
			deference_evh = op_intrpt_schedule_self ((nav_duration + difs_time), WlanC_Deference_Off);		
			}

		else if ((((fresp_to_send != WlanC_None) || 
				(wlan_flags->rts_sent == OPC_TRUE) ||
				((op_sar_buf_size (fragmentation_buffer_ptr) > 0) && (retry_count == 0))) &&
				(wlan_flags->pcf_active == OPC_TRUE)) || 
				((wlan_flags->polled == OPC_TRUE) ||
				((op_sar_buf_size (fragmentation_buffer_ptr) > 0) && (retry_count == 0))))
			{
			/* Station only waits a SIFS duration before sending a response frame, 		*/
			/* continuing a RTS/CTS sequence in progress, or if additional fragments of	*/
			/* a MSDU are being sent. Also no back off is required as long as no 		*/
			/* retrys have been (or are) required. 										*/
			deference_evh = op_intrpt_schedule_self (current_time + sifs_time, WlanC_Deference_Off);

			/* Disable the backoffs since not needed if SIFS time being used.			*/
			wlan_flags->backoff_flag = OPC_FALSE;
			wlan_flags->perform_cw   = OPC_FALSE;

			/* Set ignore busy flag to prevent canceling of deference by receiver busy.	*/
			wlan_flags->ignore_busy = OPC_TRUE;
			}
		
		else
			{
			/* If the station needs to transmit or retransmit frame, it will */
			/* defer for NAV duration plus  DIFS duration and then backoff   */
			deference_evh = op_intrpt_schedule_self ((nav_duration + difs_time), WlanC_Deference_Off);		
		
			/* Before sending data frame or Rts backoff is needed. */
			wlan_flags->backoff_flag = OPC_TRUE;
			}
		}
	
	/* Reset the updated NAV flag, since as of now we scheduled a new	*/
	/* "end of deference" interrupt after the last update.				*/
	wlan_flags->nav_updated = OPC_FALSE;
	
	FOUT;
	}

static void
wlan_frame_discard ()
	{
	int seg_bufsize;
	Packet* seg_pkptr;

	/** No further retries for the data frame for which the retry limit has reached.	**/
	/** As a result these frames are discarded.											**/
	FIN (wlan_frame_discard ());
	
	/* If retry limit has reached then drop the frame.	*/
	if (retry_count == retry_limit)
		{
		/* Update retransmission count statistic.	*/						
		op_stat_write (retrans_handle, (double) (retry_count * 1.0));

		/* Update the local and global dropped packet statistics.	*/
		op_stat_write (drop_packet_handle, 1.0);
	    op_stat_write (drop_packet_handle, 0.0);
		op_stat_write (drop_packet_handle_inbits, (double) packet_size_dcf);
	    op_stat_write (drop_packet_handle_inbits, 0.0);
		op_stat_write (global_dropped_data_handle, (double) packet_size_dcf);
		op_stat_write (global_dropped_data_handle, 0.0);

		/* Reset the retry count for the next packet.	*/
		retry_count = 0;

		/* Get the segmentation buffer size to check if there are more fragments left to be transmitted.	*/
		seg_bufsize =  (int) op_sar_buf_size (fragmentation_buffer_ptr); 

		if (seg_bufsize != 0)
			{
			/* Discard remaining fragments	*/
			seg_pkptr = op_sar_srcbuf_seg_remove (fragmentation_buffer_ptr, seg_bufsize);
			
			op_pk_destroy (seg_pkptr);
			}

		/* If expecting Ack frame then destroy the tx data frame as this frame will	*/
		/* no longer be transmitted (even if we are not expecting an Ack at this	*/
		/* moment, we still may have a copy of the frame if at one point in the		*/
		/* retransmission history of the original packet we received a Cts for our	*/
		/* Rts but then didn't receive an Ack for our data transmission; hence		*/
		/* consider this case as well).												*/
		if ((expected_frame_type == WlanC_Ack) || (wlan_transmit_frame_copy_ptr != OPC_NIL))
			{	
			/* Destroy the copy of the frame as the packet is discarded.	*/
			op_pk_destroy (wlan_transmit_frame_copy_ptr);
			wlan_transmit_frame_copy_ptr = OPC_NIL;
			}
			
		/* Reset the flag that indicates successful RTS transmission.		*/
		wlan_flags->rts_sent = OPC_FALSE;
		
		/* Reset the "frame to respond" variable unless we have a CTS or  	*/
		/* ACK to send.														*/
		if (fresp_to_send == WlanC_Data)
			{
			fresp_to_send = WlanC_None;
			}
		
		/* If there is not any other data packet sent from higher layer and	*/
		/* waiting in the buffer for transmission, reset the related flag.	*/
		if (op_prg_list_size (hld_list_ptr) == 0)
			{
			wlan_flags->data_frame_to_send = OPC_FALSE;
			}
		
		/* Although we could not transmit this data packet and eventually	*/
		/* dropped it, still set the contention window flag and back-off	*/
		/* for a contention window period. This is necessary for the		*/
		/* fairness of the algorithm. This prevents us going to IDLE state	*/
		/* (if higher layer data queue is empty) and then may attempt to	*/
		/* transmit a packet without waiting for a full backoff period as a	*/
		/* result of suddenly receiving a packet from higher layer.			*/
		wlan_flags->cw_required = OPC_TRUE;
		}
	
	FOUT;
	}

static void
wlan_pcf_frame_discard ()
	{
	int 		seg_bufsize;
	Packet* 	seg_pkptr;
	
	/** No further retries for the data frame for which the retry limit has reached.	**/
	/** As a result these frames are discarded.											**/
	FIN (wlan_pcf_frame_discard ());

	/* If retry limit has reached then drop the frame.	*/
	if (pcf_retry_count == retry_limit)
		{
		/* Update retransmission count statistic.	*/						
		op_stat_write (retrans_handle, (double) (pcf_retry_count * 1.0));

		/* Update the local and global dropped packet statistics.	*/
		op_stat_write (drop_packet_handle, 1.0);
	    op_stat_write (drop_packet_handle, 0.0);
		op_stat_write (drop_packet_handle_inbits, (double) packet_size_pcf);
	    op_stat_write (drop_packet_handle_inbits, 0.0);
		op_stat_write (global_dropped_data_handle, (double) packet_size_pcf);
		op_stat_write (global_dropped_data_handle, 0.0);

		/* Reset the retry count for the next packet.	*/
		pcf_retry_count = 0;

		if (pcf_frag_buffer_ptr != OPC_NIL)
			{
			
			/* Get the segmentation buffer size to check if there are more fragments left to be transmitted.	*/
			seg_bufsize =  (int) op_sar_buf_size (pcf_frag_buffer_ptr); 

			if (seg_bufsize != 0)
				{
				/* Discard remaining fragments	*/
				seg_pkptr = op_sar_srcbuf_seg_remove (pcf_frag_buffer_ptr, seg_bufsize);
				
				if (seg_pkptr != OPC_NIL)
					op_pk_destroy (seg_pkptr);
				}

			/* If expecting Ack frame or too many polls, then destroy the 	*/
			/* tx data frame as this frame will no longer be transmitted.	*/
			if ((expected_frame_type == WlanC_Ack) || (poll_fail_count > max_poll_fails) ||
				(wlan_pcf_transmit_frame_copy_ptr != OPC_NIL))
				{	
				/* Destroy the copy of the frame as the packet is discarded.	*/
				
				if (wlan_pcf_transmit_frame_copy_ptr != OPC_NIL)
					{
					op_pk_destroy (wlan_pcf_transmit_frame_copy_ptr);
					}
					
				wlan_pcf_transmit_frame_copy_ptr = OPC_NIL;
				}
			}

		/* Reset the "frame to respond" variable unless we have a CTS or  	*/
		/* ACK to send.														*/
		if (fresp_to_send == WlanC_Data)
			{
			fresp_to_send = WlanC_None;
			}
		}
	
	FOUT;
	}



static void
wlan_mac_rcv_channel_status_update (int channel_id)
	{
	/** This function updates the receiver_busy flag based	**/
	/** on the the current value of the receiver's received	**/
	/** power statistic and reception end time state		**/
	/** information.										**/				
	FIN (wlan_mac_rcv_channel_status_update (int channel_id));
	//printf("intrupt code %s %.15f\n", wlan_name, op_sim_time());
	/* Read the current value of the received power at the	*/
	/* receiver.											*/
	if (op_stat_local_read (channel_id) > rx_power_threshold)
		{
		/* This is the start of the reception of a new		*/
		/* packet. If the receiver was already busy and the	*/
		/* collision flag was not set, then set the			*/
		/* collision flag to true.							*/
		if (!wlan_flags->collision && wlan_flags->receiver_busy)
			{
			wlan_flags->collision = OPC_TRUE;
			
			/* We need to discard the first packet we will	*/
			/* receive from the receiver after this moment	*/
			/* in any case, since it is collided. Hence,	*/
			/* set the corresponding flag.					*/
			wlan_flags->collided_packet = OPC_TRUE;
			}
		
		/* Set the receiver status as busy.					*/
		wlan_flags->receiver_busy = OPC_TRUE;
		}
	
	/* Else a packet reception is complete. Check whether	*/
	/* the receiver became available while it was busy. It	*/
	/* may not have been busy if we were receiving a noise	*/
	/* packet with a weak signal.							*/
	else if (wlan_flags->receiver_busy)
		{
		/* Compare the receiver's reception end time value	*/
		/* with the current time to determine its status.	*/
		if (rx_state_info_ptr->rx_end_time - PRECISION_RECOVERY <= op_sim_time())
			{		
			wlan_flags->receiver_busy = OPC_FALSE;
			wlan_flags->collision = OPC_FALSE;
			}
		}
	FOUT;
	}


/****** Error handling procedure ******/
static void
wlan_mac_error (const char* msg1, const char* msg2, const char* msg3)
	{
	
	/** Terminates simulation with an error message.	**/
	FIN (wlan_mac_error (msg1, msg2, msg3));

	op_sim_end ("Error in Wireless LAN MAC process:", msg1, msg2, msg3);

	FOUT;
	}

static Boolean
wlan_poll_list_member_find (int dest_addr) 
	{
	int		i;

	/** This routine determines whether a given		**/
	/** address is on the polling list.				**/
	FIN (wlan_poll_list_member_find(dest_addr));

	/* if PCF not enabled or not an AP, then don't	*/
	/* use polling list.							*/
	if ((ap_flag == OPC_BOOLINT_DISABLED) || (pcf_flag == OPC_BOOLINT_DISABLED))
		{FRET (OPC_FALSE);}

	/* Send broadcast packets under DCF.			*/ 
	if (dest_addr < 0) {FRET (OPC_FALSE);}

	/* Otherwise, check if address on polling list.	*/
	for (i = 0; i < poll_list_size; i++ )
		{
		if (dest_addr == polling_list [i]) {FRET (OPC_TRUE);}
		if (dest_addr < polling_list [i]) {FRET (OPC_FALSE);}
		}

	/* Destination address is not on polling list.	*/ 
	FRET (OPC_FALSE);				
	}

static int
wlan_hld_list_elem_add_comp (const void* list_elem_ptr1,  const void* list_elem_ptr2)
	{
	WlanT_Hld_List_Elem* 	hld_ptr1;
	WlanT_Hld_List_Elem* 	hld_ptr2;
	
	/* This procedure is used in list processing to sort lists and find members of lists	*/
	/* containing higher layer data packets according to their MAC address destinations.	*/
	/* It returns 1 if hld_ptr1 is at a lower address than hld_ptr2 (closer to list head).	*/
	/* It returns -1 if hld_ptr1 is at a higher address than hld_ptr2 (closer to list tail).*/
	/* It returns 0 if the addresses associated with the two elements are equal.			*/
	FIN (wlan_hld_list_elem_add_comp (list_elem_ptr1, list_elem_ptr2));

	hld_ptr1 = (WlanT_Hld_List_Elem *) list_elem_ptr1;
	hld_ptr2 = (WlanT_Hld_List_Elem *) list_elem_ptr2;
	
	if (hld_ptr1->destination_address > hld_ptr2->destination_address) {FRET (-1);}
	if (hld_ptr1->destination_address < hld_ptr2->destination_address) {FRET (1);}
	else {FRET (0);}
	}

static void
wlan_frame_type_conv(int frame_type, char *frame_type_name) 
	{
	/** This routine converts a frame type to a string containing the type name	**/
	FIN (wlan_frame_type_conv(int frame_type, char *frame_type_name));
	switch (frame_type)
		{
		case WlanC_Beac:
			{
			strcpy (frame_type_name, "beacon");
			break;
			}
		case WlanC_Rts:
			{
			strcpy (frame_type_name, "WLAN RTS");
			break;
			}
		case WlanC_Cts:
			{
			strcpy (frame_type_name, "WLAN CTS");
			break;
			}
		case WlanC_Ack:
			{
			strcpy (frame_type_name, "WLAN ACK");
			break;
			}
		case WlanC_Cf_End:
			{
			strcpy (frame_type_name, "CF-End");
			break;
			}
		case WlanC_Cf_End_A:
			{
			strcpy (frame_type_name, "CF-End+ACK");
			break;
			}
		case WlanC_Data:
			{
			strcpy (frame_type_name, "WLAN Data");
			break;
			}
		case WlanC_Data_Ack:
			{
			strcpy (frame_type_name, "Data+CF-ACK");
			break;
			}
		case WlanC_Data_Poll:
			{
			strcpy (frame_type_name, "Data+CF-Poll");
			break;
			}
		case WlanC_Data_A_P:
			{
			strcpy (frame_type_name, "Data+CF-ACK+CF-Poll");
			break;
			}
		case WlanC_Data_Null:
			{
			strcpy (frame_type_name, "Null (no data)");
			break;
			}
		case WlanC_Cf_Ack:
			{
			strcpy (frame_type_name, "CF-ACK");
			break;
			}
		case WlanC_Cf_Poll:
			{
			strcpy (frame_type_name, "CF-Poll");
			break;
			}
		case WlanC_Cf_A_P:
			{
			strcpy (frame_type_name, "CF-ACK+CF-Poll");
			break;
			}
		case WlanC_None:
			{
			strcpy (frame_type_name, "WlanC_None");
			break;
			}
		default:
			{
			wlan_mac_error ("Unknown frame type: unable to convert to char", OPC_NIL, OPC_NIL);
			break;
			}
		}
	
	FOUT;			
	}


static int
wlan_bss_id_list_manage (int bssid, const char* operation)
	{
	static List*	bss_id_lptr = OPC_NIL;
	static int		list_size   = 0;
	int				low, medium, high;
	Boolean			found;
	int*			list_elem_ptr;
	
	/** This function is responsible with the management of BSS ID list		**/
	/** that is global to all instances of this process model. This list is	**/
	/** used while assigning channels to BSSs to obtain consecutive BSS		**/
	/** indices for efficient assignment of the channels. Since the list is	**/
	/** needed only during the initialization process, it is destroyed in	**/
	/** the last phase of initialization. The function accepts only three	**/
	/** types of operation: "add", "get_index" and "destroy_list". In case	**/
	/** of "get_index" operation, the index of given BSS ID is returned.	**/
	/** For other operations, the return value should be ignored.			**/
	FIN (wlan_bss_id_list_manage (bssid, operation));
	
	/* Perform the requested operation.										*/
	if (strcmp (operation, "destroy_list") == 0)
		{
		/* As requested, destroy the BSS ID list and its elements, which	*/
		/* indicates assignments of channels to BSSs is complete.			*/
		if (bss_id_lptr != OPC_NIL)
			{
			for ( ; list_size > 0; list_size--)
				op_prg_mem_free (op_prg_list_remove (bss_id_lptr, OPC_LISTPOS_HEAD));
		
			op_prg_mem_free (bss_id_lptr);
			bss_id_lptr = OPC_NIL;
			}
		}
	else
		{
		/* Either "add" or "get_index" operation is requested. First create	*/
		/* the list unless it has been already done.						*/
		if (bss_id_lptr == OPC_NIL)
			bss_id_lptr = op_prg_list_create ();
		
		/* Search for the given BSS ID in the list using binary search.		*/
		for (low = 0, high = list_size - 1, found = OPC_FALSE; low <= high && !found; )
			{
			medium = (low + high) / 2;
			list_elem_ptr = (int *) op_prg_list_access (bss_id_lptr, medium);
	
			if (*list_elem_ptr < bssid)
				low = medium + 1;
			else if (*list_elem_ptr > bssid)
				high = medium - 1;
			else
				found = OPC_TRUE;
			}
		
		/* Perform the requested operation using the search results.		*/
		if (strcmp (operation, "add") == 0)
			{
			/* We add the BSS ID into the list if it isn't already there.	*/
			if (!found)
				{
				list_elem_ptr  = (int *) op_prg_mem_alloc (sizeof (int));
				*list_elem_ptr = bssid;
				op_prg_list_insert (bss_id_lptr, list_elem_ptr, low);
				list_size++;
				}
			}
		else if (strcmp (operation, "get_index") == 0)
			{
			/* Return the position of the given BSS ID in the list. If it	*/
			/* is not found, then it is an error condition.					*/
			if (found)
				{
				FRET (medium);
				}
			else
				wlan_mac_error ("Index of an unknown BSS ID requested (internal error).", OPC_NIL, OPC_NIL);
			}
		else
			{
			/* No other operation is expected.								*/
			wlan_mac_error ("Unknown operation on BSS ID list is requested (internal error).", OPC_NIL, OPC_NIL);
			}
		}
	
	/* Unless it is "get_index" operation, the return value is not			*/
	/* important.															*/
	FRET (1);
	}

static PrgT_Mapping_Handle
wlan_bss_mapping_get (void)
	{
	static PrgT_Mapping_Handle	SV_wlan_bss_mapping_hndl;
	static Boolean 				SV_init_done = OPC_FALSE;

	/** Create and store the mapping handle for bss related information.	**/
	/** Used to store the station addresses belonging to each BSS, etc.		**/
	FIN (wlan_bss_mapping_get ())

	/* The first time this function is called, create top-level mapping.	*/
	if (!SV_init_done)
		{
		SV_wlan_bss_mapping_hndl = prg_mapping_create (wlan_bss_info_get_key, wlan_mapping_int_key_compare, wlan_bss_info_free);
		SV_init_done = OPC_TRUE;
		}

	FRET (SV_wlan_bss_mapping_hndl);
	}

static WlanT_Sta_Mapping_Info*
wlan_sta_addr_register (int bssid, int sta_addr, int sta_is_ap)
	{ 
	PrgT_Mapping_Handle 	wlan_bss_mapping_hndl;
	WlanT_Sta_Mapping_Info*	sta_info_ptr;
	WlanT_Bss_Mapping_Info*	bss_info_ptr;

	/** Add the station information to the BSS-based station map.			**/
	FIN (wlan_sta_addr_register (bssid, sta_addr, sta_is_ap));

	/* Get the BSS mapping handle (owned by called function as a static		*/
	/* variable).															*/
	wlan_bss_mapping_hndl = wlan_bss_mapping_get ();

	/* Check if this is the first station being mapping into this BSS.		*/
	bss_info_ptr = (WlanT_Bss_Mapping_Info *) prg_mapping_value_get (wlan_bss_mapping_hndl, &bssid);
	if (bss_info_ptr == PRGC_NIL)
		{
		/* Create the bss information record and store it in the BSS		*/
		/* mapping.															*/
		bss_info_ptr = (WlanT_Bss_Mapping_Info *) op_prg_mem_alloc (sizeof (WlanT_Bss_Mapping_Info));
		bss_info_ptr->bss_idx = bssid;
		bss_info_ptr->sta_mapping_hndl = prg_mapping_create (wlan_sta_info_get_key, wlan_mapping_int_key_compare, wlan_sta_info_free);
		prg_mapping_value_add (wlan_bss_mapping_hndl, bss_info_ptr);
		}

	/* Save the MAC address of the AP for the given BSS.					*/
	if (sta_is_ap == OPC_BOOLINT_ENABLED)
		bss_info_ptr->ap_sta_addr = sta_addr;

	/* Create the station information record and store it in the STA		*/
	/* mapping.																*/
	sta_info_ptr = (WlanT_Sta_Mapping_Info *) op_prg_mem_alloc (sizeof (WlanT_Sta_Mapping_Info));
	sta_info_ptr->sta_addr = sta_addr;
	sta_info_ptr->dup_mapping_hndl = prg_mapping_create (wlan_dup_info_get_key, wlan_mapping_int_key_compare, wlan_dup_info_free);
	prg_mapping_value_add (bss_info_ptr->sta_mapping_hndl, sta_info_ptr);

	FRET (sta_info_ptr);
	}

static int 
wlan_get_ap_sta_addr (int bssid)
	{
	PrgT_Mapping_Handle		wlan_bss_mapping_hndl;
	WlanT_Bss_Mapping_Info*	bss_info_ptr;

	/** This function returns the MAC address of the AP of the given BSS.	**/
	FIN (wlan_get_ap_sta_addr (bssid));

	/* Get the BSS mapping handle (owned by called function as a static		*/
	/* variable).															*/
	wlan_bss_mapping_hndl = wlan_bss_mapping_get ();

	/* Check if this is the first station being mapping into this BSS.		*/
	bss_info_ptr = (WlanT_Bss_Mapping_Info *) prg_mapping_value_get (wlan_bss_mapping_hndl, &bssid);
	if (bss_info_ptr != PRGC_NIL)
		{
		FRET (bss_info_ptr->ap_sta_addr);
		}
	else
		{
		/* Else terminate.													*/
		wlan_mac_error ("Cannot find a BSS record for the given BSS (internal error).", OPC_NIL, OPC_NIL);
		FRET (-1);
		}
	}

static WlanT_Bss_Mapping_Info*
wlan_bss_info_get (int bssid)
	{
	PrgT_Mapping_Handle		wlan_bss_mapping_hndl;
	WlanT_Bss_Mapping_Info*	bss_info_ptr;

	/** This function returns the information record of the BSS whose ID is	**/
	/** provided.															**/
	FIN (wlan_bss_info_get (bssid));

	/* Get the BSS mapping handle (owned by called function as a static		*/
	/* variable).															*/
	wlan_bss_mapping_hndl = wlan_bss_mapping_get ();

	/* Key into the station mapping for this BSS.							*/
	bss_info_ptr = (WlanT_Bss_Mapping_Info *) prg_mapping_value_get (wlan_bss_mapping_hndl, &bssid);
	if (bss_info_ptr != PRGC_NIL)
		{
		/* Return the found information record.								*/
		FRET (bss_info_ptr);
		}
	else
		{
		/* Else terminate with an error message.							*/
		wlan_mac_error ("Cannot find a BSS record for the given BSS (internal error).", OPC_NIL, OPC_NIL);
		FRET (OPC_NIL);
		}
	}

static WlanT_Sta_Mapping_Info*
wlan_sta_info_get (int sta_addr, Boolean serialize)
	{
	WlanT_Sta_Mapping_Info*	sta_info_ptr;

	/** Using mapping lookup, this function checks if a record exists for	**/
	/** the STA under the record of our own BSS. It returns PRGC_NIL if the	**/
	/** STA, whose address provided, does not belong to our BSS.			**/
	FIN (wlan_sta_info_get (bssid, sta_addr, serialize));

	/* If necessary, lock the mutex as a "reader" before accessing global	*/
	/* BSS-STA mapping information.											*/
	if (serialize)
		op_prg_mt_mutex_lock (mapping_info_mutex, OPC_MT_MUTEX_LOCK_READER);
	
	/* Check if the station information record exists in the mapping.		*/
	/* Returns PRGC_NIL if record is not found.								*/
	sta_info_ptr = (WlanT_Sta_Mapping_Info *) prg_mapping_value_get (my_bss_info_ptr->sta_mapping_hndl, &sta_addr);
	
	/* If locked, unlock the global mapping information mutex.				*/
	if (serialize)
		op_prg_mt_mutex_unlock (mapping_info_mutex);

	/* Return the found information record.									*/
	FRET (sta_info_ptr);
	}

static void
wlan_sta_addr_deregister (int bssid, int sta_addr)
	{
	PrgT_Mapping_Handle		wlan_bss_mapping_hndl;
	WlanT_Bss_Mapping_Info*	bss_info_ptr;
	
	/** This function removes the given STA address from the STA list of	**/
	/** the given BSS.														**/
	FIN (wlan_sta_addr_deregister (bssid, sta_addr));

	/* Get a handle to the mapping between BSS ID and BSS information.		*/
	wlan_bss_mapping_hndl = wlan_bss_mapping_get ();

	/* Access the BSS information.											*/
	bss_info_ptr = (WlanT_Bss_Mapping_Info *) prg_mapping_value_get (wlan_bss_mapping_hndl, &bssid);

	/* Remove the station address from the station list of the BSS.			*/
	if (bss_info_ptr != PRGC_NIL)
		prg_mapping_key_remove (bss_info_ptr->sta_mapping_hndl, &sta_addr);
	else
		{
		/* Else terminate.													*/
		wlan_mac_error ("Cannot find a BSS record for the given BSS (internal error).", OPC_NIL, OPC_NIL);		
		}
	
	FOUT;
	}

static double
wlan_min_freq_for_chan (int chan_num)
	{
	double frequency;

	/** This function computes and returns the minimum frequency of the		**/
	/** channel whose channel number is provided.							**/
	FIN (wlan_min_freq_for_chan (int chan_num));
		
	/* Frequencies are centered at 5 MHz intervals starting at 2.412 GHz.	*/
	/* Therefore, the minimum frequency for channel 1 is 2.401 GHz = 		*/
	/* 2.412 - 0.022/2, where 0.022 GHz = 22 MHz is the bandwidth for		*/
	/* 802.11b DSSS PHY (constants used below are defined based on these	*/
	/* values).																*/
	frequency = WLANC_FIRST_CHAN_MIN_FREQ + (chan_num - 1) * WLANC_CHANNEL_SPACING;

	FRET (frequency);
	}

static void
wlan_begin_new_scan (void)
	{
	/** This function switches the node's communication channel to a new	**/
	/** one at least for a short period in order to evaluate the AP of this	**/
	/** channel, if any, for possible connection.							**/
	FIN (wlan_begin_new_scan (void));

	/* Pick new channel so that it is five channels away-- the next 		*/
	/* non-overlapping channel (we first subtract one and then add one		*/
	/* because channel numbers start with 1 not 0).							*/
	channel_num = (channel_num - 1 + WLANC_CH_STEP_FOR_NO_OVERLAP) % WLANC_CHANNEL_COUNT + 1;
		
	/* If we are going to evaluate the new channel by listening to the		*/
	/* Beacons of its AP, configure our transceivers accordingly.			*/
	if (roam_state_ptr->scan_type == WlanC_Scan_Type_Beacon)
		{
		/* Set the transmitter and receiver to this channel.				*/
		wlan_set_transceiver_channel (channel_num);

		/* Initialize the BSS ID and reliability of the AP in this new		*/
		/* channel.															*/
		roam_state_ptr->ap_reliability = WLANC_AP_RELIABILITY_UNKNOWN;
		eval_bss_id = WLANC_BSS_ID_UNKNOWN;
		}
		
	/* Set a timer for slightly over two beacon periods, which will			*/
	/* indicate the end of the evaluation period of the new channel.		*/
	op_intrpt_schedule_self (current_time + beacon_int * WLANC_NEW_SCAN_BEACON_MULT, WlanC_Scan_Timeout);
	
	FOUT;
	}

static void
wlan_set_transceiver_channel (int chan_num)
	{
	double frequency;

	/** Switch the transmitter and receiver to a new frequency channel.		**/
	/** Note that unless the AP is deemed reliable, no transmissions made.	**/
	/** The STA passively listens to the new channel for beacons. 			**/
	FIN (wlan_set_transceiver_channel (int chan_num));
	
	/* Based on the given channel number, determine the lower bound of our	*/
	/* frequency band.														*/
	frequency = wlan_min_freq_for_chan (chan_num);

	/* Configure our transmitter and receiver channels accordingly.			*/
	op_ima_obj_attr_set (txch_objid, "min frequency", frequency);
	op_ima_obj_attr_set (rxch_objid, "min frequency", frequency);

	FOUT;
	}

static void
wlan_ap_switch (void)
	{
	WlanT_Sta_Mapping_Info *ap_info_ptr;

	/** The function performs switching from old BSS/AP to new BSS/AP.		**/
	FIN (wlan_ap_switch (void));

	/* First lock the mutex that manages accessing the global mapping		*/
	/* information between the APs and stations, since we will be updating	*/
	/* this information.													*/
	op_prg_mt_mutex_lock (mapping_info_mutex, OPC_MT_MUTEX_LOCK_WRITER);
	
	/* Remove this STA from the STA list of the old BSS.					*/
	wlan_sta_addr_deregister (bss_id, my_address);

	/* Remove our duplicate information from the STA record of the AP of	*/
	/* the old BSS.															*/
	ap_info_ptr =  wlan_sta_info_get (ap_mac_address, OPC_FALSE);
	prg_mapping_key_remove (ap_info_ptr->dup_mapping_hndl, &my_address);

	/* Update own BSS ID information.										*/
	bss_id = eval_bss_id;
	my_bss_info_ptr = wlan_bss_info_get (bss_id);
	
	/* Also update roaming state for later comparison while evaluating APs.	*/
	roam_state_ptr->current_bss_id = bss_id;
	
	/* Find out the MAC address of our new AP.								*/
	ap_mac_address = wlan_get_ap_sta_addr (bss_id);

	/* Add ourselves to the STA list of our new BSS.						*/
	my_sta_info_ptr = wlan_sta_addr_register (bss_id, my_address, OPC_BOOLINT_DISABLED);
	
	/* Unlock the mutex that we locked at the beginning.					*/
	op_prg_mt_mutex_unlock (mapping_info_mutex);

	FOUT;
	}

static void
wlan_reset_sv (void)
	{
	/** This function is called when the STA joins a new BSS. The state of	**/
	/** the MAC must be reset to ensure that old state does not disrupt the	**/
	/** correct operation of the MAC protocol. 								**/
	FIN (wlan_reset_sv (void));

	/* Reset only those flags that are updated during DCF operation because	*/
	/* roaming is supported only in DCF mode. The only flag that is left	*/
	/* untouched is the receiver busy flag-- this flag should be up-to-date.*/
	wlan_flags->backoff_flag       	= OPC_FALSE;
	wlan_flags->rts_sent		   	= OPC_FALSE;
	wlan_flags->rcvd_bad_packet		= OPC_FALSE;
	wlan_flags->transmitter_busy	= OPC_FALSE;
	wlan_flags->wait_eifs_dur		= OPC_FALSE;
	wlan_flags->immediate_xmt		= OPC_FALSE;
	wlan_flags->forced_bk_end  	    = OPC_FALSE;
	wlan_flags->cw_required			= OPC_FALSE;
	wlan_flags->perform_cw			= OPC_FALSE;
	wlan_flags->nav_updated			= OPC_FALSE;
	wlan_flags->collision			= OPC_FALSE;
	wlan_flags->collided_packet		= OPC_FALSE;
	wlan_flags->duration_zero		= OPC_FALSE;
	wlan_flags->ignore_busy			= OPC_FALSE;
	wlan_flags->tx_beacon			= OPC_FALSE;
	wlan_flags->more_data			= OPC_FALSE;
	wlan_flags->more_frag			= OPC_FALSE;

	/* Initialize retry and back-off slot counts.							*/
	retry_count   = 0;
	backoff_slots = BACKOFF_SLOTS_UNSET;
	
	/* Initialize NAV duration.												*/
	nav_duration = op_sim_time ();
	
	/* Initialize receiver idle timer. 										*/
	rcv_idle_time = op_sim_time ();

	/* Initializing frame response to send to none.							*/
	fresp_to_send = WlanC_None;
	
	/* Initializing expected frame type to none.							*/
	expected_frame_type = WlanC_None;
	 
	FOUT;
	}

static void
wlan_ap_position_publish (void)
	{
	/** This function inserts the location of the surrounding node into the	**/
	/** global list of AP positions. This function is called only by the	**/
	/** MAC that are APs.													**/
	FIN (wlan_ap_position_publish (void));
	
	/* We will need to initialize the global list if not done already.		*/
	if (global_ap_pos_info_lptr == OPC_NIL)
		{
		global_ap_pos_info_lptr = op_prg_list_create ();
		}
		
	/* Insert our location information into the list. 						*/
	op_prg_list_insert (global_ap_pos_info_lptr, conn_ap_pos_info_ptr, OPC_LISTPOS_TAIL);
	
	FOUT;
	}

static void
wlan_ap_eval_virtual (void)
	{
	double distance, ap_rx_pow;
	double	lat, lon, alt, x_pos, y_pos, z_pos;

	/** This function puts the surrounding STA in scan mode if its			**/
	/** distance to the connected AP is greater than a certain threshold.	**/
	FIN (wlan_ap_eval_virtual);

	/* Get current position for comparison with previously cached position. */
	op_ima_obj_pos_get (my_node_objid, &lat, &lon, &alt, &x_pos, &y_pos, &z_pos);

	/* Need to conduct the distance-based check only if the STA has moved.	*/
	if ((roam_state_ptr->lat != lat) || (roam_state_ptr->lon != lon) || (roam_state_ptr->alt != alt))
		{
		/* Position has been changed. Cache new position. 					*/
		roam_state_ptr->lat = lat;
		roam_state_ptr->lon = lon;
		roam_state_ptr->alt = alt;

		/* Check if new distance is greater than acceptable threshold for	*/
		/* connectivity.													*/
		distance = prg_geo_lat_long_distance_get (lat, lon, alt, conn_ap_pos_info_ptr->lat, conn_ap_pos_info_ptr->lon, conn_ap_pos_info_ptr->alt);
		ap_rx_pow = wlan_ap_signal_strength_calc (distance, conn_ap_pos_info_ptr);
		if (ap_rx_pow < WLANC_ROAM_SCAN_START_VIRTUAL_THRESH)
			{
			roam_state_ptr->scan_mode = OPC_TRUE;
			}
		}

	FOUT;
	}

static double 
wlan_ap_signal_strength_calc (double prop_distance, WlanT_AP_Position_Info *ap_info_ptr)
	{
	double lambda, path_loss, rx_power, frequency_mhz;

	/** This functions computes the received power based on the transmit	**/
	/** power of the given AP and given distance.							**/
	FIN (wlan_ap_signal_strength_calc (double prop_distance));

	/* Compute path loss using simple 1/r^2 formula. 						*/
	frequency_mhz = wlan_min_freq_for_chan (channel_num);
	lambda = C / (frequency_mhz * 1.0E+6);
	if (prop_distance > 0.0)
		{
		path_loss = (lambda * lambda) / (SIXTEEN_PI_SQ * prop_distance * prop_distance);
		}
	else
		path_loss = 1.0;

	/* Compute received power. 												*/
	rx_power = ap_info_ptr->tx_power * path_loss;

	FRET (rx_power);
	}

static void 
wlan_find_new_ap_virtual (void)
	{
	int						list_size, list_index;
	WlanT_AP_Position_Info	*ap_info_ptr;
	double					distance, ap_rx_pow;
	double					lat, lon, alt, x_pos, y_pos, z_pos;

	/** Find the first AP that is closer than the acceptable threshold for	**/
	/** a new connection.													**/
	FIN (wlan_find_new_ap_virtual (void));

	/* Get current position for comparison with previously cached position. */
	op_ima_obj_pos_get (my_node_objid, &lat, &lon, &alt, &x_pos, &y_pos, &z_pos);

	/* Check whether our position has changed. 								*/
	if ((roam_state_ptr->lat != lat) || (roam_state_ptr->lon != lon) || (roam_state_ptr->alt != alt))
		{
		/* Position has been changed. Cache the new position. 				*/
		roam_state_ptr->lat = lat;
		roam_state_ptr->lon = lon;
		roam_state_ptr->alt = alt;
		}

	/* Loop over all the APs in the network.								*/
	list_size = op_prg_list_size (global_ap_pos_info_lptr);
	for (list_index = 0; list_index < list_size; list_index++)
		{
		/* Consider only those APs that are on the same channel as our		*/
		/* current channel, which we are scanning.							*/
		ap_info_ptr = (WlanT_AP_Position_Info *) op_prg_list_access (global_ap_pos_info_lptr, list_index);
		if (channel_num != ap_info_ptr->ap_channel_num)
			continue;

		/* Calculate the distance between this STA and an AP from the list. */
		distance = prg_geo_lat_long_distance_get (lat, lon, alt, ap_info_ptr->lat, ap_info_ptr->lon, ap_info_ptr->alt);
		
		/* Compute expected signal strength. 								*/
		ap_rx_pow = wlan_ap_signal_strength_calc (distance, ap_info_ptr);

		/* Pick the first AP that passes the new connection threshold		*/
		/* check. Note that the beacon-based scanning algorithm picks the	*/
		/* first reliable connection. However, the APs picked may not match	*/
		/* in the different methods.                             			*/
		if (ap_rx_pow > WLANC_ROAM_NEW_CONN_VIRTUAL_THRESH)
			{
			/* STA has found a connection-- move it out of scan mode.		*/
			roam_state_ptr->scan_mode = OPC_FALSE;

			/* Update state variables that permit the STA to connect to the	*/
			/* new AP.														*/
			eval_bss_id = ap_info_ptr->ap_bss_id;
			wlan_set_transceiver_channel (channel_num);
			conn_ap_pos_info_ptr = ap_info_ptr;
			
			break;
			}
		}

	FOUT;
	}

/** Callback Functions.			**/	

static void*
wlan_bss_info_get_key (void *value_ptr)
	{
	WlanT_Bss_Mapping_Info *bss_info_ptr;

	/** This function is used as a callback function by prg_mapping			**/
	/** functions. It returns the BSS ID as the key.						**/
	FIN (wlan_bss_info_get_key (void *value_ptr));
	
	bss_info_ptr = (WlanT_Bss_Mapping_Info *) value_ptr;
	
	FRET ((void *) &(bss_info_ptr->bss_idx));
	}

static int
wlan_mapping_int_key_compare (void *key_a_ptr, void *key_b_ptr)
	{
	int *int_key_a_ptr, *int_key_b_ptr;

	/** This function is used as a callback function by prg_mapping			**/
	/** functions. It performs simple comparison of integer keys.			**/
	FIN (wlan_mapping_int_key_compare (void *key_a_ptr, void *key_b_ptr));
	
	int_key_a_ptr = (int *) key_a_ptr;
	int_key_b_ptr = (int *) key_b_ptr;

	FRET (*int_key_a_ptr < *int_key_b_ptr ? 1 : 0);
	}

static void
wlan_bss_info_free (void *value_ptr)
	{
	/** This function is used as a callback function by prg_mapping			**/
	/** functions. It is a dummy memory free function associated with BSS	**/
	/** to stations mapping, which is not expected to be called.			**/
	FIN (wlan_bss_info_free (void *value_ptr));

	op_prg_mem_free (value_ptr);

	FOUT;
	}

static void*
wlan_sta_info_get_key (void *value_ptr)
	{
	WlanT_Sta_Mapping_Info *sta_info_ptr;

	/** This function is used as a callback function by prg_mapping			**/
	/** functions. It returns the MAC address of the STA as the key.		**/
	FIN (wlan_sta_info_get_key (void *value_ptr));
	
	sta_info_ptr = (WlanT_Sta_Mapping_Info *) value_ptr;
	
	FRET ((void *) &(sta_info_ptr->sta_addr));
	}

static void
wlan_sta_info_free (void *value_ptr)
	{
	WlanT_Sta_Mapping_Info *sta_info_ptr;

	/** This function is used as a callback function by prg_mapping			**/
	/** functions. It destroy the STA record kept under BSS-STA mapping		**/
	/** tables.																**/
	FIN (wlan_sta_info_free (void *value_ptr));

	sta_info_ptr = (WlanT_Sta_Mapping_Info *) value_ptr;
	prg_mapping_destroy (sta_info_ptr->dup_mapping_hndl);
	op_prg_mem_free (sta_info_ptr);

	FOUT;
	}

static void*
wlan_dup_info_get_key (void *value_ptr)
	{
	WlanT_Duplicate_Mapping_Info *dup_info_ptr;

	/** This function is used as a callback function by prg_mapping			**/
	/** functions. It returns the MAC address of the sending node as the	**/
	/** key.																**/
	FIN (wlan_dup_info_get_key (void *value_ptr));
	
	dup_info_ptr = (WlanT_Duplicate_Mapping_Info *) value_ptr;
	
	FRET ((void *) &(dup_info_ptr->rem_sta_addr));
	}

static void
wlan_dup_info_free (void *value_ptr)
	{
	WlanT_Duplicate_Mapping_Info *dup_info_ptr;

	/** This function is used as a callback function by prg_mapping			**/
	/** functions. If any, it frees up the tuple information, and deletes	**/
	/** the duplicate record.												**/
	FIN (wlan_dup_info_free (void *value_ptr));

	dup_info_ptr = (WlanT_Duplicate_Mapping_Info *) value_ptr;
	if (dup_info_ptr->duplicate_ptr)
		op_prg_mem_free (dup_info_ptr->duplicate_ptr);

	op_prg_mem_free (value_ptr);

	FOUT;
	}


/* Modifications for LR WPAN model, by Olivier	*/
/* 
 * Modif. Oliv 
 */

static void wlan_print_state_debug (void)
{
	char message[256];
	
	FIN (wlan_print_state_debug ());
	
	switch (op_intrpt_type ())
		{
		case OPC_INTRPT_STAT:
		switch (op_intrpt_stat ())
			{
			case 0:
			sprintf (message, "Power statistic: %.15f W", op_stat_local_read (0));
			break;
			
			case 1:
			sprintf (message, "Busy statistic: %d", (int) op_stat_local_read (1));
			break;
			
			default:
			sprintf (message, "Unknown statistic");
			break;
			}
		break;
		
		case OPC_INTRPT_SELF:
		switch (op_intrpt_code ())
			{
			case WlanC_Deference_Off:
			sprintf (message, "Deference before frame transmission");
			break;
			
			case WlanC_Frame_Timeout:
			sprintf (message, "No frame rcvd in set duration (infer collision)");
			break;
			
			case WlanC_Backoff_Elapsed:
			sprintf (message, "Backoff done before frame transmission");
			break;
			
			case WlanC_CW_Elapsed:
			sprintf (message, "Backoff done after successful frame transmission");
			break;
			
			case WlanC_Beacon_Tx_Time:
			sprintf (message, "Time to transmit beacon frame");
			break;
			
			case WlanC_Cfp_End:
			sprintf (message, "End of the Contention free period");
			break;
			
			case WlanC_Scan_Timeout:
			sprintf (message, "End of scan duration for given channel");
			break;
			
			case WlanC_AP_Check_Timeout:
			sprintf (message, "Time to check the connectivity status with the current AP");
			break;
			
			default:
			sprintf (message, "Unknown code");
			break;
			}
		break;
		
		case OPC_INTRPT_STRM:
		switch (op_intrpt_strm ())
			{
			case 0:
			sprintf (message, "Packet from Physical layer");
			break;
			
			case 1:
			sprintf (message, "Packet from Higher layer");
			break;
			
			default:
			sprintf (message, "Unknown stream");
			break;
			}
		break;
		
		default:
		sprintf (message, "Unknown intrpt");
		break;
		}
	
	/* print out the message */
	//printf ("%s MAC layer: %.15f s: %s\n", wlan_name, op_sim_time (), message);
		
	FOUT;
}
/************  end of modifications  ************/

/* End of Function Block */

/* Undefine optional tracing in FIN/FOUT/FRET */
/* The FSM has its own tracing code and the other */
/* functions should not have any tracing.		  */
#undef FIN_TRACING
#define FIN_TRACING

#undef FOUTRET_TRACING
#define FOUTRET_TRACING

#if defined (__cplusplus)
extern "C" {
#endif
	void custom_wlan_mac (OP_SIM_CONTEXT_ARG_OPT);
	VosT_Obtype custom_wlan_mac_init (int * init_block_ptr);
	VosT_Address custom_wlan_mac_alloc (VOS_THREAD_INDEX_ARG_COMMA VosT_Obtype, int);
	void custom_wlan_mac_diag (OP_SIM_CONTEXT_ARG_OPT);
	void custom_wlan_mac_terminate (OP_SIM_CONTEXT_ARG_OPT);
	void custom_wlan_mac_svar (void *, const char *, void **);


	VosT_Fun_Status Vos_Define_Object (VosT_Obtype * obst_ptr, const char * name, unsigned int size, unsigned int init_obs, unsigned int inc_obs);
	VosT_Address Vos_Alloc_Object_MT (VOS_THREAD_INDEX_ARG_COMMA VosT_Obtype ob_hndl);
	VosT_Fun_Status Vos_Poolmem_Dealloc_MT (VOS_THREAD_INDEX_ARG_COMMA VosT_Address ob_ptr);
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif




/* Process model interrupt handling procedure */


void
custom_wlan_mac (OP_SIM_CONTEXT_ARG_OPT)
	{

#if !defined (VOSD_NO_FIN)
	int _op_block_origin = 0;
#endif
	FIN_MT (custom_wlan_mac ());
	if (1)
		{
		/* variables used for registering and discovering process models */
		OmsT_Pr_Handle			process_record_handle;
		List*					proc_record_handle_list_ptr;
		int						record_handle_list_size;
		int						ap_count;
		double					sta_addr;
		double					statype ;
		Objid					mac_objid;
		Objid					mac_if_module_objid;
		Objid					parent_subnet_objid;
		char					name_str [128];
		Objid					params_attr_objid;
		Objid					wlan_params_comp_attr_objid;
		int						i_cnt,j_cnt, k_cnt;
		int						addr_index;
		WlanT_Hld_List_Elem*	hld_ptr;
		Prohandle				own_prohandle;
		double					timer_duration;
		char					msg1 [256];
		WlanT_Phy_Char_Code		sta_phy_char_flag;
		Boolean					bad_packet_rcvd = OPC_FALSE;
		Boolean					pre_rx_status;
		double					pcf_active;
		int						address;
		int						pcf_enabled_stations;
		Boolean					pcf_enabled_on_AP;
		double					tx_power;
		double					x_pos, y_pos, z_pos;


		FSM_ENTER ("custom_wlan_mac")

		FSM_BLOCK_SWITCH
			{
			/*---------------------------------------------------------*/
			/** state (INIT) enter executives **/
			FSM_STATE_ENTER_UNFORCED_NOLABEL (0, "INIT", "custom_wlan_mac [INIT enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [INIT enter execs], state0_enter_exec)
				{
				/* Initialization of the process model.				*/  
				/* All the attributes are loaded in this routine	*/
				wlan_mac_sv_init (); 
				
				/* Schedule a self interrupt to wait for mac interface 	*/
				/* to move to next state after registering				*/
				op_intrpt_schedule_self (op_sim_time (), 0);
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [INIT enter execs], state0_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (1,"custom_wlan_mac")


			/** state (INIT) exit executives **/
			FSM_STATE_EXIT_UNFORCED (0, "INIT", "custom_wlan_mac [INIT exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [INIT exit execs], state0_exit_exec)
				{
				/* Obtain the process's process handle.					*/
				own_prohandle = op_pro_self ();
				
				/* Obtain the values assigned to the various attributes.*/
				op_ima_obj_attr_get (my_objid, "Wireless LAN Parameters", &wlan_params_comp_attr_objid);
				params_attr_objid = op_topo_child (wlan_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);
				
				/* Modifications for LR WPAN model, by Olivier	*/
				/* get the name of the node */
				op_ima_obj_attr_get_str (my_node_objid, "name", 128, name_str);
				wlan_name = (char *) op_prg_mem_alloc ((strlen(name_str) + 1) * sizeof(char));
				strcpy (wlan_name, name_str);
				/************  end of modifications  ************/
				
				/* Obtain the name of the process.						*/
				op_ima_obj_attr_get (my_objid, "process model", name_str);
				
				/* Determine the assigned MAC address which will be		*/
				/* used for address resolution. Note this is not the	*/
				/* final MAC address as there may be static assignments	*/
				/* in the network.										*/
				op_ima_obj_attr_get (my_objid, "Address", &my_address);
				
				/* Perform auto-addressing for the MAC address. Apart	*/
				/* from dynamically addressing, if auto-assigned, the	*/
				/* address resolution function also detects duplicate	*/
				/* static assignments. The function also initializes 	*/
				/* every MAC address as a valid destination.			*/
				oms_aa_address_resolve (oms_aa_handle, my_objid, &my_address);
				
				/* Modifications for LR WPAN model, by Olivier	*/
				/* registered the node in our custom registration */
				wpan_store_stranger_node (my_address, "wlan", rx_state_info_ptr);
				/************  end of modifications  ************/
				
				/* Register Wlan MAC process in the model wide registry	*/
				own_process_record_handle = (OmsT_Pr_Handle) oms_pr_process_register (my_node_objid, my_objid, own_prohandle, name_str);
				
				/* Initialize the channels of our transmitter and		*/
				/* receiver.											*/
				wlan_transceiver_channel_init ();
				
				/* Initialize a temp variable for station type (AP/STA).*/
				if (ap_flag == OPC_BOOLINT_ENABLED) 
					statype = 1.0;
				else 
					statype = 0.0;
				
				/* Initialize a temp variable for pcf_usage.			*/
				if (pcf_flag == OPC_BOOLINT_ENABLED) 
					pcf_active = 1.0;
				else 
					pcf_active = 0.0;
				
				/* If this station is an access point then it has to be registered as an Access Point.	*/
				/* This is because the network will be treated as Infrastructure network once AP is		*/
				/* detected.																			*/
				if (ap_flag == OPC_BOOLINT_ENABLED)
					{
					/* Allocation of record that stores position information for the AP-- STAs obtain a */
					/* pointer to this record to calculate their distance to the AP for "virtual roam". */
					conn_ap_pos_info_ptr = (WlanT_AP_Position_Info*) op_prg_mem_alloc (sizeof (WlanT_AP_Position_Info));
				
					/* Access and store node position and transmit power. */
					op_ima_obj_pos_get (my_node_objid, &(conn_ap_pos_info_ptr->lat), &(conn_ap_pos_info_ptr->lon),
						&(conn_ap_pos_info_ptr->alt), &x_pos, &y_pos, &z_pos);
					op_ima_obj_attr_get (params_attr_objid, "Transmit Power", &tx_power);
					conn_ap_pos_info_ptr->tx_power = tx_power;
				
					/* Save the BSS ID & channel number in this record-- used when the STA switches to another AP */
					conn_ap_pos_info_ptr->ap_bss_id = bss_id;
					conn_ap_pos_info_ptr->ap_channel_num = channel_num;
				
					oms_pr_attr_set (own_process_record_handle,
						"protocol",				OMSC_PR_STRING,			"mac",
						"mac_type",				OMSC_PR_STRING,			"wireless_lan",
						"subprotocol", 			OMSC_PR_NUMBER,			(double) WLAN_AP,
						"domain_id",			OMSC_PR_NUMBER,			(double) bss_id,
						"subnetid",				OMSC_PR_OBJID,		    my_subnet_objid,
						"ratx_objid",			OMSC_PR_OBJID,			tx_objid,
						"rarx_objid",			OMSC_PR_OBJID,			rx_objid,
						"address",			    OMSC_PR_NUMBER,			(double) my_address,
						"auto address handle",  OMSC_PR_ADDRESS,  	    oms_aa_handle,
						"position record",  	OMSC_PR_ADDRESS,  	    conn_ap_pos_info_ptr,
						"PCF active",			OMSC_PR_NUMBER,			pcf_active,
						OPC_NIL);                                       
					}
				else
					{
				   	oms_pr_attr_set (own_process_record_handle,
						"protocol",				OMSC_PR_STRING,			"mac",
						"mac_type",				OMSC_PR_STRING,			"wireless_lan",
						"subprotocol", 			OMSC_PR_NUMBER,			(double) WLAN_STA,
						"domain_id",			OMSC_PR_NUMBER,		    (double) bss_id,
						"subnetid",				OMSC_PR_OBJID,			my_subnet_objid,
						"ratx_objid",			OMSC_PR_OBJID,			tx_objid,
						"rarx_objid",			OMSC_PR_OBJID,			rx_objid,
						"address",				OMSC_PR_NUMBER,			(double) my_address,
						"auto address handle",	OMSC_PR_ADDRESS,		oms_aa_handle,
						"PCF active",			OMSC_PR_NUMBER,			pcf_active,
						OPC_NIL);                                       
					}
				
				/* Obtain the MAC layer information for the local MAC	*/
				/* process from the model-wide registry.				*/
				/* This is to check if the node is a gateway or not.	*/
				proc_record_handle_list_ptr = op_prg_list_create ();
				
				oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr, 
					"node objid",					OMSC_PR_OBJID,			 my_node_objid,
					"protocol", 					OMSC_PR_STRING, 		 "bridge",
				 	 OPC_NIL);
				
				/* If the MAC interface process registered itself,	*/
				/* then there must be a valid match					*/
				record_handle_list_size = op_prg_list_size (proc_record_handle_list_ptr);
				
				if (record_handle_list_size != 0)
					{
					wlan_flags->bridge_flag = OPC_TRUE;
					}
				
				/* If the station is not a bridge only then check for arp	*/
				if (wlan_flags->bridge_flag == OPC_FALSE)
					{
					/* Deallocate memory used for process discovery	*/
					while (op_prg_list_size (proc_record_handle_list_ptr))
						{
						op_prg_list_remove (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
						}
					op_prg_mem_free (proc_record_handle_list_ptr);
				
					/* Obtain the MAC layer information for the local MAC	*/
					/* process from the model-wide registry.				*/
					proc_record_handle_list_ptr = op_prg_list_create ();
					
					oms_pr_process_discover (my_objid, proc_record_handle_list_ptr, 
						"node objid",			OMSC_PR_OBJID,			my_node_objid,
						"protocol", 			OMSC_PR_STRING,			"arp", 
						OPC_NIL);
				
					/* If the MAC interface process registered itself,	*/
					/* then there must be a valid match					*/
					record_handle_list_size = op_prg_list_size (proc_record_handle_list_ptr);
					}
				
				if (record_handle_list_size != 1)
					{
					/* An error should be created if there are more	*/
					/* than one WLAN-MAC process in the local node,	*/
					/* or if no match is found.						*/
					wlan_mac_error ("Either zero or several WLAN MAC interface processes found in the node.", OPC_NIL, OPC_NIL);
					}
				else
					{
					/*	Obtain a handle on the process record	*/
					process_record_handle = (OmsT_Pr_Handle) op_prg_list_access (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
				
					/* Obtain the module objid for the Wlan MAC Interface module	*/
					oms_pr_attr_get (process_record_handle, "module objid", OMSC_PR_OBJID, &mac_if_module_objid);
				
					/* Obtain the stream numbers connected to and from the	*/
					/* Wlan MAC Interface layer process						*/
					oms_tan_neighbor_streams_find (my_objid, mac_if_module_objid, &instrm_from_mac_if, &outstrm_to_mac_if);
					}
					
				/* Deallocate memory used for process discovery	*/
				while (op_prg_list_size (proc_record_handle_list_ptr))
					{
					op_prg_list_remove (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
					}
				
				op_prg_mem_free (proc_record_handle_list_ptr);
				
				if (wlan_trace_active)
					{
					/* Cache the state name from which this function was	*/
					/* called.												*/
					strcpy (current_state_name, "init");  
					}
				error =0;
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [INIT exit execs], state0_exit_exec)


			/** state (INIT) transition processing **/
			FSM_TRANSIT_FORCE (8, state8_enter_exec, ;, "default", "", "INIT", "BSS_INIT")
				/*---------------------------------------------------------*/



			/** state (IDLE) enter executives **/
			FSM_STATE_ENTER_UNFORCED (1, "IDLE", state1_enter_exec, "custom_wlan_mac [IDLE enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [IDLE enter execs], state1_enter_exec)
				{
				/** The purpose of this state is to wait until the packet has	**/
				/** arrived from the higher or lower layer.					 	**/
				/** In this state following intrpts can occur:				 	**/
				/** 1. Data arrival from application layer   				 	**/
				/** 2. Frame (DATA,ACK,RTS,CTS) rcvd from PHY layer			 	**/
				/** 3. Busy intrpt stating that frame is being rcvd			 	**/
				/** 4. Coll intrpt indicating that more than one frame is rcvd  **/
				/*																*/
				/* When Data arrives from the application layer, insert it in	*/
				/* the queue. If rcvr is not busy then set Deference to DIFS	*/
				/* and Change state to "DEFER" state. Set Backoff flag if the	*/
				/* station needs to backoff.									*/
				/*																*/
				/* Rcvd RTS,CTS,DATA,or ACK (frame rcvd intrpt):				*/
				/* If the frame is destined for this station then send			*/
				/* appropriate response and set deference to SIFS clear the		*/
				/* rcvr busy flag and clamp any data transmission.				*/
				
				/* Modifications for LR WPAN model, by Olivier	*/
				/*
				 * Original statement:
				 *		"if (wlan_trace_active)"
				 * replaced by:
				 *		"if (wlan_trace_active || wlan_state_debug)"
				 */
				if (wlan_trace_active || wlan_state_debug)
					{
					/* Determine the current state name.						*/
					strcpy (current_state_name, "idle");
					
					/* Modif. Oliv */
					ENTER_STATE_PRINT;
					}
				/************  end of modifications  ************/
				
				/* If roaming is enabled on this node, then ensure that			*/
				/* connectivity is checked every few beacon intervals. If the	*/
				/* scan type is "virtual" (where the distance or pathloss to	*/
				/* all AP's are evaluated directly) then AP evaluation is done	*/
				/* if needed whenever any new interrupt is processed. Moreover,	*/
				/* the time at which connectivity to the AP should be next		*/
				/* evaluated is also updated each time this evaluation is		*/
				/* performed. Therefore, we need not update the next evaluation	*/
				/* time. On the other hand, if the scan type is based on 		*/
				/* actual beacon or signal strength evaluation, the next		*/
				/* evaluation time is not updated when new interrupts are		*/
				/* processed. Therefore the next evaluation time must be		*/
				/* updated. See wlan_interrupts_process() for clarification.	*/
				if (roam_state_ptr->enable_roaming) 
					{
					if (roam_state_ptr->scan_type != WlanC_Scan_Type_Distance)
						{
						ap_connectivity_check_time = op_sim_time () + beacon_int * WLANC_CONN_CHK_BEACON_MULT;
						}
					ap_connectivity_check_evhndl = op_intrpt_schedule_self (ap_connectivity_check_time, WlanC_AP_Check_Timeout);
					}
				
				/* Reset the forced backoff end flag that may have been set in	*/
				/* the BACKOFF state under rare, special cases.					*/
				wlan_flags->forced_bk_end = OPC_FALSE;
				
				/* Unlock the mutex that serializes accessing the roaming		*/
				/* related information of this MAC. 							*/
				op_prg_mt_mutex_unlock (roam_state_ptr->roam_info_mutex);
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [IDLE enter execs], state1_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (3,"custom_wlan_mac")


			/** state (IDLE) exit executives **/
			FSM_STATE_EXIT_UNFORCED (1, "IDLE", "custom_wlan_mac [IDLE exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [IDLE exit execs], state1_exit_exec)
				{
				/* Lock the mutex that serializes accessing the roaming related		*/
				/* information of this MAC. 										*/
				op_prg_mt_mutex_lock (roam_state_ptr->roam_info_mutex, 0);
				
				/* Interrupt processing routine.									*/
				wlan_interrupts_process ();
				//printf(" MEDIUM IS IDLE %d READY TO TRANSMIT %d \n", MEDIUM_IS_IDLE, READY_TO_TRANSMIT);
				/* Schedule deference interrupt when there is a frame to transmit	*/
				/* at the stream interrupt and the receiver is not busy				*/
				if (READY_TO_TRANSMIT)
					{
					/* If the medium was idling for a period equal or longer than	*/
					/* DIFS time then we don't need to defer.						*/
					if (MEDIUM_IS_IDLE && !IN_CFP)
						{
						/* We can start the transmission immediately.				*/
						wlan_flags->immediate_xmt = OPC_TRUE;
						backoff_slots = BACKOFF_SLOTS_UNSET;
						}
					
					/* We schedule a deference only for the DCF period. 			*/
					else if (!IN_CFP)
						{
						/* We need to defer. Schedule the end of it.				*/
						wlan_schedule_deference ();
						}
					}
				
				/* If roaming is enabled, there must be a periodic self interrupt scheduled for */
				/* checking connectivity. Cancel this interrupt when exiting this state. */
				if (roam_state_ptr->enable_roaming && op_ev_pending (ap_connectivity_check_evhndl))
					{
					op_ev_cancel (ap_connectivity_check_evhndl);
					}
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [IDLE exit execs], state1_exit_exec)


			/** state (IDLE) transition processing **/
			FSM_PROFILE_SECTION_IN (custom_wlan_mac [IDLE trans conditions], state1_trans_conds)
			FSM_INIT_COND (READY_TO_TRANSMIT && !MEDIUM_IS_IDLE)
			FSM_TEST_COND (READY_TO_TRANSMIT && MEDIUM_IS_IDLE && cfp_ap_medium_control == OPC_FALSE)
			FSM_TEST_COND (AP_DISCONNECTED)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("IDLE")
			FSM_PROFILE_SECTION_OUT (custom_wlan_mac [IDLE trans conditions], state1_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 2, state2_enter_exec, ;, "READY_TO_TRANSMIT && !MEDIUM_IS_IDLE", "", "IDLE", "DEFER")
				FSM_CASE_TRANSIT (1, 4, state4_enter_exec, ;, "READY_TO_TRANSMIT && MEDIUM_IS_IDLE && cfp_ap_medium_control == OPC_FALSE", "", "IDLE", "TRANSMIT")
				FSM_CASE_TRANSIT (2, 9, state9_enter_exec, wlan_begin_new_scan ();, "AP_DISCONNECTED", "wlan_begin_new_scan ()", "IDLE", "SCAN")
				FSM_CASE_TRANSIT (3, 1, state1_enter_exec, ;, "default", "", "IDLE", "IDLE")
				}
				/*---------------------------------------------------------*/



			/** state (DEFER) enter executives **/
			FSM_STATE_ENTER_UNFORCED (2, "DEFER", state2_enter_exec, "custom_wlan_mac [DEFER enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [DEFER enter execs], state2_enter_exec)
				{
				/* This state defer until the medium is available for transmission		*/
				/* interrupts that can occur in this state are:   						*/
				/* 1. Data arrival from application layer         						*/
				/* 2. Frame (DATA,ACK,RTS,CTS) rcvd from PHY layer						*/
				/* 3. Busy intrpt stating that frame is being rcvd						*/
				/* 4. Collision intrpt stating that more than one frame is rcvd    		*/
				/* 5. Deference timer has expired (self intrpt)                    		*/
				/*																		*/
				/* For Data arrival from application layer queue the packet. Set		*/
				/* Backoff flag if the station needs to backoff after deference because	*/
				/* the medium is busy. If the frame is destined for this station then	*/
				/* set frame to respond and set a deference timer to SIFS. Set			*/
				/* deference timer to SIFS and don't change states. If receiver starts	*/
				/* receiving more than one frame then flag the received frame as		*/
				/* invalid frame and set a deference to EIFS.							*/
				
				/* Modifications for LR WPAN model, by Olivier	*/
				/*
				 * Original statement:
				 *		"if (wlan_trace_active)"
				 * replaced by:
				 *		"if (wlan_trace_active || wlan_state_debug)"
				 */
				if (wlan_trace_active || wlan_state_debug /* Modif. Oliv */)
					{
					/* Determine the current state name.								*/
					strcpy (current_state_name, "defer");
					
					/* Modif. Oliv */
					ENTER_STATE_PRINT;
					}
				/************  end of modifications  ************/
				
				/* If in CFP, schedule a deference interrupt if not already scheduled.	*/ 
				if ((cfp_ap_medium_control == OPC_TRUE || wlan_flags->pcf_active == OPC_TRUE) &&
					op_ev_valid (deference_evh) != OPC_TRUE)
					{
					wlan_schedule_deference ();
					}
				
				
				/* Unlock the mutex that serializes accessing the roaming related		*/
				/* information of this MAC. 											*/
				op_prg_mt_mutex_unlock (roam_state_ptr->roam_info_mutex);
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [DEFER enter execs], state2_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (5,"custom_wlan_mac")


			/** state (DEFER) exit executives **/
			FSM_STATE_EXIT_UNFORCED (2, "DEFER", "custom_wlan_mac [DEFER exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [DEFER exit execs], state2_exit_exec)
				{
				/* Lock the mutex that serializes accessing the roaming related		*/
				/* information of this MAC. 										*/
				op_prg_mt_mutex_lock (roam_state_ptr->roam_info_mutex, 0);
				
				/* Store the previous receiver status before processing the			*/
				/* interrupt, which may change the status information.				*/
				pre_rx_status = wlan_flags->receiver_busy;
				
				/* Call the interrupt processing routine for each interrupt.		*/
				wlan_interrupts_process ();
				
				if (wlan_flags->ignore_busy == OPC_FALSE)
					{
					/* If the receiver is busy while the station is deferring		*/
					/* then clear the self interrupt. As there will be a new self	*/ 
					/* interrupt generated once the receiver becomes idle again.  	*/
					if (RECEIVER_BUSY_HIGH && (op_ev_valid (deference_evh) == OPC_TRUE))
						{
						op_ev_cancel (deference_evh);
						}
				
					/* Update the value of the temporary bad packet flag, which is	*/
					/* used in the FRAME_RCVD macro below.							*/
					bad_packet_rcvd = wlan_flags->rcvd_bad_packet;
				
					/* If the receiver became idle again schedule the end of the	*/
					/* deference.													*/
					if (RECEIVER_BUSY_LOW && pre_rx_status != OPC_FALSE)
						wlan_schedule_deference ();
				
					/* While we were deferring, if we receive a frame which			*/
					/* requires a response, or we had used EIFS due to a pervious 	*/
					/* error, then we need to re-schedule our end of				*/
					/* deference interrupt, since the deference time for response	*/
					/* frames is shorter. Similarly, we need to re-schedule it if	*/
					/* the received frame made us set our NAV to a higher value.	*/
					else if (FRAME_RCVD && 
							 (fresp_to_send != WlanC_None || wlan_flags->nav_updated == OPC_TRUE || 
							  ((wlan_flags->wait_eifs_dur == OPC_TRUE && IN_CFP) || wlan_flags->polled == OPC_TRUE)) && 
							 op_ev_valid (deference_evh) == OPC_TRUE)
						{
						/* Cancel the current event and schedule a new one.			*/
						op_ev_cancel (deference_evh);
						wlan_schedule_deference ();
						}
					
					/* Similarly if we received a self interrupt that indicates the	*/
					/* time to send a Beacon frame, and if we are deferring for the	*/
					/* transmission of a frame that is different then ACK frame,	*/
					/* then we need to reschedule the deference interrupt since the	*/
					/* Beacon frame will have priority over that frame, and a		*/
					/* different waiting time for deference.						*/
					else if (intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanC_Beacon_Tx_Time && fresp_to_send != WlanC_Ack &&
						     op_ev_valid (deference_evh) == OPC_TRUE)
						{
						/* Cancel the current event and schedule a new one.			*/
						op_ev_cancel (deference_evh);
						wlan_schedule_deference ();
						}
					}
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [DEFER exit execs], state2_exit_exec)


			/** state (DEFER) transition processing **/
			FSM_PROFILE_SECTION_IN (custom_wlan_mac [DEFER trans conditions], state2_trans_conds)
			FSM_INIT_COND (DEFERENCE_OFF)
			FSM_TEST_COND (IDLE_AFTER_CFP)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("DEFER")
			FSM_PROFILE_SECTION_OUT (custom_wlan_mac [DEFER trans conditions], state2_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 3, state3_enter_exec, ;, "DEFERENCE_OFF", "", "DEFER", "BKOFF_NEEDED")
				FSM_CASE_TRANSIT (1, 1, state1_enter_exec, CANCEL_DEF_EVENT;;, "IDLE_AFTER_CFP", "CANCEL_DEF_EVENT;", "DEFER", "IDLE")
				FSM_CASE_TRANSIT (2, 2, state2_enter_exec, ;, "default", "", "DEFER", "DEFER")
				}
				/*---------------------------------------------------------*/



			/** state (BKOFF_NEEDED) enter executives **/
			FSM_STATE_ENTER_FORCED (3, "BKOFF_NEEDED", state3_enter_exec, "custom_wlan_mac [BKOFF_NEEDED enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [BKOFF_NEEDED enter execs], state3_enter_exec)
				{
				/** In this state we determine whether a back-off is necessary for the	**/
				/** frame we are trying to transmit. It is needed when station			**/
				/** preparing to transmit frame discovers that the medium is busy or	**/
				/** when the the station infers collision. Backoff is not needed when	**/
				/** the station is responding to the frame. Following a successful		**/
				/** packet transmission, again a back-off procedure is performed for a	**/
				/** contention window period as stated in 802.11 standard.				**/
				/**																		**/
				/** If backoff needed then check whether the station completed its 		**/
				/** backoff in the last attempt. If not then resume the backoff 		**/
				/** from the same point, otherwise generate a new random number 	 	**/
				/** for the number of backoff slots. 									**/
				/* Checking whether backoff is needed or not.							*/ 
				if (wlan_flags->backoff_flag == OPC_TRUE || wlan_flags->perform_cw == OPC_TRUE)
					{
					if (backoff_slots == BACKOFF_SLOTS_UNSET)
						{                                                             
						/* Compute backoff interval using binary exponential process.	*/
						/* After a successful transmission we always use cw_min.		*/
						if (retry_count == 0 || wlan_flags->perform_cw == OPC_TRUE)
							{			 
							/* If retry count is set to 0 then set the maximum backoff	*/
							/* slots to min window size.								*/	
							max_backoff = cw_min;
							}
						else
							{
							/* We are retransmitting. Increase the back-off window		*/
							/* size.													*/
							max_backoff = max_backoff * 2 + 1; 				
							}
				
						/* The number of possible slots grows exponentially until it	*/
						/* exceeds a fixed limit.										*/
						if (max_backoff > cw_max) 
							{
							max_backoff = cw_max;
							}
				 
						/* Obtain a uniformly distributed random integer between 0 and	*/
						/* the minimum contention window size. Scale the number of		*/
						/* slots according to the number of retransmissions.			*/
						backoff_slots = floor (op_dist_uniform (max_backoff + 1));
						}
				
					/* Set a timer for the end of the backoff interval.					*/
					intrpt_time = (current_time + backoff_slots * slot_time);
					
					/* Scheduling self interrupt for backoff.							*/
					if (wlan_flags->perform_cw == OPC_TRUE)
						backoff_elapsed_evh = op_intrpt_schedule_self (intrpt_time, WlanC_CW_Elapsed);
					else
						backoff_elapsed_evh = op_intrpt_schedule_self (intrpt_time, WlanC_Backoff_Elapsed);
					
					/* Reporting number of backoff slots as a statistic.				*/
					op_stat_write (backoff_slots_handle, backoff_slots);
					} 
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [BKOFF_NEEDED enter execs], state3_enter_exec)

			/** state (BKOFF_NEEDED) exit executives **/
			FSM_STATE_EXIT_FORCED (3, "BKOFF_NEEDED", "custom_wlan_mac [BKOFF_NEEDED exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [BKOFF_NEEDED exit execs], state3_exit_exec)
				{
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [BKOFF_NEEDED exit execs], state3_exit_exec)


			/** state (BKOFF_NEEDED) transition processing **/
			FSM_PROFILE_SECTION_IN (custom_wlan_mac [BKOFF_NEEDED trans conditions], state3_trans_conds)
			FSM_INIT_COND (TRANSMIT_FRAME)
			FSM_TEST_COND (PERFORM_BACKOFF)
			FSM_TEST_LOGIC ("BKOFF_NEEDED")
			FSM_PROFILE_SECTION_OUT (custom_wlan_mac [BKOFF_NEEDED trans conditions], state3_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 4, state4_enter_exec, ;, "TRANSMIT_FRAME", "", "BKOFF_NEEDED", "TRANSMIT")
				FSM_CASE_TRANSIT (1, 5, state5_enter_exec, ;, "PERFORM_BACKOFF", "", "BKOFF_NEEDED", "BACKOFF")
				}
				/*---------------------------------------------------------*/



			/** state (TRANSMIT) enter executives **/
			FSM_STATE_ENTER_UNFORCED (4, "TRANSMIT", state4_enter_exec, "custom_wlan_mac [TRANSMIT enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [TRANSMIT enter execs], state4_enter_exec)
				{
				/** In this state following intrpts can occur:     				**/
				/** 1. Data arrival from application layer.			        	**/
				/** 2. Frame (DATA,ACK,RTS,CTS) rcvd from PHY layer.			**/
				/** 3. Busy intrpt stating that frame is being rcvd.			**/
				/** 4. Collision intrpt means more than one frame is rcvd.  	**/
				/** 5. Transmission completed intrpt from physical layer		**/
				/** Queue the packet for Data Arrival from the higher layer,	**/
				/** and do not change state.									**/
				/** After Transmission is completed change state to FRM_END		**/
				/** No response is generated for any lower layer packet arrival	**/
				
				/* Prepare transmission frame by setting appropriate	*/
				/* fields in the control/data frame.					*/ 
				/* Skip this routine if any frame is received from the	*/
				/* higher or lower layer(s)		*/
				if (wlan_flags->immediate_xmt == OPC_TRUE)
					{
					/* Initialize the contention window size for the 	*/
					/* packets that are sent without backoff for the 	*/
					/* first time, if in case they are retransmitted.	*/
					max_backoff = cw_min;
					
					/* Start the transmission.							*/
					wlan_frame_transmit ();
					
					/* Reset the immediate transmission flag.			*/
					wlan_flags->immediate_xmt = OPC_FALSE;
					}
				
				else if (wlan_flags->rcvd_bad_packet == OPC_FALSE && intrpt_type == OPC_INTRPT_SELF)  
					{
					/* If it is a PCF enabled MAC then make sure that	*/
					/* the interrupt was not PCF related. Start the		*/
					/* transmission, if the delivered self interrupt is	*/
					/* an interrupt that was just brought us into this	*/
					/* state.											*/
					if ((pcf_flag == OPC_BOOLINT_DISABLED || intrpt_code == WlanC_Deference_Off || 
						intrpt_code == WlanC_Backoff_Elapsed || intrpt_code == WlanC_CW_Elapsed) && 
						!(intrpt_code == WlanC_Beacon_Tx_Time || intrpt_code == WlanC_AP_Check_Timeout))
						{
						wlan_frame_transmit ();
						
						/* Check whether the forced transmission (end	*/
						/* of backoff) flag is set.						*/
						if (wlan_flags->forced_bk_end == OPC_TRUE)
							{
							/* Reset the flag.							*/
							wlan_flags->forced_bk_end = OPC_FALSE;
							
							/* This flag indicates a rare case: at the	*/
							/* exact time when we completed our backoff	*/
							/* and started our transmission, we also	*/
							/* started receiving a packet. Hence, mark	*/
							/* the currently being received packet as a	*/
							/* bad packet.								*/
							wlan_flags->rcvd_bad_packet = OPC_TRUE;
							}
						}
					}
				
				/* Modifications for LR WPAN model, by Olivier	*/
				/*
				 * Original statement:
				 *		"if (wlan_trace_active)"
				 * replaced by:
				 *		"if (wlan_trace_active || wlan_state_debug)"
				 */
				if (wlan_trace_active || wlan_state_debug /* Modif. Oliv */)
					{
					/* Determine the current state name.				*/
					strcpy (current_state_name, "transmit");
					
					/* Modif. Oliv */
					ENTER_STATE_PRINT;
					}
				/************  end of modifications  ************/
				
				/* Unlock the mutex that serializes accessing the		*/
				/* roaming related information of this MAC. 			*/
				op_prg_mt_mutex_unlock (roam_state_ptr->roam_info_mutex);
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [TRANSMIT enter execs], state4_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (9,"custom_wlan_mac")


			/** state (TRANSMIT) exit executives **/
			FSM_STATE_EXIT_UNFORCED (4, "TRANSMIT", "custom_wlan_mac [TRANSMIT exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [TRANSMIT exit execs], state4_exit_exec)
				{
				/* Lock the mutex that serializes accessing the roaming		*/
				/* related information of this MAC. 						*/
				op_prg_mt_mutex_lock (roam_state_ptr->roam_info_mutex, 0);
				
				/* If the packet is received while the the station is      	*/ 
				/* transmitting then mark the received packet as bad.	   	*/
				if (op_intrpt_type () == OPC_INTRPT_STAT)
					{
					intrpt_code = (WlanT_Mac_Intrpt_Code)op_intrpt_stat ();
					if (intrpt_code < TRANSMITTER_BUSY_INSTAT && op_stat_local_read (intrpt_code) > rx_power_threshold && !wlan_flags->receiver_busy)
						{	
						wlan_flags->rcvd_bad_packet = OPC_TRUE;
						}
					
					/* If we completed the transmission then reset the		*/
					/* transmitter flag.									*/
					else if (intrpt_code == TRANSMITTER_BUSY_INSTAT)
						{
						wlan_flags->transmitter_busy = OPC_FALSE;
						
						/* Also reset the receiver idle time, since with	*/
						/* the end of our transmission, we expect that the	*/
						/* medium became idle again (but make sure we are	*/
						/* also not receiving a packet).					*/
						if (!wlan_flags->receiver_busy)
							{
							rcv_idle_time = op_sim_time ();
							}
						}
					}
				
				else if ((op_intrpt_type () == OPC_INTRPT_STRM) && (op_intrpt_strm () != instrm_from_mac_if))
					{
					/* While transmitting, we received a packet from		*/
					/* physical layer. Mark the packet as bad.				*/
					wlan_flags->rcvd_bad_packet = OPC_TRUE;
					}
				
				/* Call the interrupt processing routine for each interrupt.*/
				wlan_interrupts_process ();
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [TRANSMIT exit execs], state4_exit_exec)


			/** state (TRANSMIT) transition processing **/
			FSM_PROFILE_SECTION_IN (custom_wlan_mac [TRANSMIT trans conditions], state4_trans_conds)
			FSM_INIT_COND (TRANSMISSION_COMPLETE)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("TRANSMIT")
			FSM_PROFILE_SECTION_OUT (custom_wlan_mac [TRANSMIT trans conditions], state4_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 6, state6_enter_exec, ;, "TRANSMISSION_COMPLETE", "", "TRANSMIT", "FRM_END")
				FSM_CASE_TRANSIT (1, 4, state4_enter_exec, ;, "default", "", "TRANSMIT", "TRANSMIT")
				}
				/*---------------------------------------------------------*/



			/** state (BACKOFF) enter executives **/
			FSM_STATE_ENTER_UNFORCED (5, "BACKOFF", state5_enter_exec, "custom_wlan_mac [BACKOFF enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [BACKOFF enter execs], state5_enter_exec)
				{
				/** Processing Random Backoff								**/
				/** In this state following intrpts can occur: 				**/
				/** 1. Data arrival from application layer   				**/
				/** 2. Frame (DATA,ACK,RTS,CTS) rcvd from PHY layer			**/
				/** 3. Busy intrpt stating that frame is being rcvd			**/
				/** 4. Coll intrpt stating that more than one frame is rcvd	**/  
				/** Queue the packet for Data Arrival from application 		**/
				/** layer and do not change the state.						**/ 
				/** If the frame is destined for this station then prepare  **/
				/** appropriate frame to respond and set deference to SIFS	**/
				/** Update NAV value (if needed) and reschedule deference	**/
				/** Change state to "DEFER"									**/
				/** If it's a broadcast frame then check whether NAV needs 	**/
				/** to be updated. Schedule self interrupt and change		**/
				/** state to Deference										**/
				/** If rcvr start receiving frame (busy stat intrpt) then 	**/
				/** set a flag indicating rcvr is busy. 					**/ 
				/** if rcvr start receiving more than one frame then flag 	**/ 
				/** the rcvd frame as invalid and set deference				**/
				/** timer to EIFS   										**/ 
				/* Change State to DEFER									**/
				
				/* Modifications for LR WPAN model, by Olivier	*/
				/*
				 * Original statement:
				 *		"if (wlan_trace_active)"
				 * replaced by:
				 *		"if (wlan_trace_active || wlan_state_debug)"
				 */
				if (wlan_trace_active || wlan_state_debug /* Modif. Oliv */)
					{
					/* Determine the current state name.					*/
					strcpy (current_state_name, "backoff");
					
					/* Modif. Oliv */
					ENTER_STATE_PRINT;
					}
				/************  end of modifications  ************/
				
				/* Unlock the mutex that serializes accessing the roaming	*/
				/* related information of this MAC. 						*/
				op_prg_mt_mutex_unlock (roam_state_ptr->roam_info_mutex);
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [BACKOFF enter execs], state5_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (11,"custom_wlan_mac")


			/** state (BACKOFF) exit executives **/
			FSM_STATE_EXIT_UNFORCED (5, "BACKOFF", "custom_wlan_mac [BACKOFF exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [BACKOFF exit execs], state5_exit_exec)
				{
				/* Lock the mutex that serializes accessing the roaming related		*/
				/* information of this MAC. 										*/
				op_prg_mt_mutex_lock (roam_state_ptr->roam_info_mutex, 0);
				
				/* Call the interrupt processing routine for each interrupt.		*/
				wlan_interrupts_process ();
				
				/* Set the number of slots to zero, once the backoff is completed.	*/
				if (BACKOFF_COMPLETED)
					{
					backoff_slots = BACKOFF_SLOTS_UNSET;
					}
				else if (CW_COMPLETED)
					{
					backoff_slots = BACKOFF_SLOTS_UNSET;
					
					/* Reset the contention window flags to enable future			*/
					/* transmissions.												*/
					wlan_flags->cw_required = OPC_FALSE;
					wlan_flags->perform_cw  = OPC_FALSE;
					}
				
				/* Pause the backoff procedure if our receiver just became busy or	*/
				/* if we received a self interrupt indicating the time to send a	*/
				/* Beacon frame for a new contention free period.					*/
				if (RECEIVER_BUSY_HIGH || (!wlan_flags->receiver_busy && intrpt_type == OPC_INTRPT_SELF && intrpt_code == WlanC_Beacon_Tx_Time)) 
					{
					/* Computing remaining backoff slots for next iteration.		*/
					backoff_slots =  ceil ((intrpt_time - current_time - PRECISION_RECOVERY) / slot_time);
					
					/* Don't cancel the end-of-backoff interrupt if we have already	*/
					/* completed all the slots of the back-off.						*/
					if (op_ev_valid (backoff_elapsed_evh) == OPC_TRUE && (backoff_slots > 0.0 || !RECEIVER_BUSY_HIGH))
						{
						/* Clear the self interrupt as station needs to defer.		*/
						op_ev_cancel (backoff_elapsed_evh);
						
						/* Disable perform cw flag because the station will not		*/
						/* backoff using contention window.							*/
						wlan_flags->perform_cw  = OPC_FALSE;
						}
				
					/* If the remaining backoff slots were computed as "0" slot		*/
					/* then we are experiencing a special case: we started 			*/
					/* receiving a transmission at the exact same time when we will	*/
					/* complete our backoff and start our own transmission. In such	*/
					/* cases we ignore the reception and continue with our planned	*/
					/* transmission for the accuracy of the simulation model,		*/
					/* because these two events are happening at the exact same		*/
					/* time and	their execution order should not change the overall	*/
					/* behavior of the MAC. Similarly, this will take us to IDLE	*/
					/* state in the next interrupt, if the reception started at the	*/
					/* exact time when we would complete our CW period and move		*/
					/* back to IDLE because of empty high layer buffer.				*/
					if (backoff_slots == 0.0)
						wlan_flags->forced_bk_end = OPC_TRUE;
					}
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [BACKOFF exit execs], state5_exit_exec)


			/** state (BACKOFF) transition processing **/
			FSM_PROFILE_SECTION_IN (custom_wlan_mac [BACKOFF trans conditions], state5_trans_conds)
			FSM_INIT_COND (PERFORM_TRANSMIT)
			FSM_TEST_COND (BACK_TO_DEFER)
			FSM_TEST_COND (BACK_TO_IDLE)
			FSM_TEST_COND (SCAN_AFTER_CW)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("BACKOFF")
			FSM_PROFILE_SECTION_OUT (custom_wlan_mac [BACKOFF trans conditions], state5_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 4, state4_enter_exec, ;, "PERFORM_TRANSMIT", "", "BACKOFF", "TRANSMIT")
				FSM_CASE_TRANSIT (1, 2, state2_enter_exec, wlan_schedule_deference ();;, "BACK_TO_DEFER", "wlan_schedule_deference ();", "BACKOFF", "DEFER")
				FSM_CASE_TRANSIT (2, 1, state1_enter_exec, ;, "BACK_TO_IDLE", "", "BACKOFF", "IDLE")
				FSM_CASE_TRANSIT (3, 9, state9_enter_exec, wlan_begin_new_scan ();, "SCAN_AFTER_CW", "wlan_begin_new_scan ()", "BACKOFF", "SCAN")
				FSM_CASE_TRANSIT (4, 5, state5_enter_exec, ;, "default", "", "BACKOFF", "BACKOFF")
				}
				/*---------------------------------------------------------*/



			/** state (FRM_END) enter executives **/
			FSM_STATE_ENTER_FORCED (6, "FRM_END", state6_enter_exec, "custom_wlan_mac [FRM_END enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [FRM_END enter execs], state6_enter_exec)
				{
				/** The purpose of this state is to determine the next unforced	**/
				/** state after completing transmission.					    **/
				 
				/** 3 cases											     		**/
				/** 1.If just transmitted RTS or DATA frame then wait for 	 	**/
				/** response with expected_frame_type variable set and change   **/
				/** the states to Wait for Response otherwise just DEFER for 	**/
				/** next transmission											**/
				/** 2.If expected frame is rcvd then check to see what is the	**/
				/** next frame to transmit and set appropriate deference timer	**/
				/** 2a.If all the data fragments are transmitted then check		**/
				/** whether the queue is empty or not                           **/
				/** If not then based on threshold fragment the packet 	 		**/
				/** and based on threshold decide whether to send RTS or not   	**/
				/** If there is a data to be transmitted then wait for DIFS		**/
				/**	duration before contending for the channel					**/
				/** If nothing to transmit then go to IDLE state          		**/
				/** and wait for the packet arrival from higher or lower layer	**/
				/** 3.If expected frame is not rcvd then infer collision, 		**/
				/** set backoff flag, if retry limit is not reached       		**/
				/** retransmit the frame by contending for the channel  	 	**/
				
				/* If there is no frame expected then check to see if there		*/
				/* is any other frame to transmit.								*/
				
				if (expected_frame_type == WlanC_None) 
					{
					/* If the frame needs to be retransmitted or there is   	*/
					/* something in the fragmentation buffer to transmit or the	*/
					/* station needs to respond to a frame then schedule		*/
					/* deference.												*/
					if (FRAME_TO_TRANSMIT)
						{
						/* Schedule deference before frame transmission.		*/
						wlan_schedule_deference ();
						}
					}
				else
					{
					/* The station needs to wait for the expected frame type	*/
					/* So it will set the frame timeout interrupt which will be	*/
				    /* executed if no frame is received in the set duration.   	*/
					
					/* Compute the timer duration. It is PIFS if we are an AP	*/
					/* and currently in CFP. For all other cases, the timer		*/
					/* duration is equal to "EIFS - DIFS", which is SIFS + ACK	*/
				 	/* transmission time with PLCP header.						*/
					if (ap_flag == OPC_BOOLINT_ENABLED && wlan_flags->pcf_active)
						timer_duration = pifs_time;
					else
						timer_duration = sifs_time + plcp_overhead_control + WLAN_ACK_DURATION;
					
					/* Schedule the timeout interrupt.							*/
					frame_timeout_evh = op_intrpt_schedule_self (current_time + timer_duration, WlanC_Frame_Timeout);
					}
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [FRM_END enter execs], state6_enter_exec)

			/** state (FRM_END) exit executives **/
			FSM_STATE_EXIT_FORCED (6, "FRM_END", "custom_wlan_mac [FRM_END exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [FRM_END exit execs], state6_exit_exec)
				{
				
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [FRM_END exit execs], state6_exit_exec)


			/** state (FRM_END) transition processing **/
			FSM_PROFILE_SECTION_IN (custom_wlan_mac [FRM_END trans conditions], state6_trans_conds)
			FSM_INIT_COND (FRM_END_TO_IDLE)
			FSM_TEST_COND (WAIT_FOR_FRAME)
			FSM_TEST_COND (FRM_END_TO_DEFER)
			FSM_TEST_LOGIC ("FRM_END")
			FSM_PROFILE_SECTION_OUT (custom_wlan_mac [FRM_END trans conditions], state6_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 1, state1_enter_exec, ;, "FRM_END_TO_IDLE", "", "FRM_END", "IDLE")
				FSM_CASE_TRANSIT (1, 7, state7_enter_exec, ;, "WAIT_FOR_FRAME", "", "FRM_END", "WAIT_FOR_RESPONSE")
				FSM_CASE_TRANSIT (2, 2, state2_enter_exec, ;, "FRM_END_TO_DEFER", "", "FRM_END", "DEFER")
				}
				/*---------------------------------------------------------*/



			/** state (WAIT_FOR_RESPONSE) enter executives **/
			FSM_STATE_ENTER_UNFORCED (7, "WAIT_FOR_RESPONSE", state7_enter_exec, "custom_wlan_mac [WAIT_FOR_RESPONSE enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [WAIT_FOR_RESPONSE enter execs], state7_enter_exec)
				{
				/** The purpose of this state is to wait for the response after	**/
				/** transmission. The only frames which require					**/
				/** acknowledgements are RTS and DATA frame. 					**/
				/** In this state following intrpts can occur:				   	**/
				/** 1. Data arrival from application layer   					**/
				/** 2. Frame (DATA,ACK,RTS,CTS) rcvd from PHY layer				**/
				/** 3. Frame timeout if expected frame is not rcvd 				**/
				/** 4. Busy intrpt stating that frame is being rcvd           	**/
				/** 5. Collision intrpt stating that more than one frame is rcvd**/		
				/** Queue the packet as Data Arrives from application layer		**/
				/** If Rcvd unexpected frame then collision is inferred and		**/
				/** retry count is incremented							    	**/
				/** if a collision stat interrupt from the rcvr then flag the   **/
				/** received frame as bad 										**/
				
				/* Modifications for LR WPAN model, by Olivier	*/
				/*
				 * Original statement:
				 *		"if (wlan_trace_active)"
				 * replaced by:
				 *		"if (wlan_trace_active || wlan_state_debug)"
				 */
				if (wlan_trace_active || wlan_state_debug /* Modif. Oliv */)
					{
					/* Determine the current state name.						*/
					strcpy (current_state_name, "wait_for_response");
					
					/* Modif. Oliv */
					ENTER_STATE_PRINT;
					}
				/************  end of modifications  ************/
				
				/* Unlock the mutex that serializes accessing the roaming		*/
				/* related information of this MAC. 							*/
				op_prg_mt_mutex_unlock (roam_state_ptr->roam_info_mutex);
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [WAIT_FOR_RESPONSE enter execs], state7_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (15,"custom_wlan_mac")


			/** state (WAIT_FOR_RESPONSE) exit executives **/
			FSM_STATE_EXIT_UNFORCED (7, "WAIT_FOR_RESPONSE", "custom_wlan_mac [WAIT_FOR_RESPONSE exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [WAIT_FOR_RESPONSE exit execs], state7_exit_exec)
				{
				/* Lock the mutex that serializes accessing the roaming related	*/
				/* information of this MAC. 									*/
				op_prg_mt_mutex_lock (roam_state_ptr->roam_info_mutex, 0);
				
				/* First restore the value of the bad packet received flag		*/
				/* since we will use it also in the state transition decision.	*/
				bad_packet_rcvd = wlan_flags->rcvd_bad_packet;
				
				/* Determine the interrupt type and the stream index in the		*/
				/* case of stream interrupt, since this information will be		*/
				/* in the next if statement condition.							*/
				intrpt_type = op_intrpt_type ();
				if (intrpt_type == OPC_INTRPT_STRM)
					i_strm = op_intrpt_strm ();
				
				/* Clear the frame timeout interrupt once the receiver is busy	*/
				/* or the frame is received (in case of collisions, the			*/
				/* frames whose reception has started while we were				*/
				/* transmitting are excluded in the FRAME_RCVD macro).			*/
				if (((intrpt_type == OPC_INTRPT_STAT && op_intrpt_stat () < TRANSMITTER_BUSY_INSTAT && 
					  op_stat_local_read (op_intrpt_stat ()) > rx_power_threshold && !wlan_flags->receiver_busy) ||
					 FRAME_RCVD) &&
					(op_ev_valid (frame_timeout_evh) == OPC_TRUE))
					{
					op_ev_cancel (frame_timeout_evh);
					}
				
				/* Call the interrupt processing routine for each interrupt		*/
				/* request.														*/
				wlan_interrupts_process ();
				
				/* If expected frame is not received in the set duration or the	*/
				/* there is a collision at the receiver then set the expected	*/
				/* frame type to be none because the station needs to			*/
				/* retransmit the frame.									 	*/
				if (FRAME_TIMEOUT)
					{
					/* Setting expected frame type to none frame.				*/
					expected_frame_type = WlanC_None;
					
					/* Set the flag that indicates collision.					*/
					wlan_flags->wait_eifs_dur = OPC_TRUE;
					
					/* If PCF is active, increment poll fail and the retry		*/
					/* counter.													*/
					if ((ap_flag == OPC_BOOLINT_ENABLED) &&
						(wlan_flags->pcf_active == OPC_TRUE))
						{
						/* If last frame a data frame, Increment retry counter.	*/
						if ((last_frametx_type == WlanC_Data_Poll)	||	(last_frametx_type == WlanC_Data_A_P))
							{
							pcf_retry_count++;
							}
						
						if  (wlan_flags->active_poll == OPC_TRUE) 
							{
							poll_fail_count++;
							wlan_flags->active_poll = OPC_FALSE;
							}
						
						/* Check whether further retries are possible or the	*/
						/* data frame needs to be discarded.					*/
						wlan_pcf_frame_discard();
						}
					else
						{
					
						/* Retransmission counter will be incremented.			*/
						retry_count = retry_count + 1;
				
						/* Reset the NAV duration so that the retransmission is	*/
						/* not unnecessarily delayed.							*/
						nav_duration = current_time;
				
						/* Check whether further retries are possible or the	*/
						/* data frame needs to be discarded.					*/
						wlan_frame_discard ();
						}
					}
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [WAIT_FOR_RESPONSE exit execs], state7_exit_exec)


			/** state (WAIT_FOR_RESPONSE) transition processing **/
			FSM_PROFILE_SECTION_IN (custom_wlan_mac [WAIT_FOR_RESPONSE trans conditions], state7_trans_conds)
			FSM_INIT_COND (FRAME_TIMEOUT || FRAME_RCVD)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("WAIT_FOR_RESPONSE")
			FSM_PROFILE_SECTION_OUT (custom_wlan_mac [WAIT_FOR_RESPONSE trans conditions], state7_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 6, state6_enter_exec, ;, "FRAME_TIMEOUT || FRAME_RCVD", "", "WAIT_FOR_RESPONSE", "FRM_END")
				FSM_CASE_TRANSIT (1, 7, state7_enter_exec, ;, "default", "", "WAIT_FOR_RESPONSE", "WAIT_FOR_RESPONSE")
				}
				/*---------------------------------------------------------*/



			/** state (BSS_INIT) enter executives **/
			FSM_STATE_ENTER_UNFORCED (8, "BSS_INIT", state8_enter_exec, "custom_wlan_mac [BSS_INIT enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [BSS_INIT enter execs], state8_enter_exec)
				{
				/* Schedule a self interrupt to wait for mac interface 	*/
				/* to move to next state after registering				*/
				op_intrpt_schedule_self (op_sim_time (), 0);
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [BSS_INIT enter execs], state8_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (17,"custom_wlan_mac")


			/** state (BSS_INIT) exit executives **/
			FSM_STATE_EXIT_UNFORCED (8, "BSS_INIT", "custom_wlan_mac [BSS_INIT exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [BSS_INIT exit execs], state8_exit_exec)
				{
				/* Obtain the values assigned to the various attributes				*/
				op_ima_obj_attr_get (my_objid, "Wireless LAN Parameters", &wlan_params_comp_attr_objid);
				params_attr_objid = op_topo_child (wlan_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);
				
				/* Determining the final MAC address after address resolution.		*/
				op_ima_obj_attr_get (my_objid, "Address", &my_address);
				
				/* Update our own process registery record with the final address	*/
				/* information.														*/
				oms_pr_attr_set (own_process_record_handle, "address", OMSC_PR_NUMBER, (double) my_address, OPC_NIL);                                       
				
				/* Destroy the global list of BSS IDs that was used while assigning	*/
				/* channels to BSSs.												*/
				wlan_bss_id_list_manage (bss_id, "destroy_list");
				
				/* Since the frequency band of the channels of all radio nodes are	*/
				/* determined, unless the roaming feature is enabled, refresh our	*/
				/* potential receiver group to exclude the receiver channels that	*/
				/* have non-overlapping bands with ours, which we can't reach and	*/
				/* interfere, to improve simulation performance.					*/
				if (!roam_state_ptr->enable_roaming)
					wlan_rxgroup_reduce ();
				
				/* Create the pool of station addresses of the same BSS using BSS	*/
				/* ID information.													*/
				my_sta_info_ptr = wlan_sta_addr_register (bss_id, my_address, ap_flag);
				
				/* Get a handle to the information record of our own BSS, which		*/
				/* also contains the STA list of our BSS.							*/
				my_bss_info_ptr = wlan_bss_info_get (bss_id);
				
				/* Search for the other WLAN MACs that are in the same LAN with us.	*/
				proc_record_handle_list_ptr = op_prg_list_create ();
				
				/* If the subnet is BSS based then do the process discovery using	*/
				/* BSS ID (domain_id), otherwise do it using subnet ID.				*/
				if (bss_id_type == WlanC_Bss_Divided_Subnet)
					{
				    oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr, 
					  "domain_id",			OMSC_PR_NUMBER,  		 (double) bss_id,
					  "mac_type",			OMSC_PR_STRING,	 		 "wireless_lan",
					  "protocol",			OMSC_PR_STRING,			 "mac",
					   OPC_NIL);
				    }
				else
					{
					oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr, 
					  "subnetid",			OMSC_PR_OBJID,			 my_subnet_objid,
					  "mac_type",			OMSC_PR_STRING,			"wireless_lan",
					  "protocol",			OMSC_PR_STRING,			"mac",
				 	   OPC_NIL);
					}
				
				/* If the MAC interface process registered itself,	*/
				/* then there must be a valid match					*/
				record_handle_list_size = op_prg_list_size (proc_record_handle_list_ptr);
				
				/* Initialize the address list index to zero.	*/
				addr_index = 0; 
				
				/* Variable to counting number of access point in the network.	*/
				ap_count = 0;
				
				/* Initialize the variable which holds the count of PCF users in network */
				poll_list_size =0;
				
				/* Keeps track of the number of stations which are PCF enabled 	*/
				/* If this value is greater than 0, only then a Beacon frame is */
				/* transmitted at the targeted time.							*/
				pcf_enabled_stations = 0;
				
				/* Preserves the PCF status on an AP node */
				pcf_enabled_on_AP = OPC_FALSE;
				
				/* Traversing the process record handle list to determine if there is any access point in the subnet.	*/
				for (i_cnt = 0; i_cnt < record_handle_list_size; i_cnt++ )
					{
					/*	Obtain a handle on the process record	*/
					process_record_handle = (OmsT_Pr_Handle) op_prg_list_access (proc_record_handle_list_ptr, i_cnt);
				
					/* Get the Station type.	*/
					oms_pr_attr_get (process_record_handle, "subprotocol", OMSC_PR_NUMBER, &statype);
				
					/* If the station is an Access Point then its station id will be a BSS id for all the station in that subnet.	*/
					if (statype == (double) WLAN_AP)
						{
						/* If access point found then it means that it is a Infrastructured BSS.	*/
						bss_flag = OPC_TRUE;
					
						/* Obtain the station address of the access point.							*/
						oms_pr_attr_get (process_record_handle, "address",	OMSC_PR_NUMBER, &sta_addr);	 
						ap_mac_address  = (int) sta_addr;
				
						/* According to IEEE 802.11 there cannot be more than one access point in	*/
						/* the same BSS.															*/
				   		ap_count = ap_count + 1;
						if (ap_count == 2)
							{
							sprintf(msg1,"More than one Access Point found within the same BSS (BSS ID = %d)" , bss_id);
							wlan_mac_error (msg1,"or in the same OPNET subnet.","Check the configuration.");
							}		 
				
						/* Save position information of the connected AP for "virtual" roaming */ 
						if (ap_flag == OPC_BOOLINT_DISABLED)
							oms_pr_attr_get (process_record_handle, "position record", OMSC_PR_ADDRESS, &conn_ap_pos_info_ptr);	 
				
						}
					    
					/* Checking the physical characteristic configuration for the subnet.	*/
					oms_pr_attr_get (process_record_handle, "module objid", OMSC_PR_OBJID, &mac_objid);
				
					/* Obtain the values assigned to the various attributes	*/
					op_ima_obj_attr_get (mac_objid, "Wireless LAN Parameters", &wlan_params_comp_attr_objid);
					params_attr_objid = op_topo_child (wlan_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);
				
					/* Load the appropriate physical layer characteristics.	*/	
					op_ima_obj_attr_get (params_attr_objid, "Physical Characteristics", &sta_phy_char_flag);
				
					if (sta_phy_char_flag != phy_char_flag)
						{
						wlan_mac_error ("Physical Characteristic configuration mismatch in the subnet.",
										"All stations in the subnet should have same physical characteristics", 
										"Check the configuration");			
						}	
					
					/*Check if the PCF mode has been enabled in this station	*/
					oms_pr_attr_get (process_record_handle, "PCF active", OMSC_PR_NUMBER, &pcf_active);
					
					/* If this station has its PCF functionality enabled,   */
					/* increment the PCF user count							*/
					if (pcf_active != 0.0) 
						{
						poll_list_size++;
				
						/* Preserve the PCF status if it is an AP. It is required later, when    */
						/* we check for PCF functionality enabled on other nodes in the network. */
						if (statype == (double) WLAN_AP)
							{
							pcf_enabled_on_AP = OPC_TRUE;
							}
						}
				    }
				
				/* Disable roaming based on the node type and type of BSS -- roaming not		*/
				/* supported in a PCF-based BSS or IBSS.										*/
				if (roam_state_ptr->enable_roaming && (pcf_enabled_on_AP || ap_count == 0 || ap_flag == OPC_BOOLINT_ENABLED))
					{
					roam_state_ptr->enable_roaming = OPC_FALSE;
					
					/* Write a simulation log message to report this configuration change.	*/
					op_prg_log_entry_write (config_log_handle,
						"WARNING:\n"
						" Cannot enable roaming functionality at the Wireless LAN MAC\n"
						" layer. Roaming cannot be supported by a WLAN MAC if any of\n"
						" the conditions below is true:\n"
						" a) The MAC belongs to an independent (ad-hoc) WLAN.\n"
						" b) Access point functionality is also enabled for that MAC.\n"
						" c) PCF functionality is enabled within the initial WLAN of\n"
						"    the MAC. Currently roaming is not supported with PCF\n"
						"    functionality.\n"
						"\n"
						" If you like the MAC layer of this node to execute roaming\n"
						" procedures and switch access points when available and\n"
						" necessary, then reconfigure the WLAN parameters on this\n"
						" node and/or on the other WLAN nodes of its LAN so that\n"
						" none of the conditions above is correct.\n");	
					}
				
				/* Even if enabled, disable the roaming if the surrounding node is fixed,	*/
				/* all the parent subnets are fixed and the beacon efficiency mode is		*/
				/* enabled, which assumes that the APs are not changing the locations. In	*/
				/* other words, there is no need to run roaming functions if the distance	*/
				/* between our node and any AP in the network will not change.				*/
				else if (roam_state_ptr->enable_roaming && op_id_to_type (my_node_objid) == OPC_OBJTYPE_NDFIX &&
						 beacon_eff_mode == OPC_BOOLINT_ENABLED)
					{
					/* Make sure all the parent subnets are also fixed.	Disable the roaming	*/
					/* and enable it back if one of the parent subnets is not fixed.		*/
					parent_subnet_objid = my_subnet_objid;
					roam_state_ptr->enable_roaming = OPC_FALSE;
					do
						{		
						if (op_id_to_type (parent_subnet_objid) != OPC_OBJTYPE_SUBNET_FIX)
							roam_state_ptr->enable_roaming = OPC_TRUE;
						
						/* Move to the parent subnet.										*/
						parent_subnet_objid = op_topo_parent (parent_subnet_objid);
						}
					while (!roam_state_ptr->enable_roaming && parent_subnet_objid != OPC_OBJID_NULL);
					}
				
				/* Record the count of the PCF enabled stations.	*/
				/* The beacon interval will be transmitted, only	*/
				/* if there has been a PCF enabled station			*/
				pcf_enabled_stations = poll_list_size;
				
				/* If PCF functionality has been enabled on any of the nodes     */
				/* if yes, it is required to have an Access Point in the network */
				if (pcf_enabled_stations > 0) 
					{
					/* Indicates the type of network (DCF only or PCF and DCF enabled nodes 	 */
					/* If pcf_network = 1, network contains either only PCF nodes or combination */
					/* If pcf_network = 0, network contains only DCF enabled nodes 				 */
					pcf_network = 1;
				
					/* The network has PCF enabled nodes, but no AP. */
					if (ap_count == 0)
						{
						sprintf (msg1,"PCF functionality has been enabled on %d station(s)", pcf_enabled_stations);
						wlan_mac_error (msg1,"An Access Point is required in the network to support PCF functionality.", 
										"Check your network configuration");
						}
					/* PCF enabled nodes present in the network, but */
					/* AP does not support PCF. Raise an error.		 */
					else if (pcf_enabled_on_AP == OPC_FALSE)
						{
						sprintf (msg1,"PCF functionality has been enabled on %d station(s)", pcf_enabled_stations);
						wlan_mac_error (msg1,"The node configured as Access Point does not support PCF functionality.", 
										"Check your network configuration");
						}
					}
				
				
				/* Create polling list, only if the station is an Access Point	*/
				/* and has then PCF functionality enabled  					    */
				if ((ap_flag == OPC_BOOLINT_ENABLED) && (pcf_flag == OPC_BOOLINT_ENABLED))
					{
					/* Since the current station is a AP, exclude this	*/
					/* station from the polling list					*/		
					poll_list_size--;
				
					/* Need not allocate memory for the polling list if no nodes in */
					/* the network support PCF. Also it is not necessary to create  */
					/* the polling list for the same case.							*/
					if (poll_list_size > 0)
						{
						/* Allocate memory for the polling list based on the number of PCF users.	*/
						polling_list = (int *) op_prg_mem_alloc (poll_list_size * sizeof(int));
				
						/* Initialize polling list entries.					*/
						j_cnt = 0;
					
						/* Loop through all the stations in the current subnet	*/
						/* which were shortlisted in the discovery process.		*/
						for (i_cnt = 0; i_cnt < record_handle_list_size; i_cnt++ )
							{
							/*	Obtain a handle to the ith station from the list of processes */
							process_record_handle = (OmsT_Pr_Handle) op_prg_list_access (proc_record_handle_list_ptr, i_cnt);
						
							/* Obtain the PCF functionality status	*/
							oms_pr_attr_get (process_record_handle, "PCF active", OMSC_PR_NUMBER, &pcf_active);
						
							/* Check if PCF functionality has been enabled on this station */
							if (pcf_active != 0.0) 
								{
								/* Obtain the address of the station */
								oms_pr_attr_get (process_record_handle, "address",	OMSC_PR_NUMBER, &sta_addr);	 
							
								/* Check if the address of station selected from the process	*/
								/* registry is not that of the current station					*/
								if (sta_addr != (double) my_address)
									{
									/* Store the selected station address in the polling list	*/
									polling_list[j_cnt] = (int) sta_addr;
								
									/*Increment the polling list index							*/
									j_cnt++;
								
									}
								}
							}
				
						/* Sorting has been implemented below to sort and store the	*/
						/* address of	stations in the ascending order 			*/
					
						/* Sorting needs to be done only if there are more than one	*/
						/* entry in the polling list								*/
						if (poll_list_size > 1)
							{
							/* Loop through all the elements in the polling list			*/
							for (i_cnt = 0; i_cnt < poll_list_size; i_cnt++ )
								{
								/* Store the index of the ith element 						*/
								k_cnt = i_cnt;
							
								/* Loop through all the elements from starting from i+1		*/
								for	(j_cnt = (i_cnt + 1); j_cnt < poll_list_size; j_cnt++ )
									{
									if (polling_list[j_cnt] < polling_list[k_cnt]) 
										k_cnt = j_cnt;
									}
								address= polling_list[i_cnt];
								polling_list[i_cnt] = polling_list[k_cnt];
								polling_list[k_cnt] = address;
								}
							}
						}
					}
				else 
					poll_list_size = 0;
				
				/* Printing out information to ODB.	*/
				if (wlan_trace_active == OPC_TRUE)
					{
					sprintf	(msg1, "%d stations have been polled by the AP", poll_list_size);	
					op_prg_odb_print_major (msg1, OPC_NIL);
					}
				
				
				/* Deallocate memory used for process discovery	*/
				while (op_prg_list_size (proc_record_handle_list_ptr))
					{
					op_prg_list_remove (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
					}
				op_prg_mem_free (proc_record_handle_list_ptr);
				
				/* Obtain the MAC layer information for the local MAC	*/
				/* process from the model-wide registry.				*/
				/* This is to check if the node is a gateway or not.	*/
				proc_record_handle_list_ptr = op_prg_list_create ();
				
				oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr, 
					"node objid",					OMSC_PR_OBJID,			 my_node_objid,
					"gateway node",					OMSC_PR_STRING,			"gateway",
				 	 OPC_NIL);
				
				/* If the MAC interface process registered itself,	*/
				/* then there must be a valid match					*/
				record_handle_list_size = op_prg_list_size (proc_record_handle_list_ptr);
				
				if (record_handle_list_size != 0)
					{
					wlan_flags->gateway_flag = OPC_TRUE;
					}
				
				/* Deallocate memory used for process discovery.	*/
				while (op_prg_list_size (proc_record_handle_list_ptr))
					{
					op_prg_list_remove (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
					}
				op_prg_mem_free (proc_record_handle_list_ptr);
				
				/* To enable roaming, all APs must send Beacons. 	*/
				if ((ap_flag == OPC_BOOLINT_ENABLED) && (beacon_eff_mode == OPC_BOOLINT_DISABLED || pcf_enabled_stations > 0))
					{
					/* Schedule a self interrupt to kick off the Beacon timer */
					/* All terminals need this to set NAV for PCF and other   */
					/* house keeping functions.                               */
					beacon_evh = op_intrpt_schedule_self (beacon_int, WlanC_Beacon_Tx_Time);	
					}
				
				/* If the beacon efficiency mode is on, we will scan the best AP based on the distance. */
				if (beacon_eff_mode == OPC_BOOLINT_ENABLED)
					{
					if (roam_state_ptr->enable_roaming == OPC_TRUE)
						{
						/* Set the scan_type to distance based since beacon efficiency is on. */
						roam_state_ptr->scan_type = WlanC_Scan_Type_Distance;
						if (op_ima_sim_attr_exists ("WLAN AP Connectivity Check Interval"))
							{
							op_ima_sim_attr_get (OPC_IMA_DOUBLE, "WLAN AP Connectivity Check Interval", &ap_connectivity_check_interval);
							}
						else
							{
							/* Use the default for now and issue a warning. */
							ap_connectivity_check_interval = WLANC_CONN_CHK_DIST_INTERVAL;
							op_sim_message ("WLAN MAC Roaming", "Cannot access sim attribute \"WLAN AP Connectivity Check Interval\".");
							}
				
						ap_connectivity_check_time = ap_connectivity_check_interval;
						}
					
					if (ap_flag == OPC_BOOLINT_ENABLED)
						{
						/* Insert the AP location information in the global list. */
						wlan_ap_position_publish ();
						}
					}
				
				/* Create the mutex that will be used to serialize the accessing of roaming	*/
				/* information between the receiver's power stage and MAC. Since each MAC-	*/
				/* receiver pair will have its own mutex, include the MAC's address in the	*/
				/* name of the mutex.														*/
				sprintf (name_str, "MAC %d Roaming Info Mutex", my_address);
				roam_state_ptr->roam_info_mutex = op_prg_mt_mutex_create (OPC_MT_MUTEX_NO_OPTIONS, 0, name_str);
				
				/* Lock the mutex. It will be locked at the beginning of exit execs, and	*/
				/* unlocked at the end of enter execs, of each unforced state excluding the	*/
				/* initialization states.													*/
				op_prg_mt_mutex_lock (roam_state_ptr->roam_info_mutex, 0);
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [BSS_INIT exit execs], state8_exit_exec)


			/** state (BSS_INIT) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "BSS_INIT", "IDLE")
				/*---------------------------------------------------------*/



			/** state (SCAN) enter executives **/
			FSM_STATE_ENTER_UNFORCED (9, "SCAN", state9_enter_exec, "custom_wlan_mac [SCAN enter execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [SCAN enter execs], state9_enter_exec)
				{
				/* Unlock the mutex that serializes accessing the roaming	*/
				/* related information of this MAC. 						*/
				op_prg_mt_mutex_unlock (roam_state_ptr->roam_info_mutex);
				
				/* Modifications for LR WPAN model, by Olivier	*/
				if (wlan_state_debug)
					{
					/* Determine the current state name.				*/
					strcpy (current_state_name, "scan");
					
					/* Modif. Oliv */
					ENTER_STATE_PRINT;
					}
				/************  end of modifications  ************/
				}

				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [SCAN enter execs], state9_enter_exec)

			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (19,"custom_wlan_mac")


			/** state (SCAN) exit executives **/
			FSM_STATE_EXIT_UNFORCED (9, "SCAN", "custom_wlan_mac [SCAN exit execs]")
				FSM_PROFILE_SECTION_IN (custom_wlan_mac [SCAN exit execs], state9_exit_exec)
				{
				/* Lock the mutex that serializes accessing the roaming related		*/
				/* information of this MAC. 										*/
				op_prg_mt_mutex_lock (roam_state_ptr->roam_info_mutex, 0);
				
				/* Interrupt processing routine.									*/
				wlan_interrupts_process ();
				
				/* Check whether the self interrupt set for the expiry of the scan	*/
				/* period is delivered.												*/
				if (SCAN_TIMEOUT)
					{
					switch (roam_state_ptr->scan_type)
						{
						case WlanC_Scan_Type_Distance:
							{
							/* Attempt to find a new access point based on actual	*/
							/* distances.											*/
							wlan_find_new_ap_virtual ();
							break;
							}
						case WlanC_Scan_Type_Beacon:
							{
							/* Check whether the AP of the current channel was		*/
							/* reliable during the last evaluation (scan) period.	*/
							if (roam_state_ptr->ap_reliability == WLANC_AP_RELIABLE)
								{
								/* The STA has found a connection to a reliable AP 	*/
								/* Stop scanning to stay with this new AP.			*/
								roam_state_ptr->scan_mode = OPC_FALSE;
								}
							break;
							}
						default:
							{
							break;
							}
						}
				
					/* A new AP has been found, associate with the new AP.			*/
					if (roam_state_ptr->scan_mode == OPC_FALSE)
						{
						/* Update the state variables to reflect new AP connection. */
						wlan_ap_switch ();
				
						/* Reset state variables like nav_duration, rcv_idle_time	*/
						/* etc. 													*/
						wlan_reset_sv ();
				
						/* Write a debug message if enabled.						*/
						if (wlan_trace_active == OPC_TRUE)
							{
							sprintf (msg1, "STA connected to AP with BSS ID %d", bss_id);
							op_prg_odb_print_major (msg1, OPC_NIL, OPC_NIL);
							}
						}
					
					/* If a connection could not be established in the current		*/
					/* channel continue scanning by switching to a new channel.		*/
					else
						{
						wlan_begin_new_scan ();
						}
					}
				}
				FSM_PROFILE_SECTION_OUT (custom_wlan_mac [SCAN exit execs], state9_exit_exec)


			/** state (SCAN) transition processing **/
			FSM_PROFILE_SECTION_IN (custom_wlan_mac [SCAN trans conditions], state9_trans_conds)
			FSM_INIT_COND (AP_CONNECTED && !DATA_FRAME_TO_TX)
			FSM_TEST_COND (AP_CONNECTED && DATA_FRAME_TO_TX)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("SCAN")
			FSM_PROFILE_SECTION_OUT (custom_wlan_mac [SCAN trans conditions], state9_trans_conds)

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 1, state1_enter_exec, ;, "AP_CONNECTED && !DATA_FRAME_TO_TX", "", "SCAN", "IDLE")
				FSM_CASE_TRANSIT (1, 2, state2_enter_exec, wlan_schedule_deference ();, "AP_CONNECTED && DATA_FRAME_TO_TX", "wlan_schedule_deference ()", "SCAN", "DEFER")
				FSM_CASE_TRANSIT (2, 9, state9_enter_exec, ;, "default", "", "SCAN", "SCAN")
				}
				/*---------------------------------------------------------*/



			}


		FSM_EXIT (0,"custom_wlan_mac")
		}
	}




void
custom_wlan_mac_diag (OP_SIM_CONTEXT_ARG_OPT)
	{

#if !defined (VOSD_NO_FIN)
	int _op_block_origin = __LINE__;
#endif

	FIN_MT (custom_wlan_mac_diag ())

	if (1)
		{
		/* variables used for registering and discovering process models */
		OmsT_Pr_Handle			process_record_handle;
		List*					proc_record_handle_list_ptr;
		int						record_handle_list_size;
		int						ap_count;
		double					sta_addr;
		double					statype ;
		Objid					mac_objid;
		Objid					mac_if_module_objid;
		Objid					parent_subnet_objid;
		char					name_str [128];
		Objid					params_attr_objid;
		Objid					wlan_params_comp_attr_objid;
		int						i_cnt,j_cnt, k_cnt;
		int						addr_index;
		WlanT_Hld_List_Elem*	hld_ptr;
		Prohandle				own_prohandle;
		double					timer_duration;
		char					msg1 [256];
		WlanT_Phy_Char_Code		sta_phy_char_flag;
		Boolean					bad_packet_rcvd = OPC_FALSE;
		Boolean					pre_rx_status;
		double					pcf_active;
		int						address;
		int						pcf_enabled_stations;
		Boolean					pcf_enabled_on_AP;
		double					tx_power;
		double					x_pos, y_pos, z_pos;

		/* Diagnostic Block */


		BINIT
		/* Print information about this process.	*/
		if (wlan_trace_active == OPC_TRUE)
			{
			printf ("Current state name:%s\t", current_state_name);
			}
		
		printf ("Station MAC Address:%d\n", my_address);
		printf ("printing the higher layer queue contents (packet ids)\n");
		for (i_cnt = 0; i_cnt< op_prg_list_size (hld_list_ptr); i_cnt++)
			{
			/* Remove packet from higher layer queue. */
			hld_ptr = (WlanT_Hld_List_Elem*) op_prg_list_access (hld_list_ptr, i_cnt);
			printf ("" SIMC_PK_ID_FMT "\t", op_pk_id (hld_ptr->pkptr));
			if ((i_cnt% 4) == 0)
				{
				printf ("\n");
				}
			}

		/* End of Diagnostic Block */

		}

	FOUT
	}




void
custom_wlan_mac_terminate (OP_SIM_CONTEXT_ARG_OPT)
	{

#if !defined (VOSD_NO_FIN)
	int _op_block_origin = __LINE__;
#endif

	FIN_MT (custom_wlan_mac_terminate ())

	if (1)
		{
		/* variables used for registering and discovering process models */
		OmsT_Pr_Handle			process_record_handle;
		List*					proc_record_handle_list_ptr;
		int						record_handle_list_size;
		int						ap_count;
		double					sta_addr;
		double					statype ;
		Objid					mac_objid;
		Objid					mac_if_module_objid;
		Objid					parent_subnet_objid;
		char					name_str [128];
		Objid					params_attr_objid;
		Objid					wlan_params_comp_attr_objid;
		int						i_cnt,j_cnt, k_cnt;
		int						addr_index;
		WlanT_Hld_List_Elem*	hld_ptr;
		Prohandle				own_prohandle;
		double					timer_duration;
		char					msg1 [256];
		WlanT_Phy_Char_Code		sta_phy_char_flag;
		Boolean					bad_packet_rcvd = OPC_FALSE;
		Boolean					pre_rx_status;
		double					pcf_active;
		int						address;
		int						pcf_enabled_stations;
		Boolean					pcf_enabled_on_AP;
		double					tx_power;
		double					x_pos, y_pos, z_pos;

		/* Termination Block */


		BINIT
		{
		
		}

		/* End of Termination Block */

		}
	Vos_Poolmem_Dealloc_MT (OP_SIM_CONTEXT_THREAD_INDEX_COMMA pr_state_ptr);

	FOUT
	}


/* Undefine shortcuts to state variables to avoid */
/* syntax error in direct access to fields of */
/* local variable prs_ptr in custom_wlan_mac_svar function. */
#undef retry_count
#undef intrpt_type
#undef my_address
#undef my_objid
#undef my_node_objid
#undef my_subnet_objid
#undef tx_objid
#undef txch_objid
#undef rx_objid
#undef rxch_objid
#undef own_process_record_handle
#undef hld_list_ptr
#undef operational_speed
#undef frag_threshold
#undef packet_seq_number
#undef packet_frag_number
#undef destination_addr
#undef fragmentation_buffer_ptr
#undef common_rsmbuf_ptr
#undef fresp_to_send
#undef nav_duration
#undef rts_threshold
#undef duplicate_entry
#undef expected_frame_type
#undef remote_sta_addr
#undef backoff_slots
#undef packet_load_handle
#undef intrpt_time
#undef wlan_transmit_frame_copy_ptr
#undef backoff_slots_handle
#undef instrm_from_mac_if
#undef outstrm_to_mac_if
#undef num_fragments
#undef remainder_size
#undef defragmentation_list_ptr
#undef wlan_flags
#undef oms_aa_handle
#undef current_time
#undef rcv_idle_time
#undef hld_pmh
#undef max_backoff
#undef current_state_name
#undef hl_packets_rcvd
#undef media_access_delay
#undef ete_delay_handle
#undef global_ete_delay_handle
#undef global_throughput_handle
#undef global_load_handle
#undef global_dropped_data_handle
#undef global_mac_delay_handle
#undef ctrl_traffic_rcvd_handle_inbits
#undef ctrl_traffic_sent_handle_inbits
#undef ctrl_traffic_rcvd_handle
#undef ctrl_traffic_sent_handle
#undef data_traffic_rcvd_handle_inbits
#undef data_traffic_sent_handle_inbits
#undef data_traffic_rcvd_handle
#undef data_traffic_sent_handle
#undef sifs_time
#undef slot_time
#undef cw_min
#undef cw_max
#undef difs_time
#undef plcp_overhead_control
#undef plcp_overhead_data
#undef channel_reserv_handle
#undef retrans_handle
#undef throughput_handle
#undef long_retry_limit
#undef short_retry_limit
#undef retry_limit
#undef last_frametx_type
#undef deference_evh
#undef backoff_elapsed_evh
#undef frame_timeout_evh
#undef eifs_time
#undef i_strm
#undef wlan_trace_active
#undef pkt_in_service
#undef bits_load_handle
#undef ap_flag
#undef bss_flag
#undef ap_mac_address
#undef hld_max_size
#undef max_receive_lifetime
#undef accept_large_packets
#undef phy_char_flag
#undef total_hlpk_size
#undef drop_packet_handle
#undef drop_packet_handle_inbits
#undef drop_pkt_log_handle
#undef config_log_handle
#undef drop_pkt_entry_log_flag
#undef packet_size
#undef receive_time
#undef llc_iciptr
#undef rx_power_threshold
#undef bss_id
#undef pcf_retry_count
#undef poll_fail_count
#undef max_poll_fails
#undef cfpd_list_ptr
#undef pcf_queue_offset
#undef beacon_int
#undef pcf_frag_buffer_ptr
#undef wlan_pcf_transmit_frame_copy_ptr
#undef pcf_num_fragments
#undef pcf_remainder_size
#undef polling_list
#undef poll_list_size
#undef poll_index
#undef pifs_time
#undef beacon_evh
#undef cfp_end_evh
#undef pcf_pkt_in_service
#undef pcf_flag
#undef active_pc
#undef cfp_prd
#undef cfp_offset
#undef cfp_length
#undef ap_relay
#undef total_cfpd_size
#undef packet_size_dcf
#undef packet_size_pcf
#undef receive_time_dcf
#undef receive_time_pcf
#undef cfp_ap_medium_control
#undef pcf_network
#undef beacon_eff_mode
#undef channel_num
#undef eval_bss_id
#undef roam_state_ptr
#undef rx_state_info_ptr
#undef ap_connectivity_check_interval
#undef ap_connectivity_check_time
#undef ap_connectivity_check_evhndl
#undef conn_ap_pos_info_ptr
#undef my_sta_info_ptr
#undef my_bss_info_ptr
#undef mapping_info_mutex
#undef wlan_name
#undef wlan_stat_custom
#undef wlan_state_debug
#undef error
#undef intrpt_code

#undef FIN_PREAMBLE_DEC
#undef FIN_PREAMBLE_CODE

#define FIN_PREAMBLE_DEC
#define FIN_PREAMBLE_CODE

VosT_Obtype
custom_wlan_mac_init (int * init_block_ptr)
	{

#if !defined (VOSD_NO_FIN)
	int _op_block_origin = 0;
#endif
	VosT_Obtype obtype = OPC_NIL;
	FIN_MT (custom_wlan_mac_init (init_block_ptr))

	Vos_Define_Object (&obtype, "proc state vars (custom_wlan_mac)",
		sizeof (custom_wlan_mac_state), 0, 20);
	*init_block_ptr = 0;

	FRET (obtype)
	}

VosT_Address
custom_wlan_mac_alloc (VOS_THREAD_INDEX_ARG_COMMA VosT_Obtype obtype, int init_block)
	{

#if !defined (VOSD_NO_FIN)
	int _op_block_origin = 0;
#endif
	custom_wlan_mac_state * ptr;
	FIN_MT (custom_wlan_mac_alloc (obtype))

	ptr = (custom_wlan_mac_state *)Vos_Alloc_Object_MT (VOS_THREAD_INDEX_COMMA obtype);
	if (ptr != OPC_NIL)
		ptr->_op_current_block = init_block;
	FRET ((VosT_Address)ptr)
	}



void
custom_wlan_mac_svar (void * gen_ptr, const char * var_name, void ** var_p_ptr)
	{
	custom_wlan_mac_state		*prs_ptr;

	FIN_MT (custom_wlan_mac_svar (gen_ptr, var_name, var_p_ptr))

	if (var_name == OPC_NIL)
		{
		*var_p_ptr = (void *)OPC_NIL;
		FOUT
		}
	prs_ptr = (custom_wlan_mac_state *)gen_ptr;

	if (strcmp ("retry_count" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->retry_count);
		FOUT
		}
	if (strcmp ("intrpt_type" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->intrpt_type);
		FOUT
		}
	if (strcmp ("my_address" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->my_address);
		FOUT
		}
	if (strcmp ("my_objid" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->my_objid);
		FOUT
		}
	if (strcmp ("my_node_objid" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->my_node_objid);
		FOUT
		}
	if (strcmp ("my_subnet_objid" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->my_subnet_objid);
		FOUT
		}
	if (strcmp ("tx_objid" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->tx_objid);
		FOUT
		}
	if (strcmp ("txch_objid" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->txch_objid);
		FOUT
		}
	if (strcmp ("rx_objid" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->rx_objid);
		FOUT
		}
	if (strcmp ("rxch_objid" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->rxch_objid);
		FOUT
		}
	if (strcmp ("own_process_record_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->own_process_record_handle);
		FOUT
		}
	if (strcmp ("hld_list_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->hld_list_ptr);
		FOUT
		}
	if (strcmp ("operational_speed" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->operational_speed);
		FOUT
		}
	if (strcmp ("frag_threshold" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->frag_threshold);
		FOUT
		}
	if (strcmp ("packet_seq_number" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->packet_seq_number);
		FOUT
		}
	if (strcmp ("packet_frag_number" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->packet_frag_number);
		FOUT
		}
	if (strcmp ("destination_addr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->destination_addr);
		FOUT
		}
	if (strcmp ("fragmentation_buffer_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->fragmentation_buffer_ptr);
		FOUT
		}
	if (strcmp ("common_rsmbuf_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->common_rsmbuf_ptr);
		FOUT
		}
	if (strcmp ("fresp_to_send" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->fresp_to_send);
		FOUT
		}
	if (strcmp ("nav_duration" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->nav_duration);
		FOUT
		}
	if (strcmp ("rts_threshold" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->rts_threshold);
		FOUT
		}
	if (strcmp ("duplicate_entry" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->duplicate_entry);
		FOUT
		}
	if (strcmp ("expected_frame_type" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->expected_frame_type);
		FOUT
		}
	if (strcmp ("remote_sta_addr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->remote_sta_addr);
		FOUT
		}
	if (strcmp ("backoff_slots" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->backoff_slots);
		FOUT
		}
	if (strcmp ("packet_load_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->packet_load_handle);
		FOUT
		}
	if (strcmp ("intrpt_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->intrpt_time);
		FOUT
		}
	if (strcmp ("wlan_transmit_frame_copy_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->wlan_transmit_frame_copy_ptr);
		FOUT
		}
	if (strcmp ("backoff_slots_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->backoff_slots_handle);
		FOUT
		}
	if (strcmp ("instrm_from_mac_if" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->instrm_from_mac_if);
		FOUT
		}
	if (strcmp ("outstrm_to_mac_if" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->outstrm_to_mac_if);
		FOUT
		}
	if (strcmp ("num_fragments" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->num_fragments);
		FOUT
		}
	if (strcmp ("remainder_size" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->remainder_size);
		FOUT
		}
	if (strcmp ("defragmentation_list_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->defragmentation_list_ptr);
		FOUT
		}
	if (strcmp ("wlan_flags" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->wlan_flags);
		FOUT
		}
	if (strcmp ("oms_aa_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->oms_aa_handle);
		FOUT
		}
	if (strcmp ("current_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->current_time);
		FOUT
		}
	if (strcmp ("rcv_idle_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->rcv_idle_time);
		FOUT
		}
	if (strcmp ("hld_pmh" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->hld_pmh);
		FOUT
		}
	if (strcmp ("max_backoff" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->max_backoff);
		FOUT
		}
	if (strcmp ("current_state_name" , var_name) == 0)
		{
		*var_p_ptr = (void *) (prs_ptr->current_state_name);
		FOUT
		}
	if (strcmp ("hl_packets_rcvd" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->hl_packets_rcvd);
		FOUT
		}
	if (strcmp ("media_access_delay" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->media_access_delay);
		FOUT
		}
	if (strcmp ("ete_delay_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ete_delay_handle);
		FOUT
		}
	if (strcmp ("global_ete_delay_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->global_ete_delay_handle);
		FOUT
		}
	if (strcmp ("global_throughput_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->global_throughput_handle);
		FOUT
		}
	if (strcmp ("global_load_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->global_load_handle);
		FOUT
		}
	if (strcmp ("global_dropped_data_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->global_dropped_data_handle);
		FOUT
		}
	if (strcmp ("global_mac_delay_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->global_mac_delay_handle);
		FOUT
		}
	if (strcmp ("ctrl_traffic_rcvd_handle_inbits" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ctrl_traffic_rcvd_handle_inbits);
		FOUT
		}
	if (strcmp ("ctrl_traffic_sent_handle_inbits" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ctrl_traffic_sent_handle_inbits);
		FOUT
		}
	if (strcmp ("ctrl_traffic_rcvd_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ctrl_traffic_rcvd_handle);
		FOUT
		}
	if (strcmp ("ctrl_traffic_sent_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ctrl_traffic_sent_handle);
		FOUT
		}
	if (strcmp ("data_traffic_rcvd_handle_inbits" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->data_traffic_rcvd_handle_inbits);
		FOUT
		}
	if (strcmp ("data_traffic_sent_handle_inbits" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->data_traffic_sent_handle_inbits);
		FOUT
		}
	if (strcmp ("data_traffic_rcvd_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->data_traffic_rcvd_handle);
		FOUT
		}
	if (strcmp ("data_traffic_sent_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->data_traffic_sent_handle);
		FOUT
		}
	if (strcmp ("sifs_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->sifs_time);
		FOUT
		}
	if (strcmp ("slot_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->slot_time);
		FOUT
		}
	if (strcmp ("cw_min" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->cw_min);
		FOUT
		}
	if (strcmp ("cw_max" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->cw_max);
		FOUT
		}
	if (strcmp ("difs_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->difs_time);
		FOUT
		}
	if (strcmp ("plcp_overhead_control" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->plcp_overhead_control);
		FOUT
		}
	if (strcmp ("plcp_overhead_data" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->plcp_overhead_data);
		FOUT
		}
	if (strcmp ("channel_reserv_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->channel_reserv_handle);
		FOUT
		}
	if (strcmp ("retrans_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->retrans_handle);
		FOUT
		}
	if (strcmp ("throughput_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->throughput_handle);
		FOUT
		}
	if (strcmp ("long_retry_limit" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->long_retry_limit);
		FOUT
		}
	if (strcmp ("short_retry_limit" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->short_retry_limit);
		FOUT
		}
	if (strcmp ("retry_limit" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->retry_limit);
		FOUT
		}
	if (strcmp ("last_frametx_type" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->last_frametx_type);
		FOUT
		}
	if (strcmp ("deference_evh" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->deference_evh);
		FOUT
		}
	if (strcmp ("backoff_elapsed_evh" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->backoff_elapsed_evh);
		FOUT
		}
	if (strcmp ("frame_timeout_evh" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->frame_timeout_evh);
		FOUT
		}
	if (strcmp ("eifs_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->eifs_time);
		FOUT
		}
	if (strcmp ("i_strm" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->i_strm);
		FOUT
		}
	if (strcmp ("wlan_trace_active" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->wlan_trace_active);
		FOUT
		}
	if (strcmp ("pkt_in_service" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pkt_in_service);
		FOUT
		}
	if (strcmp ("bits_load_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->bits_load_handle);
		FOUT
		}
	if (strcmp ("ap_flag" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ap_flag);
		FOUT
		}
	if (strcmp ("bss_flag" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->bss_flag);
		FOUT
		}
	if (strcmp ("ap_mac_address" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ap_mac_address);
		FOUT
		}
	if (strcmp ("hld_max_size" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->hld_max_size);
		FOUT
		}
	if (strcmp ("max_receive_lifetime" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->max_receive_lifetime);
		FOUT
		}
	if (strcmp ("accept_large_packets" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->accept_large_packets);
		FOUT
		}
	if (strcmp ("phy_char_flag" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->phy_char_flag);
		FOUT
		}
	if (strcmp ("total_hlpk_size" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->total_hlpk_size);
		FOUT
		}
	if (strcmp ("drop_packet_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->drop_packet_handle);
		FOUT
		}
	if (strcmp ("drop_packet_handle_inbits" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->drop_packet_handle_inbits);
		FOUT
		}
	if (strcmp ("drop_pkt_log_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->drop_pkt_log_handle);
		FOUT
		}
	if (strcmp ("config_log_handle" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->config_log_handle);
		FOUT
		}
	if (strcmp ("drop_pkt_entry_log_flag" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->drop_pkt_entry_log_flag);
		FOUT
		}
	if (strcmp ("packet_size" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->packet_size);
		FOUT
		}
	if (strcmp ("receive_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->receive_time);
		FOUT
		}
	if (strcmp ("llc_iciptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->llc_iciptr);
		FOUT
		}
	if (strcmp ("rx_power_threshold" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->rx_power_threshold);
		FOUT
		}
	if (strcmp ("bss_id" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->bss_id);
		FOUT
		}
	if (strcmp ("pcf_retry_count" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pcf_retry_count);
		FOUT
		}
	if (strcmp ("poll_fail_count" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->poll_fail_count);
		FOUT
		}
	if (strcmp ("max_poll_fails" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->max_poll_fails);
		FOUT
		}
	if (strcmp ("cfpd_list_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->cfpd_list_ptr);
		FOUT
		}
	if (strcmp ("pcf_queue_offset" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pcf_queue_offset);
		FOUT
		}
	if (strcmp ("beacon_int" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->beacon_int);
		FOUT
		}
	if (strcmp ("pcf_frag_buffer_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pcf_frag_buffer_ptr);
		FOUT
		}
	if (strcmp ("wlan_pcf_transmit_frame_copy_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->wlan_pcf_transmit_frame_copy_ptr);
		FOUT
		}
	if (strcmp ("pcf_num_fragments" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pcf_num_fragments);
		FOUT
		}
	if (strcmp ("pcf_remainder_size" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pcf_remainder_size);
		FOUT
		}
	if (strcmp ("polling_list" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->polling_list);
		FOUT
		}
	if (strcmp ("poll_list_size" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->poll_list_size);
		FOUT
		}
	if (strcmp ("poll_index" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->poll_index);
		FOUT
		}
	if (strcmp ("pifs_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pifs_time);
		FOUT
		}
	if (strcmp ("beacon_evh" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->beacon_evh);
		FOUT
		}
	if (strcmp ("cfp_end_evh" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->cfp_end_evh);
		FOUT
		}
	if (strcmp ("pcf_pkt_in_service" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pcf_pkt_in_service);
		FOUT
		}
	if (strcmp ("pcf_flag" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pcf_flag);
		FOUT
		}
	if (strcmp ("active_pc" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->active_pc);
		FOUT
		}
	if (strcmp ("cfp_prd" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->cfp_prd);
		FOUT
		}
	if (strcmp ("cfp_offset" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->cfp_offset);
		FOUT
		}
	if (strcmp ("cfp_length" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->cfp_length);
		FOUT
		}
	if (strcmp ("ap_relay" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ap_relay);
		FOUT
		}
	if (strcmp ("total_cfpd_size" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->total_cfpd_size);
		FOUT
		}
	if (strcmp ("packet_size_dcf" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->packet_size_dcf);
		FOUT
		}
	if (strcmp ("packet_size_pcf" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->packet_size_pcf);
		FOUT
		}
	if (strcmp ("receive_time_dcf" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->receive_time_dcf);
		FOUT
		}
	if (strcmp ("receive_time_pcf" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->receive_time_pcf);
		FOUT
		}
	if (strcmp ("cfp_ap_medium_control" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->cfp_ap_medium_control);
		FOUT
		}
	if (strcmp ("pcf_network" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->pcf_network);
		FOUT
		}
	if (strcmp ("beacon_eff_mode" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->beacon_eff_mode);
		FOUT
		}
	if (strcmp ("channel_num" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->channel_num);
		FOUT
		}
	if (strcmp ("eval_bss_id" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->eval_bss_id);
		FOUT
		}
	if (strcmp ("roam_state_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->roam_state_ptr);
		FOUT
		}
	if (strcmp ("rx_state_info_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->rx_state_info_ptr);
		FOUT
		}
	if (strcmp ("ap_connectivity_check_interval" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ap_connectivity_check_interval);
		FOUT
		}
	if (strcmp ("ap_connectivity_check_time" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ap_connectivity_check_time);
		FOUT
		}
	if (strcmp ("ap_connectivity_check_evhndl" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->ap_connectivity_check_evhndl);
		FOUT
		}
	if (strcmp ("conn_ap_pos_info_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->conn_ap_pos_info_ptr);
		FOUT
		}
	if (strcmp ("my_sta_info_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->my_sta_info_ptr);
		FOUT
		}
	if (strcmp ("my_bss_info_ptr" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->my_bss_info_ptr);
		FOUT
		}
	if (strcmp ("mapping_info_mutex" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->mapping_info_mutex);
		FOUT
		}
	if (strcmp ("wlan_name" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->wlan_name);
		FOUT
		}
	if (strcmp ("wlan_stat_custom" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->wlan_stat_custom);
		FOUT
		}
	if (strcmp ("wlan_state_debug" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->wlan_state_debug);
		FOUT
		}
	if (strcmp ("error" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->error);
		FOUT
		}
	if (strcmp ("intrpt_code" , var_name) == 0)
		{
		*var_p_ptr = (void *) (&prs_ptr->intrpt_code);
		FOUT
		}
	*var_p_ptr = (void *)OPC_NIL;

	FOUT
	}

