//========================= Official Notice ===============================
//
// "This software was developed at the National Institute of Standards
// and Technology by employees of the Federal Government in the course of
// their official duties. Pursuant to Title 17 Section 105 of the United
// States Code this software is not subject to copyright protection and
// is in the public domain.
//
// The NIST Data Flow System (NDFS) is an experimental system and is
// offered AS IS. NIST assumes no responsibility whatsoever for its use
// by other parties, and makes no guarantees and NO WARRANTIES, EXPRESS
// OR IMPLIED, about its quality, reliability, fitness for any purpose,
// or any other characteristic.
//
// We would appreciate acknowledgement if the software is used.
//
// This software can be redistributed and/or modified freely provided
// that any derivative works bear some notice that they are derived from
// it, and any modified versions bear some notice that they have been
// modified from the original."
//
//=========================================================================



#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include <string.h>

#include <sys/poll.h>		//library for the timout on answer
#include <getopt.h> 		//library option

static const char *default_dip = "10.0.0.2";
const char *dip;

const char *progname, *shortname;

unsigned char msg[14];
int fd;
struct sockaddr_in adr;
int len;

static int ID_array;
static int offset;
static char PROM_NB[8];

static void print_usage(FILE *stream)
{
  fprintf(stream, "Usage : %s [-h] [-d IP]\n"
	  "  -h        --help           Prints this message\n"
	  "  -d IP     --dest IP        Listen to this IP (default: %s)\n"
	  "\n For more information contact: cedrick.rochet@nist.gov\n"
	  "\n---------------------------- Official Notice -----------------------------\n"
	  "This software was developed at the National Institute of Standards and      \n"
	  "Technology by employees of the Federal Government in the course of their    \n"    
	  "official duties. Pursuant to Title 17 Section 105 of the United States Code \n"    
	  "this software is not subject to copyright protection and is in the public   \n"    
	  "domain.                                                                   \n\n"    
	  "array_simple_controls is an experimental system as is offered AS IS. NIST   \n"
	  "assumes no responsibility whatsoever for its use by other parties, and      \n"    
	  "makes no guarantees and NO WARRANTIES, EXPRESS OR IMPLIED, about            \n"    
	  "its quality, reliability, fitness for any purpose, or any other             \n"    
	  "characteristic. We would appreciate acknowledgement if the software is used.\n\n"    
	  "This software can be redistributed and/or modified freely provided that any \n"    
	  "derivative works bear some notice that they are derived from it, and any    \n"
	  "modified versions bear some notice that they have been modified from the    \n"
	  "original.                                                                   \n"
	  "----------------------------------------------------------------------------\n",    
	  progname, default_dip);
}

void options(int argc, char ***argv)
{
  static struct option optlist[] = {
    { "help",    0, 0, 'h'},
    { "dest",    1, 0, 'd'},
    { 0,         0, 0, 0  }
  };
  
  int usage = 0, finish = 0, error = 0;
  
  dip = default_dip;
  
  for(;;) {
    int opt = getopt_long(argc, *argv, "h:d:", optlist, 0);
    if(opt == EOF)
      break;
    switch(opt) {
    case 'h':
      usage = 1;
      finish = 1;
      error = 0;
      break;
    case 'd':
      dip = optarg;
      break;
    case '?':
    case ':':
      usage = 1;
      finish = 1;
      error = 1;
      break;
    default:
      abort();
    }
    if(finish)
      break;
  }
  
  if (usage)
    print_usage(error ? stderr : stdout);
  
  if (finish)
    exit(error);
  
  *argv += optind;
}

static void send_msg(void)
{
  if(sendto(fd, msg, len, 0, (const struct sockaddr *)&adr, sizeof(adr)) < 0) {
    perror("sendto");
    exit(1);
  }
}

static void recieve_msg(void)
{
  struct pollfd pfd;
  int res;
  pfd.fd = fd;
  pfd.events = POLLIN;
  res = poll(&pfd, 1, 100);
  if(!res) {
    fprintf(stderr, "Timeout on answer\n");
    len = 0;
    exit(0);
    return;
  }

  len = recv(fd, msg, sizeof(msg), 0);
}

static int ask_status_slave(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 2;           //request number

    msg[2] = 0;
    msg[3] = 0;
    
    len = 4;
    send_msg();
    
    recieve_msg();
    if(!len)
      continue;
    done = (msg[0] == 2);
    
  } while(!done);
  printf("Your Microphone Array slave is: %i\n",(int) msg[2]);
  return (int) msg[2];
}

static void slave_on(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 1;           //request number
    msg[2] = 0xff;
    msg[3] = 0xff;  
    
    len = 4;
    send_msg();

    done = (ask_status_slave() == 1);
  } while(!done);
}

static void slave_off(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 1;           //request number
    msg[2] = 0;
    msg[3] = 0;  
    
    len = 4;
    send_msg();

    done = (ask_status_slave() == 0);

  } while(!done);
}

static void set_slave_offset(short clk_offset)
{  
  char *p;
  
  p = (char *) &clk_offset;
  
  msg[0] = 0;
  msg[1] = 10;           //request number
  msg[2] = p[0];
  msg[3] = p[1];

  len = 4;
  send_msg();

  printf("The slave starts after : %i clock periods or %i ns" ,clk_offset ,30*clk_offset);
}

static void ask_slave_offset(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 11;           //request number
    msg[2] = 0;
    msg[3] = 0;
    
    len = 4;
    send_msg();
    
    recieve_msg();
    if(!len)
      continue;
    done = (msg[0] == 11);
    
  } while(!done);
  offset = (msg[2])|(msg[3]<<8);
  printf("The slave starts after : %i clock periods or %i ns" ,offset ,30*offset);
}

static void ask_id(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 3;           //request number
    msg[2] = 0;
    msg[3] = 0;
    
    len = 4;
    send_msg();
    
    recieve_msg();
    if(!len)
      continue;
    done = (msg[0] == 3);
    
  } while(!done);
  ID_array = (msg[2])|(msg[3]<<8);
  memcpy(PROM_NB,msg+6,8);
  printf("Capture on %x with PROM %s\n", ID_array, PROM_NB);
}

static int ask_status_capture(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 5;           //request number
    msg[2] = 0;
    msg[3] = 0;

    len = 4;
    send_msg();
    
    recieve_msg();
    if(!len)
      continue;
    done = (msg[0] == 5);
    
  } while(!done);
  printf("Your Microphone Array capture is: %i\n",(int) msg[2]);
  return (int) msg[2];
}

static void capture_on(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 4;           //request number
    msg[2] = 0xff;
    msg[3] = 0xff;  
    
    len = 4;
    send_msg();
    
    done = (ask_status_capture() == 1);
    
  } while(!done);
}

static void capture_off(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 4;           //request number
    msg[2] = 0;
    msg[3] = 0;  
    
    len = 4;
    send_msg();

    done = (ask_status_capture() == 0);
    
  } while(!done);
}

static void ask_old_packet(short packet_number)
{
  // Be careful in using this fuction because it won't stop the normal data packet traffic
  // but will insert the packets asked in the middle of the data traffic...
  // If the microphone is not in capture mode, it will send back a back with msg[2]=n
  
  char *p;
  
  p = (char *) &packet_number;
  
  msg[0] = 0;
  msg[1] = 6;           //request number
  msg[2] = p[0];
  msg[3] = p[1];

  len = 4;
  send_msg();

  printf("Your packet number is: %i",packet_number);
}
      
static int ask_status_speed(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 8;           //request number
    msg[2] = 0;
    msg[3] = 0;
    
    len = 4;
    send_msg();
    
    recieve_msg();
    if(!len)
      continue;
    
    done = (msg[0] == 7);
    
  } while(!done);
  
  printf("Your Microphone Array speed is: %i\n",(int) msg[2]);
  return (int) msg[2];
}

static void speed_on(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 7;           //request number
    msg[2] = 0xff;
    msg[3] = 0xff;  
    
    len = 4;
    send_msg();
    
    done = (ask_status_speed() == 1);
    
  } while(!done);
}

static void speed_off(void)
{
  int done = 0;
  do {
    msg[0] = 0;
    msg[1] = 7;           //request number		
    msg[2] = 0;
    msg[3] = 0;  
    
    len = 4;
    send_msg();
    
    done = (ask_status_speed() == 0);
    
  } while(!done);
}

static void ask_range_old_packet(short first_packet_number, short last_packet_number)
{
  // Be careful in using this fuction because it won't stop the normal data packet traffic
  // but will insert the packets asked in the middle of the data traffic...
  // The activation of this option on range more than 5 packets can overload your network 
  // card under to much traffic... 
  // Remember that at normal operation the traffic on the line is about 4.4MBytes per second.
  
  // If the microphone is not in capture mode, it will send back a back with msg[2]=n
  
  char *pfirst;
  char *plast;
  
  // conversion of the shorts in chars to fill msg 
  pfirst = (char *) &first_packet_number;
  plast  = (char *) &last_packet_number;
  
  msg[0]=0x00;
  msg[1]=0x09;           //request number
  msg[2] = pfirst[0];
  msg[3] = pfirst[1];
  msg[4] = plast[0];
  msg[5] = plast[1];
  
  len = 4;
  send_msg();
  
  printf("Your packet range is: %i - %i \n",first_packet_number,last_packet_number);
}

int main(int argc, char **argv)
{
  int d;
  int choix01, choix02, choix03;
  
  int number1;
  int number2;

  /* Option processing */
  progname = argv[0];
  shortname = strrchr(progname, '/');
  if(!shortname)
    shortname = progname;
  else
    shortname++;
  
  options(argc, &argv);
  
  /*socket connection*/
  fd = socket(PF_INET, SOCK_DGRAM, 0);
  if(fd<0) {
    perror("socket");
    return 0;
    exit(1);
  }
  
  memset(&adr, 0, sizeof(adr));
  adr.sin_family = AF_INET;
  adr.sin_port = htons(32767);
  adr.sin_addr.s_addr = INADDR_ANY;
  //printf("Bind to IP: %s\n", &adr.sin_addr.s_addr);
  
  if(bind(fd, (struct sockaddr *)&adr, sizeof(adr)) < 0) {
    perror("bind");
    return 0;
    exit(1);
  }
  
  memset(&adr, 0, sizeof(adr));
  adr.sin_family = AF_INET;
  adr.sin_port = htons(32767);
  inet_aton(dip, &adr.sin_addr);
  printf("Listen on IP: %s\n", dip);
  
  ask_id();
  
  choix01 = ask_status_slave();
  choix02 = ask_status_capture();
  choix03 = ask_status_speed();
  
  for(;;) {
    
    printf("\n1: SLAVE MODE ON/OFF                  - request01\n");
    printf("2: REQUEST STATUS SLAVE MODE          - request02\n");
    printf("3: REQUEST ID                         - request03\n");
    printf("4: CAPTURE ON/OFF                     - request04\n");
    printf("5: REQUEST STATUS CAPTURE             - request05\n");
    printf("6: REQUEST OLD PACKET                 - request06\n");
    printf("7: DOUBLE FREQUENCY AD ON/OFF         - request07\n");
    printf("8: REQUEST STATUS DOUBLE FREQUENCY AD - request08\n");
    printf("9: REQUEST RANGE OLD PACKETS          - request09\n");
    printf("10: SET SLAVE CLOCK OFFSET            - request10\n");
    printf("11: REQUEST SLAVE CLOCK OFFSET        - request11\n");
    printf("0: QUIT\n");
    printf("Your choice is: ");
    
    scanf("%d",&d);
    
    switch(d){
      
      case 0 :
	printf("Quitting...\n");
	exit(0);
	break;
		
      case 1:
	if (choix01 == 1) {
	  slave_off();
	  choix01=0;
      	} else {
	  slave_on();
	  choix01=1;
      	}	
	break;
      
      case 2:
	ask_status_speed();
	break;
	
      case 3:
	ask_id();
      	break;
	
      case 4:
	if (choix02 == 1)  {
	  capture_off();
      	  choix02=0;
      	} else {
	  capture_on();
	  choix02=1;
	}
	break;
    
      case 5:
	ask_status_capture();
	break;
      
      case 6:
	printf("Your number packet is: ");
	scanf("%d", &number1);
      
	ask_old_packet((short)number1);
	break;
      
      case 7:
	if (choix03 == 1) {
	  speed_off();
	  choix03=0;
	} else {
	  speed_on();
	  choix03=1;
	}
        break;
	
      case 8:
	ask_status_speed();
      	break;
      
      case 9:
      
      	printf("Your first number packet is: ");
      	scanf("%d", &number1);
	
	printf("Your last number packet is: ");
      	scanf("%d", &number2);
	
      	ask_range_old_packet((short)number1, (short)number2);
      	break;

      case 10:
      
      	printf("Your slave clock offset: ");
      	scanf("%d", &number1);
		
      	set_slave_offset((short)number1);
      	break;

      case 11:
      
      	ask_slave_offset();
      	break;
	
      default :
	printf("Error: this input is not right: %i\n",d); 
	exit(0);
	break;
    }
  }
  return 0;  
} 
