function [xx,xxxu,xxxl] = CAnewTCP                % CA MODEL FOR TCP


%**************** INITIALIZATION ****************** 

%GENERAL PARAMETERS
L=3;                                              % SYSTEM SIZE
UK=10;                                            % THE NUMBER OF SOURCES ATTACHED TO EACH ROUTER
UR=2*UK;                                          % THE NUMBER OF RECEIVERS FOR EACH ROUTER CHANGES DYNAMICALLY, BUT IT IS TWICE UK AT MOST.                             
AL=5;                                             % THE LINK CAPACITY OF ROUTING TIER
lamd=200;                                         % THE AVERAGE NUMBER OF PACKETS IN EACH "ON" STATE
lamd1=2000;                                       % THE AVERAGE TIME STEPS IDLING IN EACH "OFF" STATE
erfa=1.2;                                         % THE SHAPE PARAMETER OF PARETO DISTRIBUTION; THE DEFAULT SETTING IS THE EXPONENTIAL DISTRIBUTION; IF "ON" STATE FOLLOWS PARETO, REPLACING THE RIGHT SIDE OF THE LINE 137 WITH THE LINE 139. 
SIGMA=2.5;MU=log(lamd)-SIGMA^2/2;                 % TWO PARAMETERS OF LOGNORMAL DISTRIBUTION; THE DEFAULT SETTING IS THE EXPONENTIAL DISTRIBUTION; IF "ON" STATE FOLLOWS LOGNORMAL, REPLACING THE RIGHT SIDE OF THE LINE 137 WITH THE LINE 138.
vmax=1;                                           % SAMPLING RATE FOR COLLECTING DATA
BUFFER=50;                                        % EACH BUFFER WITH LIMITED LENGTH QUEUE
LBOUND=5;UBOUND=BUFFER;                           % UPPER AND LOWER LIMIT FOR ESTIMATING THE ROUND-TRIP TIME

LONGTIME=2610000;                                 % EXECUTION TIME (TOTAL TIME STEPS)
probenode=fix(L/2+1);                             % THE DATA OF THE NODE (probenode, probenode) WILL BE COLLECTED
xx(1:LONGTIME)=0;                                 % xx REPRESENTS THE NUMBER OF PACKETS RECEIVED BY THE NODE r(probenode,probenode) DURING A "vmax"
xxxu(1:LONGTIME)=0;xxxl(1:LONGTIME)=0;            % xxxu (OR xxxl) REPRESENTS THE NUMBER OF PACKETS FORWARDED UPWARDS (OR TOWARDS THE LEFT) BY THE NODE r(probenode,probenode) DURING A "vmax"


%ROUTERS
mq=0;
Habscissa(1:(L*L))=0;Hordinate(1:(L*L))=0;r=zeros(L);
for i=1:L
   for j=1:L
      mq=mq+1;                                    % mq WILL BE THE TOTAL NUMBER OF NODES
      r(i,j)=mq;                                  % THE SEQUENCE NUMBER OF EACH NODE
      Habscissa(mq)=i;                            % THE ABSCISSA OF EACH NODE
      Hordinate(mq)=j;                            % THE ORDINATE OF EACH NODE
   end
end
n=zeros(L);                                       % THE QUEUE LENGTH OF EACH NODE
bfd=zeros(mq,(BUFFER+4*AL));                      % bfd(A,B) REPRESENTS THE DESTINATION ADDRESS OF THE B-th PACKET IN THE NODE A
bfi=zeros(mq,(BUFFER+4*AL));                      % bfi(A,B) REPRESENTS THE SOURCE ADDRESS OF THE B-th PACKET IN THE NODE A
ptime=zeros(mq,(BUFFER+4*AL));                    % ptime(A,B) REPRESENTS THE TIME EXPERIENCED BY THE B-th PACKET IN THE NODE A TILL NOW
psequence=zeros(mq,(BUFFER+4*AL));                % psequence(A,B) REPRESENTS THE SEQUENCE NUMBER OF THE B-th PACKET OF THE NODE A IN ITS OWN CONNECTION


%SOURCES
Indica(1:mq,1:UK)=0;                              % Indica = 0 (OR 1) WHEN THE NODE IS IN "OFF" (OR "ON") STATE
begint(1:mq,1:UK)=0;                              % begint = 0 (BEFORE ENTERING SLOW-START), 1 (WAITING FOR ACK PACKETS WITHOUT LAUNCHING ANY PACKET), 2 (WITHIN CONGESTION AVOIDANCE), 3 (WITHIN THE SLOW-START), OR 4 ("OFF" STATE)
PINTERVAL(1:mq,1:UK)=ceil(exprnd(lamd1,mq,UK))+1; % PINTERVAL IS THE LENGTH OF "ON" OR "OFF" STATE FOR EACH SOURCE
Daddress(1:mq,1:UK)=0;                            % THE DESTINATION ADDRESS
DistanceSR(1:mq,1:UK)=0;                          % ESTIMATED ROUND-TRIP DISTANCE BETWEEN THE SOURCE AND THE DESTINATION
IDReceivers(1:mq,1:UK)=0;                         % THE RECEIVER'S ID IN THE DESTINATION ROUTER
cwnd(1:mq,1:UK)=1;                                % cwnd IS THE CONGESTION WINDOW
ssthresh(1:mq,1:UK)=16;                           % THE SLOW-START THRESHOLD SIZE
nstate(1:mq,1:UK)=1;                              % HOW MANY PACKETS' ACK HAVE NOT BEEN RECEIVED REGARDING THE CURRENT cwnd
PINTERVALC(1:mq,1:UK)=0;                          % HOW MANY PACKETS HAVE NOT BEEN INJECTED REGARDING THE CURRENT cwnd
Sstate(1:mq,1:UK)=1;                              % THE SEQUENCE NUMBER OF THE PACKET THAT WILL BE LAUNCHED NEXT 
SRTT(1:mq,1:UK)=0;                                % THE ESTIMATED ROUND-TRIP TIME
RTO(1:mq,1:UK)=0;                                 % THE RETRANSMISSION TIMEOUT
CRTO(1:mq,1:UK)=1;                                % THE TIMER OF A CONNECTION'S TIMEOUT


%RECEIVERS
SENO(1:mq,1:UR)=0;                                % THE EXPECTED SEQUENCE NUMBER IN A RECEIVER
Saddress(1:mq,1:UR)=0;                            % THE SENDER'S ADDRESS


%*******************  STARTING  *******************

tt=cputime;                                       % STARTING TIME

for ii=1:LONGTIME
  for k=1:vmax
    for i=1:L
      for j=1:L
      % SOURCES' OPERATION      
        for h=1:UK 
           if Indica(r(i,j),h)==1                          % "ON" STATE?
              if begint(r(i,j),h)==0
                 Daddress(r(i,j),h)=r(i,j);
                 while Daddress(r(i,j),h)==r(i,j)                 % FIND A HOST THAT SATISFIES REQUIMENTS
                    Daddress(r(i,j),h)=fix(rand*mq)+1;
                    phhp=1;
                    DAP=SENO(Daddress(r(i,j),h),phhp);
                    while DAP~=0
                       phhp=phhp+1;
                       if phhp>UR
                          Daddress(r(i,j),h)=r(i,j); 
                          DAP=0;
                       else
                          DAP=SENO(Daddress(r(i,j),h),phhp);
                       end
                    end
                 end
                 IDReceivers(r(i,j),h)=phhp;
                 SENO(Daddress(r(i,j),h),phhp)=1;
                 Saddress(Daddress(r(i,j),h),phhp)=r(i,j);
                 if (n(i,j)+1)<=BUFFER
                    n(i,j)=n(i,j)+1;
                    bfd(r(i,j),n(i,j))=Daddress(r(i,j),h)+phhp*10^-6;        % THE DECIMAL FRACTION CARRIES THE RECEIVER'S ID IN THE DESTINATION ROUTER
                    bfi(r(i,j),n(i,j))=r(i,j)+h*10^-6;                       % THE DECIMAL FRACTION CARRIES THE SENDER'S ID
                    ptime(r(i,j),n(i,j))=1;
                    psequence(r(i,j),n(i,j))=1;
                 end
                 cwnd(r(i,j),h)=1;ssthresh(r(i,j),h)=16;PINTERVALC(r(i,j),h)=0;
                 DistanceSR(r(i,j),h)=2*(L-abs(abs(Habscissa(Daddress(r(i,j),h))-i)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-j)-L/2)+1);
                 SRTT(r(i,j),h)=ceil(LBOUND*DistanceSR(r(i,j),h)/AL);
                 RTO(r(i,j),h)=ceil(LBOUND*DistanceSR(r(i,j),h)/AL);
                 begint(r(i,j),h)=3;CRTO(r(i,j),h)=1;nstate(r(i,j),h)=1;Sstate(r(i,j),h)=2;
              else
                 CRTO(r(i,j),h)=CRTO(r(i,j),h)+1; 
                 if CRTO(r(i,j),h)>=RTO(r(i,j),h)                            % TIMEOUT?
                    ssthresh(r(i,j),h)=ceil(.5*cwnd(r(i,j),h));cwnd(r(i,j),h)=1;PINTERVALC(r(i,j),h)=cwnd(r(i,j),h);begint(r(i,j),h)=2;
                    RTO(r(i,j),h)=min(ceil(UBOUND*DistanceSR(r(i,j),h)/AL),2*RTO(r(i,j),h));CRTO(r(i,j),h)=1;nstate(r(i,j),h)=cwnd(r(i,j),h);
                 end
                 if begint(r(i,j),h)>=2
                    if PINTERVALC(r(i,j),h)>0
                       if (n(i,j)+1)<=BUFFER
                          n(i,j)=n(i,j)+1;
                          bfd(r(i,j),n(i,j))=Daddress(r(i,j),h)+IDReceivers(r(i,j),h)*10^-6;   % THE DECIMAL FRACTION CARRIES THE RECEIVER'S ID IN THE DESTINATION ROUTER
                          bfi(r(i,j),n(i,j))=r(i,j)+h*10^-6;                                   % THE DECIMAL FRACTION CARRIES THE SENDER'S ID
                          ptime(r(i,j),n(i,j))=1;
                          psequence(r(i,j),n(i,j))=Sstate(r(i,j),h);
                       end   
                       Sstate(r(i,j),h)=Sstate(r(i,j),h)+1;
                       PINTERVALC(r(i,j),h)=PINTERVALC(r(i,j),h)-1;
                       if begint(r(i,j),h)==2
                          if PINTERVALC(r(i,j),h)==0
                             begint(r(i,j),h)=1;
                          end
                       end
                    end
                 end
              end      
           else                                                               % "OFF" STATE
              PINTERVAL(r(i,j),h)=PINTERVAL(r(i,j),h)-1;
              if PINTERVAL(r(i,j),h)==0
                 Indica(r(i,j),h)=1;
                 begint(r(i,j),h)=0;
                 PINTERVAL(r(i,j),h)=ceil(exprnd(lamd));                      % THE DEFAULT SETTING IS THE EXPONENTIAL DISTRIBUTION
                 %ceil(lognrnd(MU,SIGMA));                                    % IF "ON" STATE FOLLOWS LOGNORMAL, REPLACING THE RIGHT SIDE OF THE LINE 137 WITH THE LINE 138
                 %ceil(rand^(-1/erfa)*(erfa-1)*lamd/erfa);                    % IF "ON" STATE PARETO, REPLACING THE RIGHT SIDE OF THE LINE 137 WITH THE LINE 139.
              end
           end
        end
     end
  end

% ROUTERS' OPERATION
  for aol=1:AL 
     for i=1:L
        for j=1:L        
          if n(i,j)>0
            Lr=j-1;
            Rr=j+1;
            Ur=i-1;
            Dr=i+1;
            if Lr==0
               Lr=L;
            end
            if Rr==(L+1)
               Rr=1;
            end
            if Ur==0
               Ur=L;
            end
            if Dr==(L+1)
               Dr=1;
            end
            if fix(bfd(r(i,j),1))==r(i,j)                     % THE DESTINATION ROUTER OF THE CURRENT PACKET?
               if i==probenode
                  if j==probenode
                     xx(ii)=xx(ii)+1;
                  end
               end
               if ptime(r(i,j),1)>1000000                     % IS IT A ACK PACKET?
                  phhp=round(10^6*(bfd(r(i,j),1)-fix(bfd(r(i,j),1))));
                  if Daddress(r(i,j),phhp)==fix(bfi(r(i,j),1))
                     if Indica(r(i,j),phhp)==1
                        SRTT(r(i,j),phhp)=0.8*SRTT(r(i,j),phhp)+.2*(ptime(r(i,j),1)-1000000);
                        RTO(r(i,j),phhp)=min(ceil(UBOUND*DistanceSR(r(i,j),phhp)/AL),max(ceil(LBOUND*DistanceSR(r(i,j),phhp)/AL),1.5*SRTT(r(i,j),phhp)));
                        if psequence(r(i,j),1)==-1
                           nstate(r(i,j),phhp)=0;
                        else
                           nstate(r(i,j),phhp)=nstate(r(i,j),phhp)-1;
                        end
                        if nstate(r(i,j),phhp)==0
                           CRTO(r(i,j),phhp)=1;
                           if psequence(r(i,j),1)==-1
                              ssthresh(r(i,j),phhp)=ceil(.5*cwnd(r(i,j),phhp));
                              cwnd(r(i,j),phhp)=ceil(.5*cwnd(r(i,j),phhp));
                              PINTERVALC(r(i,j),phhp)=cwnd(r(i,j),phhp);
                              nstate(r(i,j),phhp)=cwnd(r(i,j),phhp);
                              begint(r(i,j),phhp)=2;
                           else
                              if begint(r(i,j),phhp)==3
                                 if cwnd(r(i,j),phhp)<ssthresh(r(i,j),phhp)
                                    cwnd(r(i,j),phhp)=cwnd(r(i,j),phhp)*2;
                                 else
                                    cwnd(r(i,j),phhp)=cwnd(r(i,j),phhp)+1;
                                    begint(r(i,j),phhp)=2;
                                 end
                              else   
                                 cwnd(r(i,j),phhp)=cwnd(r(i,j),phhp)+1;
                                 begint(r(i,j),phhp)=2;
                              end
                           end
                           PINTERVALC(r(i,j),phhp)=cwnd(r(i,j),phhp);
                           nstate(r(i,j),phhp)=cwnd(r(i,j),phhp);
                        end
                        PINTERVAL(r(i,j),phhp)=PINTERVAL(r(i,j),phhp)-1;
                        if PINTERVAL(r(i,j),phhp)==0
                           Indica(r(i,j),phhp)=0;
                           DAP=round(10^6*(bfi(r(i,j),1)-fix(bfi(r(i,j),1))));
                           SENO(Daddress(r(i,j),phhp),DAP)=0;Saddress(Daddress(r(i,j),phhp),DAP)=0;
                           Daddress(r(i,j),phhp)=-1;begint(r(i,j),phhp)=4;
                           PINTERVAL(r(i,j),phhp)=ceil(exprnd(lamd1));               % THE DEFAULT SETTING OF "OFF" STATE IS THE EXPONENTIAL DISTRIBUTION
                           %ceil(rand^(-1/erfa)*(erfa-1)*lamd1/erfa);                % IF "OFF" STATE PARETO, REPLACING THE RIGHT SIDE OF THE LINE 214 WITH THE LINE 215.
                        end
                     end
                  end
               else
                  phhp=round(10^6*(bfd(r(i,j),1)-fix(bfd(r(i,j),1))));
                  if Saddress(r(i,j),phhp)==fix(bfi(r(i,j),1))
                     if SENO(r(i,j),phhp)==psequence(r(i,j),1)                       % EXPECTED SEQUENCE NUMBER?
                        SENO(r(i,j),phhp)=SENO(r(i,j),phhp)+1;
                        if (n(i,j)+1)<=BUFFER
                           n(i,j)=n(i,j)+1;
                           bfd(r(i,j),n(i,j))=bfi(r(i,j),1);
                           bfi(r(i,j),n(i,j))=bfd(r(i,j),1);
                           ptime(r(i,j),n(i,j))=1000000+ptime(r(i,j),1);             % ADDING 1000000 TO ptime FOR ALL ACK PACKETS
                           psequence(r(i,j),n(i,j))=0;
                        end
                     else
                        SENO(r(i,j),phhp)=psequence(r(i,j),1)+1;
                        if (n(i,j)+1)<=BUFFER
                           n(i,j)=n(i,j)+1;
                           bfd(r(i,j),n(i,j))=bfi(r(i,j),1);
                           bfi(r(i,j),n(i,j))=bfd(r(i,j),1);
                           ptime(r(i,j),n(i,j))=1000000+ptime(r(i,j),1);
                           psequence(r(i,j),n(i,j))=-1;
                        end
                     end
                  end   
               end
               n(i,j)=n(i,j)-1;
               if n(i,j)>=2
                  bfd(r(i,j),1:n(i,j))=bfd(r(i,j),2:(n(i,j)+1));
                  ptime(r(i,j),1:n(i,j))=ptime(r(i,j),2:(n(i,j)+1));
                  bfi(r(i,j),1:n(i,j))=bfi(r(i,j),2:(n(i,j)+1));
                  psequence(r(i,j),1:n(i,j))=psequence(r(i,j),2:(n(i,j)+1));
               else
                  if n(i,j)==1
                     bfd(r(i,j),1)=bfd(r(i,j),2);
                     ptime(r(i,j),1)=ptime(r(i,j),2);
                     bfi(r(i,j),1)=bfi(r(i,j),2);
                     psequence(r(i,j),1)=psequence(r(i,j),2);
                  end
               end
            else                                 % ROUTING AND FORWARDING
               if fix(bfd(r(i,j),1))==r(Ur,j)
                  if i==probenode
                     if j==probenode
                        xxxu(ii)=xxxu(ii)+1;
                     end
                  end                    
                  n(Ur,j)=n(Ur,j)+1;
                  bfd(r(Ur,j),n(Ur,j))=bfd(r(i,j),1);
                  bfi(r(Ur,j),n(Ur,j))=bfi(r(i,j),1);
                  ptime(r(Ur,j),n(Ur,j))=ptime(r(i,j),1);
                  psequence(r(Ur,j),n(Ur,j))=psequence(r(i,j),1);
               else
                  if fix(bfd(r(i,j),1))==r(i,Rr)
                     n(i,Rr)=n(i,Rr)+1;
                     bfd(r(i,Rr),n(i,Rr))=bfd(r(i,j),1);
                     bfi(r(i,Rr),n(i,Rr))=bfi(r(i,j),1);
                     ptime(r(i,Rr),n(i,Rr))=ptime(r(i,j),1);
                     psequence(r(i,Rr),n(i,Rr))=psequence(r(i,j),1);
                  else
                     if fix(bfd(r(i,j),1))==r(Dr,j)
                        n(Dr,j)=n(Dr,j)+1;
                        bfd(r(Dr,j),n(Dr,j))=bfd(r(i,j),1);
                        bfi(r(Dr,j),n(Dr,j))=bfi(r(i,j),1);
                        ptime(r(Dr,j),n(Dr,j))=ptime(r(i,j),1);
                        psequence(r(Dr,j),n(Dr,j))=psequence(r(i,j),1);
                     else
                        if fix(bfd(r(i,j),1))==r(i,Lr)
                           if i==probenode
                              if j==probenode
                                 xxxl(ii)=xxxl(ii)+1;
                              end
                           end
                           n(i,Lr)=n(i,Lr)+1;
                           bfd(r(i,Lr),n(i,Lr))=bfd(r(i,j),1);
                           bfi(r(i,Lr),n(i,Lr))=bfi(r(i,j),1);
                           ptime(r(i,Lr),n(i,Lr))=ptime(r(i,j),1);
                           psequence(r(i,Lr),n(i,Lr))=psequence(r(i,j),1);
                        else
                           ddd1=L-abs(abs(Habscissa(fix(bfd(r(i,j),1)))-Ur)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),1)))-j)-L/2);
                           ddd2=L-abs(abs(Habscissa(fix(bfd(r(i,j),1)))-i)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),1)))-Rr)-L/2);
                           ddd3=L-abs(abs(Habscissa(fix(bfd(r(i,j),1)))-Dr)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),1)))-j)-L/2);
                           ddd4=L-abs(abs(Habscissa(fix(bfd(r(i,j),1)))-i)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),1)))-Lr)-L/2);
                           xxxmin=min([ddd1 ddd2 ddd3 ddd4]);
                           if ddd1==xxxmin
                              if ddd1==ddd2
                                 n(i,Rr)=n(i,Rr)+1;
                                 bfd(r(i,Rr),n(i,Rr))=bfd(r(i,j),1);
                                 bfi(r(i,Rr),n(i,Rr))=bfi(r(i,j),1);
                                 ptime(r(i,Rr),n(i,Rr))=ptime(r(i,j),1);
                                 psequence(r(i,Rr),n(i,Rr))=psequence(r(i,j),1);
                              else
                                 if i==probenode
                                    if j==probenode
                                       xxxu(ii)=xxxu(ii)+1;
                                    end
                                 end
                                 n(Ur,j)=n(Ur,j)+1;
                                 bfd(r(Ur,j),n(Ur,j))=bfd(r(i,j),1);
                                 bfi(r(Ur,j),n(Ur,j))=bfi(r(i,j),1);
                                 ptime(r(Ur,j),n(Ur,j))=ptime(r(i,j),1);
                                 psequence(r(Ur,j),n(Ur,j))=psequence(r(i,j),1);
                              end
                           else
                              if ddd2==xxxmin
                                 if ddd2==ddd3
                                    n(Dr,j)=n(Dr,j)+1;
                                    bfd(r(Dr,j),n(Dr,j))=bfd(r(i,j),1);
                                    bfi(r(Dr,j),n(Dr,j))=bfi(r(i,j),1);
                                    ptime(r(Dr,j),n(Dr,j))=ptime(r(i,j),1);
                                    psequence(r(Dr,j),n(Dr,j))=psequence(r(i,j),1);
                                 else
                                    n(i,Rr)=n(i,Rr)+1;
                                    bfd(r(i,Rr),n(i,Rr))=bfd(r(i,j),1);
                                    bfi(r(i,Rr),n(i,Rr))=bfi(r(i,j),1);
                                    ptime(r(i,Rr),n(i,Rr))=ptime(r(i,j),1);
                                    psequence(r(i,Rr),n(i,Rr))=psequence(r(i,j),1);
                                 end
                              else
                                 if ddd3==xxxmin
                                    if ddd3==ddd4
                                       if i==probenode
                                          if j==probenode
                                             xxxl(ii)=xxxl(ii)+1;
                                          end
                                       end
                                       n(i,Lr)=n(i,Lr)+1;
                                       bfd(r(i,Lr),n(i,Lr))=bfd(r(i,j),1);
                                       bfi(r(i,Lr),n(i,Lr))=bfi(r(i,j),1);
                                       ptime(r(i,Lr),n(i,Lr))=ptime(r(i,j),1);
                                       psequence(r(i,Lr),n(i,Lr))=psequence(r(i,j),1);
                                    else
                                       n(Dr,j)=n(Dr,j)+1;
                                       bfd(r(Dr,j),n(Dr,j))=bfd(r(i,j),1);
                                       bfi(r(Dr,j),n(Dr,j))=bfi(r(i,j),1);
                                       ptime(r(Dr,j),n(Dr,j))=ptime(r(i,j),1);
                                       psequence(r(Dr,j),n(Dr,j))=psequence(r(i,j),1);
                                    end
                                 else
                                    if i==probenode
                                       if j==probenode
                                          xxxl(ii)=xxxl(ii)+1;
                                       end
                                    end
                                    n(i,Lr)=n(i,Lr)+1;
                                    bfd(r(i,Lr),n(i,Lr))=bfd(r(i,j),1);
                                    bfi(r(i,Lr),n(i,Lr))=bfi(r(i,j),1);
                                    ptime(r(i,Lr),n(i,Lr))=ptime(r(i,j),1);
                                    psequence(r(i,Lr),n(i,Lr))=psequence(r(i,j),1);
                                 end
                              end
                           end   
                        end
                     end
                  end
               end
               n(i,j)=n(i,j)-1;
               if n(i,j)>BUFFER
                  n(i,j)=BUFFER;
               end
               if n(i,j)>=2
                  bfd(r(i,j),1:n(i,j))=bfd(r(i,j),2:(n(i,j)+1));
                  bfi(r(i,j),1:n(i,j))=bfi(r(i,j),2:(n(i,j)+1));
                  ptime(r(i,j),1:n(i,j))=ptime(r(i,j),2:(n(i,j)+1));
                  psequence(r(i,j),1:n(i,j))=psequence(r(i,j),2:(n(i,j)+1));
               else
                  if n(i,j)==1
                     bfd(r(i,j),1)=bfd(r(i,j),2);
                     bfi(r(i,j),1)=bfi(r(i,j),2);
                     ptime(r(i,j),1)=ptime(r(i,j),2);
                     psequence(r(i,j),1)=psequence(r(i,j),2);
                  end
               end
            end
          end
        end  
      end
    end   
    for i=1:L                                              % ptime ADDS ONE
       for j=1:L
          if n(i,j)>0
             ptime(r(i,j),1:n(i,j))=ptime(r(i,j),1:n(i,j))+1;
          end
          if n(i,j)>BUFFER
             n(i,j)=BUFFER;
          end
       end
    end
  end
end
xx=xx(10001:LONGTIME);                                     % CUT OUT THE TRANSIENT PROCESS
xxxu=xxxu(10001:LONGTIME);
xxxl=xxxl(10001:LONGTIME);

tt=cputime-tt;                                             % TOTAL EXECUTION TIME

save CAnewTCP-3-v1K10AL5-on200-off2000 xx xxxu xxxl tt     % SAVE DATA TO A MAT-FILE 
