function [xx,xxxu,xxxl] = CAnewTFRC               % CA MODEL FOR TFRC


%**************** INITIALIZATION ****************** 

%GENERAL PARAMETERS
L=3;                                              % SYSTEM SIZE
UK=10;                                            % THE NUMBER OF SOURCES ATTACHED TO EACH ROUTER
UR=2*UK;                                          % THE NUMBER OF RECEIVERS FOR EACH ROUTER CHANGES DYNAMICALLY, BUT IT IS TWICE UK AT MOST.                             
AL=5;                                             % THE LINK CAPACITY OF ROUTING TIER
lamd=200;                                         % THE AVERAGE NUMBER OF PACKETS IN EACH "ON" STATE
lamd1=2000;                                       % THE AVERAGE TIME STEPS IDLING IN EACH "OFF" STATE
erfa=1.2;                                         % THE SHAPE PARAMETER OF PARETO DISTRIBUTION, IF "ON" STATE FOLLOWS PARETO; THE DEFAULT SETTING IS THE EXPONENTIAL DISTRIBUTION 
SIGMA=2.5;MU=log(lamd)-SIGMA^2/2;                 % TWO PARAMETERS OF LOGNORMAL DISTRIBUTION, IF "ON" STATE FOLLOWS LOGNORMAL; THE DEFAULT SETTING IS THE EXPONENTIAL DISTRIBUTION
vmax=1;                                           % SAMPLING RATE FOR COLLECTING DATA
BUFFER=50;                                        % EACH BUFFER WITH LIMITED LENGTH QUEUE
TLBOUND=5;TUBOUND=1000;                           % UPPER AND LOWER LIMIT OF THE INTERVAL OF PACKETS BEING TRANSMITTED UNDER THE CONTROL OF TFRC

LONGTIME=2610000;                                 % EXECUTION TIME (TOTAL TIME STEPS)
probenode=fix(L/2+1);                             % THE DATA OF THE NODE (probenode, probenode) WILL BE COLLECTED
xx(1:LONGTIME)=0;                                 % xx REPRESENTS THE NUMBER OF PACKETS RECEIVED BY THE NODE r(probenode,probenode) DURING A "vmax"
xxxu(1:LONGTIME)=0;xxxl(1:LONGTIME)=0;            % xxxu (OR xxxl) REPRESENTS THE NUMBER OF PACKETS FORWARDED UPWARDS (OR TOWARDS THE LEFT) BY THE NODE r(probenode,probenode) DURING A "vmax"


%ROUTERS
mq=0;
Habscissa(1:(L*L))=0;Hordinate(1:(L*L))=0;r=zeros(L);
for i=1:L
   for j=1:L
      mq=mq+1;                                    % mq WILL BE THE TOTAL NUMBER OF NODES
      r(i,j)=mq;                                  % THE SEQUENCE NUMBER OF EACH NODE
      Habscissa(mq)=i;                            % THE ABSCISSA OF EACH NODE
      Hordinate(mq)=j;                            % THE ORDINATE OF EACH NODE
   end
end
n=zeros(L);                                       % THE QUEUE LENGTH OF EACH NODE
bfd=zeros(mq,(BUFFER+4*AL));                      % bfd(A,B) REPRESENTS THE DESTINATION ADDRESS OF THE B-th PACKET IN THE NODE A
bfi=zeros(mq,(BUFFER+4*AL));                      % bfi(A,B) REPRESENTS THE SOURCE ADDRESS OF THE B-th PACKET IN THE NODE A
ptime=zeros(mq,(BUFFER+4*AL));                    % ptime(A,B) REPRESENTS THE TIME EXPERIENCED BY THE B-th PACKET IN THE NODE A TILL NOW
psequence=zeros(mq,(BUFFER+4*AL));                % psequence(A,B) REPRESENTS THE SEQUENCE NUMBER OF THE B-th PACKET OF THE NODE A IN ITS OWN CONNECTION


%SOURCES
Indica(1:mq,1:UK)=0;                              % Indica = 0 (OR 1) WHEN THE NODE IS IN "OFF" (OR "ON") STATE
begint(1:mq,1:UK)=0;                              % begint = 0 (BEFORE ENTERING SLOW-START), 1 (WITHIN THE SLOW-START), OR 2 (WITHIN THE NORMAL CONNECTION STATE)
PINTERVAL(1:mq,1:UK)=ceil(exprnd(lamd1,mq,UK))+1; % PINTERVAL IS THE LENGTH OF "ON" OR "OFF" STATE FOR EACH SOURCE
Daddress(1:mq,1:UK)=0;                            % THE DESTINATION ADDRESS
DistanceSR(1:mq,1:UK)=0;                          % ESTIMATED ROUND-TRIP DISTANCE BETWEEN THE SOURCE AND THE DESTINATION
IDReceivers(1:mq,1:UK)=0;                         % THE RECEIVER'S ID IN THE DESTINATION ROUTER
PINTERVALC(1:mq,1:UK)=0;                          % HOW MANY PACKETS HAVE NOT BEEN INJECTED REGARDING THE CURRENT cwnd
Sstate(1:mq,1:UK)=1;                              % THE SEQUENCE NUMBER OF THE PACKET THAT WILL BE LAUNCHED NEXT 
SRTT(1:mq,1:UK)=0;                                % THE ESTIMATED ROUND-TRIP TIME
RTO(1:mq,1:UK)=0;                                 % THE NOFEEDBACK TIMER
CRTO(1:mq,1:UK)=1;                                % THE TIMER FOR INJECTING THE NEXT PACKET
Tcalc(1:mq,1:UK)=TUBOUND;                         % THE CURRENT INTERVAL OF PACKETS BEING TRANSMITTED UNDER THE CONTROL OF TFRC

%RECEIVERS
SENO(1:mq,1:UR)=0;                                % THE EXPECTED SEQUENCE NUMBER IN A RECEIVER; SENO = 0 IF IT'S LEFT IDLE
Saddress(1:mq,1:UR)=0;                            % THE SENDER'S ADDRESS
IDSources(1:mq,1:UR)=0;                           % THE HOST ID OF THE SENDER 
RRTO(1:mq,1:UR)=0;                                % THE TIME PERIOD FOR FEEDING MESSAGES BACK TO THE SENDER
CRRTO(1:mq,1:UR)=0;                               % THE FEEDBACK TIMER
pLER(1:mq,1:UR)=0;                                % THE CALCULATED LOSS RATE
Trecv(1:mq,1:UR)=0;                               % Trecv REPRESENTS THE RECEIVING RATE/THE AVERAGE INETRVAL OF RECEIVED APCKETS BY COUNTING THE NUMBER OF RECEIVED PACKETS EACH TIME PERIOD
stdt(1:mq,1:UR)=0;                                % THE LATEST TRIP TIME FROM THE SENDER TO THE RECEIVER
CLER(1:mq,1:UR)=0;                                % THE LOSS INTERVAL
CLERp1(1:mq,1:UR)=0;CLERp2(1:mq,1:UR)=0;          % CLERp1~8 ARE THE PREVIOUS LOSS INTERVALS
CLERp3(1:mq,1:UR)=0;CLERp4(1:mq,1:UR)=0;
CLERp5(1:mq,1:UR)=0;CLERp6(1:mq,1:UR)=0;
CLERp7(1:mq,1:UR)=0;CLERp8(1:mq,1:UR)=0;


%*******************  STARTING  *******************

tt=cputime;                                       % STARTING TIME

for ii=1:LONGTIME
  for k=1:vmax
    for i=1:L
      for j=1:L                
       % SOURCES' OPERATION
         for h=1:UK                  
           if Indica(r(i,j),h)==1                          % "ON" STATE?
              if begint(r(i,j),h)==0
                 Daddress(r(i,j),h)=r(i,j);
                 while Daddress(r(i,j),h)==r(i,j)                 % FIND A HOST THAT SATISFIES REQUIMENTS
                    Daddress(r(i,j),h)=fix(rand*mq)+1;
                    phhp=1;
                    DAP=SENO(Daddress(r(i,j),h),phhp);
                    while DAP~=0
                       phhp=phhp+1;
                       if phhp>UR
                          Daddress(r(i,j),h)=r(i,j); 
                          DAP=0;
                       else
                          DAP=SENO(Daddress(r(i,j),h),phhp);
                       end
                    end
                 end
                 IDReceivers(r(i,j),h)=phhp;
                 IDSources(Daddress(r(i,j),h),phhp)=h;
                 SENO(Daddress(r(i,j),h),phhp)=1;
                 Saddress(Daddress(r(i,j),h),phhp)=r(i,j);
                 Trecv(Daddress(r(i,j),h),phhp)=0;pLER(Daddress(r(i,j),h),phhp)=0;CLER(Daddress(r(i,j),h),phhp)=0;
                 Tcalc(r(i,j),h)=TUBOUND;
                 SRTT(r(i,j),h)=BUFFER/(2*AL)*2*(L-abs(abs(Habscissa(Daddress(r(i,j),h))-i)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-j)-L/2)+1);
                 RTO(r(i,j),h)=4*SRTT(r(i,j),h);RRTO(Daddress(r(i,j),h),phhp)=SRTT(r(i,j),h);CRRTO(Daddress(r(i,j),h),phhp)=1;stdt(Daddress(r(i,j),h),phhp)=SRTT(r(i,j),h)/2;
                 if (n(i,j)+1)<=BUFFER
                    n(i,j)=n(i,j)+1;
                    bfd(r(i,j),n(i,j))=Daddress(r(i,j),h)+phhp*10^-6;        % THE DECIMAL FRACTION CARRIES THE RECEIVER'S ID IN THE DESTINATION ROUTER
                    bfi(r(i,j),n(i,j))=r(i,j)+h*10^-6;                       % THE DECIMAL FRACTION CARRIES THE SENDER'S ID
                    ptime(r(i,j),n(i,j))=1;
                    psequence(r(i,j),n(i,j))=1;
                 end
                 CRTO(r(i,j),h)=1;Sstate(r(i,j),h)=2;
                 begint(r(i,j),h)=1;
              else
                 CRTO(r(i,j),h)=CRTO(r(i,j),h)+1; 
                 if CRTO(r(i,j),h)>=Tcalc(r(i,j),h)                          % INJECTING THE NEXT PACKET? 
                    if (n(i,j)+1)<=BUFFER
                       n(i,j)=n(i,j)+1;
                       bfd(r(i,j),n(i,j))=Daddress(r(i,j),h)+IDReceivers(r(i,j),h)*10^-6;
                       bfi(r(i,j),n(i,j))=r(i,j)+h*10^-6;
                       ptime(r(i,j),n(i,j))=1;
                       psequence(r(i,j),n(i,j))=Sstate(r(i,j),h);
                    end
                    Sstate(r(i,j),h)=Sstate(r(i,j),h)+1;
                    CRTO(r(i,j),h)=1;
                 end
                 RTO(r(i,j),h)=RTO(r(i,j),h)-1; 
                 if RTO(r(i,j),h)<=0                                         % NOFEEDBACK TIMEOUT?
                    Tcalc(r(i,j),h)=min(2*Tcalc(r(i,j),h),TUBOUND);
                    RTO(r(i,j),h)=max(4*SRTT(r(i,j),h),2*Tcalc(r(i,j),h));
                 end
              end      
           else                                                              % "OFF" STATE
              PINTERVAL(r(i,j),h)=PINTERVAL(r(i,j),h)-1;
              if PINTERVAL(r(i,j),h)==0
                 Indica(r(i,j),h)=1;
                 begint(r(i,j),h)=0;
                 PINTERVAL(r(i,j),h)=ceil(exprnd(lamd));                     % THE DEFAULT SETTING IS THE EXPONENTIAL DISTRIBUTION
                 %ceil(lognrnd(MU,SIGMA));                                   % IF "ON" STATE FOLLOWS LOGNORMAL, REPLACING THE RIGHT SIDE OF THE LINE 141 WITH THE LINE 142
                 %ceil(rand^(-1/erfa)*(erfa-1)*lamd/erfa);                   % IF "ON" STATE PARETO, REPLACING THE RIGHT SIDE OF THE LINE 141 WITH THE LINE 143
              end
           end
        end
        
      % RECEIVERS' OPERATION
        for h=1:UR
           if SENO(r(i,j),h)>0
              CRRTO(r(i,j),h)=CRRTO(r(i,j),h)+1;
              if CRRTO(r(i,j),h)>=RRTO(r(i,j),h)                             % FEEDBACK TIMEOUT?
                 CRRTO(r(i,j),h)=1;
                 if Trecv(r(i,j),h)>0   
                    Trecv(r(i,j),h)=fix(RRTO(r(i,j),h)/Trecv(r(i,j),h));
                    Trecv(r(i,j),h)=Trecv(r(i,j),h)+pLER(r(i,j),h);  
                    if (n(i,j)+1)<=BUFFER
                       n(i,j)=n(i,j)+1;
                       bfd(r(i,j),n(i,j))=Saddress(r(i,j),h)+IDSources(r(i,j),h)*10^-6;    % THE DECIMAL FRACTION CARRIES THE SENDER'S ID
                       bfi(r(i,j),n(i,j))=r(i,j)+h*10^-6;                                  % THE DECIMAL FRACTION CARRIES THE RECEIVER'S ID
                       ptime(r(i,j),n(i,j))=stdt(r(i,j),h)+1000000;                        % ADDING 1000000 TO ptime FOR ALL FEEDBACK PACKETS
                       psequence(r(i,j),n(i,j))=Trecv(r(i,j),h);                           % IT CARRIES BOTH MESSAGES OF THE AVERAGE INTERARRIVAL AND THE ESTIMATED LOSS RATE (THAT IS LESS THAN ONE, SO SET AS THE DECIMAL FRACTION), REFERRING TO THE LINE 156  
                    end
                    Trecv(r(i,j),h)=0;
                 end
                 RRTO(r(i,j),h)=SRTT(Saddress(r(i,j),h),IDSources(r(i,j),h));
              end
           end
        end    
     end
  end

% ROUTERS' OPERATION
  for aol=1:AL
     for i=1:L
        for j=1:L
          if n(i,j)>0
            Lr=j-1;
            Rr=j+1;
            Ur=i-1;
            Dr=i+1;
            if Lr==0
               Lr=L;
            end
            if Rr==(L+1)
               Rr=1;
            end
            if Ur==0
               Ur=L;
            end
            if Dr==(L+1)
               Dr=1;
            end
            if fix(bfd(r(i,j),1))==r(i,j)                                   % THE DESTINATION ROUTER OF THE CURRENT PACKET?
               if i==probenode
                  if j==probenode
                     xx(ii)=xx(ii)+1;
                  end
               end 
               if ptime(r(i,j),1)>1000000                                              % IS IT A FEEDBACK PACKET?
                  phhp=round(10^6*(bfd(r(i,j),1)-fix(bfd(r(i,j),1))));
                  if Daddress(r(i,j),phhp)==fix(bfi(r(i,j),1))
                     if Indica(r(i,j),phhp)==1
                        SRTT(r(i,j),phhp)=0.8*SRTT(r(i,j),phhp)+.2*(ptime(r(i,j),1)-1000000);      % ESTIMATING THE ROUND-TRIP TIME  
                        CRTO(r(i,j),phhp)=1;
                        DAP=fix(psequence(r(i,j),1));
                        if begint(r(i,j),phhp)==1                                                  % UPDATING Tcalc WITH FEEDBACK MESSAGES
                           if (psequence(r(i,j),1)-DAP)<=.0001
                              Tcalc(r(i,j),phhp)=max(min(max(Tcalc(r(i,j),phhp)/2,DAP/2),SRTT(r(i,j),phhp)),TLBOUND);
                           else
                              begint(r(i,j),phhp)=2;
                              Tcalc(r(i,j),phhp)=min(max((SRTT(r(i,j),phhp)*sqrt(2*(psequence(r(i,j),1)-DAP)/3)+4*SRTT(r(i,j),phhp)*3*sqrt(3*(psequence(r(i,j),1)-DAP)/8)*(psequence(r(i,j),1)-DAP)*(1+32*(psequence(r(i,j),1)-DAP)*(psequence(r(i,j),1)-DAP))),DAP/2),TUBOUND);
                           end
                        else 
                           if (psequence(r(i,j),1)-DAP)>.0001
                              Tcalc(r(i,j),phhp)=min(max((SRTT(r(i,j),phhp)*sqrt(2*(psequence(r(i,j),1)-DAP)/3)+4*SRTT(r(i,j),phhp)*3*sqrt(3*(psequence(r(i,j),1)-DAP)/8)*(psequence(r(i,j),1)-DAP)*(1+32*(psequence(r(i,j),1)-DAP)*(psequence(r(i,j),1)-DAP))),DAP/2),TUBOUND);
                           else
                              Tcalc(r(i,j),phhp)=min(max(Tcalc(r(i,j),phhp)/2,DAP/2),TUBOUND);
                           end
                        end
                        RTO(r(i,j),phhp)=max(4*SRTT(r(i,j),phhp),2*Tcalc(r(i,j),phhp));            % RESETTING THE NOFEEDBACK TIMER
                        PINTERVAL(r(i,j),phhp)=PINTERVAL(r(i,j),phhp)-1;
                        if PINTERVAL(r(i,j),phhp)==0
                           Indica(r(i,j),phhp)=0;
                           DAP=round(10^6*(bfi(r(i,j),1)-fix(bfi(r(i,j),1))));
                           SENO(Daddress(r(i,j),phhp),DAP)=0;IDSources(Daddress(r(i,j),phhp),DAP)=0;Saddress(Daddress(r(i,j),phhp),DAP)=0;RRTO(Daddress(r(i,j),phhp),DAP)=0;CRRTO(Daddress(r(i,j),phhp),DAP)=0;
                           stdt(Daddress(r(i,j),phhp),DAP)=0;CLER(Daddress(r(i,j),phhp),DAP)=0;Trecv(Daddress(r(i,j),phhp),DAP)=0;pLER(Daddress(r(i,j),phhp),DAP)=0;
                           Daddress(r(i,j),phhp)=-1;begint(r(i,j),phhp)=0;CLERp1(r(i,j),phhp)=0;CLERp2(r(i,j),phhp)=0;CLERp3(r(i,j),phhp)=0;CLERp4(r(i,j),phhp)=0;CLERp5(r(i,j),phhp)=0;CLERp6(r(i,j),phhp)=0;CLERp7(r(i,j),phhp)=0;CLERp8(r(i,j),phhp)=0;
                           PINTERVAL(r(i,j),phhp)=ceil(exprnd(lamd1));                             % THE DEFAULT SETTING OF "OFF" STATE IS THE EXPONENTIAL DISTRIBUTION
                           %ceil(rand^(-1/erfa)*(erfa-1)*lamd1/erfa);                              % IF "OFF" STATE PARETO, REPLACING THE RIGHT SIDE OF THE LINE 229 WITH THE LINE 230
                        end
                     end
                  end
               else
                  phhp=round(10^6*(bfd(r(i,j),1)-fix(bfd(r(i,j),1))));
                  if Saddress(r(i,j),phhp)==fix(bfi(r(i,j),1))
                     stdt(r(i,j),phhp)=ptime(r(i,j),1);
                     Trecv(r(i,j),phhp)=Trecv(r(i,j),phhp)+1;
                     if SENO(r(i,j),phhp)==psequence(r(i,j),1)                                     % EXPECTED SEQUENCE NUMBER?
                        SENO(r(i,j),phhp)=SENO(r(i,j),phhp)+1;
                        if CLER(r(i,j),phhp)~=0
                           CLER(r(i,j),phhp)=CLER(r(i,j),phhp)+1;
                        end
                     else
                        if CLER(r(i,j),phhp)==0
                           CLER(r(i,j),phhp)=1;
                        else
                           if CLER(r(i,j),phhp)~=1                                                 % CALCULATING THE LOSS RATE
                              CLERp2(r(i,j),phhp)=CLERp1(r(i,j),phhp);CLERp3(r(i,j),phhp)=CLERp4(r(i,j),phhp);CLERp4(r(i,j),phhp)=CLERp5(r(i,j),phhp);CLERp5(r(i,j),phhp)=CLERp6(r(i,j),phhp);CLERp6(r(i,j),phhp)=CLERp7(r(i,j),phhp);CLERp7(r(i,j),phhp)=CLERp8(r(i,j),phhp);
                              CLERp1(r(i,j),phhp)=CLER(r(i,j),phhp);
                              pLER(r(i,j),phhp)=6/(CLERp1(r(i,j),phhp)+CLERp2(r(i,j),phhp)+CLERp3(r(i,j),phhp)+CLERp4(r(i,j),phhp)+.8*CLERp5(r(i,j),phhp)+.6*CLERp6(r(i,j),phhp)+.4*CLERp7(r(i,j),phhp)+.2*CLERp8(r(i,j),phhp));
                              CLER(r(i,j),phhp)=1;
                           end
                        end
                        SENO(r(i,j),phhp)=psequence(r(i,j),1)+1;
                     end
                  end   
               end
               n(i,j)=n(i,j)-1;
               if n(i,j)>=2
                  bfd(r(i,j),1:n(i,j))=bfd(r(i,j),2:(n(i,j)+1));
                  ptime(r(i,j),1:n(i,j))=ptime(r(i,j),2:(n(i,j)+1));
                  bfi(r(i,j),1:n(i,j))=bfi(r(i,j),2:(n(i,j)+1));
                  psequence(r(i,j),1:n(i,j))=psequence(r(i,j),2:(n(i,j)+1));
               else
                  if n(i,j)==1
                     bfd(r(i,j),1)=bfd(r(i,j),2);
                     ptime(r(i,j),1)=ptime(r(i,j),2);
                     bfi(r(i,j),1)=bfi(r(i,j),2);
                     psequence(r(i,j),1)=psequence(r(i,j),2);
                  end
               end
            else                                  % ROUTING AND FORWARDING
               if fix(bfd(r(i,j),1))==r(Ur,j)
                  if i==probenode
                     if j==probenode
                        xxxu(ii)=xxxu(ii)+1;
                     end
                  end                    
                  n(Ur,j)=n(Ur,j)+1;
                  bfd(r(Ur,j),n(Ur,j))=bfd(r(i,j),1);
                  bfi(r(Ur,j),n(Ur,j))=bfi(r(i,j),1);
                  ptime(r(Ur,j),n(Ur,j))=ptime(r(i,j),1);
                  psequence(r(Ur,j),n(Ur,j))=psequence(r(i,j),1);
               else
                  if fix(bfd(r(i,j),1))==r(i,Rr)
                     n(i,Rr)=n(i,Rr)+1;
                     bfd(r(i,Rr),n(i,Rr))=bfd(r(i,j),1);
                     bfi(r(i,Rr),n(i,Rr))=bfi(r(i,j),1);
                     ptime(r(i,Rr),n(i,Rr))=ptime(r(i,j),1);
                     psequence(r(i,Rr),n(i,Rr))=psequence(r(i,j),1);
                  else
                     if fix(bfd(r(i,j),1))==r(Dr,j)
                        n(Dr,j)=n(Dr,j)+1;
                        bfd(r(Dr,j),n(Dr,j))=bfd(r(i,j),1);
                        bfi(r(Dr,j),n(Dr,j))=bfi(r(i,j),1);
                        ptime(r(Dr,j),n(Dr,j))=ptime(r(i,j),1);
                        psequence(r(Dr,j),n(Dr,j))=psequence(r(i,j),1);
                     else
                        if fix(bfd(r(i,j),1))==r(i,Lr)
                           if i==probenode
                              if j==probenode
                                 xxxl(ii)=xxxl(ii)+1;
                              end
                           end
                           n(i,Lr)=n(i,Lr)+1;
                           bfd(r(i,Lr),n(i,Lr))=bfd(r(i,j),1);
                           bfi(r(i,Lr),n(i,Lr))=bfi(r(i,j),1);
                           ptime(r(i,Lr),n(i,Lr))=ptime(r(i,j),1);
                           psequence(r(i,Lr),n(i,Lr))=psequence(r(i,j),1);
                        else
                           ddd1=L-abs(abs(Habscissa(fix(bfd(r(i,j),1)))-Ur)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),1)))-j)-L/2);
                           ddd2=L-abs(abs(Habscissa(fix(bfd(r(i,j),1)))-i)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),1)))-Rr)-L/2);
                           ddd3=L-abs(abs(Habscissa(fix(bfd(r(i,j),1)))-Dr)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),1)))-j)-L/2);
                           ddd4=L-abs(abs(Habscissa(fix(bfd(r(i,j),1)))-i)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),1)))-Lr)-L/2);
                           xxxmin=min([ddd1 ddd2 ddd3 ddd4]);
                           if ddd1==xxxmin
                              if ddd1==ddd2
                                 n(i,Rr)=n(i,Rr)+1;
                                 bfd(r(i,Rr),n(i,Rr))=bfd(r(i,j),1);
                                 bfi(r(i,Rr),n(i,Rr))=bfi(r(i,j),1);
                                 ptime(r(i,Rr),n(i,Rr))=ptime(r(i,j),1);
                                 psequence(r(i,Rr),n(i,Rr))=psequence(r(i,j),1);
                              else
                                 if i==probenode
                                    if j==probenode
                                       xxxu(ii)=xxxu(ii)+1;
                                    end
                                 end
                                 n(Ur,j)=n(Ur,j)+1;
                                 bfd(r(Ur,j),n(Ur,j))=bfd(r(i,j),1);
                                 bfi(r(Ur,j),n(Ur,j))=bfi(r(i,j),1);
                                 ptime(r(Ur,j),n(Ur,j))=ptime(r(i,j),1);
                                 psequence(r(Ur,j),n(Ur,j))=psequence(r(i,j),1);
                              end
                           else
                              if ddd2==xxxmin
                                 if ddd2==ddd3
                                    n(Dr,j)=n(Dr,j)+1;
                                    bfd(r(Dr,j),n(Dr,j))=bfd(r(i,j),1);
                                    bfi(r(Dr,j),n(Dr,j))=bfi(r(i,j),1);
                                    ptime(r(Dr,j),n(Dr,j))=ptime(r(i,j),1);
                                    psequence(r(Dr,j),n(Dr,j))=psequence(r(i,j),1);
                                 else
                                    n(i,Rr)=n(i,Rr)+1;
                                    bfd(r(i,Rr),n(i,Rr))=bfd(r(i,j),1);
                                    bfi(r(i,Rr),n(i,Rr))=bfi(r(i,j),1);
                                    ptime(r(i,Rr),n(i,Rr))=ptime(r(i,j),1);
                                    psequence(r(i,Rr),n(i,Rr))=psequence(r(i,j),1);
                                 end
                              else
                                 if ddd3==xxxmin
                                    if ddd3==ddd4
                                       if i==probenode
                                          if j==probenode
                                             xxxl(ii)=xxxl(ii)+1;
                                          end
                                       end
                                       n(i,Lr)=n(i,Lr)+1;
                                       bfd(r(i,Lr),n(i,Lr))=bfd(r(i,j),1);
                                       bfi(r(i,Lr),n(i,Lr))=bfi(r(i,j),1);
                                       ptime(r(i,Lr),n(i,Lr))=ptime(r(i,j),1);
                                       psequence(r(i,Lr),n(i,Lr))=psequence(r(i,j),1);
                                    else
                                       n(Dr,j)=n(Dr,j)+1;
                                       bfd(r(Dr,j),n(Dr,j))=bfd(r(i,j),1);
                                       bfi(r(Dr,j),n(Dr,j))=bfi(r(i,j),1);
                                       ptime(r(Dr,j),n(Dr,j))=ptime(r(i,j),1);
                                       psequence(r(Dr,j),n(Dr,j))=psequence(r(i,j),1);
                                    end
                                 else
                                    if i==probenode
                                       if j==probenode
                                          xxxl(ii)=xxxl(ii)+1;
                                       end
                                    end
                                    n(i,Lr)=n(i,Lr)+1;
                                    bfd(r(i,Lr),n(i,Lr))=bfd(r(i,j),1);
                                    bfi(r(i,Lr),n(i,Lr))=bfi(r(i,j),1);
                                    ptime(r(i,Lr),n(i,Lr))=ptime(r(i,j),1);
                                    psequence(r(i,Lr),n(i,Lr))=psequence(r(i,j),1);
                                 end
                              end
                           end   
                        end
                     end
                  end
               end
               n(i,j)=n(i,j)-1;
               if n(i,j)>BUFFER
                  n(i,j)=BUFFER;
               end
               if n(i,j)>=2
                  bfd(r(i,j),1:n(i,j))=bfd(r(i,j),2:(n(i,j)+1));
                  bfi(r(i,j),1:n(i,j))=bfi(r(i,j),2:(n(i,j)+1));
                  ptime(r(i,j),1:n(i,j))=ptime(r(i,j),2:(n(i,j)+1));
                  psequence(r(i,j),1:n(i,j))=psequence(r(i,j),2:(n(i,j)+1));
               else
                  if n(i,j)==1
                     bfd(r(i,j),1)=bfd(r(i,j),2);
                     bfi(r(i,j),1)=bfi(r(i,j),2);
                     ptime(r(i,j),1)=ptime(r(i,j),2);
                     psequence(r(i,j),1)=psequence(r(i,j),2);
                  end
               end
             end
          end  
        end
     end   
   end
   for i=1:L                                               % ptime ADDS ONE
      for j=1:L
        if n(i,j)>0
           ptime(r(i,j),1:n(i,j))=ptime(r(i,j),1:n(i,j))+1;
        end
        if n(i,j)>BUFFER
           n(i,j)=BUFFER;
        end
     end
   end
 end
end
xx=xx(10001:LONGTIME);                                     % CUT OUT THE TRANSIENT PROCESS
xxxu=xxxu(10001:LONGTIME);
xxxl=xxxl(10001:LONGTIME);

tt=cputime-tt;                                             % TOTAL EXECUTION TIME

save CAnewTFRC-3-v1K10AL5-on200-off2000 xx xxxu xxxl tt    % SAVE DATA TO A MAT-FILE