function [Lossrate] = ABILENEtdAS                    % FOUR TIERS, HETEROGENEOUS LINK/TOPOLOGY MODEL 


%************* GENERAL PARAMETERS **************

%*** ROUTER ***
L=161;                                           % THE TOTAL NUMBER OF ROUTERS
L1=11;                                           % THE NUMBER OF LAYER ONE ROUTERS
L2=40;                                           % THE NUMBER OF LAYER TWO ROUTERS   
L3=110;                                          % THE NUMBER OF LAYER THREE ROUTERS

LinkOneCapacity=160;                             % Link capacity on the layer one
LinkTwoCapacity=20;                              % Link capacity on the layer two
LinkThreeCapacity=5;                             % Link capacity on the layer three

mqTNR=0;rADDR(L)=0;
for i=1:L
    mqTNR=mqTNR+1;                               % mqTNR WILL BE THE TOTAL NUMBER OF ROUTERS
    rADDR(i)=mqTNR;                              % THE General Address of Each Router
end

rROUTINGa(L)=0;                                  % Clustering all Routers of Second and Third Layers to a Heterogeneous Topology 
rOBSERVATION(L)=0;                               % Setting Observation Pionts by rOBSERVATION
for i=12:L
    switch rADDR(i)
       case {12,13,14}
         rROUTINGa(rADDR(i))=122;
         rOBSERVATION(rADDR(i))=1; 
       case {15,16,17}
         rROUTINGa(rADDR(i))=123;
         rOBSERVATION(rADDR(i))=2;
       case {18,19}
         rROUTINGa(rADDR(i))=124;
         rOBSERVATION(rADDR(i))=3;
       case {20,21}
         rROUTINGa(rADDR(i))=125;
         rOBSERVATION(rADDR(i))=4;
       case {22,23}
         rROUTINGa(rADDR(i))=126;
         rOBSERVATION(rADDR(i))=5;
       case {24,25,26}
         rROUTINGa(rADDR(i))=127;
         rOBSERVATION(rADDR(i))=6;
       case {27,28,29,30,31}
         rROUTINGa(rADDR(i))=128;
         rOBSERVATION(rADDR(i))=7;
       case {32,33}
         rROUTINGa(rADDR(i))=129;
         rOBSERVATION(rADDR(i))=8;
       case {34,35}
         rROUTINGa(rADDR(i))=130;
         rOBSERVATION(rADDR(i))=9;
       case {36,37}
         rROUTINGa(rADDR(i))=131;
         rOBSERVATION(rADDR(i))=10;
       case {38,39,40}
         rROUTINGa(rADDR(i))=132;
         rOBSERVATION(rADDR(i))=11;
       case {41,42}
         rROUTINGa(rADDR(i))=133;
         rOBSERVATION(rADDR(i))=12;
       case {43,44,45,46}
         rROUTINGa(rADDR(i))=134;
         rOBSERVATION(rADDR(i))=13;
       case {47,48,49,50,51}
         rROUTINGa(rADDR(i))=135;
         rOBSERVATION(rADDR(i))=14;
       case {52,53}
         rROUTINGa(rADDR(i))=136;
         rOBSERVATION(rADDR(i))=15;
       case {54,55}
         rROUTINGa(rADDR(i))=137;
         rOBSERVATION(rADDR(i))=16;
       case {56,57}
         rROUTINGa(rADDR(i))=138;
         rOBSERVATION(rADDR(i))=17;
       case {58,59}
         rROUTINGa(rADDR(i))=139;
         rOBSERVATION(rADDR(i))=18;
       case {60,61}
         rROUTINGa(rADDR(i))=140;
         rOBSERVATION(rADDR(i))=19;
       case {62,63}
         rROUTINGa(rADDR(i))=141;
         rOBSERVATION(rADDR(i))=20;
       case {64,65,66,67}
         rROUTINGa(rADDR(i))=142;
         rOBSERVATION(rADDR(i))=21;
       case {68,69,70}
         rROUTINGa(rADDR(i))=143;
         rOBSERVATION(rADDR(i))=22;
       case {71,72}
         rROUTINGa(rADDR(i))=144; 
         rOBSERVATION(rADDR(i))=23;
       case {73,74,75}
         rROUTINGa(rADDR(i))=145;
         rOBSERVATION(rADDR(i))=24;
       case {76,77,78,79}
         rROUTINGa(rADDR(i))=146;
         rOBSERVATION(rADDR(i))=25;
       case {80,81}
         rROUTINGa(rADDR(i))=147;
         rOBSERVATION(rADDR(i))=26;
       case {82,83}
         rROUTINGa(rADDR(i))=148;
         rOBSERVATION(rADDR(i))=27;
       case {84,85,86,87}
         rROUTINGa(rADDR(i))=149; 
         rOBSERVATION(rADDR(i))=28;
       case {88,89,90}
         rROUTINGa(rADDR(i))=150;
         rOBSERVATION(rADDR(i))=29;
       case {91,92}
         rROUTINGa(rADDR(i))=151;
         rOBSERVATION(rADDR(i))=30;
       case {93,94}
         rROUTINGa(rADDR(i))=152; 
         rOBSERVATION(rADDR(i))=31;
       case {95,96}
         rROUTINGa(rADDR(i))=153;
         rOBSERVATION(rADDR(i))=32;
       case {97,98}
         rROUTINGa(rADDR(i))=154;
         rOBSERVATION(rADDR(i))=33;
       case {99,100,101}
         rROUTINGa(rADDR(i))=155;
         rOBSERVATION(rADDR(i))=34;
       case {102,103,104,105,106}
         rROUTINGa(rADDR(i))=156;
         rOBSERVATION(rADDR(i))=35;
       case {107,108}
         rROUTINGa(rADDR(i))=157; 
         rOBSERVATION(rADDR(i))=36;
       case {109,110,111,112,113}
         rROUTINGa(rADDR(i))=158;
         rOBSERVATION(rADDR(i))=37;
       case {114,115,116,117}
         rROUTINGa(rADDR(i))=159;
         rOBSERVATION(rADDR(i))=38;
       case {118,119}
         rROUTINGa(rADDR(i))=160;
         rOBSERVATION(rADDR(i))=39;
       case {120,121}
         rROUTINGa(rADDR(i))=161;
         rOBSERVATION(rADDR(i))=40;
       case {122,123,124}
         rROUTINGa(rADDR(i))=1;
       case {125,126,127,128}
         rROUTINGa(rADDR(i))=2;
       case {129,130}
         rROUTINGa(rADDR(i))=3;
       case {131,132,133,134,135}
         rROUTINGa(rADDR(i))=4;
       case {136,137,138}
         rROUTINGa(rADDR(i))=5;
       case {139,140,141,142}
         rROUTINGa(rADDR(i))=6;
       case {143,144}
         rROUTINGa(rADDR(i))=7;
       case {145,146,147,148}
         rROUTINGa(rADDR(i))=8;
       case {149,150,151}
         rROUTINGa(rADDR(i))=9;
       case {152,153,154,155,156}
         rROUTINGa(rADDR(i))=10;
       case {157,158,159,160,161}
         rROUTINGa(rADDR(i))=11;
    end
end

nQLR(L)=0;                                        % THE QUEUE LENGTH of Each Router
BUFFERouter=160;                                  % EACH BUFFER WITH LIMITED LENGTH QUEUE
bfd=zeros(L,BUFFERouter);                         % bfd(A,B) REPRESENTS THE DESTINATION ADDRESS OF THE Bth PACKET IN THE NODE A
bfi=zeros(L,BUFFERouter);                         % bfi(A,B) REPRESENTS THE SOURCE ADDRESS OF THE Bth PACKET IN THE NODE A
ptime=zeros(L,BUFFERouter);                       % ptime(A,B) REPRESENTS THE TIME EXPERIENCED BY THE Bth PACKET IN THE NODE A TILL NOW
psequence=zeros(L,BUFFERouter);                   % psequence(A,B) REPRESENTS THE SEQUENCE NUMBER OF THE Bth PACKET OF THE NODE A IN ITS OWN CONNECTION
                                                  %                     (2)
                                                  %                      |
                                                  %                (5)--(1)--(3)
                                                  %                      |
                                                  %                     (4)
                                               
                                                  
%*** CLIENT NODE ***

UK=200;                                           % THE NUMBER OF SOURCES ATTACHED EACH ROUTER AT LAYER TWO
UR=1000-UK;                                           % THE POSIBBLE NUMBER OF RECEIVERS OF EACH ROUTER AT LAYER TWO 
lamd=50;                                          % THE AVERAGE NUMBER OF PACKETS IN EACH "ON" STATE
lamd1=5000;                                      % THE AVERAGE TIME STEPS IDLING IN EACH "OFF" STATE
erfa=1.5;                                         % THE SHAPE PARAMETER OF PARETO DISTRIBUTION


%*** BACKBONE LINKS ***

dLinkT(1:28)=[50 50 60 60 60 60 20 20 40 40 100 100 50 50 35 35 45 45 35 35 20 20 35 35 25 25 15 15]/5;     % Backbone Link Delayes
nQLL(1:28)=0;                                                                                               % The Number of Packets Being Transmitted on The Link
Blinkdelay=zeros(28,(max(dLinkT)*LinkOneCapacity+1));                                                       % The Positions of Packets Being Transmitted on The Link
bfdLink=zeros(28,(max(dLinkT)*LinkOneCapacity));                        
bfiLink=zeros(28,(max(dLinkT)*LinkOneCapacity));                         
ptimeLink=zeros(28,(max(dLinkT)*LinkOneCapacity));                       
psequenceLink=zeros(28,(max(dLinkT)*LinkOneCapacity));

%*** OBSERVATION PARAMETERS ***

MTinterval=200;                                   % Monitoring INTERVAL
LONGTIME=4000;                                    % EXECUTION TIME (TOTAL TIME STEPS)
Lossrate(1:LONGTIME)=0;                           % Loss Rate
xmaxd(1:LONGTIME)=0;                              % The maximum number of connections toward one domain
xmaxda(1:LONGTIME)=0;                             % The address of the most congested domain
xz(1:LONGTIME)=0;                                 % The Number of Total Connections
AAX(1:4400,1:LONGTIME)=0;                         % REPRESENTS THE NUMBER OF PACKETS RECEIVED BY a Node from another Node DURING "MTinterval"; 
xq(1:LONGTIME)=0;xxq(1:LONGTIME)=0;               % Varying Queue Length
xxxq(1:LONGTIME)=0;


%*************** INITIALIZATION ***************** 

%*** SOURCE INITIALIZATION ***
for i=12:121
    for h=1:UK
        if rand<.25                                                           % 25% active sources at the beginning
            Indica(rADDR(i),h)=1;                                             % Indica = 0 (OR 1) WHEN THE NODE IS IN "OFF" (OR "ON") STATE
            begint(rADDR(i),h)=0;                                             % begint = 0 (BEFORE ENTERING SLOW-START), 1 (WAITING FOR ACK PACKETS WITHOUT LAUNCHING ANY PACKET), 2 (WITHIN CONGESTION AVOIDANCE), 3 (WITHIN THE SLOW-START), OR 4 ("OFF" STATE)
            PINTERVAL(rADDR(i),h)=ceil(rand^(-1/erfa)*(erfa-1)*lamd/erfa);    % PINTERVAL IS THE LENGTH OF "ON" OR "OFF" STATE FOR EACH SOURCE     
        else
            if rand<.33
                Indica(rADDR(i),h)=0;
                begint(rADDR(i),h)=4;
                PINTERVAL(rADDR(i),h)=ceil(rand^(-1/erfa)*(erfa-1)*.33*lamd1/erfa);
            else
                if rand<.5
                    Indica(rADDR(i),h)=0;                                             
                    begint(rADDR(i),h)=4;                                            
                    PINTERVAL(rADDR(i),h)=ceil(rand^(-1/erfa)*(erfa-1)*.66*lamd1/erfa);
                else
                    Indica(rADDR(i),h)=0;                                             
                    begint(rADDR(i),h)=4;                                            
                    PINTERVAL(rADDR(i),h)=ceil(rand^(-1/erfa)*(erfa-1)*lamd1/erfa);
                end
            end
            
        end
    end
end
Daddress(1:121,1:UK)=0;                                            % THE DESTINATION ADDRESS
DistanceSR(1:121,1:UK)=0;                                          % ESTIMATED ROUND-TRIP TIME BETWEEN THE SOURCE AND THE DESTINATION
IDReceivers(1:121,1:UK)=0;                                         % THE RECEIVER'S ID IN THE DESTINATION ROUTER
cwnd(1:121,1:UK)=0;                                                % cwnd IS THE CONGESTION WINDOW
ssthresh(1:121,1:UK)=16;                                           % THE SLOW-START THRESHOLD SIZE
nstate(1:121,1:UK)=1;                                              % HOW MANY PACKETS' ACK HAVE NOT BEEN RECEIVED REGARDING THE CURRENT cwnd
PINTERVALC(1:121,1:UK)=0;                                          % HOW MANY PACKETS HAVE NOT BEEN INJECTED REGARDING THE CURRENT cwnd
Sstate(1:121,1:UK)=1;                                              % THE SEQUENCE NUMBER OF THE PACKET THAT WILL BE LAUNCHED NEXT 
SRTT(1:121,1:UK)=0;                                                % THE ESTIMATED ROUND-TRIP TIME
RTO(1:121,1:UK)=0;                                                 % THE RETRANSMISSION TIMEOUT
CRTO(1:121,1:UK)=1;                                                % THE TIMER OF A CONNECTION'S TIMEOUT
TDistanceSR(1:L1,1:1:L1)=0;                                        % ESTIMATED ROUND-TRIP TIME BETWEEN TWO DOMAINS
for i=1:L1
    switch i 
       case {1}
         TDistanceSR(i,1)=50;                                      % ESTIMATED BUFFER DELAY
         TDistanceSR(i,2)=dLinkT(1)+dLinkT(2)+50;                  % LINK DELAY AND BUFFER DELAY
         TDistanceSR(i,3)=dLinkT(3)+dLinkT(4)+50;
         TDistanceSR(i,4)=dLinkT(1)+dLinkT(7)+dLinkT(8)+dLinkT(2)+50;
         TDistanceSR(i,5)=dLinkT(3)+dLinkT(9)+dLinkT(10)+dLinkT(4)+50;
         TDistanceSR(i,6)=dLinkT(1)+dLinkT(7)+dLinkT(11)+dLinkT(12)+dLinkT(8)+dLinkT(2)+50;
         TDistanceSR(i,7)=dLinkT(3)+dLinkT(9)+dLinkT(15)+dLinkT(16)+dLinkT(10)+dLinkT(4)+50;
         TDistanceSR(i,8)=dLinkT(3)+dLinkT(9)+dLinkT(15)+dLinkT(19)+dLinkT(20)+dLinkT(16)+dLinkT(10)+dLinkT(4)+50;
         TDistanceSR(i,9)=dLinkT(3)+dLinkT(9)+dLinkT(15)+dLinkT(21)+dLinkT(22)+dLinkT(16)+dLinkT(10)+dLinkT(4)+50;
         TDistanceSR(i,10)=dLinkT(1)+dLinkT(7)+dLinkT(11)+dLinkT(17)+dLinkT(23)+dLinkT(24)+dLinkT(18)+dLinkT(12)+dLinkT(8)+dLinkT(2)+50;
         TDistanceSR(i,11)=dLinkT(3)+dLinkT(9)+dLinkT(15)+dLinkT(21)+dLinkT(25)+dLinkT(26)+dLinkT(22)+dLinkT(16)+dLinkT(10)+dLinkT(4)+50;
       case {2}
         TDistanceSR(i,1)=dLinkT(2)+dLinkT(1)+50;
         TDistanceSR(i,2)=50;
         TDistanceSR(i,3)=dLinkT(5)+dLinkT(6)+50;
         TDistanceSR(i,4)=dLinkT(7)+dLinkT(8)+50;
         TDistanceSR(i,5)=dLinkT(5)+dLinkT(9)+dLinkT(10)+dLinkT(6)+50;
         TDistanceSR(i,6)=dLinkT(7)+dLinkT(11)+dLinkT(12)+dLinkT(8)+50;
         TDistanceSR(i,7)=dLinkT(5)+dLinkT(9)+dLinkT(15)+dLinkT(16)+dLinkT(10)+dLinkT(6)+50;
         TDistanceSR(i,8)=dLinkT(7)+dLinkT(11)+dLinkT(17)+dLinkT(18)+dLinkT(12)+dLinkT(8)+50;
         TDistanceSR(i,9)=dLinkT(5)+dLinkT(9)+dLinkT(15)+dLinkT(21)+dLinkT(22)+dLinkT(16)+dLinkT(10)+dLinkT(6)+50;
         TDistanceSR(i,10)=dLinkT(7)+dLinkT(11)+dLinkT(17)+dLinkT(23)+dLinkT(24)+dLinkT(18)+dLinkT(12)+dLinkT(8)+50;
         TDistanceSR(i,11)=dLinkT(5)+dLinkT(9)+dLinkT(15)+dLinkT(21)+dLinkT(25)+dLinkT(26)+dLinkT(22)+dLinkT(16)+dLinkT(10)+dLinkT(6)+50;
       case {3}
         TDistanceSR(i,1)=dLinkT(4)+dLinkT(3)+50;
         TDistanceSR(i,2)=dLinkT(6)+dLinkT(5)+50;
         TDistanceSR(i,3)=50;
         TDistanceSR(i,4)=dLinkT(6)+dLinkT(7)+dLinkT(8)+dLinkT(5)+50;
         TDistanceSR(i,5)=dLinkT(9)+dLinkT(10)+50;
         TDistanceSR(i,6)=dLinkT(9)+dLinkT(13)+dLinkT(14)+dLinkT(10)+50;
         TDistanceSR(i,7)=dLinkT(9)+dLinkT(15)+dLinkT(16)+dLinkT(10)+50;
         TDistanceSR(i,8)=dLinkT(9)+dLinkT(15)+dLinkT(19)+dLinkT(20)+dLinkT(16)+dLinkT(10)+50;
         TDistanceSR(i,9)=dLinkT(9)+dLinkT(15)+dLinkT(21)+dLinkT(22)+dLinkT(16)+dLinkT(10)+50;
         TDistanceSR(i,10)=dLinkT(9)+dLinkT(15)+dLinkT(19)+dLinkT(23)+dLinkT(24)+dLinkT(20)+dLinkT(16)+dLinkT(10)+50;
         TDistanceSR(i,11)=dLinkT(9)+dLinkT(15)+dLinkT(21)+dLinkT(25)+dLinkT(26)+dLinkT(22)+dLinkT(16)+dLinkT(10)+50;
       case {4}
         TDistanceSR(i,1)=dLinkT(8)+dLinkT(2)+dLinkT(1)+dLinkT(7)+50;
         TDistanceSR(i,2)=dLinkT(7)+dLinkT(8)+50;
         TDistanceSR(i,3)=dLinkT(8)+dLinkT(5)+dLinkT(6)+dLinkT(7)+50;
         TDistanceSR(i,4)=50;
         TDistanceSR(i,5)=dLinkT(8)+dLinkT(5)+dLinkT(9)+dLinkT(10)+dLinkT(6)+dLinkT(7)+50;
         TDistanceSR(i,6)=dLinkT(11)+dLinkT(12)+50;
         TDistanceSR(i,7)=dLinkT(11)+dLinkT(14)+dLinkT(15)+dLinkT(16)+dLinkT(13)+dLinkT(12)+50;
         TDistanceSR(i,8)=dLinkT(11)+dLinkT(17)+dLinkT(18)+dLinkT(12)+50;
         TDistanceSR(i,9)=dLinkT(11)+dLinkT(17)+dLinkT(20)+dLinkT(21)+dLinkT(22)+dLinkT(19)+dLinkT(18)+dLinkT(12)+50;
         TDistanceSR(i,10)=dLinkT(11)+dLinkT(17)+dLinkT(23)+dLinkT(24)+dLinkT(18)+dLinkT(12)+50;
         TDistanceSR(i,11)=dLinkT(11)+dLinkT(17)+dLinkT(23)+dLinkT(27)+dLinkT(28)+dLinkT(24)+dLinkT(18)+dLinkT(12)+50;
       case {5}
         TDistanceSR(i,1)=dLinkT(10)+dLinkT(4)+dLinkT(3)+dLinkT(9)+50;
         TDistanceSR(i,2)=dLinkT(10)+dLinkT(6)+dLinkT(5)+dLinkT(9)+50;
         TDistanceSR(i,3)=dLinkT(10)+dLinkT(9)+50;
         TDistanceSR(i,4)=dLinkT(13)+dLinkT(12)+dLinkT(11)+dLinkT(14)+50;
         TDistanceSR(i,5)=50;
         TDistanceSR(i,6)=dLinkT(13)+dLinkT(14)+50;
         TDistanceSR(i,7)=dLinkT(15)+dLinkT(16)+50;
         TDistanceSR(i,8)=dLinkT(15)+dLinkT(19)+dLinkT(20)+dLinkT(16)+50;
         TDistanceSR(i,9)=dLinkT(15)+dLinkT(21)+dLinkT(22)+dLinkT(16)+50;
         TDistanceSR(i,10)=dLinkT(15)+dLinkT(19)+dLinkT(23)+dLinkT(24)+dLinkT(20)+dLinkT(16)+50;
         TDistanceSR(i,11)=dLinkT(15)+dLinkT(21)+dLinkT(25)+dLinkT(26)+dLinkT(22)+dLinkT(16)+50;
       case {6}
         TDistanceSR(i,1)=dLinkT(12)+dLinkT(8)+dLinkT(2)+dLinkT(1)+dLinkT(7)+dLinkT(11)+50;
         TDistanceSR(i,2)=dLinkT(12)+dLinkT(8)+dLinkT(7)+dLinkT(11)+50;
         TDistanceSR(i,3)=dLinkT(14)+dLinkT(10)+dLinkT(9)+dLinkT(13)+50;
         TDistanceSR(i,4)=dLinkT(12)+dLinkT(11)+50;
         TDistanceSR(i,5)=dLinkT(14)+dLinkT(13)+50;
         TDistanceSR(i,6)=50;
         TDistanceSR(i,7)=dLinkT(14)+dLinkT(15)+dLinkT(16)+dLinkT(13)+50;
         TDistanceSR(i,8)=dLinkT(17)+dLinkT(18)+50;
         TDistanceSR(i,9)=dLinkT(17)+dLinkT(20)+dLinkT(21)+dLinkT(22)+dLinkT(19)+dLinkT(18)+50;
         TDistanceSR(i,10)=dLinkT(17)+dLinkT(23)+dLinkT(24)+dLinkT(18)+50;
         TDistanceSR(i,11)=dLinkT(17)+dLinkT(23)+dLinkT(27)+dLinkT(28)+dLinkT(24)+dLinkT(18)+50;
       case {7}
         TDistanceSR(i,1)=dLinkT(16)+dLinkT(10)+dLinkT(4)+dLinkT(3)+dLinkT(9)+dLinkT(15)+50;
         TDistanceSR(i,2)=dLinkT(16)+dLinkT(10)+dLinkT(6)+dLinkT(5)+dLinkT(9)+dLinkT(15)+50;
         TDistanceSR(i,3)=dLinkT(16)+dLinkT(10)+dLinkT(9)+dLinkT(15)+50;
         TDistanceSR(i,4)=dLinkT(19)+dLinkT(18)+dLinkT(12)+dLinkT(11)+dLinkT(17)+dLinkT(20)+50;
         TDistanceSR(i,5)=dLinkT(16)+dLinkT(15)+50;
         TDistanceSR(i,6)=dLinkT(19)+dLinkT(18)+dLinkT(17)+dLinkT(20)+50;
         TDistanceSR(i,7)=50;
         TDistanceSR(i,8)=dLinkT(19)+dLinkT(20)+50;
         TDistanceSR(i,9)=dLinkT(21)+dLinkT(22)+50;
         TDistanceSR(i,10)=dLinkT(19)+dLinkT(23)+dLinkT(24)+dLinkT(20)+50;
         TDistanceSR(i,11)=dLinkT(21)+dLinkT(25)+dLinkT(26)+dLinkT(22)+50;
       case {8}
         TDistanceSR(i,1)=dLinkT(18)+dLinkT(12)+dLinkT(8)+dLinkT(2)+dLinkT(1)+dLinkT(7)+dLinkT(11)+dLinkT(17)+50;
         TDistanceSR(i,2)=dLinkT(18)+dLinkT(12)+dLinkT(8)+dLinkT(7)+dLinkT(11)+dLinkT(17)+50;
         TDistanceSR(i,3)=dLinkT(20)+dLinkT(16)+dLinkT(10)+dLinkT(9)+dLinkT(15)+dLinkT(19)+50;
         TDistanceSR(i,4)=dLinkT(18)+dLinkT(12)+dLinkT(11)+dLinkT(17)+50;
         TDistanceSR(i,5)=dLinkT(20)+dLinkT(16)+dLinkT(15)+dLinkT(19)+50;
         TDistanceSR(i,6)=dLinkT(18)+dLinkT(17)+50;
         TDistanceSR(i,7)=dLinkT(20)+dLinkT(19)+50;
         TDistanceSR(i,8)=50;
         TDistanceSR(i,9)=dLinkT(20)+dLinkT(21)+dLinkT(22)+dLinkT(19)+50;
         TDistanceSR(i,10)=dLinkT(23)+dLinkT(24)+50;
         TDistanceSR(i,11)=dLinkT(23)+dLinkT(27)+dLinkT(28)+dLinkT(24)+50;
       case {9}
         TDistanceSR(i,1)=dLinkT(22)+dLinkT(16)+dLinkT(10)+dLinkT(4)+dLinkT(3)+dLinkT(9)+dLinkT(15)+dLinkT(21)+50;
         TDistanceSR(i,2)=dLinkT(22)+dLinkT(16)+dLinkT(10)+dLinkT(6)+dLinkT(5)+dLinkT(9)+dLinkT(15)+dLinkT(21)+50;
         TDistanceSR(i,3)=dLinkT(22)+dLinkT(16)+dLinkT(10)+dLinkT(9)+dLinkT(15)+dLinkT(21)+50;
         TDistanceSR(i,4)=dLinkT(22)+dLinkT(19)+dLinkT(18)+dLinkT(12)+dLinkT(11)+dLinkT(17)+dLinkT(20)+dLinkT(21)+50;
         TDistanceSR(i,5)=dLinkT(22)+dLinkT(16)+dLinkT(15)+dLinkT(21)+50;
         TDistanceSR(i,6)=dLinkT(22)+dLinkT(19)+dLinkT(18)+dLinkT(17)+dLinkT(20)+dLinkT(21)+50;
         TDistanceSR(i,7)=dLinkT(22)+dLinkT(21)+50;
         TDistanceSR(i,8)=dLinkT(22)+dLinkT(19)+dLinkT(20)+dLinkT(21)+50;
         TDistanceSR(i,9)=50;
         TDistanceSR(i,10)=dLinkT(25)+dLinkT(28)+dLinkT(27)+dLinkT(26)+50;
         TDistanceSR(i,11)=dLinkT(25)+dLinkT(26)+50;
       case {10}
         TDistanceSR(i,1)=dLinkT(24)+dLinkT(18)+dLinkT(12)+dLinkT(8)+dLinkT(2)+dLinkT(1)+dLinkT(7)+dLinkT(11)+dLinkT(17)+dLinkT(23)+50;
         TDistanceSR(i,2)=dLinkT(24)+dLinkT(18)+dLinkT(12)+dLinkT(8)+dLinkT(7)+dLinkT(11)+dLinkT(17)+dLinkT(23)+50;
         TDistanceSR(i,3)=dLinkT(24)+dLinkT(20)+dLinkT(16)+dLinkT(10)+dLinkT(9)+dLinkT(15)+dLinkT(19)+dLinkT(23)+50;
         TDistanceSR(i,4)=dLinkT(24)+dLinkT(18)+dLinkT(12)+dLinkT(11)+dLinkT(17)+dLinkT(23)+50;
         TDistanceSR(i,5)=dLinkT(24)+dLinkT(20)+dLinkT(16)+dLinkT(15)+dLinkT(19)+dLinkT(23)+50;
         TDistanceSR(i,6)=dLinkT(24)+dLinkT(18)+dLinkT(17)+dLinkT(23)+50;
         TDistanceSR(i,7)=dLinkT(24)+dLinkT(20)+dLinkT(19)+dLinkT(23)+50;
         TDistanceSR(i,8)=dLinkT(24)+dLinkT(23)+50;
         TDistanceSR(i,9)=dLinkT(27)+dLinkT(26)+dLinkT(25)+dLinkT(28)+50;
         TDistanceSR(i,10)=50;
         TDistanceSR(i,11)=dLinkT(27)+dLinkT(28)+50;
       case {11}
         TDistanceSR(i,1)=dLinkT(26)+dLinkT(22)+dLinkT(16)+dLinkT(10)+dLinkT(4)+dLinkT(3)+dLinkT(9)+dLinkT(15)+dLinkT(21)+dLinkT(25)+50;
         TDistanceSR(i,2)=dLinkT(28)+dLinkT(24)+dLinkT(18)+dLinkT(12)+dLinkT(8)+dLinkT(7)+dLinkT(11)+dLinkT(17)+dLinkT(23)+dLinkT(27)+50;
         TDistanceSR(i,3)=dLinkT(26)+dLinkT(22)+dLinkT(16)+dLinkT(10)+dLinkT(9)+dLinkT(15)+dLinkT(21)+dLinkT(25)+50;
         TDistanceSR(i,4)=dLinkT(28)+dLinkT(24)+dLinkT(18)+dLinkT(12)+dLinkT(11)+dLinkT(17)+dLinkT(23)+dLinkT(27)+50;
         TDistanceSR(i,5)=dLinkT(26)+dLinkT(22)+dLinkT(16)+dLinkT(15)+dLinkT(21)+dLinkT(25)+50;
         TDistanceSR(i,6)=dLinkT(28)+dLinkT(24)+dLinkT(18)+dLinkT(17)+dLinkT(23)+dLinkT(27)+50;
         TDistanceSR(i,7)=dLinkT(26)+dLinkT(22)+dLinkT(21)+dLinkT(25)+50;
         TDistanceSR(i,8)=dLinkT(28)+dLinkT(24)+dLinkT(23)+dLinkT(27)+50;
         TDistanceSR(i,9)=dLinkT(26)+dLinkT(25)+50;
         TDistanceSR(i,10)=dLinkT(28)+dLinkT(27)+50;
         TDistanceSR(i,11)=50;
    end
end

Plamd1(1:161)=1;   %[1.4 1.2 1.0 0.8 0.6 0.4 0.6 0.8 1.0 1.2 1.4];     % Traffic Load Control Parameter
%Plamd1PERIOD=500;                                               % Traffic Load Control UPDATE RATE
Plamd1PC=0;                                                      % UPDATE COUNTER

%*** RECEIVER INITIALIZATION ***
SENO(1:121,1:UR)=0;                                % THE EXPECTED SEQUENCE NUMBER IN A RECEIVER
Saddress(1:121,1:UR)=0;                            % THE SENDER'S ADDRESS
Sindica(1:121,1:UR)=0;
SRactive(1:121,1:UR)=0;
SPTIME01(1:121,1:UR)=0;
SPTIME02(1:121,1:UR)=0;
SPTIME03(1:121,1:UR)=0;
SPTIME04(1:121,1:UR)=0;
SPTIME05(1:121,1:UR)=0;



%*******************  STARTING  *******************

tt=cputime;                                          % STARTING TIME
TOUT=0;TIN=0;                                        % TIN/TOUT: Total OUTBOUND/INBOUND Packets 
SPECIALDaddress=83;
hotspotprobablity=.05;

for ii=1:LONGTIME
    Tinput=0;                                        % Tinput/Toutput: The Amount of OUTBOUND/INBOUND Packets during one MTinterval
    Toutput=0;
    for k=1:MTinterval
       %--------- SOURCE OPERATION ----------  
        for i=12:121
            for h=1:UK 
                if Indica(rADDR(i),h)==1                                % "ON" STATE?
                    if begint(rADDR(i),h)==0
                        Daddress(rADDR(i),h)=rADDR(i);
                        while rROUTINGa(rROUTINGa(Daddress(rADDR(i),h)))==rROUTINGa(rROUTINGa(rADDR(i)))        % FIND A RECEIVER THAT SATISFIES REQUIMENTS
                            if rand>hotspotprobablity
                                Daddress(rADDR(i),h)=fix(rand*110)+12;
                            else
                                Daddress(rADDR(i),h)=SPECIALDaddress;
                            end
                            phhp=1;DAP=SENO(Daddress(rADDR(i),h),phhp);
                            while DAP~=0
                                phhp=phhp+1;
                                if phhp>UR
                                    Daddress(rADDR(i),h)=rADDR(i); 
                                    DAP=0;
                                else
                                    DAP=SENO(Daddress(rADDR(i),h),phhp);
                                end
                            end
                        end
                        IDReceivers(rADDR(i),h)=phhp;
                        SENO(Daddress(rADDR(i),h),phhp)=1;
                        Saddress(Daddress(rADDR(i),h),phhp)=rADDR(i);
                        SRactive(Daddress(rADDR(i),h),phhp)=1;
                        Tinput=Tinput+1; 
                        if (nQLR(i)+1)<=BUFFERouter
                            nQLR(i)=nQLR(i)+1;
                            bfd(rADDR(i),nQLR(i))=Daddress(rADDR(i),h)+phhp*10^-6;        % THE DECIMAL FRACTION CARRIES THE RECEIVER'S ID IN THE DESTINATION ROUTER
                            bfi(rADDR(i),nQLR(i))=rADDR(i)+h*10^-6;                       % THE DECIMAL FRACTION CARRIES THE SENDER'S ID
                            ptime(rADDR(i),nQLR(i))=1;
                            psequence(rADDR(i),nQLR(i))=1;
                            nodeik01=(Daddress(rADDR(i),h)-12)*40+rOBSERVATION(rADDR(i));
                            AAX(nodeik01,ii)=AAX(nodeik01,ii)+1;
                        end
                        cwnd(rADDR(i),h)=1;ssthresh(rADDR(i),h)=16;PINTERVALC(rADDR(i),h)=0;
                        DistanceSR(rADDR(i),h)=TDistanceSR(rROUTINGa(rROUTINGa(rADDR(i))),rROUTINGa(rROUTINGa(Daddress(rADDR(i),h))));
                        SRTT(rADDR(i),h)=DistanceSR(rADDR(i),h);
                        RTO(rADDR(i),h)=SRTT(rADDR(i),h)*2;
                        begint(rADDR(i),h)=3;CRTO(rADDR(i),h)=1;nstate(rADDR(i),h)=1;Sstate(rADDR(i),h)=2;
                    else
                        CRTO(rADDR(i),h)=CRTO(rADDR(i),h)+1; 
                        if CRTO(rADDR(i),h)>=RTO(rADDR(i),h)                            % TIMEOUT?
                            ssthresh(rADDR(i),h)=16;cwnd(rADDR(i),h)=1;PINTERVALC(rADDR(i),h)=cwnd(rADDR(i),h);begint(rADDR(i),h)=2;
                            RTO(rADDR(i),h)=min(32*DistanceSR(rADDR(i),h),2*RTO(rADDR(i),h));CRTO(rADDR(i),h)=1;nstate(rADDR(i),h)=cwnd(rADDR(i),h);
                        end
                        if begint(rADDR(i),h)>=2
                            if PINTERVALC(rADDR(i),h)>0
                                Tinput=Tinput+1;
                                if (nQLR(i)+1)<=BUFFERouter
                                    nQLR(i)=nQLR(i)+1;
                                    bfd(rADDR(i),nQLR(i))=Daddress(rADDR(i),h)+IDReceivers(rADDR(i),h)*10^-6;        % THE DECIMAL FRACTION CARRIES THE RECEIVER'S ID IN THE DESTINATION ROUTER
                                    bfi(rADDR(i),nQLR(i))=rADDR(i)+h*10^-6;                                        % THE DECIMAL FRACTION CARRIES THE SENDER'S ID
                                    ptime(rADDR(i),nQLR(i))=1;
                                    psequence(rADDR(i),nQLR(i))=Sstate(rADDR(i),h);
                                    nodeik01=(Daddress(rADDR(i),h)-12)*40+rOBSERVATION(rADDR(i));
                                    AAX(nodeik01,ii)=AAX(nodeik01,ii)+1;
                                end
                                Sstate(rADDR(i),h)=Sstate(rADDR(i),h)+1;
                                PINTERVALC(rADDR(i),h)=PINTERVALC(rADDR(i),h)-1;
                                if begint(rADDR(i),h)==2
                                    if PINTERVALC(rADDR(i),h)==0
                                        begint(rADDR(i),h)=1;
                                    end
                                end
                            end
                        end
                    end      
                else                                                               % "OFF" STATE
                    PINTERVAL(rADDR(i),h)=PINTERVAL(rADDR(i),h)-1;
                    if PINTERVAL(rADDR(i),h)==0
                        Indica(rADDR(i),h)=1;
                        begint(rADDR(i),h)=0;
                        PINTERVAL(rADDR(i),h)=ceil(rand^(-1/erfa)*(erfa-1)*lamd/erfa);   % PARETO DISTRIBUTION
                                             %ceil(exprnd(lamd));                        % EXPONENTIAL 
                                             %ceil(lognrnd(MU,SIGMA));                   % LOGNORMAL
                    end
                end
            end
        end
       %/////---------------------------------------/////
       
       
       %--------- RECEIVER OPERATION ----------
        for i=12:121
            for h=1:UR
                if Sindica(rADDR(i),h)>0
                    Sindica(rADDR(i),h)=Sindica(rADDR(i),h)-1;
                    if Saddress(rADDR(i),h)~=0
                        if SPTIME01(rADDR(i),h)~=0
                            if SPTIME01(rADDR(i),h)>0
                                if (nQLR(i)+1)<=BUFFERouter
                                    nQLR(i)=nQLR(i)+1;
                                    bfd(rADDR(i),nQLR(i))=Saddress(rADDR(i),h)+SPTIME01(rADDR(i),h)-fix(SPTIME01(rADDR(i),h));
                                    bfi(rADDR(i),nQLR(i))=rADDR(i)+h*10^-6;
                                    ptime(rADDR(i),nQLR(i))=1000000+fix(SPTIME01(rADDR(i),h));             
                                    psequence(rADDR(i),nQLR(i))=0;
                                    nodeik01=(Saddress(rADDR(i),h)-12)*40+rOBSERVATION(rADDR(i));
                                    AAX(nodeik01,ii)=AAX(nodeik01,ii)+1;
                                end
                            else
                                if (nQLR(i)+1)<=BUFFERouter
                                    nQLR(i)=nQLR(i)+1;
                                    bfd(rADDR(i),nQLR(i))=Saddress(rADDR(i),h)+abs(SPTIME01(rADDR(i),h)-fix(SPTIME01(rADDR(i),h)));
                                    bfi(rADDR(i),nQLR(i))=rADDR(i)+h*10^-6;
                                    ptime(rADDR(i),nQLR(i))=1000000+abs(fix(SPTIME01(rADDR(i),h)));             
                                    psequence(rADDR(i),nQLR(i))=-1; 
                                    nodeik01=(Saddress(rADDR(i),h)-12)*40+rOBSERVATION(rADDR(i));
                                    AAX(nodeik01,ii)=AAX(nodeik01,ii)+1;
                                end
                            end
                            SPTIME01(rADDR(i),h)=SPTIME02(rADDR(i),h);SPTIME02(rADDR(i),h)=SPTIME03(rADDR(i),h);SPTIME03(rADDR(i),h)=SPTIME04(rADDR(i),h);SPTIME04(rADDR(i),h)=SPTIME05(rADDR(i),h);SPTIME05(rADDR(i),h)=0;
                        end
                    else
                        Sindica(rADDR(i),h)=0;
                        SPTIME01(rADDR(i),h)=0;SPTIME02(rADDR(i),h)=0;SPTIME03(rADDR(i),h)=0;SPTIME04(rADDR(i),h)=0;SPTIME05(rADDR(i),h)=0;
                    end 
                end
            end
        end
       %/////---------------------------------------/////

       
       %--------- ROUTER OPERATIONS OF LAYER THREE/TWO/ONE  ----------
       
        for aolayer2=1:LinkThreeCapacity 
            
            %------ ROUTER OPERATIONS OF LAYER THREE ------
            for i=12:121
                if nQLR(i)>=1                                       
                    if (fix(bfi(rADDR(i),1))-rADDR(i))~=0                      % Not OUT?   
                        if ptime(rADDR(i),1)>1000000                         % IS IT A ACK PACKET?   
                            phhp=round(10^6*(bfd(rADDR(i),1)-fix(bfd(rADDR(i),1))));
                            if fix(bfi(rADDR(i),1))==Daddress(rADDR(i),phhp)
                                if Indica(rADDR(i),phhp)==1
                                    SRTT(rADDR(i),phhp)=0.8*SRTT(rADDR(i),phhp)+.2*(ptime(rADDR(i),1)-1000000);
                                    RTO(rADDR(i),phhp)=min(32*DistanceSR(rADDR(i),phhp),max(DistanceSR(rADDR(i),phhp),1.5*SRTT(rADDR(i),phhp)));
                                    if psequence(rADDR(i),1)==-1
                                        nstate(rADDR(i),phhp)=0;
                                    else
                                        nstate(rADDR(i),phhp)=nstate(rADDR(i),phhp)-1;
                                    end
                                    if nstate(rADDR(i),phhp)==0
                                        CRTO(rADDR(i),phhp)=1;
                                        if psequence(rADDR(i),1)==-1
                                            ssthresh(rADDR(i),phhp)=ceil(.5*cwnd(rADDR(i),phhp));
                                            cwnd(rADDR(i),phhp)=ceil(.5*cwnd(rADDR(i),phhp));
                                            PINTERVALC(rADDR(i),phhp)=cwnd(rADDR(i),phhp);
                                            nstate(rADDR(i),phhp)=cwnd(rADDR(i),phhp);
                                            begint(rADDR(i),phhp)=2;
                                        else
                                            if begint(rADDR(i),phhp)==3
                                                if cwnd(rADDR(i),phhp)<ssthresh(rADDR(i),phhp)
                                                    cwnd(rADDR(i),phhp)=cwnd(rADDR(i),phhp)*2;
                                                else
                                                    cwnd(rADDR(i),phhp)=cwnd(rADDR(i),phhp)+1;
                                                    begint(rADDR(i),phhp)=2;
                                                end
                                            else   
                                                cwnd(rADDR(i),phhp)=cwnd(rADDR(i),phhp)+1;
                                                begint(rADDR(i),phhp)=2;
                                            end
                                        end
                                        PINTERVALC(rADDR(i),phhp)=cwnd(rADDR(i),phhp);
                                        nstate(rADDR(i),phhp)=cwnd(rADDR(i),phhp);
                                    end
                                    PINTERVAL(rADDR(i),phhp)=PINTERVAL(rADDR(i),phhp)-1;
                                    if PINTERVAL(rADDR(i),phhp)==0
                                        Indica(rADDR(i),phhp)=0;
                                        DAP01=round(10^6*(bfi(rADDR(i),1)-fix(bfi(rADDR(i),1))));
                                        SENO(Daddress(rADDR(i),phhp),DAP01)=0;Saddress(Daddress(rADDR(i),phhp),DAP01)=0;Sindica(Daddress(rADDR(i),phhp),DAP01)=0;
                                        SPTIME01(Daddress(rADDR(i),phhp),DAP01)=0;SPTIME02(Daddress(rADDR(i),phhp),DAP01)=0;SPTIME03(Daddress(rADDR(i),phhp),DAP01)=0;SPTIME04(Daddress(rADDR(i),phhp),DAP01)=0;SPTIME05(Daddress(rADDR(i),phhp),DAP01)=0;
                                        SRactive(Daddress(rADDR(i),phhp),DAP01)=0;
                                        Daddress(rADDR(i),phhp)=-1;begint(rADDR(i),phhp)=4;
                                        PINTERVAL(rADDR(i),phhp)=ceil(rand^(-1/erfa)*(erfa-1)*Plamd1(rROUTINGa(rADDR(i)))*lamd1/erfa);              % "OFF" STATE PARETO
                                    end
                                end
                            end
                        else
                            phhp=round(10^6*(bfd(rADDR(i),1)-fix(bfd(rADDR(i),1)))); 
                            h1=round(10^6*(bfi(rADDR(i),1)-fix(bfi(rADDR(i),1))));
                            Toutput=Toutput+1;
                            if Saddress(rADDR(i),phhp)==fix(bfi(rADDR(i),1))                           %Indica(fix(bfi(rADDR(i),1)),h1)==1
                                Sindica(rADDR(i),phhp)=Sindica(rADDR(i),phhp)+1;
                                if SPTIME01(rADDR(i),phhp)==0
                                    if SENO(rADDR(i),phhp)==psequence(rADDR(i),1)                      % EXPECTED SEQUENCE NUMBER?
                                        SENO(rADDR(i),phhp)=SENO(rADDR(i),phhp)+1;
                                        SPTIME01(rADDR(i),phhp)=ptime(rADDR(i),1)+h1*10^-6;
                                    else
                                        SENO(rADDR(i),phhp)=psequence(rADDR(i),1)+1;
                                        SPTIME01(rADDR(i),phhp)=-1*(ptime(rADDR(i),1)+h1*10^-6);
                                    end
                                else
                                    if SPTIME02(rADDR(i),phhp)==0
                                        if SENO(rADDR(i),phhp)==psequence(rADDR(i),1)                  % EXPECTED SEQUENCE NUMBER?
                                            SENO(rADDR(i),phhp)=SENO(rADDR(i),phhp)+1;
                                            SPTIME02(rADDR(i),phhp)=ptime(rADDR(i),1)+h1*10^-6;
                                        else
                                            SENO(rADDR(i),phhp)=psequence(rADDR(i),1)+1;
                                            SPTIME02(rADDR(i),phhp)=-1*(ptime(rADDR(i),1)+h1*10^-6);
                                        end
                                    else
                                        if SPTIME03(rADDR(i),phhp)==0
                                            if SENO(rADDR(i),phhp)==psequence(rADDR(i),1)              % EXPECTED SEQUENCE NUMBER?
                                                SENO(rADDR(i),phhp)=SENO(rADDR(i),phhp)+1;
                                                SPTIME03(rADDR(i),phhp)=ptime(rADDR(i),1)+h1*10^-6;
                                            else
                                                SENO(rADDR(i),phhp)=psequence(rADDR(i),1)+1;
                                                SPTIME03(rADDR(i),phhp)=-1*(ptime(rADDR(i),1)+h1*10^-6);
                                            end
                                        else
                                            if SPTIME04(rADDR(i),phhp)==0
                                                if SENO(rADDR(i),phhp)==psequence(rADDR(i),1)                  % EXPECTED SEQUENCE NUMBER?
                                                    SENO(rADDR(i),phhp)=SENO(rADDR(i),phhp)+1;
                                                    SPTIME04(rADDR(i),phhp)=ptime(rADDR(i),1)+h1*10^-6;
                                                else
                                                    SENO(rADDR(i),phhp)=psequence(rADDR(i),1)+1;
                                                    SPTIME04(rADDR(i),phhp)=-1*(ptime(rADDR(i),1)+h1*10^-6);
                                                end
                                            else
                                                if SPTIME05(rADDR(i),phhp)==0
                                                    if SENO(rADDR(i),phhp)==psequence(rADDR(i),1)                       % EXPECTED SEQUENCE NUMBER?
                                                        SENO(rADDR(i),phhp)=SENO(rADDR(i),phhp)+1;
                                                        SPTIME05(rADDR(i),phhp)=ptime(rADDR(i),1)+h1*10^-6;
                                                    else
                                                        SENO(rADDR(i),phhp)=psequence(rADDR(i),1)+1;
                                                        SPTIME05(rADDR(i),phhp)=-1*(ptime(rADDR(i),1)+h1*10^-6);
                                                    end
                                                end
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    else
                        if (nQLR(rROUTINGa(rADDR(i)))+1)<=BUFFERouter
                            nQLR(rROUTINGa(rADDR(i)))=nQLR(rROUTINGa(rADDR(i)))+1;
                            bfd(rROUTINGa(rADDR(i)),nQLR(rROUTINGa(rADDR(i))))=bfd(rADDR(i),1);
                            bfi(rROUTINGa(rADDR(i)),nQLR(rROUTINGa(rADDR(i))))=bfi(rADDR(i),1);
                            ptime(rROUTINGa(rADDR(i)),nQLR(rROUTINGa(rADDR(i))))=ptime(rADDR(i),1);
                            psequence(rROUTINGa(rADDR(i)),nQLR(rROUTINGa(rADDR(i))))=psequence(rADDR(i),1);
                        end
                    end
                    if nQLR(i)==1;
                        nQLR(i)=0;
                    else
                        nQLR(i)=nQLR(i)-1;
                        bfd(rADDR(i),1:nQLR(i))=bfd(rADDR(i),2:(nQLR(i)+1));
                        bfi(rADDR(i),1:nQLR(i))=bfi(rADDR(i),2:(nQLR(i)+1));
                        ptime(rADDR(i),1:nQLR(i))=ptime(rADDR(i),2:(nQLR(i)+1));
                        psequence(rADDR(i),1:nQLR(i))=psequence(rADDR(i),2:(nQLR(i)+1));
                    end
                end
            end
            
            %------ ROUTER OPERATIONS OF LAYER TWO  ------ 
            for aolayer1=1:(LinkTwoCapacity/LinkThreeCapacity)
                for i=122:161
                    if nQLR(i)>=1
                        switch rROUTINGa(fix(bfd(rADDR(i),1)))
                          case {i}
                             aDDRESSnextR=0;                                  % aDDRESSnextR is the Address of Next Forwarding Router; aDDRESSnext=0 means the Current Local domain.  
                          otherwise
                             aDDRESSnextR=rROUTINGa(i);
                        end
                        if aDDRESSnextR==0
                            if (nQLR(fix(bfd(rADDR(i),1)))+1)<=BUFFERouter
                                nQLR(fix(bfd(rADDR(i),1)))=nQLR(fix(bfd(rADDR(i),1)))+1;
                                bfd(fix(bfd(rADDR(i),1)),nQLR(fix(bfd(rADDR(i),1))))=bfd(rADDR(i),1);
                                bfi(fix(bfd(rADDR(i),1)),nQLR(fix(bfd(rADDR(i),1))))=bfi(rADDR(i),1);
                                ptime(fix(bfd(rADDR(i),1)),nQLR(fix(bfd(rADDR(i),1))))=ptime(rADDR(i),1);
                                psequence(fix(bfd(rADDR(i),1)),nQLR(fix(bfd(rADDR(i),1))))=psequence(rADDR(i),1);
                            end
                        else
                            if (nQLR(aDDRESSnextR)+1)<=BUFFERouter
                                nQLR(aDDRESSnextR)=nQLR(aDDRESSnextR)+1;
                                bfd(aDDRESSnextR,nQLR(aDDRESSnextR))=bfd(rADDR(i),1);
                                bfi(aDDRESSnextR,nQLR(aDDRESSnextR))=bfi(rADDR(i),1);
                                ptime(aDDRESSnextR,nQLR(aDDRESSnextR))=ptime(rADDR(i),1);
                                psequence(aDDRESSnextR,nQLR(aDDRESSnextR))=psequence(rADDR(i),1);
                            end
                        end
                        if nQLR(i)==1;
                            nQLR(i)=0;
                        else
                            nQLR(i)=nQLR(i)-1;
                            bfd(rADDR(i),1:nQLR(i))=bfd(rADDR(i),2:(nQLR(i)+1));
                            bfi(rADDR(i),1:nQLR(i))=bfi(rADDR(i),2:(nQLR(i)+1));
                            ptime(rADDR(i),1:nQLR(i))=ptime(rADDR(i),2:(nQLR(i)+1));
                            psequence(rADDR(i),1:nQLR(i))=psequence(rADDR(i),2:(nQLR(i)+1));
                        end
                    end
                end
                       
               %------ ROUTER OPERATIONS OF LAYER ONE  ------  
                for aolayer1=1:(LinkOneCapacity/LinkTwoCapacity)
                    for i=1:11
                        if nQLR(i)>=1
                            switch rADDR(i)
                              case {1}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=0;                                               % aDDRESSnext is the Link Address to Next Forwarding Router; aDDRESSnext=0 means the Current Local domain. 
                                   case {2}
                                      aDDRESSnext=1;
                                   case {3}
                                      aDDRESSnext=3;
                                   case {4}
                                      aDDRESSnext=1;
                                   case {5}
                                      aDDRESSnext=3;
                                   case {6}
                                      aDDRESSnext=1;
                                   case {7}
                                      aDDRESSnext=3;
                                   case {8}
                                      aDDRESSnext=3;
                                   case {9}
                                      aDDRESSnext=3;  
                                   case {10}
                                      aDDRESSnext=1;
                                   case {11}
                                      aDDRESSnext=3;
                                 end
                              case {2}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=2;   
                                   case {2}
                                      aDDRESSnext=0;
                                   case {3}
                                      aDDRESSnext=5;
                                   case {4}
                                      aDDRESSnext=7;
                                   case {5}
                                      aDDRESSnext=5;
                                   case {6}
                                      aDDRESSnext=7;
                                   case {7}
                                      aDDRESSnext=5;
                                   case {8}
                                      aDDRESSnext=7;
                                   case {9}
                                      aDDRESSnext=5;  
                                   case {10}
                                      aDDRESSnext=7;
                                   case {11}
                                      aDDRESSnext=5;
                                 end
                              case {3}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=4;                        
                                   case {2}
                                      aDDRESSnext=6;
                                   case {3}
                                      aDDRESSnext=0;
                                   case {4}
                                      aDDRESSnext=6;
                                   case {5}
                                      aDDRESSnext=9;
                                   case {6}
                                      aDDRESSnext=9;
                                   case {7}
                                      aDDRESSnext=9;
                                   case {8}
                                      aDDRESSnext=9;
                                   case {9}
                                      aDDRESSnext=9;  
                                   case {10}
                                      aDDRESSnext=9;
                                   case {11}
                                      aDDRESSnext=9;
                                 end
                              case {4}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=8;     
                                   case {2}
                                      aDDRESSnext=8;
                                   case {3}
                                      aDDRESSnext=8;
                                   case {4}
                                      aDDRESSnext=0;
                                   case {5}
                                      aDDRESSnext=8;
                                   case {6}
                                      aDDRESSnext=11;
                                   case {7}
                                      aDDRESSnext=11;
                                   case {8}
                                      aDDRESSnext=11;
                                   case {9}
                                      aDDRESSnext=11;  
                                   case {10}
                                      aDDRESSnext=11;
                                   case {11}
                                      aDDRESSnext=11;
                                 end
                              case {5}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=10;   
                                   case {2}
                                      aDDRESSnext=10;
                                   case {3}
                                      aDDRESSnext=10;
                                   case {4}
                                      aDDRESSnext=13;
                                   case {5}
                                      aDDRESSnext=0;
                                   case {6}
                                      aDDRESSnext=13;
                                   case {7}
                                      aDDRESSnext=15;
                                   case {8}
                                      aDDRESSnext=15;
                                   case {9}
                                      aDDRESSnext=15;  
                                   case {10}
                                      aDDRESSnext=15;
                                   case {11}
                                      aDDRESSnext=15;
                                 end   
                              case {6}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=12;   
                                   case {2}
                                      aDDRESSnext=12;
                                   case {3}
                                      aDDRESSnext=14;
                                   case {4}
                                      aDDRESSnext=12;
                                   case {5}
                                      aDDRESSnext=14;
                                   case {6}
                                      aDDRESSnext=0;
                                   case {7}
                                      aDDRESSnext=14;
                                   case {8}
                                      aDDRESSnext=17;
                                   case {9}
                                      aDDRESSnext=17;  
                                   case {10}
                                      aDDRESSnext=17;
                                   case {11}
                                      aDDRESSnext=17;
                                 end  
                              case {7}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=16;   
                                   case {2}
                                      aDDRESSnext=16;
                                   case {3}
                                      aDDRESSnext=16;
                                   case {4}
                                      aDDRESSnext=19;
                                   case {5}
                                      aDDRESSnext=16;
                                   case {6}
                                      aDDRESSnext=19;
                                   case {7}
                                      aDDRESSnext=0;
                                   case {8}
                                      aDDRESSnext=19;
                                   case {9}
                                      aDDRESSnext=21;  
                                   case {10}
                                      aDDRESSnext=19;
                                   case {11}
                                      aDDRESSnext=21;
                                 end
                              case {8}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=18;   
                                   case {2}
                                      aDDRESSnext=18;
                                   case {3}
                                      aDDRESSnext=20;
                                   case {4}
                                      aDDRESSnext=18;
                                   case {5}
                                      aDDRESSnext=20;
                                   case {6}
                                      aDDRESSnext=18;
                                   case {7}
                                      aDDRESSnext=20;
                                   case {8}
                                      aDDRESSnext=0;
                                   case {9}
                                      aDDRESSnext=20;  
                                   case {10}
                                      aDDRESSnext=23;
                                   case {11}
                                      aDDRESSnext=23;
                                 end
                              case {9}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=22;   
                                   case {2}
                                      aDDRESSnext=22;
                                   case {3}
                                      aDDRESSnext=22;
                                   case {4}
                                      aDDRESSnext=22;
                                   case {5}
                                      aDDRESSnext=22;
                                   case {6}
                                      aDDRESSnext=22;
                                   case {7}
                                      aDDRESSnext=22;
                                   case {8}
                                      aDDRESSnext=22;
                                   case {9}
                                      aDDRESSnext=0;
                                   case {10}
                                      aDDRESSnext=25;
                                   case {11}
                                      aDDRESSnext=25;
                                 end
                              case {10}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=24;   
                                   case {2}
                                      aDDRESSnext=24;
                                   case {3}
                                      aDDRESSnext=24;
                                   case {4}
                                      aDDRESSnext=24;
                                   case {5}
                                      aDDRESSnext=24;
                                   case {6}
                                      aDDRESSnext=24;
                                   case {7}
                                      aDDRESSnext=24;
                                   case {8}
                                      aDDRESSnext=24;
                                   case {9}
                                      aDDRESSnext=27;  
                                   case {10}
                                      aDDRESSnext=0;
                                   case {11}
                                      aDDRESSnext=27;
                                 end
                              case {11}
                                 switch rROUTINGa(rROUTINGa(fix(bfd(rADDR(i),1))))
                                   case {1}
                                      aDDRESSnext=26;   
                                   case {2}
                                      aDDRESSnext=28;
                                   case {3}
                                      aDDRESSnext=26;
                                   case {4}
                                      aDDRESSnext=28;
                                   case {5}
                                      aDDRESSnext=26;
                                   case {6}
                                      aDDRESSnext=28;
                                   case {7}
                                      aDDRESSnext=26;
                                   case {8}
                                      aDDRESSnext=28;
                                   case {9}
                                      aDDRESSnext=26;  
                                   case {10}
                                      aDDRESSnext=28;
                                   case {11}
                                      aDDRESSnext=0;
                                 end
                            end
                            if aDDRESSnext==0
                                if (nQLR(rROUTINGa(fix(bfd(rADDR(i),1))))+1)<=BUFFERouter
                                    nQLR(rROUTINGa(fix(bfd(rADDR(i),1))))=nQLR(rROUTINGa(fix(bfd(rADDR(i),1))))+1;
                                    bfd(rROUTINGa(fix(bfd(rADDR(i),1))),nQLR(rROUTINGa(fix(bfd(rADDR(i),1)))))=bfd(rADDR(i),1);
                                    bfi(rROUTINGa(fix(bfd(rADDR(i),1))),nQLR(rROUTINGa(fix(bfd(rADDR(i),1)))))=bfi(rADDR(i),1);
                                    ptime(rROUTINGa(fix(bfd(rADDR(i),1))),nQLR(rROUTINGa(fix(bfd(rADDR(i),1)))))=ptime(rADDR(i),1);
                                    psequence(rROUTINGa(fix(bfd(rADDR(i),1))),nQLR(rROUTINGa(fix(bfd(rADDR(i),1)))))=psequence(rADDR(i),1);
                                end
                            else
                                nQLL(aDDRESSnext)=nQLL(aDDRESSnext)+1;
                                bfdLink(aDDRESSnext,nQLL(aDDRESSnext))=bfd(rADDR(i),1);
                                bfiLink(aDDRESSnext,nQLL(aDDRESSnext))=bfi(rADDR(i),1);
                                ptimeLink(aDDRESSnext,nQLL(aDDRESSnext))=ptime(rADDR(i),1);
                                psequenceLink(aDDRESSnext,nQLL(aDDRESSnext))=psequence(rADDR(i),1);
                                Blinkdelay(aDDRESSnext,(dLinkT(aDDRESSnext)*LinkOneCapacity))=1;                                                     
                            end
                            if nQLR(i)==1;
                                nQLR(i)=0;
                            else
                                nQLR(i)=nQLR(i)-1;
                                bfd(rADDR(i),1:nQLR(i))=bfd(rADDR(i),2:(nQLR(i)+1));
                                bfi(rADDR(i),1:nQLR(i))=bfi(rADDR(i),2:(nQLR(i)+1));
                                ptime(rADDR(i),1:nQLR(i))=ptime(rADDR(i),2:(nQLR(i)+1));
                                psequence(rADDR(i),1:nQLR(i))=psequence(rADDR(i),2:(nQLR(i)+1));
                            end
                        end
                    end
                    
                    %------ BACKBONE LINK OPERATION ------
                    Blinkdelay(:,1:(max(dLinkT)*LinkOneCapacity))=Blinkdelay(:,2:(max(dLinkT)*LinkOneCapacity+1));
                    for i=1:28
                        if Blinkdelay(i,1)==1
                            if nQLL(i)>=1
                                switch i
                                  case {2,4}
                                     aDDRESSnextR=1;                      % aDDRESSnextR is the Address of Next Forwarding Router 
                                  case {1,6,8}
                                     aDDRESSnextR=2;
                                  case {3,5,10}
                                     aDDRESSnextR=3;
                                  case {7,12}
                                     aDDRESSnextR=4;
                                  case {9,14,16}
                                     aDDRESSnextR=5;
                                  case {11,13,18}
                                     aDDRESSnextR=6;
                                  case {15,20,22}
                                     aDDRESSnextR=7;
                                  case {17,19,24}
                                     aDDRESSnextR=8;
                                  case {21,26}
                                     aDDRESSnextR=9;  
                                  case {23,28}
                                     aDDRESSnextR=10;
                                  case {25,27}
                                     aDDRESSnextR=11;
                                end
                                if (nQLR(aDDRESSnextR)+1)<=BUFFERouter
                                    nQLR(aDDRESSnextR)=nQLR(aDDRESSnextR)+1;
                                    bfd(aDDRESSnextR,nQLR(aDDRESSnextR))=bfdLink(i,1);
                                    bfi(aDDRESSnextR,nQLR(aDDRESSnextR))=bfiLink(i,1);
                                    ptime(aDDRESSnextR,nQLR(aDDRESSnextR))=ptimeLink(i,1);
                                    psequence(aDDRESSnextR,nQLR(aDDRESSnextR))=psequenceLink(i,1);
                                end
                                if nQLL(i)==1;
                                    nQLL(i)=0;
                                else
                                    nQLL(i)=nQLL(i)-1;
                                    bfdLink(i,1:nQLL(i))=bfdLink(i,2:(nQLL(i)+1));
                                    bfiLink(i,1:nQLL(i))=bfiLink(i,2:(nQLL(i)+1));
                                    ptimeLink(i,1:nQLL(i))=ptimeLink(i,2:(nQLL(i)+1));
                                    psequenceLink(i,1:nQLL(i))=psequenceLink(i,2:(nQLL(i)+1));
                                end
                            end
                        end
                    end
                end
            end                
        end 
        for i=1:L
            if nQLR(i)>=1
                ptime(rADDR(i),1:nQLR(i))=ptime(rADDR(i),1:nQLR(i))+1;
            end
        end
        for i=1:28
            if nQLL(i)>=1
                ptimeLink(i,1:nQLL(i))=ptimeLink(i,1:nQLL(i))+1;
            end
        end
    end
    
    Plamd1PC=Plamd1PC+1;                                    % UPTATE Plamd1
    if Plamd1PC==2000
        SPECIALDaddress=35;
    end
    
    Lossrate(ii)=(Tinput-Toutput)/Tinput;                   % OBSERVATIONS
    TOUT=TOUT+Toutput;TIN=TIN+Tinput;
    xz(ii)=sum(sum(Indica));
    xmaxd(ii)=sum(SRactive(12,:));xmaxda(ii)=12;
    for pi01=13:121
        if xmaxd(ii)<sum(SRactive(pi01,:))
            xmaxd(ii)=sum(SRactive(pi01,:));
            xmaxda(ii)=pi01;
        end
    end
    xq(ii)=nQLR(8);xxq(ii)=nQLR(148);xxxq(ii)=nQLR(83);
end

tt=cputime-tt;                                              % TOTAL EXECUTION TIME 

save ABILENEtdAS-r5D5T2K2R8A160A20A5-a15on50-a15off5000p RTO AAX xmaxd xmaxda xq xxq xxxq tt Lossrate TOUT TIN xz SRTT SENO cwnd Sindica Indica begint SRactive nQLR nQLL  % SAVE DATA TO A MAT-FILE 
