function [Lossrate] = catcpi1t5                   % CA MODEL FOR TCP in the adaptive regulation of links


%**************** INITIALIZATION ****************** 

%GENERAL PARAMETERS
L=5;                                              % SYSTEM SIZE
UK=100;                                          % THE NUMBER OF SOURCES ATTACHED TO EACH ROUTER
UR=5*UK;                                         % THE NUMBER OF RECEIVERS FOR EACH ROUTER CHANGES DYNAMICALLY, BUT IT IS TWICE UK AT MOST.                             
AL=10;                                             % THE LINK CAPACITY OF ROUTING TIER
lamd=50;                                         % THE AVERAGE NUMBER OF PACKETS IN EACH "ON" STATE
lamd1=3000;                                       % THE AVERAGE TIME STEPS IDLING IN EACH "OFF" STATE
erfa=1.5;                                         % THE SHAPE PARAMETER OF PARETO DISTRIBUTION; THE DEFAULT SETTING IS THE EXPONENTIAL DISTRIBUTION; IF "ON" STATE FOLLOWS PARETO, REPLACING THE RIGHT SIDE OF THE LINE 137 WITH THE LINE 139. 
%SIGMA=2.5;MU=log(lamd)-SIGMA^2/2;                 % TWO PARAMETERS OF LOGNORMAL DISTRIBUTION; THE DEFAULT SETTING IS THE EXPONENTIAL DISTRIBUTION; IF "ON" STATE FOLLOWS LOGNORMAL, REPLACING THE RIGHT SIDE OF THE LINE 137 WITH THE LINE 138.
vmax=1;                                           % SAMPLING RATE FOR COLLECTING DATA
BUFFER=160;                                        % EACH BUFFER WITH LIMITED LENGTH QUEUE
LBOUND=5;UBOUND=BUFFER;                           % UPPER AND LOWER LIMIT FOR ESTIMATING THE ROUND-TRIP TIME

MTinterval=100;                                   % Monitoring INTERVAL
LONGTIME=40000;                                   % EXECUTION TIME (TOTAL TIME STEPS)
probenode=fix(L/2+1);                             % THE DATA OF THE NODE (probenode, probenode) WILL BE COLLECTED
PNODE=fix(L^2/2+1);

%xxo(1:LONGTIME)=0;xo(1:LONGTIME)=0;                                % xx REPRESENTS THE NUMBER OF PACKETS RECEIVED BY THE NODE r(probenode,probenode) DURING A "vmax"
%xxxo(1:LONGTIME)=0;xxxu(1:LONGTIME)=0;xxxl(1:LONGTIME)=0;xxxd(1:LONGTIME)=0;xxxr(1:LONGTIME)=0;           % xxxu (OR xxxl) REPRESENTS THE NUMBER OF PACKETS FORWARDED UPWARDS (OR TOWARDS THE LEFT) BY THE NODE r(probenode,probenode) DURING A "vmax"
%xxu(1:LONGTIME)=0;xxl(1:LONGTIME)=0;xu(1:LONGTIME)=0;xl(1:LONGTIME)=0;xxr(1:LONGTIME)=0;xxd(1:LONGTIME)=0;xd(1:LONGTIME)=0;xr(1:LONGTIME)=0;
Lossrate(1:LONGTIME)=0;xmaxd(1:LONGTIME)=0;xmaxda(1:LONGTIME)=0;
xz(1:LONGTIME)=0;%xxxq(1:LONGTIME)=0;xxq(1:LONGTIME)=0;xq(1:LONGTIME)=0;xns(1:LONGTIME)=0;xns2(1:LONGTIME)=0;xc(1:LONGTIME)=0;xc2(1:LONGTIME)=0;xnd1(1:LONGTIME)=0;xnd2(1:LONGTIME)=0;xnd3(1:LONGTIME)=0;xnd4(1:LONGTIME)=0;xnd5(1:LONGTIME)=0;%xnd6(1:LONGTIME)=0;xnd7(1:LONGTIME)=0;xnd8(1:LONGTIME)=0;xnd9(1:LONGTIME)=0;
AAX(1:(L^2*(L^2-1)),1:LONGTIME)=0;                % REPRESENTS THE NUMBER OF PACKETS RECEIVED BY a Node from another Node DURING "MTinterval"; 

%ROUTERS
mq=0;
Habscissa(1:(L*L))=0;Hordinate(1:(L*L))=0;r=zeros(L);
for i=1:L
   for j=1:L
      mq=mq+1;                                    % mq WILL BE THE TOTAL NUMBER OF NODES
      r(i,j)=mq;                                  % THE SEQUENCE NUMBER OF EACH NODE
      Habscissa(mq)=i;                            % THE ABSCISSA OF EACH NODE
      Hordinate(mq)=j;                            % THE ORDINATE OF EACH NODE
   end
end
n=zeros(L);                                       % THE QUEUE LENGTH OF EACH NODE
bfd=zeros(mq,BUFFER);                         % bfd(A,B) REPRESENTS THE DESTINATION ADDRESS OF THE B-th PACKET IN THE NODE A
bfi=zeros(mq,BUFFER);                         % bfi(A,B) REPRESENTS THE SOURCE ADDRESS OF THE B-th PACKET IN THE NODE A
ptime=zeros(mq,BUFFER);                       % ptime(A,B) REPRESENTS THE TIME EXPERIENCED BY THE B-th PACKET IN THE NODE A TILL NOW
psequence=zeros(mq,BUFFER);                   % psequence(A,B) REPRESENTS THE SEQUENCE NUMBER OF THE B-th PACKET OF THE NODE A IN ITS OWN CONNECTION
brouting=zeros(mq,BUFFER);

%LINKS
CREDITC(1:mq,1:5)=100000;
%CREDITCW(1:mq,1)=MTinterval*AL;
%CREDITC(1:mq,2:5)=ceil(MTinterval*AL/4);          
%CREDITCW(1:mq,2:5)=ceil(MTinterval*AL/4);         %                     (2)
%MEASURET(1:mq,1:5)=0;                             %                      |
%MEANload=ceil(MTinterval*AL/4);                   %                (5)--(1)--(3)
%xxload(1:mq)=MTinterval*AL/5;                                                  %                      |
                                                  %                     (4)

%SOURCES
for i=1:L
    for j=1:L
        for h=1:UK
            if rand>.2
                Indica(r(i,j),h)=0;                              % Indica = 0 (OR 1) WHEN THE NODE IS IN "OFF" (OR "ON") STATE
                begint(r(i,j),h)=4;                              % begint = 0 (BEFORE ENTERING SLOW-START), 1 (WAITING FOR ACK PACKETS WITHOUT LAUNCHING ANY PACKET), 2 (WITHIN CONGESTION AVOIDANCE), 3 (WITHIN THE SLOW-START), OR 4 ("OFF" STATE)
                PINTERVAL(r(i,j),h)=ceil(rand^(-1/erfa)*(erfa-1)*lamd1/erfa);  %ceil(exprnd(lamd1));         % PINTERVAL IS THE LENGTH OF "ON" OR "OFF" STATE FOR EACH SOURCE
            else
                Indica(r(i,j),h)=1;
                begint(r(i,j),h)=0;
                PINTERVAL(r(i,j),h)=ceil(rand^(-1/erfa)*(erfa-1)*lamd/erfa);
            end
        end
    end
end
Daddress(1:mq,1:UK)=0;                            % THE DESTINATION ADDRESS
DistanceSR(1:mq,1:UK)=0;                          % ESTIMATED ROUND-TRIP DISTANCE BETWEEN THE SOURCE AND THE DESTINATION
IDReceivers(1:mq,1:UK)=0;                         % THE RECEIVER'S ID IN THE DESTINATION ROUTER
cwnd(1:mq,1:UK)=1;                                % cwnd IS THE CONGESTION WINDOW
ssthresh(1:mq,1:UK)=16;                           % THE SLOW-START THRESHOLD SIZE
nstate(1:mq,1:UK)=1;                              % HOW MANY PACKETS' ACK HAVE NOT BEEN RECEIVED REGARDING THE CURRENT cwnd
PINTERVALC(1:mq,1:UK)=0;                          % HOW MANY PACKETS HAVE NOT BEEN INJECTED REGARDING THE CURRENT cwnd
Sstate(1:mq,1:UK)=1;                              % THE SEQUENCE NUMBER OF THE PACKET THAT WILL BE LAUNCHED NEXT 
SRTT(1:mq,1:UK)=0;                                % THE ESTIMATED ROUND-TRIP TIME
RTO(1:mq,1:UK)=0;                                 % THE RETRANSMISSION TIMEOUT
CRTO(1:mq,1:UK)=1;                                % THE TIMER OF A CONNECTION'S TIMEOUT


%RECEIVERS
SENO(1:mq,1:UR)=0;                                % THE EXPECTED SEQUENCE NUMBER IN A RECEIVER
Saddress(1:mq,1:UR)=0;                            % THE SENDER'S ADDRESS
Sindica(1:mq,1:UR)=0;
SRactive(1:mq,1:UR)=0;
SPTIME01(1:mq,1:UR)=0;SPTIME02(1:mq,1:UR)=0;SPTIME03(1:mq,1:UR)=0;SPTIME04(1:mq,1:UR)=0;SPTIME05(1:mq,1:UR)=0;

%*******************  STARTING  *******************
TOUT=0;TIN=0;
tt=cputime;                                       % STARTING TIME
SPECIALDaddress=fix(rand*mq)+1; %PNODE;    
PERIODSPECIALDaddress=ceil(rand^(-1/erfa)*(erfa-1)*500/erfa);

for ii=1:LONGTIME
   Toutput=0;Tinput=0;
   for k=1:MTinterval
    % SOURCES' OPERATION  
     for i=1:L
       for j=1:L
         for h=1:UK 
           if Indica(r(i,j),h)==1                          % "ON" STATE?
              if begint(r(i,j),h)==0
                 Daddress(r(i,j),h)=r(i,j);
                 while Daddress(r(i,j),h)==r(i,j)                 % FIND A HOST THAT SATISFIES REQUIMENTS
                    if rand>.02
                        Daddress(r(i,j),h)=fix(rand*mq)+1;
                    else                                          % Choose A Special Node
                        Daddress(r(i,j),h)=SPECIALDaddress;
                        if ii>PERIODSPECIALDaddress
                            SPECIALDaddress=fix(rand*mq)+1;
                            PERIODSPECIALDaddress=ceil(rand^(-1/erfa)*(erfa-1)*500/erfa)+ii;
                        end
                    end
                    phhp=1;
                    DAP=SENO(Daddress(r(i,j),h),phhp);
                    while DAP~=0
                       phhp=phhp+1;
                       if phhp>UR
                          Daddress(r(i,j),h)=r(i,j); 
                          DAP=0;
                       else
                          DAP=SENO(Daddress(r(i,j),h),phhp);
                       end
                    end
                 end
                 IDReceivers(r(i,j),h)=phhp;
                 SENO(Daddress(r(i,j),h),phhp)=1;
                 Saddress(Daddress(r(i,j),h),phhp)=r(i,j);
                 SRactive(Daddress(r(i,j),h),phhp)=1;
                 Tinput=Tinput+1; 
               % Find the routing for its next step 
                 Lr=j-1;Rr=j+1;Ur=i-1;Dr=i+1;
                 if Lr==0
                    Lr=L;
                 end
                 if Rr==(L+1)
                    Rr=1;
                 end
                 if Ur==0
                    Ur=L;
                 end
                 if Dr==(L+1)
                    Dr=1;
                 end
                 ddd2=L-abs(abs(Habscissa(Daddress(r(i,j),h))-Ur)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-j)-L/2);
                 ddd3=L-abs(abs(Habscissa(Daddress(r(i,j),h))-i)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-Rr)-L/2);
                 ddd4=L-abs(abs(Habscissa(Daddress(r(i,j),h))-Dr)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-j)-L/2);
                 ddd5=L-abs(abs(Habscissa(Daddress(r(i,j),h))-i)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-Lr)-L/2);
                 xxxmin=min([ddd2 ddd3 ddd4 ddd5]);
                 if (n(i,j)+1)<=BUFFER
                    bfd(r(i,j),(n(i,j)+1))=Daddress(r(i,j),h)+phhp*10^-6;        % THE DECIMAL FRACTION CARRIES THE RECEIVER'S ID IN THE DESTINATION ROUTER
                    bfi(r(i,j),(n(i,j)+1))=r(i,j)+h*10^-6;                       % THE DECIMAL FRACTION CARRIES THE SENDER'S ID
                    ptime(r(i,j),(n(i,j)+1))=1;
                    psequence(r(i,j),(n(i,j)+1))=1;
                    if r(i,j)<fix(bfd(r(i,j),(n(i,j)+1)))
                       nodeik01=(r(i,j)-1)*(L^2-1)+fix(bfd(r(i,j),(n(i,j)+1)))-1;
                    else
                       nodeik01=(r(i,j)-1)*(L^2-1)+fix(bfd(r(i,j),(n(i,j)+1)));
                    end
                    AAX(nodeik01,ii)=AAX(nodeik01,ii)+1;
                 end
                 if ddd2==xxxmin
                    if ddd2==ddd3
                       if (n(i,j)+1)<=BUFFER
                          n(i,j)=n(i,j)+1;
                          brouting(r(i,j),n(i,j))=3;
                          %MEASURET(r(i,j),3)=MEASURET(r(i,j),3)+1;
                       end
                    else
                       if (n(i,j)+1)<=BUFFER
                          n(i,j)=n(i,j)+1;
                          brouting(r(i,j),n(i,j))=2;
                          %MEASURET(r(i,j),2)=MEASURET(r(i,j),2)+1;
                       end
                    end
                 else
                    if ddd3==xxxmin
                       if ddd3==ddd4
                          if (n(i,j)+1)<=BUFFER
                             n(i,j)=n(i,j)+1;
                             brouting(r(i,j),n(i,j))=4;
                             %MEASURET(r(i,j),4)=MEASURET(r(i,j),4)+1;
                          end 
                       else
                          if (n(i,j)+1)<=BUFFER
                             n(i,j)=n(i,j)+1;
                             brouting(r(i,j),n(i,j))=3;
                             %MEASURET(r(i,j),3)=MEASURET(r(i,j),3)+1;
                          end
                       end
                    else
                       if ddd4==xxxmin
                          if ddd4==ddd5
                             if (n(i,j)+1)<=BUFFER
                                n(i,j)=n(i,j)+1;
                                brouting(r(i,j),n(i,j))=5;
                                %MEASURET(r(i,j),5)=MEASURET(r(i,j),5)+1;
                             end            
                          else
                             if (n(i,j)+1)<=BUFFER
                                n(i,j)=n(i,j)+1;
                                brouting(r(i,j),n(i,j))=4;
                                %MEASURET(r(i,j),4)=MEASURET(r(i,j),4)+1;
                             end
                          end
                       else
                          if (n(i,j)+1)<=BUFFER
                             n(i,j)=n(i,j)+1;
                             brouting(r(i,j),n(i,j))=5;
                             %MEASURET(r(i,j),5)=MEASURET(r(i,j),5)+1;
                          end
                       end
                    end
                 end
                 cwnd(r(i,j),h)=1;ssthresh(r(i,j),h)=16;PINTERVALC(r(i,j),h)=0;
                 DistanceSR(r(i,j),h)=2*(L-abs(abs(Habscissa(Daddress(r(i,j),h))-i)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-j)-L/2)+1);
                 SRTT(r(i,j),h)=ceil(LBOUND*DistanceSR(r(i,j),h)/AL);
                 RTO(r(i,j),h)=ceil(LBOUND*DistanceSR(r(i,j),h)/AL);
                 begint(r(i,j),h)=3;CRTO(r(i,j),h)=1;nstate(r(i,j),h)=1;Sstate(r(i,j),h)=2;
              else
                 CRTO(r(i,j),h)=CRTO(r(i,j),h)+1; 
                 if CRTO(r(i,j),h)>=RTO(r(i,j),h)                            % TIMEOUT?
                    ssthresh(r(i,j),h)=16;cwnd(r(i,j),h)=1;PINTERVALC(r(i,j),h)=cwnd(r(i,j),h);begint(r(i,j),h)=2;
                    RTO(r(i,j),h)=min(ceil(UBOUND*DistanceSR(r(i,j),h)/AL),2*RTO(r(i,j),h));CRTO(r(i,j),h)=1;nstate(r(i,j),h)=cwnd(r(i,j),h);
                 end
                 if begint(r(i,j),h)>=2
                    if PINTERVALC(r(i,j),h)>0
                       Tinput=Tinput+1;
                     % Find the routing for its next step 
                       Lr=j-1;Rr=j+1;Ur=i-1;Dr=i+1;
                       if Lr==0
                          Lr=L;
                       end
                       if Rr==(L+1)
                          Rr=1;
                       end
                       if Ur==0
                          Ur=L;
                       end
                       if Dr==(L+1)
                          Dr=1;
                       end
                       ddd2=L-abs(abs(Habscissa(Daddress(r(i,j),h))-Ur)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-j)-L/2);
                       ddd3=L-abs(abs(Habscissa(Daddress(r(i,j),h))-i)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-Rr)-L/2);
                       ddd4=L-abs(abs(Habscissa(Daddress(r(i,j),h))-Dr)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-j)-L/2);
                       ddd5=L-abs(abs(Habscissa(Daddress(r(i,j),h))-i)-L/2)-abs(abs(Hordinate(Daddress(r(i,j),h))-Lr)-L/2);
                       xxxmin=min([ddd2 ddd3 ddd4 ddd5]);
                       if (n(i,j)+1)<=BUFFER
                          bfd(r(i,j),(n(i,j)+1))=Daddress(r(i,j),h)+IDReceivers(r(i,j),h)*10^-6;        % THE DECIMAL FRACTION CARRIES THE RECEIVER'S ID IN THE DESTINATION ROUTER
                          bfi(r(i,j),(n(i,j)+1))=r(i,j)+h*10^-6;                                        % THE DECIMAL FRACTION CARRIES THE SENDER'S ID
                          ptime(r(i,j),(n(i,j)+1))=1;
                          psequence(r(i,j),(n(i,j)+1))=Sstate(r(i,j),h);
                          if r(i,j)<fix(bfd(r(i,j),(n(i,j)+1)))
                             nodeik01=(r(i,j)-1)*(L^2-1)+fix(bfd(r(i,j),(n(i,j)+1)))-1;
                          else
                             nodeik01=(r(i,j)-1)*(L^2-1)+fix(bfd(r(i,j),(n(i,j)+1)));
                          end
                          AAX(nodeik01,ii)=AAX(nodeik01,ii)+1;
                       end
                       if ddd2==xxxmin
                          if ddd2==ddd3
                             if (n(i,j)+1)<=BUFFER
                                n(i,j)=n(i,j)+1;
                                brouting(r(i,j),n(i,j))=3;
                                %MEASURET(r(i,j),3)=MEASURET(r(i,j),3)+1;
                             end
                          else
                             if (n(i,j)+1)<=BUFFER
                                n(i,j)=n(i,j)+1;
                                brouting(r(i,j),n(i,j))=2;
                                %MEASURET(r(i,j),2)=MEASURET(r(i,j),2)+1;
                             end
                          end
                       else
                          if ddd3==xxxmin
                             if ddd3==ddd4
                                if (n(i,j)+1)<=BUFFER
                                   n(i,j)=n(i,j)+1;
                                   brouting(r(i,j),n(i,j))=4;
                                   %MEASURET(r(i,j),4)=MEASURET(r(i,j),4)+1;
                                end 
                             else
                                if (n(i,j)+1)<=BUFFER
                                   n(i,j)=n(i,j)+1;
                                   brouting(r(i,j),n(i,j))=3;
                                   %MEASURET(r(i,j),3)=MEASURET(r(i,j),3)+1;
                                end
                             end
                          else
                             if ddd4==xxxmin
                                if ddd4==ddd5
                                   if (n(i,j)+1)<=BUFFER
                                      n(i,j)=n(i,j)+1;
                                      brouting(r(i,j),n(i,j))=5;
                                      %MEASURET(r(i,j),5)=MEASURET(r(i,j),5)+1;
                                   end            
                                else
                                   if (n(i,j)+1)<=BUFFER
                                      n(i,j)=n(i,j)+1;
                                      brouting(r(i,j),n(i,j))=4;
                                      %MEASURET(r(i,j),4)=MEASURET(r(i,j),4)+1;
                                   end
                                end
                             else
                                if (n(i,j)+1)<=BUFFER
                                   n(i,j)=n(i,j)+1;
                                   brouting(r(i,j),n(i,j))=5;
                                   %MEASURET(r(i,j),5)=MEASURET(r(i,j),5)+1;
                                end
                             end
                          end
                       end
                       Sstate(r(i,j),h)=Sstate(r(i,j),h)+1;
                       PINTERVALC(r(i,j),h)=PINTERVALC(r(i,j),h)-1;
                       if begint(r(i,j),h)==2
                          if PINTERVALC(r(i,j),h)==0
                             begint(r(i,j),h)=1;
                          end
                       end
                    end
                 end
              end      
           else                                                               % "OFF" STATE
              PINTERVAL(r(i,j),h)=PINTERVAL(r(i,j),h)-1;
              if PINTERVAL(r(i,j),h)==0
                 Indica(r(i,j),h)=1;
                 begint(r(i,j),h)=0;
                 PINTERVAL(r(i,j),h)=ceil(rand^(-1/erfa)*(erfa-1)*lamd/erfa); %ceil(exprnd(lamd));                      % THE DEFAULT SETTING IS THE EXPONENTIAL DISTRIBUTION
                 %ceil(lognrnd(MU,SIGMA));                                    % IF "ON" STATE FOLLOWS LOGNORMAL, REPLACING THE RIGHT SIDE OF THE LINE 137 WITH THE LINE 138
                 %ceil(rand^(-1/erfa)*(erfa-1)*lamd/erfa);                    % IF "ON" STATE PARETO, REPLACING THE RIGHT SIDE OF THE LINE 137 WITH THE LINE 139.
              end
           end
        end
     end
  end
  
 % RECEIVERS' OPERATION
  for i=1:L
     for j=1:L
         for h=1:UR
            if Sindica(r(i,j),h)>0
               Sindica(r(i,j),h)=Sindica(r(i,j),h)-1;
               if Saddress(r(i,j),h)~=0
                  if SPTIME01(r(i,j),h)~=0
                     if SPTIME01(r(i,j),h)>0
                         if (n(i,j)+1)<=BUFFER
                             bfd(r(i,j),(n(i,j)+1))=Saddress(r(i,j),h)+SPTIME01(r(i,j),h)-fix(SPTIME01(r(i,j),h));
                             bfi(r(i,j),(n(i,j)+1))=r(i,j)+h*10^-6;
                             ptime(r(i,j),(n(i,j)+1))=1000000+fix(SPTIME01(r(i,j),h));             
                             psequence(r(i,j),(n(i,j)+1))=0;
                             if r(i,j)<fix(bfd(r(i,j),(n(i,j)+1)))
                                nodeik01=(r(i,j)-1)*(L^2-1)+fix(bfd(r(i,j),(n(i,j)+1)))-1;
                             else
                                nodeik01=(r(i,j)-1)*(L^2-1)+fix(bfd(r(i,j),(n(i,j)+1)));
                             end
                             AAX(nodeik01,ii)=AAX(nodeik01,ii)+1;
                         end
                     else
                         if (n(i,j)+1)<=BUFFER
                             bfd(r(i,j),(n(i,j)+1))=Saddress(r(i,j),h)+abs(SPTIME01(r(i,j),h)-fix(SPTIME01(r(i,j),h)));
                             bfi(r(i,j),(n(i,j)+1))=r(i,j)+h*10^-6;
                             ptime(r(i,j),(n(i,j)+1))=1000000+abs(fix(SPTIME01(r(i,j),h)));             
                             psequence(r(i,j),(n(i,j)+1))=-1; 
                             if r(i,j)<fix(bfd(r(i,j),(n(i,j)+1)))
                                nodeik01=(r(i,j)-1)*(L^2-1)+fix(bfd(r(i,j),(n(i,j)+1)))-1;
                             else
                                nodeik01=(r(i,j)-1)*(L^2-1)+fix(bfd(r(i,j),(n(i,j)+1)));
                             end
                             AAX(nodeik01,ii)=AAX(nodeik01,ii)+1;
                         end
                     end
                     SPTIME01(r(i,j),h)=SPTIME02(r(i,j),h);SPTIME02(r(i,j),h)=SPTIME03(r(i,j),h);SPTIME03(r(i,j),h)=SPTIME04(r(i,j),h);SPTIME04(r(i,j),h)=SPTIME05(r(i,j),h);SPTIME05(r(i,j),h)=0;
                     dapppp=1;
                 else
                     dapppp=0;
                 end
                 if dapppp==1
                 % Find the routing for its next step 
                 Lr=j-1;Rr=j+1;Ur=i-1;Dr=i+1;
                 if Lr==0
                    Lr=L;
                 end
                 if Rr==(L+1)
                    Rr=1;
                 end
                 if Ur==0
                    Ur=L;
                 end
                 if Dr==(L+1)
                    Dr=1;
                 end
                 ddd2=L-abs(abs(Habscissa(Saddress(r(i,j),h))-Ur)-L/2)-abs(abs(Hordinate(Saddress(r(i,j),h))-j)-L/2);
                 ddd3=L-abs(abs(Habscissa(Saddress(r(i,j),h))-i)-L/2)-abs(abs(Hordinate(Saddress(r(i,j),h))-Rr)-L/2);
                 ddd4=L-abs(abs(Habscissa(Saddress(r(i,j),h))-Dr)-L/2)-abs(abs(Hordinate(Saddress(r(i,j),h))-j)-L/2);
                 ddd5=L-abs(abs(Habscissa(Saddress(r(i,j),h))-i)-L/2)-abs(abs(Hordinate(Saddress(r(i,j),h))-Lr)-L/2);
                 xxxmin=min([ddd2 ddd3 ddd4 ddd5]);
                 if ddd2==xxxmin
                    if ddd2==ddd3
                       if (n(i,j)+1)<=BUFFER
                           n(i,j)=n(i,j)+1;
                           brouting(r(i,j),n(i,j))=3;
                           %MEASURET(r(i,j),3)=MEASURET(r(i,j),3)+1;
                       end
                    else
                       if (n(i,j)+1)<=BUFFER
                           n(i,j)=n(i,j)+1;
                           brouting(r(i,j),n(i,j))=2;
                           %MEASURET(r(i,j),2)=MEASURET(r(i,j),2)+1;
                       end
                    end
                 else
                    if ddd3==xxxmin
                       if ddd3==ddd4
                          if (n(i,j)+1)<=BUFFER
                              n(i,j)=n(i,j)+1;
                              brouting(r(i,j),n(i,j))=4;
                              %MEASURET(r(i,j),4)=MEASURET(r(i,j),4)+1;
                          end 
                       else
                          if (n(i,j)+1)<=BUFFER
                              n(i,j)=n(i,j)+1;
                              brouting(r(i,j),n(i,j))=3;
                              %MEASURET(r(i,j),3)=MEASURET(r(i,j),3)+1;
                          end
                       end
                    else
                       if ddd4==xxxmin
                          if ddd4==ddd5
                             if (n(i,j)+1)<=BUFFER
                                 n(i,j)=n(i,j)+1;
                                 brouting(r(i,j),n(i,j))=5;
                                 %MEASURET(r(i,j),5)=MEASURET(r(i,j),5)+1;
                             end            
                          else
                             if (n(i,j)+1)<=BUFFER
                                 n(i,j)=n(i,j)+1;
                                 brouting(r(i,j),n(i,j))=4;
                                 %MEASURET(r(i,j),4)=MEASURET(r(i,j),4)+1;
                             end
                          end
                       else
                          if (n(i,j)+1)<=BUFFER
                              n(i,j)=n(i,j)+1;
                              brouting(r(i,j),n(i,j))=5;
                              %MEASURET(r(i,j),5)=MEASURET(r(i,j),5)+1;
                          end
                        end
                     end
                   end
                 end
              else
                 Sindica(r(i,j),h)=0;
                 SPTIME01(r(i,j),h)=0;SPTIME02(r(i,j),h)=0;SPTIME03(r(i,j),h)=0;SPTIME04(r(i,j),h)=0;SPTIME05(r(i,j),h)=0;
              end
           end
        end
     end
  end

  % ROUTERS' OPERATION
  for aol=1:AL 
     for i=1:L
        for j=1:L        
           if n(i,j)>0
               DAP=1;DAPPP=CREDITC(r(i,j),brouting(r(i,j),DAP));
               while DAPPP<1
                   if DAP<n(i,j)
                      DAP=DAP+1;
                      DAPPP=CREDITC(r(i,j),brouting(r(i,j),DAP));
                   else
                      DAPPP=2;DAP=BUFFER+10;
                   end
               end
               if DAP<=n(i,j)
                  if brouting(r(i,j),DAP)==1
                     if ptime(r(i,j),DAP)>1000000                                  % IS IT A ACK PACKET?
                        phhp=round(10^6*(bfd(r(i,j),DAP)-fix(bfd(r(i,j),DAP))));
                        if Daddress(r(i,j),phhp)==fix(bfi(r(i,j),DAP))
                           if Indica(r(i,j),phhp)==1
                              SRTT(r(i,j),phhp)=0.8*SRTT(r(i,j),phhp)+.2*(ptime(r(i,j),DAP)-1000000);
                              RTO(r(i,j),phhp)=min(ceil(UBOUND*DistanceSR(r(i,j),phhp)/AL),max(ceil(LBOUND*DistanceSR(r(i,j),phhp)/AL),1.5*SRTT(r(i,j),phhp)));
                              if psequence(r(i,j),DAP)==-1
                                 nstate(r(i,j),phhp)=0;
                              else
                                 nstate(r(i,j),phhp)=nstate(r(i,j),phhp)-1;
                              end
                              if nstate(r(i,j),phhp)==0
                                 CRTO(r(i,j),phhp)=1;
                                 if psequence(r(i,j),DAP)==-1
                                    ssthresh(r(i,j),phhp)=ceil(.5*cwnd(r(i,j),phhp));
                                    cwnd(r(i,j),phhp)=ceil(.5*cwnd(r(i,j),phhp));
                                    PINTERVALC(r(i,j),phhp)=cwnd(r(i,j),phhp);
                                    nstate(r(i,j),phhp)=cwnd(r(i,j),phhp);
                                    begint(r(i,j),phhp)=2;
                                 else
                                    if begint(r(i,j),phhp)==3
                                       if cwnd(r(i,j),phhp)<ssthresh(r(i,j),phhp)
                                          cwnd(r(i,j),phhp)=cwnd(r(i,j),phhp)*2;
                                       else
                                          cwnd(r(i,j),phhp)=cwnd(r(i,j),phhp)+1;
                                          begint(r(i,j),phhp)=2;
                                       end
                                    else   
                                       cwnd(r(i,j),phhp)=cwnd(r(i,j),phhp)+1;
                                       begint(r(i,j),phhp)=2;
                                    end
                                 end
                                 PINTERVALC(r(i,j),phhp)=cwnd(r(i,j),phhp);
                                 nstate(r(i,j),phhp)=cwnd(r(i,j),phhp);
                              end
                              PINTERVAL(r(i,j),phhp)=PINTERVAL(r(i,j),phhp)-1;
                              if PINTERVAL(r(i,j),phhp)==0
                                 Indica(r(i,j),phhp)=0;
                                 DAP01=round(10^6*(bfi(r(i,j),DAP)-fix(bfi(r(i,j),DAP))));
                                 SENO(Daddress(r(i,j),phhp),DAP01)=0;Saddress(Daddress(r(i,j),phhp),DAP01)=0;Sindica(Daddress(r(i,j),phhp),DAP01)=0;
                                 SPTIME01(Daddress(r(i,j),phhp),DAP01)=0;SPTIME02(Daddress(r(i,j),phhp),DAP01)=0;SPTIME03(Daddress(r(i,j),phhp),DAP01)=0;SPTIME04(Daddress(r(i,j),phhp),DAP01)=0;SPTIME05(Daddress(r(i,j),phhp),DAP01)=0;
                                 SRactive(Daddress(r(i,j),phhp),DAP01)=0;
                                 Daddress(r(i,j),phhp)=-1;begint(r(i,j),phhp)=4;
                                 PINTERVAL(r(i,j),phhp)=ceil(rand^(-1/erfa)*(erfa-1)*lamd1/erfa);                % THE DEFAULT SETTING OF "OFF" STATE IS THE EXPONENTIAL DISTRIBUTION
                                 %ceil(exprnd(lamd1));               % IF "OFF" STATE PARETO, REPLACING THE RIGHT SIDE OF THE LINE 214 WITH THE LINE 215.
                              end
                           end
                        end
                     else
                        phhp=round(10^6*(bfd(r(i,j),DAP)-fix(bfd(r(i,j),DAP)))); 
                        h1=round(10^6*(bfi(r(i,j),DAP)-fix(bfi(r(i,j),DAP))));
                        Toutput=Toutput+1;
                        if Saddress(r(i,j),phhp)==fix(bfi(r(i,j),DAP))                           %Indica(fix(bfi(r(i,j),DAP)),h1)==1
                           Sindica(r(i,j),phhp)=Sindica(r(i,j),phhp)+1;
                           if SPTIME01(r(i,j),phhp)==0
                              if SENO(r(i,j),phhp)==psequence(r(i,j),DAP)                       % EXPECTED SEQUENCE NUMBER?
                                 SENO(r(i,j),phhp)=SENO(r(i,j),phhp)+1;
                                 SPTIME01(r(i,j),phhp)=ptime(r(i,j),DAP)+h1*10^-6;
                              else
                                 SENO(r(i,j),phhp)=psequence(r(i,j),DAP)+1;
                                 SPTIME01(r(i,j),phhp)=-1*(ptime(r(i,j),DAP)+h1*10^-6);
                              end
                           else
                              if SPTIME02(r(i,j),phhp)==0
                                 if SENO(r(i,j),phhp)==psequence(r(i,j),DAP)                       % EXPECTED SEQUENCE NUMBER?
                                    SENO(r(i,j),phhp)=SENO(r(i,j),phhp)+1;
                                    SPTIME02(r(i,j),phhp)=ptime(r(i,j),DAP)+h1*10^-6;
                                 else
                                    SENO(r(i,j),phhp)=psequence(r(i,j),DAP)+1;
                                    SPTIME02(r(i,j),phhp)=-1*(ptime(r(i,j),DAP)+h1*10^-6);
                                 end
                             else
                                 if SPTIME03(r(i,j),phhp)==0
                                    if SENO(r(i,j),phhp)==psequence(r(i,j),DAP)                       % EXPECTED SEQUENCE NUMBER?
                                       SENO(r(i,j),phhp)=SENO(r(i,j),phhp)+1;
                                       SPTIME03(r(i,j),phhp)=ptime(r(i,j),DAP)+h1*10^-6;
                                    else
                                       SENO(r(i,j),phhp)=psequence(r(i,j),DAP)+1;
                                       SPTIME03(r(i,j),phhp)=-1*(ptime(r(i,j),DAP)+h1*10^-6);
                                    end
                                 else
                                    if SPTIME04(r(i,j),phhp)==0
                                       if SENO(r(i,j),phhp)==psequence(r(i,j),DAP)                       % EXPECTED SEQUENCE NUMBER?
                                          SENO(r(i,j),phhp)=SENO(r(i,j),phhp)+1;
                                          SPTIME04(r(i,j),phhp)=ptime(r(i,j),DAP)+h1*10^-6;
                                       else
                                          SENO(r(i,j),phhp)=psequence(r(i,j),DAP)+1;
                                          SPTIME04(r(i,j),phhp)=-1*(ptime(r(i,j),DAP)+h1*10^-6);
                                       end
                                    else
                                       if SPTIME05(r(i,j),phhp)==0
                                          if SENO(r(i,j),phhp)==psequence(r(i,j),DAP)                       % EXPECTED SEQUENCE NUMBER?
                                             SENO(r(i,j),phhp)=SENO(r(i,j),phhp)+1;
                                             SPTIME05(r(i,j),phhp)=ptime(r(i,j),DAP)+h1*10^-6;
                                          else
                                             SENO(r(i,j),phhp)=psequence(r(i,j),DAP)+1;
                                             SPTIME05(r(i,j),phhp)=-1*(ptime(r(i,j),DAP)+h1*10^-6);
                                          end
                                       end
                                    end
                                 end
                              end
                           end
                        end
                     end
                  else   
                     if brouting(r(i,j),DAP)==2
                       % CREDITC(r(i,j),2)=CREDITC(r(i,j),2)-1;
                        Ur=i-1;
                        if Ur==0
                           Ur=L;
                        end
                        if (n(Ur,j)+1)<=BUFFER
                           bfd(r(Ur,j),(n(Ur,j)+1))=bfd(r(i,j),DAP);
                           bfi(r(Ur,j),(n(Ur,j)+1))=bfi(r(i,j),DAP);
                           ptime(r(Ur,j),(n(Ur,j)+1))=ptime(r(i,j),DAP);
                           psequence(r(Ur,j),(n(Ur,j)+1))=psequence(r(i,j),DAP);
                        end
                        if fix(bfd(r(i,j),DAP))==r(Ur,j)
                           if (n(Ur,j)+1)<=BUFFER
                              n(Ur,j)=n(Ur,j)+1;
                              brouting(r(Ur,j),n(Ur,j))=1;
                              %MEASURET(r(Ur,j),1)=MEASURET(r(Ur,j),1)+1;
                           end
                        else
                           iq=Ur;jq=j;
                           Lr=jq-1;Rr=jq+1;Ur=iq-1;Dr=iq+1;
                           if Lr==0
                              Lr=L;
                           end
                           if Rr==(L+1)
                              Rr=1;
                           end
                           if Ur==0
                              Ur=L;
                           end
                           if Dr==(L+1)
                              Dr=1;
                           end
                           ddd2=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-Ur)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-jq)-L/2);
                           ddd3=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-iq)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-Rr)-L/2);
                           ddd4=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-Dr)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-jq)-L/2);
                           ddd5=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-iq)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-Lr)-L/2);
                           xxxmin=min([ddd2 ddd3 ddd4 ddd5]);
                           if ddd2==xxxmin
                              if ddd2==ddd3
                                 if (n(iq,jq)+1)<=BUFFER
                                    n(iq,jq)=n(iq,jq)+1;
                                    brouting(r(iq,jq),n(iq,jq))=3;
                                    %MEASURET(r(iq,jq),3)=MEASURET(r(iq,jq),3)+1;
                                 end
                              else
                                 if (n(iq,jq)+1)<=BUFFER
                                    n(iq,jq)=n(iq,jq)+1;
                                    brouting(r(iq,jq),n(iq,jq))=2;
                                    %MEASURET(r(iq,jq),2)=MEASURET(r(iq,jq),2)+1;
                                 end
                              end
                           else
                              if ddd3==xxxmin
                                 if ddd3==ddd4
                                    if (n(iq,jq)+1)<=BUFFER
                                       n(iq,jq)=n(iq,jq)+1;
                                       brouting(r(iq,jq),n(iq,jq))=4;
                                       %MEASURET(r(iq,jq),4)=MEASURET(r(iq,jq),4)+1;
                                    end 
                                 else
                                    if (n(iq,jq)+1)<=BUFFER
                                       n(iq,jq)=n(iq,jq)+1;
                                       brouting(r(iq,jq),n(iq,jq))=3;
                                       %MEASURET(r(iq,jq),3)=MEASURET(r(iq,jq),3)+1;
                                    end
                                 end
                              else
                                 if ddd4==xxxmin
                                    if ddd4==ddd5
                                       if (n(iq,jq)+1)<=BUFFER
                                          n(iq,jq)=n(iq,jq)+1;
                                          brouting(r(iq,jq),n(iq,jq))=5;
                                          %MEASURET(r(iq,jq),5)=MEASURET(r(iq,jq),5)+1;
                                       end            
                                    else
                                       if (n(iq,jq)+1)<=BUFFER
                                          n(iq,jq)=n(iq,jq)+1;
                                          brouting(r(iq,jq),n(iq,jq))=4;
                                          %MEASURET(r(iq,jq),4)=MEASURET(r(iq,jq),4)+1;
                                       end
                                    end
                                 else
                                    if (n(iq,jq)+1)<=BUFFER
                                       n(iq,jq)=n(iq,jq)+1;
                                       brouting(r(iq,jq),n(iq,jq))=5;
                                       %MEASURET(r(iq,jq),5)=MEASURET(r(iq,jq),5)+1;
                                    end
                                 end
                              end
                           end
                        end
                     else
                        if brouting(r(i,j),DAP)==3
                         %  CREDITC(r(i,j),3)=CREDITC(r(i,j),3)-1;
                           Rr=j+1;
                           if Rr==(L+1)
                              Rr=1;
                           end
                           if (n(i,Rr)+1)<=BUFFER
                              bfd(r(i,Rr),(n(i,Rr)+1))=bfd(r(i,j),DAP);
                              bfi(r(i,Rr),(n(i,Rr)+1))=bfi(r(i,j),DAP);
                              ptime(r(i,Rr),(n(i,Rr)+1))=ptime(r(i,j),DAP);
                              psequence(r(i,Rr),(n(i,Rr)+1))=psequence(r(i,j),DAP);
                           end
                           if fix(bfd(r(i,j),DAP))==r(i,Rr)
                              if (n(i,Rr)+1)<=BUFFER
                                 n(i,Rr)=n(i,Rr)+1;
                                 brouting(r(i,Rr),n(i,Rr))=1;
                                 %MEASURET(r(i,Rr),1)=MEASURET(r(i,Rr),1)+1;
                              end
                           else
                              iq=i;jq=Rr;
                              Lr=jq-1;Rr=jq+1;Ur=iq-1;Dr=iq+1;
                              if Lr==0
                                 Lr=L;
                              end
                              if Rr==(L+1)
                                 Rr=1;
                              end
                              if Ur==0
                                 Ur=L;
                              end
                              if Dr==(L+1)
                                 Dr=1;
                              end
                              ddd2=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-Ur)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-jq)-L/2);
                              ddd3=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-iq)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-Rr)-L/2);
                              ddd4=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-Dr)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-jq)-L/2);
                              ddd5=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-iq)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-Lr)-L/2);
                              xxxmin=min([ddd2 ddd3 ddd4 ddd5]);
                              if ddd2==xxxmin
                                 if ddd2==ddd3
                                    if (n(iq,jq)+1)<=BUFFER
                                       n(iq,jq)=n(iq,jq)+1;
                                       brouting(r(iq,jq),n(iq,jq))=3;
                                       %MEASURET(r(iq,jq),3)=MEASURET(r(iq,jq),3)+1;
                                    end
                                 else
                                    if (n(iq,jq)+1)<=BUFFER
                                       n(iq,jq)=n(iq,jq)+1;
                                       brouting(r(iq,jq),n(iq,jq))=2;
                                       %MEASURET(r(iq,jq),2)=MEASURET(r(iq,jq),2)+1;
                                    end
                                 end
                              else
                                 if ddd3==xxxmin
                                    if ddd3==ddd4
                                       if (n(iq,jq)+1)<=BUFFER
                                          n(iq,jq)=n(iq,jq)+1;
                                          brouting(r(iq,jq),n(iq,jq))=4;
                                          %MEASURET(r(iq,jq),4)=MEASURET(r(iq,jq),4)+1;
                                       end 
                                    else
                                       if (n(iq,jq)+1)<=BUFFER
                                          n(iq,jq)=n(iq,jq)+1;
                                          brouting(r(iq,jq),n(iq,jq))=3;
                                          %MEASURET(r(iq,jq),3)=MEASURET(r(iq,jq),3)+1;
                                       end
                                    end
                                 else
                                    if ddd4==xxxmin
                                       if ddd4==ddd5
                                          if (n(iq,jq)+1)<=BUFFER
                                             n(iq,jq)=n(iq,jq)+1;
                                             brouting(r(iq,jq),n(iq,jq))=5;
                                             %MEASURET(r(iq,jq),5)=MEASURET(r(iq,jq),5)+1;
                                          end            
                                       else
                                          if (n(iq,jq)+1)<=BUFFER
                                             n(iq,jq)=n(iq,jq)+1;
                                             brouting(r(iq,jq),n(iq,jq))=4;
                                             %MEASURET(r(iq,jq),4)=MEASURET(r(iq,jq),4)+1;
                                          end
                                       end
                                    else
                                       if (n(iq,jq)+1)<=BUFFER
                                          n(iq,jq)=n(iq,jq)+1;
                                          brouting(r(iq,jq),n(iq,jq))=5;
                                          %MEASURET(r(iq,jq),5)=MEASURET(r(iq,jq),5)+1;
                                       end
                                    end
                                 end 
                              end
                           end
                        else
                           if brouting(r(i,j),DAP)==4
                             % CREDITC(r(i,j),4)=CREDITC(r(i,j),4)-1;
                              Dr=i+1;
                              if Dr==(L+1)
                                 Dr=1;
                              end
                              if (n(Dr,j)+1)<=BUFFER
                                 bfd(r(Dr,j),(n(Dr,j)+1))=bfd(r(i,j),DAP);
                                 bfi(r(Dr,j),(n(Dr,j)+1))=bfi(r(i,j),DAP);
                                 ptime(r(Dr,j),(n(Dr,j)+1))=ptime(r(i,j),DAP);
                                 psequence(r(Dr,j),(n(Dr,j)+1))=psequence(r(i,j),DAP);
                              end
                              if fix(bfd(r(i,j),DAP))==r(Dr,j)
                                 if (n(Dr,j)+1)<=BUFFER
                                    n(Dr,j)=n(Dr,j)+1;
                                    brouting(r(Dr,j),n(Dr,j))=1;
                                    %MEASURET(r(Dr,j),1)=MEASURET(r(Dr,j),1)+1;
                                 end
                              else
                                 iq=Dr;jq=j;
                                 Lr=jq-1;Rr=jq+1;Ur=iq-1;Dr=iq+1;
                                 if Lr==0
                                    Lr=L;
                                 end
                                 if Rr==(L+1)
                                    Rr=1;
                                 end
                                 if Ur==0
                                    Ur=L;
                                 end
                                 if Dr==(L+1)
                                    Dr=1;
                                 end
                                 ddd2=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-Ur)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-jq)-L/2);
                                 ddd3=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-iq)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-Rr)-L/2);
                                 ddd4=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-Dr)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-jq)-L/2);
                                 ddd5=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-iq)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-Lr)-L/2);
                                 xxxmin=min([ddd2 ddd3 ddd4 ddd5]);
                                 if ddd2==xxxmin
                                    if ddd2==ddd3
                                       if (n(iq,jq)+1)<=BUFFER
                                          n(iq,jq)=n(iq,jq)+1;
                                          brouting(r(iq,jq),n(iq,jq))=3;
                                          %MEASURET(r(iq,jq),3)=MEASURET(r(iq,jq),3)+1;
                                       end
                                    else
                                       if (n(iq,jq)+1)<=BUFFER
                                          n(iq,jq)=n(iq,jq)+1;
                                          brouting(r(iq,jq),n(iq,jq))=2;
                                          %MEASURET(r(iq,jq),2)=MEASURET(r(iq,jq),2)+1;
                                       end
                                    end
                                 else
                                    if ddd3==xxxmin
                                       if ddd3==ddd4
                                          if (n(iq,jq)+1)<=BUFFER
                                             n(iq,jq)=n(iq,jq)+1;
                                             brouting(r(iq,jq),n(iq,jq))=4;
                                             %MEASURET(r(iq,jq),4)=MEASURET(r(iq,jq),4)+1;
                                          end 
                                       else
                                          if (n(iq,jq)+1)<=BUFFER
                                             n(iq,jq)=n(iq,jq)+1;
                                             brouting(r(iq,jq),n(iq,jq))=3;
                                             %MEASURET(r(iq,jq),3)=MEASURET(r(iq,jq),3)+1;
                                          end
                                       end
                                    else
                                       if ddd4==xxxmin
                                          if ddd4==ddd5
                                             if (n(iq,jq)+1)<=BUFFER
                                                n(iq,jq)=n(iq,jq)+1;
                                                brouting(r(iq,jq),n(iq,jq))=5;
                                                %MEASURET(r(iq,jq),5)=MEASURET(r(iq,jq),5)+1;
                                             end            
                                          else
                                             if (n(iq,jq)+1)<=BUFFER
                                                n(iq,jq)=n(iq,jq)+1;
                                                brouting(r(iq,jq),n(iq,jq))=4;
                                                %MEASURET(r(iq,jq),4)=MEASURET(r(iq,jq),4)+1;
                                             end
                                          end
                                       else
                                          if (n(iq,jq)+1)<=BUFFER
                                             n(iq,jq)=n(iq,jq)+1;
                                             brouting(r(iq,jq),n(iq,jq))=5;
                                             %MEASURET(r(iq,jq),5)=MEASURET(r(iq,jq),5)+1;
                                          end
                                       end
                                    end 
                                 end
                              end
                           else
                             % CREDITC(r(i,j),5)=CREDITC(r(i,j),5)-1;
                              Lr=j-1;
                              if Lr==0
                                 Lr=L;
                              end
                              if (n(i,Lr)+1)<=BUFFER
                                 bfd(r(i,Lr),(n(i,Lr)+1))=bfd(r(i,j),DAP);
                                 bfi(r(i,Lr),(n(i,Lr)+1))=bfi(r(i,j),DAP);
                                 ptime(r(i,Lr),(n(i,Lr)+1))=ptime(r(i,j),DAP);
                                 psequence(r(i,Lr),(n(i,Lr)+1))=psequence(r(i,j),DAP);
                              end
                              if fix(bfd(r(i,j),DAP))==r(i,Lr)
                                 if (n(i,Lr)+1)<=BUFFER
                                    n(i,Lr)=n(i,Lr)+1;
                                    brouting(r(i,Lr),n(i,Lr))=1;
                                    %MEASURET(r(i,Lr),1)=MEASURET(r(i,Lr),1)+1;
                                 end
                              else
                                 iq=i;jq=Lr;
                                 Lr=jq-1;Rr=jq+1;Ur=iq-1;Dr=iq+1;
                                 if Lr==0
                                    Lr=L;
                                 end
                                 if Rr==(L+1)
                                    Rr=1;
                                 end
                                 if Ur==0
                                    Ur=L;
                                 end
                                 if Dr==(L+1)
                                    Dr=1;
                                 end
                                 ddd2=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-Ur)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-jq)-L/2);
                                 ddd3=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-iq)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-Rr)-L/2);
                                 ddd4=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-Dr)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-jq)-L/2);
                                 ddd5=L-abs(abs(Habscissa(fix(bfd(r(i,j),DAP)))-iq)-L/2)-abs(abs(Hordinate(fix(bfd(r(i,j),DAP)))-Lr)-L/2);
                                 xxxmin=min([ddd2 ddd3 ddd4 ddd5]);
                                 if ddd2==xxxmin
                                    if ddd2==ddd3
                                       if (n(iq,jq)+1)<=BUFFER
                                          n(iq,jq)=n(iq,jq)+1;
                                          brouting(r(iq,jq),n(iq,jq))=3;
                                          %MEASURET(r(iq,jq),3)=MEASURET(r(iq,jq),3)+1;
                                       end
                                    else
                                       if (n(iq,jq)+1)<=BUFFER
                                          n(iq,jq)=n(iq,jq)+1;
                                          brouting(r(iq,jq),n(iq,jq))=2;
                                          %MEASURET(r(iq,jq),2)=MEASURET(r(iq,jq),2)+1;
                                       end
                                    end
                                 else
                                    if ddd3==xxxmin
                                       if ddd3==ddd4
                                          if (n(iq,jq)+1)<=BUFFER
                                             n(iq,jq)=n(iq,jq)+1;
                                             brouting(r(iq,jq),n(iq,jq))=4;
                                             %MEASURET(r(iq,jq),4)=MEASURET(r(iq,jq),4)+1;
                                          end 
                                       else
                                          if (n(iq,jq)+1)<=BUFFER
                                             n(iq,jq)=n(iq,jq)+1;
                                             brouting(r(iq,jq),n(iq,jq))=3;
                                             %MEASURET(r(iq,jq),3)=MEASURET(r(iq,jq),3)+1;
                                          end
                                       end
                                    else
                                       if ddd4==xxxmin
                                          if ddd4==ddd5
                                             if (n(iq,jq)+1)<=BUFFER
                                                n(iq,jq)=n(iq,jq)+1;
                                                brouting(r(iq,jq),n(iq,jq))=5;
                                                %MEASURET(r(iq,jq),5)=MEASURET(r(iq,jq),5)+1;
                                             end            
                                          else
                                             if (n(iq,jq)+1)<=BUFFER
                                                n(iq,jq)=n(iq,jq)+1;
                                                brouting(r(iq,jq),n(iq,jq))=4;
                                                %MEASURET(r(iq,jq),4)=MEASURET(r(iq,jq),4)+1;
                                             end
                                          end
                                       else
                                          if (n(iq,jq)+1)<=BUFFER
                                             n(iq,jq)=n(iq,jq)+1;
                                             brouting(r(iq,jq),n(iq,jq))=5;
                                             %MEASURET(r(iq,jq),5)=MEASURET(r(iq,jq),5)+1;
                                          end
                                       end
                                    end 
                                 end
                              end
                           end
                        end
                     end
                  end
                  if n(i,j)==1;
                     n(i,j)=n(i,j)-1;
                  else
                     n(i,j)=n(i,j)-1;
                     bfd(r(i,j),1:n(i,j))=bfd(r(i,j),2:(n(i,j)+1));
                     bfi(r(i,j),1:n(i,j))=bfi(r(i,j),2:(n(i,j)+1));
                     ptime(r(i,j),1:n(i,j))=ptime(r(i,j),2:(n(i,j)+1));
                     psequence(r(i,j),1:n(i,j))=psequence(r(i,j),2:(n(i,j)+1));
                     brouting(r(i,j),1:n(i,j))=brouting(r(i,j),2:(n(i,j)+1));
                  end
               end   
            end
         end
      end
    end   
    for i=1:L                                              % ptime ADDS ONE
       for j=1:L
          if n(i,j)>0
             ptime(r(i,j),1:n(i,j))=ptime(r(i,j),1:n(i,j))+1;
          end
       end
    end
  end
  %for pi01=1:mq
  %    xxload(pi01)=.9*xxload(pi01)+.1*sum(MEASURET(pi01,:));
  %end
  Lossrate(ii)=(Tinput-Toutput)/Tinput;
  TOUT=TOUT+Toutput;TIN=TIN+Tinput;
  xz(ii)=sum(sum(Indica));%xns(ii)=sum(Indica(PNODE,:));xns2(ii)=sum(Indica((L+2),:));xc(ii)=max(cwnd(PNODE,:));xc2(ii)=max(cwnd((L+2),:));xnd1(ii)=sum(SRactive((L+2),:));xnd2(ii)=sum(SRactive((2*L-1),:));xnd3(ii)=sum(SRactive(19,:));xnd4(ii)=sum(SRactive(17,:));xnd5(ii)=sum(SRactive(PNODE,:));%xnd6(ii)=sum(SRactive((PNODE+3),:));xnd7(ii)=sum(SRactive(65,:));xnd8(ii)=sum(SRactive(68,:));xnd9(ii)=sum(SRactive(71,:));
  xmaxd(ii)=sum(SRactive(1,:));xmaxda(ii)=1;
  for pi01=2:mq
      if xmaxd(ii)<sum(SRactive(pi01,:))
          xmaxd(ii)=sum(SRactive(pi01,:));
          xmaxda(ii)=pi01;
      end
  end
  %xxxu(ii)=MEASURET(PNODE,2);xxxo(ii)=MEASURET(PNODE,1);xxxl(ii)=MEASURET(PNODE,5);xxxd(ii)=MEASURET(PNODE,4);xxxr(ii)=MEASURET(PNODE,3);
  %xxu(ii)=MEASURET((PNODE+L),2);xxo(ii)=MEASURET((PNODE+L),1);xxl(ii)=MEASURET((PNODE+L),5);xxd(ii)=MEASURET((PNODE+L),4);xxr(ii)=MEASURET((PNODE+L),3);
  %xu(ii)=MEASURET((PNODE+L+L),2);xl(ii)=MEASURET((PNODE+L+L),5);xd(ii)=MEASURET((PNODE+L+L),4);xr(ii)=MEASURET((PNODE+L+L),3);xo(ii)=MEASURET((PNODE+L+L),1);
  %MEASURET(1:mq,1:5)=0;xxxq(ii)=n(probenode,probenode);xxq(ii)=n((probenode+1),probenode);xq(ii)=n((probenode+2),probenode);
end

%xxxu=xxxu(501:LONGTIME);xxxl=xxxl(501:LONGTIME);xxxd=xxxd(501:LONGTIME);xxxr=xxxr(501:LONGTIME);xxxo=xxxo(501:LONGTIME);
%xxu=xxu(501:LONGTIME);xxl=xxl(501:LONGTIME);xxd=xxd(501:LONGTIME);xxr=xxr(501:LONGTIME);xxo=xxo(501:LONGTIME);
%xu=xu(501:LONGTIME);xl=xl(501:LONGTIME);xd=xd(501:LONGTIME);xr=xr(501:LONGTIME);xo=xo(501:LONGTIME);
%Lossrate=Lossrate(501:LONGTIME);xxxq=xxxq(501:LONGTIME);xxq=xxq(501:LONGTIME);xq=xq(501:LONGTIME);
%xz=xz(501:LONGTIME);xns=xns(501:LONGTIME);xns2=xns2(501:LONGTIME);xnd=xnd(501:LONGTIME);xnd2=xnd2(501:LONGTIME);xc=xc(501:LONGTIME);xc2=xc2(501:LONGTIME);
tt=cputime-tt;                                             % TOTAL EXECUTION TIME xxxq xxq xq xxload xxu xxxu xxxo xxu xxl xxd xxr xxo xu xl xd xr xo xns xns2 xnd1 xnd2 xnd3 xnd4 xnd5 xc xc2 MEASURET

save catcpi1t5-r2T1K100AL10-a15on50-a15off3000 AAX xmaxd xmaxda tt Lossrate TOUT TIN xz SRTT SENO cwnd Sindica Indica SRactive n  % SAVE DATA TO A MAT-FILE 
