Option Strict On

Imports System.Collections.Specialized

Imports SF = Syncfusion.Windows.Forms.Grid

Public Class ScenarioPicker
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents GoButton As System.Windows.Forms.Button
    Private WithEvents GroupView4 As Syncfusion.Windows.Forms.Tools.GroupView
    Private WithEvents GroupView6 As Syncfusion.Windows.Forms.Tools.GroupView
    Private WithEvents FaceGroup As System.Windows.Forms.GroupBox
    Private WithEvents GroupView5 As Syncfusion.Windows.Forms.Tools.GroupView
    Private WithEvents GroupView7 As Syncfusion.Windows.Forms.Tools.GroupView
    Private WithEvents GroupView8 As Syncfusion.Windows.Forms.Tools.GroupView
    Private WithEvents GroupView9 As Syncfusion.Windows.Forms.Tools.GroupView
    Private WithEvents FingerprintGroup As System.Windows.Forms.GroupBox
    Private WithEvents IrisGroup As System.Windows.Forms.GroupBox
    Private WithEvents Label4 As System.Windows.Forms.Label
    Private WithEvents Label6 As System.Windows.Forms.Label
    Private WithEvents Label5 As System.Windows.Forms.Label
    Private WithEvents Label7 As System.Windows.Forms.Label
    Private WithEvents Label8 As System.Windows.Forms.Label
    Private WithEvents Label9 As System.Windows.Forms.Label
    Private WithEvents FaceScenarioList As System.Windows.Forms.ListBox
    Private WithEvents FingerScenarioList As System.Windows.Forms.ListBox
    Private WithEvents mFaceDownloadCheck As System.Windows.Forms.CheckBox
    Private WithEvents mFaceCaptureCheck As System.Windows.Forms.CheckBox
    Private WithEvents mFaceInitializeCheck As System.Windows.Forms.CheckBox
    Private WithEvents mFingerCaptureCheck As System.Windows.Forms.CheckBox
    Private WithEvents mFingerInitializeCheck As System.Windows.Forms.CheckBox
    Private WithEvents mIrisCaptureCheck As System.Windows.Forms.CheckBox
    Private WithEvents mIrisInitializeCheck As System.Windows.Forms.CheckBox
    Private WithEvents IrisScenarioList As System.Windows.Forms.ListBox
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(ScenarioPicker))
        Me.GoButton = New System.Windows.Forms.Button
        Me.FaceGroup = New System.Windows.Forms.GroupBox
        Me.FaceScenarioList = New System.Windows.Forms.ListBox
        Me.Label4 = New System.Windows.Forms.Label
        Me.mFaceDownloadCheck = New System.Windows.Forms.CheckBox
        Me.mFaceCaptureCheck = New System.Windows.Forms.CheckBox
        Me.mFaceInitializeCheck = New System.Windows.Forms.CheckBox
        Me.GroupView4 = New Syncfusion.Windows.Forms.Tools.GroupView
        Me.Label6 = New System.Windows.Forms.Label
        Me.GroupView6 = New Syncfusion.Windows.Forms.Tools.GroupView
        Me.FingerprintGroup = New System.Windows.Forms.GroupBox
        Me.FingerScenarioList = New System.Windows.Forms.ListBox
        Me.Label5 = New System.Windows.Forms.Label
        Me.mFingerCaptureCheck = New System.Windows.Forms.CheckBox
        Me.mFingerInitializeCheck = New System.Windows.Forms.CheckBox
        Me.GroupView5 = New Syncfusion.Windows.Forms.Tools.GroupView
        Me.Label7 = New System.Windows.Forms.Label
        Me.GroupView7 = New Syncfusion.Windows.Forms.Tools.GroupView
        Me.IrisGroup = New System.Windows.Forms.GroupBox
        Me.IrisScenarioList = New System.Windows.Forms.ListBox
        Me.Label8 = New System.Windows.Forms.Label
        Me.mIrisCaptureCheck = New System.Windows.Forms.CheckBox
        Me.mIrisInitializeCheck = New System.Windows.Forms.CheckBox
        Me.GroupView8 = New Syncfusion.Windows.Forms.Tools.GroupView
        Me.Label9 = New System.Windows.Forms.Label
        Me.GroupView9 = New Syncfusion.Windows.Forms.Tools.GroupView
        Me.FaceGroup.SuspendLayout()
        Me.FingerprintGroup.SuspendLayout()
        Me.IrisGroup.SuspendLayout()
        Me.SuspendLayout()
        '
        'GoButton
        '
        Me.GoButton.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.GoButton.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GoButton.Location = New System.Drawing.Point(328, 528)
        Me.GoButton.Name = "GoButton"
        Me.GoButton.TabIndex = 3
        Me.GoButton.Text = "Go"
        '
        'FaceGroup
        '
        Me.FaceGroup.Controls.Add(Me.FaceScenarioList)
        Me.FaceGroup.Controls.Add(Me.Label4)
        Me.FaceGroup.Controls.Add(Me.mFaceDownloadCheck)
        Me.FaceGroup.Controls.Add(Me.mFaceCaptureCheck)
        Me.FaceGroup.Controls.Add(Me.mFaceInitializeCheck)
        Me.FaceGroup.Controls.Add(Me.GroupView4)
        Me.FaceGroup.Controls.Add(Me.Label6)
        Me.FaceGroup.Controls.Add(Me.GroupView6)
        Me.FaceGroup.Location = New System.Drawing.Point(16, 16)
        Me.FaceGroup.Name = "FaceGroup"
        Me.FaceGroup.Size = New System.Drawing.Size(384, 160)
        Me.FaceGroup.TabIndex = 12
        Me.FaceGroup.TabStop = False
        Me.FaceGroup.Text = "Face"
        '
        'FaceScenarioList
        '
        Me.FaceScenarioList.Location = New System.Drawing.Point(32, 56)
        Me.FaceScenarioList.Name = "FaceScenarioList"
        Me.FaceScenarioList.Size = New System.Drawing.Size(168, 69)
        Me.FaceScenarioList.TabIndex = 15
        '
        'Label4
        '
        Me.Label4.Font = New System.Drawing.Font("Trebuchet MS", 8.25!, System.Drawing.FontStyle.Underline, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label4.Location = New System.Drawing.Point(240, 32)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(72, 16)
        Me.Label4.TabIndex = 14
        Me.Label4.Text = "Pick a Type:"
        '
        'mFaceDownloadCheck
        '
        Me.mFaceDownloadCheck.Enabled = False
        Me.mFaceDownloadCheck.Location = New System.Drawing.Point(248, 104)
        Me.mFaceDownloadCheck.Name = "mFaceDownloadCheck"
        Me.mFaceDownloadCheck.Size = New System.Drawing.Size(88, 16)
        Me.mFaceDownloadCheck.TabIndex = 12
        Me.mFaceDownloadCheck.Text = "Download"
        '
        'mFaceCaptureCheck
        '
        Me.mFaceCaptureCheck.Enabled = False
        Me.mFaceCaptureCheck.Location = New System.Drawing.Point(248, 80)
        Me.mFaceCaptureCheck.Name = "mFaceCaptureCheck"
        Me.mFaceCaptureCheck.Size = New System.Drawing.Size(88, 16)
        Me.mFaceCaptureCheck.TabIndex = 11
        Me.mFaceCaptureCheck.Text = "Capture"
        '
        'mFaceInitializeCheck
        '
        Me.mFaceInitializeCheck.Enabled = False
        Me.mFaceInitializeCheck.Location = New System.Drawing.Point(248, 56)
        Me.mFaceInitializeCheck.Name = "mFaceInitializeCheck"
        Me.mFaceInitializeCheck.Size = New System.Drawing.Size(88, 16)
        Me.mFaceInitializeCheck.TabIndex = 10
        Me.mFaceInitializeCheck.Text = "Initialize"
        '
        'GroupView4
        '
        Me.GroupView4.LargeImageList = Nothing
        Me.GroupView4.Location = New System.Drawing.Point(232, 24)
        Me.GroupView4.Name = "GroupView4"
        Me.GroupView4.Size = New System.Drawing.Size(136, 112)
        Me.GroupView4.SmallImageList = Nothing
        Me.GroupView4.TabIndex = 5
        Me.GroupView4.Text = "GroupView3"
        '
        'Label6
        '
        Me.Label6.Font = New System.Drawing.Font("Trebuchet MS", 8.25!, System.Drawing.FontStyle.Underline, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label6.Location = New System.Drawing.Point(32, 32)
        Me.Label6.Name = "Label6"
        Me.Label6.Size = New System.Drawing.Size(192, 23)
        Me.Label6.TabIndex = 2
        Me.Label6.Text = "Choose a scenario"
        '
        'GroupView6
        '
        Me.GroupView6.LargeImageList = Nothing
        Me.GroupView6.Location = New System.Drawing.Point(16, 24)
        Me.GroupView6.Name = "GroupView6"
        Me.GroupView6.Size = New System.Drawing.Size(208, 112)
        Me.GroupView6.SmallImageList = Nothing
        Me.GroupView6.TabIndex = 0
        Me.GroupView6.Text = "GroupView1"
        '
        'FingerprintGroup
        '
        Me.FingerprintGroup.Controls.Add(Me.FingerScenarioList)
        Me.FingerprintGroup.Controls.Add(Me.Label5)
        Me.FingerprintGroup.Controls.Add(Me.mFingerCaptureCheck)
        Me.FingerprintGroup.Controls.Add(Me.mFingerInitializeCheck)
        Me.FingerprintGroup.Controls.Add(Me.GroupView5)
        Me.FingerprintGroup.Controls.Add(Me.Label7)
        Me.FingerprintGroup.Controls.Add(Me.GroupView7)
        Me.FingerprintGroup.Location = New System.Drawing.Point(16, 184)
        Me.FingerprintGroup.Name = "FingerprintGroup"
        Me.FingerprintGroup.Size = New System.Drawing.Size(384, 160)
        Me.FingerprintGroup.TabIndex = 13
        Me.FingerprintGroup.TabStop = False
        Me.FingerprintGroup.Text = "Fingerprint"
        '
        'FingerScenarioList
        '
        Me.FingerScenarioList.Location = New System.Drawing.Point(32, 56)
        Me.FingerScenarioList.Name = "FingerScenarioList"
        Me.FingerScenarioList.Size = New System.Drawing.Size(168, 69)
        Me.FingerScenarioList.TabIndex = 15
        '
        'Label5
        '
        Me.Label5.Font = New System.Drawing.Font("Trebuchet MS", 8.25!, System.Drawing.FontStyle.Underline, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label5.Location = New System.Drawing.Point(240, 32)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(72, 16)
        Me.Label5.TabIndex = 14
        Me.Label5.Text = "Pick a Type:"
        '
        'mFingerCaptureCheck
        '
        Me.mFingerCaptureCheck.Enabled = False
        Me.mFingerCaptureCheck.Location = New System.Drawing.Point(248, 80)
        Me.mFingerCaptureCheck.Name = "mFingerCaptureCheck"
        Me.mFingerCaptureCheck.Size = New System.Drawing.Size(88, 16)
        Me.mFingerCaptureCheck.TabIndex = 11
        Me.mFingerCaptureCheck.Text = "Capture"
        '
        'mFingerInitializeCheck
        '
        Me.mFingerInitializeCheck.Enabled = False
        Me.mFingerInitializeCheck.Location = New System.Drawing.Point(248, 56)
        Me.mFingerInitializeCheck.Name = "mFingerInitializeCheck"
        Me.mFingerInitializeCheck.Size = New System.Drawing.Size(88, 16)
        Me.mFingerInitializeCheck.TabIndex = 10
        Me.mFingerInitializeCheck.Text = "Initialize"
        '
        'GroupView5
        '
        Me.GroupView5.LargeImageList = Nothing
        Me.GroupView5.Location = New System.Drawing.Point(232, 24)
        Me.GroupView5.Name = "GroupView5"
        Me.GroupView5.Size = New System.Drawing.Size(136, 112)
        Me.GroupView5.SmallImageList = Nothing
        Me.GroupView5.TabIndex = 5
        Me.GroupView5.Text = "GroupView3"
        '
        'Label7
        '
        Me.Label7.Font = New System.Drawing.Font("Trebuchet MS", 8.25!, System.Drawing.FontStyle.Underline, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label7.Location = New System.Drawing.Point(32, 32)
        Me.Label7.Name = "Label7"
        Me.Label7.Size = New System.Drawing.Size(192, 23)
        Me.Label7.TabIndex = 2
        Me.Label7.Text = "Choose a scenario"
        '
        'GroupView7
        '
        Me.GroupView7.LargeImageList = Nothing
        Me.GroupView7.Location = New System.Drawing.Point(16, 24)
        Me.GroupView7.Name = "GroupView7"
        Me.GroupView7.Size = New System.Drawing.Size(208, 112)
        Me.GroupView7.SmallImageList = Nothing
        Me.GroupView7.TabIndex = 0
        Me.GroupView7.Text = "GroupView1"
        '
        'IrisGroup
        '
        Me.IrisGroup.Controls.Add(Me.IrisScenarioList)
        Me.IrisGroup.Controls.Add(Me.Label8)
        Me.IrisGroup.Controls.Add(Me.mIrisCaptureCheck)
        Me.IrisGroup.Controls.Add(Me.mIrisInitializeCheck)
        Me.IrisGroup.Controls.Add(Me.GroupView8)
        Me.IrisGroup.Controls.Add(Me.Label9)
        Me.IrisGroup.Controls.Add(Me.GroupView9)
        Me.IrisGroup.Location = New System.Drawing.Point(16, 352)
        Me.IrisGroup.Name = "IrisGroup"
        Me.IrisGroup.Size = New System.Drawing.Size(384, 160)
        Me.IrisGroup.TabIndex = 14
        Me.IrisGroup.TabStop = False
        Me.IrisGroup.Text = "Iris"
        '
        'IrisScenarioList
        '
        Me.IrisScenarioList.Location = New System.Drawing.Point(32, 56)
        Me.IrisScenarioList.Name = "IrisScenarioList"
        Me.IrisScenarioList.Size = New System.Drawing.Size(168, 69)
        Me.IrisScenarioList.TabIndex = 15
        '
        'Label8
        '
        Me.Label8.Font = New System.Drawing.Font("Trebuchet MS", 8.25!, System.Drawing.FontStyle.Underline, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label8.Location = New System.Drawing.Point(240, 32)
        Me.Label8.Name = "Label8"
        Me.Label8.Size = New System.Drawing.Size(72, 16)
        Me.Label8.TabIndex = 14
        Me.Label8.Text = "Pick a Type:"
        '
        'mIrisCaptureCheck
        '
        Me.mIrisCaptureCheck.Enabled = False
        Me.mIrisCaptureCheck.Location = New System.Drawing.Point(248, 80)
        Me.mIrisCaptureCheck.Name = "mIrisCaptureCheck"
        Me.mIrisCaptureCheck.Size = New System.Drawing.Size(88, 16)
        Me.mIrisCaptureCheck.TabIndex = 11
        Me.mIrisCaptureCheck.Text = "Capture"
        '
        'mIrisInitializeCheck
        '
        Me.mIrisInitializeCheck.Enabled = False
        Me.mIrisInitializeCheck.Location = New System.Drawing.Point(248, 56)
        Me.mIrisInitializeCheck.Name = "mIrisInitializeCheck"
        Me.mIrisInitializeCheck.Size = New System.Drawing.Size(88, 16)
        Me.mIrisInitializeCheck.TabIndex = 10
        Me.mIrisInitializeCheck.Text = "Initialize"
        '
        'GroupView8
        '
        Me.GroupView8.LargeImageList = Nothing
        Me.GroupView8.Location = New System.Drawing.Point(232, 24)
        Me.GroupView8.Name = "GroupView8"
        Me.GroupView8.Size = New System.Drawing.Size(136, 112)
        Me.GroupView8.SmallImageList = Nothing
        Me.GroupView8.TabIndex = 5
        Me.GroupView8.Text = "GroupView3"
        '
        'Label9
        '
        Me.Label9.Font = New System.Drawing.Font("Trebuchet MS", 8.25!, System.Drawing.FontStyle.Underline, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label9.Location = New System.Drawing.Point(32, 32)
        Me.Label9.Name = "Label9"
        Me.Label9.Size = New System.Drawing.Size(192, 23)
        Me.Label9.TabIndex = 2
        Me.Label9.Text = "Choose a scenario"
        '
        'GroupView9
        '
        Me.GroupView9.LargeImageList = Nothing
        Me.GroupView9.Location = New System.Drawing.Point(16, 24)
        Me.GroupView9.Name = "GroupView9"
        Me.GroupView9.Size = New System.Drawing.Size(208, 112)
        Me.GroupView9.SmallImageList = Nothing
        Me.GroupView9.TabIndex = 0
        Me.GroupView9.Text = "GroupView1"
        '
        'ScenarioPicker
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(424, 574)
        Me.Controls.Add(Me.IrisGroup)
        Me.Controls.Add(Me.FingerprintGroup)
        Me.Controls.Add(Me.FaceGroup)
        Me.Controls.Add(Me.GoButton)
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.MaximizeBox = False
        Me.MinimizeBox = False
        Me.Name = "ScenarioPicker"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "Scenario Picker"
        Me.FaceGroup.ResumeLayout(False)
        Me.FingerprintGroup.ResumeLayout(False)
        Me.IrisGroup.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region


    Public Enum Scenarios
        AllOkay
        AlwaysHaveFailure
        AlwaysHaveTimeout
        HaveRandomFailure
        HaveRandomTimeout
        HaveHighFailureRate
        HaveHighTimeoutRate
        NumberOfScenariors
    End Enum

    Protected Overrides Sub OnLoad(ByVal e As EventArgs)

        FaceScenario = New ArrayList(2)
        FingerScenario = New ArrayList(2)
        IrisScenario = New ArrayList(2)

        MyBase.OnLoad(e)
        For i As Integer = 0 To Scenarios.NumberOfScenariors - 1
            Dim scenario As Scenarios = CType(i, Scenarios)
            FaceScenarioList.Items.Add(scenario.ToString)
            FingerScenarioList.Items.Add(scenario.ToString)
            IrisScenarioList.Items.Add(scenario.ToString)
        Next
        FaceScenarioList.SelectedIndex = 0
        FingerScenarioList.SelectedIndex = 0
        IrisScenarioList.SelectedIndex = 0

        Me.Refresh()

    End Sub

    Private Sub ScenarioPicker_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub

    Private Sub FaceScenarioList_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FaceScenarioList.SelectedIndexChanged
        Dim SelectedScenario As Scenarios = CType(FaceScenarioList.SelectedIndex, Scenarios)
        If FaceScenario.Count = 0 Then FaceScenario.Insert(0, SelectedScenario)
        FaceScenario(0) = SelectedScenario
        EnableCheckBox(SensorType.Face, SelectedScenario)
        Refresh()
    End Sub

    Private Sub FingerScenarioList_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FingerScenarioList.SelectedIndexChanged
        Dim SelectedScenario As Scenarios = CType(FingerScenarioList.SelectedIndex, Scenarios)
        If FingerScenario.Count = 0 Then FingerScenario.Insert(0, SelectedScenario)
        FingerScenario(0) = SelectedScenario
        EnableCheckBox(SensorType.Fingerprint, SelectedScenario)
        Refresh()
    End Sub

    Private Sub IrisScenarioList_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IrisScenarioList.SelectedIndexChanged
        Dim SelectedScenario As Scenarios = CType(IrisScenarioList.SelectedIndex, Scenarios)
        If IrisScenario.Count = 0 Then IrisScenario.Insert(0, SelectedScenario)
        IrisScenario(0) = SelectedScenario
        EnableCheckBox(SensorType.Iris, SelectedScenario)
        Refresh()
    End Sub

    Private Function ScenariosSelections(ByVal sType As SensorType, ByVal selectedScenario As Scenarios) As Decimal
        Select Case selectedScenario
            Case Scenarios.AllOkay
            Case Scenarios.AlwaysHaveFailure, Scenarios.AlwaysHaveTimeout
                Return 1D
            Case Scenarios.HaveHighFailureRate, Scenarios.HaveHighTimeoutRate
                Return 0.8D
            Case Scenarios.HaveRandomFailure, Scenarios.HaveRandomTimeout
                Return 0.25D
        End Select
    End Function

    Private Sub EnableCheckBox(ByVal sType As SensorType, ByVal selectedScenario As Scenarios)
        Dim enable As Boolean
        If selectedScenario <> Scenarios.AllOkay Then
            enable = True
        Else
            enable = False
        End If
        Select Case sType
            Case SensorType.Face
                If selectedScenario <> Scenarios.AlwaysHaveTimeout AndAlso _
                   selectedScenario <> Scenarios.HaveHighTimeoutRate AndAlso _
                   selectedScenario <> Scenarios.HaveRandomTimeout Then
                    mFaceCaptureCheck.Enabled = enable
                Else
                    mFaceCaptureCheck.Enabled = Not enable
                End If
                mFaceInitializeCheck.Enabled = enable
                mFaceDownloadCheck.Enabled = enable
                FaceCheckBoxEnabled = enable
            Case SensorType.Fingerprint
                    mFingerCaptureCheck.Enabled = enable
                    mFingerInitializeCheck.Enabled = enable
                    FingerCheckBoxEnabled = enable
            Case SensorType.Iris
                    mIrisCaptureCheck.Enabled = enable
                    mIrisInitializeCheck.Enabled = enable
                    IrisCheckBoxEnabled = enable
        End Select
        Refresh()
    End Sub

    Public Overrides Sub Refresh()
        MyBase.Refresh()
        If (FaceCheckBoxEnabled AndAlso Not mFaceCaptureCheck.Checked AndAlso _
                                     Not mFaceInitializeCheck.Checked AndAlso Not mFaceDownloadCheck.Checked) Or _
           (FingerCheckBoxEnabled AndAlso Not mFingerCaptureCheck.Checked AndAlso Not mFingerInitializeCheck.Checked) Or _
           (IrisCheckBoxEnabled AndAlso Not mIrisCaptureCheck.Checked AndAlso Not mIrisInitializeCheck.Checked) Then
            GoButton.Enabled = False
        Else
            'if all the check boxes are disable, therefore user have selected AlwaysOkay Scenario
            'Clear all the check mark for all the boxes.
            If Not FaceCheckBoxEnabled Then
                mFaceCaptureCheck.CheckState = CheckState.Unchecked
                mFaceInitializeCheck.CheckState = CheckState.Unchecked
                mFaceDownloadCheck.CheckState = CheckState.Unchecked
            Else
                If Not mFaceCaptureCheck.Enabled Then mFaceCaptureCheck.CheckState = CheckState.Unchecked
            End If
            If Not FingerCheckBoxEnabled Then
                mFingerCaptureCheck.CheckState = CheckState.Unchecked
                mFingerInitializeCheck.CheckState = CheckState.Unchecked
            End If
            If Not IrisCheckBoxEnabled Then
                mIrisCaptureCheck.CheckState = CheckState.Unchecked
                mIrisCaptureCheck.CheckState = CheckState.Unchecked
            End If
            GoButton.Enabled = True
        End If
    End Sub
    Private Sub mFaceInitializeCheckBoxChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mFaceInitializeCheck.CheckedChanged
        If mFaceInitializeCheck.Checked Then
            mFaceCaptureCheck.Checked = False
            mFaceDownloadCheck.Checked = False
        End If
        If FaceScenario.Count = 1 Then FaceScenario.Insert(1, ProcessType.Initialize)
        FaceScenario(1) = ProcessType.Initialize
        Refresh()
    End Sub

    Private Sub mFaceCaptureCheckChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mFaceCaptureCheck.CheckedChanged
        If mFaceCaptureCheck.Checked Then
            mFaceInitializeCheck.Checked = False
            mFaceDownloadCheck.Checked = False
        End If
        If FaceScenario.Count = 1 Then FaceScenario.Insert(1, ProcessType.Capture)
        FaceScenario(1) = ProcessType.Capture
        Refresh()
    End Sub
    Private Sub mFaceDownloadCheckChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mFaceDownloadCheck.CheckedChanged
        If mFaceDownloadCheck.Checked Then
            mFaceInitializeCheck.Checked = False
            mFaceCaptureCheck.Checked = False
        End If
        If FaceScenario.Count = 1 Then FaceScenario.Insert(1, ProcessType.Download)
        FaceScenario(1) = ProcessType.Download
        Refresh()
    End Sub

    Private Sub mFingerInitializeCheckBoxChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mFingerInitializeCheck.CheckedChanged
        If mFingerInitializeCheck.Checked Then mFingerCaptureCheck.Checked = False
        If FingerScenario.Count = 1 Then FingerScenario.Insert(1, ProcessType.Initialize)
        FingerScenario(1) = ProcessType.Initialize
        Refresh()
    End Sub

    Private Sub mFingerCaptureCheckChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mFingerCaptureCheck.CheckedChanged
        If mFingerCaptureCheck.Checked Then mFingerInitializeCheck.Checked = False
        If FingerScenario.Count = 1 Then FingerScenario.Insert(1, ProcessType.Capture)
        FingerScenario(1) = ProcessType.Capture
        Refresh()
    End Sub

    Private Sub mIrisInitializeCheckBoxChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mIrisInitializeCheck.CheckedChanged
        If mIrisCaptureCheck.Checked Then mIrisInitializeCheck.Checked = False
        If IrisScenario.Count = 1 Then IrisScenario.Insert(1, ProcessType.Initialize)
        IrisScenario(1) = ProcessType.Initialize
        Refresh()
    End Sub

    Private Sub mCaptureCheckBoxChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mIrisCaptureCheck.CheckedChanged
        If mIrisInitializeCheck.Checked Then mIrisCaptureCheck.Checked = False
        If IrisScenario.Count = 1 Then IrisScenario.Insert(1, ProcessType.Capture)
        IrisScenario(1) = ProcessType.Capture
        Refresh()
    End Sub

    Private Enum SensorType
        Face
        Fingerprint
        Iris
    End Enum
    Public Enum ProbabilityType
        Okay
        CaptureTimeout
        CaptureFailure
        InitTimeout
        InitFailure
        DownloadTimeout
        DownloadFailure
    End Enum
    Public Enum ProcessType
        Initialize
        Capture
        Download
    End Enum
    Private FaceCheckBoxEnabled As Boolean
    Private FingerCheckBoxEnabled As Boolean
    Private IrisCheckBoxEnabled As Boolean

    Public FaceScenario As ArrayList
    Public FingerScenario As ArrayList
    Public IrisScenario As ArrayList
End Class
