Option Strict On

Imports System.Reflection
Imports System.Xml.Serialization
Imports System.IO

Imports Mbark
Imports Mbark.Sensors
Imports Mbark.Threading

Public Class StandaloneSensorController
    Inherits Mbark.Sensors.BaseSensorController

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        UserNew()
    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        CType(Me.SensorPanel, System.ComponentModel.ISupportInitialize).BeginInit()
        '
        'TaskListControl
        '
        Me.TaskListControl.Name = "TaskListControl"
        '
        'ConditionsControl
        '
        Me.ConditionsControl.Name = "ConditionsControl"
        '
        'AttemptPicker
        '
        Me.AttemptPicker.Name = "AttemptPicker"
        '
        'SensorStatusControl
        '
        Me.SensorStatusControl.Name = "SensorStatusControl"
        '
        'InaccessibleBodyPartsControl
        '
        Me.InaccessibleBodyPartsControl.Name = "InaccessibleBodyPartsControl"
        '
        'SensorPanel
        '
        Me.SensorPanel.Name = "SensorPanel"
        '
        'ButtonsPanel
        '
        Me.ButtonsPanel.Name = "ButtonsPanel"
        '
        'StandaloneSensorController
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(4, 11)
        Me.ClientSize = New System.Drawing.Size(1024, 734)
        Me.Location = New System.Drawing.Point(0, 0)
        Me.Name = "StandaloneSensorController"
        Me.Text = "Session"
        CType(Me.SensorPanel, System.ComponentModel.ISupportInitialize).EndInit()

    End Sub

#End Region

    Private FaceFolderPath As String = "C:\tmp\Images\Face"
    Private FingerprintsFolderPath As String = "C:\tmp\Images\Fingerprints\"
    Private IrisFolderPath As String = "C:\tmp\Images\Iris\"

    Private Sub UserNew()

        Try

            'when start up check if the image directories exist, if not exist create folder
            If Not Directory.Exists(FaceFolderPath) Then Directory.CreateDirectory(FaceFolderPath)
            If Not Directory.Exists(FingerprintsFolderPath) Then Directory.CreateDirectory(FingerprintsFolderPath)
            If Not Directory.Exists(IrisFolderPath) Then Directory.CreateDirectory(IrisFolderPath)

        Catch ex As Exception
            Debugger.Break()
        End Try



    End Sub

    Protected Overrides Sub OnLoad(ByVal e As EventArgs)
        MyBase.OnLoad(e)


    End Sub

    Protected Overrides Sub OnCaptureCommandComplete(ByVal e As CommandCompleteEventArgs)

        If e.Command.TargetReturnValue Is Nothing Then Exit Sub

        If Not e.Command.TargetException Is Nothing Then
            Return
        End If

        If IsDemo Then
            SaveCapturedImage(e.Command)
        End If

    End Sub

    Private Sub SaveCapturedImage(ByVal command As AsyncCommand)


        Dim CollectionObj As CaptureResultCollection = CType(command.TargetReturnValue, CaptureResultCollection)
        If CollectionObj.Results Is Nothing Then Exit Sub

        Dim CaptureResultObj As CaptureResult = CType(CollectionObj.Results(CollectionObj.Results.Count - 1), CaptureResult)
        Dim ResultImage As Bitmap = CType(CaptureResultObj.ImageProperties.Image, Bitmap)

        Select Case CaptureResultObj.SensorProperties.Modality
            Case SensorModality.Fingerprint
                ResultImage.Save(FingerprintsFolderPath & command.CommandId.ToString & ".bmp")
            Case SensorModality.Iris
                If CollectionObj.Results.Count = 1 Then
                    ResultImage.Save(IrisFolderPath & command.CommandId.ToString & ".bmp")
                Else
                    OKICaptureResult(command)
                End If


        End Select

    End Sub

    Private Sub OKICaptureResult(ByVal command As AsyncCommand)

        Dim CollectionObj As CaptureResultCollection = CType(command.TargetReturnValue, CaptureResultCollection)
        Dim img As Image
        For c As Integer = 0 To CollectionObj.Results.Count - 1
            img = CollectionObj.Results(c).ImageProperties.Image
            img.Save(IrisFolderPath & command.CommandId.ToString & "_" & c & ".bmp")
        Next

    End Sub

    Protected Overrides Sub OnDownloadCommandComplete(ByVal e As CommandCompleteEventArgs)
        Dim savedObj As Object
        With e.Command
            If .TargetException Is Nothing Then
                If Not .TargetReturnValue Is Nothing Then
                    ' for demo purpose only
                    If IsDemo Then
                        SaveFaceImageToFile(e)
                    End If
                End If
            End If
        End With
    End Sub
    Private Sub SaveFaceImageToFile(ByVal e As CommandCompleteEventArgs)
        With e.Command
            Dim ReturnValue As CaptureResultCollection = CType(.TargetReturnValue, CaptureResultCollection)
            If ReturnValue.Results.Count = 0 Then Exit Sub
            Try
                Dim Img As Image
                For c As Integer = 0 To ReturnValue.Results.Count - 1
                    With ReturnValue.Results(c)
                        Img = .ImageProperties.Image
                        Img.RotateFlip(RotateFlipType.Rotate90FlipNone)
                    End With

                    Img.Save(FaceFolderPath & .CommandId.ToString & "_" & c & ".bmp")
                Next
            Catch ex As Exception
            End Try
        End With

    End Sub


End Class
