'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports Mbark.UI

Imports System.Drawing
Imports System.Globalization
Imports System.Windows.Forms

Imports Mbark.SensorMessages
Imports Mbark.UI.GlobalUISettings


Namespace Mbark.Sensors

    Public Class AttemptPictureBox
        Inherits UserControl
        Implements IAutosizable
        Implements IHasUICulture

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call
            UserNew()
        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents OuterPanel As Syncfusion.Windows.Forms.Tools.GradientPanel
        Friend WithEvents CaptionLabel As System.Windows.Forms.Label
        Friend WithEvents SmoothPictureBox As Mbark.UI.SmoothPictureBox
        Friend WithEvents EditButton As System.Windows.Forms.Button
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(AttemptPictureBox))
            Me.OuterPanel = New Syncfusion.Windows.Forms.Tools.GradientPanel
            Me.CaptionLabel = New System.Windows.Forms.Label
            Me.EditButton = New System.Windows.Forms.Button
            Me.SmoothPictureBox = New Mbark.UI.SmoothPictureBox
            CType(Me.OuterPanel, System.ComponentModel.ISupportInitialize).BeginInit()
            Me.OuterPanel.SuspendLayout()
            Me.SuspendLayout()
            '
            'OuterPanel
            '
            Me.OuterPanel.AccessibleDescription = resources.GetString("OuterPanel.AccessibleDescription")
            Me.OuterPanel.AccessibleName = resources.GetString("OuterPanel.AccessibleName")
            Me.OuterPanel.Anchor = CType(resources.GetObject("OuterPanel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.OuterPanel.AutoScroll = CType(resources.GetObject("OuterPanel.AutoScroll"), Boolean)
            Me.OuterPanel.AutoScrollMargin = CType(resources.GetObject("OuterPanel.AutoScrollMargin"), System.Drawing.Size)
            Me.OuterPanel.AutoScrollMinSize = CType(resources.GetObject("OuterPanel.AutoScrollMinSize"), System.Drawing.Size)
            Me.OuterPanel.BackgroundImage = CType(resources.GetObject("OuterPanel.BackgroundImage"), System.Drawing.Image)
            Me.OuterPanel.BorderColor = System.Drawing.Color.Blue
            Me.OuterPanel.BorderStyle = System.Windows.Forms.BorderStyle.None
            Me.OuterPanel.Controls.Add(Me.CaptionLabel)
            Me.OuterPanel.Controls.Add(Me.EditButton)
            Me.OuterPanel.Controls.Add(Me.SmoothPictureBox)
            Me.OuterPanel.Dock = CType(resources.GetObject("OuterPanel.Dock"), System.Windows.Forms.DockStyle)
            Me.OuterPanel.Enabled = CType(resources.GetObject("OuterPanel.Enabled"), Boolean)
            Me.OuterPanel.Font = CType(resources.GetObject("OuterPanel.Font"), System.Drawing.Font)
            Me.OuterPanel.ImeMode = CType(resources.GetObject("OuterPanel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.OuterPanel.Location = CType(resources.GetObject("OuterPanel.Location"), System.Drawing.Point)
            Me.OuterPanel.Name = "OuterPanel"
            Me.OuterPanel.RightToLeft = CType(resources.GetObject("OuterPanel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.OuterPanel.Size = CType(resources.GetObject("OuterPanel.Size"), System.Drawing.Size)
            Me.OuterPanel.TabIndex = CType(resources.GetObject("OuterPanel.TabIndex"), Integer)
            Me.OuterPanel.Text = resources.GetString("OuterPanel.Text")
            Me.OuterPanel.Visible = CType(resources.GetObject("OuterPanel.Visible"), Boolean)
            '
            'CaptionLabel
            '
            Me.CaptionLabel.AccessibleDescription = resources.GetString("CaptionLabel.AccessibleDescription")
            Me.CaptionLabel.AccessibleName = resources.GetString("CaptionLabel.AccessibleName")
            Me.CaptionLabel.Anchor = CType(resources.GetObject("CaptionLabel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.CaptionLabel.AutoSize = CType(resources.GetObject("CaptionLabel.AutoSize"), Boolean)
            Me.CaptionLabel.Dock = CType(resources.GetObject("CaptionLabel.Dock"), System.Windows.Forms.DockStyle)
            Me.CaptionLabel.Enabled = CType(resources.GetObject("CaptionLabel.Enabled"), Boolean)
            Me.CaptionLabel.Font = CType(resources.GetObject("CaptionLabel.Font"), System.Drawing.Font)
            Me.CaptionLabel.Image = CType(resources.GetObject("CaptionLabel.Image"), System.Drawing.Image)
            Me.CaptionLabel.ImageAlign = CType(resources.GetObject("CaptionLabel.ImageAlign"), System.Drawing.ContentAlignment)
            Me.CaptionLabel.ImageIndex = CType(resources.GetObject("CaptionLabel.ImageIndex"), Integer)
            Me.CaptionLabel.ImeMode = CType(resources.GetObject("CaptionLabel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.CaptionLabel.Location = CType(resources.GetObject("CaptionLabel.Location"), System.Drawing.Point)
            Me.CaptionLabel.Name = "CaptionLabel"
            Me.CaptionLabel.RightToLeft = CType(resources.GetObject("CaptionLabel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.CaptionLabel.Size = CType(resources.GetObject("CaptionLabel.Size"), System.Drawing.Size)
            Me.CaptionLabel.TabIndex = CType(resources.GetObject("CaptionLabel.TabIndex"), Integer)
            Me.CaptionLabel.Text = resources.GetString("CaptionLabel.Text")
            Me.CaptionLabel.TextAlign = CType(resources.GetObject("CaptionLabel.TextAlign"), System.Drawing.ContentAlignment)
            Me.CaptionLabel.Visible = CType(resources.GetObject("CaptionLabel.Visible"), Boolean)
            '
            'EditButton
            '
            Me.EditButton.AccessibleDescription = resources.GetString("EditButton.AccessibleDescription")
            Me.EditButton.AccessibleName = resources.GetString("EditButton.AccessibleName")
            Me.EditButton.Anchor = CType(resources.GetObject("EditButton.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.EditButton.BackgroundImage = CType(resources.GetObject("EditButton.BackgroundImage"), System.Drawing.Image)
            Me.EditButton.Dock = CType(resources.GetObject("EditButton.Dock"), System.Windows.Forms.DockStyle)
            Me.EditButton.Enabled = CType(resources.GetObject("EditButton.Enabled"), Boolean)
            Me.EditButton.FlatStyle = CType(resources.GetObject("EditButton.FlatStyle"), System.Windows.Forms.FlatStyle)
            Me.EditButton.Font = CType(resources.GetObject("EditButton.Font"), System.Drawing.Font)
            Me.EditButton.Image = CType(resources.GetObject("EditButton.Image"), System.Drawing.Image)
            Me.EditButton.ImageAlign = CType(resources.GetObject("EditButton.ImageAlign"), System.Drawing.ContentAlignment)
            Me.EditButton.ImageIndex = CType(resources.GetObject("EditButton.ImageIndex"), Integer)
            Me.EditButton.ImeMode = CType(resources.GetObject("EditButton.ImeMode"), System.Windows.Forms.ImeMode)
            Me.EditButton.Location = CType(resources.GetObject("EditButton.Location"), System.Drawing.Point)
            Me.EditButton.Name = "EditButton"
            Me.EditButton.RightToLeft = CType(resources.GetObject("EditButton.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.EditButton.Size = CType(resources.GetObject("EditButton.Size"), System.Drawing.Size)
            Me.EditButton.TabIndex = CType(resources.GetObject("EditButton.TabIndex"), Integer)
            Me.EditButton.Text = resources.GetString("EditButton.Text")
            Me.EditButton.TextAlign = CType(resources.GetObject("EditButton.TextAlign"), System.Drawing.ContentAlignment)
            Me.EditButton.Visible = CType(resources.GetObject("EditButton.Visible"), Boolean)
            '
            'SmoothPictureBox
            '
            Me.SmoothPictureBox.AccessibleDescription = resources.GetString("SmoothPictureBox.AccessibleDescription")
            Me.SmoothPictureBox.AccessibleName = resources.GetString("SmoothPictureBox.AccessibleName")
            Me.SmoothPictureBox.Alignment = Mbark.UI.SmoothPictureBoxAlignment.Center
            Me.SmoothPictureBox.Anchor = CType(resources.GetObject("SmoothPictureBox.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.SmoothPictureBox.AutoScroll = CType(resources.GetObject("SmoothPictureBox.AutoScroll"), Boolean)
            Me.SmoothPictureBox.AutoScrollMargin = CType(resources.GetObject("SmoothPictureBox.AutoScrollMargin"), System.Drawing.Size)
            Me.SmoothPictureBox.AutoScrollMinSize = CType(resources.GetObject("SmoothPictureBox.AutoScrollMinSize"), System.Drawing.Size)
            Me.SmoothPictureBox.BackgroundImage = CType(resources.GetObject("SmoothPictureBox.BackgroundImage"), System.Drawing.Image)
            Me.SmoothPictureBox.Backwards = False
            Me.SmoothPictureBox.BorderColor = System.Drawing.Color.Black
            Me.SmoothPictureBox.BorderThickness = 1
            Me.SmoothPictureBox.DisabledImage = Nothing
            Me.SmoothPictureBox.Dock = CType(resources.GetObject("SmoothPictureBox.Dock"), System.Windows.Forms.DockStyle)
            Me.SmoothPictureBox.Enabled = CType(resources.GetObject("SmoothPictureBox.Enabled"), Boolean)
            Me.SmoothPictureBox.EnabledImage = Nothing
            Me.SmoothPictureBox.Font = CType(resources.GetObject("SmoothPictureBox.Font"), System.Drawing.Font)
            Me.SmoothPictureBox.ImeMode = CType(resources.GetObject("SmoothPictureBox.ImeMode"), System.Windows.Forms.ImeMode)
            Me.SmoothPictureBox.Location = CType(resources.GetObject("SmoothPictureBox.Location"), System.Drawing.Point)
            Me.SmoothPictureBox.Name = "SmoothPictureBox"
            Me.SmoothPictureBox.OverlayColor = System.Drawing.Color.Black
            Me.SmoothPictureBox.OverlayFont = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
            Me.SmoothPictureBox.OverlayText = Nothing
            Me.SmoothPictureBox.RightToLeft = CType(resources.GetObject("SmoothPictureBox.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.SmoothPictureBox.Size = CType(resources.GetObject("SmoothPictureBox.Size"), System.Drawing.Size)
            Me.SmoothPictureBox.TabIndex = CType(resources.GetObject("SmoothPictureBox.TabIndex"), Integer)
            Me.SmoothPictureBox.Visible = CType(resources.GetObject("SmoothPictureBox.Visible"), Boolean)
            Me.SmoothPictureBox.WithBorder = False
            '
            'AttemptPictureBox
            '
            Me.AccessibleDescription = resources.GetString("$this.AccessibleDescription")
            Me.AccessibleName = resources.GetString("$this.AccessibleName")
            Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
            Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
            Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
            Me.BackColor = System.Drawing.SystemColors.Control
            Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
            Me.Controls.Add(Me.OuterPanel)
            Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
            Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
            Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
            Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
            Me.Name = "AttemptPictureBox"
            Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.Size = CType(resources.GetObject("$this.Size"), System.Drawing.Size)
            CType(Me.OuterPanel, System.ComponentModel.ISupportInitialize).EndInit()
            Me.OuterPanel.ResumeLayout(False)
            Me.ResumeLayout(False)

        End Sub

#End Region

        Private mUICulture As CultureInfo = CultureInfo.CurrentUICulture
        Public Property UICulture() As CultureInfo Implements IHasUICulture.UICulture
            Get
                Return mUICulture
            End Get
            Set(ByVal Value As CultureInfo)
                mUICulture = Value
            End Set
        End Property

        Private Sub UserNew()
            'SetStyle(Mbark.UI.DoubleBufferStyle, True)
            SmoothPictureBox.WithBorder = True
        End Sub

        Private mAttemptWire As SensorTaskAttempt
        Public Sub WireAttempt(ByVal attempt As SensorTaskAttempt)
            If attempt Is Nothing Then Throw New ArgumentNullException("attempt")
            mAttemptWire = attempt
            SmoothPictureBox.EnabledImage = New Bitmap(attempt.ThumbnailImage)
        End Sub

        Public Sub RefreshLabel(ByVal conditions As ConditionCollection, ByVal parts As BodyParts)


            If mAttemptWire.InConflict(conditions, parts) Then

                CaptionLabel.Text = Messages.Conflict(UICulture) & vbNewLine
                CaptionLabel.Font = Defaults.Fonts.Bold

            ElseIf mAttemptWire.HadCaptureFailure Then

                CaptionLabel.Text = Messages.CaptureFailure(UICulture)
                CaptionLabel.Font = Defaults.Fonts.Regular

            ElseIf mAttemptWire.HasCorruptImage Then

                CaptionLabel.Text = Messages.Corrupt(UICulture)
                CaptionLabel.Font = Defaults.Fonts.Regular

            ElseIf mAttemptWire.HadDownloadFailure Then

                CaptionLabel.Text = Messages.DownloadFailure(UICulture)
                CaptionLabel.Font = Defaults.Fonts.Regular

            ElseIf mAttemptWire.IsRejected Then

                CaptionLabel.Text = Messages.Rejected(UICulture)
                CaptionLabel.Font = Defaults.Fonts.Regular

            ElseIf mAttemptWire.HasDownloadStage Then

                If mAttemptWire.DownloadSuccessful Then
                    CaptionLabel.Text = Messages.DownloadComplete(UICulture)
                ElseIf mAttemptWire.HadDownloadFailure Then
                    CaptionLabel.Text = Messages.DownloadFailed(UICulture)
                ElseIf mAttemptWire.NeedsDownload Then
                    CaptionLabel.Text = Messages.AwaitingDownload(UICulture)
                End If
                CaptionLabel.Font = Defaults.Fonts.Regular

            Else

                CaptionLabel.Text = Messages.Success(UICulture)
                CaptionLabel.Font = Defaults.Fonts.Regular

            End If

            CaptionLabel.Refresh()

        End Sub

        Public Overrides Sub Refresh()
            MyBase.Refresh()
            SmoothPictureBox.Refresh()

            If mAttemptWire Is Nothing Then Return

            RecursiveSuspendLayout(Me)
            ' Don't allow attempt of busy sensors to be edited
            Dim busy As Boolean
            If mAttemptWire.ParentTask.Sensor.LatestStatus = SensorStatus.Capturing OrElse _
                mAttemptWire.ParentTask.Sensor.LatestStatus = SensorStatus.Initializing OrElse _
                mAttemptWire.ParentTask.Sensor.LatestStatus = SensorStatus.Downloading Then
                busy = True
            End If
            EditButton.Visible = Not busy
            EditButton.Enabled = Not busy
            EditButton.Refresh()
            RecursiveResumeLayout(Me)

        End Sub


        Public Sub ClearPicture()
            SmoothPictureBox.EnabledImage = Nothing
        End Sub


        Public Property WithEditButton() As Boolean
            Get
                Return EditButton.Visible
            End Get
            Set(ByVal value As Boolean)
                EditButton.Visible = value
            End Set
        End Property

        Protected Overrides Sub OnLayout(ByVal levent As LayoutEventArgs)
            MyBase.OnLayout(levent)
            If Not NearestForm Is Nothing Then RefreshAutomaticLayout(NearestForm.CreateGraphics)
        End Sub

        Private Sub EditButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles EditButton.Click
            RaiseEvent EditRequested(Me, New EditRequestedEventArgs(mAttemptWire))
        End Sub

        Public Event EditRequested(ByVal sender As Object, ByVal e As EditRequestedEventArgs)

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)
        End Sub

        Public Sub RefreshAutomaticLayout(ByVal graphics As System.Drawing.Graphics) Implements UI.IAutosizable.RefreshAutomaticLayout

            If SmoothPictureBox.EnabledImage Is Nothing Then Return

            SmoothPictureBox.Location = New Point(0, 0)
            SmoothPictureBox.Width = Width - DockPadding.Left - DockPadding.Right
            SmoothPictureBox.Height = Height - DockPadding.Top - DockPadding.Bottom - CInt(CaptionLabel.Height * 1.5)

            Dim imageLowerLeft As New Point(0, SmoothPictureBox.EnabledImage.Height)
            Dim capLoc As New Point(0, SmoothPictureBox.RemapImagePoint(imageLowerLeft).Y + 1)
            CaptionLabel.Location = capLoc

            EditButton.Font = Mbark.UI.GlobalUISettings.Defaults.Fonts.Small
            UI.AutoSize.ToText(graphics, EditButton, 1.5, 1.2)
            Dim editButtonLoc As Point = SmoothPictureBox.RemapImagePoint(New Point(0, 0))
            editButtonLoc.X += 2
            editButtonLoc.Y += 2
            EditButton.Location = editButtonLoc
            EditButton.BringToFront()

            ' Font, size, and place the label
            CaptionLabel.Width = Width - DockPadding.Left - DockPadding.Right
            AutoHeight.Label(graphics, CaptionLabel)
            Refresh()

        End Sub

        Public ReadOnly Property MinimumHeight() As Integer Implements UI.IAutosizable.MinimumHeight
            Get

            End Get
        End Property

        Public ReadOnly Property MinimumWidth() As Integer Implements UI.IAutosizable.MinimumWidth
            Get

            End Get
        End Property

        Public ReadOnly Property NearestForm() As System.Windows.Forms.Form Implements UI.IAutosizable.NearestForm
            Get
                Return FindNearestForm(Me)
            End Get
        End Property

        Public ReadOnly Property GetEditButton() As Control
            Get
                Return EditButton
            End Get
        End Property

    End Class

    Public Class EditRequestedEventArgs
        Inherits EventArgs
        Private mAttempt As SensorTaskAttempt
        Public ReadOnly Property Attempt() As SensorTaskAttempt
            Get
                Return mAttempt
            End Get
        End Property
        Public Sub New(ByVal attempt As SensorTaskAttempt)
            mAttempt = attempt
        End Sub
    End Class

End Namespace