Option Strict On

Imports System.Windows.Forms
Imports System.Drawing
Imports System.Globalization
Imports System.ComponentModel

Imports Mbark.UI.GlobalUISettings

Namespace Mbark.UI

    Public Class RadioGroupBox
        Inherits System.Windows.Forms.UserControl
        Implements IAutosizable
        Implements IHasUICulture

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call
            usernew()
        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Private WithEvents OuterPanel As Syncfusion.Windows.Forms.Tools.GradientPanel
        Friend WithEvents MainGroupBox As System.Windows.Forms.GroupBox
        Friend WithEvents FancyHeaderLabel As Syncfusion.Windows.Forms.Tools.GradientLabel
        Public WithEvents InnerPanel As System.Windows.Forms.Panel
        Protected Friend WithEvents GroupRadioButton As System.Windows.Forms.RadioButton
        Friend WithEvents GroupBoxLabel As System.Windows.Forms.Label
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Me.OuterPanel = New Syncfusion.Windows.Forms.Tools.GradientPanel
            Me.MainGroupBox = New System.Windows.Forms.GroupBox
            Me.GroupBoxLabel = New System.Windows.Forms.Label
            Me.GroupRadioButton = New System.Windows.Forms.RadioButton
            Me.InnerPanel = New System.Windows.Forms.Panel
            Me.FancyHeaderLabel = New Syncfusion.Windows.Forms.Tools.GradientLabel
            CType(Me.OuterPanel, System.ComponentModel.ISupportInitialize).BeginInit()
            Me.OuterPanel.SuspendLayout()
            Me.MainGroupBox.SuspendLayout()
            Me.SuspendLayout()
            '
            'OuterPanel
            '
            Me.OuterPanel.BorderColor = System.Drawing.Color.Black
            Me.OuterPanel.BorderStyle = System.Windows.Forms.BorderStyle.None
            Me.OuterPanel.Controls.Add(Me.MainGroupBox)
            Me.OuterPanel.Controls.Add(Me.FancyHeaderLabel)
            Me.OuterPanel.Dock = System.Windows.Forms.DockStyle.Fill
            Me.OuterPanel.Location = New System.Drawing.Point(0, 0)
            Me.OuterPanel.Name = "OuterPanel"
            Me.OuterPanel.Size = New System.Drawing.Size(192, 120)
            Me.OuterPanel.TabIndex = 0
            '
            'MainGroupBox
            '
            Me.MainGroupBox.Controls.Add(Me.GroupBoxLabel)
            Me.MainGroupBox.Controls.Add(Me.GroupRadioButton)
            Me.MainGroupBox.Controls.Add(Me.InnerPanel)
            Me.MainGroupBox.Dock = System.Windows.Forms.DockStyle.Fill
            Me.MainGroupBox.FlatStyle = System.Windows.Forms.FlatStyle.System
            Me.MainGroupBox.ForeColor = System.Drawing.SystemColors.ControlText
            Me.MainGroupBox.Location = New System.Drawing.Point(0, 16)
            Me.MainGroupBox.Name = "MainGroupBox"
            Me.MainGroupBox.Size = New System.Drawing.Size(192, 104)
            Me.MainGroupBox.TabIndex = 2
            Me.MainGroupBox.TabStop = False
            '
            'GroupBoxLabel
            '
            Me.GroupBoxLabel.ForeColor = System.Drawing.SystemColors.HotTrack
            Me.GroupBoxLabel.Location = New System.Drawing.Point(80, 0)
            Me.GroupBoxLabel.Name = "GroupBoxLabel"
            Me.GroupBoxLabel.Size = New System.Drawing.Size(0, 0)
            Me.GroupBoxLabel.TabIndex = 9
            Me.GroupBoxLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
            '
            'GroupRadioButton
            '
            Me.GroupRadioButton.BackColor = System.Drawing.SystemColors.Control
            Me.GroupRadioButton.FlatStyle = System.Windows.Forms.FlatStyle.System
            Me.GroupRadioButton.Font = New System.Drawing.Font("Verdana", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
            Me.GroupRadioButton.ForeColor = System.Drawing.SystemColors.HotTrack
            Me.GroupRadioButton.Location = New System.Drawing.Point(40, 0)
            Me.GroupRadioButton.Name = "GroupRadioButton"
            Me.GroupRadioButton.Size = New System.Drawing.Size(16, 24)
            Me.GroupRadioButton.TabIndex = 11
            '
            'InnerPanel
            '
            Me.InnerPanel.Dock = System.Windows.Forms.DockStyle.Fill
            Me.InnerPanel.Location = New System.Drawing.Point(3, 16)
            Me.InnerPanel.Name = "InnerPanel"
            Me.InnerPanel.Size = New System.Drawing.Size(186, 85)
            Me.InnerPanel.TabIndex = 4
            '
            'FancyHeaderLabel
            '
            Me.FancyHeaderLabel.BackgroundColor = New Syncfusion.Drawing.BrushInfo(Syncfusion.Drawing.GradientStyle.ForwardDiagonal, System.Drawing.SystemColors.ActiveCaption, System.Drawing.SystemColors.InactiveCaption)
            Me.FancyHeaderLabel.BorderSides = CType((((System.Windows.Forms.Border3DSide.Left Or System.Windows.Forms.Border3DSide.Top) _
                        Or System.Windows.Forms.Border3DSide.Right) _
                        Or System.Windows.Forms.Border3DSide.Bottom), System.Windows.Forms.Border3DSide)
            Me.FancyHeaderLabel.BorderStyle = System.Windows.Forms.Border3DStyle.Adjust
            Me.FancyHeaderLabel.Dock = System.Windows.Forms.DockStyle.Top
            Me.FancyHeaderLabel.ForeColor = System.Drawing.SystemColors.HighlightText
            Me.FancyHeaderLabel.Location = New System.Drawing.Point(0, 0)
            Me.FancyHeaderLabel.Name = "FancyHeaderLabel"
            Me.FancyHeaderLabel.Size = New System.Drawing.Size(192, 16)
            Me.FancyHeaderLabel.TabIndex = 0
            Me.FancyHeaderLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
            Me.FancyHeaderLabel.Visible = False
            '
            'RadioGroupBox
            '
            Me.Controls.Add(Me.OuterPanel)
            Me.Name = "RadioGroupBox"
            Me.Size = New System.Drawing.Size(192, 120)
            CType(Me.OuterPanel, System.ComponentModel.ISupportInitialize).EndInit()
            Me.OuterPanel.ResumeLayout(False)
            Me.MainGroupBox.ResumeLayout(False)
            Me.ResumeLayout(False)

        End Sub

#End Region

        Private mUICulture As CultureInfo = CultureInfo.CurrentUICulture
        Public Property UICulture() As CultureInfo Implements IHasUICulture.UICulture
            Get
                Return mUICulture
            End Get
            Set(ByVal Value As CultureInfo)
                mUICulture = Value
            End Set
        End Property


        Private Sub UserNew()
            SetStyle(Windows.Forms.ControlStyles.SupportsTransparentBackColor, True)
            AddHandler GroupRadioButton.CheckedChanged, AddressOf RelayCheckBoxChanged
        End Sub

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)
            If Not NearestForm Is Nothing Then
                Dim g As Graphics = NearestForm.CreateGraphics()
                RefreshAutomaticLayout(g)
                g.Dispose()
            End If
            MainGroupBox.Font = Defaults.Fonts.GroupBox
        End Sub


        Public ReadOnly Property OuterPanelDockPadding() As DockPaddingEdges
            Get
                Return OuterPanel.DockPadding
            End Get
        End Property

        Private mWithRadioButton As Boolean
        Public Overridable Property WithRadioButton() As Boolean
            Get
                Return mWithRadioButton
            End Get
            Set(ByVal value As Boolean)
                mWithRadioButton = value
                Refresh()
            End Set
        End Property

        <Browsable(False)> Public Property RadioButtonSelected() As Boolean
            Get
                Return GroupRadioButton.Checked
            End Get
            Set(ByVal value As Boolean)
                GroupRadioButton.Checked = value
            End Set
        End Property

        Private mHeaderText As String
        Public Property HeaderText() As String
            Get
                Return mHeaderText
            End Get
            Set(ByVal value As String)
                mHeaderText = value
                If WithFancyHeader Then

                    FancyHeaderLabel.Text = mHeaderText
                Else
                    MainGroupBox.Text = mHeaderText
                End If
                If Not NearestForm Is Nothing Then
                    Dim g As Graphics = NearestForm.CreateGraphics
                    RefreshAutomaticLayout(g)
                    g.Dispose()
                End If
            End Set
        End Property

        Private mHeaderTextColor As Color = Mbark.UI.ThemeInterop.GroupBoxForeColor()
        Public Property HeaderTextColor() As Color
            Get
                Return mHeaderTextColor
            End Get
            Set(ByVal value As Color)
                mHeaderTextColor = value
                If WithFancyHeader Then
                    FancyHeaderLabel.ForeColor = value
                Else
                    MainGroupBox.ForeColor = value
                End If
            End Set
        End Property

        Public Overrides Sub Refresh()
            MyBase.Refresh()
            GroupRadioButton.Visible = mWithRadioButton
            'If Not NearestForm Is Nothing Then RefreshAutomaticLayout(NearestForm.CreateGraphics)
        End Sub


        Private mRadioButtonIndentation As Integer = 8
        <Browsable(False)> Public Property RadioButtonIndentation() As Integer
            Get
                Return mRadioButtonIndentation
            End Get
            Set(ByVal value As Integer)
                mRadioButtonIndentation = value
            End Set
        End Property

        Public Overridable Sub RefreshAutomaticLayout(ByVal graphics As System.Drawing.Graphics) Implements UI.IAutosizable.RefreshAutomaticLayout

            If graphics Is Nothing Then Return

            SuspendLayout()

            ' Size and place the radio button
            Dim rbLocX As Integer = DockPadding.Left + RadioButtonIndentation
            Dim rbLocY As Integer = DockPadding.Top

            GroupRadioButton.Location = New Point(rbLocX, rbLocY)
            GroupRadioButton.Font = Defaults.Fonts.Regular
            GroupRadioButton.Text = InfrastructureMessages.Messages.HiddenGroupRadioButtonText(UICulture)
            GroupRadioButton.ForeColor = SystemColors.Control
            GroupRadioButton.Size = GlobalUISettings.ControlSizes.RadioButtonSize

            FancyHeaderLabel.Font = Defaults.Fonts.FancyLabel
            AutoHeight.FancyLabel(graphics, FancyHeaderLabel)

            GroupBoxLabel.Visible = GroupBoxLabel.Text.Trim <> String.Empty
            GroupBoxLabel.Font = Defaults.Fonts.GroupBox
            GroupBoxLabel.Location = UpperRight(GroupRadioButton)
            GroupBoxLabel.Text = mHeaderText
            UI.AutoSize.Label(graphics, GroupBoxLabel)




            If mWithRadioButton Then

                MainGroupBox.Text = String.Empty

                GroupRadioButton.Visible = True
                GroupRadioButton.Size = ControlSizes.RadioButtonSize


                ' Extend the top padding if needed
                'Dim groupBoxHeaderHeight As Integer = Height - InnerPanel.Height
                'OuterPanel.DockPadding.Top = Math.Max(0, groupBoxHeaderHeight - GroupBoxLabel.Height)

            Else
                GroupRadioButton.Size = New Size(0, 0)
                GroupRadioButton.Visible = False
                MainGroupBox.Text = mHeaderText
                GroupRadioButton.Text = String.Empty
                GroupBoxLabel.Text = String.Empty
            End If



            MainGroupBox.Font = GlobalUISettings.Defaults.Fonts.GroupBox

            Mbark.UI.AutoSize.ToText(graphics, GroupBoxLabel, 1.05, 0.9)

            mMinimumWidth = Width - InnerPanel.Width + GroupRadioButton.Width + GroupBoxLabel.Width

            AutoHeight.Control(UICulture, graphics, GroupRadioButton)

            ResumeLayout()

        End Sub

        Public Overridable ReadOnly Property MinimumHeight() As Integer Implements UI.IAutosizable.MinimumHeight
            Get
                Return GroupBoxLabel.Height
            End Get
        End Property

        Public ReadOnly Property InnerPanelLocation() As Point
            Get
                Dim x As Integer = InnerPanel.Location.X + OuterPanel.Location.X
                Dim y As Integer = InnerPanel.Location.Y + OuterPanel.Location.Y
                Return New Point(x, y)
            End Get
        End Property

        Private mMinimumWidth As Integer
        Public Overridable ReadOnly Property MinimumWidth() As Integer Implements UI.IAutosizable.MinimumWidth
            Get
                Return mMinimumWidth
            End Get
        End Property

        Public ReadOnly Property NearestForm() As System.Windows.Forms.Form Implements UI.IAutosizable.NearestForm
            Get
                Return FindNearestForm(Me)
            End Get
        End Property

        Protected Overrides Sub OnLayout(ByVal levent As LayoutEventArgs)
            MyBase.OnLayout(levent)
            If Not NearestForm Is Nothing Then
                Dim g As Graphics = NearestForm.CreateGraphics
                RefreshAutomaticLayout(g)
                g.Dispose()
            End If
        End Sub

        Public Event RadioButtonChanged(ByVal sender As Object, ByVal e As EventArgs)

        Private Sub RelayCheckBoxChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
            SyncLock Me : RaiseEvent RadioButtonChanged(Me, e) : End SyncLock
        End Sub

        Public ReadOnly Property TotalLeftPadding() As Integer
            Get
                Return _
                DockPadding.Left + _
                OuterPanel.DockPadding.Left + _
                InnerPanel.DockPadding.Left + _
                InnerPanel.Location.X
            End Get
        End Property


        Public ReadOnly Property TotalRightPadding() As Integer
            Get
                Return Width - InnerPanel.Width - TotalLeftPadding
            End Get
        End Property

        Public ReadOnly Property TotalTopPadding() As Integer
            Get
                Return _
                    DockPadding.Top + _
                    OuterPanel.DockPadding.Top + _
                    InnerPanel.DockPadding.Top + _
                    InnerPanel.Location.Y
            End Get
        End Property

        Public ReadOnly Property TotalBottomPadding() As Integer
            Get
                Return Height - InnerPanel.Height - TotalTopPadding
            End Get
        End Property

        Public Property RadioGroupBoxChecked() As Boolean
            Get
                Return GroupRadioButton.Checked
            End Get
            Set(ByVal value As Boolean)
                GroupRadioButton.Checked = value
            End Set
        End Property


        Private Sub GroupBoxLabel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GroupBoxLabel.Click
            Me.GroupRadioButton.Checked = True
        End Sub

        Private mWithFancyHeader As Boolean
        Public Property WithFancyHeader() As Boolean
            Get
                Return mWithFancyHeader
            End Get
            Set(ByVal value As Boolean)
                mWithFancyHeader = value
                If mWithFancyHeader Then
                    FancyHeaderLabel.Visible = True
                    FancyHeaderLabel.Text = mHeaderText
                    MainGroupBox.Visible = False
                    If MainGroupBox.Controls.Contains(InnerPanel) Then
                        MainGroupBox.Controls.Remove(InnerPanel)
                        OuterPanel.Controls.Add(InnerPanel)
                        InnerPanel.BringToFront()
                        InnerPanel.Dock = DockStyle.Fill
                        OuterPanel.BorderStyle = BorderStyle.FixedSingle
                        OuterPanel.BorderColor = SystemColors.Highlight
                    End If
                Else
                    FancyHeaderLabel.Visible = False
                    MainGroupBox.Visible = True
                    If OuterPanel.Controls.Contains(InnerPanel) Then
                        OuterPanel.Controls.Remove(InnerPanel)
                        MainGroupBox.Controls.Add(InnerPanel)
                        OuterPanel.BorderStyle = BorderStyle.None
                    End If
                End If
                If Not NearestForm Is Nothing Then
                    Dim g As Graphics = NearestForm.CreateGraphics()
                    RefreshAutomaticLayout(g)
                    g.Dispose()
                End If
            End Set
        End Property

    End Class

End Namespace
