'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 


Imports System.Runtime.Serialization
Imports System.Collections.Specialized
Imports System.Xml.Serialization

Imports Mbark

Namespace Mbark.Sensors

    <XmlType("RuntimePredicateFactory")> _
    Public Class PredicateFactory

        Private mDefinition As New PredicateFactoryDefinition
        Private mUnmetPrequisiteMessage As LocalizableString
        Private mFactoryArgs As Object()

        Public Sub FactoryArgs(ByVal ParamArray args As Object())
            mFactoryArgs = args
        End Sub

        Friend ReadOnly Property GetFactoryArgs(ByVal index As Integer) As Object
            Get
                Return mFactoryArgs(index)
            End Get
        End Property

        Public Property PredicateType() As PredicateType
            Get
                Return mDefinition.PredicateType
            End Get
            Set(ByVal value As PredicateType)
                mDefinition.PredicateType = value
            End Set
        End Property

        Public Function CreatePredicate(ByVal conditions As ConditionCollection) As Predicate

            With mDefinition
                Select Case .PredicateType

                    Case PredicateType.LiteralPredicate
                        Dim value As Boolean = DirectCast(mFactoryArgs(0), Boolean)
                        CreatePredicate = New LiteralPredicate(value)

                    Case PredicateType.CompoundAndPredicate
                        Dim PF1 As PredicateFactory = DirectCast(mFactoryArgs(0), PredicateFactory)
                        Dim PF2 As PredicateFactory = DirectCast(mFactoryArgs(1), PredicateFactory)
                        CreatePredicate = New CompoundAndPredicate(conditions, PF1, PF2)

                    Case PredicateType.CompoundOrPredicate
                        Dim PF1 As PredicateFactory = DirectCast(mFactoryArgs(0), PredicateFactory)
                        Dim PF2 As PredicateFactory = DirectCast(mFactoryArgs(1), PredicateFactory)
                        CreatePredicate = New CompoundOrPredicate(conditions, PF1, PF2)

                    Case PredicateType.CategoryEqualsLiteralPredicate
                        Dim category As SensorTaskCategory = DirectCast(mFactoryArgs(0), SensorTaskCategory)
                        CreatePredicate = New TargetCategoryEqualsLiteralPredicate(conditions, category)

                    Case PredicateType.ConditionEqualsLiteralPredicate
                        Dim name As String = DirectCast(mFactoryArgs(0), String)
                        Dim value As Object = mFactoryArgs(1)
                        CreatePredicate = New ConditionEqualsLiteralPredicate(conditions, name, value)

                    Case PredicateType.CategoryContainedInSetPredicate
                        Dim categories As ArrayList = DirectCast(mFactoryArgs(0), ArrayList)
                        CreatePredicate = New CategoryContainedInSetPredicate(conditions, categories)

                    Case PredicateType.SensorModalityEqualsLiteralPredicate
                        Dim soughtModality As SensorModality = DirectCast(mFactoryArgs(0), SensorModality)
                        CreatePredicate = New SensorModalityEqualsLiteralPredicate(conditions, soughtModality)
                End Select

                Dim names As StringCollection = ExtractParticipatingConditions(Me)
                For i As Integer = 0 To names.Count - 1
                    If Not CreatePredicate.ParticipatingConditionNames.Contains(names(i)) Then
                        CreatePredicate.ParticipatingConditionNames.Add(names(i))
                    End If
                Next
            End With

            CreatePredicate.UnmetPrerequisiteMessage = Me.UnmetPrerequisiteMessage

        End Function

        Public Property UnmetPrerequisiteMessage() As LocalizableString
            Get
                Return mUnmetPrequisiteMessage
            End Get
            Set(ByVal value As LocalizableString)
                mUnmetPrequisiteMessage = value
            End Set
        End Property


        Public Function Definition() As PredicateFactoryDefinition

            If Not UnmetPrerequisiteMessage Is Nothing Then
                mDefinition.UnmetPrerequisiteMessageDefinition = UnmetPrerequisiteMessage.CreateDefinition
            End If

            If mDefinition.FactoryArgDefinitions Is Nothing Then
                mDefinition.FactoryArgDefinitions = New Object() {}
            End If

            ReDim mDefinition.FactoryArgDefinitions(mFactoryArgs.Length - 1)
            For i As Integer = 0 To mFactoryArgs.Length - 1
                If TypeOf mFactoryArgs(i) Is PredicateFactory Then
                    mDefinition.FactoryArgDefinitions(i) = DirectCast(mFactoryArgs(i), PredicateFactory).Definition
                Else
                    mDefinition.FactoryArgDefinitions(i) = mFactoryArgs(i)
                End If
            Next



            Return mDefinition.DeepCopy

        End Function

        Friend Sub BindFromDefinitionToSelf(ByVal definition As PredicateFactoryDefinition)

            mDefinition = definition.DeepCopy

            ' Reconstitute the unmet prereq message if there is one
            If Not definition.UnmetPrerequisiteMessageDefinition Is Nothing Then
                mUnmetPrequisiteMessage = definition.UnmetPrerequisiteMessageDefinition.CreateLocalizableString
            End If

            ReDim mFactoryArgs(mDefinition.FactoryArgDefinitions.Length - 1)
            For i As Integer = 0 To mDefinition.FactoryArgDefinitions.Length - 1
                If TypeOf mDefinition.FactoryArgDefinitions(i) Is PredicateFactoryDefinition Then
                    mFactoryArgs(i) = DirectCast(mDefinition.FactoryArgDefinitions(i), PredicateFactoryDefinition).CreatePredicateFactory
                Else
                    mFactoryArgs(i) = mDefinition.FactoryArgDefinitions(i)
                End If
            Next
        End Sub

    End Class


    <XmlType("PredicateFactory"), Serializable()> _
    Public Class PredicateFactoryDefinition
        Implements ICloneable

        Private mPredicateType As PredicateType
        Public Property PredicateType() As PredicateType
            Get
                Return mPredicateType
            End Get
            Set(ByVal value As PredicateType)
                mPredicateType = value
            End Set
        End Property
        Private mUnmetPrerequisiteMessageDefinition As LocalizableStringDefinition
        Public Property UnmetPrerequisiteMessageDefinition() As LocalizableStringDefinition
            Get
                Return mUnmetPrerequisiteMessageDefinition
            End Get
            Set(ByVal value As LocalizableStringDefinition)
                mUnmetPrerequisiteMessageDefinition = value
            End Set
        End Property

        <XmlElement("FactoryArguments")> _
        Public FactoryArgDefinitions As Object()

        Public Function DeepCopy() As PredicateFactoryDefinition
            Return DirectCast(Clone(), PredicateFactoryDefinition)
        End Function

        Public Function Clone() As Object Implements System.ICloneable.Clone

            Dim newDef As New PredicateFactoryDefinition

            newDef.PredicateType = Me.PredicateType
            If Not UnmetPrerequisiteMessageDefinition Is Nothing Then
                newDef.UnmetPrerequisiteMessageDefinition = Me.UnmetPrerequisiteMessageDefinition.DeepCopy
            End If


            If FactoryArgDefinitions Is Nothing Then
                FactoryArgDefinitions = New Object() {}
            End If

            ReDim newDef.FactoryArgDefinitions(FactoryArgDefinitions.Length - 1)
            For i As Integer = 0 To FactoryArgDefinitions.Length - 1
                If FactoryArgDefinitions(i).GetType.GetInterface("IClonable") Is Nothing Then
                    newDef.FactoryArgDefinitions(i) = FactoryArgDefinitions(i)
                Else
                    newDef.FactoryArgDefinitions(i) = DirectCast(FactoryArgDefinitions(i), ICloneable).Clone
                End If
            Next

            Return newDef

        End Function

        Public Function CreatePredicateFactory() As PredicateFactory
            Dim factory As New PredicateFactory
            factory.BindFromDefinitionToSelf(Me)
            Return factory
        End Function

    End Class


End Namespace
