'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Drawing
Imports System.Globalization
Imports System.Windows.Forms

Imports Mbark.UI
Imports Mbark.SensorMessages


' Note:
' ----
' This control does not encapsulate much UI logic, because it is used in more than one place. Specifically, 
' see AttemptEditor and SkipTaskForm for detailed behavior

Namespace Mbark.Sensors

    Public Class TaskOrAttemptEditor
        Inherits System.Windows.Forms.UserControl
        Implements IAutosizable
        Implements IHasUICulture

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call

        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Public WithEvents CancelReasonsControl As Mbark.Sensors.CancelReasonsControl
        Public WithEvents CaptureResultControl As Mbark.Sensors.CaptureResultPanel
        Public WithEvents CurrentConditionsControl As Mbark.Sensors.ConditionsControl
        Public WithEvents CapturedConditionsControl As Mbark.Sensors.ConditionsControl
        Public WithEvents CurrentInaccessibleBodyPartsControl As Mbark.Sensors.InaccessibleBodyPartsControl
        Public WithEvents CapturedInaccessibleBodyPartsControl As Mbark.Sensors.InaccessibleBodyPartsControl

        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(TaskOrAttemptEditor))
            Me.CurrentConditionsControl = New Mbark.Sensors.ConditionsControl
            Me.CancelReasonsControl = New Mbark.Sensors.CancelReasonsControl
            Me.CapturedInaccessibleBodyPartsControl = New Mbark.Sensors.InaccessibleBodyPartsControl
            Me.CaptureResultControl = New Mbark.Sensors.CaptureResultPanel
            Me.CapturedConditionsControl = New Mbark.Sensors.ConditionsControl
            Me.CurrentInaccessibleBodyPartsControl = New Mbark.Sensors.InaccessibleBodyPartsControl
            Me.SuspendLayout()
            '
            'CurrentConditionsControl
            '
            Me.CurrentConditionsControl.AccessibleDescription = resources.GetString("CurrentConditionsControl.AccessibleDescription")
            Me.CurrentConditionsControl.AccessibleName = resources.GetString("CurrentConditionsControl.AccessibleName")
            Me.CurrentConditionsControl.Anchor = CType(resources.GetObject("CurrentConditionsControl.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.CurrentConditionsControl.AutoScroll = CType(resources.GetObject("CurrentConditionsControl.AutoScroll"), Boolean)
            Me.CurrentConditionsControl.AutoScrollMargin = CType(resources.GetObject("CurrentConditionsControl.AutoScrollMargin"), System.Drawing.Size)
            Me.CurrentConditionsControl.AutoScrollMinSize = CType(resources.GetObject("CurrentConditionsControl.AutoScrollMinSize"), System.Drawing.Size)
            Me.CurrentConditionsControl.BackgroundImage = CType(resources.GetObject("CurrentConditionsControl.BackgroundImage"), System.Drawing.Image)
            Me.CurrentConditionsControl.DisabledLabelColor = System.Drawing.Color.Black
            Me.CurrentConditionsControl.DisabledLabelText = ""
            Me.CurrentConditionsControl.Dock = CType(resources.GetObject("CurrentConditionsControl.Dock"), System.Windows.Forms.DockStyle)
            Me.CurrentConditionsControl.Enabled = CType(resources.GetObject("CurrentConditionsControl.Enabled"), Boolean)
            Me.CurrentConditionsControl.Font = CType(resources.GetObject("CurrentConditionsControl.Font"), System.Drawing.Font)
            Me.CurrentConditionsControl.HeaderText = "Special Conditions"
            Me.CurrentConditionsControl.HeaderTextColor = System.Drawing.Color.Empty
            Me.CurrentConditionsControl.ImeMode = CType(resources.GetObject("CurrentConditionsControl.ImeMode"), System.Windows.Forms.ImeMode)
            Me.CurrentConditionsControl.Location = CType(resources.GetObject("CurrentConditionsControl.Location"), System.Drawing.Point)
            Me.CurrentConditionsControl.Name = "CurrentConditionsControl"
            Me.CurrentConditionsControl.RadioButtonIndentation = 8
            Me.CurrentConditionsControl.RadioButtonSelected = False
            Me.CurrentConditionsControl.RadioGroupBoxChecked = False
            Me.CurrentConditionsControl.RightToLeft = CType(resources.GetObject("CurrentConditionsControl.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.CurrentConditionsControl.ShowStaticsOnly = False
            Me.CurrentConditionsControl.Size = CType(resources.GetObject("CurrentConditionsControl.Size"), System.Drawing.Size)
            Me.CurrentConditionsControl.TabIndex = CType(resources.GetObject("CurrentConditionsControl.TabIndex"), Integer)
            Me.CurrentConditionsControl.UICulture = New System.Globalization.CultureInfo("en-US")
            Me.CurrentConditionsControl.Visible = CType(resources.GetObject("CurrentConditionsControl.Visible"), Boolean)
            Me.CurrentConditionsControl.WithFancyHeader = False
            Me.CurrentConditionsControl.WithRadioButton = False
            '
            'CancelReasonsControl
            '
            Me.CancelReasonsControl.AccessibleDescription = resources.GetString("CancelReasonsControl.AccessibleDescription")
            Me.CancelReasonsControl.AccessibleName = resources.GetString("CancelReasonsControl.AccessibleName")
            Me.CancelReasonsControl.Anchor = CType(resources.GetObject("CancelReasonsControl.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.CancelReasonsControl.AutoScroll = CType(resources.GetObject("CancelReasonsControl.AutoScroll"), Boolean)
            Me.CancelReasonsControl.AutoScrollMargin = CType(resources.GetObject("CancelReasonsControl.AutoScrollMargin"), System.Drawing.Size)
            Me.CancelReasonsControl.AutoScrollMinSize = CType(resources.GetObject("CancelReasonsControl.AutoScrollMinSize"), System.Drawing.Size)
            Me.CancelReasonsControl.BackgroundImage = CType(resources.GetObject("CancelReasonsControl.BackgroundImage"), System.Drawing.Image)
            Me.CancelReasonsControl.Dock = CType(resources.GetObject("CancelReasonsControl.Dock"), System.Windows.Forms.DockStyle)
            Me.CancelReasonsControl.Enabled = CType(resources.GetObject("CancelReasonsControl.Enabled"), Boolean)
            Me.CancelReasonsControl.Font = CType(resources.GetObject("CancelReasonsControl.Font"), System.Drawing.Font)
            Me.CancelReasonsControl.HeaderText = "Other"
            Me.CancelReasonsControl.HeaderTextColor = System.Drawing.Color.Empty
            Me.CancelReasonsControl.ImeMode = CType(resources.GetObject("CancelReasonsControl.ImeMode"), System.Windows.Forms.ImeMode)
            Me.CancelReasonsControl.Location = CType(resources.GetObject("CancelReasonsControl.Location"), System.Drawing.Point)
            Me.CancelReasonsControl.Name = "CancelReasonsControl"
            Me.CancelReasonsControl.RadioButtonIndent = 16
            Me.CancelReasonsControl.RadioButtonIndentation = 8
            Me.CancelReasonsControl.RadioButtonSelected = False
            Me.CancelReasonsControl.RadioGroupBoxChecked = False
            Me.CancelReasonsControl.RightToLeft = CType(resources.GetObject("CancelReasonsControl.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.CancelReasonsControl.Size = CType(resources.GetObject("CancelReasonsControl.Size"), System.Drawing.Size)
            Me.CancelReasonsControl.TabIndex = CType(resources.GetObject("CancelReasonsControl.TabIndex"), Integer)
            Me.CancelReasonsControl.UICulture = New System.Globalization.CultureInfo("en-US")
            Me.CancelReasonsControl.Visible = CType(resources.GetObject("CancelReasonsControl.Visible"), Boolean)
            Me.CancelReasonsControl.WithFancyHeader = False
            Me.CancelReasonsControl.WithRadioButton = False
            '
            'CapturedInaccessibleBodyPartsControl
            '
            Me.CapturedInaccessibleBodyPartsControl.AccessibleDescription = resources.GetString("CapturedInaccessibleBodyPartsControl.AccessibleDescription")
            Me.CapturedInaccessibleBodyPartsControl.AccessibleName = resources.GetString("CapturedInaccessibleBodyPartsControl.AccessibleName")
            Me.CapturedInaccessibleBodyPartsControl.Anchor = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.CapturedInaccessibleBodyPartsControl.AutoScroll = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.AutoScroll"), Boolean)
            Me.CapturedInaccessibleBodyPartsControl.AutoScrollMargin = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.AutoScrollMargin"), System.Drawing.Size)
            Me.CapturedInaccessibleBodyPartsControl.AutoScrollMinSize = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.AutoScrollMinSize"), System.Drawing.Size)
            Me.CapturedInaccessibleBodyPartsControl.BackgroundImage = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.BackgroundImage"), System.Drawing.Image)
            Me.CapturedInaccessibleBodyPartsControl.DisabledLabelColor = System.Drawing.Color.Black
            Me.CapturedInaccessibleBodyPartsControl.DisabledLabelText = ""
            Me.CapturedInaccessibleBodyPartsControl.Dock = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.Dock"), System.Windows.Forms.DockStyle)
            Me.CapturedInaccessibleBodyPartsControl.Enabled = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.Enabled"), Boolean)
            Me.CapturedInaccessibleBodyPartsControl.Font = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.Font"), System.Drawing.Font)
            Me.CapturedInaccessibleBodyPartsControl.HeaderText = Nothing
            Me.CapturedInaccessibleBodyPartsControl.HeaderTextColor = System.Drawing.Color.Empty
            Me.CapturedInaccessibleBodyPartsControl.ImeMode = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.ImeMode"), System.Windows.Forms.ImeMode)
            Me.CapturedInaccessibleBodyPartsControl.Location = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.Location"), System.Drawing.Point)
            Me.CapturedInaccessibleBodyPartsControl.Name = "CapturedInaccessibleBodyPartsControl"
            Me.CapturedInaccessibleBodyPartsControl.RadioButtonIndentation = 8
            Me.CapturedInaccessibleBodyPartsControl.RadioButtonSelected = False
            Me.CapturedInaccessibleBodyPartsControl.RadioGroupBoxChecked = False
            Me.CapturedInaccessibleBodyPartsControl.RightToLeft = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.CapturedInaccessibleBodyPartsControl.Size = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.Size"), System.Drawing.Size)
            Me.CapturedInaccessibleBodyPartsControl.TabIndex = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.TabIndex"), Integer)
            Me.CapturedInaccessibleBodyPartsControl.Visible = CType(resources.GetObject("CapturedInaccessibleBodyPartsControl.Visible"), Boolean)
            Me.CapturedInaccessibleBodyPartsControl.WithFancyHeader = False
            Me.CapturedInaccessibleBodyPartsControl.WithIrises = False
            Me.CapturedInaccessibleBodyPartsControl.WithLeftHand = False
            Me.CapturedInaccessibleBodyPartsControl.WithRadioButton = False
            Me.CapturedInaccessibleBodyPartsControl.WithRightHand = False
            '
            'CaptureResultControl
            '
            Me.CaptureResultControl.AccessibleDescription = resources.GetString("CaptureResultControl.AccessibleDescription")
            Me.CaptureResultControl.AccessibleName = resources.GetString("CaptureResultControl.AccessibleName")
            Me.CaptureResultControl.Anchor = CType(resources.GetObject("CaptureResultControl.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.CaptureResultControl.AutoScroll = CType(resources.GetObject("CaptureResultControl.AutoScroll"), Boolean)
            Me.CaptureResultControl.AutoScrollMargin = CType(resources.GetObject("CaptureResultControl.AutoScrollMargin"), System.Drawing.Size)
            Me.CaptureResultControl.AutoScrollMinSize = CType(resources.GetObject("CaptureResultControl.AutoScrollMinSize"), System.Drawing.Size)
            Me.CaptureResultControl.BackgroundImage = CType(resources.GetObject("CaptureResultControl.BackgroundImage"), System.Drawing.Image)
            Me.CaptureResultControl.CorruptImage = False
            Me.CaptureResultControl.Dock = CType(resources.GetObject("CaptureResultControl.Dock"), System.Windows.Forms.DockStyle)
            Me.CaptureResultControl.Enabled = CType(resources.GetObject("CaptureResultControl.Enabled"), Boolean)
            Me.CaptureResultControl.Font = CType(resources.GetObject("CaptureResultControl.Font"), System.Drawing.Font)
            Me.CaptureResultControl.HeaderText = Nothing
            Me.CaptureResultControl.HeaderTextColor = System.Drawing.Color.Empty
            Me.CaptureResultControl.ImeMode = CType(resources.GetObject("CaptureResultControl.ImeMode"), System.Windows.Forms.ImeMode)
            Me.CaptureResultControl.Location = CType(resources.GetObject("CaptureResultControl.Location"), System.Drawing.Point)
            Me.CaptureResultControl.Name = "CaptureResultControl"
            Me.CaptureResultControl.RadioButtonIndentation = 8
            Me.CaptureResultControl.RadioButtonSelected = False
            Me.CaptureResultControl.RadioGroupBoxChecked = False
            Me.CaptureResultControl.RejectImage = False
            Me.CaptureResultControl.RightToLeft = CType(resources.GetObject("CaptureResultControl.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.CaptureResultControl.Size = CType(resources.GetObject("CaptureResultControl.Size"), System.Drawing.Size)
            Me.CaptureResultControl.TabIndex = CType(resources.GetObject("CaptureResultControl.TabIndex"), Integer)
            Me.CaptureResultControl.UICulture = New System.Globalization.CultureInfo("en-US")
            Me.CaptureResultControl.Visible = CType(resources.GetObject("CaptureResultControl.Visible"), Boolean)
            Me.CaptureResultControl.WithFancyHeader = False
            Me.CaptureResultControl.WithRadioButton = False
            '
            'CapturedConditionsControl
            '
            Me.CapturedConditionsControl.AccessibleDescription = resources.GetString("CapturedConditionsControl.AccessibleDescription")
            Me.CapturedConditionsControl.AccessibleName = resources.GetString("CapturedConditionsControl.AccessibleName")
            Me.CapturedConditionsControl.Anchor = CType(resources.GetObject("CapturedConditionsControl.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.CapturedConditionsControl.AutoScroll = CType(resources.GetObject("CapturedConditionsControl.AutoScroll"), Boolean)
            Me.CapturedConditionsControl.AutoScrollMargin = CType(resources.GetObject("CapturedConditionsControl.AutoScrollMargin"), System.Drawing.Size)
            Me.CapturedConditionsControl.AutoScrollMinSize = CType(resources.GetObject("CapturedConditionsControl.AutoScrollMinSize"), System.Drawing.Size)
            Me.CapturedConditionsControl.BackgroundImage = CType(resources.GetObject("CapturedConditionsControl.BackgroundImage"), System.Drawing.Image)
            Me.CapturedConditionsControl.DisabledLabelColor = System.Drawing.Color.Black
            Me.CapturedConditionsControl.DisabledLabelText = ""
            Me.CapturedConditionsControl.Dock = CType(resources.GetObject("CapturedConditionsControl.Dock"), System.Windows.Forms.DockStyle)
            Me.CapturedConditionsControl.Enabled = CType(resources.GetObject("CapturedConditionsControl.Enabled"), Boolean)
            Me.CapturedConditionsControl.Font = CType(resources.GetObject("CapturedConditionsControl.Font"), System.Drawing.Font)
            Me.CapturedConditionsControl.HeaderText = "Special Conditions"
            Me.CapturedConditionsControl.HeaderTextColor = System.Drawing.Color.Empty
            Me.CapturedConditionsControl.ImeMode = CType(resources.GetObject("CapturedConditionsControl.ImeMode"), System.Windows.Forms.ImeMode)
            Me.CapturedConditionsControl.Location = CType(resources.GetObject("CapturedConditionsControl.Location"), System.Drawing.Point)
            Me.CapturedConditionsControl.Name = "CapturedConditionsControl"
            Me.CapturedConditionsControl.RadioButtonIndentation = 8
            Me.CapturedConditionsControl.RadioButtonSelected = False
            Me.CapturedConditionsControl.RadioGroupBoxChecked = False
            Me.CapturedConditionsControl.RightToLeft = CType(resources.GetObject("CapturedConditionsControl.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.CapturedConditionsControl.ShowStaticsOnly = False
            Me.CapturedConditionsControl.Size = CType(resources.GetObject("CapturedConditionsControl.Size"), System.Drawing.Size)
            Me.CapturedConditionsControl.TabIndex = CType(resources.GetObject("CapturedConditionsControl.TabIndex"), Integer)
            Me.CapturedConditionsControl.UICulture = New System.Globalization.CultureInfo("en-US")
            Me.CapturedConditionsControl.Visible = CType(resources.GetObject("CapturedConditionsControl.Visible"), Boolean)
            Me.CapturedConditionsControl.WithFancyHeader = False
            Me.CapturedConditionsControl.WithRadioButton = False
            '
            'CurrentInaccessibleBodyPartsControl
            '
            Me.CurrentInaccessibleBodyPartsControl.AccessibleDescription = resources.GetString("CurrentInaccessibleBodyPartsControl.AccessibleDescription")
            Me.CurrentInaccessibleBodyPartsControl.AccessibleName = resources.GetString("CurrentInaccessibleBodyPartsControl.AccessibleName")
            Me.CurrentInaccessibleBodyPartsControl.Anchor = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.CurrentInaccessibleBodyPartsControl.AutoScroll = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.AutoScroll"), Boolean)
            Me.CurrentInaccessibleBodyPartsControl.AutoScrollMargin = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.AutoScrollMargin"), System.Drawing.Size)
            Me.CurrentInaccessibleBodyPartsControl.AutoScrollMinSize = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.AutoScrollMinSize"), System.Drawing.Size)
            Me.CurrentInaccessibleBodyPartsControl.BackgroundImage = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.BackgroundImage"), System.Drawing.Image)
            Me.CurrentInaccessibleBodyPartsControl.DisabledLabelColor = System.Drawing.Color.Black
            Me.CurrentInaccessibleBodyPartsControl.DisabledLabelText = ""
            Me.CurrentInaccessibleBodyPartsControl.Dock = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.Dock"), System.Windows.Forms.DockStyle)
            Me.CurrentInaccessibleBodyPartsControl.Enabled = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.Enabled"), Boolean)
            Me.CurrentInaccessibleBodyPartsControl.Font = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.Font"), System.Drawing.Font)
            Me.CurrentInaccessibleBodyPartsControl.HeaderText = Nothing
            Me.CurrentInaccessibleBodyPartsControl.HeaderTextColor = System.Drawing.Color.Empty
            Me.CurrentInaccessibleBodyPartsControl.ImeMode = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.ImeMode"), System.Windows.Forms.ImeMode)
            Me.CurrentInaccessibleBodyPartsControl.Location = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.Location"), System.Drawing.Point)
            Me.CurrentInaccessibleBodyPartsControl.Name = "CurrentInaccessibleBodyPartsControl"
            Me.CurrentInaccessibleBodyPartsControl.RadioButtonIndentation = 8
            Me.CurrentInaccessibleBodyPartsControl.RadioButtonSelected = False
            Me.CurrentInaccessibleBodyPartsControl.RadioGroupBoxChecked = False
            Me.CurrentInaccessibleBodyPartsControl.RightToLeft = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.CurrentInaccessibleBodyPartsControl.Size = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.Size"), System.Drawing.Size)
            Me.CurrentInaccessibleBodyPartsControl.TabIndex = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.TabIndex"), Integer)
            Me.CurrentInaccessibleBodyPartsControl.Visible = CType(resources.GetObject("CurrentInaccessibleBodyPartsControl.Visible"), Boolean)
            Me.CurrentInaccessibleBodyPartsControl.WithFancyHeader = False
            Me.CurrentInaccessibleBodyPartsControl.WithIrises = False
            Me.CurrentInaccessibleBodyPartsControl.WithLeftHand = False
            Me.CurrentInaccessibleBodyPartsControl.WithRadioButton = False
            Me.CurrentInaccessibleBodyPartsControl.WithRightHand = False
            '
            'TaskOrAttemptEditor
            '
            Me.AccessibleDescription = resources.GetString("$this.AccessibleDescription")
            Me.AccessibleName = resources.GetString("$this.AccessibleName")
            Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
            Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
            Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
            Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
            Me.Controls.Add(Me.CurrentInaccessibleBodyPartsControl)
            Me.Controls.Add(Me.CapturedConditionsControl)
            Me.Controls.Add(Me.CaptureResultControl)
            Me.Controls.Add(Me.CapturedInaccessibleBodyPartsControl)
            Me.Controls.Add(Me.CancelReasonsControl)
            Me.Controls.Add(Me.CurrentConditionsControl)
            Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
            Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
            Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
            Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
            Me.Name = "TaskOrAttemptEditor"
            Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.Size = CType(resources.GetObject("$this.Size"), System.Drawing.Size)
            Me.ResumeLayout(False)

        End Sub

#End Region

        Private mUICulture As CultureInfo = CultureInfo.CurrentUICulture
        Public Property UICulture() As CultureInfo Implements IHasUICulture.UICulture

            Get
                Return mUICulture
            End Get
            Set(ByVal Value As CultureInfo)
                mUICulture = Value
            End Set
        End Property

        Private mWithCapturedInaccessibleBodyParts As Boolean
        Public Property WithCapturedInaccessibleParts() As Boolean
            Get
                Return mWithCapturedInaccessibleBodyParts
            End Get
            Set(ByVal value As Boolean)
                mWithCapturedInaccessibleBodyParts = value
            End Set
        End Property

        Private mWithCurrentInaccessibleBodyParts As Boolean
        Public Property WithCurrentInaccessibleBodyParts() As Boolean
            Get
                Return mWithCurrentInaccessibleBodyParts
            End Get
            Set(ByVal value As Boolean)
                mWithCurrentInaccessibleBodyParts = value
            End Set
        End Property

        Private mWithCapturedConditions As Boolean
        Public Property WithCapturedConditions() As Boolean
            Get
                Return mWithCapturedConditions
            End Get
            Set(ByVal value As Boolean)
                mWithCapturedConditions = value
            End Set
        End Property

        Private mWithCurrentConditions As Boolean
        Public Property WithCurrentConditions() As Boolean
            Get
                Return mWithCurrentConditions
            End Get
            Set(ByVal value As Boolean)
                mWithCurrentConditions = value
            End Set
        End Property

        Private mWithCancelReasons As Boolean
        Public Property WithCancellationReasons() As Boolean
            Get
                Return mWithCancelReasons
            End Get
            Set(ByVal value As Boolean)
                mWithCancelReasons = value
            End Set
        End Property

        Private mWithCaptureResult As Boolean
        Public Property WithCaptureResult() As Boolean
            Get
                Return mWithCaptureResult
            End Get
            Set(ByVal value As Boolean)
                mWithCaptureResult = value
            End Set
        End Property

        Protected Overrides Sub OnLayout(ByVal levent As LayoutEventArgs)
            MyBase.OnLayout(levent)
            If Not NearestForm Is Nothing Then RefreshAutomaticLayout(NearestForm.CreateGraphics)
        End Sub

        Private mBorderPadding As Integer = 4
        Private mHalfBorderPadding As Integer = 2
        Public Property BorderPadding() As Integer
            Get
                Return mBorderPadding
            End Get
            Set(ByVal value As Integer)
                If value Mod 2 = 1 Then value += 1
                mBorderPadding = value
                mHalfBorderPadding = CInt(mBorderPadding / 2)
            End Set
        End Property


        Private mAutosizePanelsNotYetDrawn As Integer
        Private mAutosizePanelsDrawn As Integer
        Private mAutosizePanelsToDraw As Integer
        Private mAutosizeWidthUsed As Integer


        Public Sub AttemptToEdit(ByVal attempt As SensorTaskAttempt)
            If attempt Is Nothing Then Throw New ArgumentNullException("attempt")

            WithCapturedConditions = True
            WithCancellationReasons = False
            WithCaptureResult = True

            If attempt.ParentTask.TargetCategory = SensorTaskCategory.Face Then
                WithCapturedInaccessibleParts = False
                WithCurrentInaccessibleBodyParts = False
            Else
                WithCapturedInaccessibleParts = True
                WithCurrentInaccessibleBodyParts = True
            End If

            CapturedConditionsControl.WireConditions(attempt.CapturedConditions)
            CapturedInaccessibleBodyPartsControl.WireBodyPartsList(attempt.InaccessiblePartsOnCapture)
            CaptureResultControl.WireAttempt(attempt)

        End Sub

        Private mCurrentConditionsWire As ConditionCollection
        Public Sub WireCurrentConditions(ByVal conditions As ConditionCollection)
            If conditions Is Nothing Then Throw New ArgumentNullException("conditions")
            mCurrentConditionsWire = conditions
            WithCurrentConditions = True
            CurrentConditionsControl.WireConditions(mCurrentConditionsWire)
        End Sub

        ' CHECK THIS; Did this do anything?

        Private mCurrentInaccessibleBodyPartsWire As BodyParts
        Public Sub WireCurrentInaccessibleBodyParts(ByVal parts As BodyParts)
            If parts Is Nothing Then Throw New ArgumentNullException("parts")
            mCurrentInaccessibleBodyPartsWire = parts
            WithCurrentInaccessibleBodyParts = True
            CurrentInaccessibleBodyPartsControl.WireBodyPartsList(mCurrentInaccessibleBodyPartsWire)
        End Sub

        Private Sub AutosizeAndStackPanel(ByVal graphics As Graphics, ByVal topPanel As Control, ByVal bottomPanel As Control)

            AutosizePanel(graphics, topPanel)
            mAutosizePanelsNotYetDrawn += 1
            mAutosizePanelsDrawn -= 1
            Dim widthUsedAfterOnePanel As Integer = mAutosizeWidthUsed

            topPanel.Height = CInt(topPanel.Height / 2)

            AutosizePanel(graphics, bottomPanel)
            bottomPanel.Location = LowerLeft(topPanel)
            bottomPanel.Width = topPanel.Width
            bottomPanel.Height = topPanel.Height

            ' Restore the amount of width used
            mAutosizeWidthUsed = widthUsedAfterOnePanel

        End Sub


        Private Sub AutosizePanel(ByVal graphics As Graphics, ByVal autoSizablePanel As Control)

            Dim a As IAutosizable = DirectCast(autoSizablePanel, IAutosizable)
            With autoSizablePanel
                a.RefreshAutomaticLayout(graphics)
                If Not .Visible Then Return


                If mAutosizePanelsNotYetDrawn = 0 Then Debugging.Break()
                Dim panelWidth As Integer = CInt((Me.ClientRectangle.Width - mAutosizeWidthUsed) / mAutosizePanelsNotYetDrawn)

                mAutosizePanelsNotYetDrawn -= 1
                mAutosizePanelsDrawn += 1

                Dim bpLeft As Integer, bpRight As Integer, bp As Integer
                If mAutosizePanelsNotYetDrawn = 0 Then bpRight = mBorderPadding Else bpRight = mHalfBorderPadding
                If mAutosizePanelsDrawn >= 1 Then bpLeft = mBorderPadding Else bpLeft = mHalfBorderPadding
                bp = bpLeft + bpRight

                .Location = New Point(mAutosizeWidthUsed + bpLeft, mBorderPadding)
                .Height = ClientRectangle.Height - mBorderPadding * 2
                .Width = Math.Max(panelWidth - bp, a.MinimumWidth - bp)

                mMinimumWidth += a.MinimumWidth + bp
                mMinimumHeight = Math.Max(mMinimumHeight, a.MinimumHeight + mBorderPadding * 2)

                mAutosizeWidthUsed += .Width + bp

            End With

        End Sub

        Private mStackConditionPanels As Boolean = True
        Public Property StackConditionPanels() As Boolean
            Get
                Return mStackConditionPanels
            End Get
            Set(ByVal value As Boolean)
                mStackConditionPanels = value
            End Set
        End Property

        Private mStackBodyPartPanels As Boolean = True
        Public Property StackBodyPartPanels() As Boolean
            Get
                Return mStackBodyPartPanels
            End Get
            Set(ByVal value As Boolean)
                mStackBodyPartPanels = value
            End Set
        End Property


        Public Sub RefreshAutomaticLayout(ByVal graphics As System.Drawing.Graphics) Implements UI.IAutosizable.RefreshAutomaticLayout

            SuspendLayout()

            mAutosizePanelsToDraw = 0


            If mWithCancelReasons Then mAutosizePanelsToDraw += 1
            If mWithCaptureResult Then mAutosizePanelsToDraw += 1


            If Not CapturedConditionsControl.Conditions Is Nothing Then
                If WithCapturedConditions AndAlso Not CapturedConditionsControl.Conditions.HasValidConditions Then

                    ' Don't show any captured or current conditions if there are no valid ones
                    mWithCapturedConditions = False
                    mWithCurrentConditions = False

                    ' Don't bother stacking the body part panels if there are no conditions
                    StackBodyPartPanels = False
                End If
            End If

            Dim bothConditions As Boolean = WithCapturedConditions AndAlso WithCurrentConditions
            If bothConditions Then
                If StackConditionPanels Then
                    mAutosizePanelsToDraw += 1
                Else
                    mAutosizePanelsToDraw += 2
                End If
            Else
                If WithCapturedConditions Then mAutosizePanelsToDraw += 1
                If WithCurrentConditions Then mAutosizePanelsToDraw += 1
            End If

            Dim bothParts As Boolean = WithCapturedInaccessibleParts AndAlso WithCurrentInaccessibleBodyParts
            If bothParts Then
                If StackBodyPartPanels Then
                    mAutosizePanelsToDraw += 1
                Else
                    mAutosizePanelsToDraw += 2
                End If
            Else
                If WithCapturedInaccessibleParts Then mAutosizePanelsToDraw += 1
                If WithCurrentInaccessibleBodyParts Then mAutosizePanelsToDraw += 1
            End If

            CapturedInaccessibleBodyPartsControl.Visible = mWithCapturedInaccessibleBodyParts
            CurrentInaccessibleBodyPartsControl.Visible = mWithCurrentInaccessibleBodyParts
            CapturedConditionsControl.Visible = mWithCapturedConditions
            CurrentConditionsControl.Visible = mWithCurrentConditions
            CancelReasonsControl.Visible = mWithCancelReasons
            CaptureResultControl.Visible = mWithCaptureResult


            ' If there are no panels to draw, then leave
            If mAutosizePanelsToDraw = 0 Then Return

            mAutosizePanelsDrawn = 0
            mAutosizeWidthUsed = 0
            mAutosizePanelsNotYetDrawn = mAutosizePanelsToDraw

            mMinimumWidth = 0
            mMinimumHeight = 0

            If WithCancellationReasons Then AutosizePanel(graphics, CancelReasonsControl)
            If WithCaptureResult Then AutosizePanel(graphics, CaptureResultControl)

            If bothConditions AndAlso StackConditionPanels Then
                AutosizeAndStackPanel(graphics, CapturedConditionsControl, CurrentConditionsControl)
            Else
                If WithCapturedConditions Then AutosizePanel(graphics, CapturedConditionsControl)
                If WithCurrentConditions Then AutosizePanel(graphics, CurrentConditionsControl)
            End If

            If bothParts AndAlso StackBodyPartPanels Then
                AutosizeAndStackPanel(graphics, CapturedInaccessibleBodyPartsControl, CurrentInaccessibleBodyPartsControl)
            Else
                If WithCapturedInaccessibleParts Then AutosizePanel(graphics, CapturedInaccessibleBodyPartsControl)
                If WithCurrentInaccessibleBodyParts Then AutosizePanel(graphics, CurrentInaccessibleBodyPartsControl)
            End If

            ResumeLayout()


        End Sub

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)
            If InDesignMode(Me) Then Return

            ' Propogate the culture information
            CapturedConditionsControl.UICulture = UICulture
            CurrentConditionsControl.UICulture = UICulture
            CapturedInaccessibleBodyPartsControl.UICulture = UICulture
            CurrentInaccessibleBodyPartsControl.UICulture = UICulture
            CancelReasonsControl.UICulture = UICulture
            CaptureResultControl.UICulture = UICulture

            CurrentConditionsControl.ShowStaticsOnly = True

            PopulateMessages()
            
        End Sub

        Private Sub PopulateMessages()
            CapturedConditionsControl.HeaderText = Messages.CapturedConditions(UICulture)
            CurrentConditionsControl.HeaderText = Messages.CurrentConditions(UICulture)
            CapturedInaccessibleBodyPartsControl.HeaderText = Messages.CapturedInjuries(UICulture)
            CurrentInaccessibleBodyPartsControl.HeaderText = Messages.CurrentInjuries(UICulture)
        End Sub


        Private mMinimumHeight As Integer
        Public ReadOnly Property MinimumHeight() As Integer Implements UI.IAutosizable.MinimumHeight
            Get
                Return mMinimumHeight
            End Get
        End Property

        Private mMinimumWidth As Integer
        Public ReadOnly Property MinimumWidth() As Integer Implements UI.IAutosizable.MinimumWidth
            Get
                Return mMinimumWidth
            End Get
        End Property

        Public ReadOnly Property NearestForm() As System.Windows.Forms.Form Implements UI.IAutosizable.NearestForm
            Get
                Return FindNearestForm(Me)
            End Get
        End Property

    End Class

End Namespace