'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Globalization
Imports Mbark.SensorMessages

Namespace Mbark.Sensors

    Public Class SensorRecoveryForm
        Inherits System.Windows.Forms.Form
        Implements IHasUICulture

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call

        End Sub

        'Form overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents TimeoutIndicator1 As Mbark.UI.TimeoutIndicator
        Friend WithEvents InstructionLabel As System.Windows.Forms.Label
        Friend WithEvents TryToRecoverButton As System.Windows.Forms.Button
        Friend WithEvents GiveUpButton As System.Windows.Forms.Button
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(SensorRecoveryForm))
            Me.InstructionLabel = New System.Windows.Forms.Label
            Me.TryToRecoverButton = New System.Windows.Forms.Button
            Me.GiveUpButton = New System.Windows.Forms.Button
            Me.TimeoutIndicator1 = New Mbark.UI.TimeoutIndicator
            Me.SuspendLayout()
            '
            'InstructionLabel
            '
            Me.InstructionLabel.AccessibleDescription = resources.GetString("InstructionLabel.AccessibleDescription")
            Me.InstructionLabel.AccessibleName = resources.GetString("InstructionLabel.AccessibleName")
            Me.InstructionLabel.Anchor = CType(resources.GetObject("InstructionLabel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.InstructionLabel.AutoSize = CType(resources.GetObject("InstructionLabel.AutoSize"), Boolean)
            Me.InstructionLabel.Dock = CType(resources.GetObject("InstructionLabel.Dock"), System.Windows.Forms.DockStyle)
            Me.InstructionLabel.Enabled = CType(resources.GetObject("InstructionLabel.Enabled"), Boolean)
            Me.InstructionLabel.Font = CType(resources.GetObject("InstructionLabel.Font"), System.Drawing.Font)
            Me.InstructionLabel.Image = CType(resources.GetObject("InstructionLabel.Image"), System.Drawing.Image)
            Me.InstructionLabel.ImageAlign = CType(resources.GetObject("InstructionLabel.ImageAlign"), System.Drawing.ContentAlignment)
            Me.InstructionLabel.ImageIndex = CType(resources.GetObject("InstructionLabel.ImageIndex"), Integer)
            Me.InstructionLabel.ImeMode = CType(resources.GetObject("InstructionLabel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.InstructionLabel.Location = CType(resources.GetObject("InstructionLabel.Location"), System.Drawing.Point)
            Me.InstructionLabel.Name = "InstructionLabel"
            Me.InstructionLabel.RightToLeft = CType(resources.GetObject("InstructionLabel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.InstructionLabel.Size = CType(resources.GetObject("InstructionLabel.Size"), System.Drawing.Size)
            Me.InstructionLabel.TabIndex = CType(resources.GetObject("InstructionLabel.TabIndex"), Integer)
            Me.InstructionLabel.Text = resources.GetString("InstructionLabel.Text")
            Me.InstructionLabel.TextAlign = CType(resources.GetObject("InstructionLabel.TextAlign"), System.Drawing.ContentAlignment)
            Me.InstructionLabel.Visible = CType(resources.GetObject("InstructionLabel.Visible"), Boolean)
            '
            'TryToRecoverButton
            '
            Me.TryToRecoverButton.AccessibleDescription = resources.GetString("TryToRecoverButton.AccessibleDescription")
            Me.TryToRecoverButton.AccessibleName = resources.GetString("TryToRecoverButton.AccessibleName")
            Me.TryToRecoverButton.Anchor = CType(resources.GetObject("TryToRecoverButton.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.TryToRecoverButton.BackgroundImage = CType(resources.GetObject("TryToRecoverButton.BackgroundImage"), System.Drawing.Image)
            Me.TryToRecoverButton.Dock = CType(resources.GetObject("TryToRecoverButton.Dock"), System.Windows.Forms.DockStyle)
            Me.TryToRecoverButton.Enabled = CType(resources.GetObject("TryToRecoverButton.Enabled"), Boolean)
            Me.TryToRecoverButton.FlatStyle = CType(resources.GetObject("TryToRecoverButton.FlatStyle"), System.Windows.Forms.FlatStyle)
            Me.TryToRecoverButton.Font = CType(resources.GetObject("TryToRecoverButton.Font"), System.Drawing.Font)
            Me.TryToRecoverButton.Image = CType(resources.GetObject("TryToRecoverButton.Image"), System.Drawing.Image)
            Me.TryToRecoverButton.ImageAlign = CType(resources.GetObject("TryToRecoverButton.ImageAlign"), System.Drawing.ContentAlignment)
            Me.TryToRecoverButton.ImageIndex = CType(resources.GetObject("TryToRecoverButton.ImageIndex"), Integer)
            Me.TryToRecoverButton.ImeMode = CType(resources.GetObject("TryToRecoverButton.ImeMode"), System.Windows.Forms.ImeMode)
            Me.TryToRecoverButton.Location = CType(resources.GetObject("TryToRecoverButton.Location"), System.Drawing.Point)
            Me.TryToRecoverButton.Name = "TryToRecoverButton"
            Me.TryToRecoverButton.RightToLeft = CType(resources.GetObject("TryToRecoverButton.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.TryToRecoverButton.Size = CType(resources.GetObject("TryToRecoverButton.Size"), System.Drawing.Size)
            Me.TryToRecoverButton.TabIndex = CType(resources.GetObject("TryToRecoverButton.TabIndex"), Integer)
            Me.TryToRecoverButton.Text = resources.GetString("TryToRecoverButton.Text")
            Me.TryToRecoverButton.TextAlign = CType(resources.GetObject("TryToRecoverButton.TextAlign"), System.Drawing.ContentAlignment)
            Me.TryToRecoverButton.Visible = CType(resources.GetObject("TryToRecoverButton.Visible"), Boolean)
            '
            'GiveUpButton
            '
            Me.GiveUpButton.AccessibleDescription = resources.GetString("GiveUpButton.AccessibleDescription")
            Me.GiveUpButton.AccessibleName = resources.GetString("GiveUpButton.AccessibleName")
            Me.GiveUpButton.Anchor = CType(resources.GetObject("GiveUpButton.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.GiveUpButton.BackgroundImage = CType(resources.GetObject("GiveUpButton.BackgroundImage"), System.Drawing.Image)
            Me.GiveUpButton.Dock = CType(resources.GetObject("GiveUpButton.Dock"), System.Windows.Forms.DockStyle)
            Me.GiveUpButton.Enabled = CType(resources.GetObject("GiveUpButton.Enabled"), Boolean)
            Me.GiveUpButton.FlatStyle = CType(resources.GetObject("GiveUpButton.FlatStyle"), System.Windows.Forms.FlatStyle)
            Me.GiveUpButton.Font = CType(resources.GetObject("GiveUpButton.Font"), System.Drawing.Font)
            Me.GiveUpButton.Image = CType(resources.GetObject("GiveUpButton.Image"), System.Drawing.Image)
            Me.GiveUpButton.ImageAlign = CType(resources.GetObject("GiveUpButton.ImageAlign"), System.Drawing.ContentAlignment)
            Me.GiveUpButton.ImageIndex = CType(resources.GetObject("GiveUpButton.ImageIndex"), Integer)
            Me.GiveUpButton.ImeMode = CType(resources.GetObject("GiveUpButton.ImeMode"), System.Windows.Forms.ImeMode)
            Me.GiveUpButton.Location = CType(resources.GetObject("GiveUpButton.Location"), System.Drawing.Point)
            Me.GiveUpButton.Name = "GiveUpButton"
            Me.GiveUpButton.RightToLeft = CType(resources.GetObject("GiveUpButton.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.GiveUpButton.Size = CType(resources.GetObject("GiveUpButton.Size"), System.Drawing.Size)
            Me.GiveUpButton.TabIndex = CType(resources.GetObject("GiveUpButton.TabIndex"), Integer)
            Me.GiveUpButton.Text = resources.GetString("GiveUpButton.Text")
            Me.GiveUpButton.TextAlign = CType(resources.GetObject("GiveUpButton.TextAlign"), System.Drawing.ContentAlignment)
            Me.GiveUpButton.Visible = CType(resources.GetObject("GiveUpButton.Visible"), Boolean)
            '
            'TimeoutIndicator1
            '
            Me.TimeoutIndicator1.AccessibleDescription = resources.GetString("TimeoutIndicator1.AccessibleDescription")
            Me.TimeoutIndicator1.AccessibleName = resources.GetString("TimeoutIndicator1.AccessibleName")
            Me.TimeoutIndicator1.Anchor = CType(resources.GetObject("TimeoutIndicator1.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.TimeoutIndicator1.AutoScroll = CType(resources.GetObject("TimeoutIndicator1.AutoScroll"), Boolean)
            Me.TimeoutIndicator1.AutoScrollMargin = CType(resources.GetObject("TimeoutIndicator1.AutoScrollMargin"), System.Drawing.Size)
            Me.TimeoutIndicator1.AutoScrollMinSize = CType(resources.GetObject("TimeoutIndicator1.AutoScrollMinSize"), System.Drawing.Size)
            Me.TimeoutIndicator1.BackgroundImage = CType(resources.GetObject("TimeoutIndicator1.BackgroundImage"), System.Drawing.Image)
            Me.TimeoutIndicator1.CriticalColor = System.Drawing.Color.Red
            Me.TimeoutIndicator1.CriticalTime = 0
            Me.TimeoutIndicator1.Dock = CType(resources.GetObject("TimeoutIndicator1.Dock"), System.Windows.Forms.DockStyle)
            Me.TimeoutIndicator1.Enabled = CType(resources.GetObject("TimeoutIndicator1.Enabled"), Boolean)
            Me.TimeoutIndicator1.Font = CType(resources.GetObject("TimeoutIndicator1.Font"), System.Drawing.Font)
            Me.TimeoutIndicator1.ImeMode = CType(resources.GetObject("TimeoutIndicator1.ImeMode"), System.Windows.Forms.ImeMode)
            Me.TimeoutIndicator1.Location = CType(resources.GetObject("TimeoutIndicator1.Location"), System.Drawing.Point)
            Me.TimeoutIndicator1.Name = "TimeoutIndicator1"
            Me.TimeoutIndicator1.RightToLeft = CType(resources.GetObject("TimeoutIndicator1.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.TimeoutIndicator1.Size = CType(resources.GetObject("TimeoutIndicator1.Size"), System.Drawing.Size)
            Me.TimeoutIndicator1.TabIndex = CType(resources.GetObject("TimeoutIndicator1.TabIndex"), Integer)
            Me.TimeoutIndicator1.UpdateFrequency = 100
            Me.TimeoutIndicator1.Visible = CType(resources.GetObject("TimeoutIndicator1.Visible"), Boolean)
            '
            'SensorRecoveryForm
            '
            Me.AccessibleDescription = resources.GetString("$this.AccessibleDescription")
            Me.AccessibleName = resources.GetString("$this.AccessibleName")
            Me.AutoScaleBaseSize = CType(resources.GetObject("$this.AutoScaleBaseSize"), System.Drawing.Size)
            Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
            Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
            Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
            Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
            Me.ClientSize = CType(resources.GetObject("$this.ClientSize"), System.Drawing.Size)
            Me.ControlBox = False
            Me.Controls.Add(Me.TimeoutIndicator1)
            Me.Controls.Add(Me.GiveUpButton)
            Me.Controls.Add(Me.TryToRecoverButton)
            Me.Controls.Add(Me.InstructionLabel)
            Me.DockPadding.All = 8
            Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
            Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
            Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow
            Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
            Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
            Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
            Me.MaximumSize = CType(resources.GetObject("$this.MaximumSize"), System.Drawing.Size)
            Me.MinimumSize = CType(resources.GetObject("$this.MinimumSize"), System.Drawing.Size)
            Me.Name = "SensorRecoveryForm"
            Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.StartPosition = CType(resources.GetObject("$this.StartPosition"), System.Windows.Forms.FormStartPosition)
            Me.Text = resources.GetString("$this.Text")
            Me.ResumeLayout(False)

        End Sub

#End Region

        Private mUICulture As CultureInfo = CultureInfo.CurrentUICulture
        Public Property UICulture() As CultureInfo Implements IHasUICulture.UICulture
            Get
                Return mUICulture
            End Get
            Set(ByVal Value As CultureInfo)
                mUICulture = Value
            End Set
        End Property


        Public Enum RecoveryAction
            Reinitialize
            GiveUp
        End Enum


        Private mFailingSensor As ISensor
        Public Property FailingSensor() As ISensor
            Get
                Return mFailingSensor
            End Get
            Set(ByVal value As ISensor)
                mFailingSensor = value
            End Set
        End Property

        Private mDesiredRecoveryAction As RecoveryAction
        Public Property DesiredRecoveryAction() As RecoveryAction
            Get
                Return mDesiredRecoveryAction
            End Get
            Set(ByVal value As RecoveryAction)
                mDesiredRecoveryAction = value
            End Set
        End Property


        Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TryToRecoverButton.Click
            mDesiredRecoveryAction = RecoveryAction.Reinitialize
            Me.Close()
        End Sub

        Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GiveUpButton.Click
            mDesiredRecoveryAction = RecoveryAction.GiveUp
            Me.Close()
        End Sub

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)
            PopulateMessages()
            InstructionLabel.Font = Mbark.UI.GlobalUISettings.Defaults.Fonts.Regular
            TryToRecoverButton.Font = Mbark.UI.GlobalUISettings.Defaults.Fonts.Button
            GiveUpButton.Font = Mbark.UI.GlobalUISettings.Defaults.Fonts.Button
            TimeoutIndicator1.StartCountdown(30000)
        End Sub

        Private Sub PopulateMessages()
            Me.Text = Messages.SensorRecoveryFormTitle(UICulture)
            InstructionLabel.Text = Messages.SensorRecoveryInstructions(UICulture)
        End Sub

        Private Sub OutOfTime(ByVal sendere As Object, ByVal e As EventArgs) Handles TimeoutIndicator1.OutOfTimeEvent
            mDesiredRecoveryAction = RecoveryAction.Reinitialize
            Me.Close()
        End Sub

    End Class

End Namespace