Option Strict On

Imports System.Drawing
Imports System.Windows.Forms

Imports SF = Syncfusion.Windows.Forms.Tools

Imports Mbark.UI
Imports Mbark.SensorMessages

Namespace Mbark.Sensors


    Public Class IrisPickerControl
        Inherits BasePickerControl

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call
            UserNew()
        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents RightEyeToolTip As System.Windows.Forms.ToolTip
        Friend WithEvents LeftEyeToolTip As System.Windows.Forms.ToolTip
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Me.components = New System.ComponentModel.Container
            Me.RightEyeToolTip = New System.Windows.Forms.ToolTip(Me.components)
            Me.LeftEyeToolTip = New System.Windows.Forms.ToolTip(Me.components)
            '
            'IrisPickerControl
            '
            Me.Name = "IrisPickerControl"
            Me.Size = New System.Drawing.Size(304, 432)

        End Sub

#End Region

        Public WithEvents LeftEyeCheckBox As New XBox
        Public WithEvents RightEyeCheckBox As New XBox

        Private Sub UserNew()

            LeftEyeCheckBox.Name = "LeftEyeCheckBox"
            Controls.Add(LeftEyeCheckBox)

            RightEyeCheckBox.Name = "RightEyeCheckBox"
            Controls.Add(RightEyeCheckBox)


            PartImages(New Bitmap(Me.GetType(), "head.png"), New Bitmap(Me.GetType(), "head-disabled.png"))

        End Sub

        Protected Friend Overrides Sub BindFromWireToControl()

            If BodyPartsWire Is Nothing Then Return

            With BodyPartsWire
                If .Contains(BodyPart.LeftIris) Then LeftEyeCheckBox.CheckState = CheckState.Checked
                If .Contains(BodyPart.RightIris) Then RightEyeCheckBox.CheckState = CheckState.Checked
            End With

        End Sub

        Private Sub BindFromControlToWire()

            If BodyPartsWire Is Nothing Then Return
            With BodyPartsWire
                If LeftEyeCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.LeftIris) Else .Remove(BodyPart.LeftIris)
                If RightEyeCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.RightIris) Else .Remove(BodyPart.RightIris)
            End With

        End Sub


        Private Shared RightEyeCenter As New Point(152, 248)
        Private Shared LeftEyeCenter As New Point(279, 248)

        Private mLeftEyeOnly As Boolean
        Public Property LeftEyeOnly() As Boolean
            Get
                Return mLeftEyeOnly
            End Get
            Set(ByVal value As Boolean)
                mLeftEyeOnly = value
            End Set
        End Property

        Private mRightEyeOnly As Boolean
        Public Property RightEyeOnly() As Boolean
            Get
                Return mRightEyeOnly
            End Get
            Set(ByVal value As Boolean)
                mRightEyeOnly = value
            End Set
        End Property


        Private Sub PlaceCheckBox(ByVal checkBox As CheckBox, ByVal loc As Point)

            checkBox.Height = 13
            checkBox.Width = 13

            Dim newPoint As Point = MainPictureBox.RemapImagePoint(loc)

            newPoint.Y -= CInt(checkBox.Height / 2)
            newPoint.X -= CInt(checkBox.Width / 2)

            checkBox.Location = newPoint
            checkBox.Size = GlobalUISettings.ControlSizes.CheckBox
            checkBox.BringToFront()

        End Sub

        'Private Sub PlaceLabelAtopCheckBox(ByVal label As Label, ByVal checkbox As CheckBox)
        '    Dim x As Integer = checkbox.Location.X + CInt(checkbox.Width / 2) - CInt(label.Width / 2)
        '    Dim y As Integer = checkbox.Location.Y - label.Height
        '    label.Location = New Point(x, y)
        'End Sub

        Protected Overrides Sub LayoutCheckBoxes()
            PlaceCheckBox(RightEyeCheckBox, RightEyeCenter)
            PlaceCheckBox(LeftEyeCheckBox, LeftEyeCenter)
        End Sub


        Protected Overrides Sub RefreshCheckBoxes()
            LeftEyeCheckBox.Enabled = MyBase.Enabled
            RightEyeCheckBox.Enabled = MyBase.Enabled

            If RightEyeOnly Then LeftEyeCheckBox.Enabled = False
            If LeftEyeOnly Then RightEyeCheckBox.Enabled = False
        End Sub


        Private Sub CheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles RightEyeCheckBox.CheckedChanged, LeftEyeCheckBox.CheckedChanged
            RefreshCheckBoxes()
            BindFromControlToWire()
        End Sub



        Public Overrides Sub RefreshAutomaticLayout(ByVal graphics As Graphics)
            MyBase.RefreshAutomaticLayout(graphics)
        End Sub

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)
            PopulateMessages()
        End Sub

        Private Sub PopulateMessages()
            FooterLabel.Text = Messages.Irises(UICulture)
            RightEyeToolTip.SetToolTip(RightEyeCheckBox, Messages.RightIris(UICulture))
            LeftEyeToolTip.SetToolTip(LeftEyeCheckBox, Messages.LeftIris(UICulture))
        End Sub


        'reset all Iris check box - un-check all check box when new session starting
        Public Sub ResetIrisPickerControl()
            LeftEyeCheckBox.Checked = False
            RightEyeCheckBox.Checked = False
        End Sub
    End Class

End Namespace