'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 


Option Strict On

Imports Mbark
Imports Mbark.UI
Imports Mbark.Threading

Imports System.Drawing
Imports System.Globalization
Imports System.Windows.Forms

Namespace Mbark.Sensors

    Public Class BaseSensor
        Inherits System.Windows.Forms.UserControl
        Implements ISensor
        Implements IAutosizable

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call
            UserNew()
        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If Me.mCommandThreadLifetime = CommandThreadLifetime.PerConstruction Then
                mCommandManager.Stop(True)
            End If
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents HeaderLabel As Syncfusion.Windows.Forms.Tools.GradientLabel
        Protected Friend WithEvents ActivateSensorButton As System.Windows.Forms.Button
        Protected Friend WithEvents CancelSensorButton As System.Windows.Forms.Button
        Friend WithEvents FooterPanel As Syncfusion.Windows.Forms.Tools.GradientPanel
        Protected Friend WithEvents TimeoutIndicator As TimeoutIndicator
        Friend WithEvents ButtonPanel As Syncfusion.Windows.Forms.Tools.GradientPanel
        Protected Friend WithEvents MainPanel As System.Windows.Forms.Panel
        Friend WithEvents ConditionsLabel As Syncfusion.Windows.Forms.Tools.GradientLabel
        Protected Friend WithEvents OuterPanel As Syncfusion.Windows.Forms.Tools.GradientPanel
        Protected Friend WithEvents InnerPanel As System.Windows.Forms.Panel
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(BaseSensor))
            Me.OuterPanel = New Syncfusion.Windows.Forms.Tools.GradientPanel
            Me.InnerPanel = New System.Windows.Forms.Panel
            Me.MainPanel = New System.Windows.Forms.Panel
            Me.FooterPanel = New Syncfusion.Windows.Forms.Tools.GradientPanel
            Me.ButtonPanel = New Syncfusion.Windows.Forms.Tools.GradientPanel
            Me.ActivateSensorButton = New System.Windows.Forms.Button
            Me.CancelSensorButton = New System.Windows.Forms.Button
            Me.TimeoutIndicator = New TimeoutIndicator
            Me.ConditionsLabel = New Syncfusion.Windows.Forms.Tools.GradientLabel
            Me.HeaderLabel = New Syncfusion.Windows.Forms.Tools.GradientLabel
            CType(Me.OuterPanel, System.ComponentModel.ISupportInitialize).BeginInit()
            Me.OuterPanel.SuspendLayout()
            Me.InnerPanel.SuspendLayout()
            CType(Me.FooterPanel, System.ComponentModel.ISupportInitialize).BeginInit()
            Me.FooterPanel.SuspendLayout()
            CType(Me.ButtonPanel, System.ComponentModel.ISupportInitialize).BeginInit()
            Me.ButtonPanel.SuspendLayout()
            Me.SuspendLayout()
            '
            'OuterPanel
            '
            Me.OuterPanel.AccessibleDescription = resources.GetString("OuterPanel.AccessibleDescription")
            Me.OuterPanel.AccessibleName = resources.GetString("OuterPanel.AccessibleName")
            Me.OuterPanel.Anchor = CType(resources.GetObject("OuterPanel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.OuterPanel.AutoScroll = CType(resources.GetObject("OuterPanel.AutoScroll"), Boolean)
            Me.OuterPanel.AutoScrollMargin = CType(resources.GetObject("OuterPanel.AutoScrollMargin"), System.Drawing.Size)
            Me.OuterPanel.AutoScrollMinSize = CType(resources.GetObject("OuterPanel.AutoScrollMinSize"), System.Drawing.Size)
            Me.OuterPanel.BackgroundImage = CType(resources.GetObject("OuterPanel.BackgroundImage"), System.Drawing.Image)
            Me.OuterPanel.BorderColor = System.Drawing.SystemColors.Highlight
            Me.OuterPanel.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
            Me.OuterPanel.Controls.Add(Me.InnerPanel)
            Me.OuterPanel.Controls.Add(Me.FooterPanel)
            Me.OuterPanel.Controls.Add(Me.ConditionsLabel)
            Me.OuterPanel.Controls.Add(Me.HeaderLabel)
            Me.OuterPanel.Dock = CType(resources.GetObject("OuterPanel.Dock"), System.Windows.Forms.DockStyle)
            Me.OuterPanel.Enabled = CType(resources.GetObject("OuterPanel.Enabled"), Boolean)
            Me.OuterPanel.Font = CType(resources.GetObject("OuterPanel.Font"), System.Drawing.Font)
            Me.OuterPanel.ImeMode = CType(resources.GetObject("OuterPanel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.OuterPanel.Location = CType(resources.GetObject("OuterPanel.Location"), System.Drawing.Point)
            Me.OuterPanel.Name = "OuterPanel"
            Me.OuterPanel.RightToLeft = CType(resources.GetObject("OuterPanel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.OuterPanel.Size = CType(resources.GetObject("OuterPanel.Size"), System.Drawing.Size)
            Me.OuterPanel.TabIndex = CType(resources.GetObject("OuterPanel.TabIndex"), Integer)
            Me.OuterPanel.Text = resources.GetString("OuterPanel.Text")
            Me.OuterPanel.Visible = CType(resources.GetObject("OuterPanel.Visible"), Boolean)
            '
            'InnerPanel
            '
            Me.InnerPanel.AccessibleDescription = resources.GetString("InnerPanel.AccessibleDescription")
            Me.InnerPanel.AccessibleName = resources.GetString("InnerPanel.AccessibleName")
            Me.InnerPanel.Anchor = CType(resources.GetObject("InnerPanel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.InnerPanel.AutoScroll = CType(resources.GetObject("InnerPanel.AutoScroll"), Boolean)
            Me.InnerPanel.AutoScrollMargin = CType(resources.GetObject("InnerPanel.AutoScrollMargin"), System.Drawing.Size)
            Me.InnerPanel.AutoScrollMinSize = CType(resources.GetObject("InnerPanel.AutoScrollMinSize"), System.Drawing.Size)
            Me.InnerPanel.BackgroundImage = CType(resources.GetObject("InnerPanel.BackgroundImage"), System.Drawing.Image)
            Me.InnerPanel.Controls.Add(Me.MainPanel)
            Me.InnerPanel.Dock = CType(resources.GetObject("InnerPanel.Dock"), System.Windows.Forms.DockStyle)
            Me.InnerPanel.Enabled = CType(resources.GetObject("InnerPanel.Enabled"), Boolean)
            Me.InnerPanel.Font = CType(resources.GetObject("InnerPanel.Font"), System.Drawing.Font)
            Me.InnerPanel.ImeMode = CType(resources.GetObject("InnerPanel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.InnerPanel.Location = CType(resources.GetObject("InnerPanel.Location"), System.Drawing.Point)
            Me.InnerPanel.Name = "InnerPanel"
            Me.InnerPanel.RightToLeft = CType(resources.GetObject("InnerPanel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.InnerPanel.Size = CType(resources.GetObject("InnerPanel.Size"), System.Drawing.Size)
            Me.InnerPanel.TabIndex = CType(resources.GetObject("InnerPanel.TabIndex"), Integer)
            Me.InnerPanel.Text = resources.GetString("InnerPanel.Text")
            Me.InnerPanel.Visible = CType(resources.GetObject("InnerPanel.Visible"), Boolean)
            '
            'MainPanel
            '
            Me.MainPanel.AccessibleDescription = resources.GetString("MainPanel.AccessibleDescription")
            Me.MainPanel.AccessibleName = resources.GetString("MainPanel.AccessibleName")
            Me.MainPanel.Anchor = CType(resources.GetObject("MainPanel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.MainPanel.AutoScroll = CType(resources.GetObject("MainPanel.AutoScroll"), Boolean)
            Me.MainPanel.AutoScrollMargin = CType(resources.GetObject("MainPanel.AutoScrollMargin"), System.Drawing.Size)
            Me.MainPanel.AutoScrollMinSize = CType(resources.GetObject("MainPanel.AutoScrollMinSize"), System.Drawing.Size)
            Me.MainPanel.BackgroundImage = CType(resources.GetObject("MainPanel.BackgroundImage"), System.Drawing.Image)
            Me.MainPanel.Dock = CType(resources.GetObject("MainPanel.Dock"), System.Windows.Forms.DockStyle)
            Me.MainPanel.Enabled = CType(resources.GetObject("MainPanel.Enabled"), Boolean)
            Me.MainPanel.Font = CType(resources.GetObject("MainPanel.Font"), System.Drawing.Font)
            Me.MainPanel.ImeMode = CType(resources.GetObject("MainPanel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.MainPanel.Location = CType(resources.GetObject("MainPanel.Location"), System.Drawing.Point)
            Me.MainPanel.Name = "MainPanel"
            Me.MainPanel.RightToLeft = CType(resources.GetObject("MainPanel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.MainPanel.Size = CType(resources.GetObject("MainPanel.Size"), System.Drawing.Size)
            Me.MainPanel.TabIndex = CType(resources.GetObject("MainPanel.TabIndex"), Integer)
            Me.MainPanel.Text = resources.GetString("MainPanel.Text")
            Me.MainPanel.Visible = CType(resources.GetObject("MainPanel.Visible"), Boolean)
            '
            'FooterPanel
            '
            Me.FooterPanel.AccessibleDescription = resources.GetString("FooterPanel.AccessibleDescription")
            Me.FooterPanel.AccessibleName = resources.GetString("FooterPanel.AccessibleName")
            Me.FooterPanel.Anchor = CType(resources.GetObject("FooterPanel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.FooterPanel.AutoScroll = CType(resources.GetObject("FooterPanel.AutoScroll"), Boolean)
            Me.FooterPanel.AutoScrollMargin = CType(resources.GetObject("FooterPanel.AutoScrollMargin"), System.Drawing.Size)
            Me.FooterPanel.AutoScrollMinSize = CType(resources.GetObject("FooterPanel.AutoScrollMinSize"), System.Drawing.Size)
            Me.FooterPanel.BackgroundImage = CType(resources.GetObject("FooterPanel.BackgroundImage"), System.Drawing.Image)
            Me.FooterPanel.BorderColor = System.Drawing.Color.Black
            Me.FooterPanel.BorderStyle = System.Windows.Forms.BorderStyle.None
            Me.FooterPanel.Controls.Add(Me.ButtonPanel)
            Me.FooterPanel.Controls.Add(Me.TimeoutIndicator)
            Me.FooterPanel.Dock = CType(resources.GetObject("FooterPanel.Dock"), System.Windows.Forms.DockStyle)
            Me.FooterPanel.Enabled = CType(resources.GetObject("FooterPanel.Enabled"), Boolean)
            Me.FooterPanel.Font = CType(resources.GetObject("FooterPanel.Font"), System.Drawing.Font)
            Me.FooterPanel.ImeMode = CType(resources.GetObject("FooterPanel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.FooterPanel.Location = CType(resources.GetObject("FooterPanel.Location"), System.Drawing.Point)
            Me.FooterPanel.Name = "FooterPanel"
            Me.FooterPanel.RightToLeft = CType(resources.GetObject("FooterPanel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.FooterPanel.Size = CType(resources.GetObject("FooterPanel.Size"), System.Drawing.Size)
            Me.FooterPanel.TabIndex = CType(resources.GetObject("FooterPanel.TabIndex"), Integer)
            Me.FooterPanel.Text = resources.GetString("FooterPanel.Text")
            Me.FooterPanel.Visible = CType(resources.GetObject("FooterPanel.Visible"), Boolean)
            '
            'ButtonPanel
            '
            Me.ButtonPanel.AccessibleDescription = resources.GetString("ButtonPanel.AccessibleDescription")
            Me.ButtonPanel.AccessibleName = resources.GetString("ButtonPanel.AccessibleName")
            Me.ButtonPanel.Anchor = CType(resources.GetObject("ButtonPanel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.ButtonPanel.AutoScroll = CType(resources.GetObject("ButtonPanel.AutoScroll"), Boolean)
            Me.ButtonPanel.AutoScrollMargin = CType(resources.GetObject("ButtonPanel.AutoScrollMargin"), System.Drawing.Size)
            Me.ButtonPanel.AutoScrollMinSize = CType(resources.GetObject("ButtonPanel.AutoScrollMinSize"), System.Drawing.Size)
            Me.ButtonPanel.BackgroundImage = CType(resources.GetObject("ButtonPanel.BackgroundImage"), System.Drawing.Image)
            Me.ButtonPanel.BorderColor = System.Drawing.Color.Black
            Me.ButtonPanel.BorderStyle = System.Windows.Forms.BorderStyle.None
            Me.ButtonPanel.Controls.Add(Me.ActivateSensorButton)
            Me.ButtonPanel.Controls.Add(Me.CancelSensorButton)
            Me.ButtonPanel.Dock = CType(resources.GetObject("ButtonPanel.Dock"), System.Windows.Forms.DockStyle)
            Me.ButtonPanel.Enabled = CType(resources.GetObject("ButtonPanel.Enabled"), Boolean)
            Me.ButtonPanel.Font = CType(resources.GetObject("ButtonPanel.Font"), System.Drawing.Font)
            Me.ButtonPanel.ImeMode = CType(resources.GetObject("ButtonPanel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.ButtonPanel.Location = CType(resources.GetObject("ButtonPanel.Location"), System.Drawing.Point)
            Me.ButtonPanel.Name = "ButtonPanel"
            Me.ButtonPanel.RightToLeft = CType(resources.GetObject("ButtonPanel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.ButtonPanel.Size = CType(resources.GetObject("ButtonPanel.Size"), System.Drawing.Size)
            Me.ButtonPanel.TabIndex = CType(resources.GetObject("ButtonPanel.TabIndex"), Integer)
            Me.ButtonPanel.Text = resources.GetString("ButtonPanel.Text")
            Me.ButtonPanel.Visible = CType(resources.GetObject("ButtonPanel.Visible"), Boolean)
            '
            'ActivateSensorButton
            '
            Me.ActivateSensorButton.AccessibleDescription = resources.GetString("ActivateSensorButton.AccessibleDescription")
            Me.ActivateSensorButton.AccessibleName = resources.GetString("ActivateSensorButton.AccessibleName")
            Me.ActivateSensorButton.Anchor = CType(resources.GetObject("ActivateSensorButton.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.ActivateSensorButton.BackgroundImage = CType(resources.GetObject("ActivateSensorButton.BackgroundImage"), System.Drawing.Image)
            Me.ActivateSensorButton.Dock = CType(resources.GetObject("ActivateSensorButton.Dock"), System.Windows.Forms.DockStyle)
            Me.ActivateSensorButton.Enabled = CType(resources.GetObject("ActivateSensorButton.Enabled"), Boolean)
            Me.ActivateSensorButton.FlatStyle = CType(resources.GetObject("ActivateSensorButton.FlatStyle"), System.Windows.Forms.FlatStyle)
            Me.ActivateSensorButton.Font = CType(resources.GetObject("ActivateSensorButton.Font"), System.Drawing.Font)
            Me.ActivateSensorButton.Image = CType(resources.GetObject("ActivateSensorButton.Image"), System.Drawing.Image)
            Me.ActivateSensorButton.ImageAlign = CType(resources.GetObject("ActivateSensorButton.ImageAlign"), System.Drawing.ContentAlignment)
            Me.ActivateSensorButton.ImageIndex = CType(resources.GetObject("ActivateSensorButton.ImageIndex"), Integer)
            Me.ActivateSensorButton.ImeMode = CType(resources.GetObject("ActivateSensorButton.ImeMode"), System.Windows.Forms.ImeMode)
            Me.ActivateSensorButton.Location = CType(resources.GetObject("ActivateSensorButton.Location"), System.Drawing.Point)
            Me.ActivateSensorButton.Name = "ActivateSensorButton"
            Me.ActivateSensorButton.RightToLeft = CType(resources.GetObject("ActivateSensorButton.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.ActivateSensorButton.Size = CType(resources.GetObject("ActivateSensorButton.Size"), System.Drawing.Size)
            Me.ActivateSensorButton.TabIndex = CType(resources.GetObject("ActivateSensorButton.TabIndex"), Integer)
            Me.ActivateSensorButton.Text = resources.GetString("ActivateSensorButton.Text")
            Me.ActivateSensorButton.TextAlign = CType(resources.GetObject("ActivateSensorButton.TextAlign"), System.Drawing.ContentAlignment)
            Me.ActivateSensorButton.Visible = CType(resources.GetObject("ActivateSensorButton.Visible"), Boolean)
            '
            'CancelSensorButton
            '
            Me.CancelSensorButton.AccessibleDescription = resources.GetString("CancelSensorButton.AccessibleDescription")
            Me.CancelSensorButton.AccessibleName = resources.GetString("CancelSensorButton.AccessibleName")
            Me.CancelSensorButton.Anchor = CType(resources.GetObject("CancelSensorButton.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.CancelSensorButton.BackgroundImage = CType(resources.GetObject("CancelSensorButton.BackgroundImage"), System.Drawing.Image)
            Me.CancelSensorButton.Dock = CType(resources.GetObject("CancelSensorButton.Dock"), System.Windows.Forms.DockStyle)
            Me.CancelSensorButton.Enabled = CType(resources.GetObject("CancelSensorButton.Enabled"), Boolean)
            Me.CancelSensorButton.FlatStyle = CType(resources.GetObject("CancelSensorButton.FlatStyle"), System.Windows.Forms.FlatStyle)
            Me.CancelSensorButton.Font = CType(resources.GetObject("CancelSensorButton.Font"), System.Drawing.Font)
            Me.CancelSensorButton.Image = CType(resources.GetObject("CancelSensorButton.Image"), System.Drawing.Image)
            Me.CancelSensorButton.ImageAlign = CType(resources.GetObject("CancelSensorButton.ImageAlign"), System.Drawing.ContentAlignment)
            Me.CancelSensorButton.ImageIndex = CType(resources.GetObject("CancelSensorButton.ImageIndex"), Integer)
            Me.CancelSensorButton.ImeMode = CType(resources.GetObject("CancelSensorButton.ImeMode"), System.Windows.Forms.ImeMode)
            Me.CancelSensorButton.Location = CType(resources.GetObject("CancelSensorButton.Location"), System.Drawing.Point)
            Me.CancelSensorButton.Name = "CancelSensorButton"
            Me.CancelSensorButton.RightToLeft = CType(resources.GetObject("CancelSensorButton.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.CancelSensorButton.Size = CType(resources.GetObject("CancelSensorButton.Size"), System.Drawing.Size)
            Me.CancelSensorButton.TabIndex = CType(resources.GetObject("CancelSensorButton.TabIndex"), Integer)
            Me.CancelSensorButton.Text = resources.GetString("CancelSensorButton.Text")
            Me.CancelSensorButton.TextAlign = CType(resources.GetObject("CancelSensorButton.TextAlign"), System.Drawing.ContentAlignment)
            Me.CancelSensorButton.Visible = CType(resources.GetObject("CancelSensorButton.Visible"), Boolean)
            '
            'TimeoutIndicator
            '
            Me.TimeoutIndicator.AccessibleDescription = resources.GetString("TimeoutIndicator.AccessibleDescription")
            Me.TimeoutIndicator.AccessibleName = resources.GetString("TimeoutIndicator.AccessibleName")
            Me.TimeoutIndicator.Anchor = CType(resources.GetObject("TimeoutIndicator.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.TimeoutIndicator.AutoScroll = CType(resources.GetObject("TimeoutIndicator.AutoScroll"), Boolean)
            Me.TimeoutIndicator.AutoScrollMargin = CType(resources.GetObject("TimeoutIndicator.AutoScrollMargin"), System.Drawing.Size)
            Me.TimeoutIndicator.AutoScrollMinSize = CType(resources.GetObject("TimeoutIndicator.AutoScrollMinSize"), System.Drawing.Size)
            Me.TimeoutIndicator.BackgroundImage = CType(resources.GetObject("TimeoutIndicator.BackgroundImage"), System.Drawing.Image)
            Me.TimeoutIndicator.CriticalColor = System.Drawing.Color.Red
            Me.TimeoutIndicator.CriticalTime = 0
            Me.TimeoutIndicator.Dock = CType(resources.GetObject("TimeoutIndicator.Dock"), System.Windows.Forms.DockStyle)
            Me.TimeoutIndicator.Enabled = CType(resources.GetObject("TimeoutIndicator.Enabled"), Boolean)
            Me.TimeoutIndicator.Font = CType(resources.GetObject("TimeoutIndicator.Font"), System.Drawing.Font)
            Me.TimeoutIndicator.ImeMode = CType(resources.GetObject("TimeoutIndicator.ImeMode"), System.Windows.Forms.ImeMode)
            Me.TimeoutIndicator.Location = CType(resources.GetObject("TimeoutIndicator.Location"), System.Drawing.Point)
            Me.TimeoutIndicator.Name = "TimeoutIndicator"
            Me.TimeoutIndicator.RightToLeft = CType(resources.GetObject("TimeoutIndicator.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.TimeoutIndicator.Size = CType(resources.GetObject("TimeoutIndicator.Size"), System.Drawing.Size)
            Me.TimeoutIndicator.TabIndex = CType(resources.GetObject("TimeoutIndicator.TabIndex"), Integer)
            Me.TimeoutIndicator.UpdateFrequency = 100
            Me.TimeoutIndicator.Visible = CType(resources.GetObject("TimeoutIndicator.Visible"), Boolean)
            '
            'ConditionsLabel
            '
            Me.ConditionsLabel.AccessibleDescription = resources.GetString("ConditionsLabel.AccessibleDescription")
            Me.ConditionsLabel.AccessibleName = resources.GetString("ConditionsLabel.AccessibleName")
            Me.ConditionsLabel.Anchor = CType(resources.GetObject("ConditionsLabel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.ConditionsLabel.AutoSize = CType(resources.GetObject("ConditionsLabel.AutoSize"), Boolean)
            Me.ConditionsLabel.BackgroundColor = New Syncfusion.Drawing.BrushInfo(System.Drawing.SystemColors.Control)
            Me.ConditionsLabel.BorderSides = System.Windows.Forms.Border3DSide.Top
            Me.ConditionsLabel.BorderStyle = System.Windows.Forms.Border3DStyle.Adjust
            Me.ConditionsLabel.Dock = CType(resources.GetObject("ConditionsLabel.Dock"), System.Windows.Forms.DockStyle)
            Me.ConditionsLabel.Enabled = CType(resources.GetObject("ConditionsLabel.Enabled"), Boolean)
            Me.ConditionsLabel.Font = CType(resources.GetObject("ConditionsLabel.Font"), System.Drawing.Font)
            Me.ConditionsLabel.Image = CType(resources.GetObject("ConditionsLabel.Image"), System.Drawing.Image)
            Me.ConditionsLabel.ImageAlign = CType(resources.GetObject("ConditionsLabel.ImageAlign"), System.Drawing.ContentAlignment)
            Me.ConditionsLabel.ImageIndex = CType(resources.GetObject("ConditionsLabel.ImageIndex"), Integer)
            Me.ConditionsLabel.ImeMode = CType(resources.GetObject("ConditionsLabel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.ConditionsLabel.Location = CType(resources.GetObject("ConditionsLabel.Location"), System.Drawing.Point)
            Me.ConditionsLabel.Name = "ConditionsLabel"
            Me.ConditionsLabel.RightToLeft = CType(resources.GetObject("ConditionsLabel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.ConditionsLabel.Size = CType(resources.GetObject("ConditionsLabel.Size"), System.Drawing.Size)
            Me.ConditionsLabel.TabIndex = CType(resources.GetObject("ConditionsLabel.TabIndex"), Integer)
            Me.ConditionsLabel.Text = resources.GetString("ConditionsLabel.Text")
            Me.ConditionsLabel.TextAlign = CType(resources.GetObject("ConditionsLabel.TextAlign"), System.Drawing.ContentAlignment)
            Me.ConditionsLabel.Visible = CType(resources.GetObject("ConditionsLabel.Visible"), Boolean)
            '
            'HeaderLabel
            '
            Me.HeaderLabel.AccessibleDescription = resources.GetString("HeaderLabel.AccessibleDescription")
            Me.HeaderLabel.AccessibleName = resources.GetString("HeaderLabel.AccessibleName")
            Me.HeaderLabel.Anchor = CType(resources.GetObject("HeaderLabel.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.HeaderLabel.AutoSize = CType(resources.GetObject("HeaderLabel.AutoSize"), Boolean)
            Me.HeaderLabel.BackgroundColor = New Syncfusion.Drawing.BrushInfo(Syncfusion.Drawing.GradientStyle.ForwardDiagonal, System.Drawing.SystemColors.ActiveCaption, System.Drawing.SystemColors.InactiveCaption)
            Me.HeaderLabel.BorderSides = CType((((System.Windows.Forms.Border3DSide.Left Or System.Windows.Forms.Border3DSide.Top) _
                        Or System.Windows.Forms.Border3DSide.Right) _
                        Or System.Windows.Forms.Border3DSide.Bottom), System.Windows.Forms.Border3DSide)
            Me.HeaderLabel.BorderStyle = System.Windows.Forms.Border3DStyle.Adjust
            Me.HeaderLabel.Dock = CType(resources.GetObject("HeaderLabel.Dock"), System.Windows.Forms.DockStyle)
            Me.HeaderLabel.Enabled = CType(resources.GetObject("HeaderLabel.Enabled"), Boolean)
            Me.HeaderLabel.Font = CType(resources.GetObject("HeaderLabel.Font"), System.Drawing.Font)
            Me.HeaderLabel.ForeColor = System.Drawing.SystemColors.HighlightText
            Me.HeaderLabel.Image = CType(resources.GetObject("HeaderLabel.Image"), System.Drawing.Image)
            Me.HeaderLabel.ImageAlign = CType(resources.GetObject("HeaderLabel.ImageAlign"), System.Drawing.ContentAlignment)
            Me.HeaderLabel.ImageIndex = CType(resources.GetObject("HeaderLabel.ImageIndex"), Integer)
            Me.HeaderLabel.ImeMode = CType(resources.GetObject("HeaderLabel.ImeMode"), System.Windows.Forms.ImeMode)
            Me.HeaderLabel.Location = CType(resources.GetObject("HeaderLabel.Location"), System.Drawing.Point)
            Me.HeaderLabel.Name = "HeaderLabel"
            Me.HeaderLabel.RightToLeft = CType(resources.GetObject("HeaderLabel.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.HeaderLabel.Size = CType(resources.GetObject("HeaderLabel.Size"), System.Drawing.Size)
            Me.HeaderLabel.TabIndex = CType(resources.GetObject("HeaderLabel.TabIndex"), Integer)
            Me.HeaderLabel.Text = resources.GetString("HeaderLabel.Text")
            Me.HeaderLabel.TextAlign = CType(resources.GetObject("HeaderLabel.TextAlign"), System.Drawing.ContentAlignment)
            Me.HeaderLabel.Visible = CType(resources.GetObject("HeaderLabel.Visible"), Boolean)
            '
            'BaseSensor
            '
            Me.AccessibleDescription = resources.GetString("$this.AccessibleDescription")
            Me.AccessibleName = resources.GetString("$this.AccessibleName")
            Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
            Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
            Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
            Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
            Me.Controls.Add(Me.OuterPanel)
            Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
            Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
            Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
            Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
            Me.Name = "BaseSensor"
            Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.Size = CType(resources.GetObject("$this.Size"), System.Drawing.Size)
            CType(Me.OuterPanel, System.ComponentModel.ISupportInitialize).EndInit()
            Me.OuterPanel.ResumeLayout(False)
            Me.InnerPanel.ResumeLayout(False)
            CType(Me.FooterPanel, System.ComponentModel.ISupportInitialize).EndInit()
            Me.FooterPanel.ResumeLayout(False)
            CType(Me.ButtonPanel, System.ComponentModel.ISupportInitialize).EndInit()
            Me.ButtonPanel.ResumeLayout(False)
            Me.ResumeLayout(False)

        End Sub

#End Region

#Region "Private (Properties)"

        Private mDisabled As Boolean

        Private mDownloadIsCancellable As Boolean
        Private mLatestThumbnail As Bitmap
        Private mRequiresRecovery As Boolean

        Private mStatus As SensorStatus = SensorStatus.Offline
#End Region

        Private mUICulture As CultureInfo = CultureInfo.CurrentUICulture
        Public Property UICulture() As CultureInfo Implements ISensor.UICulture
            Get
                Return mUICulture
            End Get
            Set(ByVal Value As CultureInfo)
                mUICulture = value
            End Set
        End Property

        Private Const MaximumThumbnailWidthOrHeight As Integer = 500

        Private Sub UserNew()
            'SetStyle(Mbark.UI.DoubleBufferStyle, True)

            mStatus = SensorStatus.Uninitialized
            mSensorId = Guid.NewGuid

            If Me.mCommandThreadLifetime = CommandThreadLifetime.PerConstruction Then
                mCommandManager.Start()
            End If

            AddHandler ActivateSensorButton.Click, AddressOf HandleSensorButtonClick

        End Sub

#Region " Command Manager "

        Private mCommandManager As New AsyncCommandManager
        Protected ReadOnly Property CommandManager() As AsyncCommandManager
            Get
                Return mCommandManager
            End Get
        End Property

#End Region

#Region " Static Sensor Properties "

        Public Overridable ReadOnly Property Modality() As SensorModality _
    Implements ISensor.Modality
            Get
                If InDesignMode(Me) Then Return SensorModality.Face
                Throw New MissingSpecializationException(GetType(BaseSensor), "Modality")
            End Get
        End Property

        Public Overridable ReadOnly Property FriendlyName() As String Implements ISensor.FriendlyName
            Get
                If InDesignMode(Me) Then Return String.Empty
                Throw New MissingSpecializationException(GetType(BaseSensor), "FriendlyName")
            End Get
        End Property

        Public Overridable ReadOnly Property IsActive() As Boolean _
     Implements ISensor.IsActive
            Get
                If InDesignMode(Me) Then Return False
                Throw New MissingSpecializationException(GetType(BaseSensor), "IsActive")
            End Get
        End Property


        Public ReadOnly Property AsControl() As System.Windows.Forms.Control _
        Implements ISensor.AsControl
            Get
                Return Me
            End Get
        End Property

        Private mSensorId As Guid
        Public ReadOnly Property SensorId() As Guid Implements ISensor.SensorId
            Get
                Return mSensorId
            End Get
        End Property


        Private mRequiresReview As Boolean
        Public ReadOnly Property RequiresReview() As Boolean _
        Implements ISensor.RequiresReview
            Get
                Return mRequiresReview
            End Get
        End Property
        Protected Property WritableRequiresReview() As Boolean
            Get
                Return mRequiresReview
            End Get
            Set(ByVal value As Boolean)
                mRequiresReview = value
            End Set
        End Property

        Private mPollingIsCancelable As Boolean = True
        Public ReadOnly Property PollingIsCancelable() As Boolean Implements ISensor.PollingIsCancelable
            Get
                Return mPollingIsCancelable
            End Get
        End Property
        Protected Property WritablePollingIsCancelable() As Boolean
            Get
                Return mPollingIsCancelable
            End Get
            Set(ByVal value As Boolean)
                mPollingIsCancelable = value
            End Set
        End Property

        Private mHasLivePreview As Boolean
        Public Overridable ReadOnly Property HasLivePreview() As Boolean Implements ISensor.HasLivePreview
            Get
                Return mHasLivePreview
            End Get
        End Property
        Protected Overridable Property WritableHasLivePreview() As Boolean
            Get
                Return mHasLivePreview
            End Get
            Set(ByVal value As Boolean)
                mHasLivePreview = value
            End Set
        End Property

        Private mPercentDownloadedIsMeaningful As Boolean
        Public ReadOnly Property PercentDownloadedIsMeaningful() As Boolean _
        Implements ISensor.PercentDownloadedIsMeaningful
            Get
                Return mPercentDownloadedIsMeaningful
            End Get
        End Property
        Public Property WritablePercentDownloadedIsMeaningful() As Boolean
            Get
                Return mPercentDownloadedIsMeaningful
            End Get
            Set(ByVal value As Boolean)
                mPercentDownloadedIsMeaningful = value
            End Set
        End Property

        Public Enum CommandThreadLifetime
            PerConstruction
            PerInitialization
        End Enum

        Private mCommandThreadLifetime As CommandThreadLifetime = CommandThreadLifetime.PerInitialization
        Public Property AsyncCommandManagerLifetime() As CommandThreadLifetime
            Get
                Return mCommandThreadLifetime
            End Get
            Set(ByVal value As CommandThreadLifetime)
                mCommandThreadLifetime = value
            End Set
        End Property

        Private mHasConfigurationClass As Boolean
        Public ReadOnly Property HasConfigurationClass() As Boolean _
        Implements ISensor.HasConfigurationClass
            Get
                Return mHasConfigurationClass
            End Get
        End Property
        Protected Property WritableHasConfigurationClass() As Boolean
            Get
                Return mHasConfigurationClass
            End Get
            Set(ByVal value As Boolean)
                mHasConfigurationClass = value
            End Set
        End Property

        Private mConfigurationClassName As String
        Public ReadOnly Property ConfigurationClassName() As String _
        Implements ISensor.ConfigurationClassName
            Get
                Return mConfigurationClassName
            End Get
        End Property
        Protected Property WritableConfigurationClassName() As String
            Get
                Return mConfigurationClassName
            End Get
            Set(ByVal value As String)
                mConfigurationClassName = value
            End Set
        End Property

        Public ReadOnly Property TypeName() As String Implements ISensor.TypeName
            Get
                Return Me.GetType.FullName
            End Get
        End Property


#End Region

#Region " Dynamic Sensor Properties "
        Public Overridable ReadOnly Property LatestStatus() As SensorStatus _
        Implements ISensor.LatestStatus
            Get
                Return mStatus
            End Get
        End Property
        Public Property Disabled() As Boolean Implements ISensor.Disabled
            Get
                Return mDisabled
            End Get
            Set(ByVal Value As Boolean)
                mDisabled = Value
            End Set
        End Property

        Private mTargetParts As BodyParts
        Public Property TargetParts() As BodyParts Implements ISensor.TargetParts
            Get
                Return mTargetParts
            End Get
            Set(ByVal Value As BodyParts)
                mTargetParts = Value
            End Set
        End Property

        Private mInaccessibleParts As BodyParts
        Public Property InaccessibleParts() As BodyParts Implements ISensor.InaccessibleParts
            Get
                Return mInaccessibleParts
            End Get
            Set(ByVal Value As BodyParts)
                mInaccessibleParts = Value
            End Set
        End Property

        Private mTargetCategory As SensorTaskCategory
        Public Property TargetCategory() As SensorTaskCategory Implements ISensor.TargetCategory
            Get
                Return mTargetCategory
            End Get
            Set(ByVal Value As SensorTaskCategory)
                mTargetCategory = value
            End Set
        End Property

#Region "PercentDownloaded Property"
        Private mPercentDownloaded As Single
        Public ReadOnly Property PercentDownloaded() As Single Implements ISensor.PercentDownloaded
            Get
                Return mPercentDownloaded
            End Get
        End Property
        Protected Property WritablePercentDownloaded() As Single
            Get
                Return mPercentDownloaded
            End Get
            Set(ByVal value As Single)
                mPercentDownloaded = value
            End Set
        End Property
#End Region

#Region "LatestThumbnail Property"
        Public ReadOnly Property LatestThumbnail() As System.Drawing.Bitmap Implements ISensor.LatestThumbnail
            Get
                If mLatestThumbnail Is Nothing Then Return Nothing
                If mLatestThumbnail.Width = 0 OrElse mLatestThumbnail.Height = 0 Then Return Nothing


                Dim tooWide As Boolean = mLatestThumbnail.Width > MaximumThumbnailWidthOrHeight
                Dim tooTall As Boolean = mLatestThumbnail.Height > MaximumThumbnailWidthOrHeight
                Dim isMoreWideThanTall As Boolean = mLatestThumbnail.Width > mLatestThumbnail.Height

                If tooWide Or tooTall AndAlso isMoreWideThanTall AndAlso mLatestThumbnail.Width <> 0 Then
                    mLatestThumbnail = UI.ResizeImage(mLatestThumbnail, MaximumThumbnailWidthOrHeight * 1.0! / mLatestThumbnail.Width)
                ElseIf tooWide Or tooTall AndAlso mLatestThumbnail.Height <> 0 Then
                    mLatestThumbnail = UI.ResizeImage(mLatestThumbnail, MaximumThumbnailWidthOrHeight * 1.0! / mLatestThumbnail.Height)
                End If
                Return mLatestThumbnail
            End Get
        End Property
        Protected Property WritableLatestThumbnail() As System.Drawing.Bitmap
            Get
                Return mLatestThumbnail
            End Get
            Set(ByVal value As System.Drawing.Bitmap)
                mLatestThumbnail = value
            End Set
        End Property
#End Region

#Region "LastReviewImageAcceptable Property"

        Private mLastReviewImageAcceptable As Boolean
        Public Property LastReviewImageAcceptable() As Boolean _
        Implements ISensor.LatestReviewImageConsideredAcceptable
            Get
                Return mLastReviewImageAcceptable
            End Get
            Set(ByVal Value As Boolean)
                mLastReviewImageAcceptable = Value
            End Set
        End Property

#End Region

#Region "LastCaptureSuccessful Property"
        Private mLastCaptureSuccessful As Boolean
        Public ReadOnly Property LastCaptureSuccessful() As Boolean _
        Implements ISensor.LatestCaptureSuccessful
            Get
                Return mLastCaptureSuccessful
            End Get
        End Property
        Protected Property WritableLastCaptureSuccessful() As Boolean
            Get
                Return mLastCaptureSuccessful
            End Get
            Set(ByVal value As Boolean)
                mLastCaptureSuccessful = value
            End Set
        End Property
#End Region

        Public ReadOnly Property IsOfflineOrUninitiazlied() As Boolean _
        Implements ISensor.IsOfflineOrUninitialized
            Get
                Return mStatus = SensorStatus.Offline Or mStatus = SensorStatus.Uninitialized
            End Get
        End Property

        Public ReadOnly Property OfflineOrUninitialized() As Boolean
            Get
                Return mStatus = SensorStatus.Offline Or mStatus = SensorStatus.Uninitialized
            End Get
        End Property

#End Region

#Region "  GUI  "

        Private mButtonsEnabled As Boolean
        Private mMainPanelAspectRatio As Single = 4.0! / 3.0!
        Private mMinimumHeight As Integer
        Private mMinimumWidth As Integer


        Public Property ButtonsEnabled() As Boolean
            Get
                Return mButtonsEnabled
            End Get
            Set(ByVal value As Boolean)
                mButtonsEnabled = value
                ActivateSensorButton.Enabled = value
                CancelSensorButton.Enabled = value
                ActivateSensorButton.Refresh()
                CancelSensorButton.Refresh()
            End Set
        End Property


        Private Sub RefreshButtons()

            If IsActive Then
                CancelSensorButton.Visible = True
            Else
                CancelSensorButton.Visible = False
            End If

            If LatestStatus = SensorStatus.Online Then
                With ActivateSensorButton
                    .Enabled = True
                    .Visible = True
                    .Refresh()
                End With
            End If

        End Sub

        Public Property MainPanelAspectRatio() As Single
            Get
                Return mMainPanelAspectRatio
            End Get
            Set(ByVal value As Single)
                mMainPanelAspectRatio = value
            End Set
        End Property

        Public Property ConditionsLabelText() As String Implements ISensor.ConditionsLabelText
            Get
                Return ConditionsLabel.Text
            End Get
            Set(ByVal Value As String)
                ConditionsLabel.Text = Value
            End Set
        End Property

        Public Property ActivateSensorButtonEnabled() As Boolean Implements ISensor.ActivateSensorButtonEnabled
            Get
                Return ActivateSensorButton.Enabled
            End Get
            Set(ByVal Value As Boolean)
                ActivateSensorButton.Enabled = Value
            End Set
        End Property


#Region "  Autosize  "
        Public Sub RefreshAutomaticLayout(ByVal graphics As System.Drawing.Graphics) Implements UI.IAutosizable.RefreshAutomaticLayout

            RecursiveSuspendLayout(Me)



            ' Font and size the headerLabel
            AutoFont.FancyLabel(HeaderLabel)
            UI.AutoHeight.FancyLabel(graphics, HeaderLabel)

            ConditionsLabel.Font = GlobalUISettings.Defaults.Fonts.Regular
            ConditionsLabel.Height = HeaderLabel.Height  ' We don't use AutoHeight.Label() because the string could be empty
            If ConditionsLabel.Text = String.Empty Then ConditionsLabel.Height = 0


            Dim innerPanelAR As Single = (1.0! * InnerPanel.Width) / (1.0! * InnerPanel.Height)
            Dim ipw As Integer = InnerPanel.Width - InnerPanel.DockPadding.Left - InnerPanel.DockPadding.Right
            Dim iph As Integer = InnerPanel.Height - InnerPanel.DockPadding.Top - InnerPanel.DockPadding.Bottom

            If innerPanelAR < mMainPanelAspectRatio Then
                MainPanel.Height = CInt(ipw * 1.0 / mMainPanelAspectRatio)
                MainPanel.Location = New Point(InnerPanel.DockPadding.Left, CInt(0.5 * (iph - MainPanel.Height)))
                MainPanel.Width = InnerPanel.Width - InnerPanel.DockPadding.Left - InnerPanel.DockPadding.Right
            Else
                MainPanel.Height = InnerPanel.Height - InnerPanel.DockPadding.Top - InnerPanel.DockPadding.Bottom
                MainPanel.Width = CInt(iph * mMainPanelAspectRatio)
                MainPanel.Location = New Point(CInt(0.5 * (ipw - MainPanel.Width)), InnerPanel.DockPadding.Top)

            End If

            If IsActive Then
                TimeoutIndicator.Height = 0
            Else
                TimeoutIndicator.Height = CInt(GlobalUISettings.Defaults.Fonts.Regular.Size * 2)
            End If

            ' Autofont and size the buttons
            Static buttons As ArrayList
            If buttons Is Nothing Then
                buttons = New ArrayList
                buttons.Add(ActivateSensorButton)
                buttons.Add(CancelSensorButton)
            End If
            ActivateSensorButton.Font = GlobalUISettings.Defaults.Fonts.Button
            CancelSensorButton.Font = GlobalUISettings.Defaults.Fonts.Button
            UI.AutoSize.Buttons(graphics, buttons)

            ActivateSensorButton.Refresh()
            CancelSensorButton.Refresh()


            ' Adjust the footer panel height (the ButtonPanel.Dock = Full, so we can't adjust that height)`
            FooterPanel.Height = _
                FooterPanel.DockPadding.Top + FooterPanel.DockPadding.Bottom + ActivateSensorButton.Height + TimeoutIndicator.Height + _
            ButtonPanel.DockPadding.Top + ButtonPanel.DockPadding.Bottom

            ActivateSensorButton.Location = New Point(ButtonPanel.DockPadding.Left, ButtonPanel.DockPadding.Top)
            CancelSensorButton.Location = New Point(ButtonPanel.Width - CancelSensorButton.Width - ButtonPanel.DockPadding.Left, ButtonPanel.DockPadding.Top)

            mMinimumWidth = _
                FooterPanel.DockPadding.Left + FooterPanel.DockPadding.Right + _
                ActivateSensorButton.Width + CancelSensorButton.Height



            mMinimumHeight = _
                HeaderLabel.Height + FooterPanel.Height + ConditionsLabel.Height

            RecursiveResumeLayout(Me)
        End Sub

        Protected Overrides Sub OnLayout(ByVal levent As LayoutEventArgs)
            MyBase.OnLayout(levent)
            If Not NearestForm Is Nothing Then RefreshAutomaticLayout(NearestForm.CreateGraphics)
        End Sub

        Public ReadOnly Property MinimumHeight() As Integer Implements UI.IAutosizable.MinimumHeight
            Get
                Return mMinimumHeight
            End Get
        End Property

        Public ReadOnly Property MinimumWidth() As Integer Implements UI.IAutosizable.MinimumWidth
            Get
                Return mMinimumWidth
            End Get
        End Property

        Public ReadOnly Property NearestForm() As System.Windows.Forms.Form Implements UI.IAutosizable.NearestForm
            Get
                Return FindNearestForm(Me)
            End Get
        End Property
#End Region

        Private mTabArray As ArrayList
        Public ReadOnly Property TabList() As ArrayList
            Get
                mTabArray = New ArrayList
                If ActivateSensorButton.Enabled Then
                    mTabArray.Insert(0, ActivateSensorButton)
                    Return mTabArray
                End If
                If CancelSensorButton.Enabled Then
                    mTabArray.Insert(0, CancelSensorButton())
                    Return mTabArray
                End If
                Return Nothing
            End Get
        End Property

#End Region

#Region " Loading & Startup "


        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)

            SuspendLayout()

            Dim allPadding As Integer = 4

            If InDesignMode(Me) Then Return

            If IsActive Then
                ActivateSensorButton.Visible = True
                CancelSensorButton.Visible = False
                TimeoutIndicator.Visible = False
            Else
                ActivateSensorButton.Visible = True
                CancelSensorButton.Visible = True
                CancelSensorButton.Enabled = False
                TimeoutIndicator.Visible = True
            End If

            InnerPanel.DockPadding.All = allPadding
            FooterPanel.DockPadding.Left = allPadding
            FooterPanel.DockPadding.Right = allPadding
            FooterPanel.DockPadding.Bottom = allPadding

            ' Ensures this class intercepts the completion of capture first. (When a command
            ' is instantiated, the handlers are also bound in the order they appear in the the CommandCompleteHandler
            ' array.) Sneaky, eh?
            '
            CaptureCommandTemplate.InsertCommandCompleteHandler(0, AddressOf HandleCaptureCompleted)
            InitializationCommandTemplate.InsertCommandCompleteHandler(0, AddressOf HandleInitializationCompleted)

            If Not ConfigurationCommandTemplate Is Nothing Then
                ConfigurationCommandTemplate.InsertCommandCompleteHandler(0, AddressOf HandleConfigurationCompleted)
            End If

            If Not NearestForm Is Nothing Then RefreshAutomaticLayout(NearestForm.CreateGraphics)


            ResumeLayout()

            'GenerateTabList()
        End Sub
#End Region


#Region " Capture Activation and Default Result Wrapper "

        Public Event CaptureActivated(ByVal sender As Object, ByVal e As CaptureActivatedEventArgs) _
        Implements ISensor.CaptureActivatedEvent


        Public Overridable ReadOnly Property CaptureCommandTemplate() As Threading.AsyncCommandTemplate _
            Implements ISensor.CaptureCommandTemplate
            Get
                If InDesignMode(Me) Then Return Nothing
                Throw New MissingSpecializationException(Me.GetType, "CaptureCommand")
            End Get
        End Property

        Private mDownloadTemplate As Threading.AsyncCommandTemplate
        Public Overridable ReadOnly Property DownloadCommandTemplate() As Threading.AsyncCommandTemplate _
        Implements ISensor.DownloadCommandTemplate
            Get
                Return mDownloadTemplate
            End Get
        End Property

        Private mPollingWasCanceled As Boolean
        Public ReadOnly Property PollingWasCanceled() As Boolean Implements ISensor.PollingWasCanceled
            Get
                Return mPollingWasCanceled
            End Get
        End Property
        Protected Property WritablePollingWasCanceled() As Boolean
            Get
                Return mPollingWasCanceled
            End Get
            Set(ByVal value As Boolean)
                mPollingWasCanceled = value
            End Set
        End Property


        Protected Overridable Sub OnCaptureActivated(ByVal captureActivated As CaptureActivatedEventArgs)

            mPollingWasCanceled = False
            mLastCaptureSuccessful = False

            If Not IsActive Then
                With TimeoutIndicator
                    .Visible = True
                    .StartCountdown(CaptureCommandTemplate.ExpirationTime)
                End With
                CancelSensorButton.Enabled = PollingIsCancelable
            End If


            Dim captureCommand As New AsyncCommand(CaptureCommandTemplate)
            mStatus = SensorStatus.Capturing
            CommandManager.Enqueue(captureCommand)
        End Sub

        Protected Sub StopCountdownTimerNow()
            'TimeoutIndicator.Visible = False
            TimeoutIndicator.StopCountdown()
            TimeoutIndicator.Refresh()
        End Sub

        Private Sub HandleCaptureCompleted(ByVal sender As Object, ByVal e As CommandCompleteEventArgs)

            ' Stop the timeout indicator (if it's not already)
            If Not IsActive Then
                With TimeoutIndicator
                    .StopCountdown()
                    .Refresh()
                End With
                CancelSensorButton.Enabled = False
            End If


        End Sub

        Private Sub HandleInitializationCompleted(ByVal sender As Object, ByVal e As CommandCompleteEventArgs)
            OnInitializationCompleted(e)
        End Sub

        Protected Overridable Sub OnCaptureCompleted(ByVal e As CommandCompleteEventArgs)
            ' Meant to be overridden
        End Sub

        Protected Overridable Sub OnInitializationCompleted(ByVal e As CommandCompleteEventArgs)

        End Sub

        Private Sub HandleSensorButtonClick(ByVal sender As System.Object, ByVal e As EventArgs)
            RequiresParts()
            ActivateSensorButton.Enabled = False
            Dim args As New CaptureActivatedEventArgs(Me)
            OnCaptureActivated(args)
            RaiseEvent CaptureActivated(Me, args)
        End Sub

        Public Overridable Function StartDownload(ByVal guid As Guid) As Guid Implements ISensor.StartDownload
            ForbidInvokeRequired(Me)
            mLatestDownloadWasSuccessful = False
            mStatus = SensorStatus.Downloading
            Dim downloadcommand As AsyncCommand = CreateDownloadCommand(guid)
            CommandManager.Enqueue(downloadcommand)
            HeaderLabel.Text = FriendlyName()
            Return downloadcommand.CommandId
        End Function

        Protected Overridable Function CreateDownloadCommand(ByVal guid As Guid) As AsyncCommand
            Throw New Mbark.MissingSpecializationException("CreateDownloadCommand")
        End Function

        Public Overridable Sub CancelCapture() Implements ISensor.CancelCapture
            If mStatus = SensorStatus.Capturing AndAlso PollingIsCancelable Then
                CancelSensorButton.PerformClick()
            End If
        End Sub

        Public Sub ActivateCaptureNow() Implements ISensor.ActivateSensorNow
            ActivateSensorButton.PerformClick()
        End Sub

#End Region

#Region "  Initialization & Uninitialization  "

        Public Overridable ReadOnly Property InitializationCommandTemplate() As Threading.AsyncCommandTemplate _
                Implements ISensor.InitializationCommandTemplate
            Get
                If InDesignMode(Me) Then Return Nothing
                Throw New MissingSpecializationException(Me.GetType, "InitializationCommandTemplate")
            End Get
        End Property

        Public Overridable Function StartInitialize() As Guid Implements ISensor.StartInitialize
            ForbidInvokeRequired(Me)

            If mStatus = SensorStatus.Online Then Return Guid.Empty
            mStatus = SensorStatus.Initializing

            Dim initCommand As New AsyncCommand(InitializationCommandTemplate)

            If mCommandThreadLifetime = CommandThreadLifetime.PerInitialization Then
                CommandManager.Start()
            End If

            CommandManager.Enqueue(initCommand)

            HeaderLabel.Text = FriendlyName()

            Return initCommand.CommandId
        End Function

        Public Overridable Sub Uninitialize() Implements ISensor.Uninitialize
            ForbidInvokeRequired(Me)
            If mCommandThreadLifetime = CommandThreadLifetime.PerInitialization Then
                CommandManager.Stop(True)
            End If
            mStatus = SensorStatus.Uninitialized
        End Sub

#End Region

#Region "  Configuration  "

        Public Overridable ReadOnly Property ConfigurationCommandTemplate() As Threading.AsyncCommandTemplate _
            Implements ISensor.ConfigurationCommandTemplate
            Get
                If InDesignMode(Me) Then Return Nothing
                Throw New MissingSpecializationException(Me.GetType, "ConfigurationCommandTemplate")
            End Get
        End Property

        Public Overridable Function StartConfiguration(ByVal configuration As SensorConfiguration) As Guid _
            Implements ISensor.StartConfiguration

            ' The sensor must neither be offline nor uninitialized
            If IsOfflineOrUninitiazlied Then Throw New BadSensorStatusException("Configuration", LatestStatus)

            mStatus = SensorStatus.Configuring
            Dim configCommand As New AsyncCommand(ConfigurationCommandTemplate)

            configCommand.TargetMethodArgs(New Object() {configuration})

            CommandManager.Enqueue(configCommand)
            Return configCommand.CommandId

        End Function

#Region " Requires Configuration"

        Private mRequiresConfiguration As Boolean
        Public Overridable ReadOnly Property RequiresConfiguration() As Boolean _
        Implements ISensor.RequiresConfiguration
            Get
                Return mRequiresConfiguration
            End Get
        End Property
        Protected Property WritableRequiresConfiguration() As Boolean
            Get
                Return mRequiresConfiguration
            End Get
            Set(ByVal value As Boolean)
                mRequiresConfiguration = value
            End Set
        End Property

#End Region

        Private Sub HandleConfigurationCompleted(ByVal sender As Object, ByVal e As CommandCompleteEventArgs)
            OnConfigurationCompleted(e)
        End Sub

        Protected Overridable Sub OnConfigurationCompleted(ByVal e As CommandCompleteEventArgs)
            ' Meant to be overridden
        End Sub

#End Region

#Region "IsTimeout Property"
        Private mIsTimeout As Boolean
        Protected Property WritableIsTimeout() As Boolean
            Get
                Return mIsTimeout
            End Get
            Set(ByVal value As Boolean)
                mIsTimeout = value
            End Set
        End Property
        Public ReadOnly Property IsTimeout() As Boolean
            Get
                Return mIsTimeout
            End Get
        End Property

#End Region


        Private Sub RequiresParts()
            Debug.Assert(Not mTargetParts Is Nothing)
            Debug.Assert(Not mInaccessibleParts Is Nothing)
        End Sub


        Public Overridable Sub StartLivePreview() Implements ISensor.StartLivePreview

        End Sub

        Public Overridable Sub StopLivePreview() Implements ISensor.StopLivePreview

        End Sub



        Public Overridable Function ConvertBytesAsObjectToBitmap(ByVal rawData As Object, ByVal width As Integer, ByVal height As Integer) As Bitmap
            Dim ByteArray() As Byte = CType(rawData, Byte())
            Dim bitmap As New Drawing.Bitmap(width, height, Imaging.PixelFormat.Format8bppIndexed)
            bitmap.Palette = EmptyPalette
            Dim bmd As Imaging.BitmapData = _
                            bitmap.LockBits(New Rectangle(0, 0, width, height), Imaging.ImageLockMode.ReadWrite, bitmap.PixelFormat)

            System.Runtime.InteropServices.Marshal.Copy(ByteArray, 0, bmd.Scan0, width * height)
            bitmap.UnlockBits(bmd)

            Return bitmap
        End Function

        Private mEmptyPalette As Drawing.Imaging.ColorPalette
        Public Sub InitEmptyPalette()
            Dim bitmap As New Drawing.Bitmap(Width, Height, Imaging.PixelFormat.Format8bppIndexed)
            mEmptyPalette = bitmap.Palette
            For i As Integer = 0 To 255
                EmptyPalette.Entries(i) = Color.FromArgb(i, i, i)
            Next
        End Sub

        Public ReadOnly Property EmptyPalette() As Drawing.Imaging.ColorPalette
            Get
                Return mEmptyPalette
            End Get
        End Property

        Protected Sub MarkAsOffline()
            mStatus = SensorStatus.Offline
        End Sub

        Protected Sub MarkAsOnline()
            mStatus = SensorStatus.Online
        End Sub

#Region "LatestDownloadWasSuccessful Property"
        Private mLatestDownloadWasSuccessful As Boolean
        Public ReadOnly Property LatestDownloadWasSuccessful() As Boolean Implements ISensor.LatestDownloadWasSuccessful
            Get
                Return mLatestDownloadWasSuccessful
            End Get
        End Property
        Protected Property WritableLatestDownloadWasSuccessful() As Boolean
            Get
                Return mLatestDownloadWasSuccessful
            End Get
            Set(ByVal value As Boolean)
                mLatestDownloadWasSuccessful = value
            End Set
        End Property
#End Region

        Public Overridable Function CancelDownload() As Boolean Implements ISensor.CancelDownload
            Throw New MissingSpecializationException("CancelDownload")
        End Function
        Public ReadOnly Property DownloadIsCancellable() As Boolean Implements ISensor.DownloadIsCancelable
            Get
                Return mDownloadIsCancellable
            End Get
        End Property
        Public Property WritableDownloadIsCancellable() As Boolean
            Get
                Return mDownloadIsCancellable
            End Get
            Set(ByVal value As Boolean)
                mDownloadIsCancellable = value
            End Set
        End Property

#Region "LatestDownloadWasCanceled Property"
        Private mLatestDownloadWasCanceled As Boolean
        Public ReadOnly Property LatestDownloadWasCanceled() As Boolean Implements ISensor.LatestDownloadWasCanceled
            Get
                Return mLatestDownloadWasCanceled
            End Get
        End Property
        Protected Property WritableLatestDownloadWasCanceled() As Boolean
            Get
                Return mLatestDownloadWasCanceled
            End Get
            Set(ByVal value As Boolean)
                mLatestDownloadWasCanceled = value
            End Set
        End Property

#End Region
        Public Overridable Sub DeleteInternalImages() Implements ISensor.DeleteInternalImages
            ' Meant to be overridden
        End Sub

#Region "DeferInitialization Property"
        Private mDeferInitialization As Boolean
        Public ReadOnly Property DeferInitialization() As Boolean Implements ISensor.DeferInitialization
            Get
                Return mDeferInitialization
            End Get
        End Property
        Protected Property WritableDeferInitialization() As Boolean
            Get
                Return mDeferInitialization
            End Get
            Set(ByVal value As Boolean)
                mDeferInitialization = value
            End Set
        End Property
#End Region

#Region "RequiresRecovery Property"
        Public Property RequiresRecovery() As Boolean Implements ISensor.RequiresRecovery
            Get
                Return mRequiresRecovery
            End Get
            Set(ByVal Value As Boolean)
                mRequiresRecovery = Value
            End Set
        End Property
        Protected Property WritableRequiresRecovery() As Boolean
            Get
                Return mRequiresRecovery
            End Get
            Set(ByVal value As Boolean)
                mRequiresRecovery = value
            End Set
        End Property
#End Region

#Region " Log4Net "
        'Private mIsLoggerMode As Boolean = True
        'Private mLog As New Logger(GetType(BaseSensorController))
#End Region



    End Class

End Namespace
