'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Drawing
Imports System.Security.Permissions
Imports System.Windows.Forms

Namespace Mbark.UI

    Public Class BaseForm
        Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call

        End Sub

        'Form overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Private WithEvents ResizeTimer As System.Windows.Forms.Timer
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Me.components = New System.ComponentModel.Container
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(BaseForm))
            Me.ResizeTimer = New System.Windows.Forms.Timer(Me.components)
            '
            'ResizeTimer
            '
            Me.ResizeTimer.Interval = 300
            '
            'BaseForm
            '
            Me.AccessibleDescription = resources.GetString("$this.AccessibleDescription")
            Me.AccessibleName = resources.GetString("$this.AccessibleName")
            Me.AutoScaleBaseSize = CType(resources.GetObject("$this.AutoScaleBaseSize"), System.Drawing.Size)
            Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
            Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
            Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
            Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
            Me.ClientSize = CType(resources.GetObject("$this.ClientSize"), System.Drawing.Size)
            Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
            Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
            Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
            Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
            Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
            Me.MaximumSize = CType(resources.GetObject("$this.MaximumSize"), System.Drawing.Size)
            Me.MinimumSize = CType(resources.GetObject("$this.MinimumSize"), System.Drawing.Size)
            Me.Name = "BaseForm"
            Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.StartPosition = CType(resources.GetObject("$this.StartPosition"), System.Windows.Forms.FormStartPosition)
            Me.Text = resources.GetString("$this.Text")

        End Sub

#End Region

        Private mLastSize As Size
        Protected Overrides Sub OnResize(ByVal e As EventArgs)
            If WindowState = FormWindowState.Normal Then mLastSize = Me.Size
            If ResizeTimer Is Nothing Then ResizeTimer = New System.windows.Forms.Timer
            ResizeTimer.Enabled = True
            ResizeTimer.Stop()
            ResizeTimer.Start()
        End Sub


        Private Sub ResizeTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResizeTimer.Tick
            ResizeTimer.Enabled = False
            MyBase.OnResize(New EventArgs)
        End Sub

        Public Enum WndMsg
            Activate = &H6
            ActivateApp = &H1C
            AfxFirst = &H360
            AfxLast = &H37F
            App = &H8000
            AskClipboardFormatName = &H30C
            CancelJournal = &H4B
            CancelMode = &H1F
            CaptureChanged = &H215
            ChangeClipboardChain = &H30D
            [Char] = &H102
            CharToItem = &H2F
            ChildActivate = &H22
            Clear = &H303
            Close = &H10
            Command = &H111
            Compacting = &H41
            CompareItem = &H39
            ContextMenu = &H7B
            Copy = &H301
            CopyData = &H4A
            Create = &H1
            ControlColorButton = &H135
            ControlColorDialog = &H136
            ControlColorEdit = &H133
            ControlColorListBox = &H134
            ControlColorMsgBox = &H132
            ControlColorScrollBar = &H137
            ControlColorStatic = &H138
            Cut = &H300
            DeadChar = &H103
            DeleteItem = &H2D
            Destroy = &H2
            DestroyClipboard = &H307
            DeviceChange = &H219
            DeviceModeChange = &H1B
            DisplayChange = &H7E
            DrawClipboard = &H308
            DrawItem = &H2B
            DropFiles = &H233
            Enable = &HA
            EndSession = &H16
            EnterIdle = &H121
            EnterMenuLoop = &H211
            EnterSizeMove = &H231
            EraseBackground = &H14
            ExitMenuLoop = &H212
            ExitSizeMove = &H232
            FontChange = &H1D
            GetDialogCode = &H87
            GetFont = &H31
            GetHotkey = &H33
            GetIcon = &H7F
            GetMinMaxInfo = &H24
            GetObject = &H3D
            GetText = &HD
            GetTextLength = &HE
            HandheldFirst = &H358
            HandheldLast = &H35F
            Help = &H53
            Hotkey = &H312
            HScroll = &H114
            HScrollClipboard = &H30E
            IconEraseBackground = &H27
            ImeChar = &H286
            ImeComposition = &H10F
            ImeCompositionFull = &H284
            ImeControl = &H283
            ImeEndComposition = &H10E
            ImeKeyDown = &H290
            ImeKeyLast = &H10F
            ImeKeyUp = &H291
            ImeNotify = &H282
            ImeRequest = &H288
            ImeSelect = &H285
            ImeSetContext = &H281
            ImeStartComposition = &H10D
            InitDialog = &H110
            InitMenu = &H116
            InitMenuPopup = &H117
            InputLanguageChange = &H51
            InputLanguageChangeRequest = &H50
            KeyDown = &H100
            KeyFirst = &H100
            KeyLast = &H108
            KeyUp = &H101
            KillFocus = &H8
            LeftButtonDoubleClick = &H203
            LeftButtonDown = &H201
            LeftButtonUp = &H202
            MiddleButtonDoubleClick = &H209
            MiddleButtonDown = &H207
            MiddleButtonUp = &H208
            MdiActivate = &H222
            MdiCascade = &H227
            MdiCreate = &H220
            MdiDestroy = &H221
            MdiGetActive = &H229
            MdiIconArrange = &H228
            MdiMaximize = &H225
            MdiNext = &H224
            MdiRefreshMenu = &H234
            MdiRestore = &H223
            MdiResetMenu = &H230
            MdiTitle = &H226
            MeasureItem = &H2C
            MenuChar = &H120
            MenuCommand = &H126
            MenuDrag = &H123
            MenuGetObject = &H124
            MenuButtonUp = &H122
            MenuSelect = &H11F
            MouseActivate = &H21
            MouseFirst = &H200
            MouseHover = &H2A1
            MouseLast = &H20A
            MouseLeave = &H2A3
            MouseMove = &H200
            MouseWheel = &H20A
            Move = &H3
            Moving = &H216
            NonClientActivate = &H86
            NonClientCalcSize = &H83
            NonClientCreate = &H81
            NonClientDestroy = &H82
            NonClientHitTest = &H84
            NonClientLeftButtonClick = &HA3
            NonClientLeftButtonDown = &HA1
            NonClientLeftButtonUp = &HA2
            NonClientMiddleButtonDoubleClick = &HA9
            NonClientMiddleButtonDown = &HA7
            NonClientMiddleButtonUp = &HA8
            NonClientMouseMove = &HA0
            NonClientPaint = &H85
            NonClientRightButtonDoubleClick = &HA6
            NonClientRightButtonDown = &HA4
            NonClientRightButtonUp = &HA5
            NextDialogControl = &H28
            NextMenu = &H213
            Notify = &H4E
            NotifyFormat = &H55
            Null = &H0
            Paint = &HF
            PaintClipboard = &H309
            PaintIcon = &H26
            PaletteChanged = &H311
            PaletteIsChanging = &H310
            ParentNotify = &H210
            Paste = &H302
            PenWinFirst = &H380
            PenWinLast = &H38F
            Power = &H48
            PowerBroadcast = &H218
            Print = &H317
            PrintClient = &H318
            QueryDragIcon = &H37
            QueryEndSession = &H11
            QueryNewPalette = &H30F
            QueryOpen = &H13
            QueueSync = &H23
            Quit = &H12
            RightButtonDoubleClick = &H206
            RightButtonDown = &H204
            RightButtonUp = &H205
            RenderAllFormats = &H306
            RenderFormat = &H305
            SetCursor = &H20
            SetFocus = &H7
            SetFont = &H30
            SetHotkey = &H32
            SetIcon = &H80
            SetRedraw = &HB
            SetText = &HC
            SettingChange = &H1A
            ShowWindow = &H18
            Size = &H5
            SizeClipboard = &H30B
            Sizing = &H214
            SpoolerStatus = &H2A
            StyleChanged = &H7D
            StyleChanging = &H7C
            SyncPaint = &H88
            SysChar = &H106
            SysColorChange = &H15
            SysCommand = &H112
            SysDeadChar = &H107
            SysKeyDown = &H104
            SysKeyUp = &H105
            TrainingCard = &H52
            TimeChange = &H1E
            Timer = &H113
            Undo = &H304
            UninitializeMenuPopup = &H125
            User = &H400
            UserChanged = &H54
            VerticalKeyToItem = &H2E
            VerticalScroll = &H115
            VerticalScrollClipboard = &H30A
            WindowPositionChanged = &H47
            WindowPositionChanging = &H46
            WinIniChange = &H1A
        End Enum

        Public Enum ShowWindowCommand
            Hide = 0
            ShowNormal = 1
            Normal = 1
            ShowMinimized = 2
            ShowMaximized = 3
            Maximize = 3
            ShowNoActivate = 4
            Show = 5
            Minimize = 6
            ShowMinNoActive = 7
            ShowNA = 8
            Restore = 9
            ShowDefault = 10
            ForceMinimize = 11
            Max = 11
        End Enum


        <SecurityPermission(SecurityAction.LinkDemand, Flags:=SecurityPermissionFlag.UnmanagedCode)> Protected Overrides Sub WndProc(ByRef m As Message)
            Static PreviousSizeWParam As IntPtr
            If m.Msg = WndMsg.Size Then

                If m.WParam.Equals(IntPtr.Zero) Then
                    ' WORKAROUND - This seems to be the only (easy?) way to capture maximize events
                    OnMaximize()
                    mLastSize = Size
                End If

                If m.WParam.Equals(0) AndAlso PreviousSizeWParam.Equals(1) Then
                    Me.Size = mLastSize
                End If
                PreviousSizeWParam = m.WParam
            End If

            MyBase.WndProc(m)

        End Sub

        Protected Overridable Sub OnMinimize()
            ' Intended for override
        End Sub


        Protected Overridable Sub OnMaximize()
            ' Intended for override
        End Sub



    End Class

End Namespace