Option Strict On

Imports Mbark

Imports Mbark.Sensors
Imports Mbark.Sensors.Builtins

Imports System.Drawing
Imports System.Xml.Serialization
Imports System.Collections.Specialized

Module ConfigurationFileWriterEntryPoint

    Private Const ConfigurationsDirectory As String = "Configurations\"

    Private LeftRightThumbs As SensorTaskCategoryCollection = _
        New SensorTaskCategoryCollection(New SensorTaskCategory() _
        {SensorTaskCategory.LeftSlap, SensorTaskCategory.RightSlap, SensorTaskCategory.ThumbsSlap})

    Private LeftRightIris As SensorTaskCategoryCollection = _
        New SensorTaskCategoryCollection(New SensorTaskCategory() _
        {SensorTaskCategory.LeftIris, SensorTaskCategory.RightIris})


#Region "  Generic Factory Adders  "

    Private Sub AddFaceFactories( _
        ByVal factories As SensorTaskFactoryCollection, _
        ByVal sensor As ISensor, _
        ByVal colors As SensorTaskColors, _
        ByVal config As SensorConfiguration, _
        ByVal reassignableTaskCategories As SensorTaskCategoryCollection)
        With factories
            .CurrentConditions.Add(ConditionFactories.NotCarryingGlasses.Create(.CurrentConditions))
            .CurrentConditions.Add(ConditionFactories.NotWearingGlasses.Create(.CurrentConditions))
            .CurrentConditions.AddEquivalenceClass(PredicateFactories.NotWearingGlassesEquivalence)

            ' Face (non-glasses wearer)
            .Add(FactoryCreators.FaceForNonCarryingGlasses(.CurrentConditions, sensor, 1, colors, Nothing))
            .Factory(.Count - 1).SensorConfiguration = config

            ' Face (glasses wearer; one off, one on)
            .Add(FactoryCreators.FaceWithGlassesOff(.CurrentConditions, sensor, 1, colors, Nothing))
            .Factory(.Count - 1).SensorConfiguration = config

            .Add(FactoryCreators.FaceWithGlassesOn(.CurrentConditions, sensor, 1, colors, Nothing))
            .Factory(.Count - 1).SensorConfiguration = config
        End With
    End Sub

    Private Sub AddIrisFactories( _
         ByVal factories As SensorTaskFactoryCollection, _
         ByVal sensor As ISensor, _
         ByVal colors As SensorTaskColors, _
         ByVal config As SensorConfiguration, _
         ByVal reassignableTaskCategories As SensorTaskCategoryCollection)

        With factories

            .CurrentConditions.Add(ConditionFactories.NotCarryingGlasses.Create(.CurrentConditions))
            .CurrentConditions.Add(ConditionFactories.NotWearingGlasses.Create(.CurrentConditions))
            .CurrentConditions.AddEquivalenceClass(PredicateFactories.NotWearingGlassesEquivalence)

            ' Iris (non-glasses wearer)
            .Add(FactoryCreators.LeftIrisForNonCarryingGlasses(.CurrentConditions, sensor, 1, colors, Nothing))
            .Factory(.Count - 1).SensorConfiguration = config
            .Add(FactoryCreators.RightIrisForNonCarryingGlasses(.CurrentConditions, sensor, 1, colors, Nothing))
            .Factory(.Count - 1).SensorConfiguration = config

            ' Iris (glasses wearer; one off, one on)
            .Add(FactoryCreators.LeftIrisWithGlassesOff(.CurrentConditions, sensor, 1, colors, Nothing))
            .Factory(.Count - 1).SensorConfiguration = config
            .Add(FactoryCreators.RightIrisWithGlassesOff(.CurrentConditions, sensor, 1, colors, Nothing))
            .Factory(.Count - 1).SensorConfiguration = config
            .Add(FactoryCreators.LeftIrisWithGlassesOn(.CurrentConditions, sensor, 1, colors, Nothing))
            .Factory(.Count - 1).SensorConfiguration = config
            .Add(FactoryCreators.RightIrisWithGlassesOn(.CurrentConditions, sensor, 1, colors, Nothing))
            .Factory(.Count - 1).SensorConfiguration = config
        End With
    End Sub
    Private Sub AddLeftSlap( _
        ByVal factories As SensorTaskFactoryCollection, _
        ByVal sensor As ISensor, _
        ByVal scheme As SensorTaskColors, _
        ByVal config As SensorConfiguration, _
        ByVal reassignableCategories As SensorTaskCategoryCollection)

        With factories
            .Add(FactoryCreators.LeftSlap(sensor, 1, scheme, reassignableCategories))
            .Factory(.Count - 1).SensorConfiguration = config
        End With

    End Sub


    Private Sub AddRightSlap( _
        ByVal factories As SensorTaskFactoryCollection, _
        ByVal sensor As ISensor, _
        ByVal scheme As SensorTaskColors, _
        ByVal config As SensorConfiguration, _
        ByVal reassignableCategories As SensorTaskCategoryCollection)

        With factories
            .Add(FactoryCreators.RightSlap(sensor, 1, scheme, reassignableCategories))
            .Factory(.Count - 1).SensorConfiguration = config
        End With
    End Sub

    Private Sub AddThumbsSlap( _
        ByVal factories As SensorTaskFactoryCollection, _
        ByVal sensor As ISensor, _
        ByVal scheme As SensorTaskColors, _
        ByVal config As SensorConfiguration, _
        ByVal reassignableCategories As SensorTaskCategoryCollection)

        With factories
            .Add(FactoryCreators.ThumbsSlap(sensor, 1, scheme, reassignableCategories))
            .Factory(.Count - 1).SensorConfiguration = config
        End With
    End Sub

    Private Sub WriteEmptyConfigurationFile()
        Dim factories As New SensorTaskFactoryCollection
        Dim configurationName As String = "Empty.xml"
        factories.SaveAsXmlFile(ConfigurationsDirectory & configurationName)
    End Sub


#End Region

    Private Sub WriteCrossmatchLeftRightThumbs()

        Dim crossMatch As New Mbark.Sensors.CrossMatchSensor
        Dim factories As New SensorTaskFactoryCollection
        factories.Sensors.Add(crossMatch)


        AddLeftSlap(factories, crossMatch, SensorTaskColorSchemes.Orange, Nothing, LeftRightThumbs)
        AddRightSlap(factories, crossMatch, SensorTaskColorSchemes.Orange, Nothing, LeftRightThumbs)
        AddThumbsSlap(factories, crossMatch, SensorTaskColorSchemes.Orange, Nothing, LeftRightThumbs)

        Dim configurationName As String = "CrossMatch Left-Right-Thumbs.xml"
        factories.SaveAsXmlFile(ConfigurationsDirectory & configurationName)

    End Sub

    Private Sub WriteSmithsHeimannLeftRightThumbs()

        Dim sh As New Mbark.Sensors.SmithsHeimmanSensor
        Dim configurationName As String = "SmithsHeimann Left-Right-Thumbs.xml"

        Dim factories As New SensorTaskFactoryCollection
        Dim shConfig As New SmithsHeimmanConfiguration

        AddLeftSlap(factories, sh, SensorTaskColorSchemes.BlueGreen, shConfig, LeftRightThumbs)
        AddRightSlap(factories, sh, SensorTaskColorSchemes.BlueGreen, shConfig, LeftRightThumbs)
        AddThumbsSlap(factories, sh, SensorTaskColorSchemes.BlueGreen, shConfig, LeftRightThumbs)

        factories.Sensors.Add(sh)
        factories.SaveAsXmlFile(ConfigurationsDirectory & configurationName)
    End Sub

    Private Sub WriteSmithsHeimannRightLeftThumbs()

        Dim sh As New Mbark.Sensors.SmithsHeimmanSensor
        Dim configurationName As String = "SmithsHeimann Right-Left-Thumbs.xml"

        Dim factories As New SensorTaskFactoryCollection
        Dim shConfig As New SmithsHeimmanConfiguration

        AddRightSlap(factories, sh, SensorTaskColorSchemes.BlueGreen, shConfig, LeftRightThumbs)
        AddLeftSlap(factories, sh, SensorTaskColorSchemes.BlueGreen, shConfig, LeftRightThumbs)
        AddThumbsSlap(factories, sh, SensorTaskColorSchemes.BlueGreen, shConfig, LeftRightThumbs)

        factories.Sensors.Add(sh)
        factories.SaveAsXmlFile(ConfigurationsDirectory & configurationName)
    End Sub


    Private Sub WriteAlternatingSensorLeftRightSlap()

        Dim sh As New Mbark.Sensors.SmithsHeimmanSensor
        Dim cm As New Mbark.Sensors.CrossMatchSensor

        Dim configurationName As String = "Left-Right Alternating Sensors.xml"

        Dim factories As New SensorTaskFactoryCollection

        Dim shConfig As New SmithsHeimmanConfiguration

        AddLeftSlap(factories, sh, SensorTaskColorSchemes.Orange, shConfig, LeftRightThumbs)
        AddLeftSlap(factories, cm, SensorTaskColorSchemes.Yellow, Nothing, LeftRightThumbs)
        AddRightSlap(factories, sh, SensorTaskColorSchemes.Orange, shConfig, LeftRightThumbs)
        AddRightSlap(factories, cm, SensorTaskColorSchemes.Yellow, Nothing, LeftRightThumbs)

        factories.Sensors.Add(sh)
        factories.Sensors.Add(cm)
        factories.SaveAsXmlFile(ConfigurationsDirectory & configurationName)

    End Sub

    Private Sub WriteOlympusConfigurationFile()
        Dim olympus As New OlympusCamera
        Dim configurationName As String = "Olympus.xml"
        Dim factories As New SensorTaskFactoryCollection
        AddFaceFactories(factories, olympus, SensorTaskColorSchemes.Purple, New OlympusConfiguration, Nothing)
        factories.Sensors.Add(olympus)
        factories.SaveAsXmlFile(ConfigurationsDirectory & configurationName)
    End Sub

    Private Sub WriteVirtualSensorConfigurationFile()
        Dim vFace As New VirtualFace
        Dim vFinger As New VirtualFingerprint
        Dim vIris As New VirtualIris
        Dim factories As New SensorTaskFactoryCollection

        AddFaceFactories(factories, vFace, SensorTaskColorSchemes.Red, VirtualFaceConfiguration(), Nothing)
        factories.Sensors.Add(vFace)

        AddLeftSlap(factories, vFinger, SensorTaskColorSchemes.BlueGreen, VirtualFingerprintConfiguration, LeftRightThumbs)
        AddRightSlap(factories, vFinger, SensorTaskColorSchemes.BlueGreen, VirtualFingerprintConfiguration, LeftRightThumbs)
        AddThumbsSlap(factories, vFinger, SensorTaskColorSchemes.BlueGreen, VirtualFingerprintConfiguration, LeftRightThumbs)
        factories.Sensors.Add(vFinger)


        factories.Sensors.Add(vIris)

        Dim ConfigurationName As String = "VirtualSensors.xml"
        factories.SaveAsXmlFile(ConfigurationsDirectory & ConfigurationName)
    End Sub

    Private Function VirtualFaceConfiguration() As VirtualSensorsConfiguration
        Dim config As New VirtualSensorsConfiguration
        With config.CaptureOperationBehavior.Wait
            .ShortTime = 150
            .LongTime = .ShortTime + 1000
            .ProbOfLongWait = 0
            config.CaptureOperationBehavior.InvocationStyle = VirtualSensorInvocationStyle.Synchronous
            config.CaptureOperationBehavior.Timeout = .BetweenShortAndLongTime(0.75)
        End With

        With config.DownloadOperationBehavior.Wait
            .ShortTime = 500
            .LongTime = 8000
            .ProcessTime = 3000
            config.DownloadOperationBehavior.InvocationStyle = VirtualSensorInvocationStyle.SynchronouslyWrappedAsynchronous
            config.DownloadOperationBehavior.Timeout = .BetweenShortAndLongTime(0.5)

        End With


        Return config
    End Function

    Private Function VirtualFingerprintConfiguration() As VirtualSensorsConfiguration
        Dim config As New VirtualSensorsConfiguration
        With config.CaptureOperationBehavior.Wait
            .ShortTime = 150
            .LongTime = .ShortTime + 100
            .ProcessTime = 4000
            .ProbOfLongWait = 0
            config.CaptureOperationBehavior.InvocationStyle = VirtualSensorInvocationStyle.Synchronous
            config.CaptureOperationBehavior.Timeout = .BetweenShortAndLongTime(0.75)
        End With

        Return config
    End Function

    Private Function VirtualIrisConfiguration() As VirtualSensorsConfiguration
        Dim config As New VirtualSensorsConfiguration
        With config.CaptureOperationBehavior.Wait
            .ShortTime = 150
            .ProcessTime = 3000
            .LongTime = .ShortTime + 100
            .ProbOfLongWait = 0
            config.CaptureOperationBehavior.InvocationStyle = VirtualSensorInvocationStyle.SynchronouslyWrappedAsynchronous
            config.CaptureOperationBehavior.Timeout = .BetweenShortAndLongTime(0.75)
        End With

        Return config
    End Function




    'Private Sub WriteOKIConfigurationFile()
    '    Dim oki As New Mbark.Sensors.OkiIrisSensor
    '    Dim ConfigurationName As String = "OKI Iris.xml"
    '    Dim factories As New SensorTaskFactories
    '    CreateIrisFactories(factories, oki)
    '    factories.Sensors.Add(oki)
    '    factories.SaveAsXml(ConfigurationsDirectory & ConfigurationName)   
    'End Sub
    'Private Sub WriteLGConfigurationFile()
    '    Dim lg As New Mbark.Sensors.LGIrisSensor
    '    Dim configurationName As String = "LG Iris.xml"
    '    Dim factories As New SensorTaskFactories
    '    CreateIrisFactories(factories, lg)
    '    factories.Sensors.Add(lg)
    '    factories.SaveAsXml(ConfigurationsDirectory & configurationName)
    'End Sub


    'Private Sub writeOlympusConfigurationFile()
    '    Dim olympus As New OlympusCamera
    '    Dim configurationName As String = "Olympus Face.xml"
    '    Dim factories As New SensorTaskFactories
    '    CreateFaceFactories(factories, olympus)
    '    factories.Sensors.Add(olympus)
    '    factories.SaveAsXml(ConfigurationsDirectory & configurationName)
    'End Sub

    'Private Sub WriteCM_OKIconfigurationFile()
    '    Dim oki As New OkiIrisSensor
    '    Dim cm As New CrossMatchSensor
    '    Dim factories As New SensorTaskFactories
    '    factories.Sensors.Add(oki)
    '    CreateIrisFactories(factories, oki)
    '    factories.Sensors.Add(cm)
    '    CreateFingerprintsFactories(factories, cm)

    '    Dim configurationName As String = "CrossMatch and Oki.xml"
    '    factories.SaveAsXml(ConfigurationsDirectory & configurationName)
    'End Sub

    Sub Main()
        WriteEmptyConfigurationFile()
        WriteCrossmatchLeftRightThumbs()
        WriteSmithsHeimannLeftRightThumbs()
        WriteAlternatingSensorLeftRightSlap()
        WriteOlympusConfigurationFile()
        WriteVirtualSensorConfigurationFile()
        'WriteSmithsHeimannConfigurationFile()
        'WriteOKIConfigurationFile()
        'WriteLGConfigurationFile()

        'WriteCM_OKIconfigurationFile()
    End Sub

End Module

