Option Strict On

Imports Mbark.Sensors
Imports Mbark.Security
Imports Mbark.BusinessObjects.EntityClasses
Imports Mbark.BusinessObjects.Support

Imports Mbark.SystemCoordination

Namespace Mbark.BusinessObjects.Support.Adaptors

    Public Module SharedAdaptors

        Public Function CategoryToTaskDescription(ByVal category As SensorTaskCategory) As TaskDescriptionEntity
            Select Case category
                Case SensorTaskCategory.Face
                    Return ValidationClasses.Tasks.Face
                Case SensorTaskCategory.LeftSlap
                    Return ValidationClasses.Tasks.LeftSlap
                Case SensorTaskCategory.RightSlap
                    Return ValidationClasses.Tasks.RightSlap
            End Select
        End Function


        Public Function CommitSensor(ByVal sensor As ISensor) As SensorEntity

            Dim sensorRecord As New SensorEntity
            With sensorRecord
                .SensorId = Guid.NewGuid
                '.Manufacturer = sensor.Manufacturer
                '.ModelNumber = sensor.ModelName
                '.FirmwareVersion = sensor.FirmwareVersion
                '.SerialNumber = sensor.SerialNumber
                '.SensorLabel = sensor.ElectronicLabel
                .CreatedBy = Security.CurrentUserAsContactId
                .LastSelected = DateTime.UtcNow
            End With
            Return CommitIfNew.Sensor(sensorRecord)
        End Function


        Public Function CommitRecording( _
            ByVal session As SessionEntity, _
            ByVal attempt As SensorTaskAttempt, _
            ByVal isRegistration As Boolean _
        ) As RecordingEntity

            Dim recording As New RecordingEntity
            With recording
                .RecordingId = Guid.NewGuid
                .Repetition = CType(attempt.ParentTask.Attempts.IndexOf(attempt), Short)
                .SessionId = session.SessionId
                .RegistrationRecord = isRegistration
                '.StartTime = 
                '.EndTime = 
                .CreatedBy = Security.CurrentUserAsContactId
                .TaskId = CategoryToTaskDescription(attempt.ParentTask.TargetCategory).TaskId
                .OperatorId = Security.CurrentUserAsContactId
                ' FIXME .AssistantId = ' FIXME
                .StationName = System.Net.Dns.GetHostName
            End With
            recording.Save()
            Return recording
        End Function



    End Module

End Namespace