''  ---
''  License
''  ---
''
''  This software was developed at the National Institute of Standards and
''  Technology (NIST) by employees of the Federal Government in the course
''  of their official duties. Pursuant to title 17 Section 105 of the
''  United States Code, this software is not subject to copyright protection
''  and is in the public domain. NIST assumes no responsibility  whatsoever for
''  its use by other parties, and makes no guarantees, expressed or implied,
''  about its quality, reliability, or any other characteristic.
''
''  ---
''  Disclaimer
''  ---
''  This software was developed to facilitate multimodal biometric data collection
''  for the Department of Homeland Security in accordance with Section 303 of the 
''  Border Security Act, codified as 8 U.S.C. 1732.  Specific hardware and software 
''  products identified in this software were used in order to perform the data 
''  collection. In no case does such identification imply recommendation or endorsement 
''  by the National Institute of Standards and Technology, nor does it imply that the 
''  products and equipment identified are necessarily the best available for the purpose.
''

Option Strict On

Imports System.Drawing
Imports System.Windows.Forms

Imports SF = Syncfusion.Windows.Forms.Tools

Imports Mbark.UI
Imports Mbark.SensorMessages
Imports Mbark.UI.GlobalUISettings


Namespace Mbark.Sensors

    Public Class InaccessibleBodyPartsControl
        Inherits RadioGroupBox
        Implements ISensorControlModeChangeConsumer


#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call
            usernew()
        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents InstructionLabel As System.Windows.Forms.Label
        Friend WithEvents MainPanel As System.Windows.Forms.Panel
        Friend WithEvents MainGridLayout As Syncfusion.Windows.Forms.Tools.GridLayout
        Private WithEvents LeftHand As Mbark.Sensors.FingerPickerControl
        Private WithEvents RightHand As Mbark.Sensors.FingerPickerControl
        Private WithEvents Irises As Mbark.Sensors.IrisPickerControl
        Friend WithEvents DisabledLabel As Syncfusion.Windows.Forms.Tools.GradientLabel
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Me.components = New System.ComponentModel.Container
            Me.MainPanel = New System.Windows.Forms.Panel
            Me.Irises = New Mbark.Sensors.IrisPickerControl
            Me.LeftHand = New Mbark.Sensors.FingerPickerControl
            Me.RightHand = New Mbark.Sensors.FingerPickerControl
            Me.MainGridLayout = New Syncfusion.Windows.Forms.Tools.GridLayout(Me.components)
            Me.InstructionLabel = New System.Windows.Forms.Label
            Me.DisabledLabel = New Syncfusion.Windows.Forms.Tools.GradientLabel
            Me.InnerPanel.SuspendLayout()
            Me.MainPanel.SuspendLayout()
            CType(Me.MainGridLayout, System.ComponentModel.ISupportInitialize).BeginInit()
            Me.SuspendLayout()
            '
            'GroupRadioButton
            '
            Me.GroupRadioButton.Name = "GroupRadioButton"
            '
            'InnerPanel
            '
            Me.InnerPanel.BackColor = System.Drawing.SystemColors.Control
            Me.InnerPanel.Controls.Add(Me.MainPanel)
            Me.InnerPanel.Controls.Add(Me.InstructionLabel)
            Me.InnerPanel.Name = "InnerPanel"
            Me.InnerPanel.Size = New System.Drawing.Size(786, 485)
            '
            'MainPanel
            '
            Me.MainPanel.BackColor = System.Drawing.SystemColors.Control
            Me.MainPanel.Controls.Add(Me.Irises)
            Me.MainPanel.Controls.Add(Me.LeftHand)
            Me.MainPanel.Controls.Add(Me.RightHand)
            Me.MainPanel.Dock = System.Windows.Forms.DockStyle.Fill
            Me.MainPanel.Location = New System.Drawing.Point(0, 0)
            Me.MainPanel.Name = "MainPanel"
            Me.MainPanel.Size = New System.Drawing.Size(786, 461)
            Me.MainPanel.TabIndex = 10
            '
            'Irises
            '
            Me.Irises.BackColor = System.Drawing.SystemColors.Control
            Me.Irises.Enabled = False
            Me.Irises.LeftEyeOnly = False
            Me.Irises.Location = New System.Drawing.Point(1, 0)
            Me.Irises.Name = "Irises"
            Me.MainGridLayout.SetParticipateInLayout(Me.Irises, True)
            Me.Irises.RightEyeOnly = False
            Me.Irises.Size = New System.Drawing.Size(259, 461)
            Me.Irises.TabIndex = 2
            '
            'LeftHand
            '
            Me.LeftHand.BackColor = System.Drawing.SystemColors.Control
            Me.LeftHand.CausesValidation = False
            Me.LeftHand.DockPadding.Right = 292
            Me.LeftHand.DockPadding.Top = 10
            Me.LeftHand.Enabled = False
            Me.LeftHand.IsLeft = True
            Me.LeftHand.LeftSlapOnly = False
            Me.LeftHand.Location = New System.Drawing.Point(264, 0)
            Me.LeftHand.Name = "LeftHand"
            Me.MainGridLayout.SetParticipateInLayout(Me.LeftHand, True)
            Me.LeftHand.RightSlapOnly = False
            Me.LeftHand.Size = New System.Drawing.Size(259, 461)
            Me.LeftHand.TabIndex = 1
            Me.LeftHand.ThumbsOnly = False
            '
            'RightHand
            '
            Me.RightHand.BackColor = System.Drawing.SystemColors.Control
            Me.RightHand.CausesValidation = False
            Me.RightHand.DockPadding.Top = 10
            Me.RightHand.Enabled = False
            Me.RightHand.IsLeft = False
            Me.RightHand.LeftSlapOnly = False
            Me.RightHand.Location = New System.Drawing.Point(527, 0)
            Me.RightHand.Name = "RightHand"
            Me.MainGridLayout.SetParticipateInLayout(Me.RightHand, True)
            Me.RightHand.RightSlapOnly = False
            Me.RightHand.Size = New System.Drawing.Size(259, 461)
            Me.RightHand.TabIndex = 0
            Me.RightHand.ThumbsOnly = False
            '
            'MainGridLayout
            '
            Me.MainGridLayout.Columns = 3
            Me.MainGridLayout.ContainerControl = Me.MainPanel
            Me.MainGridLayout.HGap = 4
            Me.MainGridLayout.Rows = 1
            '
            'InstructionLabel
            '
            Me.InstructionLabel.BackColor = System.Drawing.SystemColors.Control
            Me.InstructionLabel.Dock = System.Windows.Forms.DockStyle.Bottom
            Me.InstructionLabel.Location = New System.Drawing.Point(0, 461)
            Me.InstructionLabel.Name = "InstructionLabel"
            Me.InstructionLabel.Size = New System.Drawing.Size(786, 24)
            Me.InstructionLabel.TabIndex = 9
            Me.InstructionLabel.Text = "Label"
            Me.InstructionLabel.TextAlign = System.Drawing.ContentAlignment.BottomCenter
            '
            'DisabledLabel
            '
            Me.DisabledLabel.BackColor = System.Drawing.Color.Black
            Me.DisabledLabel.BackgroundColor = New Syncfusion.Drawing.BrushInfo(Syncfusion.Drawing.PatternStyle.BackwardDiagonal, System.Drawing.SystemColors.ControlLightLight, System.Drawing.SystemColors.ControlLight)
            Me.DisabledLabel.BorderSides = CType((((System.Windows.Forms.Border3DSide.Left Or System.Windows.Forms.Border3DSide.Top) _
                        Or System.Windows.Forms.Border3DSide.Right) _
                        Or System.Windows.Forms.Border3DSide.Bottom), System.Windows.Forms.Border3DSide)
            Me.DisabledLabel.BorderStyle = System.Windows.Forms.Border3DStyle.Etched
            Me.DisabledLabel.Location = New System.Drawing.Point(298, 208)
            Me.DisabledLabel.Name = "DisabledLabel"
            Me.DisabledLabel.Size = New System.Drawing.Size(196, 104)
            Me.DisabledLabel.TabIndex = 14
            Me.DisabledLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
            '
            'InaccessibleBodyPartsControl
            '
            Me.Controls.Add(Me.DisabledLabel)
            Me.Name = "InaccessibleBodyPartsControl"
            Me.Size = New System.Drawing.Size(792, 520)
            Me.Controls.SetChildIndex(Me.DisabledLabel, 0)
            Me.InnerPanel.ResumeLayout(False)
            Me.MainPanel.ResumeLayout(False)
            CType(Me.MainGridLayout, System.ComponentModel.ISupportInitialize).EndInit()
            Me.ResumeLayout(False)

        End Sub

#End Region

        Private Sub UserNew()
            AddHandler GroupRadioButton.CheckedChanged, AddressOf HandleRadioButtonChecked
        End Sub

        Private mBodyPartswire As BodyParts
        Public Sub WireBodyPartsList(ByVal parts As BodyParts)
            mBodyPartswire = parts
            LeftHand.WireBodyPartList(parts)
            RightHand.WireBodyPartList(parts)
            Irises.WireBodyPartList(parts)
        End Sub

        Public ReadOnly Property BodyPartsWire() As BodyParts
            Get
                Return mBodyPartswire
            End Get

        End Property


        Private mWithLeftHand As Boolean
        Public Property WithLeftHand() As Boolean
            Get
                Return mWithLeftHand
            End Get
            Set(ByVal value As Boolean)
                mWithLeftHand = value
                MainGridLayout.SetParticipateInLayout(LeftHand, value)
                LeftHand.Visible = value
                Refresh()
            End Set
        End Property

        Private mWithRightHand As Boolean
        Public Property WithRightHand() As Boolean
            Get
                Return mWithRightHand
            End Get
            Set(ByVal value As Boolean)
                mWithRightHand = value
                MainGridLayout.SetParticipateInLayout(RightHand, value)
                RightHand.Visible = value
                Refresh()
            End Set
        End Property

        Private mWithIrises As Boolean
        Public Property WithIrises() As Boolean
            Get
                Return mWithIrises
            End Get
            Set(ByVal value As Boolean)
                mWithIrises = value
                MainGridLayout.SetParticipateInLayout(Irises, value)
                Irises.Visible = value
                Refresh()
            End Set
        End Property

        Private Sub HandleRadioButton(ByVal sender As Object, ByVal e As EventArgs)

        End Sub

        Public Sub BindFromWireToControl()
            LeftHand.BindFromWireToControl()
            RightHand.BindFromWireToControl()
            Irises.BindFromWireToControl()
        End Sub


        Private Const UndocumentedPaddingNeededToPreventWordWrapPadding As Integer = 8
        Public Overrides Sub AutoSize(ByVal graphics As System.Drawing.Graphics)
            MyBase.AutoSize(graphics)


            'RecursiveSuspendLayout(Me)
            InstructionLabel.Font = Defaults.Fonts.InstructionLabel
            DisabledLabel.Font = Defaults.Fonts.Small
            AutoHeight.Label(graphics, InstructionLabel)

            Dim columns As Integer

            ' Compute the minimum height & width
            mMinimumHeight = 0
            mMinimumWidth = 0

            RightHand.AutoSize(graphics)
            LeftHand.AutoSize(graphics)
            Irises.AutoSize(graphics)

            Dim minPanelWidth As Integer = 0

            Dim leftMin As Integer
            If WithLeftHand Then
                leftMin = LeftHand.MinimumHeight
                minPanelWidth += LeftHand.MinimumWidth
                columns += 1
            End If

            Dim rightMin As Integer
            If WithRightHand Then
                rightMin = RightHand.MinimumHeight
                minPanelWidth += RightHand.MinimumWidth
                columns += 1
            End If

            Dim irisesMin As Integer
            If WithIrises Then
                irisesMin = Irises.MinimumHeight
                minPanelWidth += Irises.MinimumWidth
                columns += 1
            End If

            Dim instructionLabelWidth As Integer = _
                StringWidthInPixels(graphics, InstructionLabel.Font, InstructionLabel.Text) + _
                PaddingConstants.Undocumented.PreventLabelWordWrap

            If MyBase.WithFancyHeader Then InnerPanel.DockPadding.Top = 2

            mMinimumWidth = Math.Max(mMinimumWidth, MyBase.MinimumWidth)
            mMinimumWidth = Math.Max(mMinimumWidth, minPanelWidth)
            mMinimumWidth = Math.Max(mMinimumWidth, instructionLabelWidth)
            mMinimumWidth += TotalLeftPadding + TotalRightPadding

            MainGridLayout.Columns = columns

            mMinimumHeight = Math.Max(mMinimumHeight, leftMin)
            mMinimumHeight = Math.Max(mMinimumHeight, rightMin)
            mMinimumHeight = Math.Max(mMinimumHeight, irisesMin)
            mMinimumHeight += TotalTopPadding + TotalBottomPadding + InstructionLabel.Height

            UI.AutoSize.Label(graphics, DisabledLabel)
            DisabledLabel.Width = CInt(DisabledLabel.Width * 1.2!)
            DisabledLabel.Height = CInt(DisabledLabel.Height * 1.0!)

            Dim disabledLabelX As Integer = CInt(Me.Width / 2.0! - DisabledLabel.Width / 2.0!)
            Dim disabledlabely As Integer = CInt(Me.Height / 2.0! - DisabledLabel.Height / 2.0!)
            DisabledLabel.Location = New Point(disabledLabelX, disabledlabely)

            RefreshPanels()
            ' RecursiveResumeLayout(Me)




        End Sub

        Public Overrides Sub Refresh()
            MyBase.Refresh()
            If WithRadioButton Then
                LeftHand.Enabled = GroupRadioButton.Checked
                RightHand.Enabled = GroupRadioButton.Checked
                Irises.Enabled = GroupRadioButton.Checked
            Else
                LeftHand.Enabled = True
                RightHand.Enabled = True
                Irises.Enabled = True
            End If
            LeftHand.Refresh()
            RightHand.Refresh()
            Irises.Refresh()
            If Not NearestForm Is Nothing Then AutoSize(NearestForm.CreateGraphics)
        End Sub

        Private Sub HandleRadioButtonChecked(ByVal sender As System.Object, ByVal e As System.EventArgs)
            Refresh()
        End Sub

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)
            If InDesignMode(Me) Then Return

            SubscribeToParentSensorControlModeChangeEvents(Me, True)

            ' If there's a control mode provider, then disable the controls; they'll be enabled when appropriate
            If SensorControlModeProvider Is Nothing Then
                LeftHand.Enabled = False
                RightHand.Enabled = False
                Irises.Enabled = False
            Else
                LeftHand.Enabled = True
                RightHand.Enabled = True
                Irises.Enabled = True
            End If

            HeaderText = "Injuries"  ' i18n

            InstructionLabel.Text = Messages.ChecksIndicateInjuries

            AutoSize(NearestForm.CreateGraphics)
            Refresh()
        End Sub

        Protected Overrides Sub OnLayout(ByVal e As LayoutEventArgs)
            MyBase.OnLayout(e)
            If Not NearestForm Is Nothing Then AutoSize(NearestForm.CreateGraphics)
        End Sub

        Private mMinimumHeight As Integer
        Public Overrides ReadOnly Property MinimumHeight() As Integer
            Get
                Return mMinimumHeight
            End Get
        End Property

        Private mMinimumWidth As Integer
        Public Overrides ReadOnly Property MinimumWidth() As Integer
            Get
                Return mMinimumWidth
            End Get
        End Property

        Public Sub ReflectTask(ByVal task As SensorTask)

            Select Case task.TargetCategory
                Case SensorTaskCategory.LeftSlap
                    WithLeftHand = True
                    WithRightHand = False
                    WithIrises = False
                    LeftHand.LeftSlapOnly = True
                Case SensorTaskCategory.RightSlap
                    WithLeftHand = False
                    WithRightHand = True
                    WithIrises = False
                    RightHand.RightSlapOnly = True
                Case SensorTaskCategory.ThumbsSlap
                    WithLeftHand = True
                    WithRightHand = True
                    WithIrises = False
                    LeftHand.ThumbsOnly = True
                    RightHand.ThumbsOnly = True
                Case SensorTaskCategory.LeftIris
                    WithLeftHand = False
                    WithRightHand = False
                    WithIrises = True
                    Irises.LeftEyeOnly = True
                Case SensorTaskCategory.RightIris
                    WithLeftHand = False
                    WithRightHand = False
                    WithIrises = True
                    Irises.RightEyeOnly = True
                Case SensorTaskCategory.Face
                    WithLeftHand = False
                    WithRightHand = False
                    WithIrises = False
                Case Else
                    WithLeftHand = True
                    WithRightHand = True
                    WithIrises = True
            End Select


        End Sub



        Public Sub HandleSensorControlModeChange(ByVal sender As Object, ByVal e As SensorControlModeChangeEventArgs) _
        Implements ISensorControlModeChangeConsumer.HandleSensorControlModeChange

            If SensorControlModeSets.InaccessibleBodyPartsChangeable.Contains(e.NewMode) Then
                LeftHand.Enabled = True
                RightHand.Enabled = True
                Irises.Enabled = True
            Else
                LeftHand.Enabled = False
                RightHand.Enabled = False
                Irises.Enabled = False
            End If

        End Sub

        Private mSensorControlModeProvider As ISensorControlModeProvider
        Public ReadOnly Property SensorControlModeProvider() As ISensorControlModeProvider _
        Implements ISensorControlModeChangeConsumer.SensorControlModeProvider
            Get
                If mSensorControlModeProvider Is Nothing Then
                    mSensorControlModeProvider = DirectCast(FindNearestSensorControlModeProviderParent(Me), ISensorControlModeProvider)
                End If
                Return mSensorControlModeProvider
            End Get
        End Property

        'reset all picker control when starting new session
        Public Sub ResetControl()
            RightHand.ResetFingerPickerControl()
            LeftHand.ResetFingerPickerControl()
            Irises.ResetIrisPickerControl()
        End Sub

        Protected Overrides Sub OnEnabledChanged(ByVal e As EventArgs)
            MyBase.OnEnabledChanged(e)
            RefreshPanels()
        End Sub

        Private Sub RefreshPanels()
            LeftHand.Enabled = MyBase.Enabled
            RightHand.Enabled = MyBase.Enabled
            Irises.Enabled = MyBase.Enabled

            If DisabledLabel.Text = String.Empty Then
                DisabledLabel.Visible = False
            Else
                DisabledLabel.Visible = Not MyBase.Enabled
                DisabledLabel.Enabled = Not MyBase.Enabled
                DisabledLabel.Refresh()
            End If
        End Sub

        Public Property DisabledLabelText() As String
            Get
                Return DisabledLabel.Text
            End Get
            Set(ByVal value As String)
                If value <> DisabledLabel.Text Then
                    If Not NearestForm Is Nothing Then AutoSize(NearestForm.CreateGraphics)
                    DisabledLabel.Text = value
                End If
            End Set
        End Property

        Public Property DisabledLabelColor() As Color
            Get
                Return DisabledLabel.BackColor
            End Get
            Set(ByVal value As Color)
                DisabledLabel.BackColor = value
            End Set
        End Property


    End Class

End Namespace