''  ---
''  License
''  ---
''
''  This software was developed at the National Institute of Standards and
''  Technology (NIST) by employees of the Federal Government in the course
''  of their official duties. Pursuant to title 17 Section 105 of the
''  United States Code, this software is not subject to copyright protection
''  and is in the public domain. NIST assumes no responsibility  whatsoever for
''  its use by other parties, and makes no guarantees, expressed or implied,
''  about its quality, reliability, or any other characteristic.
''
''  ---
''  Disclaimer
''  ---
''  This software was developed to facilitate multimodal biometric data collection
''  for the Department of Homeland Security in accordance with Section 303 of the 
''  Border Security Act, codified as 8 U.S.C. 1732.  Specific hardware and software 
''  products identified in this software were used in order to perform the data 
''  collection. In no case does such identification imply recommendation or endorsement 
''  by the National Institute of Standards and Technology, nor does it imply that the 
''  products and equipment identified are necessarily the best available for the purpose.
''

Option Strict On

Imports System.Drawing
Imports System.Windows.Forms

Imports SF = Syncfusion.Windows.Forms.Tools

Imports Mbark.UI

Namespace Mbark.Sensors


    Public Class BasePickerControl
        Inherits System.Windows.Forms.UserControl
        Implements IAutosizable

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call

        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents FooterLabel As System.Windows.Forms.Label
        Friend WithEvents MainPictureBox As Mbark.UI.SmoothPictureBox
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Me.FooterLabel = New System.Windows.Forms.Label
            Me.MainPictureBox = New Mbark.UI.SmoothPictureBox
            Me.SuspendLayout()
            '
            'FooterLabel
            '
            Me.FooterLabel.Dock = System.Windows.Forms.DockStyle.Bottom
            Me.FooterLabel.Location = New System.Drawing.Point(0, 127)
            Me.FooterLabel.Name = "FooterLabel"
            Me.FooterLabel.Size = New System.Drawing.Size(150, 23)
            Me.FooterLabel.TabIndex = 0
            Me.FooterLabel.Text = "FOOTER"
            Me.FooterLabel.TextAlign = System.Drawing.ContentAlignment.TopCenter
            '
            'MainPictureBox
            '
            Me.MainPictureBox.Backwards = False
            Me.MainPictureBox.DisabledImage = Nothing
            Me.MainPictureBox.Dock = System.Windows.Forms.DockStyle.Fill
            Me.MainPictureBox.EnabledImage = Nothing
            Me.MainPictureBox.Location = New System.Drawing.Point(0, 0)
            Me.MainPictureBox.Name = "MainPictureBox"
            Me.MainPictureBox.Size = New System.Drawing.Size(150, 127)
            Me.MainPictureBox.TabIndex = 2
            Me.MainPictureBox.WithBorder = False
            '
            'BasePickerControl
            '
            Me.Controls.Add(Me.MainPictureBox)
            Me.Controls.Add(Me.FooterLabel)
            Me.Name = "BasePickerControl"
            Me.ResumeLayout(False)

        End Sub

#End Region

        Private mEnabledImage As Bitmap
        Private mDisabledImage As Bitmap

        Protected Overrides Sub OnLoad(ByVal e as EventArgs)
            MyBase.OnLoad(e)
            If InDesignMode(Me) Then Return

            MainPictureBox.EnabledImage = mEnabledImage
            MainPictureBox.DisabledImage = mDisabledImage
            MainPictureBox.Refresh()

            LayoutCheckboxes()
            BindFromWireToControl()


        End Sub

        Protected Overrides Sub OnLayout(ByVal e as LayoutEventArgs)
            MyBase.OnLayout(e)
            If Not NearestForm Is Nothing Then AutoSize(NearestForm.CreateGraphics)
            LayoutCheckboxes()
        End Sub

        'Protected Property PartImage() As Bitmap
        '    Get
        '        Return mEnabledImage
        '    End Get
        '    Set(ByVal value As Bitmap)
        '        mEnabledImage = value
        '        mDisabledImage = New Bitmap(value)
        '        Watermarkify(mDisabledImage, 2)
        '    End Set
        'End Property

        Protected Sub PartImages(ByVal enabledImage As Bitmap, ByVal disabledImage As Bitmap)
            mEnabledImage = enabledImage
            mDisabledImage = disabledImage
        End Sub

        Protected Friend Overridable Sub BindFromWireToControl()
            Throw New Mbark.MissingSpecializationException("BindFromWireToControl")
        End Sub

        Protected Overridable Sub LayoutCheckboxes()
            If Not InDesignMode(Me) Then Throw New Mbark.MissingSpecializationException("LayoutCheckboxes")
        End Sub

        Protected Overridable Sub RefreshCheckboxes()
            If Not InDesignMode(Me) Then Throw New Mbark.MissingSpecializationException("RefreshCheckboxes")
        End Sub

        Private mBodyPartsWire As BodyParts
        Public Sub WireBodyPartList(ByVal parts As BodyParts)
            mBodyPartsWire = parts
            BindFromWireToControl()
        End Sub
        Protected ReadOnly Property BodyPartsWire() As BodyParts
            Get
                Return mBodyPartsWire
            End Get
        End Property

        Public Overridable Sub AutoSize(ByVal graphics As System.Drawing.Graphics) Implements UI.IAutosizable.AutoSize
            SuspendLayout()
            FooterLabel.Font = Mbark.UI.GlobalUISettings.Defaults.Fonts.SmallBold
            MainPictureBox.Refresh()
            RefreshCheckboxes()
            Mbark.UI.AutoHeight.Label(graphics, FooterLabel)
            ResumeLayout()
        End Sub

        Protected Overrides Sub OnEnabledChanged(ByVal e As EventArgs)
            MyBase.OnEnabledChanged(e)
            MainPictureBox.Enabled = MyBase.Enabled
            MainPictureBox.Refresh()
        End Sub


        Public ReadOnly Property MinimumHeight() As Integer Implements UI.IAutosizable.MinimumHeight
            Get
                If MainPictureBox.ImageAspectRatio = 0 Then Return 0
                Return CInt(MinimumWidth / MainPictureBox.ImageAspectRatio + FooterLabel.Height) + _
                DockPadding.Top + DockPadding.Bottom
            End Get
        End Property

        Private mMinimumWidth As Integer = 80
        Public ReadOnly Property MinimumWidth() As Integer Implements UI.IAutosizable.MinimumWidth
            Get
                Return mMinimumWidth + DockPadding.Left + DockPadding.Right
            End Get
        End Property

        Public ReadOnly Property NearestForm() As System.Windows.Forms.Form Implements UI.IAutosizable.NearestForm
            Get
                Return FindNearestForm(Me)
            End Get
        End Property

        'Public Overrides Sub Refresh()
        '    MyBase.Refresh()
        '    MainPictureBox.Enabled = Me.Enabled
        '    MainPictureBox.Refresh()
        'End Sub

    End Class

End Namespace