'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 


Option Strict On


Imports System.Drawing
Imports System.Globalization
Imports System.Windows.Forms

Imports Mbark.UI
Imports Mbark.UI.GlobalUISettings
Imports Mbark.SensorMessages

Namespace Mbark.Sensors

    Public Class AttemptPicker
        Inherits RadioGroupBox
        Implements IHasTabList

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call

        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents FlowLayout As Syncfusion.Windows.Forms.Tools.FlowLayout
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Me.components = New System.ComponentModel.Container
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(AttemptPicker))
            Me.FlowLayout = New Syncfusion.Windows.Forms.Tools.FlowLayout(Me.components)
            CType(Me.FlowLayout, System.ComponentModel.ISupportInitialize).BeginInit()
            '
            'InnerPanel
            '
            Me.InnerPanel.BackColor = System.Drawing.SystemColors.Control
            Me.InnerPanel.Dock = CType(resources.GetObject("InnerPanel.Dock"), System.Windows.Forms.DockStyle)
            Me.InnerPanel.ForeColor = System.Drawing.SystemColors.ControlText
            Me.InnerPanel.Location = CType(resources.GetObject("InnerPanel.Location"), System.Drawing.Point)
            Me.InnerPanel.Name = "InnerPanel"
            Me.InnerPanel.Size = CType(resources.GetObject("InnerPanel.Size"), System.Drawing.Size)
            '
            'GroupRadioButton
            '
            Me.GroupRadioButton.Name = "GroupRadioButton"
            '
            'FlowLayout
            '
            Me.FlowLayout.Alignment = CType(resources.GetObject("FlowLayout.Alignment"), Syncfusion.Windows.Forms.Tools.FlowAlignment)
            Me.FlowLayout.AutoLayout = False
            Me.FlowLayout.ContainerControl = Me.InnerPanel
            Me.FlowLayout.CustomLayoutBounds = CType(resources.GetObject("FlowLayout.CustomLayoutBounds"), System.Drawing.Rectangle)
            Me.FlowLayout.HGap = CType(resources.GetObject("FlowLayout.HGap"), Integer)
            Me.FlowLayout.LayoutMode = CType(resources.GetObject("FlowLayout.LayoutMode"), Syncfusion.Windows.Forms.Tools.FlowLayoutMode)
            Me.FlowLayout.ReverseRows = CType(resources.GetObject("FlowLayout.ReverseRows"), Boolean)
            Me.FlowLayout.VGap = CType(resources.GetObject("FlowLayout.VGap"), Integer)
            '
            'AttemptPicker
            '
            Me.AccessibleDescription = resources.GetString("$this.AccessibleDescription")
            Me.AccessibleName = resources.GetString("$this.AccessibleName")
            Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
            Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
            Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
            Me.BackColor = System.Drawing.SystemColors.Control
            Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
            Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
            Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
            Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
            Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
            Me.Name = "AttemptPicker"
            Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.Size = CType(resources.GetObject("$this.Size"), System.Drawing.Size)
            CType(Me.FlowLayout, System.ComponentModel.ISupportInitialize).EndInit()

        End Sub

#End Region

        Private mAttemptBoxes As New ArrayList
        Private mAttemptToBox As New Hashtable
        Private mTaskWire As SensorTask

        Private mConditionsWire As ConditionCollection
        Private mInaccessibleBodyPartsWire As BodyParts


        Public Sub WireConditions(ByVal conditions As ConditionCollection)
            mConditionsWire = conditions
            PopulateControls()
        End Sub

        Public Sub WireInaccessibleBodyParts(ByVal parts As BodyParts)
            mInaccessibleBodyPartsWire = parts
        End Sub

        Public Sub WireTask(ByVal task As SensorTask)
            mTaskWire = task
        End Sub

        Private Delegate Sub PickerRefresher()
        Public Sub RefreshPicker()
            If InvokeRequired Then
                Me.Invoke(New PickerRefresher(AddressOf RefreshPickerImplementation))
            Else
                RefreshPickerImplementation()
            End If
        End Sub
        Private mTabList As ArrayList
        Private Sub PopulateControls()

            If mTaskWire Is Nothing Then
                mAttemptToBox.Clear()
                For i As Integer = 0 To mAttemptBoxes.Count - 1
                    DirectCast(mAttemptBoxes(i), AttemptPictureBox).ClearPicture()
                Next
                mAttemptBoxes.Clear()
                ClearInnerPanelControls()
                Return
            End If

            SuspendLayout()
            MyBase.InnerPanel.Visible = False
            Dim attempts As SensorTaskAttemptCollection = mTaskWire.Attempts

            While mAttemptBoxes.Count < attempts.Count
                Dim apb As New AttemptPictureBox
                apb.Visible = False
                AddHandler apb.EditRequested, AddressOf HandleEditRequested
                mAttemptBoxes.Add(apb)
            End While


            ' Remove stale attempts from the hashtable

            Dim en As IEnumerator = mAttemptToBox.Keys.GetEnumerator
            Dim toRemove As New ArrayList
            Dim toDispose As New ArrayList
            While en.MoveNext
                Dim attempt As SensorTaskAttempt = DirectCast(en.Current, SensorTaskAttempt)
                If Not attempts.Contains(attempt) Then
                    Dim apb As AttemptPictureBox = DirectCast(mAttemptToBox(attempt), AttemptPictureBox)
                    apb.Visible = False
                    apb.CaptionLabel.Text = String.Empty
                    apb.ClearPicture()
                    toRemove.Add(attempt)
                    toDispose.Add(apb)
                End If
            End While

            For i As Integer = 0 To toRemove.Count - 1
                mAttemptToBox.Remove(toRemove(i))
            Next

            ' Populate new attempts into the hashtable
            For i As Integer = 0 To attempts.Count - 1

                If Not mAttemptToBox.ContainsKey(attempts(i)) Then
                    If Not attempts(i).ThumbnailImage Is Nothing Then
                        Dim apbNotYetInMap As AttemptPictureBox = DirectCast(mAttemptBoxes(i), AttemptPictureBox)
                        apbNotYetInMap.Visible = False
                        apbNotYetInMap.WireAttempt(attempts(i))
                        InnerPanel.Controls.Add(apbNotYetInMap)
                        mAttemptToBox(attempts(i)) = apbNotYetInMap
                    End If
                End If

                ' Correctly order the picture boxes
                Dim apb As AttemptPictureBox = DirectCast(mAttemptToBox(attempts(i)), AttemptPictureBox)
                If Not apb Is Nothing Then
                    apb.SendToBack()
                End If

            Next

            mTabList = New ArrayList
            For i As Integer = 0 To attempts.Count - 1
                Dim apb As AttemptPictureBox = DirectCast(mAttemptToBox(attempts(i)), AttemptPictureBox)
                'If Not apb Is Nothing Then apb.Visible = True
                If Not apb Is Nothing Then
                    apb.Visible = True
                    If Not mTabList.Contains(apb.EditButton) Then
                        mTabList.Add(apb.EditButton)
                    End If
                End If
            Next

            MyBase.InnerPanel.Visible = True
            ResumeLayout()


        End Sub

        Public Sub Clear()

            ClearInnerPanelControls()

            mAttemptToBox.Clear()
            mAttemptBoxes.Clear()
            mTaskWire = Nothing
            RefreshPicker()
        End Sub

        Public Overrides Sub RefreshAutomaticLayout(ByVal graphics As Graphics)
            MyBase.RefreshAutomaticLayout(graphics)

            InnerPanel.Visible = False
            If mTaskWire Is Nothing Then Return

            RecursiveSuspendLayout(Me)

            ' Determine the height and width of each AttemptPictureBox
            Dim abpHeight As Integer = InnerPanel.Height - FlowLayout.VGap
            Dim abpWidth As Integer

            If mAttemptToBox.Count > 0 Then
                abpWidth = CInt(InnerPanel.Width / mAttemptToBox.Count) - PaddingConstants.Undocumented.PreventFlowLayoutWrap - FlowLayout.HGap
            End If
            'If attempts.Count > 0 Then
            '    abpWidth = CInt(InnerPanel.Width / attempts.Count) - PaddingConstants.Undocumented.PreventFlowLayoutWrap - FlowLayout.HGap
            'End If

            ' Resize and label the boxes
            Dim en As IEnumerator = mAttemptToBox.Keys.GetEnumerator

            While en.MoveNext
                Dim attempt As SensorTaskAttempt = DirectCast(en.Current, SensorTaskAttempt)
                Dim abp As AttemptPictureBox = DirectCast(mAttemptToBox(attempt), AttemptPictureBox)
                If Not mAttemptToBox(attempt) Is Nothing Then
                    abp.RefreshLabel(mConditionsWire, mInaccessibleBodyPartsWire)
                    abp.RefreshAutomaticLayout(graphics)
                    abp.Height = abpHeight
                    abp.Width = abpWidth
                End If
            End While

            ' For some reason, we need a second pass at the autosize
            en = mAttemptToBox.Keys.GetEnumerator
            While en.MoveNext
                Dim attempt As SensorTaskAttempt = DirectCast(en.Current, SensorTaskAttempt)
                If Not mAttemptToBox(attempt) Is Nothing Then
                    Dim abp As AttemptPictureBox = DirectCast(mAttemptToBox(attempt), AttemptPictureBox)
                    abp.RefreshAutomaticLayout(graphics)
                End If
            End While

            InnerPanel.Visible = True

            FlowLayout.LayoutContainer()
            RecursiveResumeLayout(Me)



        End Sub

        Protected Overrides Sub OnLayout(ByVal levent As LayoutEventArgs)
            MyBase.OnLayout(levent)
            If Not NearestForm Is Nothing Then
                Dim g As Graphics = NearestForm.CreateGraphics
                RefreshAutomaticLayout(g)
                g.Dispose()
            End If
        End Sub


        Public Sub RefreshPickerImplementation()
            If NearestForm Is Nothing Then Return
            PopulateControls()

            RefreshAutomaticLayout(NearestForm.CreateGraphics)
        End Sub

        Public ReadOnly Property TaskWire() As SensorTask
            Get
                Return mTaskWire
            End Get
        End Property

        Public Event EditRequested(ByVal sender As Object, ByVal e As EditRequestedEventArgs)

        Private Sub HandleEditRequested(ByVal sender As Object, ByVal e As EditRequestedEventArgs)
            RaiseEvent EditRequested(sender, e)
        End Sub

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)
            HeaderText = "Captured Images" ' i18n
        End Sub

        Private mAttemptPickerBoxesEnabled As Boolean
        Public Property AttemptPickerBoxesEnabled() As Boolean
            Get
                Return mAttemptPickerBoxesEnabled
            End Get
            Set(ByVal value As Boolean)
                mAttemptPickerBoxesEnabled = value
                For i As Integer = 0 To mAttemptBoxes.Count - 1
                    With DirectCast(mAttemptBoxes(i), AttemptPictureBox)
                        .Enabled = mAttemptPickerBoxesEnabled
                        .Refresh()
                    End With
                Next
            End Set
        End Property

        Public ReadOnly Property TabList() As ArrayList Implements IHasTabList.TabList
            Get
                Return mTabList
            End Get
        End Property
        Private Sub ClearInnerPanelControls()
            For i As Integer = InnerPanel.Controls.Count - 1 To 0 Step -1
                InnerPanel.Controls(i).Dispose()
            Next
            InnerPanel.Controls.Clear()
        End Sub
    End Class


End Namespace
