Option Strict On

Imports Mbark
Imports Mbark.Sensors

Public Class VirtualSensorController
    Inherits Mbark.Sensors.BaseSensorController

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        UserNew()
    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container
        Me.Text = "VirtualSensorController"
    End Sub

#End Region

    Private Sub UserNew()
        Me.AutomaticallyStartNewTaskSets = False
    End Sub
    Protected Overrides Sub OnLoad(ByVal e As EventArgs)
        MyBase.OnLoad(e)
    End Sub

    Protected Overrides Sub OnClosing(ByVal e As System.ComponentModel.CancelEventArgs)
        MyBase.OnClosing(e)
    End Sub

    Public WithEvents mScenarioPicker As ScenarioPicker
    Protected Overrides Sub OnAwaitingStartOfNewTaskSet()
        mScenarioPicker = New ScenarioPicker
        AddHandler mScenarioPicker.GoButton.Click, AddressOf ScenarioPickerGoButton_Click
        'AddHandler mScenarioPicker.Closing, AddressOf ScenarioPickerOnClose
        Me.Enabled = False

        With mScenarioPicker
            .Location = UI.LocationForCenteringChildForm(Me, mScenarioPicker)
            .Show()
        End With
    End Sub

    Private FaceInitTimeout As Decimal ' = 0.25D
    Private FaceCaptureFailure As Decimal '= 1
    Private FaceDownloadTimeout As Decimal '= 1
    Private FaceDownloadFailure As Decimal
    Private FaceInitFailure As Decimal

    Private FingerprintInitTimeout As Decimal '= 0.25D
    Private FingerprintInitFailure As Decimal '= 0.8D
    Private FingerprintCaptureFailure As Decimal '= 0.8D
    Private FingerprintCaptureTimeout As Decimal

    Private IrisInitTimeout As Decimal '= 0.25D
    Private IrisInitFailure As Decimal '= 0.8D
    Private IrisCaptureFailure As Decimal
    Private IrisCaptureTimeout As Decimal


    Private Sub ScenarioPickerGoButton_Click(ByVal sender As Object, ByVal events As EventArgs)
        SetFaceProbabilities(mScenarioPicker.FaceScenario)
        SetFingerProbabilities(mScenarioPicker.FingerScenario)
        SetIrisProbabilities(mScenarioPicker.IrisScenario)

        For m As Integer = 0 To Sensors.Count - 1
            Dim vSensor As BaseVirtualSensor = DirectCast(Sensors(m), BaseVirtualSensor)
            'Dim mNewConfiguration As VirtualSensorsConfiguration = _
            'CType(Me.TaskFactories(m).SensorConfiguration, VirtualSensorsConfiguration)
            Dim mNewConfiguration As VirtualSensorsConfiguration = New VirtualSensorsConfiguration
            Dim InitOperationBehavior As New VirtualSensorOperationBehavior

            Select Case vSensor.Modality
                Case SensorModality.Face
                    mNewConfiguration.CaptureOperationBehavior.ProbabilityOfFailure = FaceCaptureFailure
                    With mNewConfiguration.DownloadOperationBehavior
                        .ProbabilityOfTimeout = FaceDownloadTimeout
                        .ProbabilityOfFailure = FaceDownloadFailure
                        .Timeout = vSensor.DownloadCommandTemplate.ExpirationTime

                    End With
            

                    With InitOperationBehavior

                        .Wait.ShortTime = 2000
                        .Wait.LongTime = 5000
                        .Wait.ProbOfLongWait = 0
                        .InvocationStyle = VirtualSensorInvocationStyle.Synchronous
                        .Timeout = InitOperationBehavior.Wait.BetweenShortAndLongTime(0.5)
                        .ProbabilityOfFailure = FaceInitFailure
                        .ProbabilityOfTimeout = FaceInitTimeout
                    End With

                Case SensorModality.Fingerprint
                    With mNewConfiguration.CaptureOperationBehavior
                        .ProbabilityOfFailure = FingerprintCaptureFailure
                        .Timeout = vSensor.CaptureCommandTemplate.ExpirationTime
                        .ProbabilityOfTimeout = FingerprintCaptureTimeout
                    End With


                    With InitOperationBehavior
                        .Wait.ShortTime = 200
                        .Wait.LongTime = 12000
                        .Wait.ProbOfLongWait = 0
                        .InvocationStyle = VirtualSensorInvocationStyle.Synchronous
                        .Timeout = InitOperationBehavior.Wait.BetweenShortAndLongTime(1.0)
                        .ProbabilityOfFailure = FingerprintInitFailure
                        .ProbabilityOfTimeout = FingerprintInitTimeout
                    End With

                Case SensorModality.Iris
                    With mNewConfiguration.CaptureOperationBehavior
                        .ProbabilityOfFailure = IrisCaptureFailure
                        .Timeout = vSensor.CaptureCommandTemplate.ExpirationTime
                        .ProbabilityOfTimeout = IrisCaptureTimeout
                    End With

                    With InitOperationBehavior
                        .Wait.ShortTime = 300
                        .Wait.LongTime = 13000
                        .Wait.ProbOfLongWait = 0
                        .InvocationStyle = VirtualSensorInvocationStyle.Synchronous
                        .Timeout = InitOperationBehavior.Wait.BetweenShortAndLongTime(1.0)
                        .ProbabilityOfFailure = IrisInitFailure
                        .ProbabilityOfTimeout = IrisInitTimeout
                    End With

            End Select

            For x As Integer = 0 To Me.TaskFactories.Count - 1
                If TaskFactories(x).Sensor.FriendlyName = vSensor.FriendlyName Then
                    Dim vConfiguration As VirtualSensorsConfiguration = CType(TaskFactories(x).SensorConfiguration, VirtualSensorsConfiguration)
                    mNewConfiguration.CaptureOperationBehavior.Wait = vConfiguration.CaptureOperationBehavior.Wait
                    mNewConfiguration.DownloadOperationBehavior.Wait = vConfiguration.DownloadOperationBehavior.Wait
                    TaskFactories(x).SensorConfiguration = mNewConfiguration
                End If
            Next

            Dim InitObj() As Object = {InitOperationBehavior}
            vSensor.InitializationCommandTemplate.TargetMethodArgs(InitObj)
        Next
        mScenarioPicker.Close()
        mScenarioPicker.Dispose()
        Me.Enabled = True
        StartNewTaskSet()
    End Sub

    'Protected Overrides Sub CaptureActivatedListener(ByVal sender As Object, ByVal e As CaptureActivatedEventArgs)
    '    MyBase.CaptureActivatedListener(sender, e)
    'End Sub


    Protected Overrides Sub OnActivated(ByVal e As EventArgs)
        MyBase.OnActivated(e)
        If Not mScenarioPicker Is Nothing Then mScenarioPicker.BringToFront()
    End Sub

    Private Sub SetFaceProbabilities(ByVal FaceScenario As ArrayList)
        Dim SelectedScenario As ScenarioPicker.Scenarios = CType(FaceScenario(0), ScenarioPicker.Scenarios)
        Dim ProcessType As ScenarioPicker.ProcessType
        If FaceScenario.Count > 1 Then ProcessType = CType(FaceScenario(1), ScenarioPicker.ProcessType)

        Select Case SelectedScenario
            Case ScenarioPicker.Scenarios.AllOkay
                FaceInitTimeout = 0
                FaceInitFailure = 0
                FaceCaptureFailure = 0
                FaceDownloadTimeout = 0
                FaceDownloadFailure = 0

            Case ScenarioPicker.Scenarios.AlwaysHaveFailure
                If ProcessType = ScenarioPicker.ProcessType.Capture Then FaceCaptureFailure = 1D
                If ProcessType = ScenarioPicker.ProcessType.Download Then FaceDownloadFailure = 1D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FaceInitFailure = 1D

            Case ScenarioPicker.Scenarios.AlwaysHaveTimeout
                If ProcessType = ScenarioPicker.ProcessType.Download Then FaceDownloadTimeout = 1

            Case ScenarioPicker.Scenarios.HaveHighFailureRate
                If ProcessType = ScenarioPicker.ProcessType.Capture Then FaceCaptureFailure = 0.8D
                If ProcessType = ScenarioPicker.ProcessType.Download Then FaceDownloadFailure = 0.8D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FaceInitFailure = 0.8D

            Case ScenarioPicker.Scenarios.HaveHighTimeoutRate
                If ProcessType = ScenarioPicker.ProcessType.Download Then FaceDownloadTimeout = 0.8D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FaceInitTimeout = 0.8D

            Case ScenarioPicker.Scenarios.HaveRandomFailure
                If ProcessType = ScenarioPicker.ProcessType.Capture Then FaceCaptureFailure = 0.25D
                If ProcessType = ScenarioPicker.ProcessType.Download Then FaceDownloadFailure = 0.25D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FaceInitFailure = 0.25D

            Case ScenarioPicker.Scenarios.HaveRandomTimeout
                If ProcessType = ScenarioPicker.ProcessType.Download Then FaceDownloadTimeout = 0.25D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FaceInitTimeout = 0.25D
        End Select
    End Sub

    Private Sub SetFingerProbabilities(ByVal FingerScenario As ArrayList)
        Dim SelectedScenario As ScenarioPicker.Scenarios = CType(FingerScenario(0), ScenarioPicker.Scenarios)
        Dim ProcessType As ScenarioPicker.ProcessType
        If FingerScenario.Count > 1 Then ProcessType = CType(FingerScenario(1), ScenarioPicker.ProcessType)

        Select Case SelectedScenario
            Case ScenarioPicker.Scenarios.AllOkay
                FingerprintInitTimeout = 0
                FingerprintInitFailure = 0
                FingerprintCaptureFailure = 0
                FingerprintCaptureTimeout = 0

            Case ScenarioPicker.Scenarios.AlwaysHaveFailure
                If ProcessType = ScenarioPicker.ProcessType.Capture Then FingerprintCaptureFailure = 1D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FingerprintInitFailure = 1D

            Case ScenarioPicker.Scenarios.AlwaysHaveTimeout
                If ProcessType = ScenarioPicker.ProcessType.Capture Then FingerprintCaptureTimeout = 1D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FingerprintInitTimeout = 1D

            Case ScenarioPicker.Scenarios.HaveHighFailureRate
                If ProcessType = ScenarioPicker.ProcessType.Capture Then FingerprintCaptureFailure = 0.8D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FingerprintInitFailure = 0.8D

            Case ScenarioPicker.Scenarios.HaveHighTimeoutRate
                If ProcessType = ScenarioPicker.ProcessType.Capture Then FingerprintCaptureTimeout = 0.8D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FingerprintInitTimeout = 0.8D

            Case ScenarioPicker.Scenarios.HaveRandomFailure
                If ProcessType = ScenarioPicker.ProcessType.Capture Then FingerprintCaptureFailure = 0.25D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FingerprintInitFailure = 0.25D

            Case ScenarioPicker.Scenarios.HaveRandomTimeout
                If ProcessType = ScenarioPicker.ProcessType.Capture Then FingerprintCaptureTimeout = 0.25D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then FingerprintInitTimeout = 0.25D
        End Select
    End Sub

    Private Sub SetIrisProbabilities(ByVal IrisScenario As ArrayList)
        Dim SelectedScenario As ScenarioPicker.Scenarios = CType(IrisScenario(0), ScenarioPicker.Scenarios)
        Dim ProcessType As ScenarioPicker.ProcessType
        If IrisScenario.Count > 1 Then ProcessType = CType(IrisScenario(1), ScenarioPicker.ProcessType)

        Select Case SelectedScenario
            Case ScenarioPicker.Scenarios.AllOkay
                IrisInitTimeout = 0
                IrisInitFailure = 0
                IrisCaptureFailure = 0
                IrisCaptureTimeout = 0

            Case ScenarioPicker.Scenarios.AlwaysHaveFailure
                If ProcessType = ScenarioPicker.ProcessType.Capture Then IrisCaptureFailure = 1D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then IrisInitFailure = 1D

            Case ScenarioPicker.Scenarios.AlwaysHaveTimeout
                If ProcessType = ScenarioPicker.ProcessType.Capture Then IrisCaptureTimeout = 1D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then IrisInitTimeout = 1D

            Case ScenarioPicker.Scenarios.HaveHighFailureRate
                If ProcessType = ScenarioPicker.ProcessType.Capture Then IrisCaptureFailure = 0.8D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then IrisInitFailure = 0.8D

            Case ScenarioPicker.Scenarios.HaveHighTimeoutRate
                If ProcessType = ScenarioPicker.ProcessType.Capture Then IrisCaptureTimeout = 0.8D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then IrisInitTimeout = 0.8D

            Case ScenarioPicker.Scenarios.HaveRandomFailure
                If ProcessType = ScenarioPicker.ProcessType.Capture Then IrisCaptureFailure = 0.25D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then IrisInitFailure = 0.25D

            Case ScenarioPicker.Scenarios.HaveRandomTimeout
                If ProcessType = ScenarioPicker.ProcessType.Capture Then IrisCaptureTimeout = 0.25D
                If ProcessType = ScenarioPicker.ProcessType.Initialize Then IrisInitTimeout = 0.25D
        End Select
    End Sub

End Class
