'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Xml.Serialization

Namespace Mbark.Sensors

    <XmlType("RuntimeSensorTaskCollection")> Public Class SensorTaskCollection
        Implements ICollection

        Private mTasks As ArrayList

        Friend Function CreateDefinition() As SensorTaskCollectionDefinition
            Dim newDef As New SensorTaskCollectionDefinition
            ReDim newDef.SensorTaskDefinitions(mTasks.Count - 1)
            For i As Integer = 0 To mTasks.Count - 1
                newDef.SensorTaskDefinitions(i) = Items(i).CreateDefinition()
            Next
            Return newDef
        End Function

        Public ReadOnly Property Last() As SensorTask
            Get
                If mTasks.Count = 0 Then Return Nothing Else Return DirectCast(mTasks(mTasks.Count - 1), SensorTask)
            End Get
        End Property

        Public Sub Add(ByVal task As SensorTask)
            mTasks.Add(task)
        End Sub

        Public Sub Insert(ByVal index As Integer, ByVal task As SensorTask)
            If task Is Nothing Then Throw New ArgumentNullException("task")
            mTasks.Insert(index, task)
        End Sub

        Public Sub Remove(ByVal task As SensorTask)
            mTasks.Remove(task)
        End Sub

        Public Sub Add(ByVal tasks As SensorTaskCollection)
            If tasks Is Nothing Then Return
            mTasks.AddRange(tasks.mTasks.ToArray)
        End Sub

        Default Public ReadOnly Property Items(ByVal index As Integer) As SensorTask
            Get
                If index < 0 Or index >= mTasks.Count Then Return Nothing
                Return DirectCast(mTasks(index), SensorTask)
            End Get
        End Property

        Public Sub Sort()
            mTasks.Sort(Nothing)
        End Sub

        Public ReadOnly Property Count() As Integer Implements ICollection.Count
            Get
                Return mTasks.Count
            End Get
        End Property


        Public Sub New()
            mTasks = New ArrayList
        End Sub

        Public Function IndexOf(ByVal task As SensorTask) As Integer
            Return mTasks.IndexOf(task)
        End Function

        Public ReadOnly Property IsDownloadStillNeeded() As Boolean
            Get
                For i As Integer = 0 To mTasks.Count - 1
                    For j As Integer = 0 To Items(i).Attempts.Count - 1
                        If Items(i).Attempts(j).NeedsDownload Then Return True
                    Next
                Next
                Return False
            End Get
        End Property

        Public ReadOnly Property HasActivatableTask() As Boolean
            Get
                For i As Integer = 0 To mTasks.Count - 1
                    If Items(i).IsActivatable Then Return True
                Next
                Return False
            End Get
        End Property


        Public Sub PopulateSensorSet(ByVal sensors As SensorCollection, ByVal includeSensorsOfDisabledTasks As Boolean)

            If sensors Is Nothing Then Throw New ArgumentNullException("sensors")

            For i As Integer = 0 To mTasks.Count - 1

                If Not sensors.Contains(Items(i).Sensor) Then
                    ' If the sensor is not yet in the set...

                    Dim task As SensorTask = DirectCast(mTasks(i), SensorTask)
                    If includeSensorsOfDisabledTasks Then
                        ' ... and we don't care if the task is disabled ...
                        sensors.Add(Items(i).Sensor)

                    ElseIf task.Enabled Then
                        ' ... or we do care if the task is enabled, we check to make sure it is.
                        sensors.Add(Items(i).Sensor)
                    End If

                End If
            Next
        End Sub

        Public Sub Clear()
            mTasks.Clear()
        End Sub

        Public ReadOnly Property FirstActivatableTask(ByVal start As Integer) As Integer
            Get
                For i As Integer = start To mTasks.Count - 1
                    Dim task As SensorTask = DirectCast(mTasks(i), SensorTask)
                    If task.IsActivatable Then Return i
                Next
                Return -1
            End Get
        End Property

        Public ReadOnly Property FirstActivatableTask() As Integer
            Get
                Return FirstActivatableTask(0)
            End Get
        End Property


#Region "Collection / Enumerator"

        Public Sub CopyTo(ByVal array As System.Array, ByVal index As Integer) Implements System.Collections.ICollection.CopyTo
            mTasks.CopyTo(array, index)
        End Sub

        Public Sub CopyTo(ByVal sensorTasks As SensorTaskCollection, ByVal index As Integer)
            If sensorTasks Is Nothing Then Throw New ArgumentNullException("sensorTasks")
            mTasks.CopyTo(sensorTasks.mTasks.ToArray, index)
        End Sub


        Public ReadOnly Property IsSynchronized() As Boolean Implements System.Collections.ICollection.IsSynchronized
            Get
                Return mTasks.IsSynchronized()
            End Get
        End Property

        Public ReadOnly Property SyncRoot() As Object Implements System.Collections.ICollection.SyncRoot
            Get
                Return mTasks.SyncRoot
            End Get
        End Property

        Public Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
            Return mTasks.GetEnumerator
        End Function


#End Region


    End Class


End Namespace