'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Drawing
Imports System.Globalization
Imports System.Windows.Forms

Imports SF = Syncfusion.Windows.Forms.Tools

Imports Mbark.UI
Imports Mbark.SensorMessages

Namespace Mbark.Sensors

    Public Class FingerpickerControl
        Inherits BasePickerControl


#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call
            UserNew()
        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            '
            'FingerPickerControl
            '
            Me.BackColor = System.Drawing.SystemColors.Control
            Me.CausesValidation = False
            Me.Name = "FingerPickerControl"
            Me.Size = New System.Drawing.Size(400, 472)

        End Sub

#End Region

        Public WithEvents IndexCheckBox As New XBox
        Public WithEvents MiddleCheckBox As New XBox
        Public WithEvents RingCheckBox As New XBox
        Public WithEvents LittleCheckBox As New XBox
        Public WithEvents ThumbCheckBox As New XBox
        Public WithEvents PalmCheckBox As New XBox


        Private Sub UserNew()
            ' This gets set before Load(), which initializes the image
            PartImages(New Bitmap(Me.GetType(), "hand.png"), New Bitmap(Me.GetType(), "hand-disabled.png"))


            ThumbCheckBox.Name = "ThumbCheckBox"
            Controls.Add(ThumbCheckBox)

            IndexCheckBox.Name = "IndexCheckBox"
            Controls.Add(IndexCheckBox)

            MiddleCheckBox.Name = "MiddleCheckBox"
            Controls.Add(MiddleCheckBox)

            RingCheckBox.Name = "RingCheckBox"
            Controls.Add(RingCheckBox)

            LittleCheckBox.Name = "LittleCheckBox"
            Controls.Add(LittleCheckBox)

            ThumbCheckBox.Name = "ThumbCheckBox"
            Controls.Add(ThumbCheckBox)

        End Sub

        Private mIsLeft As Boolean = True
        Public Property IsLeft() As Boolean
            Get
                Return mIsLeft
            End Get
            Set(ByVal value As Boolean)
                mIsLeft = value
            End Set
        End Property


        Private mBindingFromWireToControl As Boolean
        Protected Friend Overrides Sub BindFromWireToControl()

            If BodyPartsWire Is Nothing Then Return

            mBindingFromWireToControl = True

            With BodyPartsWire
                If IsLeft Then
                    If .Contains(BodyPart.LeftThumb) Then ThumbCheckBox.CheckState = CheckState.Checked Else ThumbCheckBox.CheckState = CheckState.Unchecked
                    If .Contains(BodyPart.LeftIndex) Then IndexCheckBox.CheckState = CheckState.Checked Else IndexCheckBox.CheckState = CheckState.Unchecked
                    If .Contains(BodyPart.LeftMiddle) Then MiddleCheckBox.CheckState = CheckState.Checked Else MiddleCheckBox.CheckState = CheckState.Unchecked
                    If .Contains(BodyPart.LeftRing) Then RingCheckBox.CheckState = CheckState.Checked Else RingCheckBox.CheckState = CheckState.Unchecked
                    If .Contains(BodyPart.LeftLittle) Then LittleCheckBox.CheckState = CheckState.Checked Else LittleCheckBox.CheckState = CheckState.Unchecked
                Else
                    If .Contains(BodyPart.RightThumb) Then ThumbCheckBox.CheckState = CheckState.Checked Else ThumbCheckBox.CheckState = CheckState.Unchecked
                    If .Contains(BodyPart.RightIndex) Then IndexCheckBox.CheckState = CheckState.Checked Else IndexCheckBox.CheckState = CheckState.Unchecked
                    If .Contains(BodyPart.RightMiddle) Then MiddleCheckBox.CheckState = CheckState.Checked Else MiddleCheckBox.CheckState = CheckState.Unchecked
                    If .Contains(BodyPart.RightRing) Then RingCheckBox.CheckState = CheckState.Checked Else RingCheckBox.CheckState = CheckState.Unchecked
                    If .Contains(BodyPart.RightLittle) Then LittleCheckBox.CheckState = CheckState.Checked Else LittleCheckBox.CheckState = CheckState.Unchecked
                End If

            End With

            mThumbState = ThumbCheckBox.CheckState
            mIndexState = IndexCheckBox.CheckState
            mMiddleState = MiddleCheckBox.CheckState
            mRingState = RingCheckBox.CheckState
            mLittleState = LittleCheckBox.CheckState


            RefreshCheckBoxes()
            mBindingFromWireToControl = False


        End Sub

        Private Sub BindFromControlToWire()

            If BodyPartsWire Is Nothing Then Return

            With BodyPartsWire
                If IsLeft Then
                    If ThumbCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.LeftThumb) Else .Remove(BodyPart.LeftThumb)
                    If IndexCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.LeftIndex) Else .Remove(BodyPart.LeftIndex)
                    If MiddleCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.LeftMiddle) Else .Remove(BodyPart.LeftMiddle)
                    If RingCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.LeftRing) Else .Remove(BodyPart.LeftRing)
                    If LittleCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.LeftLittle) Else .Remove(BodyPart.LeftLittle)
                Else
                    If ThumbCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.RightThumb) Else .Remove(BodyPart.RightThumb)
                    If IndexCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.RightIndex) Else .Remove(BodyPart.RightIndex)
                    If MiddleCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.RightMiddle) Else .Remove(BodyPart.RightMiddle)
                    If RingCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.RightRing) Else .Remove(BodyPart.RightRing)
                    If LittleCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.RightLittle) Else .Remove(BodyPart.RightLittle)
                End If
            End With


        End Sub

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)
            If InDesignMode(Me) Then Return

            ThumbCheckBox.Size = GlobalUISettings.ControlSizes.CheckBox
            IndexCheckBox.Size = GlobalUISettings.ControlSizes.CheckBox
            MiddleCheckBox.Size = GlobalUISettings.ControlSizes.CheckBox
            RingCheckBox.Size = GlobalUISettings.ControlSizes.CheckBox
            LittleCheckBox.Size = GlobalUISettings.ControlSizes.CheckBox
            PalmCheckBox.Size = GlobalUISettings.ControlSizes.CheckBox


            OnLayout(New LayoutEventArgs(Me, String.Empty))
            RefreshCheckBoxes()
        End Sub

        Private Shared LittleTip As New Point(136 - 4, 57 - 10)
        Private Shared RingTip As New Point(190 - 4, 33 - 10)
        Private Shared MiddleTip As New Point(242 - 4, 12 - 10)
        Private Shared IndexTip As New Point(290 - 4, 38 - 10)
        Private Shared ThumbTip As New Point(282, 168 - 10)
        Private Shared PalmCenter As New Point(67 - 4, 281 - 10)

        Private Shared SmallestXDelta As Integer = IndexTip.X - MiddleTip.X

        Private Sub PlaceCheckBox(ByVal checkBox As CheckBox, ByVal loc As Point)

            Dim newPoint As Point = MainPictureBox.RemapImagePoint(loc)

            checkBox.Size = GlobalUISettings.ControlSizes.CheckBox

            newPoint.Y += DockPadding.Top - checkBox.Height
            newPoint.X -= CInt(checkBox.Width / 2.0!)
            newPoint.X += DockPadding.Left

            ' Nudge the x-coordinate past the left side
            newPoint.X = Math.Max(DockPadding.Left + 1, newPoint.X)

            ' Nudge the x-coordinate in from the right side
            newPoint.X = Math.Min(newPoint.X, Width - DockPadding.Right - checkBox.Width)




            checkBox.Location = newPoint
            checkBox.BringToFront()

        End Sub

        Protected Overrides Sub LayoutCheckBoxes()

            ' See if we need to add a little padding at the top
            Dim newMiddle As Point = MainPictureBox.RemapImagePoint(MiddleTip)
            If newMiddle.Y < IndexCheckBox.Height Then
                DockPadding.Top = IndexCheckBox.Height - newMiddle.Y
            Else
                DockPadding.Top = 0
            End If

            Dim newIndex As Point = MainPictureBox.RemapImagePoint(IndexTip)
            'If IsLeft AndAlso newIndex.X > (MainPictureBox.Width - IndexCheckBox.Width / 2.0!) Then
            '    DockPadding.Right = CInt(IndexCheckBox.Width / 2.0! - (MainPictureBox.Width - newIndex.X) + 20)
            'ElseIf newIndex.X < IndexCheckBox.Width Then
            '    DockPadding.Left = CInt(IndexCheckBox.Width / 2.0!) - newIndex.X
            'Else
            DockPadding.Left = 0
            DockPadding.Right = 0
            'End If

            PlaceCheckBox(ThumbCheckBox, ThumbTip)
            PlaceCheckBox(IndexCheckBox, IndexTip)
            PlaceCheckBox(MiddleCheckBox, MiddleTip)
            PlaceCheckBox(RingCheckBox, RingTip)
            PlaceCheckBox(LittleCheckBox, LittleTip)
            PlaceCheckBox(PalmCheckBox, PalmCenter)

        End Sub

        Protected Overrides Sub OnLayout(ByVal levent As LayoutEventArgs)
            MyBase.OnLayout(levent)

            If IsLeft Then
                FooterLabel.Text = Messages.LeftHand(UICulture)
                MainPictureBox.Backwards = False
            Else
                FooterLabel.Text = Messages.RightHand(UICulture)
                MainPictureBox.Backwards = True
            End If
            MainPictureBox.Refresh()
            LayoutCheckBoxes()

        End Sub

        Protected Overrides Function ComputeMinimumWidth() As Integer
            Dim baseMinimumWidth As Integer = MyBase.ComputeMinimumWidth
            Dim minimumScale As Single = UI.GlobalUISettings.ControlSizes.CheckBox.Width * 1.0! / SmallestXDelta

            Dim spacingPreservativeMinimumWidth As Integer
            If Not MainPictureBox.EnabledImage Is Nothing Then
                spacingPreservativeMinimumWidth = CInt(minimumScale * MainPictureBox.EnabledImage.Width)
            End If

            Return Math.Max(baseMinimumWidth, spacingPreservativeMinimumWidth)
        End Function

        Private mThumbState As CheckState
        Private mIndexState As CheckState
        Private mMiddleState As CheckState
        Private mRingState As CheckState
        Private mLittleState As CheckState
        Private mPalmState As CheckState


        Private Sub ThumbCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles ThumbCheckBox.CheckedChanged
            If mBindingFromWireToControl Then Return
            If Not mHandlingPalmCheckBox Then mThumbState = ThumbCheckBox.CheckState
            RefreshCheckBoxes()
            BindFromControlToWire()
        End Sub

        Private Sub IndexCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles IndexCheckBox.CheckedChanged
            If mBindingFromWireToControl Then Return
            If Not mHandlingPalmCheckBox Then mIndexState = IndexCheckBox.CheckState
            RefreshCheckBoxes()
            BindFromControlToWire()
        End Sub

        Private Sub LittleCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles LittleCheckBox.CheckedChanged
            If mBindingFromWireToControl Then Return
            If Not mHandlingPalmCheckBox Then mLittleState = LittleCheckBox.CheckState
            RefreshCheckBoxes()
            BindFromControlToWire()
        End Sub

        Private Sub RingCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles RingCheckBox.CheckedChanged
            If mBindingFromWireToControl Then Return
            If Not mHandlingPalmCheckBox Then mRingState = RingCheckBox.CheckState
            RefreshCheckBoxes()
            BindFromControlToWire()
        End Sub

        Private Sub MiddleCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles MiddleCheckBox.CheckedChanged
            If mBindingFromWireToControl Then Return
            If Not mHandlingPalmCheckBox Then mMiddleState = MiddleCheckBox.CheckState
            RefreshCheckBoxes()
            BindFromControlToWire()
        End Sub


        Private mAllFingersManuallyChecked As Boolean
        Private mAllFingersChecked As Boolean
        Private mInsideRefreshCheckBoxes As Boolean
        Protected Overrides Sub RefreshCheckBoxes()

            If mInsideRefreshCheckBoxes Then Return
            mInsideRefreshCheckBoxes = True


            '
            ' First, we see if all the boxes were manually checked
            '
            If mThumbState = CheckState.Checked AndAlso _
               mIndexState = CheckState.Checked AndAlso _
               mMiddleState = CheckState.Checked AndAlso _
               mRingState = CheckState.Checked AndAlso _
               mLittleState = CheckState.Checked Then
                mAllFingersManuallyChecked = True
            Else
                mAllFingersManuallyChecked = False
            End If

            If ThumbCheckBox.CheckState = CheckState.Checked AndAlso _
               IndexCheckBox.CheckState = CheckState.Checked AndAlso _
               MiddleCheckBox.CheckState = CheckState.Checked AndAlso _
               RingCheckBox.CheckState = CheckState.Checked AndAlso _
               LittleCheckBox.CheckState = CheckState.Checked Then
                mAllFingersChecked = True
            Else
                mAllFingersChecked = False
            End If


            If mHandlingPalmCheckBox Then
                ' 
                ' Respond to a change in the palm check box
                ' 
                If mPalmState = CheckState.Checked Then

                    ' Using .BeginUpdate caches the updates so they don't all happen at once
                    BodyPartsWire.BeginUpdate()
                    ThumbCheckBox.CheckState = CheckState.Checked
                    IndexCheckBox.CheckState = CheckState.Checked
                    MiddleCheckBox.CheckState = CheckState.Checked
                    RingCheckBox.CheckState = CheckState.Checked
                    LittleCheckBox.CheckState = CheckState.Checked
                    BodyPartsWire.EndUpdate()

                    ThumbCheckBox.Enabled = False
                    IndexCheckBox.Enabled = False
                    MiddleCheckBox.Enabled = False
                    RingCheckBox.Enabled = False
                    LittleCheckBox.Enabled = False
                    PalmCheckBox.Enabled = MyBase.Enabled

                Else

                    If Not BodyPartsWire Is Nothing Then BodyPartsWire.BeginUpdate()
                    ThumbCheckBox.CheckState = mThumbState
                    IndexCheckBox.CheckState = mIndexState
                    MiddleCheckBox.CheckState = mMiddleState
                    RingCheckBox.CheckState = mRingState
                    LittleCheckBox.CheckState = mLittleState
                    If Not BodyPartsWire Is Nothing Then BodyPartsWire.EndUpdate()

                    ThumbCheckBox.Enabled = MyBase.Enabled
                    IndexCheckBox.Enabled = MyBase.Enabled
                    MiddleCheckBox.Enabled = MyBase.Enabled
                    RingCheckBox.Enabled = MyBase.Enabled
                    LittleCheckBox.Enabled = MyBase.Enabled

                End If

            Else
                '
                ' Respond to a change in some other finger
                '

                If mAllFingersManuallyChecked Then
                    PalmCheckBox.CheckState = CheckState.Checked
                    PalmCheckBox.Enabled = False
                Else
                    PalmCheckBox.Enabled = Enabled

                    If mAllFingersChecked Then
                        PalmCheckBox.CheckState = CheckState.Checked
                    Else
                        PalmCheckBox.CheckState = CheckState.Unchecked
                        ThumbCheckBox.Enabled = Enabled
                        IndexCheckBox.Enabled = Enabled
                        MiddleCheckBox.Enabled = Enabled
                        RingCheckBox.Enabled = Enabled
                        LittleCheckBox.Enabled = Enabled
                    End If

                End If

            End If

            mInsideRefreshCheckBoxes = False

            ThumbCheckBox.Refresh()
            IndexCheckBox.Refresh()
            MiddleCheckBox.Refresh()
            RingCheckBox.Refresh()
            LittleCheckBox.Refresh()
            PalmCheckBox.Refresh()

            Return


        End Sub



        Private mHandlingPalmCheckBox As Boolean
        Private Sub PalmCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles PalmCheckBox.CheckedChanged
            mPalmState = PalmCheckBox.CheckState

            mHandlingPalmCheckBox = True
            RefreshCheckBoxes()
            mHandlingPalmCheckBox = False

            BindFromControlToWire()
        End Sub

        Public Sub ResetFingerpickerControl()
            'reset all check box - un-check all check box when new session starting
            ThumbCheckBox.Checked = False
            IndexCheckBox.Checked = False
            MiddleCheckBox.Checked = False
            RingCheckBox.Checked = False
            LittleCheckBox.Checked = False
            PalmCheckBox.Checked = False
        End Sub

        Protected Overrides Sub OnEnabledChanged(ByVal e As EventArgs)
            MyBase.OnEnabledChanged(e)
            RefreshCheckBoxes()
        End Sub

        Public Overrides Sub Refresh()
            MyBase.Refresh()
            Me.RefreshCheckBoxes()
        End Sub





    End Class

End Namespace