Imports System
Imports System.Collections
Imports System.Runtime.Remoting
Imports System.Runtime.Remoting.Channels
Imports System.Runtime.Remoting.Lifetime
Imports System.Runtime.Remoting.Messaging

Imports Belikov
Imports Belikov.GenuineChannels
Imports Belikov.GenuineChannels.BroadcastEngine
Imports Belikov.GenuineChannels.DotNetRemotingLayer


Namespace Mbark.Sensors
    Module Server

        Sub Main()
            Dim props As IDictionary = New Hashtable
            props("MaxContentSize") = "5000000"
            props("MaxQueuedItems") = "100"
            props("MaxTotalSize") = "10000000"
            props("Compression") = "False"
            props("port") = "2120"

            Try
                AddHandler GenuineGlobalEventProvider.GenuineChannelsGlobalEvent, New GenuineChannelsGlobalEventHandler(AddressOf GenuineChannelsEventHandler)
                Dim channel As GenuineTcp.GenuineTcpChannel = New GenuineTcp.GenuineTcpChannel(props, Nothing, Nothing)
                ChannelServices.RegisterChannel(channel)

                Dim wkste As New WellKnownServiceTypeEntry(GetType(OlympusFaceCam), "OlympusFaceCam", WellKnownObjectMode.Singleton)
                RemotingConfiguration.RegisterWellKnownServiceType(wkste)
            Catch ex As Exception
                Debugging.WriteLine(ex)
            End Try
            Debugging.WriteLine("Server has been started. Press enter to exit.")
            Console.ReadLine()
        End Sub
        Public Sub GenuineChannelsEventHandler(ByVal sender As Object, ByVal e As GenuineEventArgs)
            Debugging.WriteLine(e.EventType.ToString)
        End Sub

    End Module

End Namespace
