''  ---
''  License
''  ---
''
''  This software was developed at the National Institute of Standards and
''  Technology (NIST) by employees of the Federal Government in the course
''  of their official duties. Pursuant to title 17 Section 105 of the
''  United States Code, this software is not subject to copyright protection
''  and is in the public domain. NIST assumes no responsibility  whatsoever for
''  its use by other parties, and makes no guarantees, expressed or implied,
''  about its quality, reliability, or any other characteristic.
''
''  ---
''  Disclaimer
''  ---
''  This software was developed to facilitate multimodal biometric data collection
''  for the Department of Homeland Security in accordance with Section 303 of the 
''  Border Security Act, codified as 8 U.S.C. 1732.  Specific hardware and software 
''  products identified in this software were used in order to perform the data 
''  collection. In no case does such identification imply recommendation or endorsement 
''  by the National Institute of Standards and Technology, nor does it imply that the 
''  products and equipment identified are necessarily the best available for the purpose.
''

'------------------------------------------------------------------------------
' <autogenerated>
'     This code was generated by CodeSmith.
'     Version: 3.1.0.424
'
'     Changes to this file may cause incorrect behavior and will be lost if
'     the code is regenerated.
' </autogenerated>
'------------------------------------------------------------------------------
Imports System
Imports System.Runtime.Serialization
Imports Mbark.InfrastructureMessages

Namespace Mbark


<Serializable()> Public Class MbarkException
        Inherits Exception
		
		Public Sub New()
            MyBase.New(Messages.GeneralMbarkException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal msg As String)
            MyBase.New(msg)
        End Sub
	
 
 End Class

	


<Serializable()> Public Class UnreachableCodeException
        Inherits MbarkException
		
		Public Sub New()
            MyBase.New(Messages.GeneralUnreachableCodeException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal msg As String)
            MyBase.New(msg)
        End Sub
	
 
 End Class

	


<Serializable()> Public Class TrespassingException
        Inherits MbarkException
		
		Public Sub New()
            MyBase.New(Messages.GeneralTrespassingException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal msg As String)
            MyBase.New(msg)
        End Sub
	
 
 End Class

	


<Serializable()> Public Class NoSuchFieldException
        Inherits MbarkException
		
		Public Sub New()
            MyBase.New(Messages.GeneralNoSuchFieldException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal fieldName As String)
			MyBase.New(Messages.SpecificNoSuchFieldException(fieldName))
		End Sub
	
 
 End Class

	


<Serializable()> Public Class MissingSpecializationException
        Inherits TrespassingException
		
		Public Sub New()
            MyBase.New(Messages.GeneralMissingSpecializationException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal baseType As Type, ByVal methodName As String)
			MyBase.New(Messages.SpecificMissingSpecializationException(baseType, methodName))
		End Sub
	
		Public Sub New(ByVal msg As String)
            MyBase.New(msg)
        End Sub
	
 
 End Class

	


<Serializable()> Public Class MissingWiringException
        Inherits TrespassingException
		
		Public Sub New()
            MyBase.New(Messages.GeneralMissingWiringException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal typeName As Type, ByVal methodName As String)
			MyBase.New(Messages.SpecificMissingWiringException(typeName, methodName))
		End Sub
	
		Public Sub New(ByVal msg As String)
            MyBase.New(msg)
        End Sub
	
 
 End Class

	


<Serializable()> Public Class ControlIsNotAutosizableException
        Inherits MbarkException
		
		Public Sub New()
            MyBase.New(Messages.GeneralControlIsNotAutosizableException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal controlName As String)
			MyBase.New(Messages.SpecificControlIsNotAutosizableException(controlName))
		End Sub
	
 
 End Class

	


<Serializable()> Public Class ControlHasNoSupportForSoughtInterfaceException
        Inherits MbarkException
		
		Public Sub New()
            MyBase.New(Messages.GeneralControlHasNoSupportForSoughtInterfaceException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal controlName As String, ByVal interfaceName As String)
			MyBase.New(Messages.SpecificControlHasNoSupportForSoughtInterfaceException(controlName, interfaceName))
		End Sub
	
		Public Sub New(ByVal msg As String)
            MyBase.New(msg)
        End Sub
	
 
 End Class

	


<Serializable()> Public Class UnexpectedNumberOfInterfaceSupportersException
        Inherits MbarkException
		
		Public Sub New()
            MyBase.New(Messages.GeneralUnexpectedNumberOfInterfaceSupportersException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal interfaceName As String, ByVal foundCount As Integer, ByVal expectedCount As Integer)
			MyBase.New(Messages.SpecificUnexpectedNumberOfInterfaceSupportersException(interfaceName, foundCount, expectedCount))
		End Sub
	
		Public Sub New(ByVal msg As String)
            MyBase.New(msg)
        End Sub
	
 
 End Class

	


<Serializable()> Public Class TooManyCallsException
        Inherits TrespassingException
		
		Public Sub New()
            MyBase.New(Messages.GeneralTooManyCallsException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal methodName As String, ByVal limit As Integer)
			MyBase.New(Messages.SpecificTooManyCallsException(methodName, limit))
		End Sub
	
		Public Sub New(ByVal msg As String)
            MyBase.New(msg)
        End Sub
	
 
 End Class

	


<Serializable()> Public Class NotFormInvokableException
        Inherits MbarkException
		
		Public Sub New()
            MyBase.New(Messages.GeneralNotFormInvokableException)
        End Sub        

		Public Sub New(ByVal msg As String, ByVal ex As Exception)
            MyBase.New(msg, ex)
        End Sub

        Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub
		
	
		Public Sub New(ByVal msg As String)
            MyBase.New(msg)
        End Sub
	
 
 End Class

End Namespace
