using System;
using System.Runtime.InteropServices;
using BioAPI.include.bioapi_type;

namespace BioAPI.include.bioapi_schema
{
//	typedef struct _bioapi_bsp_schema
//			{
//				BioAPI_UUID ModuleId;
//				BioAPI_DEVICE_ID DeviceId;
//				CSSM_STRING BSPName;
//				BioAPI_VERSION SpecVersion;
//				BioAPI_VERSION ProductVersion;
//				CSSM_STRING Vendor;
//				BioAPI_BIR_BIOMETRIC_DATA_FORMAT BspSupportedFormats[MDSU_MAX_VALUE_COUNT];
//				uint32 NumSupportedFormats;
//				uint32 FactorsMask;
//				uint32 Operations;
//				uint32 Options;
//				uint32 PayloadPolicy;
//				uint32 MaxPayloadSize;
//				sint32 DefaultVerifyTimeout;
//				sint32 DefaultIdentifyTimeout;
//				sint32 DefaultCaptureTimeout;
//				sint32 DefaultEnrollTimeout;
//				uint32 MaxBspDbSize;
//				uint32 MaxIdentify;
//				CSSM_STRING Description;
//				char Path[_MAX_PATH];
//			} BioAPI_BSP_SCHEMA;

	[StructLayout(LayoutKind.Sequential)]
	public class BioAPI_BSP_SCHEMA 
	{
		public BioAPI_UUID ModuleId = new BioAPI_UUID();
		public uint DeviceId;
		public string BSPName;
		public BioAPI_VERSION SpecVersion = new BioAPI_VERSION();
		public BioAPI_VERSION ProductVersion = new BioAPI_VERSION();
		public string Vendor;
		public BioAPI_BIR_BIOMETRIC_DATA_FORMAT [] BspSupportedFormats
			= new BioAPI_BIR_BIOMETRIC_DATA_FORMAT[(int) Consts.MDSU_MAX_VALUE_COUNT];
		public uint NumSupportedFormats;
		public uint FactorsMask;
		public uint Operations;
		public uint Options;
		public uint PayloadPolicy;
		public uint MaxPayloadSize;
		public int DefaultVerifyTimeout;
		public int DefaultIdentifyTimeout;
		public int DefaultCaptureTimeout;
		public int DefaultEnrollTimeout;
		public uint MaxBspDbSize;
		public uint MaxIdentify;
		public string Description;
		public string Path;
		public BioAPI_BSP_SCHEMA()
		{
			for (int i = 0; i < (int) Consts.MDSU_MAX_VALUE_COUNT; i++)
				BspSupportedFormats[i] = new BioAPI_BIR_BIOMETRIC_DATA_FORMAT();
		}
	}    
 
//	typedef struct _bioapi_device_schema
//			{
//				BioAPI_UUID ModuleId;
//				BioAPI_DEVICE_ID DeviceId;
//				BioAPI_BIR_BIOMETRIC_DATA_FORMAT DeviceSupportedFormats[MDSU_MAX_VALUE_COUNT];
//				uint32 NumSupportedFormats;
//				uint32 SupportedEvents;
//				CSSM_STRING DeviceVendor;
//				CSSM_STRING DeviceDescription;
//				CSSM_STRING DeviceSerialNumber;
//				BioAPI_VERSION DeviceHardwareVersion;
//				BioAPI_VERSION DeviceFirmwareVersion;
//				BioAPI_BOOL AuthenticatedDevice;
//			} BioAPI_DEVICE_SCHEMA;

	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public class BioAPI_DEVICE_SCHEMA 
	{
		public BioAPI_UUID ModuleId = new BioAPI_UUID();
		public BioAPI_DEVICE_ID DeviceId;
		public BioAPI_BIR_BIOMETRIC_DATA_FORMAT [] DeviceSupportedFormats
			= new BioAPI_BIR_BIOMETRIC_DATA_FORMAT[(int) Consts.MDSU_MAX_VALUE_COUNT];
		public uint NumSupportedFormats;
		public uint SupportedEvents;
		public string DeviceVendor;
		public string DeviceDescription;
		public string DeviceSerialNumber;
		public BioAPI_VERSION DeviceHardwareVersion = new BioAPI_VERSION();
		public BioAPI_VERSION DeviceFirmwareVersion = new BioAPI_VERSION();
		public BioAPI_BOOL AuthenticatedDevice;

		public BioAPI_DEVICE_SCHEMA()
		{
			for (int i = 0; i < (int) Consts.MDSU_MAX_VALUE_COUNT; i++)
				DeviceSupportedFormats[i] = new BioAPI_BIR_BIOMETRIC_DATA_FORMAT();
		}

	}   

//	typedef struct _bioapi_h_level_framework_schema
//			{
//				BioAPI_UUID ModuleId;
//				CSSM_STRING ModuleName;
//				BioAPI_VERSION SpecVersion;
//				BioAPI_VERSION ProdVersion;
//				CSSM_STRING Vendor;
//				CSSM_STRING Description;
//			} BioAPI_H_LEVEL_FRAMEWORK_SCHEMA;
//	
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public class BioAPI_H_LEVEL_FRAMEWORK_SCHEMA 
	{
		public BioAPI_UUID ModuleId = new BioAPI_UUID();
		public string ModuleName;
		public BioAPI_VERSION SpecVersion = new BioAPI_VERSION();
		public BioAPI_VERSION ProdVersion = new BioAPI_VERSION();
		public string Vendor;
		public string Description;
	}   
}