Option Strict On

Imports System.Globalization

Module StandaloneSensorControllerEntryPoint

    Public Sub Main()

        Try
            Static mutex As Threading.Mutex
            mutex = New Threading.Mutex(True, "StandaloneSensorControllerEntryPoint")

            If mutex.WaitOne(0, False) Then
                Application.EnableVisualStyles()
                Application.DoEvents()
                Dim controller As StandaloneSensorController = New StandaloneSensorController
                controller.UICulture = New CultureInfo("en-US")
                Application.Run(controller)
            Else
                MsgBox("Please close the application before starting another") 'i18n
            End If
        Catch ex As Exception
            Mbark.UI.PrettyPrintException(CultureInfo.CurrentUICulture, ex)
        End Try

    End Sub

End Module
