Option Strict On

Imports System
Imports System.IO
Imports System.Drawing
Imports System.Drawing.Imaging

Imports AxLSCAPTURECTRLLib
Imports LSCAPTURECTRLLib

Namespace Mbark.Sensors

    Public Module SmithsHeimannShared

        Private Const LiveWidth As Integer = 800
        Private Const LiveHeight As Integer = 800
        Private Const ImageWidth As Integer = 800
        Private Const ImageHeight As Integer = 800


        Public Function GetSmithsHeimannConfigurationFile() As String
            Dim configurationFileNames As New Collections.Specialized.StringCollection
            configurationFileNames.Add("LS_ILM.cfg")
            configurationFileNames.Add("LS2.config")

            Dim fileLocations As New Collections.Specialized.StringCollection
            For i As Integer = 0 To configurationFileNames.Count - 1
                Dim name As String = configurationFileNames(i)
                With fileLocations
                    .Add(Path.Combine(Environment.GetEnvironmentVariable("ProgramFiles"), "Cross Match Technologies\ScanCtrl\binaries" & name))
                    .Add(Path.Combine("C:\MBARK\Configurations", name))
                    .Add(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, name))
                    .Add(Path.Combine(IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configurations"), name))
                End With
            Next

            For i As Integer = 0 To fileLocations.Count - 1
                If File.Exists(fileLocations(i)) Then
                    Return fileLocations(i)
                End If
            Next

        End Function
        Public Function ErrorCodeToString(ByVal code As Integer) As String

            Const MinCaptureSrvErrorCode As Integer = -1014
            Const MaxCaptureSrvErrorCode As Integer = -1012

            Const MinCommonErrorCode As Integer = -15
            Const MaxCommonErrorcode As Integer = -11

            Const MinCommunicationErrorCode As Integer = -214
            Const MaxCommunicationErrorCode As Integer = -201

            Const MinGrabberErrorCode As Integer = -101
            Const MaxGrabberErrorcode As Integer = -113

            Const MinIlmErrorCode As Integer = -665
            Const MaxIlmErrorCode As Integer = -601

            Const MinIlmWarningCode As Integer = 601
            Const MaxIlmWarnignCode As Integer = 656


            If code >= MinCaptureSrvErrorCode AndAlso code <= MaxCaptureSrvErrorCode Then
                Return CType(code, CaptureSrvErrorConstants).ToString
            End If

            If code >= MinCommonErrorCode AndAlso code <= MinCommonErrorCode Then
                Return CType(code, CommonErrorConstants).ToString
            End If

            If code >= MinCommunicationErrorCode AndAlso code <= MaxCommunicationErrorCode Then
                Return CType(code, CommunicationErrorConstants).ToString
            End If

            If code >= MinGrabberErrorCode AndAlso code <= MaxGrabberErrorcode Then
                Return CType(code, GrabberErrorConstants).ToString
            End If

            If code >= MinIlmErrorCode AndAlso code <= MaxIlmErrorCode Then
                Return CType(code, IlmErrorConstants).ToString
            End If

            If code >= MinIlmWarningCode AndAlso code <= MaxIlmWarnignCode Then
                Return CType(code, IlmWarningConstants).ToString
            End If

            Return "Unknown error"

        End Function
        Public Function FullImageToBitmap(ByVal sensor As ISensor, ByVal EmptyPalette As ColorPalette, ByVal fullImageAsObject As Object) As Bitmap
            Dim SHSensor As BaseSensor = DirectCast(sensor, BaseSensor)
            If EmptyPalette Is Nothing Then SHSensor.InitEmptyPalette()

            Dim fullImage As Array = CType(fullImageAsObject, Array)
            Try
                Dim maxRow As Integer = fullImage.GetUpperBound(0)
                Dim maxColumn As Integer = fullImage.GetUpperBound(1)
                Dim width As Integer = maxColumn + 1
                Dim height As Integer = maxRow + 1

                Dim imageAsBytes((maxColumn + 1) * (maxRow + 1) - 1) As Byte
                System.Buffer.BlockCopy(fullImage, 0, imageAsBytes, 0, fullImage.Length)

                Dim bmp As Bitmap = SHSensor.ConvertBytesAsObjectToBitmap(imageAsBytes, width, height)
                bmp.RotateFlip(RotateFlipType.Rotate90FlipX)
                Return bmp
            Catch ex As Exception
                Debugging.Break()
            End Try
        End Function
        Public Function Open(ByVal SHCtrl As AxLsCaptureCtrl, ByVal iType As ImageType) As Boolean
            
            Select Case iType
                Case ImageType.SingleFingerprintCapture
                    Dim rc As Integer = SHCtrl.ILM_FINGER_init(ImageHeight, ImageWidth, LiveHeight, LiveWidth)
                    If rc <> CommonErrorConstants.lcOK Then Return False
                    'mSHBLScanSingleCtrl.ILM_FINGER_takeFlatPicture
                    Return True
                Case ImageType.SlapFingerprintCapture
                    Dim rc As Integer = SHCtrl.ILM_PALM_init(ImageHeight, ImageWidth, LiveHeight, LiveWidth)
                    If rc <> CommonErrorConstants.lcOK Then Return False
                    SHCtrl.ILM_PALM_setTakePictureOptions(BeeperConstants.lcBEEP_PATTERN_NONE, BeeperConstants.lcBEEP_PATTERN_NONE)
                    Return True
            End Select
        End Function
        Public Function Close(ByVal SHCtrl As AxLsCaptureCtrl, ByVal iType As ImageType) As Boolean
            Select Case iType
                Case ImageType.SingleFingerprintCapture
                    Dim rc As Integer = SHCtrl.ILM_FINGER_exit
                Case ImageType.SlapFingerprintCapture
                    Dim rc As Integer = SHCtrl.ILM_PALM_exit
                    Return True
            End Select
        End Function

        Public Enum ImageType
            SlapFingerprintCapture
            SingleFingerprintCapture
        End Enum
    End Module

End Namespace

