'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Xml.Serialization

Namespace Mbark.Sensors


    <XmlType("TaskFactoryCollection"), Serializable()> _
    Public Class SensorTaskFactoryCollectionDefinition

        ' 
        ' | This class describes the auto-serializable components of SensorTaskFactoryCollection   |
        ' 

        Private mCurrentInaccessibleBodyParts As New BodyParts
        Private mCurrentConditions As ConditionCollectionDefinition
        Private mSensorDefinitions As SensorTypeDefinition()
        Private mFactoryDefinitions As New SimpleSensorTaskFactoryDefinitionCollection

        <XmlArray()> Public Property SensorDefinitions() As SensorTypeDefinition()
            Get
                Return mSensorDefinitions
            End Get
            Set(ByVal value As SensorTypeDefinition())
                mSensorDefinitions = value
            End Set
        End Property


        Public ReadOnly Property FactoryDefinitions() As SimpleSensorTaskFactoryDefinitionCollection
            Get
                Return mFactoryDefinitions
            End Get
            'Set(ByVal value As SensorTaskFactory.Definition())
            '    mFactoryDefinitions = value
            'End Set
        End Property

        Friend Sub UpdateCapacity(ByVal newCapacity As Integer)
            mFactoryDefinitions.Capacity = newCapacity
        End Sub

        Public Property CurrentConditions() As ConditionCollectionDefinition
            Get
                Return mCurrentConditions
            End Get
            Set(ByVal value As ConditionCollectionDefinition)
                mCurrentConditions = value
            End Set
        End Property
        Public Property CurrentInaccessibleBodyParts() As BodyParts
            Get
                Return mCurrentInaccessibleBodyParts
            End Get
            Set(ByVal value As BodyParts)
                mCurrentInaccessibleBodyParts = value
            End Set
        End Property
        Public Function CreateSensorTaskFactories() As SensorTaskFactoryCollection

            Dim factories As New SensorTaskFactoryCollection

            ' Reconstitute the sensors
            For i As Integer = 0 To SensorDefinitions.Length - 1
                factories.Sensors.Add(SensorTypeDefinition.CreateSensor(SensorDefinitions(i)))
            Next

            ' Reconstitute the current conditions
            factories.mCurrentConditions = CurrentConditions.CreateConditionCollection()
            factories.mCurrentInaccessibleBodyParts = CurrentInaccessibleBodyParts.DeepCopy

            ' Reconstitute the task factories
            For i As Integer = 0 To FactoryDefinitions.Count - 1
                factories.Add(FactoryDefinitions(i).CreateFactory(factories))
            Next

            factories.UpdateTaskMap()


            Return factories
        End Function

    End Class

End Namespace
