'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 
Option Strict On

Imports System.Collections.Specialized
Imports System.Text
Imports System.Runtime.Serialization
Imports System.Xml.Serialization
Imports System.Windows.Forms

Imports Mbark.UI.GlobalUISettings

Namespace Mbark.Sensors


    <XmlType("RuntimeConditionFactoryCollection")> _
    Public Class ConditionFactoryCollection
        Implements ICollection

        Private mEquivalenceClassFactories As New ArrayList
        Private mFactories As New ArrayList

        Public Sub AddEquivalenceClassFactory(ByVal factory As PredicateFactory)
            mEquivalenceClassFactories.Add(factory)
        End Sub

        Public Sub Add(ByVal factory As ConditionFactory)
            mFactories.Add(factory)
        End Sub
        
        Default Public Property Item(ByVal index As Integer) As ConditionFactory
            Get
                Return DirectCast(mFactories(index), ConditionFactory)
            End Get
            Set(ByVal value As ConditionFactory)
                mFactories(index) = value
            End Set
        End Property

        Public Function CreateDefinition() As ConditionFactoryCollectionDefinition
            Dim def As New ConditionFactoryCollectionDefinition

            ReDim def.EquivalenceClassFactoryDefinitions(mEquivalenceClassFactories.Count - 1)
            For i As Integer = 0 To mEquivalenceClassFactories.Count - 1
                def.EquivalenceClassFactoryDefinitions(i) = DirectCast(mEquivalenceClassFactories(i), PredicateFactory).Definition
            Next

            ReDim def.FactoryDefinitions(mFactories.Count - 1)
            For i As Integer = 0 To mFactories.Count - 1
                def.FactoryDefinitions(i) = DirectCast(mFactories(i), ConditionFactory).CreateDefinition()
            Next
            Return def
        End Function

        Public Function CreateConditionCollection() As ConditionCollection
            Dim conditions As New ConditionCollection
            For i As Integer = 0 To mFactories.Count - 1
                Dim factory As ConditionFactory = Item(i)
                conditions(factory.ConditionName) = factory.Create(conditions)
            Next
            For i As Integer = 0 To mEquivalenceClassFactories.Count - 1
                Dim factory As PredicateFactory = DirectCast(mEquivalenceClassFactories(i), PredicateFactory)
                conditions.AddEquivalenceClass(factory)
            Next
            Return conditions
        End Function


        Public Shared Function Create(ByVal definition As ConditionFactoryCollectionDefinition) As ConditionFactoryCollection
            If definition Is Nothing Then Throw New ArgumentNullException("definition")
            Dim newFactories As New ConditionFactoryCollection

            For i As Integer = 0 To definition.FactoryDefinitions.Length - 1
                newFactories.Add(definition.FactoryDefinitions(i).CreateConditionFactory())
            Next

            For i As Integer = 0 To definition.EquivalenceClassFactoryDefinitions.Length - 1
                newFactories.AddEquivalenceClassFactory(definition.EquivalenceClassFactoryDefinitions(i).CreatePredicateFactory())
            Next


            Return newFactories

        End Function


        'Public Function CreateConditionCollection(ByVal parentTask As SensorTask) As ConditionCollection
        '    Dim conditions As ConditionCollection = Create()
        '    conditions.WireParentTask(parentTask)
        '    Return conditions
        'End Function


#Region "ICollection Implementation"


        Public ReadOnly Property Count() As Integer Implements ICollection.Count
            Get
                Return mFactories.Count
            End Get
        End Property

        Public Sub CopyTo(ByVal array As System.Array, ByVal index As Integer) Implements ICollection.CopyTo
            mFactories.CopyTo(array, index)
        End Sub

        Public Sub CopyTo(ByVal factories As ConditionFactoryCollection, ByVal index As Integer)
            If factories Is Nothing Then Throw New ArgumentNullException("factories")
            mFactories.CopyTo(factories.mFactories.ToArray, index)
        End Sub

        Public ReadOnly Property IsSynchronized() As Boolean Implements ICollection.IsSynchronized
            Get
                Return mFactories.IsSynchronized
            End Get
        End Property

        Public ReadOnly Property SyncRoot() As Object Implements ICollection.SyncRoot
            Get
                Return mFactories.SyncRoot
            End Get
        End Property

        Public Function GetEnumerator() As System.Collections.IEnumerator Implements IEnumerable.GetEnumerator
            Return mFactories.GetEnumerator
        End Function
#End Region

    End Class

    <XmlType("ConditionFactoryCollection"), Serializable()> _
   Public Class ConditionFactoryCollectionDefinition
        Implements ICloneable

        <XmlElement("EquivalenceClasses")> _
        Public EquivalenceClassFactoryDefinitions() As PredicateFactoryDefinition
        <XmlElement("Factories")> _
        Public FactoryDefinitions() As ConditionFactoryDefinition

        Public Function Clone() As Object Implements System.ICloneable.Clone
            Dim newDef As New ConditionFactoryCollectionDefinition

            If EquivalenceClassFactoryDefinitions Is Nothing Then
                EquivalenceClassFactoryDefinitions = New PredicateFactoryDefinition() {}
            End If

            ReDim newDef.EquivalenceClassFactoryDefinitions(EquivalenceClassFactoryDefinitions.Length - 1)
            For i As Integer = 0 To EquivalenceClassFactoryDefinitions.Length - 1
                newDef.EquivalenceClassFactoryDefinitions(i) = EquivalenceClassFactoryDefinitions(i).DeepCopy
            Next

            If FactoryDefinitions Is Nothing Then
                FactoryDefinitions = New ConditionFactoryDefinition() {}
            End If

            ReDim newDef.FactoryDefinitions(FactoryDefinitions.Length - 1)
            For i As Integer = 0 To FactoryDefinitions.Length - 1
                newDef.FactoryDefinitions(i) = FactoryDefinitions(i).DeepCopy()
            Next
            Return newDef
        End Function

        Public Function DeepCopy() As ConditionFactoryCollectionDefinition
            Return DirectCast(Clone(), ConditionFactoryCollectionDefinition)
        End Function

        Public Function CreateConditionFactoryCollection() As ConditionFactoryCollection
            Dim factories As New ConditionFactoryCollection
            For i As Integer = 0 To FactoryDefinitions.Length - 1
                factories.Add(FactoryDefinitions(i).CreateConditionFactory())
            Next

            For i As Integer = 0 To EquivalenceClassFactoryDefinitions.Length - 1
                factories.AddEquivalenceClassFactory(EquivalenceClassFactoryDefinitions(i).CreatePredicateFactory)
            Next

            Return factories

        End Function

    End Class

End Namespace
