''  ---
''  License
''  ---
''
''  This software was developed at the National Institute of Standards and
''  Technology (NIST) by employees of the Federal Government in the course
''  of their official duties. Pursuant to title 17 Section 105 of the
''  United States Code, this software is not subject to copyright protection
''  and is in the public domain. NIST assumes no responsibility  whatsoever for
''  its use by other parties, and makes no guarantees, expressed or implied,
''  about its quality, reliability, or any other characteristic.
''
''  ---
''  Disclaimer
''  ---
''  This software was developed to facilitate multimodal biometric data collection
''  for the Department of Homeland Security in accordance with Section 303 of the 
''  Border Security Act, codified as 8 U.S.C. 1732.  Specific hardware and software 
''  products identified in this software were used in order to perform the data 
''  collection. In no case does such identification imply recommendation or endorsement 
''  by the National Institute of Standards and Technology, nor does it imply that the 
''  products and equipment identified are necessarily the best available for the purpose.
''

Option Strict On

Imports System.Drawing
Imports System.Windows.Forms

Imports SF = Syncfusion.Windows.Forms.Tools

Imports Mbark.UI
Imports Mbark.SensorMessages

Namespace Mbark.Sensors


    Public Class IrisPickerControl
        Inherits BasePickerControl

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call
            UserNew()
        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents RightEyeCheckBox As System.Windows.Forms.CheckBox
        Friend WithEvents LeftEyeCheckbox As System.Windows.Forms.CheckBox
        Friend WithEvents RightEyeToolTip As System.Windows.Forms.ToolTip
        Friend WithEvents LeftEyeToolTip As System.Windows.Forms.ToolTip
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Me.components = New System.ComponentModel.Container
            Me.RightEyeCheckBox = New System.Windows.Forms.CheckBox
            Me.LeftEyeCheckbox = New System.Windows.Forms.CheckBox
            Me.RightEyeToolTip = New System.Windows.Forms.ToolTip(Me.components)
            Me.LeftEyeToolTip = New System.Windows.Forms.ToolTip(Me.components)
            Me.SuspendLayout()
            '
            'RightEyeCheckBox
            '
            Me.RightEyeCheckBox.Anchor = System.Windows.Forms.AnchorStyles.None
            Me.RightEyeCheckBox.Enabled = False
            Me.RightEyeCheckBox.FlatStyle = System.Windows.Forms.FlatStyle.System
            Me.RightEyeCheckBox.Location = New System.Drawing.Point(88, 167)
            Me.RightEyeCheckBox.Name = "RightEyeCheckBox"
            Me.RightEyeCheckBox.Size = New System.Drawing.Size(12, 12)
            Me.RightEyeCheckBox.TabIndex = 0
            '
            'LeftEyeCheckbox
            '
            Me.LeftEyeCheckbox.Anchor = System.Windows.Forms.AnchorStyles.None
            Me.LeftEyeCheckbox.Enabled = False
            Me.LeftEyeCheckbox.FlatStyle = System.Windows.Forms.FlatStyle.System
            Me.LeftEyeCheckbox.Location = New System.Drawing.Point(213, 166)
            Me.LeftEyeCheckbox.Name = "LeftEyeCheckbox"
            Me.LeftEyeCheckbox.Size = New System.Drawing.Size(19, 26)
            Me.LeftEyeCheckbox.TabIndex = 1
            Me.LeftEyeCheckbox.Text = "CheckBox1"
            '
            'IrisPickerControl
            '
            Me.Controls.Add(Me.LeftEyeCheckbox)
            Me.Controls.Add(Me.RightEyeCheckBox)
            Me.Name = "IrisPickerControl"
            Me.Size = New System.Drawing.Size(304, 432)
            Me.Controls.SetChildIndex(Me.RightEyeCheckBox, 0)
            Me.Controls.SetChildIndex(Me.LeftEyeCheckbox, 0)
            Me.ResumeLayout(False)

        End Sub

#End Region

        Private Sub UserNew()
            PartImages(New Bitmap(Me.GetType(), "head.png"), New Bitmap(Me.GetType(), "head-disabled.png"))
            FooterLabel.Text = "Irises"
        End Sub

        Protected Friend Overrides Sub BindFromWireToControl()

            If BodyPartsWire Is Nothing Then Return

            With BodyPartsWire
                If .Contains(BodyPart.LeftIris) Then LeftEyeCheckbox.CheckState = CheckState.Checked
                If .Contains(BodyPart.RightIris) Then RightEyeCheckBox.CheckState = CheckState.Checked
            End With

        End Sub

        Private Sub BindFromControlToWire()

            If BodyPartsWire Is Nothing Then Return
            With BodyPartsWire
                If LeftEyeCheckbox.CheckState = CheckState.Checked Then .Add(BodyPart.LeftIris) Else .Remove(BodyPart.LeftIris)
                If RightEyeCheckBox.CheckState = CheckState.Checked Then .Add(BodyPart.RightIris) Else .Remove(BodyPart.RightIris)
            End With

        End Sub


        Private Shared RightEyeCenter As New Point(152, 248)
        Private Shared LeftEyeCenter As New Point(279, 248)

        Private mLeftEyeOnly As Boolean
        Public Property LeftEyeOnly() As Boolean
            Get
                Return mLeftEyeOnly
            End Get
            Set(ByVal value As Boolean)
                mLeftEyeOnly = value
            End Set
        End Property

        Private mRightEyeOnly As Boolean
        Public Property RightEyeOnly() As Boolean
            Get
                Return mRightEyeOnly
            End Get
            Set(ByVal value As Boolean)
                mRightEyeOnly = value
            End Set
        End Property


        Private Sub PlaceCheckBox(ByVal checkBox As CheckBox, ByVal loc As Point)

            checkBox.Height = 13
            checkBox.Width = 13

            Dim newPoint As Point = MainPictureBox.RemapImagePoint(loc)

            newPoint.Y -= CInt(checkBox.Height / 2)
            newPoint.X -= CInt(checkBox.Width / 2)

            checkBox.Location = newPoint
            checkBox.Size = GlobalUISettings.ControlSizes.CheckBox

        End Sub

        Private Sub PlaceLabelAtopCheckbox(ByVal label As Label, ByVal checkbox As CheckBox)
            Dim x As Integer = checkbox.Location.X + CInt(checkbox.Width / 2) - CInt(label.Width / 2)
            Dim y As Integer = checkbox.Location.Y - label.Height
            label.Location = New Point(x, y)
        End Sub

        Protected Overrides Sub LayoutCheckboxes()
            PlaceCheckBox(RightEyeCheckBox, RightEyeCenter)
            PlaceCheckBox(LeftEyeCheckbox, LeftEyeCenter)
        End Sub


        Protected Overrides Sub RefreshCheckboxes()
            LeftEyeCheckbox.Enabled = MyBase.Enabled
            RightEyeCheckBox.Enabled = MyBase.Enabled

            If RightEyeOnly Then LeftEyeCheckbox.Enabled = False
            If LeftEyeOnly Then RightEyeCheckBox.Enabled = False
        End Sub


        Private Sub RightEyeCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles RightEyeCheckBox.CheckedChanged, LeftEyeCheckbox.CheckedChanged
            RefreshCheckboxes()
            BindFromControlToWire()
        End Sub


        Public Overrides Sub Autosize(ByVal graphics As Graphics)
            MyBase.AutoSize(graphics)
        End Sub

        Protected Overrides Sub OnLoad(ByVal e as EventArgs)
            MyBase.OnLoad(e)
            RightEyeToolTip.SetToolTip(RightEyeCheckBox, Messages.RightIris)
            LeftEyeToolTip.SetToolTip(LeftEyeCheckbox, Messages.LeftIris)

        End Sub

        'reset all Iris check box - un-check all check box when new session starting
        Public Sub ResetIrisPickerControl()
            LeftEyeCheckbox.Checked = False
            RightEyeCheckBox.Checked = False
        End Sub
    End Class

End Namespace