''  ---
''  License
''  ---
''
''  This software was developed at the National Institute of Standards and
''  Technology (NIST) by employees of the Federal Government in the course
''  of their official duties. Pursuant to title 17 Section 105 of the
''  United States Code, this software is not subject to copyright protection
''  and is in the public domain. NIST assumes no responsibility  whatsoever for
''  its use by other parties, and makes no guarantees, expressed or implied,
''  about its quality, reliability, or any other characteristic.
''
''  ---
''  Disclaimer
''  ---
''  This software was developed to facilitate multimodal biometric data collection
''  for the Department of Homeland Security in accordance with Section 303 of the 
''  Border Security Act, codified as 8 U.S.C. 1732.  Specific hardware and software 
''  products identified in this software were used in order to perform the data 
''  collection. In no case does such identification imply recommendation or endorsement 
''  by the National Institute of Standards and Technology, nor does it imply that the 
''  products and equipment identified are necessarily the best available for the purpose.
''

Option Strict On
Imports log4net

Namespace Mbark.UI
    Public Module LogToFile
        Private mILog As ILog
        Private mLogFile As New log4net.Appender.FileAppender
        Private mIsLogMode As Boolean = True
        Private mFileName As String = "Capture.log"

        Public Sub ConfigureLog(ByVal lType As System.Type, ByVal PatternType As PatternStringType, ByVal Location As String)
            'Must be close inorder to change setting for File Appender
            CloseLog()

            If PatternType = PatternStringType.Start Then
                If IO.File.Exists(IO.Path.Combine(Location, mFileName)) Then IO.File.Delete(IO.Path.Combine(Location, mFileName))
            End If

            mILog = LogManager.GetLogger(lType)

            mLogFile = New log4net.Appender.FileAppender
            mLogFile.File = IO.Path.Combine(Location, mFileName)
            Dim pattern As New log4net.Layout.PatternLayout(GetPatternString(PatternType))
            mLogFile.Layout = pattern
            mLogFile.Name = "Mbark.log"
            mLogFile.AppendToFile = True
            mLogFile.ImmediateFlush = True
            mLogFile.Threshold = log4net.Core.Level.Debug

            Config.BasicConfigurator.Configure(mLogFile)
            mLogFile.ActivateOptions()

        End Sub
        Public Sub CloseLog()
            mLogFile.Close()
        End Sub

        Public Sub WriteLine(ByVal OutputLevel As LogLevel, Optional ByVal message As String = Nothing)
            If IsLogMode Then
                Select Case OutputLevel
                    Case LogLevel.Debug
                        mILog.Debug(message)
                    Case LogLevel.Error
                        mILog.Error(message)
                    Case LogLevel.Fatal
                        mILog.Fatal(message)
                    Case LogLevel.Info
                        mILog.Info(message)
                    Case LogLevel.Warning
                        mILog.Warn(message)
                End Select
            End If
        End Sub

        Private ReadOnly Property GetPatternString(ByVal type As PatternStringType) As String
            Get
                Select Case type
                    Case PatternStringType.Start ' start of the data collect ex: header, footer
                        Return "%message%n%date " & NoldusCode.MbarkStartSession & " %n"
                    Case PatternStringType.Content ' data
                        Return "%date %message%n"
                    Case PatternStringType.End
                        Return "%date " & NoldusCode.MbarkEndSession & "%n"
                    Case Else
                        Return ""
                End Select
            End Get
        End Property

        Public Property IsLogMode() As Boolean
            Get
                Return mIsLogMode
            End Get
            Set(ByVal Value As Boolean)
                mIsLogMode = Value
            End Set
        End Property
        Public Enum LogLevel
            Debug
            [Error]
            Fatal
            Info
            Warning
        End Enum
        Public Enum PatternStringType
            Start
            Content
            [End]
        End Enum
    End Module

End Namespace

