Option Strict On

Imports System.Globalization
Imports System.Xml.Serialization

Namespace Mbark

    <XmlType("RuntimeLocalizableString")> _
    Public Class LocalizableString

        Private mMessageTable As New Hashtable

        Default Public Property Message(ByVal region As String) As String
            Get
                Return DirectCast(mMessageTable(region), String)
            End Get
            Set(ByVal value As String)
                mMessageTable(region) = value
            End Set
        End Property

        Public Property ByCulture(ByVal culture As CultureInfo) As String
            Get
                If culture Is Nothing Then
                    Return DirectCast(mMessageTable(CultureInfo.CurrentUICulture.Name), String)
                Else
                    Return DirectCast(mMessageTable(culture.Name), String)
                End If
            End Get
            Set(ByVal Value As String)
                If culture Is Nothing Then Throw New ArgumentNullException("culture")
                mMessageTable(culture.Name) = Value
            End Set
        End Property

        Public Function CreateDefinition() As LocalizableStringDefinition
            Dim newDef As New LocalizableStringDefinition
            Dim en As IEnumerator = mMessageTable.Keys.GetEnumerator
            While en.MoveNext
                Dim region As String = DirectCast(en.Current, String)
                Dim message As String = Me(region)
                Dim pair As New RegionMessagePair(region, message)
                newDef.RegionMessagePairs.Add(pair)
            End While
            Return newDef
        End Function


    End Class


    <XmlType("RegionMessagePair"), Serializable()> Public Class RegionMessagePair
        Private mRegion As String
        Private mMessage As String

        Public Property Region() As String
            Get
                Return mRegion
            End Get
            Set(ByVal Value As String)
                mRegion = Value
            End Set
        End Property

        Public Property Message() As String
            Get
                Return mMessage
            End Get
            Set(ByVal Value As String)
                mMessage = Value
            End Set
        End Property

        Public Sub New()
        End Sub

        Public Sub New(ByVal region As String, ByVal message As String)
            mRegion = region
            mMessage = message
        End Sub

    End Class

    <XmlType("LocalizableString"), Serializable()> Public Class LocalizableStringDefinition
        Implements ICloneable

        Private mRegionMessagePairs As New SimpleRegionMessagePairCollection
        Public ReadOnly Property RegionMessagePairs() As SimpleRegionMessagePairCollection
            Get
                Return mRegionMessagePairs
            End Get
        End Property

        Public Function Clone() As Object Implements System.ICloneable.Clone
            Dim newDef As New LocalizableStringDefinition
            newDef.RegionMessagePairs.AddRange(mRegionMessagePairs)
            Return newDef
        End Function

        Public Function DeepCopy() As LocalizableStringDefinition
            Return DirectCast(Clone(), LocalizableStringDefinition)
        End Function

        Public Function CreateLocalizableString() As LocalizableString
            Dim newLocalizableString As New LocalizableString
            For i As Integer = 0 To RegionMessagePairs.Count - 1
                newLocalizableString(RegionMessagePairs(i).Region) = RegionMessagePairs(i).Message
            Next
            Return newLocalizableString
        End Function

    End Class

End Namespace
