'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Drawing

Namespace Mbark.Sensors

    <Serializable()> Public Class SensorTaskColorsDefinition
        Implements ICloneable

        Private mInactive As Integer
        Public Property Inactive() As Integer
            Get
                Return mInactive
            End Get
            Set(Byval value As Integer)
                mInactive = value
            End Set
        End Property
        Private mConflictTextColor As Integer
        Public Property ConflictTextColor() As Integer
            Get
                Return mConflictTextColor
            End Get
            Set(Byval value As Integer)
                mConflictTextColor = value
            End Set
        End Property
        Private mActive As Integer
        Public Property Active() As Integer
            Get
                Return mActive
            End Get
            Set(Byval value As Integer)
                mActive = value
            End Set
        End Property
        Private mDownloadProgressBar As Integer
        Public Property DownloadProgressBar() As Integer
            Get
                Return mDownloadProgressBar
            End Get
            Set(Byval value As Integer)
                mDownloadProgressBar = value
            End Set
        End Property

        Public Function CreateSensorTaskColors() As SensorTaskColors
            Dim newColors As New SensorTaskColors
            newColors.Active = Color.FromArgb(Active)
            newColors.Inactive = Color.FromArgb(Inactive)
            newColors.DownloadProgressBar = Color.FromArgb(DownloadProgressBar)
            newColors.ConflictTextColor = Color.FromArgb(ConflictTextColor)
            Return newColors
        End Function

        Public Function Clone() As Object Implements System.ICloneable.Clone
            Dim newDef As New SensorTaskColorsDefinition
            newDef.Inactive = Inactive
            newDef.Active = Active
            newDef.ConflictTextColor = ConflictTextColor
            newDef.DownloadProgressBar = DownloadProgressBar
            Return newDef
        End Function

        Public Function DeepCopy() As SensorTaskColorsDefinition
            Return DirectCast(Clone(), SensorTaskColorsDefinition)
        End Function
    End Class

    Public Class SensorTaskColors

        Public Function Definition() As SensorTaskColorsDefinition
            Dim newDef As New SensorTaskColorsDefinition
            With newDef
                .Active = mActive.ToArgb
                .Inactive = mInactive.ToArgb
                .ConflictTextColor = mConflictTextColor.ToArgb
                .DownloadProgressBar = mDownloadProgressBar.ToArgb
            End With
            Return newDef
        End Function

        Private mInactive As Color
        Private mConflictTextColor As Color
        Private mActive As Color
        Private mDownloadProgressBar As Color

        Public Property Inactive() As Color
            Get
                Return mInactive
            End Get
            Set(ByVal value As Color)
                mInactive = value
            End Set
        End Property

        Public Property DownloadProgressBar() As Color
            Get
                Return mDownloadProgressBar
            End Get
            Set(ByVal value As Color)
                mDownloadProgressBar = value
            End Set
        End Property


        Public Property ConflictTextColor() As Color
            Get
                Return mConflictTextColor
            End Get
            Set(ByVal value As Color)
                mConflictTextColor = value
            End Set
        End Property

        Public Property Active() As Color
            Get
                Return mActive
            End Get
            Set(ByVal value As Color)
                mActive = value
            End Set
        End Property
    End Class


End Namespace
