'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Windows.Forms

Imports Mbark.UI.GlobalUISettings

Namespace Mbark.Sensors

    Public Class BooleanCondition
        Inherits Condition

        Public Overloads Function Equals(ByVal arg As Boolean) As Boolean
            Return DirectCast(Value, Boolean) = arg
        End Function
        Public Overrides Property Value() As Object
            Get
                If MyBase.Value Is Nothing Then Return False Else Return MyBase.Value
            End Get
            Set(ByVal value As Object)
                If Prerequisite Is Nothing OrElse Prerequisite.Evaluate Then
                    MyBase.Value = value
                Else
                    MyBase.Value = Nothing
                End If
            End Set
        End Property

        Private mDefinition As New BooleanConditionDefinition

        Private mStandaloneTrueString As LocalizableString
        Private mStandaloneFalseString As LocalizableString
        Private mStandaloneInvalidString As LocalizableString
        Private mCompoundTrueString As LocalizableString
        Private mCompoundFalseString As LocalizableString
        Private mCompoundInvalidString As LocalizableString

        Friend Sub New( _
            ByVal initialValue As Boolean, _
            ByVal standaloneTrueString As LocalizableString, _
            ByVal standaloneFalseString As LocalizableString, _
            ByVal standaloneInvalidString As LocalizableString, _
            ByVal compoundTrueString As LocalizableString, _
            ByVal compoundFalseString As LocalizableString, _
            ByVal compoundInvalidString As LocalizableString)

            ' Only factories should be able to create contidions

            MyBase.New()
            MyBase.InitialValue(initialValue)


            mStandaloneTrueString = standaloneTrueString
            mStandaloneFalseString = standaloneFalseString
            mStandaloneInvalidString = standaloneInvalidString

            mCompoundTrueString = compoundTrueString
            mCompoundFalseString = compoundFalseString
            mCompoundInvalidString = compoundInvalidString

        End Sub


        Public Overrides Function StandaloneToString() As String
            If Not IsValid Then Return mStandaloneInvalidString(Application.CurrentCulture.Name)
            If DirectCast(Value, Boolean) Then Return mStandaloneTrueString(Application.CurrentCulture.Name)
            Return mStandaloneFalseString(Application.CurrentCulture.Name)
        End Function

        Public Overrides Function CompoundToString() As String
            If Not IsValid Then Return mCompoundInvalidString(Application.CurrentCulture.Name)
            If DirectCast(Value, Boolean) Then Return mCompoundTrueString(Application.CurrentCulture.Name)
            Return mCompoundFalseString(Application.CurrentCulture.Name)
        End Function


        Friend Overrides Function DeepCopyValue() As Object
            Dim val As Boolean = DirectCast(Value, Boolean)
            If val Then Return CObj(True) Else Return CObj(False)
        End Function


        Friend Overrides Function Definition(ByVal factories As ArrayList) _
        As ConditionDefinition
            mDefinition.StandaloneTrueStringDefinition = mStandaloneTrueString.CreateDefinition
            mDefinition.StandaloneFalseStringDefinition = mStandaloneFalseString.CreateDefinition
            mDefinition.StandaloneInvalidStringDefinition = mStandaloneInvalidString.CreateDefinition

            mDefinition.CompoundTrueStringDefinition = mCompoundTrueString.CreateDefinition
            mDefinition.CompoundFalseStringDefinition = mCompoundFalseString.CreateDefinition
            mDefinition.CompoundInvalidStringDefinition = mCompoundInvalidString.CreateDefinition

            mDefinition.OriginatingFactoryIndex = factories.IndexOf(OriginatingFactory)
            mDefinition.BooleanValue = CType(Value, Boolean)
            mDefinition.PrerequisiteDefinition = MyBase.Prerequisite.CreateDefinition
            Return mDefinition.DeepCopy
        End Function
    End Class

    <Serializable()> Public Class BooleanConditionDefinition
        Inherits ConditionDefinition

#Region "Private"


        Private mBooleanValue As Boolean
        Private mCompoundFalseStringDefinition As New LocalizableStringDefinition
        Private mCompoundInvalidStringDefinition As New LocalizableStringDefinition
        Private mCompoundTrueStringDefinition As New LocalizableStringDefinition
        Private mStandaloneFalseStringDefinition As New LocalizableStringDefinition
        Private mStandaloneInvalidStringDefinition As New LocalizableStringDefinition
        Private mStandaloneTrueStringDefinition As New LocalizableStringDefinition
#End Region

#Region "Properties"
        Public Property StandaloneFalseStringDefinition() As LocalizableStringDefinition
            Get
                Return mStandaloneFalseStringDefinition
            End Get
            Set(ByVal Value As LocalizableStringDefinition)
                mStandaloneFalseStringDefinition = Value
            End Set
        End Property
        Public Property CompoundTrueStringDefinition() As LocalizableStringDefinition
            Get
                Return mCompoundTrueStringDefinition
            End Get
            Set(ByVal Value As LocalizableStringDefinition)
                mCompoundTrueStringDefinition = Value
            End Set
        End Property

        Public Property StandaloneTrueStringDefinition() As LocalizableStringDefinition
            Get
                Return mStandaloneTrueStringDefinition
            End Get
            Set(ByVal Value As LocalizableStringDefinition)
                mStandaloneTrueStringDefinition = Value
            End Set
        End Property

        Public Property StandaloneInvalidStringDefinition() As LocalizableStringDefinition
            Get
                Return mStandaloneInvalidStringDefinition
            End Get
            Set(ByVal Value As LocalizableStringDefinition)
                mStandaloneInvalidStringDefinition = Value
            End Set
        End Property
        Public Property CompoundFalseStringDefinition() As LocalizableStringDefinition
            Get
                Return mCompoundFalseStringDefinition
            End Get
            Set(ByVal Value As LocalizableStringDefinition)
                mCompoundFalseStringDefinition = Value
            End Set
        End Property
        Public Property CompoundInvalidStringDefinition() As LocalizableStringDefinition
            Get
                Return mCompoundInvalidStringDefinition
            End Get
            Set(ByVal Value As LocalizableStringDefinition)
                mCompoundInvalidStringDefinition = Value
            End Set
        End Property
        Public Property BooleanValue() As Boolean
            Get
                Return mBooleanValue
            End Get
            Set(ByVal Value As Boolean)
                mBooleanValue = Value
            End Set
        End Property
#End Region

#Region "Clone"
        Public Overrides Function Clone() As Object
            Dim newDef As New BooleanConditionDefinition
            CloneImplementation(newDef)
            Return newDef
        End Function

        Protected Overloads Sub CloneImplementation(ByVal definition As BooleanConditionDefinition)
            If definition Is Nothing Then Throw New ArgumentNullException("definition")
            MyBase.CloneImplementation(definition)
            definition.StandaloneTrueStringDefinition = StandaloneTrueStringDefinition.DeepCopy
            definition.StandaloneFalseStringDefinition = StandaloneFalseStringDefinition.DeepCopy
            definition.StandaloneInvalidStringDefinition = StandaloneInvalidStringDefinition.DeepCopy
            definition.CompoundTrueStringDefinition = CompoundTrueStringDefinition.DeepCopy
            definition.CompoundFalseStringDefinition = CompoundFalseStringDefinition.DeepCopy
            definition.CompoundInvalidStringDefinition = CompoundInvalidStringDefinition.DeepCopy
            definition.BooleanValue = BooleanValue
        End Sub
#End Region

        Public Overrides Function CreateCondition( _
            ByVal conditions As ConditionCollection, _
            ByVal factory As ConditionFactory) As Condition

            If factory Is Nothing Then Throw New ArgumentNullException("factory")


            Dim condition As New BooleanCondition( _
                CType(BooleanValue, Boolean), _
                StandaloneTrueStringDefinition.CreateLocalizableString, _
                StandaloneFalseStringDefinition.CreateLocalizableString, _
                StandaloneInvalidStringDefinition.CreateLocalizableString, _
                CompoundTrueStringDefinition.CreateLocalizableString, _
                CompoundFalseStringDefinition.CreateLocalizableString, _
                CompoundInvalidStringDefinition.CreateLocalizableString)

            If Not PrerequisiteDefinition Is Nothing Then
                condition.Prerequisite = PrerequisiteDefinition.DeepCopy.CreatePredicate(conditions)
            End If

            condition.WireOriginatingFactory(factory)
            Return condition
        End Function


    End Class



End Namespace
