'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Kayee Kwong (kayee@nist.gov)
'       Ross J. Micheals (rossm@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 


Option Strict On

Namespace Mbark.Sensors

    Public Interface IFaceSensor

        Property IsDownloadCanceled() As Boolean
        Function Open() As Boolean

        Function Init(ByVal lcdMode As Integer, ByVal zoom As Double, ByVal flashMode As Boolean) As Boolean
        Function Init(ByVal usabilityMode As Boolean) As Boolean
        Function Init() As Boolean

        Sub Close()
        Function Capture(ByVal UseNineCamera As Boolean) As Boolean
        ReadOnly Property GetPictureIndexList() As Integer()

        Sub Refresh()
        Sub DeleteAll(ByVal usabilityMode As Boolean)
        Sub DeleteLast()

        Function SaveCaptureProperties(ByVal propertyList As Hashtable) As Boolean
        Function GetCaptureProperties(ByVal propertyList As Hashtable) As Boolean
        ReadOnly Property PictureCount(ByVal cameraNumber As Integer) As Integer

        Function Picture(ByVal CamNum As Integer, ByVal index As Integer) As Byte()
        Function DownloadThumbnail(ByVal PictureIndexList() As Integer) As Boolean
        ReadOnly Property Thumbnails() As Byte()()()

        Sub Status(ByVal cameraCount As Integer, ByVal cameraIDs() As String)
        Sub Reset()

        Function RequireConnect() As Boolean
        Sub RequireDisconnect()

        ReadOnly Property CameraCount() As Integer
        ReadOnly Property ConfigurationType() As Type

        Sub SetCameraIds(ByVal cameraId() As String)
        ReadOnly Property GetCameraID() As String()
        ReadOnly Property IsFull() As Boolean
        Sub Uninitialize()
    End Interface

End Namespace

