' 
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Drawing
Imports System.Globalization
Imports System.Windows.Forms

Imports Mbark.UI
Imports Mbark.SensorMessages

Namespace Mbark.Sensors

    Public Class ControllerButtonsPanel
        Inherits System.Windows.Forms.UserControl
        Implements IAutosizable
        Implements IHasUICulture

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call

        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents EndSessionButton As System.Windows.Forms.Button
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(ControllerButtonsPanel))
            Me.EndSessionButton = New System.Windows.Forms.Button
            Me.SuspendLayout()
            '
            'EndSessionButton
            '
            Me.EndSessionButton.AccessibleDescription = resources.GetString("EndSessionButton.AccessibleDescription")
            Me.EndSessionButton.AccessibleName = resources.GetString("EndSessionButton.AccessibleName")
            Me.EndSessionButton.Anchor = CType(resources.GetObject("EndSessionButton.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.EndSessionButton.BackgroundImage = CType(resources.GetObject("EndSessionButton.BackgroundImage"), System.Drawing.Image)
            Me.EndSessionButton.Dock = CType(resources.GetObject("EndSessionButton.Dock"), System.Windows.Forms.DockStyle)
            Me.EndSessionButton.Enabled = CType(resources.GetObject("EndSessionButton.Enabled"), Boolean)
            Me.EndSessionButton.FlatStyle = CType(resources.GetObject("EndSessionButton.FlatStyle"), System.Windows.Forms.FlatStyle)
            Me.EndSessionButton.Font = CType(resources.GetObject("EndSessionButton.Font"), System.Drawing.Font)
            Me.EndSessionButton.Image = CType(resources.GetObject("EndSessionButton.Image"), System.Drawing.Image)
            Me.EndSessionButton.ImageAlign = CType(resources.GetObject("EndSessionButton.ImageAlign"), System.Drawing.ContentAlignment)
            Me.EndSessionButton.ImageIndex = CType(resources.GetObject("EndSessionButton.ImageIndex"), Integer)
            Me.EndSessionButton.ImeMode = CType(resources.GetObject("EndSessionButton.ImeMode"), System.Windows.Forms.ImeMode)
            Me.EndSessionButton.Location = CType(resources.GetObject("EndSessionButton.Location"), System.Drawing.Point)
            Me.EndSessionButton.Name = "EndSessionButton"
            Me.EndSessionButton.RightToLeft = CType(resources.GetObject("EndSessionButton.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.EndSessionButton.Size = CType(resources.GetObject("EndSessionButton.Size"), System.Drawing.Size)
            Me.EndSessionButton.TabIndex = CType(resources.GetObject("EndSessionButton.TabIndex"), Integer)
            Me.EndSessionButton.Text = resources.GetString("EndSessionButton.Text")
            Me.EndSessionButton.TextAlign = CType(resources.GetObject("EndSessionButton.TextAlign"), System.Drawing.ContentAlignment)
            Me.EndSessionButton.Visible = CType(resources.GetObject("EndSessionButton.Visible"), Boolean)
            '
            'ControllerButtonsPanel
            '
            Me.AccessibleDescription = resources.GetString("$this.AccessibleDescription")
            Me.AccessibleName = resources.GetString("$this.AccessibleName")
            Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
            Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
            Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
            Me.BackColor = System.Drawing.SystemColors.Control
            Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
            Me.Controls.Add(Me.EndSessionButton)
            Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
            Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
            Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
            Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
            Me.Name = "ControllerButtonsPanel"
            Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.Size = CType(resources.GetObject("$this.Size"), System.Drawing.Size)
            Me.ResumeLayout(False)

        End Sub

#End Region

        Private mUICulture As CultureInfo = CultureInfo.CurrentUICulture
        Public Property UICulture() As CultureInfo Implements IHasUICulture.UICulture
            Get
                Return mUICulture
            End Get
            Set(ByVal Value As CultureInfo)
                mUICulture = Value
            End Set
        End Property

        Dim mButtons As New ArrayList
        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            mButtons.Add(EndSessionButton)
        End Sub

        Public Sub RefreshAutomaticLayout(ByVal graphics As System.Drawing.Graphics) _
        Implements UI.IAutosizable.RefreshAutomaticLayout

            EndSessionButton.Text = Messages.EndSessionButtonText(UICulture)
            EndSessionButton.Font = GlobalUISettings.Defaults.Fonts.Button
            UI.AutoSize.Buttons(graphics, mButtons)

            Dim endSessionButtonXLocation As Integer = Me.Width - EndSessionButton.Width
            EndSessionButton.Location = New Point(endSessionButtonXLocation + DockPadding.Left - DockPadding.Right, DockPadding.Top)

            mMinimumwidth = EndSessionButton.Width + DockPadding.Left + DockPadding.Right
            mMinimumHeight = EndSessionButton.Height + DockPadding.Top + DockPadding.Bottom

        End Sub

        Private mMinimumHeight As Integer
        Public ReadOnly Property MinimumHeight() As Integer Implements UI.IAutosizable.MinimumHeight
            Get
                Return mMinimumHeight
            End Get
        End Property

        Private mMinimumwidth As Integer
        Public ReadOnly Property MinimumWidth() As Integer Implements UI.IAutosizable.MinimumWidth
            Get

                Return mMinimumwidth
            End Get
        End Property

        Public ReadOnly Property NearestForm() As System.Windows.Forms.Form Implements UI.IAutosizable.NearestForm
            Get
                Return FindNearestForm(Me)
            End Get
        End Property

        Private mTabArray As ArrayList
        Public ReadOnly Property TabList() As ArrayList
            Get
                If EndSessionButton.Enabled Then
                    mTabArray = New ArrayList
                    mTabArray.Insert(0, EndSessionButton)
                    Return mTabArray
                End If
                Return Nothing
            End Get
        End Property
    End Class

End Namespace