'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Namespace Mbark.Sensors

    Public Class CaptureResultCollection
        Implements ICollection

        ' A CaptureResultCollection provides a collection of CaptureResults. For the purposes of easy serialization
        ' the collection is implemented via a SimpleCaptureResultCollection.

        Private mResults As SimpleCaptureResultCollection

        Public ReadOnly Property Results() As SimpleCaptureResultCollection
            Get
                If mResults Is Nothing Then mResults = New SimpleCaptureResultCollection
                Return mResults
            End Get
        End Property


        Default Property Result(ByVal index As Integer) As CaptureResult
            Get
                Return Results(index)
            End Get
            Set(ByVal value As CaptureResult)
                Results(index) = value
            End Set
        End Property

        Public Function Definition() As CaptureResultCollectionDefinition
            Dim newDef As New CaptureResultCollectionDefinition
            For i As Integer = 0 To Results.Count - 1
                newDef.ResultDefinitions.Add(Results(i).CreateDefinition)
            Next
            Return newDef
        End Function

#Region "ICollection Implementation"

        Public Sub CopyTo(ByVal array As System.Array, ByVal index As Integer) Implements ICollection.CopyTo
            mResults.CopyTo(array, index)
        End Sub

        Public Sub CopyTo(ByVal results As CaptureResultCollection, ByVal index As Integer)
            If results Is Nothing Then Throw New ArgumentNullException("results")
            mResults.CopyTo(results.mResults, index)
        End Sub

        Public ReadOnly Property Count() As Integer Implements ICollection.Count
            Get
                Return Results.Count
            End Get
        End Property

        Public ReadOnly Property IsSynchronized() As Boolean Implements ICollection.IsSynchronized
            Get
                Return mResults.IsSynchronized
            End Get
        End Property

        Public ReadOnly Property SyncRoot() As Object Implements ICollection.SyncRoot
            Get
                Return mResults.SyncRoot
            End Get
        End Property

        Public Function GetEnumerator() As IEnumerator Implements IEnumerable.GetEnumerator
            Return mResults.GetEnumerator
        End Function
#End Region

    End Class


End Namespace
