''  ---
''  License
''  ---
''
''  This software was developed at the National Institute of Standards and
''  Technology (NIST) by employees of the Federal Government in the course
''  of their official duties. Pursuant to title 17 Section 105 of the
''  United States Code, this software is not subject to copyright protection
''  and is in the public domain. NIST assumes no responsibility  whatsoever for
''  its use by other parties, and makes no guarantees, expressed or implied,
''  about its quality, reliability, or any other characteristic.
''
''  ---
''  Disclaimer
''  ---
''  This software was developed to facilitate multimodal biometric data collection
''  for the Department of Homeland Security in accordance with Section 303 of the 
''  Border Security Act, codified as 8 U.S.C. 1732.  Specific hardware and software 
''  products identified in this software were used in order to perform the data 
''  collection. In no case does such identification imply recommendation or endorsement 
''  by the National Institute of Standards and Technology, nor does it imply that the 
''  products and equipment identified are necessarily the best available for the purpose.
''

Option Strict On

Namespace Mbark

    Public Class FieldList

        Public Shared Function NewEmptyList() As FieldList
            Return New FieldList
        End Function

        Public Shared Function NewFullList(ByVal fieldCount As Integer) As FieldList
            Dim list As New FieldList
            For i As Integer = 0 To fieldCount - 1
                list.Add(i)
            Next
            Return list
        End Function

        Function Add(ByVal fieldIndex As Integer) As FieldList
            mFields.Add(fieldIndex)
            Return Me
        End Function

        Function Remove(ByVal fieldIndex As Integer) As FieldList
            mFields.Remove(fieldIndex)
            Return Me
        End Function

        ReadOnly Property Items() As IList
            Get
                Return mFields
            End Get
        End Property

        Default ReadOnly Property Item(ByVal index As Integer) As Integer
            Get
                Return CType(mFields(index), Integer)
            End Get
        End Property

        Private mFields As New ArrayList

        Private Sub New()
        End Sub

    End Class

End Namespace