'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Delegate
Imports System.Drawing
Imports System.Globalization
Imports System.Threading


Imports CM_SCANCTRLLib

Imports Mbark.UI
Imports Mbark.Threading



Namespace Mbark.Sensors

    Public Class CrossMatchSensor
        Inherits BaseSensor

        Private Const ID500CriticalTime As Integer = 3000
        Private Const ID700CriticalTime As Integer = 3000
        Private Const GuardianCriticalTime As Integer = 3000


        Private Const CaptureCommandExpirationTime As Integer = 12000 'ms 
        Private Const InitializationExpirationTime As Integer = 30000 'ms
        Private Const DownloadCommandExpirationTime As Integer = 5000 'ms
        Private Const ConfigurationCommandExpirationTime As Integer = 10000 'ms

        Private Const ID500AspectRatio As Single = 1808.0! / 1024.0!
        Private Const ID700AspectRatio As Single = 1600.0! / 1500.0!
        Private Const GuardianAspectRatio As Single = 1600.0! / 1500.0!

        Private Const InternalDetectedFingerprintsDelay As Integer = 500
        Private Const InternalPrintsDetectedTimeout As Integer = 5000
        Private Const InternalNoActivityTimeout As Integer = 10000


#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call
            UserNew()
        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If

            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents mCrossMatch As AxCM_SCANCTRLLib.AxScanCtrl

        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(CrossMatchSensor))
            Me.mCrossMatch = New AxCM_SCANCTRLLib.AxScanCtrl
            Me.InnerPanel.SuspendLayout()
            CType(Me.OuterPanel, System.ComponentModel.ISupportInitialize).BeginInit()
            Me.OuterPanel.SuspendLayout()
            Me.MainPanel.SuspendLayout()
            CType(Me.mCrossMatch, System.ComponentModel.ISupportInitialize).BeginInit()
            Me.SuspendLayout()
            '
            'InnerPanel
            '
            Me.InnerPanel.Name = "InnerPanel"
            Me.InnerPanel.Size = New System.Drawing.Size(342, 230)
            Me.InnerPanel.TabIndex = 2
            '
            'OuterPanel
            '
            Me.OuterPanel.Name = "OuterPanel"
            Me.OuterPanel.Size = New System.Drawing.Size(344, 312)
            Me.OuterPanel.TabIndex = 0
            '
            'ActivateSensorButton
            '
            Me.ActivateSensorButton.Name = "ActivateSensorButton"
            Me.ActivateSensorButton.TabIndex = 0
            '
            'CancelSensorButton
            '
            Me.CancelSensorButton.Name = "CancelSensorButton"
            Me.CancelSensorButton.TabIndex = 1
            '
            'MainPanel
            '
            Me.MainPanel.Controls.Add(Me.mCrossMatch)
            Me.MainPanel.Name = "MainPanel"
            Me.MainPanel.Size = New System.Drawing.Size(384, 264)
            '
            'TimeoutIndicator
            '
            Me.TimeoutIndicator.Name = "TimeoutIndicator"
            Me.TimeoutIndicator.Size = New System.Drawing.Size(342, 16)
            Me.TimeoutIndicator.TabIndex = 0
            '
            'mCrossMatch
            '
            Me.mCrossMatch.ContainingControl = Me
            Me.mCrossMatch.Dock = System.Windows.Forms.DockStyle.Fill
            Me.mCrossMatch.Location = New System.Drawing.Point(0, 0)
            Me.mCrossMatch.Name = "mCrossMatch"
            Me.mCrossMatch.OcxState = CType(resources.GetObject("mCrossMatch.OcxState"), System.Windows.Forms.AxHost.State)
            Me.mCrossMatch.Size = New System.Drawing.Size(384, 264)
            Me.mCrossMatch.TabIndex = 0
            '
            'CrossMatchSensor
            '
            Me.Name = "CrossMatchSensor"
            Me.Size = New System.Drawing.Size(344, 312)
            Me.InnerPanel.ResumeLayout(False)
            CType(Me.OuterPanel, System.ComponentModel.ISupportInitialize).EndInit()
            Me.OuterPanel.ResumeLayout(False)
            Me.MainPanel.ResumeLayout(False)
            CType(Me.mCrossMatch, System.ComponentModel.ISupportInitialize).EndInit()
            Me.ResumeLayout(False)

        End Sub

#End Region

        Public Sub UserNew()

        
            AddHandler mCrossMatch.DetectedFingerprints, AddressOf mCrossMatch_DetectedFingerprints
            AddHandler mCrossMatch.NoActivityTimeout, AddressOf mCrossMatch_NoActivityTimeout

        End Sub

        Private mActive As Boolean = False
        Private mAutoMode As Boolean = False 'this mode can be set by the user from the interface in the future

        Protected Delegate Function ProcessDelegate() As Object
        Protected Delegate Function CaptureDelegate(ByVal CmdGuid As Guid) As Object
        Private mModality As SensorModality = SensorModality.Fingerprint
        Public Overrides ReadOnly Property Modality() As SensorModality
            Get
                Return mModality
            End Get
        End Property
        Public Overrides ReadOnly Property IsActive() As Boolean
            Get
                Return mActive
            End Get
        End Property

        Private mName As String = "CrossMatch"
        Public Overrides ReadOnly Property FriendlyName() As String
            Get
                Return mName
            End Get
        End Property

#Region "       Initialization         "

        Public Overrides ReadOnly Property InitializationCommandTemplate() As Threading.AsyncCommandTemplate
            Get
                Static init As AsyncCommandTemplate
                If init Is Nothing Then
                    init = New AsyncCommandTemplate
                    With init
                        .TargetMethod = CreateDelegate(GetType(ProcessDelegate), Me, "Initialization")
                        .ExpirationTime = InitializationExpirationTime
                        .IgnoreUnderlyingHandleOfTargetControl = True
                    End With
                End If
                Return init
            End Get
        End Property
        'Initialization helper function 

        Private mIsInitialized As Boolean = False
        Private mSensorCalibrate As Boolean = False
        Private Function Initialization() As Object

            With mCrossMatch
                Try
                    WritableRequiresRecovery = False
                    If .IsInitialized = 1 Then
                        'Check if it has initizlized
                        MarkAsOnline()
                        mIsInitialized = True
                        SensorProperties()
                    ElseIf .IsInitialized = 0 Then
                        ' Otherwise, initialize the senso
                        .Initialize()
                        If .DetectedScannersCount = 0 Then
                            WritableRequiresRecovery = True
                            MarkAsOffline()
                        End If
                        Dim lex As Exception
                        If Open(lex) Then
                            MarkAsOnline()
                            mIsInitialized = True
                            SensorProperties()
                            'Close()
                        Else
                            MarkAsOffline()
                            Throw New InitializationFailureException("CM: Initialization failed.", lex)
                        End If

                    End If

                    Dim scanner As String = .CurrentScanner

                    ' Correct the aspect ratio
                    If .CurrentScanner = ID700 Then MainPanelAspectRatio = ID700AspectRatio
                    If .CurrentScanner = ID500 Then MainPanelAspectRatio = ID500AspectRatio
                    If .CurrentScanner = Guardian Then MainPanelAspectRatio = GuardianAspectRatio


                    If .CurrentScanner = ID500 Then TimeoutIndicator.CriticalTime = ID500CriticalTime
                    If .CurrentScanner = ID700 Then TimeoutIndicator.CriticalTime = ID700CriticalTime
                    If .CurrentScanner = Guardian Then TimeoutIndicator.CriticalTime = GuardianCriticalTime


                Catch ex As Exception
                    WritableRequiresRecovery = True
                    MarkAsOffline()
                    Throw New InitializationFailureException("CM: Initialization failed.", ex)
                Finally
                    Thread.CurrentThread.Interrupt()
                End Try
            End With
        End Function
        Private mSensorProperties As New SensorProperties
        Private Sub SensorProperties()
            With mCrossMatch
                mSensorProperties.Manufacturer = "Cross Match"
                mSensorProperties.ModelName = .CurrentScanner ' 
                mName = "Cross Match " & .CurrentScanner
                mSensorProperties.SerialNumber = .SystemSerialNo
                mSensorProperties.VendorLibraryName = .ModuleName
                mSensorProperties.VendorLibraryVersion = .ModuleVersion
                mSensorProperties.Modality = Modality

            End With
        End Sub
#End Region

#Region "         Configuration         "
        Public Overrides ReadOnly Property ConfigurationCommandTemplate() As Threading.AsyncCommandTemplate
            Get
                Static config As AsyncCommandTemplate
                If config Is Nothing Then
                    config = New AsyncCommandTemplate
                    With config
                        .ExpirationTime = ConfigurationCommandExpirationTime
                        .IgnoreUnderlyingHandleOfTargetControl = True
                    End With
                End If
                Return config
            End Get
        End Property
        Public Sub Configuration(ByVal ConfigurationObj As Object)

        End Sub
#End Region

#Region "       Uninitialization        "
        Public Overrides Sub Uninitialize()
            MyBase.Uninitialize()
            With mCrossMatch
                If .IsInitialized = 1 Then
                    Close()
                    .Uninitialize()
                    mIsInitialized = False
                    mSensorCalibrate = False
                    MyBase.Uninitialize()
                End If
            End With
        End Sub
#End Region

#Region "       Capture         "
        Protected Friend mCaptureDone As Boolean
        Protected Friend mCaptureResult As Integer
        Private mTrueCaptureResultMethod As ResultMethod
        Private mCapturingFinger As New BodyParts

        Public Overrides ReadOnly Property CaptureCommandTemplate() As Threading.AsyncCommandTemplate
            Get
                Static Capture As AsyncCommandTemplate
                If Capture Is Nothing Then
                    Capture = New AsyncCommandTemplate
                    With Capture
                        .TargetMethod = CreateDelegate(GetType(ProcessDelegate), Me, "CaptureImage")
                        .ExpirationTime = CaptureCommandExpirationTime
                        .IgnoreUnderlyingHandleOfTargetControl = True
                    End With
                End If
                Return Capture
            End Get
        End Property

        Private Function CaptureImage() As Object
            mCaptureDone = False
            WritablePollingWasCanceled = False
            WritableLatestDownloadWasSuccessful = False
            WritableIsTimeOut = False
            Dim Hand As BodyParts = TargetParts()
            WritableLatestThumbnail = Nothing
            Try
                Dim exIn As Exception
                If Not Open(exIn) Then
                    MarkAsOffline()
                    Throw New SensorException("CM: Cannot open sensor for recording.", exIn)
                End If

                'Configure settings for reader
                If Not SetCurrentHand(Hand) Then
                    MarkAsOffline()
                    Throw New SensorException("CM: Problem configure settings")
                End If

                While (Not mCaptureDone) AndAlso (Not PollingWasCanceled) AndAlso (Not IsTimeout)
                    WaitWithDoEvents(50, 10)
                End While

                'Must stop the CounterTimer soon after Capture returns from the reader
                StopCountdownTimerNow()

                ' if timed out or capture is Canceled, then throw exceptions
                If IsTimeout Or PollingWasCanceled Then
                    MarkAsOnline()
                    If IsTimeout Then Throw New CaptureTimeoutException("CM: Recording timeout.")
                    If PollingWasCanceled Then Throw New PollingCanceledException("CM: Recording Canceled.")
                End If



                ' if capture result <> 0, it is a non-fatal exception
                If mCaptureResult <> SLAP_PROCESSING_RESULTS.PROCESSING_OK Then
                    MarkAsOnLine()
                    Throw New CaptureFailureException("CM: Recording error. Error: " & mCaptureResult)
                End If

                With mCrossMatch
                    Dim ticks As Long = DateTime.Now.Ticks

                    Dim ImgWidth As Integer = .FullImageWidth
                    Dim ImgHeight As Integer = .FullImageHeight
                    Dim Imgobj As Object = .FullImage
                    Dim FingerprintImage As Bitmap = FullImageToBitmap(.FullImage)

                    Dim lResult As New CaptureResult
                    lResult.ImageProperties.Image = FingerprintImage
                    lResult.SensorProperties = mSensorProperties

                    Dim CaptureResultList As New CaptureResultCollection
                    CaptureResultList.Results.Add(lResult)
                    WritableLatestThumbnail = FingerprintImage
                    Me.LastReviewImageAcceptable = True
                    MarkAsOnline()

                    Dim elapsed As Long = DateTime.Now.Ticks - ticks

                    Return CaptureResultList
                End With



            Catch ex As ThreadInterruptedException
                MarkAsOnline()
                Throw New CaptureTimeoutException("CM: Recording timeout.", ex)
            Finally
                TurnOffLiveMode()
                mCrossMatch.ClearImage()
                If mCrossMatch.CurrentScanner = ID500 Then
                    ClearDisplay()
                End If
            End Try

        End Function


        'Function gets call automically when reader detected fingerprints
        Private Sub mCrossMatch_DetectedFingerprints(ByVal sender As Object, ByVal e As AxCM_SCANCTRLLib._IScanCtrlEvents_DetectedFingerprintsEvent)
            Dim fingerprintData As Object
            Dim processingResults As SLAP_PROCESSING_RESULTS
            Dim qualityScore As Integer
            Dim missingFingers As FINGER_INDICATOR_EX = GetMissingFinger()
            '
            Try
                mCrossMatch.FetchFingerPrint(mCrossMatch.NextFingerToScan, missingFingers, fingerprintData, processingResults, qualityScore)
            Catch ex As Exception
                Debugger.Break()
            End Try
            mCaptureDone = True
            mCaptureResult = processingResults
        End Sub

        Private Sub mCrossMatch_NoActivityTimeout(ByVal sender As Object, ByVal e As System.EventArgs)
            WritableIsTimeOut = True
        End Sub

        'determine missing finger
        Private Function GetMissingFinger() As FINGER_INDICATOR_EX
            Dim MissingParts As BodyParts = InaccessibleParts()
            Dim MissingFingers, finger As FINGER_INDICATOR_EX
            Dim x As Integer
            If MissingParts.Count = 0 Then Return FINGER_INDICATOR_EX.FINGER_NONE_EX
            For x = 0 To MissingParts.Count - 1
                Select Case MissingParts.Items(x)
                    Case BodyPart.LeftIndex
                        finger = FINGER_INDICATOR_EX.LEFT_INDEX_FINGER
                    Case BodyPart.LeftMiddle
                        finger = FINGER_INDICATOR_EX.LEFT_MIDDLE_FINGER
                    Case BodyPart.LeftRing
                        finger = FINGER_INDICATOR_EX.LEFT_RING_FINGER
                    Case BodyPart.LeftLittle
                        finger = FINGER_INDICATOR_EX.LEFT_LITTLE_FINGER
                    Case BodyPart.LeftThumb
                        finger = FINGER_INDICATOR_EX.LEFT_THUMB_FINGER
                    Case BodyPart.RightIndex
                        finger = FINGER_INDICATOR_EX.RIGHT_INDEX_FINGER
                    Case BodyPart.RightMiddle
                        finger = FINGER_INDICATOR_EX.RIGHT_MIDDLE_FINGER
                    Case BodyPart.RightRing
                        finger = FINGER_INDICATOR_EX.RIGHT_RING_FINGER
                    Case BodyPart.RightLittle
                        finger = FINGER_INDICATOR_EX.RIGHT_LITTLE_FINGER
                    Case BodyPart.RightThumb
                        finger = FINGER_INDICATOR_EX.RIGHT_THUMB_FINGER
                End Select
                If MissingFingers = 0 Then
                    MissingFingers = finger
                Else
                    MissingFingers = MissingFingers Or finger
                End If
            Next
            Return MissingFingers
        End Function

        Public Function FullImageToBitmap(ByVal fullImageAsObject As Object) As Bitmap
            If EmptyPalette Is Nothing Then InitEmptyPalette()

            Dim fullImage As Array = CType(fullImageAsObject, Array)

            Try
                Dim maxRow As Integer = fullImage.GetUpperBound(0)
                Dim maxColumn As Integer = fullImage.GetUpperBound(1)
                Dim width As Integer = maxColumn + 1
                Dim height As Integer = maxRow + 1

                Dim imageAsBytes((maxColumn + 1) * (maxRow + 1) - 1) As Byte
                System.Buffer.BlockCopy(fullImage, 0, imageAsBytes, 0, fullImage.Length)

                Dim bmp As Bitmap = ConvertBytesAsObjectToBitmap(imageAsBytes, width, height)
                bmp.RotateFlip(RotateFlipType.Rotate270FlipNone)
                Return bmp
            Catch ex As Exception
                Debugger.Break()
            End Try

        End Function

#End Region

#Region "       Cross Match device      "
        Private Function Open(Optional ByRef rex As Exception = Nothing) As Boolean
            Try
                With mCrossMatch
                    If .DetectedScannersCount = 0 Then Return False
                    If .IsScannerOpen() = 0 Then
                        .OpenScanner()
                        If Not mSensorCalibrate Then .InitializeCalData()
                    End If

                    If .IsScannerCalibrated = 0 Then
                        Dim pStatus1, pStatus2 As Integer
                        .Calibrate(CALIBRATION_MODE.CAL__MODE_QUICK_CAL_ONLY, pStatus1, pStatus2)
                        mSensorCalibrate = True
                    End If

                End With
            Catch ex As Exception
                rex = ex
                'return false for all sensor failure
                Return False
            End Try
            Return True
        End Function
        Private Sub Close()
            Try
                With mCrossMatch
                    If .IsScannerOpen = 1 Then
                        .CloseScanner()
                    End If
                End With
            Catch ex As Exception

            End Try
        End Sub
        Private Function SetCurrentHand(ByVal Hand As BodyParts) As Boolean
            'Config Sensor to Auto mode, if sensor failed, return immediately
            If Not SetSensorProperty() Then Return False
            'Making sure live mode is off, if sensor failed, return immediately
            If Not TurnOffLiveMode() Then Return False
            With mCrossMatch

                If Hand.Equals(BodyParts.ForLeftSlapTask) Then
                    .NextFingerToScan = FINGER_INDICATOR_EX.LEFT_SLAP_FINGERS
                    If .CurrentScanner = ID500 Then SendDisplayToScanner(1, 0)
                    mCapturingFinger = BodyParts.ForLeftSlapTask

                ElseIf Hand.Equals(BodyParts.ForRightSlapTask) Then
                    .NextFingerToScan = FINGER_INDICATOR_EX.RIGHT_SLAP_FINGERS
                    If .CurrentScanner = ID500 Then SendDisplayToScanner(1, 2)
                    mCapturingFinger = BodyParts.ForRightSlapTask

                ElseIf Hand.Equals(BodyParts.ForThumbsSlapTask) Then
                    If .CurrentScanner = ID500 Then
                        .NextFingerToScan = FINGER_INDICATOR_EX.LEFT_SLAP_THUMB
                        SendDisplayToScanner(1, 14)
                    ElseIf .CurrentScanner = ID700 Or .CurrentScanner = Guardian Then
                        .NextFingerToScan = FINGER_INDICATOR_EX.TWO_THUMB_SLAPS
                    End If
                    mCapturingFinger = BodyParts.ForThumbsSlapTask
                End If

                'Display this page while annotating fingerprints 
                If .CurrentScanner = ID500 Then SendDisplayToScanner(3, 2)

                .set_LiveMode(1, LIVE_MODE.LIVE_MODE_ON)

            End With

            Return True
        End Function
        Private Function SetSensorProperty() As Boolean
            Try
                With mCrossMatch

                    ' Configure the scanner for automatic capture
                    .AutoFingerprintDetection = BOOL_EXT.TRUE_VALUE
                    .AutomatedHandDetection = BOOL_EXT.TRUE_VALUE
                    .FingerprintRotation = BOOL_EXT.TRUE_VALUE
                    .SequenceCheck = BOOL_EXT.TRUE_VALUE

                    .WriteProperty("detected_fingerprints_delay", "", InternalDetectedFingerprintsDelay)
                    .WriteProperty("prints_detected_timeout", "", InternalPrintsDetectedTimeout)
                    .WriteProperty("no_activity_timeout", "", InternalNoActivityTimeout)
                End With
            Catch ex As Exception
                'return false for all sensor failure
                Return False
            End Try

            Return True
        End Function

        Private Function TurnOffLiveMode() As Boolean
            Try
                ' Check if the scanner is in live mode, if so turn off live mode property
                With mCrossMatch
                    If .get_LiveMode(1) = LIVE_MODE.LIVE_MODE_ON Then .set_LiveMode(1, LIVE_MODE.LIVE_MODE_OFF)

                    If .CurrentFolder = ID500 Then
                        For i As Integer = 17 To 20
                            SendDisplayToScanner(i, 0)
                        Next
                    End If

                End With


            Catch ex As Exception
                ' rjm asks - Can we narrow down the scope of what we catch here?

                'return false for all sensor failure
                Return False
            End Try
            Return True
        End Function
        Private Sub ClearDisplay()
            Try
                SendDisplayToScanner(3, 12)
            Catch ex As Exception
                Return
            End Try
        End Sub

        ' Display message on scanner
        Private Sub SendDisplayToScanner(ByVal value As Integer, ByVal b As Byte)
            Dim varData As Object
            Dim fullAdd As Integer
            Dim shift As Integer = 8
            fullAdd = value << shift
            fullAdd = fullAdd + 213
            varData = b
            Try
                mCrossMatch.WriteDevice("disp", fullAdd, varData)
            Catch ex As Exception
                Return
            End Try
        End Sub
#End Region

#Region "       Download      "
        Protected Overrides Function CreateDownloadCommand(ByVal id As Guid) As AsyncCommand
            Dim DownloadCommand As New AsyncCommand(DownloadCommandTemplate)
            DownloadCommand.TargetMethodArg(0) = id
            Return DownloadCommand
        End Function

        Public Overrides ReadOnly Property DownloadCommandTemplate() As Threading.AsyncCommandTemplate
            Get
                Static download As AsyncCommandTemplate
                If download Is Nothing Then
                    download = New AsyncCommandTemplate
                    With download
                        .TargetMethod = CreateDelegate(GetType(DownloadDelegate), Me, "DownloadImage")
                        Dim args As Object() = {Guid.Empty}
                        .TargetMethodArgs(args)
                        .IgnoreUnderlyingHandleOfTargetControl = True
                        .ExpirationTime = DownloadCommandExpirationTime
                    End With
                End If
                Return download
            End Get
        End Property
        Private Delegate Function DownloadDelegate(ByVal id As Guid) As Object
        Private Function DownloadImage(ByVal id As Guid) As Object
        End Function
#End Region

        Protected Overrides Sub OnLoad(ByVal e As System.EventArgs)
            MyBase.OnLoad(e)
            WritablePollingWasCanceled = True
        End Sub

        Private Sub CancelSensorButton_Click(ByVal sender As Object, ByVal e As EventArgs) _
    Handles CancelSensorButton.Click
            WritablePollingWasCanceled = True
        End Sub

        Private Const ID500 As String = "id500"
        Private Const ID700 As String = "id700"
        Private Const Guardian As String = "guardian"

    End Class



End Namespace

