'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Xml.Serialization

Namespace Mbark.Sensors

    <XmlType("RuntimeConditionFactory")> _
    Public Class ConditionFactory

        Friend mPrerequisiteFactory As PredicateFactory
        Friend mDefinition As New ConditionFactoryDefinition
        Friend mConditionDescription As New LocalizableString

        'Private Shared mAllFactories As New ArrayList

        Public Sub New()
            MyBase.New()
            'mAllFactories.Add(Me)
        End Sub

        Public Property ConditionIsStatic() As Boolean
            Get
                Return mDefinition.ConditionIsStatic
            End Get
            Set(ByVal value As Boolean)
                mDefinition.ConditionIsStatic = value
            End Set
        End Property


        Public Sub InitializationArgs(ByVal ParamArray args As Object())
            mDefinition.InitializationArgs.AddRange(args)
        End Sub

        Public Property ConditionDescription() As LocalizableString
            Get
                Return mConditionDescription
            End Get
            Set(ByVal value As LocalizableString)
                mConditionDescription = value
            End Set
        End Property

        Public Property ConditionDescription(ByVal region As String) As String
            Get
                Return mConditionDescription(region)
            End Get
            Set(ByVal value As String)
                mConditionDescription(region) = value
            End Set
        End Property

        Public Property PrerequisiteFactory() As PredicateFactory
            Get
                If mPrerequisiteFactory Is Nothing Then Return Builtins.PredicateFactories.TrueLiteral
                Return mPrerequisiteFactory
            End Get
            Set(ByVal value As PredicateFactory)
                mPrerequisiteFactory = value
            End Set
        End Property

        Public Property ConditionType() As ConditionType
            Get
                Return mDefinition.ConditionType
            End Get
            Set(ByVal value As ConditionType)
                mDefinition.ConditionType = value
            End Set
        End Property

        Public Property ConditionInitialValue() As Object
            Get
                Return mDefinition.ConditionInitialValue
            End Get
            Set(ByVal value As Object)
                mDefinition.ConditionInitialValue = value
            End Set
        End Property

        Public Property ConditionName() As String
            Get
                Return mDefinition.ConditionName
            End Get
            Set(ByVal value As String)
                mDefinition.ConditionName = value
            End Set
        End Property


        Public Function Create(ByVal conditions As ConditionCollection) _
        As Condition
            Select Case mDefinition.ConditionType
                Case ConditionType.BooleanCondition
                    Dim val As Boolean = DirectCast(mDefinition.ConditionInitialValue, Boolean)

                    ' Transform each LocalizableStringDefinition to a LocalizableString
                    For i As Integer = 0 To 5
                        Dim arg As Object = mDefinition.InitializationArgs(i)
                        If arg.GetType().Equals(GetType(LocalizableStringDefinition)) Then
                            mDefinition.InitializationArgs(i) = DirectCast(arg, LocalizableStringDefinition).CreateLocalizableString
                        End If
                    Next

                    Create = New BooleanCondition( _
                        val, _
                        DirectCast(mDefinition.InitializationArgs(0), LocalizableString), _
                        DirectCast(mDefinition.InitializationArgs(1), LocalizableString), _
                        DirectCast(mDefinition.InitializationArgs(2), LocalizableString), _
                        DirectCast(mDefinition.InitializationArgs(3), LocalizableString), _
                        DirectCast(mDefinition.InitializationArgs(4), LocalizableString), _
                        DirectCast(mDefinition.InitializationArgs(5), LocalizableString))
            End Select

            If Not mPrerequisiteFactory Is Nothing Then Create.Prerequisite = mPrerequisiteFactory.CreatePredicate(conditions)

            Create.WireOriginatingFactory(Me)
        End Function

        Public Function CreateDefinition() As ConditionFactoryDefinition
            mDefinition.PrerequisiteFactoryDefinition = PrerequisiteFactory.Definition

            Select Case mDefinition.ConditionType
                Case ConditionType.BooleanCondition
                    For i As Integer = 0 To 5

                        ' Transform objects that are localizable strings to their definitions
                        Dim arg As Object = mDefinition.InitializationArgs(i)
                        If arg.GetType().Equals(GetType(LocalizableString)) Then
                            mDefinition.InitializationArgs(i) = DirectCast(arg, LocalizableString).CreateDefinition
                        End If
                    Next
            End Select
            mDefinition.ConditionDescriptionDefinition = mConditionDescription.CreateDefinition

            Return mDefinition.DeepCopy
        End Function



    End Class


    <XmlType("ConditionFactory"), Serializable()> Public Class ConditionFactoryDefinition
        Implements ICloneable


#Region "Private"

        Private mConditionName As String
        Private mConditionType As ConditionType
        Private mConditionIsStatic As Boolean
        Private mConditionDescriptionDefinition As LocalizableStringDefinition
        Private mConditionInitialValue As Object

        Friend mInitializationArgs As New ArrayList
        Private mPrerequisiteFactoryDefinition As PredicateFactoryDefinition
#End Region
        Public Property ConditionType() As ConditionType
            Get
                Return mConditionType
            End Get
            Set(ByVal Value As ConditionType)
                mConditionType = Value
            End Set
        End Property
        Public Property ConditionInitialValue() As Object
            Get
                Return mConditionInitialValue
            End Get
            Set(ByVal Value As Object)
                mConditionInitialValue = Value
            End Set
        End Property
        Public Property ConditionName() As String
            Get
                Return mConditionName
            End Get
            Set(ByVal Value As String)
                mConditionName = Value
            End Set
        End Property
        <XmlElement("ConditionDescription")> Public Property ConditionDescriptionDefinition() As LocalizableStringDefinition
            Get
                Return mConditionDescriptionDefinition
            End Get
            Set(ByVal Value As LocalizableStringDefinition)
                mConditionDescriptionDefinition = Value
            End Set
        End Property
        Public Property ConditionIsStatic() As Boolean
            Get
                Return mConditionIsStatic
            End Get
            Set(ByVal Value As Boolean)
                mConditionIsStatic = Value
            End Set
        End Property
        <XmlElement("PrerequisiteFactory")> Public Property PrerequisiteFactoryDefinition() As PredicateFactoryDefinition
            Get
                Return mPrerequisiteFactoryDefinition
            End Get
            Set(ByVal Value As PredicateFactoryDefinition)
                mPrerequisiteFactoryDefinition = Value
            End Set
        End Property
        Public ReadOnly Property InitializationArgs() As ArrayList
            Get
                Return mInitializationArgs
            End Get
        End Property

        Public Function Clone() As Object Implements ICloneable.Clone
            Dim newDef As New ConditionFactoryDefinition
            newDef.ConditionType = ConditionType
            newDef.ConditionInitialValue = ConditionInitialValue
            newDef.ConditionName = ConditionName
            newDef.ConditionDescriptionDefinition = ConditionDescriptionDefinition.DeepCopy
            newDef.ConditionIsStatic = ConditionIsStatic
            newDef.PrerequisiteFactoryDefinition = PrerequisiteFactoryDefinition.DeepCopy
            newDef.InitializationArgs.AddRange(InitializationArgs)
            Return newDef
        End Function

        Public Function DeepCopy() As ConditionFactoryDefinition
            Return DirectCast(Clone(), ConditionFactoryDefinition)
        End Function

        Public Function CreateConditionFactory() As ConditionFactory
            Dim factory As New ConditionFactory
            factory.mDefinition = DeepCopy()
            factory.mPrerequisiteFactory = PrerequisiteFactoryDefinition.CreatePredicateFactory
            factory.mConditionDescription = ConditionDescriptionDefinition.CreateLocalizableString
            Return factory
        End Function

    End Class


End Namespace
