Option Strict On

Imports Mbark.BusinessObjects.EntityClasses

Namespace Mbark.SystemCoordination

    <Serializable()> Public Class SelectedDeploymentChangedEventArgs
        Inherits EventArgs

        Public Sub New(ByVal oldDeployment As DeploymentEntity, ByVal newDeployment As DeploymentEntity)
            mOldDeployment = oldDeployment
            mNewDeployment = newDeployment
        End Sub

        Public ReadOnly Property OldDeployment() As DeploymentEntity
            Get
                Return mOldDeployment
            End Get
        End Property

        Public ReadOnly Property NewDeployment() As DeploymentEntity
            Get
                Return mNewDeployment
            End Get
        End Property

        Private mOldDeployment As DeploymentEntity
        Private mNewDeployment As DeploymentEntity
    End Class

    Public Interface ISelectedDeploymentProvider
        ReadOnly Property SelectedDeployment() As DeploymentEntity
        ReadOnly Property SelectedDeploymentChanged() As IBroadcaster
    End Interface
    Public Interface ISelectedDeploymentChanger
        Sub SelectDeployment(ByVal deployment As DeploymentEntity)
    End Interface

    Public Enum BiographicFormChangeCategory
        StartupRequest
        StartupAcknowledgement
        DataChange
        Done
    End Enum
    <Serializable()> Public Class BiographicFormChangedEventArgs
        Inherits EventArgs

        Private mChange As BiographicFormChangeCategory
        Public ReadOnly Property Change() As BiographicFormChangeCategory
            Get
                Return mChange
            End Get
        End Property

        Private mManagerHostname As String
        Public ReadOnly Property ManagerHostname() As String
            Get
                Return mManagerHostname
            End Get
        End Property

        Private mManagerCategory As ManagerCategory
        Public ReadOnly Property ManagerCategory() As ManagerCategory
            Get
                Return mManagerCategory
            End Get
        End Property

        Private mBiographicData As SubjectBiographicData
        Public Property BiographicData() As SubjectBiographicData
            Get
                Return mBiographicData
            End Get
            Set(ByVal value As SubjectBiographicData)
                mBiographicData = value
            End Set
        End Property

        Public Sub New( _
            ByVal change As BiographicFormChangeCategory, _
            ByVal managerHostname As String, _
            ByVal managerCategory As ManagerCategory, _
            ByVal biographicData As SubjectBiographicData)
            mChange = change
            mManagerHostname = managerHostname
            mManagerCategory = managerCategory
            mBiographicData = biographicData
        End Sub

    End Class

    Public Interface ISystemCoordinator
        Inherits ISelectedDeploymentProvider

        Sub Arrive(ByVal hostname As String, ByVal category As ManagerCategory)
        Sub Depart(ByVal hostname As String, ByVal category As ManagerCategory)

        Sub KeepAlive(ByVal hostname As String, ByVal category As ManagerCategory, ByVal latestState As Integer)

        ReadOnly Property IsAlive(ByVal hostname As String, ByVal category As ManagerCategory) As Boolean

        ReadOnly Property ManagerArrivalOrDeparture() As IBroadcaster
        ReadOnly Property ImportantStateChange() As IBroadcaster
        ReadOnly Property BiographicFormChange() As IBroadcaster

        ReadOnly Property DesignatedTablet(ByVal registrarHostname As String) As String
        ReadOnly Property DesignatedRegistrar(ByVal tabletHostname As String) As String

        Sub DesignateTabletToRegistrar(ByVal tabletHostname As String, ByVal registrarHostname As String)

        ReadOnly Property LatestState(ByVal hostname As String, ByVal category As ManagerCategory) As Integer

    End Interface

    Public Enum ManagerCategory
        None
        Tablet
        Registration
        Session
    End Enum

    <Serializable()> Public Class ManagerArrivalOrDepartureEventArgs
        Inherits EventArgs

        Private mManagerHostname As String
        Private mManagerCategory As ManagerCategory
        Private mArriving As Boolean

        Public ReadOnly Property ManagerHostname() As String
            Get
                Return mManagerHostname
            End Get
        End Property

        Public ReadOnly Property Category() As ManagerCategory
            Get
                Return mManagerCategory
            End Get
        End Property

        Public ReadOnly Property Arriving() As Boolean
            Get
                Return mArriving
            End Get
        End Property

        Public Sub New(ByVal manager As String, ByVal category As ManagerCategory, ByVal arriving As Boolean)
            mManagerHostname = manager
            mManagerCategory = category
            mArriving = arriving
        End Sub
    End Class

    Public Enum TabletManagerState
        NoneOrUnknown
        StartCoordination
        AwaitStartFormRequest
        StartingBiographicForm
        ShowingBiographicForm
        BiographicFormClosing
        FinalizingBiographicForm
    End Enum

    Public Enum RegistrationManagerState
        NoneOrUnknown
        StartCoordination
        AwaitingValidDeployment
        AwaitingDesignatedTablet
        RequestingBiographicFormStart
        AwaitingBiographicFormStartup
        AwaitingBiographicFormChange
        HandlingBiographicFormChange
        HandlingFinalBiographicData
        StartingBiometricForm
        AwaitingBiometricData
        HandlingBiometricData
    End Enum

    Public Enum SubjectSex
        Unspecified
        Male
        Female
    End Enum

    <Serializable()> Public Class SubjectBiographicData

        Private mDateOfBirth As Date
        Private mSex As SubjectSex
        Private mCountryOfOrigin As CountryData
        Private mRepeatVisitor As Boolean
        Private mConsentTime As DateTime

        Public Property ConsentTime() As DateTime
            Get
                Return mConsentTime
            End Get
            Set(ByVal value As DateTime)
                mConsentTime = value
            End Set
        End Property

        Public Property RepeatVisitor() As Boolean
            Get
                Return mRepeatVisitor
            End Get
            Set(ByVal value As Boolean)
                mRepeatVisitor = value
            End Set
        End Property

        Public Property CountryOfOrigin() As CountryData
            Get
                Return mCountryOfOrigin
            End Get
            Set(ByVal value As CountryData)
                mCountryOfOrigin = value
            End Set
        End Property
        Public Property DateOfBirth() As Date
            Get
                Return mDateOfBirth
            End Get
            Set(ByVal value As Date)
                mDateOfBirth = value
            End Set
        End Property
        Public Property Sex() As SubjectSex
            Get
                Return mSex
            End Get
            Set(ByVal value As SubjectSex)
                mSex = value
            End Set
        End Property
        Public Overrides Function ToString() As String
            Return String.Format("{0}, {1}, {2}", mCountryOfOrigin.Name, mDateOfBirth.ToShortDateString, Sex)
        End Function

    End Class


End Namespace